// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --function-signature --check-attributes --check-globals --include-generated-funcs --global-value-regex ".*"
// RUN: %clang_cc1 -triple aarch64-none-linux-gnu -emit-llvm -o - %s | FileCheck %s


// Test that an ifunc is generated and used when the default
// version is defined after the first use of the function.
__attribute__((target_version("aes"))) void used_before_default_def(void) {}
void call_before_def(void) { used_before_default_def(); }
__attribute__((target_version("default"))) void used_before_default_def(void) {}


// Test that an ifunc is generated and used when the default
// version is defined before the first use of the function.
__attribute__((target_version("aes"))) void used_after_default_def(void) {}
__attribute__((target_version("default"))) void used_after_default_def(void) {}
void call_after_def(void) { used_after_default_def(); }


// Test that an unmagled declaration is generated and used when the
// default version is declared after the first use of the function.
__attribute__((target_version("aes"))) void used_before_default_decl(void) {}
void call_before_decl(void) { used_before_default_decl(); }
__attribute__((target_version("default"))) void used_before_default_decl(void);


// Test that an unmagled declaration is generated and used when the
// default version is declared before the first use of the function.
__attribute__((target_version("aes"))) void used_after_default_decl(void) {}
__attribute__((target_version("default"))) void used_after_default_decl(void);
void call_after_decl(void) { used_after_default_decl(); }


// Test that an unmagled declaration is generated and used when
// the default version is not present.
__attribute__((target_version("aes"))) void used_no_default(void) {}
void call_no_default(void) { used_no_default(); }


// Test that neither an ifunc nor a declaration is generated if the default
// definition is missing since the versioned function is not used.
__attribute__((target_version("aes"))) void not_used_no_default(void) {}


// Test that an ifunc is generated if the default version is defined but not used.
__attribute__((target_version("aes"))) void not_used_with_default(void) {}
__attribute__((target_version("default"))) void not_used_with_default(void) {}


// Test that the ifunc symbol can be used for indirect calls.
__attribute__((target_version("aes"))) void indirect_use(void) {}
__attribute__((target_version("default"))) void indirect_use(void) {}
typedef void (*fptr)(void);
void call_indirectly(void) {
  fptr fn = indirect_use;
  fn();
}


// Test that an internal ifunc is generated if the versions are annotated with static inline.
static inline __attribute__((target_version("aes"))) void internal_func(void) {}
static inline __attribute__((target_version("default"))) void internal_func(void) {}
void call_internal(void) { internal_func(); }


// Test that an ifunc is generated with if the versions are annotated with inline.
inline __attribute__((target_version("aes"))) void linkonce_func(void) {}
inline __attribute__((target_version("default"))) void linkonce_func(void) {}
void call_linkonce(void) { linkonce_func(); }


//.
// CHECK: @__aarch64_cpu_features = external dso_local global { i64 }
// CHECK: @used_before_default_def = weak_odr ifunc void (), ptr @used_before_default_def.resolver
// CHECK: @used_after_default_def = weak_odr ifunc void (), ptr @used_after_default_def.resolver
// CHECK: @not_used_with_default = weak_odr ifunc void (), ptr @not_used_with_default.resolver
// CHECK: @indirect_use = weak_odr ifunc void (), ptr @indirect_use.resolver
// CHECK: @internal_func = internal ifunc void (), ptr @internal_func.resolver
// CHECK: @linkonce_func = weak_odr ifunc void (), ptr @linkonce_func.resolver
//.
// CHECK: Function Attrs: noinline nounwind optnone
// CHECK-LABEL: define {{[^@]+}}@used_before_default_def._Maes
// CHECK-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret void
//
//
// CHECK: Function Attrs: noinline nounwind optnone
// CHECK-LABEL: define {{[^@]+}}@call_before_def
// CHECK-SAME: () #[[ATTR1:[0-9]+]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    call void @used_before_default_def()
// CHECK-NEXT:    ret void
//
//
// CHECK: Function Attrs: noinline nounwind optnone
// CHECK-LABEL: define {{[^@]+}}@used_before_default_def.default
// CHECK-SAME: () #[[ATTR2:[0-9]+]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret void
//
//
// CHECK: Function Attrs: noinline nounwind optnone
// CHECK-LABEL: define {{[^@]+}}@used_after_default_def._Maes
// CHECK-SAME: () #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret void
//
//
// CHECK: Function Attrs: noinline nounwind optnone
// CHECK-LABEL: define {{[^@]+}}@used_after_default_def.default
// CHECK-SAME: () #[[ATTR2]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret void
//
//
// CHECK: Function Attrs: noinline nounwind optnone
// CHECK-LABEL: define {{[^@]+}}@call_after_def
// CHECK-SAME: () #[[ATTR1]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    call void @used_after_default_def()
// CHECK-NEXT:    ret void
//
//
// CHECK: Function Attrs: noinline nounwind optnone
// CHECK-LABEL: define {{[^@]+}}@used_before_default_decl._Maes
// CHECK-SAME: () #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret void
//
//
// CHECK: Function Attrs: noinline nounwind optnone
// CHECK-LABEL: define {{[^@]+}}@call_before_decl
// CHECK-SAME: () #[[ATTR1]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    call void @used_before_default_decl()
// CHECK-NEXT:    ret void
//
//
// CHECK: Function Attrs: noinline nounwind optnone
// CHECK-LABEL: define {{[^@]+}}@used_after_default_decl._Maes
// CHECK-SAME: () #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret void
//
//
// CHECK: Function Attrs: noinline nounwind optnone
// CHECK-LABEL: define {{[^@]+}}@call_after_decl
// CHECK-SAME: () #[[ATTR1]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    call void @used_after_default_decl()
// CHECK-NEXT:    ret void
//
//
// CHECK: Function Attrs: noinline nounwind optnone
// CHECK-LABEL: define {{[^@]+}}@used_no_default._Maes
// CHECK-SAME: () #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret void
//
//
// CHECK: Function Attrs: noinline nounwind optnone
// CHECK-LABEL: define {{[^@]+}}@call_no_default
// CHECK-SAME: () #[[ATTR1]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    call void @used_no_default()
// CHECK-NEXT:    ret void
//
//
// CHECK: Function Attrs: noinline nounwind optnone
// CHECK-LABEL: define {{[^@]+}}@not_used_no_default._Maes
// CHECK-SAME: () #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret void
//
//
// CHECK: Function Attrs: noinline nounwind optnone
// CHECK-LABEL: define {{[^@]+}}@not_used_with_default._Maes
// CHECK-SAME: () #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret void
//
//
// CHECK: Function Attrs: noinline nounwind optnone
// CHECK-LABEL: define {{[^@]+}}@not_used_with_default.default
// CHECK-SAME: () #[[ATTR2]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret void
//
//
// CHECK: Function Attrs: noinline nounwind optnone
// CHECK-LABEL: define {{[^@]+}}@indirect_use._Maes
// CHECK-SAME: () #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret void
//
//
// CHECK: Function Attrs: noinline nounwind optnone
// CHECK-LABEL: define {{[^@]+}}@indirect_use.default
// CHECK-SAME: () #[[ATTR2]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret void
//
//
// CHECK: Function Attrs: noinline nounwind optnone
// CHECK-LABEL: define {{[^@]+}}@call_indirectly
// CHECK-SAME: () #[[ATTR1]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[FN:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    store ptr @indirect_use, ptr [[FN]], align 8
// CHECK-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[FN]], align 8
// CHECK-NEXT:    call void [[TMP0]]()
// CHECK-NEXT:    ret void
//
//
// CHECK: Function Attrs: noinline nounwind optnone
// CHECK-LABEL: define {{[^@]+}}@call_internal
// CHECK-SAME: () #[[ATTR1]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    call void @internal_func()
// CHECK-NEXT:    ret void
//
//
// CHECK: Function Attrs: noinline nounwind optnone
// CHECK-LABEL: define {{[^@]+}}@call_linkonce
// CHECK-SAME: () #[[ATTR1]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    call void @linkonce_func()
// CHECK-NEXT:    ret void
//
//
// CHECK-LABEL: define {{[^@]+}}@used_before_default_def.resolver() comdat {
// CHECK-NEXT:  resolver_entry:
// CHECK-NEXT:    call void @__init_cpu_features_resolver()
// CHECK-NEXT:    [[TMP0:%.*]] = load i64, ptr @__aarch64_cpu_features, align 8
// CHECK-NEXT:    [[TMP1:%.*]] = and i64 [[TMP0]], 33536
// CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i64 [[TMP1]], 33536
// CHECK-NEXT:    [[TMP3:%.*]] = and i1 true, [[TMP2]]
// CHECK-NEXT:    br i1 [[TMP3]], label [[RESOLVER_RETURN:%.*]], label [[RESOLVER_ELSE:%.*]]
// CHECK:       resolver_return:
// CHECK-NEXT:    ret ptr @used_before_default_def._Maes
// CHECK:       resolver_else:
// CHECK-NEXT:    ret ptr @used_before_default_def.default
//
//
// CHECK-LABEL: define {{[^@]+}}@used_after_default_def.resolver() comdat {
// CHECK-NEXT:  resolver_entry:
// CHECK-NEXT:    call void @__init_cpu_features_resolver()
// CHECK-NEXT:    [[TMP0:%.*]] = load i64, ptr @__aarch64_cpu_features, align 8
// CHECK-NEXT:    [[TMP1:%.*]] = and i64 [[TMP0]], 33536
// CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i64 [[TMP1]], 33536
// CHECK-NEXT:    [[TMP3:%.*]] = and i1 true, [[TMP2]]
// CHECK-NEXT:    br i1 [[TMP3]], label [[RESOLVER_RETURN:%.*]], label [[RESOLVER_ELSE:%.*]]
// CHECK:       resolver_return:
// CHECK-NEXT:    ret ptr @used_after_default_def._Maes
// CHECK:       resolver_else:
// CHECK-NEXT:    ret ptr @used_after_default_def.default
//
//
// CHECK-LABEL: define {{[^@]+}}@not_used_with_default.resolver() comdat {
// CHECK-NEXT:  resolver_entry:
// CHECK-NEXT:    call void @__init_cpu_features_resolver()
// CHECK-NEXT:    [[TMP0:%.*]] = load i64, ptr @__aarch64_cpu_features, align 8
// CHECK-NEXT:    [[TMP1:%.*]] = and i64 [[TMP0]], 33536
// CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i64 [[TMP1]], 33536
// CHECK-NEXT:    [[TMP3:%.*]] = and i1 true, [[TMP2]]
// CHECK-NEXT:    br i1 [[TMP3]], label [[RESOLVER_RETURN:%.*]], label [[RESOLVER_ELSE:%.*]]
// CHECK:       resolver_return:
// CHECK-NEXT:    ret ptr @not_used_with_default._Maes
// CHECK:       resolver_else:
// CHECK-NEXT:    ret ptr @not_used_with_default.default
//
//
// CHECK-LABEL: define {{[^@]+}}@indirect_use.resolver() comdat {
// CHECK-NEXT:  resolver_entry:
// CHECK-NEXT:    call void @__init_cpu_features_resolver()
// CHECK-NEXT:    [[TMP0:%.*]] = load i64, ptr @__aarch64_cpu_features, align 8
// CHECK-NEXT:    [[TMP1:%.*]] = and i64 [[TMP0]], 33536
// CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i64 [[TMP1]], 33536
// CHECK-NEXT:    [[TMP3:%.*]] = and i1 true, [[TMP2]]
// CHECK-NEXT:    br i1 [[TMP3]], label [[RESOLVER_RETURN:%.*]], label [[RESOLVER_ELSE:%.*]]
// CHECK:       resolver_return:
// CHECK-NEXT:    ret ptr @indirect_use._Maes
// CHECK:       resolver_else:
// CHECK-NEXT:    ret ptr @indirect_use.default
//
//
// CHECK: Function Attrs: noinline nounwind optnone
// CHECK-LABEL: define {{[^@]+}}@internal_func._Maes
// CHECK-SAME: () #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret void
//
//
// CHECK: Function Attrs: noinline nounwind optnone
// CHECK-LABEL: define {{[^@]+}}@internal_func.default
// CHECK-SAME: () #[[ATTR2]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret void
//
//
// CHECK-LABEL: define {{[^@]+}}@internal_func.resolver() {
// CHECK-NEXT:  resolver_entry:
// CHECK-NEXT:    call void @__init_cpu_features_resolver()
// CHECK-NEXT:    [[TMP0:%.*]] = load i64, ptr @__aarch64_cpu_features, align 8
// CHECK-NEXT:    [[TMP1:%.*]] = and i64 [[TMP0]], 33536
// CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i64 [[TMP1]], 33536
// CHECK-NEXT:    [[TMP3:%.*]] = and i1 true, [[TMP2]]
// CHECK-NEXT:    br i1 [[TMP3]], label [[RESOLVER_RETURN:%.*]], label [[RESOLVER_ELSE:%.*]]
// CHECK:       resolver_return:
// CHECK-NEXT:    ret ptr @internal_func._Maes
// CHECK:       resolver_else:
// CHECK-NEXT:    ret ptr @internal_func.default
//
//
// CHECK: Function Attrs: noinline nounwind optnone
// CHECK-LABEL: define {{[^@]+}}@linkonce_func._Maes
// CHECK-SAME: () #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret void
//
//
// CHECK: Function Attrs: noinline nounwind optnone
// CHECK-LABEL: define {{[^@]+}}@linkonce_func.default
// CHECK-SAME: () #[[ATTR2]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret void
//
//
// CHECK-LABEL: define {{[^@]+}}@linkonce_func.resolver() comdat {
// CHECK-NEXT:  resolver_entry:
// CHECK-NEXT:    call void @__init_cpu_features_resolver()
// CHECK-NEXT:    [[TMP0:%.*]] = load i64, ptr @__aarch64_cpu_features, align 8
// CHECK-NEXT:    [[TMP1:%.*]] = and i64 [[TMP0]], 33536
// CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i64 [[TMP1]], 33536
// CHECK-NEXT:    [[TMP3:%.*]] = and i1 true, [[TMP2]]
// CHECK-NEXT:    br i1 [[TMP3]], label [[RESOLVER_RETURN:%.*]], label [[RESOLVER_ELSE:%.*]]
// CHECK:       resolver_return:
// CHECK-NEXT:    ret ptr @linkonce_func._Maes
// CHECK:       resolver_else:
// CHECK-NEXT:    ret ptr @linkonce_func.default
//
//.
// CHECK: [[META0:![0-9]+]] = !{i32 1, !"wchar_size", i32 4}
// CHECK: [[META1:![0-9]+]] = !{!"{{.*}}clang version {{.*}}"}
//.
