// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --version 5
// RUN: %clang_cc1 -triple thumbv8-linux-gnueabihf -target-cpu cortex-a57 \
// RUN:     -ffreestanding -disable-O0-optnone -emit-llvm %s -o - | \
// RUN:     opt -S -passes=mem2reg,sroa | FileCheck -check-prefixes=CHECK,CHECK-A32 %s
// RUN: %clang_cc1 -triple arm64-linux-gnueabihf -target-feature +neon \
// RUN:     -ffreestanding -disable-O0-optnone -emit-llvm %s -o - | \
// RUN:     opt -S -passes=mem2reg,sroa | FileCheck -check-prefixes=CHECK,CHECK-A64 %s

// REQUIRES: aarch64-registered-target || arm-registered-target

#include <arm_neon.h>

// CHECK-A32-LABEL: define dso_local <2 x float> @test_vrnda_f32(
// CHECK-A32-SAME: <2 x float> noundef [[A:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK-A32-NEXT:  [[ENTRY:.*:]]
// CHECK-A32-NEXT:    [[TMP0:%.*]] = bitcast <2 x float> [[A]] to <2 x i32>
// CHECK-A32-NEXT:    [[TMP1:%.*]] = bitcast <2 x i32> [[TMP0]] to <8 x i8>
// CHECK-A32-NEXT:    [[VRNDA_V_I:%.*]] = bitcast <8 x i8> [[TMP1]] to <2 x float>
// CHECK-A32-NEXT:    [[VRNDA_V1_I:%.*]] = call <2 x float> @llvm.arm.neon.vrinta.v2f32(<2 x float> [[VRNDA_V_I]])
// CHECK-A32-NEXT:    [[VRNDA_V2_I:%.*]] = bitcast <2 x float> [[VRNDA_V1_I]] to <8 x i8>
// CHECK-A32-NEXT:    [[TMP2:%.*]] = bitcast <8 x i8> [[VRNDA_V2_I]] to <2 x i32>
// CHECK-A32-NEXT:    [[TMP3:%.*]] = bitcast <2 x i32> [[TMP2]] to <2 x float>
// CHECK-A32-NEXT:    ret <2 x float> [[TMP3]]
//
// CHECK-A64-LABEL: define dso_local <2 x float> @test_vrnda_f32(
// CHECK-A64-SAME: <2 x float> noundef [[A:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK-A64-NEXT:  [[ENTRY:.*:]]
// CHECK-A64-NEXT:    [[TMP0:%.*]] = bitcast <2 x float> [[A]] to <2 x i32>
// CHECK-A64-NEXT:    [[TMP1:%.*]] = bitcast <2 x i32> [[TMP0]] to <8 x i8>
// CHECK-A64-NEXT:    [[VRNDA_I:%.*]] = bitcast <8 x i8> [[TMP1]] to <2 x float>
// CHECK-A64-NEXT:    [[VRNDA1_I:%.*]] = call <2 x float> @llvm.round.v2f32(<2 x float> [[VRNDA_I]])
// CHECK-A64-NEXT:    ret <2 x float> [[VRNDA1_I]]
//
float32x2_t test_vrnda_f32(float32x2_t a) {
  return vrnda_f32(a);
}

// CHECK-A32-LABEL: define dso_local <4 x float> @test_vrndaq_f32(
// CHECK-A32-SAME: <4 x float> noundef [[A:%.*]]) #[[ATTR0]] {
// CHECK-A32-NEXT:  [[ENTRY:.*:]]
// CHECK-A32-NEXT:    [[TMP0:%.*]] = bitcast <4 x float> [[A]] to <4 x i32>
// CHECK-A32-NEXT:    [[TMP1:%.*]] = bitcast <4 x i32> [[TMP0]] to <16 x i8>
// CHECK-A32-NEXT:    [[VRNDAQ_V_I:%.*]] = bitcast <16 x i8> [[TMP1]] to <4 x float>
// CHECK-A32-NEXT:    [[VRNDAQ_V1_I:%.*]] = call <4 x float> @llvm.arm.neon.vrinta.v4f32(<4 x float> [[VRNDAQ_V_I]])
// CHECK-A32-NEXT:    [[VRNDAQ_V2_I:%.*]] = bitcast <4 x float> [[VRNDAQ_V1_I]] to <16 x i8>
// CHECK-A32-NEXT:    [[TMP2:%.*]] = bitcast <16 x i8> [[VRNDAQ_V2_I]] to <4 x i32>
// CHECK-A32-NEXT:    [[TMP3:%.*]] = bitcast <4 x i32> [[TMP2]] to <4 x float>
// CHECK-A32-NEXT:    ret <4 x float> [[TMP3]]
//
// CHECK-A64-LABEL: define dso_local <4 x float> @test_vrndaq_f32(
// CHECK-A64-SAME: <4 x float> noundef [[A:%.*]]) #[[ATTR0]] {
// CHECK-A64-NEXT:  [[ENTRY:.*:]]
// CHECK-A64-NEXT:    [[TMP0:%.*]] = bitcast <4 x float> [[A]] to <4 x i32>
// CHECK-A64-NEXT:    [[TMP1:%.*]] = bitcast <4 x i32> [[TMP0]] to <16 x i8>
// CHECK-A64-NEXT:    [[VRNDA_I:%.*]] = bitcast <16 x i8> [[TMP1]] to <4 x float>
// CHECK-A64-NEXT:    [[VRNDA1_I:%.*]] = call <4 x float> @llvm.round.v4f32(<4 x float> [[VRNDA_I]])
// CHECK-A64-NEXT:    ret <4 x float> [[VRNDA1_I]]
//
float32x4_t test_vrndaq_f32(float32x4_t a) {
  return vrndaq_f32(a);
}

// CHECK-A32-LABEL: define dso_local <2 x float> @test_vrndm_f32(
// CHECK-A32-SAME: <2 x float> noundef [[A:%.*]]) #[[ATTR0]] {
// CHECK-A32-NEXT:  [[ENTRY:.*:]]
// CHECK-A32-NEXT:    [[TMP0:%.*]] = bitcast <2 x float> [[A]] to <2 x i32>
// CHECK-A32-NEXT:    [[TMP1:%.*]] = bitcast <2 x i32> [[TMP0]] to <8 x i8>
// CHECK-A32-NEXT:    [[VRNDM_V_I:%.*]] = bitcast <8 x i8> [[TMP1]] to <2 x float>
// CHECK-A32-NEXT:    [[VRNDM_V1_I:%.*]] = call <2 x float> @llvm.arm.neon.vrintm.v2f32(<2 x float> [[VRNDM_V_I]])
// CHECK-A32-NEXT:    [[VRNDM_V2_I:%.*]] = bitcast <2 x float> [[VRNDM_V1_I]] to <8 x i8>
// CHECK-A32-NEXT:    [[TMP2:%.*]] = bitcast <8 x i8> [[VRNDM_V2_I]] to <2 x i32>
// CHECK-A32-NEXT:    [[TMP3:%.*]] = bitcast <2 x i32> [[TMP2]] to <2 x float>
// CHECK-A32-NEXT:    ret <2 x float> [[TMP3]]
//
// CHECK-A64-LABEL: define dso_local <2 x float> @test_vrndm_f32(
// CHECK-A64-SAME: <2 x float> noundef [[A:%.*]]) #[[ATTR0]] {
// CHECK-A64-NEXT:  [[ENTRY:.*:]]
// CHECK-A64-NEXT:    [[TMP0:%.*]] = bitcast <2 x float> [[A]] to <2 x i32>
// CHECK-A64-NEXT:    [[TMP1:%.*]] = bitcast <2 x i32> [[TMP0]] to <8 x i8>
// CHECK-A64-NEXT:    [[VRNDM_I:%.*]] = bitcast <8 x i8> [[TMP1]] to <2 x float>
// CHECK-A64-NEXT:    [[VRNDM1_I:%.*]] = call <2 x float> @llvm.floor.v2f32(<2 x float> [[VRNDM_I]])
// CHECK-A64-NEXT:    ret <2 x float> [[VRNDM1_I]]
//
float32x2_t test_vrndm_f32(float32x2_t a) {
  return vrndm_f32(a);
}

// CHECK-A32-LABEL: define dso_local <4 x float> @test_vrndmq_f32(
// CHECK-A32-SAME: <4 x float> noundef [[A:%.*]]) #[[ATTR0]] {
// CHECK-A32-NEXT:  [[ENTRY:.*:]]
// CHECK-A32-NEXT:    [[TMP0:%.*]] = bitcast <4 x float> [[A]] to <4 x i32>
// CHECK-A32-NEXT:    [[TMP1:%.*]] = bitcast <4 x i32> [[TMP0]] to <16 x i8>
// CHECK-A32-NEXT:    [[VRNDMQ_V_I:%.*]] = bitcast <16 x i8> [[TMP1]] to <4 x float>
// CHECK-A32-NEXT:    [[VRNDMQ_V1_I:%.*]] = call <4 x float> @llvm.arm.neon.vrintm.v4f32(<4 x float> [[VRNDMQ_V_I]])
// CHECK-A32-NEXT:    [[VRNDMQ_V2_I:%.*]] = bitcast <4 x float> [[VRNDMQ_V1_I]] to <16 x i8>
// CHECK-A32-NEXT:    [[TMP2:%.*]] = bitcast <16 x i8> [[VRNDMQ_V2_I]] to <4 x i32>
// CHECK-A32-NEXT:    [[TMP3:%.*]] = bitcast <4 x i32> [[TMP2]] to <4 x float>
// CHECK-A32-NEXT:    ret <4 x float> [[TMP3]]
//
// CHECK-A64-LABEL: define dso_local <4 x float> @test_vrndmq_f32(
// CHECK-A64-SAME: <4 x float> noundef [[A:%.*]]) #[[ATTR0]] {
// CHECK-A64-NEXT:  [[ENTRY:.*:]]
// CHECK-A64-NEXT:    [[TMP0:%.*]] = bitcast <4 x float> [[A]] to <4 x i32>
// CHECK-A64-NEXT:    [[TMP1:%.*]] = bitcast <4 x i32> [[TMP0]] to <16 x i8>
// CHECK-A64-NEXT:    [[VRNDM_I:%.*]] = bitcast <16 x i8> [[TMP1]] to <4 x float>
// CHECK-A64-NEXT:    [[VRNDM1_I:%.*]] = call <4 x float> @llvm.floor.v4f32(<4 x float> [[VRNDM_I]])
// CHECK-A64-NEXT:    ret <4 x float> [[VRNDM1_I]]
//
float32x4_t test_vrndmq_f32(float32x4_t a) {
  return vrndmq_f32(a);
}

// CHECK-A32-LABEL: define dso_local <2 x float> @test_vrndn_f32(
// CHECK-A32-SAME: <2 x float> noundef [[A:%.*]]) #[[ATTR0]] {
// CHECK-A32-NEXT:  [[ENTRY:.*:]]
// CHECK-A32-NEXT:    [[TMP0:%.*]] = bitcast <2 x float> [[A]] to <2 x i32>
// CHECK-A32-NEXT:    [[TMP1:%.*]] = bitcast <2 x i32> [[TMP0]] to <8 x i8>
// CHECK-A32-NEXT:    [[VRNDN_V_I:%.*]] = bitcast <8 x i8> [[TMP1]] to <2 x float>
// CHECK-A32-NEXT:    [[VRNDN_V1_I:%.*]] = call <2 x float> @llvm.arm.neon.vrintn.v2f32(<2 x float> [[VRNDN_V_I]])
// CHECK-A32-NEXT:    [[VRNDN_V2_I:%.*]] = bitcast <2 x float> [[VRNDN_V1_I]] to <8 x i8>
// CHECK-A32-NEXT:    [[TMP2:%.*]] = bitcast <8 x i8> [[VRNDN_V2_I]] to <2 x i32>
// CHECK-A32-NEXT:    [[TMP3:%.*]] = bitcast <2 x i32> [[TMP2]] to <2 x float>
// CHECK-A32-NEXT:    ret <2 x float> [[TMP3]]
//
// CHECK-A64-LABEL: define dso_local <2 x float> @test_vrndn_f32(
// CHECK-A64-SAME: <2 x float> noundef [[A:%.*]]) #[[ATTR0]] {
// CHECK-A64-NEXT:  [[ENTRY:.*:]]
// CHECK-A64-NEXT:    [[TMP0:%.*]] = bitcast <2 x float> [[A]] to <2 x i32>
// CHECK-A64-NEXT:    [[TMP1:%.*]] = bitcast <2 x i32> [[TMP0]] to <8 x i8>
// CHECK-A64-NEXT:    [[VRNDN_I:%.*]] = bitcast <8 x i8> [[TMP1]] to <2 x float>
// CHECK-A64-NEXT:    [[VRNDN1_I:%.*]] = call <2 x float> @llvm.roundeven.v2f32(<2 x float> [[VRNDN_I]])
// CHECK-A64-NEXT:    ret <2 x float> [[VRNDN1_I]]
//
float32x2_t test_vrndn_f32(float32x2_t a) {
  return vrndn_f32(a);
}

// CHECK-A32-LABEL: define dso_local <4 x float> @test_vrndnq_f32(
// CHECK-A32-SAME: <4 x float> noundef [[A:%.*]]) #[[ATTR0]] {
// CHECK-A32-NEXT:  [[ENTRY:.*:]]
// CHECK-A32-NEXT:    [[TMP0:%.*]] = bitcast <4 x float> [[A]] to <4 x i32>
// CHECK-A32-NEXT:    [[TMP1:%.*]] = bitcast <4 x i32> [[TMP0]] to <16 x i8>
// CHECK-A32-NEXT:    [[VRNDNQ_V_I:%.*]] = bitcast <16 x i8> [[TMP1]] to <4 x float>
// CHECK-A32-NEXT:    [[VRNDNQ_V1_I:%.*]] = call <4 x float> @llvm.arm.neon.vrintn.v4f32(<4 x float> [[VRNDNQ_V_I]])
// CHECK-A32-NEXT:    [[VRNDNQ_V2_I:%.*]] = bitcast <4 x float> [[VRNDNQ_V1_I]] to <16 x i8>
// CHECK-A32-NEXT:    [[TMP2:%.*]] = bitcast <16 x i8> [[VRNDNQ_V2_I]] to <4 x i32>
// CHECK-A32-NEXT:    [[TMP3:%.*]] = bitcast <4 x i32> [[TMP2]] to <4 x float>
// CHECK-A32-NEXT:    ret <4 x float> [[TMP3]]
//
// CHECK-A64-LABEL: define dso_local <4 x float> @test_vrndnq_f32(
// CHECK-A64-SAME: <4 x float> noundef [[A:%.*]]) #[[ATTR0]] {
// CHECK-A64-NEXT:  [[ENTRY:.*:]]
// CHECK-A64-NEXT:    [[TMP0:%.*]] = bitcast <4 x float> [[A]] to <4 x i32>
// CHECK-A64-NEXT:    [[TMP1:%.*]] = bitcast <4 x i32> [[TMP0]] to <16 x i8>
// CHECK-A64-NEXT:    [[VRNDN_I:%.*]] = bitcast <16 x i8> [[TMP1]] to <4 x float>
// CHECK-A64-NEXT:    [[VRNDN1_I:%.*]] = call <4 x float> @llvm.roundeven.v4f32(<4 x float> [[VRNDN_I]])
// CHECK-A64-NEXT:    ret <4 x float> [[VRNDN1_I]]
//
float32x4_t test_vrndnq_f32(float32x4_t a) {
  return vrndnq_f32(a);
}

// CHECK-A32-LABEL: define dso_local <2 x float> @test_vrndp_f32(
// CHECK-A32-SAME: <2 x float> noundef [[A:%.*]]) #[[ATTR0]] {
// CHECK-A32-NEXT:  [[ENTRY:.*:]]
// CHECK-A32-NEXT:    [[TMP0:%.*]] = bitcast <2 x float> [[A]] to <2 x i32>
// CHECK-A32-NEXT:    [[TMP1:%.*]] = bitcast <2 x i32> [[TMP0]] to <8 x i8>
// CHECK-A32-NEXT:    [[VRNDP_V_I:%.*]] = bitcast <8 x i8> [[TMP1]] to <2 x float>
// CHECK-A32-NEXT:    [[VRNDP_V1_I:%.*]] = call <2 x float> @llvm.arm.neon.vrintp.v2f32(<2 x float> [[VRNDP_V_I]])
// CHECK-A32-NEXT:    [[VRNDP_V2_I:%.*]] = bitcast <2 x float> [[VRNDP_V1_I]] to <8 x i8>
// CHECK-A32-NEXT:    [[TMP2:%.*]] = bitcast <8 x i8> [[VRNDP_V2_I]] to <2 x i32>
// CHECK-A32-NEXT:    [[TMP3:%.*]] = bitcast <2 x i32> [[TMP2]] to <2 x float>
// CHECK-A32-NEXT:    ret <2 x float> [[TMP3]]
//
// CHECK-A64-LABEL: define dso_local <2 x float> @test_vrndp_f32(
// CHECK-A64-SAME: <2 x float> noundef [[A:%.*]]) #[[ATTR0]] {
// CHECK-A64-NEXT:  [[ENTRY:.*:]]
// CHECK-A64-NEXT:    [[TMP0:%.*]] = bitcast <2 x float> [[A]] to <2 x i32>
// CHECK-A64-NEXT:    [[TMP1:%.*]] = bitcast <2 x i32> [[TMP0]] to <8 x i8>
// CHECK-A64-NEXT:    [[VRNDP_I:%.*]] = bitcast <8 x i8> [[TMP1]] to <2 x float>
// CHECK-A64-NEXT:    [[VRNDP1_I:%.*]] = call <2 x float> @llvm.ceil.v2f32(<2 x float> [[VRNDP_I]])
// CHECK-A64-NEXT:    ret <2 x float> [[VRNDP1_I]]
//
float32x2_t test_vrndp_f32(float32x2_t a) {
  return vrndp_f32(a);
}

// CHECK-A32-LABEL: define dso_local <4 x float> @test_vrndpq_f32(
// CHECK-A32-SAME: <4 x float> noundef [[A:%.*]]) #[[ATTR0]] {
// CHECK-A32-NEXT:  [[ENTRY:.*:]]
// CHECK-A32-NEXT:    [[TMP0:%.*]] = bitcast <4 x float> [[A]] to <4 x i32>
// CHECK-A32-NEXT:    [[TMP1:%.*]] = bitcast <4 x i32> [[TMP0]] to <16 x i8>
// CHECK-A32-NEXT:    [[VRNDPQ_V_I:%.*]] = bitcast <16 x i8> [[TMP1]] to <4 x float>
// CHECK-A32-NEXT:    [[VRNDPQ_V1_I:%.*]] = call <4 x float> @llvm.arm.neon.vrintp.v4f32(<4 x float> [[VRNDPQ_V_I]])
// CHECK-A32-NEXT:    [[VRNDPQ_V2_I:%.*]] = bitcast <4 x float> [[VRNDPQ_V1_I]] to <16 x i8>
// CHECK-A32-NEXT:    [[TMP2:%.*]] = bitcast <16 x i8> [[VRNDPQ_V2_I]] to <4 x i32>
// CHECK-A32-NEXT:    [[TMP3:%.*]] = bitcast <4 x i32> [[TMP2]] to <4 x float>
// CHECK-A32-NEXT:    ret <4 x float> [[TMP3]]
//
// CHECK-A64-LABEL: define dso_local <4 x float> @test_vrndpq_f32(
// CHECK-A64-SAME: <4 x float> noundef [[A:%.*]]) #[[ATTR0]] {
// CHECK-A64-NEXT:  [[ENTRY:.*:]]
// CHECK-A64-NEXT:    [[TMP0:%.*]] = bitcast <4 x float> [[A]] to <4 x i32>
// CHECK-A64-NEXT:    [[TMP1:%.*]] = bitcast <4 x i32> [[TMP0]] to <16 x i8>
// CHECK-A64-NEXT:    [[VRNDP_I:%.*]] = bitcast <16 x i8> [[TMP1]] to <4 x float>
// CHECK-A64-NEXT:    [[VRNDP1_I:%.*]] = call <4 x float> @llvm.ceil.v4f32(<4 x float> [[VRNDP_I]])
// CHECK-A64-NEXT:    ret <4 x float> [[VRNDP1_I]]
//
float32x4_t test_vrndpq_f32(float32x4_t a) {
  return vrndpq_f32(a);
}

// CHECK-A32-LABEL: define dso_local <2 x float> @test_vrndx_f32(
// CHECK-A32-SAME: <2 x float> noundef [[A:%.*]]) #[[ATTR0]] {
// CHECK-A32-NEXT:  [[ENTRY:.*:]]
// CHECK-A32-NEXT:    [[TMP0:%.*]] = bitcast <2 x float> [[A]] to <2 x i32>
// CHECK-A32-NEXT:    [[TMP1:%.*]] = bitcast <2 x i32> [[TMP0]] to <8 x i8>
// CHECK-A32-NEXT:    [[VRNDX_V_I:%.*]] = bitcast <8 x i8> [[TMP1]] to <2 x float>
// CHECK-A32-NEXT:    [[VRNDX_V1_I:%.*]] = call <2 x float> @llvm.arm.neon.vrintx.v2f32(<2 x float> [[VRNDX_V_I]])
// CHECK-A32-NEXT:    [[VRNDX_V2_I:%.*]] = bitcast <2 x float> [[VRNDX_V1_I]] to <8 x i8>
// CHECK-A32-NEXT:    [[TMP2:%.*]] = bitcast <8 x i8> [[VRNDX_V2_I]] to <2 x i32>
// CHECK-A32-NEXT:    [[TMP3:%.*]] = bitcast <2 x i32> [[TMP2]] to <2 x float>
// CHECK-A32-NEXT:    ret <2 x float> [[TMP3]]
//
// CHECK-A64-LABEL: define dso_local <2 x float> @test_vrndx_f32(
// CHECK-A64-SAME: <2 x float> noundef [[A:%.*]]) #[[ATTR0]] {
// CHECK-A64-NEXT:  [[ENTRY:.*:]]
// CHECK-A64-NEXT:    [[TMP0:%.*]] = bitcast <2 x float> [[A]] to <2 x i32>
// CHECK-A64-NEXT:    [[TMP1:%.*]] = bitcast <2 x i32> [[TMP0]] to <8 x i8>
// CHECK-A64-NEXT:    [[VRNDX_I:%.*]] = bitcast <8 x i8> [[TMP1]] to <2 x float>
// CHECK-A64-NEXT:    [[VRNDX1_I:%.*]] = call <2 x float> @llvm.rint.v2f32(<2 x float> [[VRNDX_I]])
// CHECK-A64-NEXT:    ret <2 x float> [[VRNDX1_I]]
//
float32x2_t test_vrndx_f32(float32x2_t a) {
  return vrndx_f32(a);
}

// CHECK-A32-LABEL: define dso_local <4 x float> @test_vrndxq_f32(
// CHECK-A32-SAME: <4 x float> noundef [[A:%.*]]) #[[ATTR0]] {
// CHECK-A32-NEXT:  [[ENTRY:.*:]]
// CHECK-A32-NEXT:    [[TMP0:%.*]] = bitcast <4 x float> [[A]] to <4 x i32>
// CHECK-A32-NEXT:    [[TMP1:%.*]] = bitcast <4 x i32> [[TMP0]] to <16 x i8>
// CHECK-A32-NEXT:    [[VRNDXQ_V_I:%.*]] = bitcast <16 x i8> [[TMP1]] to <4 x float>
// CHECK-A32-NEXT:    [[VRNDXQ_V1_I:%.*]] = call <4 x float> @llvm.arm.neon.vrintx.v4f32(<4 x float> [[VRNDXQ_V_I]])
// CHECK-A32-NEXT:    [[VRNDXQ_V2_I:%.*]] = bitcast <4 x float> [[VRNDXQ_V1_I]] to <16 x i8>
// CHECK-A32-NEXT:    [[TMP2:%.*]] = bitcast <16 x i8> [[VRNDXQ_V2_I]] to <4 x i32>
// CHECK-A32-NEXT:    [[TMP3:%.*]] = bitcast <4 x i32> [[TMP2]] to <4 x float>
// CHECK-A32-NEXT:    ret <4 x float> [[TMP3]]
//
// CHECK-A64-LABEL: define dso_local <4 x float> @test_vrndxq_f32(
// CHECK-A64-SAME: <4 x float> noundef [[A:%.*]]) #[[ATTR0]] {
// CHECK-A64-NEXT:  [[ENTRY:.*:]]
// CHECK-A64-NEXT:    [[TMP0:%.*]] = bitcast <4 x float> [[A]] to <4 x i32>
// CHECK-A64-NEXT:    [[TMP1:%.*]] = bitcast <4 x i32> [[TMP0]] to <16 x i8>
// CHECK-A64-NEXT:    [[VRNDX_I:%.*]] = bitcast <16 x i8> [[TMP1]] to <4 x float>
// CHECK-A64-NEXT:    [[VRNDX1_I:%.*]] = call <4 x float> @llvm.rint.v4f32(<4 x float> [[VRNDX_I]])
// CHECK-A64-NEXT:    ret <4 x float> [[VRNDX1_I]]
//
float32x4_t test_vrndxq_f32(float32x4_t a) {
  return vrndxq_f32(a);
}

// CHECK-A32-LABEL: define dso_local <2 x float> @test_vrnd_f32(
// CHECK-A32-SAME: <2 x float> noundef [[A:%.*]]) #[[ATTR0]] {
// CHECK-A32-NEXT:  [[ENTRY:.*:]]
// CHECK-A32-NEXT:    [[TMP0:%.*]] = bitcast <2 x float> [[A]] to <2 x i32>
// CHECK-A32-NEXT:    [[TMP1:%.*]] = bitcast <2 x i32> [[TMP0]] to <8 x i8>
// CHECK-A32-NEXT:    [[VRND_V_I:%.*]] = bitcast <8 x i8> [[TMP1]] to <2 x float>
// CHECK-A32-NEXT:    [[VRND_V1_I:%.*]] = call <2 x float> @llvm.arm.neon.vrintz.v2f32(<2 x float> [[VRND_V_I]])
// CHECK-A32-NEXT:    [[VRND_V2_I:%.*]] = bitcast <2 x float> [[VRND_V1_I]] to <8 x i8>
// CHECK-A32-NEXT:    [[TMP2:%.*]] = bitcast <8 x i8> [[VRND_V2_I]] to <2 x i32>
// CHECK-A32-NEXT:    [[TMP3:%.*]] = bitcast <2 x i32> [[TMP2]] to <2 x float>
// CHECK-A32-NEXT:    ret <2 x float> [[TMP3]]
//
// CHECK-A64-LABEL: define dso_local <2 x float> @test_vrnd_f32(
// CHECK-A64-SAME: <2 x float> noundef [[A:%.*]]) #[[ATTR0]] {
// CHECK-A64-NEXT:  [[ENTRY:.*:]]
// CHECK-A64-NEXT:    [[TMP0:%.*]] = bitcast <2 x float> [[A]] to <2 x i32>
// CHECK-A64-NEXT:    [[TMP1:%.*]] = bitcast <2 x i32> [[TMP0]] to <8 x i8>
// CHECK-A64-NEXT:    [[VRNDZ_I:%.*]] = bitcast <8 x i8> [[TMP1]] to <2 x float>
// CHECK-A64-NEXT:    [[VRNDZ1_I:%.*]] = call <2 x float> @llvm.trunc.v2f32(<2 x float> [[VRNDZ_I]])
// CHECK-A64-NEXT:    ret <2 x float> [[VRNDZ1_I]]
//
float32x2_t test_vrnd_f32(float32x2_t a) {
  return vrnd_f32(a);
}

// CHECK-A32-LABEL: define dso_local <4 x float> @test_vrndq_f32(
// CHECK-A32-SAME: <4 x float> noundef [[A:%.*]]) #[[ATTR0]] {
// CHECK-A32-NEXT:  [[ENTRY:.*:]]
// CHECK-A32-NEXT:    [[TMP0:%.*]] = bitcast <4 x float> [[A]] to <4 x i32>
// CHECK-A32-NEXT:    [[TMP1:%.*]] = bitcast <4 x i32> [[TMP0]] to <16 x i8>
// CHECK-A32-NEXT:    [[VRNDQ_V_I:%.*]] = bitcast <16 x i8> [[TMP1]] to <4 x float>
// CHECK-A32-NEXT:    [[VRNDQ_V1_I:%.*]] = call <4 x float> @llvm.arm.neon.vrintz.v4f32(<4 x float> [[VRNDQ_V_I]])
// CHECK-A32-NEXT:    [[VRNDQ_V2_I:%.*]] = bitcast <4 x float> [[VRNDQ_V1_I]] to <16 x i8>
// CHECK-A32-NEXT:    [[TMP2:%.*]] = bitcast <16 x i8> [[VRNDQ_V2_I]] to <4 x i32>
// CHECK-A32-NEXT:    [[TMP3:%.*]] = bitcast <4 x i32> [[TMP2]] to <4 x float>
// CHECK-A32-NEXT:    ret <4 x float> [[TMP3]]
//
// CHECK-A64-LABEL: define dso_local <4 x float> @test_vrndq_f32(
// CHECK-A64-SAME: <4 x float> noundef [[A:%.*]]) #[[ATTR0]] {
// CHECK-A64-NEXT:  [[ENTRY:.*:]]
// CHECK-A64-NEXT:    [[TMP0:%.*]] = bitcast <4 x float> [[A]] to <4 x i32>
// CHECK-A64-NEXT:    [[TMP1:%.*]] = bitcast <4 x i32> [[TMP0]] to <16 x i8>
// CHECK-A64-NEXT:    [[VRNDZ_I:%.*]] = bitcast <16 x i8> [[TMP1]] to <4 x float>
// CHECK-A64-NEXT:    [[VRNDZ1_I:%.*]] = call <4 x float> @llvm.trunc.v4f32(<4 x float> [[VRNDZ_I]])
// CHECK-A64-NEXT:    ret <4 x float> [[VRNDZ1_I]]
//
float32x4_t test_vrndq_f32(float32x4_t a) {
  return vrndq_f32(a);
}

// CHECK-A32-LABEL: define dso_local float @test_vrndns_f32(
// CHECK-A32-SAME: float noundef [[A:%.*]]) #[[ATTR0]] {
// CHECK-A32-NEXT:  [[ENTRY:.*:]]
// CHECK-A32-NEXT:    [[VRNDN_I:%.*]] = call float @llvm.arm.neon.vrintn.f32(float [[A]])
// CHECK-A32-NEXT:    ret float [[VRNDN_I]]
//
// CHECK-A64-LABEL: define dso_local float @test_vrndns_f32(
// CHECK-A64-SAME: float noundef [[A:%.*]]) #[[ATTR0]] {
// CHECK-A64-NEXT:  [[ENTRY:.*:]]
// CHECK-A64-NEXT:    [[VRNDN_I:%.*]] = call float @llvm.roundeven.f32(float [[A]])
// CHECK-A64-NEXT:    ret float [[VRNDN_I]]
//
float32_t test_vrndns_f32(float32_t a) {
  return vrndns_f32(a);
}

// CHECK-LABEL: define dso_local <2 x float> @test_vrndi_f32(
// CHECK-SAME: <2 x float> noundef [[A:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <2 x float> [[A]] to <2 x i32>
// CHECK-NEXT:    [[TMP1:%.*]] = bitcast <2 x i32> [[TMP0]] to <8 x i8>
// CHECK-NEXT:    [[VRNDI_V_I:%.*]] = bitcast <8 x i8> [[TMP1]] to <2 x float>
// CHECK-NEXT:    [[VRNDI_V1_I:%.*]] = call <2 x float> @llvm.nearbyint.v2f32(<2 x float> [[VRNDI_V_I]])
// CHECK-NEXT:    ret <2 x float> [[VRNDI_V1_I]]
//
float32x2_t test_vrndi_f32(float32x2_t a) {
  return vrndi_f32(a);
}

// CHECK-LABEL: define dso_local <4 x float> @test_vrndiq_f32(
// CHECK-SAME: <4 x float> noundef [[A:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <4 x float> [[A]] to <4 x i32>
// CHECK-NEXT:    [[TMP1:%.*]] = bitcast <4 x i32> [[TMP0]] to <16 x i8>
// CHECK-NEXT:    [[VRNDIQ_V_I:%.*]] = bitcast <16 x i8> [[TMP1]] to <4 x float>
// CHECK-NEXT:    [[VRNDIQ_V1_I:%.*]] = call <4 x float> @llvm.nearbyint.v4f32(<4 x float> [[VRNDIQ_V_I]])
// CHECK-NEXT:    ret <4 x float> [[VRNDIQ_V1_I]]
//
float32x4_t test_vrndiq_f32(float32x4_t a) {
  return vrndiq_f32(a);
}
