---
stage: Create
group: Code Review
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://about.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

<!--
This documentation is auto generated by a script.
Please do not edit this file directly. Run `make gen-docs` instead.
-->

# `glab variable set`

Create a new variable for a project or group.

```plaintext
glab variable set <key> <value> [flags]
```

## Aliases

```plaintext
new
create
```

## Examples

```console
$ glab variable set WITH_ARG "some value"
$ glab variable set WITH_DESC "some value" --description "some description"
$ glab variable set FROM_FLAG -v "some value"
$ glab variable set FROM_ENV_WITH_ARG "${ENV_VAR}"
$ glab variable set FROM_ENV_WITH_FLAG -v"${ENV_VAR}"
$ glab variable set FROM_FILE < secret.txt
$ cat file.txt | glab variable set SERVER_TOKEN
$ cat token.txt | glab variable set GROUP_TOKEN -g mygroup --scope=prod

```

## Options

```plaintext
  -d, --description string   Set description of a variable.
  -g, --group string         Set variable for a group.
  -m, --masked               Whether the variable is masked.
  -p, --protected            Whether the variable is protected.
  -r, --raw                  Whether the variable is treated as a raw string.
  -s, --scope string         The environment_scope of the variable. Values: all (*), or specific environments. (default "*")
  -t, --type string          The type of a variable: env_var, file. (default "env_var")
  -v, --value string         The value of a variable.
```

## Options inherited from parent commands

```plaintext
      --help              Show help for this command.
  -R, --repo OWNER/REPO   Select another repository. Can use either OWNER/REPO or `GROUP/NAMESPACE/REPO` format. Also accepts full URL or Git URL.
```
