---
stage: Create
group: Code Review
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://about.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

<!--
This documentation is auto generated by a script.
Please do not edit this file directly. Run `make gen-docs` instead.
-->

# `glab cluster graph`

Query Kubernetes object graph using GitLab Agent for Kubernetes. (EXPERIMENTAL)

## Synopsis

This commands starts a web server that shows a live view of Kubernetes objects graph in a browser.
It works via the GitLab Agent for Kubernetes running in the cluster.
The minimum required GitLab and GitLab Agent version is v18.1.

Please leave feedback in [this issue](https://gitlab.com/gitlab-org/cli/-/issues/7900).

### Resource filtering

Resources and namespaces can be filterer using [CEL expressions](https://cel.dev/).

`object_selector_expression` can be used to filter objects. The expression must return a boolean. The following variables are available:

- `obj` is the Kubernetes object being evaluated.
- `group` group of the object.
- `version` version of the object.
- `resource` resource name of the object. E.g. pods for the Pod kind.
- `namespace` namespace of the object.
- `name` name of the object.
- `labels` labels of the object.
- `annotations` annotations of the object.

`resource_selector_expression` can be used to filter Kubernetes discovery information to include/exclude resources
from the watch request. The expression must return a boolean. The following variables are available:

- `group` group of the object.
- `version` version of the object.
- `resource` resource name of the object. E.g. pods for the Pod kind.
- `namespaced` scope of group+version+resource. Can be `bool` `true` or `false`.

### Advanced usage

Apart from high level ways to construct the query, this command allows you to construct and send
the query using all the underlying API capabilities.
Please see the
[technical design doc](https://gitlab.com/gitlab-org/cluster-integration/gitlab-agent/-/blob/master/doc/graph_api.md)
to understand what is possible and how to do it.

This command only supports personal and project access tokens for authentication.
The token should have at least the `Developer` role in the agent project and the `read_api` and `k8s_proxy` scopes.

This feature is experimental. It might be broken or removed without any prior notice.
Read more about what experimental features mean at
<https://docs.gitlab.com/policy/development_stages_support/>

Use experimental features at your own risk.

```plaintext
glab cluster graph [flags]
```

## Examples

```console
# Run the default query for agent 123
$ glab cluster graph -R user/project -a 123

# Show common resources from the core and RBAC groups
$ glab cluster graph -R user/project -a 123 --core --rbac

# Show certain resources
$ glab cluster graph -R user/project -a 123 --resources=pods --resources=configmaps

# Same as above, but more compact
$ glab cluster graph -R user/project -a 123 -r={pods,configmaps}

# Select a certain namespace
$ glab cluster graph -R user/project -a 123 -n={my-ns,my-stuff}

# Select all namespaces that have a certain annotation
$ glab cluster graph -R user/project -a 123 --ns-expression='"my-annotation" in annotations'

# Advanced usage - pass the full query directly via stdin.
# The query below watches serviceaccounts in all namespaces except for the kube-system.
$ Q='{"queries":[{"include":{"resource_selector_expression":"resource == \"serviceaccounts\""}}],"namespaces":{"object_selector_expression":"name != \"kube-system\""}}'

$ echo -n "$Q" | glab cluster graph -R user/project -a 123 --stdin

```

## Options

```plaintext
  -a, --agent int                  The numerical Agent ID to connect to.
      --apps                       Watch deployments, replicasets, daemonsets, and statefulsets in apps/v1 group.
      --batch                      Watch jobs, and cronjobs in batch/v1 group.
      --cluster-rbac               Watch clusterroles, and clusterrolebindings in rbac.authorization.k8s.io/v1 group.
      --core                       Watch pods, secrets, configmaps, and serviceaccounts in core/v1 group
      --crd                        Watch customresourcedefinitions in apiextensions.k8s.io/v1 group.
      --listen-addr string         Address to listen on. (default "localhost:0")
      --listen-net string          Network on which to listen for connections. (default "tcp")
      --log-watch-request          Log watch request to stdout. Can be useful for debugging.
  -n, --namespace stringArray      Namespaces to watch. If not specified, all namespaces are watched with label and field selectors filtering.
      --ns-expression string       CEL expression to select namespaces. Evaluated before a namespace is watched and on any updates for the namespace object.
      --ns-field-selector string   Field selector to select namespaces. See https://kubernetes.io/docs/concepts/overview/working-with-objects/field-selectors/.
      --ns-label-selector string   Label selector to select namespaces. See https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors.
      --rbac                       Watch roles, and rolebindings in rbac.authorization.k8s.io/v1 group.
  -r, --resources stringArray      A list of resources to watch. You can see the list of resources your cluster supports by running kubectl api-resources.
      --stdin                      Read watch request from standard input.
```

## Options inherited from parent commands

```plaintext
      --help              Show help for this command.
  -R, --repo OWNER/REPO   Select another repository. Can use either OWNER/REPO or `GROUP/NAMESPACE/REPO` format. Also accepts full URL or Git URL.
```
