---
title: glab token rotate
stage: Create
group: Code Review
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://about.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

<!--
This documentation is auto generated by a script.
Please do not edit this file directly. Run `make gen-docs` instead.
-->

Rotate user, group, or project access tokens

## Synopsis

Rotate user, group, or project access token, then print the new token on stdout. If multiple tokens with
the same name exist, you can specify the ID of the token.

The expiration date of the token will be calculated by adding the duration (default 30 days) to the
current date. Alternatively you can specify a different duration or an explicit end date.

The output format can be either "JSON" or "text". The JSON output will show the meta information of the
rotated token.

Administrators can rotate personal access tokens belonging to other users.

```plaintext
glab token rotate <token-name|token-id> [flags]
```

## Aliases

```plaintext
rotate
rot
```

## Examples

```console
# Rotate project access token of current project
$ glab token rotate  my-project-token

# Rotate project access token of another project, set to expiration date
$ glab token rotate --repo user/repo my-project-token --expires-at 2024-08-08

# Rotate group access token
$ glab token rotate --group group/sub-group my-group-token

# Rotate personal access token and extend duration to 7 days
$ glab token rotate --user @me --duration $((7 * 24))h my-personal-token

# Rotate a personal access token of another user (administrator only)
$ glab token rotate --user johndoe johns-personal-token

```

## Options

```plaintext
  -D, --duration duration   Sets the token duration, in hours. Maximum of 8760. Examples: 24h, 168h, 504h. (default 720h0m0s)
  -E, --expires-at DATE     Sets the token's expiration date and time, in YYYY-MM-DD format. If not specified, --duration is used. (default 0001-01-01)
  -g, --group string        Rotate group access token. Ignored if a user or repository argument is set.
  -F, --output string       Format output as: text, json. 'text' provides the new token value; 'json' outputs the token with metadata. (default "text")
  -R, --repo OWNER/REPO     Select another repository. Can use either OWNER/REPO or `GROUP/NAMESPACE/REPO` format. Also accepts full URL or Git URL.
  -U, --user string         Rotate personal access token. Use @me for the current user.
```

## Options inherited from parent commands

```plaintext
  -h, --help   Show help for this command.
```
