package todo

import (
	"errors"
	"fmt"
	"net/http"

	"github.com/spf13/cobra"

	"gitlab.com/gitlab-org/cli/internal/cmdutils"
	"gitlab.com/gitlab-org/cli/internal/commands/mr/mrutils"
	"gitlab.com/gitlab-org/cli/internal/mcpannotations"
)

var errTodoExists = errors.New("To-do already exists.")

func NewCmdTodo(f cmdutils.Factory) *cobra.Command {
	mrToDoCmd := &cobra.Command{
		Use:     "todo [<id> | <branch>]",
		Aliases: []string{"add-todo"},
		Short:   "Add a to-do item to merge request.",
		Long:    ``,
		Args:    cobra.MaximumNArgs(1),
		Annotations: map[string]string{
			mcpannotations.Destructive: "true",
		},
		RunE: func(cmd *cobra.Command, args []string) error {
			var err error
			c := f.IO().Color()

			client, err := f.GitLabClient()
			if err != nil {
				return err
			}

			mr, repo, err := mrutils.MRFromArgs(cmd.Context(), f, args, "any")
			if err != nil {
				return err
			}

			_, resp, err := client.MergeRequests.CreateTodo(repo.FullName(), mr.IID)

			if resp.StatusCode == http.StatusNotModified {
				return errTodoExists
			}
			if err != nil {
				return err
			}

			fmt.Fprintln(f.IO().StdOut, c.GreenCheck(), "Done!!")

			return nil
		},
	}

	return mrToDoCmd
}
