// Copyright 2015 The Go Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

package ssa

// machine-independent optimization.
func opt(f *Func) {
	applyRewrite(f, rewriteBlockgeneric, rewriteValuegeneric, removeDeadValues)
}

func divisible(f *Func) {
	applyRewrite(f, rewriteBlockdivisible, rewriteValuedivisible, removeDeadValues)
}

func divmod(f *Func) {
	applyRewrite(f, rewriteBlockdivmod, rewriteValuedivmod, removeDeadValues)
}
