// SPDX-License-Identifier: MPL-2.0
/**
 * SECTION:element-analyticssplitter
 * @see_also: analyticscombiner
 *
 * `analyticssplitter` is a generic, media-agnostic stream splitter for streams generated by
 * `analyticscombiner` and other streams that make use of `GstAnalyticsBatchMeta`.
 *
 * See the `analyticscombiner` and `GstAnalyticsBatchMeta` documentation for more details.
 *
 * Since: plugins-rs-0.14.0
 */
use glib::prelude::*;

mod imp;

glib::wrapper! {
    pub struct AnalyticsSplitter(ObjectSubclass<imp::AnalyticsSplitter>) @extends gst::Element, gst::Object;
}

pub fn register(plugin: &gst::Plugin) -> Result<(), glib::BoolError> {
    gst::Element::register(
        Some(plugin),
        "analyticssplitter",
        gst::Rank::PRIMARY,
        AnalyticsSplitter::static_type(),
    )
}
