# Support

If you're having trouble with understanding what HELICS does, how to use HELICS, getting a specific feature to work, or trouble-shooting some aspect of a HELICS-based co-simulation; there are a variety of support mechanisms we offer.

- [**Documentation**](https://docs.helics.org/en/latest/) - Though you're already here at the documentation site, the following pages may be of particular interest:

  - [Installation Guide](./installation/index.md) - Help with getting HELICS installed with the correct options for your particular use case
  - [User Guide](./index.md) - Comprehensive guide to understanding and using HELICS covering both the [fundamentals](./fundamental_topics/fundamental_topics_index) as well as more [advanced topics](./advanced_topics/advanced_topics_index.md).
  - [API reference](../references/api-reference/index.md) - HELICS is written in C++ with many supported language bindings. The C++ Doxygen is the most comprehensive reference for the HELICS API

- [**User Forum**](https://github.com/GMLC-TDC/HELICS/discussions) - A space where users can discuss their HELICS use cases and get support on how to use HELICS.

- [**Bug Reports/Support**](https://github.com/GMLC-TDC/HELICS/issues) - If HELICS doesn't appear to be working as expected, this is the place to file a bug report and get some help.

- **Examples, Use Cases, and Tutorials** - Over the years there have been a number of different public examples, use cases, and demonstrations of HELICS. These may be useful to show how particular features work or as a starting point for your use of HELICS.

  - [NREL March 2020 In-house Tutorial](https://github.com/GMLC-TDC/HELICS-Tutorial-2020-03-13)
  - [HELICS Examples Github repository](https://github.com/GMLC-TDC/HELICS-Examples)
  - [HELICS Fundamental Tutorials](https://github.com/GMLC-TDC/HELICS-Tutorial)
  - [Demonstration Use Cases](https://github.com/GMLC-TDC/HELICS-Use-Cases) - Fully-formed co-simulation use cases using a variety of simulators and HELICS features.

- **[YouTube Channel](https://www.youtube.com/channel/UCPa81c4BVXEYXt2EShTzbcg/featured)** - HELICS developers have created a number of short lectures and tutorials about how HELICS works and how to use it.

- **[Gitter](https://gitter.im/GMLC-TDC/HELICS)** - Live chat with developers (when they're logged in) for quick fix support.

- **Virtual Office Hours** - HELICS developers have periodic [open office hours](https://helics.org/HELICSOfficeHours.ics) where anybody can come and get hands-on help with understanding HELICS better or getting a particular feature to work.
