#BEGIN_LEGAL
#
#Copyright (c) 2025 Intel Corporation
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.
#  
#END_LEGAL
# Temporary file for initial work
# TBD - should be autogenerated on build time
FIXED_DATA_WIDTH = 256
ENCODER_OPERANDS_MAX = 8

BASE_TYPES =  '''
typedef unsigned int uint32_t;

typedef signed char xed_int8_t;
typedef short xed_int16_t;
typedef int xed_int32_t;
typedef long long xed_int64_t;
typedef unsigned char xed_uint8_t;
typedef unsigned short xed_uint16_t;
typedef unsigned int xed_uint32_t;
typedef unsigned long long xed_uint64_t;

typedef unsigned int  xed_uint_t;
typedef          int  xed_int_t;
typedef unsigned int  xed_bits_t;
typedef unsigned int  xed_bool_t;
typedef xed_uint64_t xed_addr_t;

typedef union {
   xed_uint8_t   byte[2]; 
   xed_int8_t  s_byte[2]; 

  struct {
    xed_uint8_t b0; /*low 8 bits*/
    xed_uint8_t b1; /*high 8 bits*/
  } b;
  xed_int16_t  i16;
  xed_uint16_t u16;
} xed_union16_t ;

typedef union {
   xed_uint8_t   byte[4]; 
   xed_uint16_t  word[2]; 
   xed_int8_t  s_byte[4]; 
   xed_int16_t s_word[2]; 

  struct {
    xed_uint8_t b0; /*low 8 bits*/
    xed_uint8_t b1; 
    xed_uint8_t b2; 
    xed_uint8_t b3; /*high 8 bits*/
  } b;

  struct {
    xed_uint16_t w0; /*low 16 bits*/
    xed_uint16_t w1; /*high 16 bits*/
  } w;
  xed_int32_t  i32;
  xed_uint32_t u32;
} xed_union32_t ;

typedef union {
   xed_uint8_t      byte[8]; 
   xed_uint16_t     word[4]; 
   xed_uint32_t    dword[2]; 
   xed_int8_t     s_byte[8]; 
   xed_int16_t    s_word[4]; 
   xed_int32_t   s_dword[2]; 

  struct {
    xed_uint8_t b0; /*low 8 bits*/
    xed_uint8_t b1; 
    xed_uint8_t b2; 
    xed_uint8_t b3; 
    xed_uint8_t b4; 
    xed_uint8_t b5; 
    xed_uint8_t b6; 
    xed_uint8_t b7; /*high 8 bits*/
  } b;

  struct {
    xed_uint16_t w0; /*low 16 bits*/
    xed_uint16_t w1;
    xed_uint16_t w2;
    xed_uint16_t w3; /*high 16 bits*/
  } w;
  struct {
    xed_uint32_t lo32;
    xed_uint32_t hi32;
  } s;
    xed_uint64_t u64;
    xed_int64_t i64;
} xed_union64_t ;

typedef union {
    xed_uint32_t i;
    struct {
        xed_uint8_t has_modrm;
        xed_uint8_t has_disp;
        xed_uint8_t has_imm;
    } s;
} xed_ild_vars_t;

'''

EMPTY_ENUMS = '''
typedef unsigned int xed_reg_enum_t;
typedef unsigned int xed_category_enum_t;
typedef unsigned int xed_extension_enum_t;
typedef unsigned int xed_isa_set_enum_t;
typedef unsigned int xed_iclass_enum_t;
typedef unsigned int xed_iform_enum_t;
typedef unsigned int xed_chip_enum_t;
typedef unsigned int xed_operand_enum_t;
typedef unsigned int xed_operand_visibility_enum_t;
typedef unsigned int xed_operand_action_enum_t;
typedef unsigned int xed_nonterminal_enum_t;
'''

cdef_string = BASE_TYPES + EMPTY_ENUMS + '''
#define XED_ENCODE_ORDER_MAX_OPERANDS 5

#define XED_REG_INVALID 0

typedef enum {
  XED_ADDRESS_WIDTH_INVALID=0,
  XED_ADDRESS_WIDTH_16b=2, ///< 16b addressing
  XED_ADDRESS_WIDTH_32b=4, ///< 32b addressing
  XED_ADDRESS_WIDTH_64b=8, ///< 64b addressing
  XED_ADDRESS_WIDTH_LAST
} xed_address_width_enum_t;

typedef enum {
  XED_MACHINE_MODE_INVALID,
  XED_MACHINE_MODE_LONG_64, ///< 64b operating mode
  XED_MACHINE_MODE_LONG_COMPAT_32, ///< 32b protected mode
  XED_MACHINE_MODE_LONG_COMPAT_16, ///< 16b protected mode
  XED_MACHINE_MODE_LEGACY_32, ///< 32b protected mode
  XED_MACHINE_MODE_LEGACY_16, ///< 16b protected mode
  XED_MACHINE_MODE_REAL_16, ///< 16b real mode
  XED_MACHINE_MODE_REAL_32, ///< 32b real mode (CS.D bit = 1)
  XED_MACHINE_MODE_LAST
} xed_machine_mode_enum_t;

typedef enum {
  XED_ERROR_NONE, ///< There was no error
  XED_ERROR_BUFFER_TOO_SHORT, ///< There were not enough bytes in the given buffer
  XED_ERROR_GENERAL_ERROR, ///< XED could not decode the given instruction
  XED_ERROR_INVALID_FOR_CHIP, ///< The instruciton is not valid for the specified chip
  XED_ERROR_BAD_REGISTER, ///< XED could not decode the given instruction because an invalid register encoding was used.
  XED_ERROR_BAD_LOCK_PREFIX, ///< A lock prefix was found where none is allowed.
  XED_ERROR_BAD_LEGACY_PREFIX, ///< A 66, F2 or F3 prefix was found where none is allowed.
  XED_ERROR_BAD_REX_PREFIX, ///< A REX prefix was found where none is allowed.
  XED_ERROR_BAD_MAP, ///< An illegal value for the MAP field was detected in the instruction.
  XED_ERROR_BAD_EVEX_V_PRIME, ///< EVEX.V'=0 was detected in a non-64b mode instruction.
  XED_ERROR_BAD_EVEX_Z_NO_MASKING, ///< EVEX.Z!=0 when EVEX.aaa==0
  XED_ERROR_NO_OUTPUT_POINTER, ///< The output pointer for xed_agen was zero
  XED_ERROR_NO_AGEN_CALL_BACK_REGISTERED, ///< One or both of the callbacks for xed_agen were missing.
  XED_ERROR_BAD_MEMOP_INDEX, ///< Memop indices must be 0 or 1.
  XED_ERROR_CALLBACK_PROBLEM, ///< The register or segment callback for xed_agen experienced a problem
  XED_ERROR_GATHER_REGS, ///< The index, dest and mask regs for AVX2 gathers must be different.
  XED_ERROR_INSTR_TOO_LONG, ///< Full decode of instruction would exeed 15B.
  XED_ERROR_INVALID_MODE, ///< The instruction was not valid for the specified mode
  XED_ERROR_BAD_EVEX_LL, ///< EVEX.LL must not ==3 unless using embedded rounding
  XED_ERROR_BAD_REG_MATCH, ///< Some registers must not match for this instruction (e.g. source with dest or dest with dest).
  XED_ERROR_LAST
} xed_error_enum_t;

typedef enum {
  XED_SYNTAX_INVALID,
  XED_SYNTAX_XED, ///< XED disassembly syntax
  XED_SYNTAX_ATT, ///< ATT SYSV disassembly syntax
  XED_SYNTAX_INTEL, ///< Intel disassembly syntax
  XED_SYNTAX_LAST
} xed_syntax_enum_t;

typedef struct {
    unsigned int hex_address_before_symbolic_name; 
    unsigned int xml_a; 
    unsigned int xml_f; 
    unsigned int omit_unit_scale;
    unsigned int no_sign_extend_signed_immediates;
    unsigned int write_mask_curly_k0;
    xed_bool_t lowercase_hex;
    xed_bool_t positive_memory_displacements;
    xed_bool_t emit_ignored_branch_taken_hint;
} xed_format_options_t;

typedef struct xed_operand_storage_s {
    /*
    * This struct provides a universal storage for different struct variations.
    * Prevents buffer overflows when struct sizes change due to build differences.
    * Acts as a raw memory container, allowing dynamic interpretation in Python.
    * Ensures safe memory allocation without requiring multiple struct definitions.
    */
    char data[%(FIXED_WIDTH)s];  // Fixed-size buffer to handle varying struct layouts safely.
} xed_operand_storage_t;

typedef struct xed_inst_s {
    xed_uint8_t _noperands; 
    xed_uint8_t _cpl;  // the nominal CPL for the instruction.
    xed_uint8_t _flag_complex; /* 1/0 valued, bool type */
    xed_uint8_t _exceptions; //xed_exception_enum_t
    
    xed_uint16_t _flag_info_index; 

    xed_uint16_t  _iform_enum; //xed_iform_enum_t
    // index into the xed_operand[] array of xed_operand_t structures
    xed_uint16_t _operand_base; 
    // index to table of xed_attributes_t structures
    xed_uint16_t _attributes;
}  xed_inst_t;


/*
* This struct provides a universal storage for different struct variations.
* Prevents buffer overflows when struct sizes change due to build differences.
* Acts as a raw memory container, allowing dynamic interpretation in Python.
* Ensures safe memory allocation without requiring multiple struct definitions.
*/
typedef struct xed_decoded_inst_s  {
    char data[%(FIXED_WIDTH)s];  // Fixed-size buffer to handle varying struct layouts safely.
} xed_decoded_inst_t;

typedef xed_decoded_inst_t xed_operand_values_t;


typedef  int (*xed_disassembly_callback_fn_t)(
    xed_uint64_t  address,
    char*         symbol_buffer,
    xed_uint32_t  buffer_length,
    xed_uint64_t* offset,
    void*         context);

typedef struct {

    /////////////////////////////////////////
    // REQUIRED FIELDS - users should set these
    /////////////////////////////////////////
    
    /// the decoded instruction to print
    const xed_decoded_inst_t* p;

    /// pointer to the output buffer
    char* buf;

    /// length of the output buffer. (bytes) Must be > 25 to start.
    int blen;

    /////////////////////////////////////////
    // OPTIONAL FIELDS - user can set these
    /////////////////////////////////////////
    
    /// program counter location. Must be zero if not used.  (Sometimes
    /// instructions are disassembled in a temporary buffer at a different
    /// location than where they may or will exist in memory).
    xed_uint64_t runtime_address;

    /// disassembly_callback MUST be set to zero if not used!  If zero, the
    /// default disassembly callback is used (if one has been registered).
    xed_disassembly_callback_fn_t disassembly_callback;

    /// passed to disassembly callback. Can be zero if not used.
    void* context; 

    /// default is Intel-syntax (dest on left)
    xed_syntax_enum_t syntax; 

    /// 1=indicated the format_options field is valid, 0=use default
    /// formatting options from xed_format_set_options().
    int format_options_valid;  
    xed_format_options_t format_options;

    
    /////////////////////////////////////////
    // NONPUBLIC FIELDS - Users should not use these!
    /////////////////////////////////////////

    /// internal, do not use
    xed_bool_t emitted;
    
    /// internal, do not use
    unsigned int operand_indx;
    
    /// internal, do not use
    unsigned int skip_operand;

    /// internal, do not use
    xed_reg_enum_t extra_index_operand; // for MPX

    /// internal, do not use
    xed_bool_t implicit;
    
    /// internal, do not use
    xed_bool_t truncate_eip_eosz16;

} xed_print_info_t;

typedef struct xed_state_s {
  /// real architected machine modes
  xed_machine_mode_enum_t mmode; 
  /// for 16b/32b modes
  xed_address_width_enum_t stack_addr_width; 
} xed_state_t;

typedef struct xed_operand_s
{
    xed_uint8_t         _name; // xed_operand_enum_t
    
     // implicit, explicit, suppressed
    xed_uint8_t         _operand_visibility; // xed_operand_visibility_enum_t
    xed_uint8_t         _rw;   // read or written // xed_operand_action_enum_t
    
     // width code, could be invalid (then use register name)
    xed_uint8_t         _oc2; // xed_operand_width_enum_t
    
     // IMM, IMM_CONST, NT_LOOKUP_FN, REG, ERROR
    xed_uint8_t         _type; //xed_operand_type_enum_t
    xed_uint8_t         _xtype; // xed data type: u32, f32, etc. //xed_operand_element_xtype_enum_t
    xed_uint8_t         _cvt_idx; //  decoration index
    xed_uint8_t         _nt; 
    union {
        xed_uint32_t                 _imm;  // value for some constant immmed
        xed_nonterminal_enum_t       _nt;   // for nt_lookup_fn's
        xed_reg_enum_t               _reg;  // register name
    } _u;
}  xed_operand_t;    
''' % {'FIXED_WIDTH': FIXED_DATA_WIDTH}

################################# ENCODER TYPES #################################
cdef_string += '''

typedef enum {
    XED_ENCODER_OPERAND_TYPE_INVALID,
    XED_ENCODER_OPERAND_TYPE_REL_BRDISP,
    XED_ENCODER_OPERAND_TYPE_ABS_BRDISP,
    XED_ENCODER_OPERAND_TYPE_REG,
    XED_ENCODER_OPERAND_TYPE_IMM0,
    XED_ENCODER_OPERAND_TYPE_SIMM0,
    XED_ENCODER_OPERAND_TYPE_IMM1,
    XED_ENCODER_OPERAND_TYPE_MEM,
    XED_ENCODER_OPERAND_TYPE_PTR,
    
     /* special for things with suppressed implicit memops */
    XED_ENCODER_OPERAND_TYPE_SEG0,
    
     /* special for things with suppressed implicit memops */
    XED_ENCODER_OPERAND_TYPE_SEG1,
    
    /* specific operand storage fields -- must supply a name */
    XED_ENCODER_OPERAND_TYPE_OTHER  
} xed_encoder_operand_type_t;

typedef struct {
    xed_int64_t    displacement; 
    xed_uint32_t   displacement_bits;
} xed_enc_displacement_t;

typedef struct {
    xed_reg_enum_t seg;
    xed_reg_enum_t base;
    xed_reg_enum_t index;
    xed_uint32_t   scale;
    xed_enc_displacement_t disp;
} xed_memop_t;

typedef xed_decoded_inst_t xed_encoder_request_t; 

typedef union {
    struct {
        xed_uint32_t rep               :1;
        xed_uint32_t repne             :1;
        xed_uint32_t br_hint_taken     :1;
        xed_uint32_t br_hint_not_taken :1;
    } s;
    xed_uint32_t i;
}  xed_encoder_prefixes_t;

typedef struct {
    xed_encoder_operand_type_t  type;
    union {
        xed_reg_enum_t reg;
        xed_int32_t brdisp;
        xed_uint64_t imm0;
        xed_uint8_t imm1;
        struct {
            xed_operand_enum_t operand_name;
            xed_uint32_t       value;
        } s;
        xed_memop_t mem;
    } u;
    xed_uint32_t width_bits;
} xed_encoder_operand_t;

typedef struct {
    xed_state_t mode;
    xed_iclass_enum_t iclass;
    xed_uint32_t effective_operand_width;

    xed_uint32_t effective_address_width; 

    xed_encoder_prefixes_t prefixes;
    xed_uint32_t noperands;
    xed_encoder_operand_t operands[%(ENCODER_OPERANDS_MAX)s];
} xed_encoder_instruction_t;

''' % {'ENCODER_OPERANDS_MAX': ENCODER_OPERANDS_MAX}
