/////////////////////////////////////////////////////////////////////////////// 
// 
// MonTest.cc 
// ------------- 
// monitor class test module 
// 
// Design and Implementation by Bjoern Lemke 
// 
// (C)opyright 2017 by Bjoern Lemke 
// 
// 
/////////////////////////////////////////////////////////////////////////////// 

#include "../src/Exception.h" 
#include "../src/Monitor.h" 

#include <locale.h> 

int main(int argc, char **argv) 
{ 

    try 
    { 

        Monitor m(Chain(":")); 

	m.regMenu(Chain("Info"), 1); 
        m.regMenu(Chain("Form"), 2); 
        m.regMenu(Chain("Selection"), 3); 
        m.regMenu(Chain("Table"), 4);
	m.regMenu(Chain("Attriute"), 5); 
        m.regMenu(Chain("quit"), 6);

	m.regShortCut('a', 99);
	m.regShortCut('b', 100);
	m.regShortCut('c', 101);
						
        int midx = 0; 
        while ( midx != 6 ) 
        { 
           midx =  m.showHeader(); 

	   if ( midx == 1 )
	   {
	       m.showInfoBox("Info Sample", "This is the information sample to show the curses based information box. This is the information sample to show the curses based information box" , 60);
	   }
           else if ( midx == 2 ) 
           { 

	       ListT<Chain> attrList; 
	       ListT<Chain> valList; 
	       attrList.Insert("String Input:S:40:Hello"); 
	       attrList.Insert("Number Input:N:10:4711");
	       attrList.Insert("Password Input:P:10");
	       attrList.Insert("Menu Input:M:10:Alpha=1,Beta=2,Gamma=3"); 
	       
	       m.showFormBox("Form Sample", attrList, valList);

	       Chain formResult;
	       Chain *pVal = valList.First();
	       while ( pVal )
	       {
		   formResult += Chain("val = ") + *pVal + Chain(",");
		   pVal = valList.Next();
	       }
	       m.showInfoBox("Form result", formResult, 60);
	       
           } 
           else if ( midx == 3 ) 
           {
	       ListT<Chain> selectList;
	       selectList.Insert("Alpha=1");
	       selectList.Insert("Beta=2");
	       selectList.Insert("Gamma=3");
	       	     	       
	       int r = m.showSelectBox("Selection Sample", selectList);

	       m.showInfoBox(Chain("Select result "),  Chain(r)  + Chain(" value selected"), 60);
           }
           else if ( midx == 4 ) 
           {	      
	       int i=0;
	       int ret = MON_TIMEOUT;
	       bool doInit = true;
	       while ( ret != MON_LEAVE )
	       {
		   ListT<Chain> schema;
		   ListT<ListT<Chain> > table;
		   
		   schema.Insert("Alpha=10");
		   schema.Insert("Beta=20");
		   schema.Insert("Gamma=5");
		   
		   ListT<Chain> row1;
		   row1.Insert("This");
		   row1.Insert("Alpha");
		   row1.Insert(Chain(i));
		   table.Insert(row1);
		   
		   ListT<Chain> row2;
		   row2.Insert("ThisX");
		   row2.Insert("Beta");
		   row2.Insert(Chain(ret));
		   table.Insert(row2);

		   ListT<Chain> row3;
		   row3.Insert("HHH");
		   row3.Insert("Gamma");
		   row3.Insert(Chain("XXX"));
		   table.Insert(row3);

		   ListT<Monitor::TableColor> colorMap;		   
		   colorMap.Insert(Monitor::TableColor(Chain("Alpha"), MON_RED));
		   
		   ret = m.showTableBox("The title", schema, table, 3000, colorMap, doInit, true);
		   doInit = false;
		   i++;
		   
		   // i = ret; // m.getSelectedRow();
	       }
           }
	   else if ( midx == 5 ) 
           {
	       int ret = 1;
	       int i=0;
	       while ( ret != MON_LEAVE )
	       {
		   
		   ListT<Chain> keyValueA;
		   keyValueA.Insert("Alpha=10");
		   keyValueA.Insert("Beta=20");
		   keyValueA.Insert("Gamma=" + Chain(i));


		   ListT<Chain> keyValueB;
		   keyValueB.Insert("Hugo=10");
		   keyValueB.Insert("Lotte=20");
		   keyValueB.Insert("Walter=" + Chain(i));

		   ListT< ListT<Chain> > attrSpec;
		   attrSpec.Insert(keyValueA);
		   attrSpec.Insert(keyValueB);
		   
		   ret = m.showAttributeBox(10, 40, attrSpec, 3000);
		   i++;
	       }
	       // m.showInfoBox("Select result", Chain(r) + Chain(" value selected"));
           }

        }
    } 
    catch (Exception e) 
    { 
        Chain msg; 
        e.pop(msg); 
        cout << msg << endl; 
        return 1; 
    } 

    return 0; 

} 
