; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 4
; RUN: llc -mtriple=amdgcn -mcpu=tahiti -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX6 %s
; RUN: llc -mtriple=amdgcn -mcpu=tonga -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX8 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx900 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX9 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1010 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX10-MAD %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX11-MAD %s

; RUN: llc -mtriple=amdgcn -mcpu=gfx940 -verify-machineinstrs -fp-contract=fast < %s | FileCheck -check-prefixes=GFX940-FMA %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1010 -verify-machineinstrs -fp-contract=fast < %s | FileCheck -check-prefixes=GFX10-FMA %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -verify-machineinstrs -fp-contract=fast < %s | FileCheck -check-prefixes=GFX11-FMA %s

declare i32 @llvm.amdgcn.workitem.id.x() nounwind readnone
declare float @llvm.fabs.f32(float) nounwind readnone

define amdgpu_kernel void @madak_f32(ptr addrspace(1) noalias %out, ptr addrspace(1) noalias %in.a, ptr addrspace(1) noalias %in.b) #0 {
; GFX6-LABEL: madak_f32:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GFX6-NEXT:    s_load_dwordx2 s[8:9], s[0:1], 0xd
; GFX6-NEXT:    s_mov_b32 s3, 0xf000
; GFX6-NEXT:    s_mov_b32 s2, 0
; GFX6-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_mov_b64 s[0:1], s[6:7]
; GFX6-NEXT:    v_mov_b32_e32 v1, 0
; GFX6-NEXT:    s_mov_b64 s[10:11], s[2:3]
; GFX6-NEXT:    buffer_load_dword v2, v[0:1], s[0:3], 0 addr64
; GFX6-NEXT:    buffer_load_dword v3, v[0:1], s[8:11], 0 addr64
; GFX6-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_madak_f32 v2, v2, v3, 0x41200000
; GFX6-NEXT:    buffer_store_dword v2, v[0:1], s[4:7], 0 addr64
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: madak_f32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 2, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s7
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s6, v4
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_add_u32_e32 v2, vcc, s0, v4
; GFX8-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; GFX8-NEXT:    flat_load_dword v5, v[0:1]
; GFX8-NEXT:    flat_load_dword v2, v[2:3]
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s4, v4
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_madak_f32 v2, v5, v2, 0x41200000
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: madak_f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[6:7]
; GFX9-NEXT:    global_load_dword v2, v0, s[2:3]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_madak_f32 v1, v1, v2, 0x41200000
; GFX9-NEXT:    global_store_dword v0, v1, s[4:5]
; GFX9-NEXT:    s_endpgm
;
; GFX10-MAD-LABEL: madak_f32:
; GFX10-MAD:       ; %bb.0:
; GFX10-MAD-NEXT:    s_clause 0x1
; GFX10-MAD-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX10-MAD-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX10-MAD-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-MAD-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-MAD-NEXT:    s_clause 0x1
; GFX10-MAD-NEXT:    global_load_dword v1, v0, s[6:7]
; GFX10-MAD-NEXT:    global_load_dword v2, v0, s[2:3]
; GFX10-MAD-NEXT:    s_waitcnt vmcnt(0)
; GFX10-MAD-NEXT:    v_madak_f32 v1, v1, v2, 0x41200000
; GFX10-MAD-NEXT:    global_store_dword v0, v1, s[4:5]
; GFX10-MAD-NEXT:    s_endpgm
;
; GFX11-MAD-LABEL: madak_f32:
; GFX11-MAD:       ; %bb.0:
; GFX11-MAD-NEXT:    s_clause 0x1
; GFX11-MAD-NEXT:    s_load_b128 s[4:7], s[0:1], 0x24
; GFX11-MAD-NEXT:    s_load_b64 s[0:1], s[0:1], 0x34
; GFX11-MAD-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-MAD-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-MAD-NEXT:    s_clause 0x1
; GFX11-MAD-NEXT:    global_load_b32 v1, v0, s[6:7]
; GFX11-MAD-NEXT:    global_load_b32 v2, v0, s[0:1]
; GFX11-MAD-NEXT:    s_waitcnt vmcnt(0)
; GFX11-MAD-NEXT:    v_mul_f32_e32 v1, v1, v2
; GFX11-MAD-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-MAD-NEXT:    v_add_f32_e32 v1, 0x41200000, v1
; GFX11-MAD-NEXT:    global_store_b32 v0, v1, s[4:5]
; GFX11-MAD-NEXT:    s_nop 0
; GFX11-MAD-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-MAD-NEXT:    s_endpgm
;
; GFX940-FMA-LABEL: madak_f32:
; GFX940-FMA:       ; %bb.0:
; GFX940-FMA-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX940-FMA-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX940-FMA-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX940-FMA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-FMA-NEXT:    global_load_dword v1, v0, s[6:7]
; GFX940-FMA-NEXT:    global_load_dword v2, v0, s[2:3]
; GFX940-FMA-NEXT:    s_waitcnt vmcnt(0)
; GFX940-FMA-NEXT:    v_fmaak_f32 v1, v1, v2, 0x41200000
; GFX940-FMA-NEXT:    global_store_dword v0, v1, s[4:5] sc0 sc1
; GFX940-FMA-NEXT:    s_endpgm
;
; GFX10-FMA-LABEL: madak_f32:
; GFX10-FMA:       ; %bb.0:
; GFX10-FMA-NEXT:    s_clause 0x1
; GFX10-FMA-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX10-FMA-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX10-FMA-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-FMA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-FMA-NEXT:    s_clause 0x1
; GFX10-FMA-NEXT:    global_load_dword v1, v0, s[6:7]
; GFX10-FMA-NEXT:    global_load_dword v2, v0, s[2:3]
; GFX10-FMA-NEXT:    s_waitcnt vmcnt(0)
; GFX10-FMA-NEXT:    v_fmaak_f32 v1, v1, v2, 0x41200000
; GFX10-FMA-NEXT:    global_store_dword v0, v1, s[4:5]
; GFX10-FMA-NEXT:    s_endpgm
;
; GFX11-FMA-LABEL: madak_f32:
; GFX11-FMA:       ; %bb.0:
; GFX11-FMA-NEXT:    s_clause 0x1
; GFX11-FMA-NEXT:    s_load_b128 s[4:7], s[0:1], 0x24
; GFX11-FMA-NEXT:    s_load_b64 s[0:1], s[0:1], 0x34
; GFX11-FMA-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-FMA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-FMA-NEXT:    s_clause 0x1
; GFX11-FMA-NEXT:    global_load_b32 v1, v0, s[6:7]
; GFX11-FMA-NEXT:    global_load_b32 v2, v0, s[0:1]
; GFX11-FMA-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FMA-NEXT:    v_fmaak_f32 v1, v1, v2, 0x41200000
; GFX11-FMA-NEXT:    global_store_b32 v0, v1, s[4:5]
; GFX11-FMA-NEXT:    s_nop 0
; GFX11-FMA-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-FMA-NEXT:    s_endpgm
  %tid = tail call i32 @llvm.amdgcn.workitem.id.x() nounwind readnone
  %in.a.gep = getelementptr float, ptr addrspace(1) %in.a, i32 %tid
  %in.b.gep = getelementptr float, ptr addrspace(1) %in.b, i32 %tid
  %out.gep = getelementptr float, ptr addrspace(1) %out, i32 %tid

  %a = load float, ptr addrspace(1) %in.a.gep, align 4
  %b = load float, ptr addrspace(1) %in.b.gep, align 4

  %mul = fmul float %a, %b
  %madak = fadd float %mul, 10.0
  store float %madak, ptr addrspace(1) %out.gep, align 4
  ret void
}

; Make sure this is only folded with one use. This is a code size
; optimization and if we fold the immediate multiple times, we'll undo
; it.
define amdgpu_kernel void @madak_2_use_f32(ptr addrspace(1) noalias %out, ptr addrspace(1) noalias %in) #0 {
; GFX6-LABEL: madak_2_use_f32:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s6, 0
; GFX6-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX6-NEXT:    v_mov_b32_e32 v1, 0
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX6-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64 glc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64 offset:4 glc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_load_dword v4, v[0:1], s[4:7], 0 addr64 offset:8 glc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v5, 0x41200000
; GFX6-NEXT:    s_mov_b64 s[2:3], s[6:7]
; GFX6-NEXT:    v_madak_f32 v3, v2, v3, 0x41200000
; GFX6-NEXT:    v_mac_f32_e32 v5, v2, v4
; GFX6-NEXT:    buffer_store_dword v3, v[0:1], s[0:3], 0 addr64
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_store_dword v5, v[0:1], s[4:7], 0 addr64 offset:4
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: madak_2_use_f32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX8-NEXT:    v_lshlrev_b32_e32 v6, 2, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s2, v6
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    v_add_u32_e32 v2, vcc, 4, v0
; GFX8-NEXT:    v_addc_u32_e32 v3, vcc, 0, v1, vcc
; GFX8-NEXT:    v_add_u32_e32 v4, vcc, 8, v0
; GFX8-NEXT:    v_addc_u32_e32 v5, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v7, v[0:1] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    flat_load_dword v8, v[2:3] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    flat_load_dword v4, v[4:5] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s0, v6
; GFX8-NEXT:    v_mov_b32_e32 v5, 0x41200000
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    v_madak_f32 v6, v7, v8, 0x41200000
; GFX8-NEXT:    v_mac_f32_e32 v5, v7, v4
; GFX8-NEXT:    flat_store_dword v[0:1], v6
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    flat_store_dword v[2:3], v5
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: madak_2_use_f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    v_mov_b32_e32 v4, 0x41200000
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[2:3] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    global_load_dword v2, v0, s[2:3] offset:4 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    global_load_dword v3, v0, s[2:3] offset:8 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_madak_f32 v2, v1, v2, 0x41200000
; GFX9-NEXT:    v_mac_f32_e32 v4, v1, v3
; GFX9-NEXT:    global_store_dword v0, v2, s[0:1]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    global_store_dword v0, v4, s[2:3] offset:4
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_endpgm
;
; GFX10-MAD-LABEL: madak_2_use_f32:
; GFX10-MAD:       ; %bb.0:
; GFX10-MAD-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX10-MAD-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-MAD-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-MAD-NEXT:    global_load_dword v1, v0, s[2:3] glc dlc
; GFX10-MAD-NEXT:    s_waitcnt vmcnt(0)
; GFX10-MAD-NEXT:    global_load_dword v2, v0, s[2:3] offset:4 glc dlc
; GFX10-MAD-NEXT:    s_waitcnt vmcnt(0)
; GFX10-MAD-NEXT:    global_load_dword v3, v0, s[2:3] offset:8 glc dlc
; GFX10-MAD-NEXT:    s_waitcnt vmcnt(0)
; GFX10-MAD-NEXT:    v_madak_f32 v2, v1, v2, 0x41200000
; GFX10-MAD-NEXT:    v_madak_f32 v1, v1, v3, 0x41200000
; GFX10-MAD-NEXT:    global_store_dword v0, v2, s[0:1]
; GFX10-MAD-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-MAD-NEXT:    global_store_dword v0, v1, s[2:3] offset:4
; GFX10-MAD-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-MAD-NEXT:    s_endpgm
;
; GFX11-MAD-LABEL: madak_2_use_f32:
; GFX11-MAD:       ; %bb.0:
; GFX11-MAD-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-MAD-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-MAD-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-MAD-NEXT:    global_load_b32 v1, v0, s[2:3] glc dlc
; GFX11-MAD-NEXT:    s_waitcnt vmcnt(0)
; GFX11-MAD-NEXT:    global_load_b32 v2, v0, s[2:3] offset:4 glc dlc
; GFX11-MAD-NEXT:    s_waitcnt vmcnt(0)
; GFX11-MAD-NEXT:    global_load_b32 v3, v0, s[2:3] offset:8 glc dlc
; GFX11-MAD-NEXT:    s_waitcnt vmcnt(0)
; GFX11-MAD-NEXT:    v_mul_f32_e32 v2, v1, v2
; GFX11-MAD-NEXT:    v_mul_f32_e32 v1, v1, v3
; GFX11-MAD-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-MAD-NEXT:    v_dual_add_f32 v1, 0x41200000, v1 :: v_dual_add_f32 v2, 0x41200000, v2
; GFX11-MAD-NEXT:    global_store_b32 v0, v2, s[0:1] dlc
; GFX11-MAD-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-MAD-NEXT:    global_store_b32 v0, v1, s[2:3] offset:4 dlc
; GFX11-MAD-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-MAD-NEXT:    s_nop 0
; GFX11-MAD-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-MAD-NEXT:    s_endpgm
;
; GFX940-FMA-LABEL: madak_2_use_f32:
; GFX940-FMA:       ; %bb.0:
; GFX940-FMA-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX940-FMA-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX940-FMA-NEXT:    v_mov_b32_e32 v4, 0x41200000
; GFX940-FMA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-FMA-NEXT:    global_load_dword v1, v0, s[2:3] sc0 sc1
; GFX940-FMA-NEXT:    s_waitcnt vmcnt(0)
; GFX940-FMA-NEXT:    global_load_dword v2, v0, s[2:3] offset:4 sc0 sc1
; GFX940-FMA-NEXT:    s_waitcnt vmcnt(0)
; GFX940-FMA-NEXT:    global_load_dword v3, v0, s[2:3] offset:8 sc0 sc1
; GFX940-FMA-NEXT:    s_waitcnt vmcnt(0)
; GFX940-FMA-NEXT:    v_fmaak_f32 v2, v1, v2, 0x41200000
; GFX940-FMA-NEXT:    v_fmac_f32_e32 v4, v1, v3
; GFX940-FMA-NEXT:    global_store_dword v0, v2, s[0:1] sc0 sc1
; GFX940-FMA-NEXT:    s_waitcnt vmcnt(0)
; GFX940-FMA-NEXT:    global_store_dword v0, v4, s[2:3] offset:4 sc0 sc1
; GFX940-FMA-NEXT:    s_waitcnt vmcnt(0)
; GFX940-FMA-NEXT:    s_endpgm
;
; GFX10-FMA-LABEL: madak_2_use_f32:
; GFX10-FMA:       ; %bb.0:
; GFX10-FMA-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX10-FMA-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-FMA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-FMA-NEXT:    global_load_dword v1, v0, s[2:3] glc dlc
; GFX10-FMA-NEXT:    s_waitcnt vmcnt(0)
; GFX10-FMA-NEXT:    global_load_dword v2, v0, s[2:3] offset:4 glc dlc
; GFX10-FMA-NEXT:    s_waitcnt vmcnt(0)
; GFX10-FMA-NEXT:    global_load_dword v3, v0, s[2:3] offset:8 glc dlc
; GFX10-FMA-NEXT:    s_waitcnt vmcnt(0)
; GFX10-FMA-NEXT:    v_fmaak_f32 v2, v1, v2, 0x41200000
; GFX10-FMA-NEXT:    v_fmaak_f32 v1, v1, v3, 0x41200000
; GFX10-FMA-NEXT:    global_store_dword v0, v2, s[0:1]
; GFX10-FMA-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-FMA-NEXT:    global_store_dword v0, v1, s[2:3] offset:4
; GFX10-FMA-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-FMA-NEXT:    s_endpgm
;
; GFX11-FMA-LABEL: madak_2_use_f32:
; GFX11-FMA:       ; %bb.0:
; GFX11-FMA-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-FMA-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-FMA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-FMA-NEXT:    global_load_b32 v1, v0, s[2:3] glc dlc
; GFX11-FMA-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FMA-NEXT:    global_load_b32 v2, v0, s[2:3] offset:4 glc dlc
; GFX11-FMA-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FMA-NEXT:    global_load_b32 v3, v0, s[2:3] offset:8 glc dlc
; GFX11-FMA-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FMA-NEXT:    v_fmaak_f32 v2, v1, v2, 0x41200000
; GFX11-FMA-NEXT:    v_fmaak_f32 v1, v1, v3, 0x41200000
; GFX11-FMA-NEXT:    global_store_b32 v0, v2, s[0:1] dlc
; GFX11-FMA-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-FMA-NEXT:    global_store_b32 v0, v1, s[2:3] offset:4 dlc
; GFX11-FMA-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-FMA-NEXT:    s_nop 0
; GFX11-FMA-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-FMA-NEXT:    s_endpgm
  %tid = tail call i32 @llvm.amdgcn.workitem.id.x() nounwind readnone

  %in.gep.0 = getelementptr float, ptr addrspace(1) %in, i32 %tid
  %in.gep.1 = getelementptr float, ptr addrspace(1) %in.gep.0, i32 1
  %in.gep.2 = getelementptr float, ptr addrspace(1) %in.gep.0, i32 2

  %out.gep.0 = getelementptr float, ptr addrspace(1) %out, i32 %tid
  %out.gep.1 = getelementptr float, ptr addrspace(1) %in.gep.0, i32 1

  %a = load volatile float, ptr addrspace(1) %in.gep.0, align 4
  %b = load volatile float, ptr addrspace(1) %in.gep.1, align 4
  %c = load volatile float, ptr addrspace(1) %in.gep.2, align 4

  %mul0 = fmul float %a, %b
  %mul1 = fmul float %a, %c
  %madak0 = fadd float %mul0, 10.0
  %madak1 = fadd float %mul1, 10.0

  store volatile float %madak0, ptr addrspace(1) %out.gep.0, align 4
  store volatile float %madak1, ptr addrspace(1) %out.gep.1, align 4
  ret void
}

define amdgpu_kernel void @madak_m_inline_imm_f32(ptr addrspace(1) noalias %out, ptr addrspace(1) noalias %in.a) #0 {
; GFX6-LABEL: madak_m_inline_imm_f32:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s6, 0
; GFX6-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX6-NEXT:    v_mov_b32_e32 v1, 0
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX6-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64
; GFX6-NEXT:    s_mov_b64 s[2:3], s[6:7]
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_madak_f32 v2, 4.0, v2, 0x41200000
; GFX6-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: madak_m_inline_imm_f32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s0, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_madak_f32 v2, 4.0, v3, 0x41200000
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: madak_m_inline_imm_f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_madak_f32 v1, 4.0, v1, 0x41200000
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX10-MAD-LABEL: madak_m_inline_imm_f32:
; GFX10-MAD:       ; %bb.0:
; GFX10-MAD-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX10-MAD-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-MAD-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-MAD-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX10-MAD-NEXT:    s_waitcnt vmcnt(0)
; GFX10-MAD-NEXT:    v_madak_f32 v1, 4.0, v1, 0x41200000
; GFX10-MAD-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX10-MAD-NEXT:    s_endpgm
;
; GFX11-MAD-LABEL: madak_m_inline_imm_f32:
; GFX11-MAD:       ; %bb.0:
; GFX11-MAD-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-MAD-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-MAD-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-MAD-NEXT:    global_load_b32 v1, v0, s[2:3]
; GFX11-MAD-NEXT:    s_waitcnt vmcnt(0)
; GFX11-MAD-NEXT:    v_mul_f32_e32 v1, 4.0, v1
; GFX11-MAD-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-MAD-NEXT:    v_add_f32_e32 v1, 0x41200000, v1
; GFX11-MAD-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-MAD-NEXT:    s_nop 0
; GFX11-MAD-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-MAD-NEXT:    s_endpgm
;
; GFX940-FMA-LABEL: madak_m_inline_imm_f32:
; GFX940-FMA:       ; %bb.0:
; GFX940-FMA-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX940-FMA-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX940-FMA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-FMA-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX940-FMA-NEXT:    s_waitcnt vmcnt(0)
; GFX940-FMA-NEXT:    v_fmaak_f32 v1, 4.0, v1, 0x41200000
; GFX940-FMA-NEXT:    global_store_dword v0, v1, s[0:1] sc0 sc1
; GFX940-FMA-NEXT:    s_endpgm
;
; GFX10-FMA-LABEL: madak_m_inline_imm_f32:
; GFX10-FMA:       ; %bb.0:
; GFX10-FMA-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX10-FMA-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-FMA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-FMA-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX10-FMA-NEXT:    s_waitcnt vmcnt(0)
; GFX10-FMA-NEXT:    v_fmaak_f32 v1, 4.0, v1, 0x41200000
; GFX10-FMA-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX10-FMA-NEXT:    s_endpgm
;
; GFX11-FMA-LABEL: madak_m_inline_imm_f32:
; GFX11-FMA:       ; %bb.0:
; GFX11-FMA-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-FMA-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-FMA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-FMA-NEXT:    global_load_b32 v1, v0, s[2:3]
; GFX11-FMA-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FMA-NEXT:    v_fmaak_f32 v1, 4.0, v1, 0x41200000
; GFX11-FMA-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-FMA-NEXT:    s_nop 0
; GFX11-FMA-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-FMA-NEXT:    s_endpgm
  %tid = tail call i32 @llvm.amdgcn.workitem.id.x() nounwind readnone
  %in.a.gep = getelementptr float, ptr addrspace(1) %in.a, i32 %tid
  %out.gep = getelementptr float, ptr addrspace(1) %out, i32 %tid

  %a = load float, ptr addrspace(1) %in.a.gep, align 4

  %mul = fmul float 4.0, %a
  %madak = fadd float %mul, 10.0
  store float %madak, ptr addrspace(1) %out.gep, align 4
  ret void
}

; Make sure nothing weird happens with a value that is also allowed as
; an inline immediate.
define amdgpu_kernel void @madak_inline_imm_f32(ptr addrspace(1) noalias %out, ptr addrspace(1) noalias %in.a, ptr addrspace(1) noalias %in.b) #0 {
; GFX6-LABEL: madak_inline_imm_f32:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GFX6-NEXT:    s_load_dwordx2 s[8:9], s[0:1], 0xd
; GFX6-NEXT:    s_mov_b32 s3, 0xf000
; GFX6-NEXT:    s_mov_b32 s2, 0
; GFX6-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_mov_b64 s[0:1], s[6:7]
; GFX6-NEXT:    v_mov_b32_e32 v1, 0
; GFX6-NEXT:    s_mov_b64 s[10:11], s[2:3]
; GFX6-NEXT:    buffer_load_dword v2, v[0:1], s[0:3], 0 addr64
; GFX6-NEXT:    buffer_load_dword v3, v[0:1], s[8:11], 0 addr64
; GFX6-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_mad_f32 v2, v2, v3, 4.0
; GFX6-NEXT:    buffer_store_dword v2, v[0:1], s[4:7], 0 addr64
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: madak_inline_imm_f32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 2, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s7
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s6, v4
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_add_u32_e32 v2, vcc, s0, v4
; GFX8-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; GFX8-NEXT:    flat_load_dword v5, v[0:1]
; GFX8-NEXT:    flat_load_dword v2, v[2:3]
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s4, v4
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mad_f32 v2, v5, v2, 4.0
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: madak_inline_imm_f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[6:7]
; GFX9-NEXT:    global_load_dword v2, v0, s[2:3]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_mad_f32 v1, v1, v2, 4.0
; GFX9-NEXT:    global_store_dword v0, v1, s[4:5]
; GFX9-NEXT:    s_endpgm
;
; GFX10-MAD-LABEL: madak_inline_imm_f32:
; GFX10-MAD:       ; %bb.0:
; GFX10-MAD-NEXT:    s_clause 0x1
; GFX10-MAD-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX10-MAD-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX10-MAD-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-MAD-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-MAD-NEXT:    s_clause 0x1
; GFX10-MAD-NEXT:    global_load_dword v1, v0, s[6:7]
; GFX10-MAD-NEXT:    global_load_dword v2, v0, s[2:3]
; GFX10-MAD-NEXT:    s_waitcnt vmcnt(0)
; GFX10-MAD-NEXT:    v_mad_f32 v1, v1, v2, 4.0
; GFX10-MAD-NEXT:    global_store_dword v0, v1, s[4:5]
; GFX10-MAD-NEXT:    s_endpgm
;
; GFX11-MAD-LABEL: madak_inline_imm_f32:
; GFX11-MAD:       ; %bb.0:
; GFX11-MAD-NEXT:    s_clause 0x1
; GFX11-MAD-NEXT:    s_load_b128 s[4:7], s[0:1], 0x24
; GFX11-MAD-NEXT:    s_load_b64 s[0:1], s[0:1], 0x34
; GFX11-MAD-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-MAD-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-MAD-NEXT:    s_clause 0x1
; GFX11-MAD-NEXT:    global_load_b32 v1, v0, s[6:7]
; GFX11-MAD-NEXT:    global_load_b32 v2, v0, s[0:1]
; GFX11-MAD-NEXT:    s_waitcnt vmcnt(0)
; GFX11-MAD-NEXT:    v_mul_f32_e32 v1, v1, v2
; GFX11-MAD-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-MAD-NEXT:    v_add_f32_e32 v1, 4.0, v1
; GFX11-MAD-NEXT:    global_store_b32 v0, v1, s[4:5]
; GFX11-MAD-NEXT:    s_nop 0
; GFX11-MAD-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-MAD-NEXT:    s_endpgm
;
; GFX940-FMA-LABEL: madak_inline_imm_f32:
; GFX940-FMA:       ; %bb.0:
; GFX940-FMA-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX940-FMA-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX940-FMA-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX940-FMA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-FMA-NEXT:    global_load_dword v1, v0, s[6:7]
; GFX940-FMA-NEXT:    global_load_dword v2, v0, s[2:3]
; GFX940-FMA-NEXT:    s_waitcnt vmcnt(0)
; GFX940-FMA-NEXT:    v_fma_f32 v1, v1, v2, 4.0
; GFX940-FMA-NEXT:    global_store_dword v0, v1, s[4:5] sc0 sc1
; GFX940-FMA-NEXT:    s_endpgm
;
; GFX10-FMA-LABEL: madak_inline_imm_f32:
; GFX10-FMA:       ; %bb.0:
; GFX10-FMA-NEXT:    s_clause 0x1
; GFX10-FMA-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX10-FMA-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX10-FMA-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-FMA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-FMA-NEXT:    s_clause 0x1
; GFX10-FMA-NEXT:    global_load_dword v1, v0, s[6:7]
; GFX10-FMA-NEXT:    global_load_dword v2, v0, s[2:3]
; GFX10-FMA-NEXT:    s_waitcnt vmcnt(0)
; GFX10-FMA-NEXT:    v_fma_f32 v1, v1, v2, 4.0
; GFX10-FMA-NEXT:    global_store_dword v0, v1, s[4:5]
; GFX10-FMA-NEXT:    s_endpgm
;
; GFX11-FMA-LABEL: madak_inline_imm_f32:
; GFX11-FMA:       ; %bb.0:
; GFX11-FMA-NEXT:    s_clause 0x1
; GFX11-FMA-NEXT:    s_load_b128 s[4:7], s[0:1], 0x24
; GFX11-FMA-NEXT:    s_load_b64 s[0:1], s[0:1], 0x34
; GFX11-FMA-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-FMA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-FMA-NEXT:    s_clause 0x1
; GFX11-FMA-NEXT:    global_load_b32 v1, v0, s[6:7]
; GFX11-FMA-NEXT:    global_load_b32 v2, v0, s[0:1]
; GFX11-FMA-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FMA-NEXT:    v_fma_f32 v1, v1, v2, 4.0
; GFX11-FMA-NEXT:    global_store_b32 v0, v1, s[4:5]
; GFX11-FMA-NEXT:    s_nop 0
; GFX11-FMA-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-FMA-NEXT:    s_endpgm
  %tid = tail call i32 @llvm.amdgcn.workitem.id.x() nounwind readnone
  %in.a.gep = getelementptr float, ptr addrspace(1) %in.a, i32 %tid
  %in.b.gep = getelementptr float, ptr addrspace(1) %in.b, i32 %tid
  %out.gep = getelementptr float, ptr addrspace(1) %out, i32 %tid

  %a = load float, ptr addrspace(1) %in.a.gep, align 4
  %b = load float, ptr addrspace(1) %in.b.gep, align 4

  %mul = fmul float %a, %b
  %madak = fadd float %mul, 4.0
  store float %madak, ptr addrspace(1) %out.gep, align 4
  ret void
}

; We can't use an SGPR when forming madak
define amdgpu_kernel void @s_v_madak_f32(ptr addrspace(1) noalias %out, ptr addrspace(1) noalias %in.a, float %b) #0 {
; GFX6-LABEL: s_v_madak_f32:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GFX6-NEXT:    s_load_dword s8, s[0:1], 0xd
; GFX6-NEXT:    s_mov_b32 s3, 0xf000
; GFX6-NEXT:    s_mov_b32 s2, 0
; GFX6-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_mov_b64 s[0:1], s[6:7]
; GFX6-NEXT:    v_mov_b32_e32 v1, 0
; GFX6-NEXT:    buffer_load_dword v2, v[0:1], s[0:3], 0 addr64
; GFX6-NEXT:    v_mov_b32_e32 v3, 0x41200000
; GFX6-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_mac_f32_e32 v3, s8, v2
; GFX6-NEXT:    buffer_store_dword v3, v[0:1], s[4:7], 0 addr64
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: s_v_madak_f32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX8-NEXT:    s_load_dword s0, s[0:1], 0x34
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s7
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s6, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s4, v2
; GFX8-NEXT:    v_mov_b32_e32 v2, 0x41200000
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mac_f32_e32 v2, s0, v3
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: s_v_madak_f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NEXT:    s_load_dword s2, s[0:1], 0x34
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    v_mov_b32_e32 v2, 0x41200000
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[6:7]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_mac_f32_e32 v2, s2, v1
; GFX9-NEXT:    global_store_dword v0, v2, s[4:5]
; GFX9-NEXT:    s_endpgm
;
; GFX10-MAD-LABEL: s_v_madak_f32:
; GFX10-MAD:       ; %bb.0:
; GFX10-MAD-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX10-MAD-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-MAD-NEXT:    s_load_dword s0, s[0:1], 0x34
; GFX10-MAD-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-MAD-NEXT:    global_load_dword v1, v0, s[6:7]
; GFX10-MAD-NEXT:    s_waitcnt vmcnt(0)
; GFX10-MAD-NEXT:    v_madak_f32 v1, s0, v1, 0x41200000
; GFX10-MAD-NEXT:    global_store_dword v0, v1, s[4:5]
; GFX10-MAD-NEXT:    s_endpgm
;
; GFX11-MAD-LABEL: s_v_madak_f32:
; GFX11-MAD:       ; %bb.0:
; GFX11-MAD-NEXT:    s_clause 0x1
; GFX11-MAD-NEXT:    s_load_b128 s[4:7], s[0:1], 0x24
; GFX11-MAD-NEXT:    s_load_b32 s0, s[0:1], 0x34
; GFX11-MAD-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-MAD-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-MAD-NEXT:    global_load_b32 v1, v0, s[6:7]
; GFX11-MAD-NEXT:    s_waitcnt vmcnt(0)
; GFX11-MAD-NEXT:    v_mul_f32_e32 v1, s0, v1
; GFX11-MAD-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-MAD-NEXT:    v_add_f32_e32 v1, 0x41200000, v1
; GFX11-MAD-NEXT:    global_store_b32 v0, v1, s[4:5]
; GFX11-MAD-NEXT:    s_nop 0
; GFX11-MAD-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-MAD-NEXT:    s_endpgm
;
; GFX940-FMA-LABEL: s_v_madak_f32:
; GFX940-FMA:       ; %bb.0:
; GFX940-FMA-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX940-FMA-NEXT:    s_load_dword s2, s[0:1], 0x34
; GFX940-FMA-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX940-FMA-NEXT:    v_mov_b32_e32 v2, 0x41200000
; GFX940-FMA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-FMA-NEXT:    global_load_dword v1, v0, s[6:7]
; GFX940-FMA-NEXT:    s_waitcnt vmcnt(0)
; GFX940-FMA-NEXT:    v_fmac_f32_e32 v2, s2, v1
; GFX940-FMA-NEXT:    global_store_dword v0, v2, s[4:5] sc0 sc1
; GFX940-FMA-NEXT:    s_endpgm
;
; GFX10-FMA-LABEL: s_v_madak_f32:
; GFX10-FMA:       ; %bb.0:
; GFX10-FMA-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX10-FMA-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-FMA-NEXT:    s_load_dword s0, s[0:1], 0x34
; GFX10-FMA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-FMA-NEXT:    global_load_dword v1, v0, s[6:7]
; GFX10-FMA-NEXT:    s_waitcnt vmcnt(0)
; GFX10-FMA-NEXT:    v_fmaak_f32 v1, s0, v1, 0x41200000
; GFX10-FMA-NEXT:    global_store_dword v0, v1, s[4:5]
; GFX10-FMA-NEXT:    s_endpgm
;
; GFX11-FMA-LABEL: s_v_madak_f32:
; GFX11-FMA:       ; %bb.0:
; GFX11-FMA-NEXT:    s_clause 0x1
; GFX11-FMA-NEXT:    s_load_b128 s[4:7], s[0:1], 0x24
; GFX11-FMA-NEXT:    s_load_b32 s0, s[0:1], 0x34
; GFX11-FMA-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-FMA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-FMA-NEXT:    global_load_b32 v1, v0, s[6:7]
; GFX11-FMA-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FMA-NEXT:    v_fmaak_f32 v1, s0, v1, 0x41200000
; GFX11-FMA-NEXT:    global_store_b32 v0, v1, s[4:5]
; GFX11-FMA-NEXT:    s_nop 0
; GFX11-FMA-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-FMA-NEXT:    s_endpgm
  %tid = tail call i32 @llvm.amdgcn.workitem.id.x() nounwind readnone
  %in.a.gep = getelementptr float, ptr addrspace(1) %in.a, i32 %tid
  %out.gep = getelementptr float, ptr addrspace(1) %out, i32 %tid

  %a = load float, ptr addrspace(1) %in.a.gep, align 4

  %mul = fmul float %a, %b
  %madak = fadd float %mul, 10.0
  store float %madak, ptr addrspace(1) %out.gep, align 4
  ret void
}

define amdgpu_kernel void @v_s_madak_f32(ptr addrspace(1) noalias %out, float %a, ptr addrspace(1) noalias %in.b) #0 {
; GFX6-LABEL: v_s_madak_f32:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0xd
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s6, 0
; GFX6-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX6-NEXT:    v_mov_b32_e32 v1, 0
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64
; GFX6-NEXT:    s_load_dword s2, s[0:1], 0xb
; GFX6-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x9
; GFX6-NEXT:    v_mov_b32_e32 v3, 0x41200000
; GFX6-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_mac_f32_e32 v3, s2, v2
; GFX6-NEXT:    buffer_store_dword v3, v[0:1], s[4:7], 0 addr64
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: v_s_madak_f32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; GFX8-NEXT:    s_load_dword s0, s[0:1], 0x2c
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; GFX8-NEXT:    v_mov_b32_e32 v2, 0x41200000
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mac_f32_e32 v2, s0, v3
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: v_s_madak_f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    v_mov_b32_e32 v2, 0x41200000
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX9-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mac_f32_e32 v2, s4, v1
; GFX9-NEXT:    global_store_dword v0, v2, s[2:3]
; GFX9-NEXT:    s_endpgm
;
; GFX10-MAD-LABEL: v_s_madak_f32:
; GFX10-MAD:       ; %bb.0:
; GFX10-MAD-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX10-MAD-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-MAD-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-MAD-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX10-MAD-NEXT:    s_clause 0x1
; GFX10-MAD-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GFX10-MAD-NEXT:    s_waitcnt_depctr 0xffe3
; GFX10-MAD-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; GFX10-MAD-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-MAD-NEXT:    v_madak_f32 v1, s4, v1, 0x41200000
; GFX10-MAD-NEXT:    global_store_dword v0, v1, s[2:3]
; GFX10-MAD-NEXT:    s_endpgm
;
; GFX11-MAD-LABEL: v_s_madak_f32:
; GFX11-MAD:       ; %bb.0:
; GFX11-MAD-NEXT:    s_load_b64 s[2:3], s[0:1], 0x34
; GFX11-MAD-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-MAD-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-MAD-NEXT:    global_load_b32 v1, v0, s[2:3]
; GFX11-MAD-NEXT:    s_clause 0x1
; GFX11-MAD-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; GFX11-MAD-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX11-MAD-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-MAD-NEXT:    v_mul_f32_e32 v1, s2, v1
; GFX11-MAD-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-MAD-NEXT:    v_add_f32_e32 v1, 0x41200000, v1
; GFX11-MAD-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-MAD-NEXT:    s_nop 0
; GFX11-MAD-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-MAD-NEXT:    s_endpgm
;
; GFX940-FMA-LABEL: v_s_madak_f32:
; GFX940-FMA:       ; %bb.0:
; GFX940-FMA-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX940-FMA-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX940-FMA-NEXT:    v_mov_b32_e32 v2, 0x41200000
; GFX940-FMA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-FMA-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX940-FMA-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GFX940-FMA-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; GFX940-FMA-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-FMA-NEXT:    v_fmac_f32_e32 v2, s4, v1
; GFX940-FMA-NEXT:    global_store_dword v0, v2, s[2:3] sc0 sc1
; GFX940-FMA-NEXT:    s_endpgm
;
; GFX10-FMA-LABEL: v_s_madak_f32:
; GFX10-FMA:       ; %bb.0:
; GFX10-FMA-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX10-FMA-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-FMA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-FMA-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX10-FMA-NEXT:    s_clause 0x1
; GFX10-FMA-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GFX10-FMA-NEXT:    s_waitcnt_depctr 0xffe3
; GFX10-FMA-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; GFX10-FMA-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-FMA-NEXT:    v_fmaak_f32 v1, s4, v1, 0x41200000
; GFX10-FMA-NEXT:    global_store_dword v0, v1, s[2:3]
; GFX10-FMA-NEXT:    s_endpgm
;
; GFX11-FMA-LABEL: v_s_madak_f32:
; GFX11-FMA:       ; %bb.0:
; GFX11-FMA-NEXT:    s_load_b64 s[2:3], s[0:1], 0x34
; GFX11-FMA-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-FMA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-FMA-NEXT:    global_load_b32 v1, v0, s[2:3]
; GFX11-FMA-NEXT:    s_clause 0x1
; GFX11-FMA-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; GFX11-FMA-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX11-FMA-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-FMA-NEXT:    v_fmaak_f32 v1, s2, v1, 0x41200000
; GFX11-FMA-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-FMA-NEXT:    s_nop 0
; GFX11-FMA-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-FMA-NEXT:    s_endpgm
  %tid = tail call i32 @llvm.amdgcn.workitem.id.x() nounwind readnone
  %in.b.gep = getelementptr float, ptr addrspace(1) %in.b, i32 %tid
  %out.gep = getelementptr float, ptr addrspace(1) %out, i32 %tid

  %b = load float, ptr addrspace(1) %in.b.gep, align 4

  %mul = fmul float %a, %b
  %madak = fadd float %mul, 10.0
  store float %madak, ptr addrspace(1) %out.gep, align 4
  ret void
}

define amdgpu_kernel void @s_s_madak_f32(ptr addrspace(1) %out, float %a, float %b) #0 {
; GFX6-LABEL: s_s_madak_f32:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GFX6-NEXT:    v_mov_b32_e32 v0, 0x41200000
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s6, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v1, s3
; GFX6-NEXT:    s_mov_b32 s4, s0
; GFX6-NEXT:    s_mov_b32 s5, s1
; GFX6-NEXT:    v_mac_f32_e32 v0, s2, v1
; GFX6-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: s_s_madak_f32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX8-NEXT:    v_mov_b32_e32 v2, 0x41200000
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s3
; GFX8-NEXT:    v_mac_f32_e32 v2, s2, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: s_s_madak_f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v1, 0x41200000
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v2, s3
; GFX9-NEXT:    v_mac_f32_e32 v1, s2, v2
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX10-MAD-LABEL: s_s_madak_f32:
; GFX10-MAD:       ; %bb.0:
; GFX10-MAD-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX10-MAD-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-MAD-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-MAD-NEXT:    v_mov_b32_e32 v0, s3
; GFX10-MAD-NEXT:    v_madak_f32 v0, s2, v0, 0x41200000
; GFX10-MAD-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX10-MAD-NEXT:    s_endpgm
;
; GFX11-MAD-LABEL: s_s_madak_f32:
; GFX11-MAD:       ; %bb.0:
; GFX11-MAD-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-MAD-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-MAD-NEXT:    v_mul_f32_e64 v0, s2, s3
; GFX11-MAD-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-MAD-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_add_f32 v0, 0x41200000, v0
; GFX11-MAD-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11-MAD-NEXT:    s_nop 0
; GFX11-MAD-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-MAD-NEXT:    s_endpgm
;
; GFX940-FMA-LABEL: s_s_madak_f32:
; GFX940-FMA:       ; %bb.0:
; GFX940-FMA-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX940-FMA-NEXT:    v_mov_b32_e32 v1, 0x41200000
; GFX940-FMA-NEXT:    v_mov_b32_e32 v0, 0
; GFX940-FMA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-FMA-NEXT:    v_mov_b32_e32 v2, s3
; GFX940-FMA-NEXT:    v_fmac_f32_e32 v1, s2, v2
; GFX940-FMA-NEXT:    global_store_dword v0, v1, s[0:1] sc0 sc1
; GFX940-FMA-NEXT:    s_endpgm
;
; GFX10-FMA-LABEL: s_s_madak_f32:
; GFX10-FMA:       ; %bb.0:
; GFX10-FMA-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX10-FMA-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-FMA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-FMA-NEXT:    v_mov_b32_e32 v0, s3
; GFX10-FMA-NEXT:    v_fmaak_f32 v0, s2, v0, 0x41200000
; GFX10-FMA-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX10-FMA-NEXT:    s_endpgm
;
; GFX11-FMA-LABEL: s_s_madak_f32:
; GFX11-FMA:       ; %bb.0:
; GFX11-FMA-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-FMA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-FMA-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mov_b32 v0, s3
; GFX11-FMA-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-FMA-NEXT:    v_fmaak_f32 v0, s2, v0, 0x41200000
; GFX11-FMA-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11-FMA-NEXT:    s_nop 0
; GFX11-FMA-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-FMA-NEXT:    s_endpgm
  %mul = fmul float %a, %b
  %madak = fadd float %mul, 10.0
  store float %madak, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @no_madak_src0_modifier_f32(ptr addrspace(1) noalias %out, ptr addrspace(1) noalias %in.a, ptr addrspace(1) noalias %in.b) #0 {
; GFX6-LABEL: no_madak_src0_modifier_f32:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GFX6-NEXT:    s_load_dwordx2 s[8:9], s[0:1], 0xd
; GFX6-NEXT:    s_mov_b32 s3, 0xf000
; GFX6-NEXT:    s_mov_b32 s2, 0
; GFX6-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_mov_b64 s[0:1], s[6:7]
; GFX6-NEXT:    v_mov_b32_e32 v1, 0
; GFX6-NEXT:    s_mov_b64 s[10:11], s[2:3]
; GFX6-NEXT:    buffer_load_dword v2, v[0:1], s[0:3], 0 addr64
; GFX6-NEXT:    buffer_load_dword v3, v[0:1], s[8:11], 0 addr64
; GFX6-NEXT:    s_mov_b32 s0, 0x41200000
; GFX6-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_mad_f32 v2, |v2|, v3, s0
; GFX6-NEXT:    buffer_store_dword v2, v[0:1], s[4:7], 0 addr64
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: no_madak_src0_modifier_f32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 2, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s7
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s6, v4
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_add_u32_e32 v2, vcc, s0, v4
; GFX8-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; GFX8-NEXT:    flat_load_dword v5, v[0:1]
; GFX8-NEXT:    flat_load_dword v2, v[2:3]
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s4, v4
; GFX8-NEXT:    s_mov_b32 s0, 0x41200000
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mad_f32 v2, |v5|, v2, s0
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: no_madak_src0_modifier_f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    s_mov_b32 s0, 0x41200000
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[6:7]
; GFX9-NEXT:    global_load_dword v2, v0, s[2:3]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_mad_f32 v1, |v1|, v2, s0
; GFX9-NEXT:    global_store_dword v0, v1, s[4:5]
; GFX9-NEXT:    s_endpgm
;
; GFX10-MAD-LABEL: no_madak_src0_modifier_f32:
; GFX10-MAD:       ; %bb.0:
; GFX10-MAD-NEXT:    s_clause 0x1
; GFX10-MAD-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX10-MAD-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX10-MAD-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-MAD-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-MAD-NEXT:    s_clause 0x1
; GFX10-MAD-NEXT:    global_load_dword v1, v0, s[6:7]
; GFX10-MAD-NEXT:    global_load_dword v2, v0, s[2:3]
; GFX10-MAD-NEXT:    s_waitcnt vmcnt(0)
; GFX10-MAD-NEXT:    v_mad_f32 v1, |v1|, v2, 0x41200000
; GFX10-MAD-NEXT:    global_store_dword v0, v1, s[4:5]
; GFX10-MAD-NEXT:    s_endpgm
;
; GFX11-MAD-LABEL: no_madak_src0_modifier_f32:
; GFX11-MAD:       ; %bb.0:
; GFX11-MAD-NEXT:    s_clause 0x1
; GFX11-MAD-NEXT:    s_load_b128 s[4:7], s[0:1], 0x24
; GFX11-MAD-NEXT:    s_load_b64 s[0:1], s[0:1], 0x34
; GFX11-MAD-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-MAD-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-MAD-NEXT:    s_clause 0x1
; GFX11-MAD-NEXT:    global_load_b32 v1, v0, s[6:7]
; GFX11-MAD-NEXT:    global_load_b32 v2, v0, s[0:1]
; GFX11-MAD-NEXT:    s_waitcnt vmcnt(0)
; GFX11-MAD-NEXT:    v_mul_f32_e64 v1, |v1|, v2
; GFX11-MAD-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-MAD-NEXT:    v_add_f32_e32 v1, 0x41200000, v1
; GFX11-MAD-NEXT:    global_store_b32 v0, v1, s[4:5]
; GFX11-MAD-NEXT:    s_nop 0
; GFX11-MAD-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-MAD-NEXT:    s_endpgm
;
; GFX940-FMA-LABEL: no_madak_src0_modifier_f32:
; GFX940-FMA:       ; %bb.0:
; GFX940-FMA-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX940-FMA-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX940-FMA-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX940-FMA-NEXT:    s_mov_b32 s0, 0x41200000
; GFX940-FMA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-FMA-NEXT:    global_load_dword v1, v0, s[6:7]
; GFX940-FMA-NEXT:    global_load_dword v2, v0, s[2:3]
; GFX940-FMA-NEXT:    s_waitcnt vmcnt(0)
; GFX940-FMA-NEXT:    v_fma_f32 v1, |v1|, v2, s0
; GFX940-FMA-NEXT:    global_store_dword v0, v1, s[4:5] sc0 sc1
; GFX940-FMA-NEXT:    s_endpgm
;
; GFX10-FMA-LABEL: no_madak_src0_modifier_f32:
; GFX10-FMA:       ; %bb.0:
; GFX10-FMA-NEXT:    s_clause 0x1
; GFX10-FMA-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX10-FMA-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX10-FMA-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-FMA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-FMA-NEXT:    s_clause 0x1
; GFX10-FMA-NEXT:    global_load_dword v1, v0, s[6:7]
; GFX10-FMA-NEXT:    global_load_dword v2, v0, s[2:3]
; GFX10-FMA-NEXT:    s_waitcnt vmcnt(0)
; GFX10-FMA-NEXT:    v_fma_f32 v1, |v1|, v2, 0x41200000
; GFX10-FMA-NEXT:    global_store_dword v0, v1, s[4:5]
; GFX10-FMA-NEXT:    s_endpgm
;
; GFX11-FMA-LABEL: no_madak_src0_modifier_f32:
; GFX11-FMA:       ; %bb.0:
; GFX11-FMA-NEXT:    s_clause 0x1
; GFX11-FMA-NEXT:    s_load_b128 s[4:7], s[0:1], 0x24
; GFX11-FMA-NEXT:    s_load_b64 s[0:1], s[0:1], 0x34
; GFX11-FMA-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-FMA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-FMA-NEXT:    s_clause 0x1
; GFX11-FMA-NEXT:    global_load_b32 v1, v0, s[6:7]
; GFX11-FMA-NEXT:    global_load_b32 v2, v0, s[0:1]
; GFX11-FMA-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FMA-NEXT:    v_fma_f32 v1, |v1|, v2, 0x41200000
; GFX11-FMA-NEXT:    global_store_b32 v0, v1, s[4:5]
; GFX11-FMA-NEXT:    s_nop 0
; GFX11-FMA-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-FMA-NEXT:    s_endpgm
  %tid = tail call i32 @llvm.amdgcn.workitem.id.x() nounwind readnone
  %in.a.gep = getelementptr float, ptr addrspace(1) %in.a, i32 %tid
  %in.b.gep = getelementptr float, ptr addrspace(1) %in.b, i32 %tid
  %out.gep = getelementptr float, ptr addrspace(1) %out, i32 %tid

  %a = load float, ptr addrspace(1) %in.a.gep, align 4
  %b = load float, ptr addrspace(1) %in.b.gep, align 4

  %a.fabs = call float @llvm.fabs.f32(float %a) nounwind readnone

  %mul = fmul float %a.fabs, %b
  %madak = fadd float %mul, 10.0
  store float %madak, ptr addrspace(1) %out.gep, align 4
  ret void
}

define amdgpu_kernel void @no_madak_src1_modifier_f32(ptr addrspace(1) noalias %out, ptr addrspace(1) noalias %in.a, ptr addrspace(1) noalias %in.b) #0 {
; GFX6-LABEL: no_madak_src1_modifier_f32:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GFX6-NEXT:    s_load_dwordx2 s[8:9], s[0:1], 0xd
; GFX6-NEXT:    s_mov_b32 s3, 0xf000
; GFX6-NEXT:    s_mov_b32 s2, 0
; GFX6-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_mov_b64 s[0:1], s[6:7]
; GFX6-NEXT:    v_mov_b32_e32 v1, 0
; GFX6-NEXT:    s_mov_b64 s[10:11], s[2:3]
; GFX6-NEXT:    buffer_load_dword v2, v[0:1], s[0:3], 0 addr64
; GFX6-NEXT:    buffer_load_dword v3, v[0:1], s[8:11], 0 addr64
; GFX6-NEXT:    s_mov_b32 s0, 0x41200000
; GFX6-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_mad_f32 v2, v2, |v3|, s0
; GFX6-NEXT:    buffer_store_dword v2, v[0:1], s[4:7], 0 addr64
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: no_madak_src1_modifier_f32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 2, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s7
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s6, v4
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_add_u32_e32 v2, vcc, s0, v4
; GFX8-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; GFX8-NEXT:    flat_load_dword v5, v[0:1]
; GFX8-NEXT:    flat_load_dword v2, v[2:3]
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s4, v4
; GFX8-NEXT:    s_mov_b32 s0, 0x41200000
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mad_f32 v2, v5, |v2|, s0
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: no_madak_src1_modifier_f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    s_mov_b32 s0, 0x41200000
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[6:7]
; GFX9-NEXT:    global_load_dword v2, v0, s[2:3]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_mad_f32 v1, v1, |v2|, s0
; GFX9-NEXT:    global_store_dword v0, v1, s[4:5]
; GFX9-NEXT:    s_endpgm
;
; GFX10-MAD-LABEL: no_madak_src1_modifier_f32:
; GFX10-MAD:       ; %bb.0:
; GFX10-MAD-NEXT:    s_clause 0x1
; GFX10-MAD-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX10-MAD-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX10-MAD-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-MAD-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-MAD-NEXT:    s_clause 0x1
; GFX10-MAD-NEXT:    global_load_dword v1, v0, s[6:7]
; GFX10-MAD-NEXT:    global_load_dword v2, v0, s[2:3]
; GFX10-MAD-NEXT:    s_waitcnt vmcnt(0)
; GFX10-MAD-NEXT:    v_mad_f32 v1, v1, |v2|, 0x41200000
; GFX10-MAD-NEXT:    global_store_dword v0, v1, s[4:5]
; GFX10-MAD-NEXT:    s_endpgm
;
; GFX11-MAD-LABEL: no_madak_src1_modifier_f32:
; GFX11-MAD:       ; %bb.0:
; GFX11-MAD-NEXT:    s_clause 0x1
; GFX11-MAD-NEXT:    s_load_b128 s[4:7], s[0:1], 0x24
; GFX11-MAD-NEXT:    s_load_b64 s[0:1], s[0:1], 0x34
; GFX11-MAD-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-MAD-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-MAD-NEXT:    s_clause 0x1
; GFX11-MAD-NEXT:    global_load_b32 v1, v0, s[6:7]
; GFX11-MAD-NEXT:    global_load_b32 v2, v0, s[0:1]
; GFX11-MAD-NEXT:    s_waitcnt vmcnt(0)
; GFX11-MAD-NEXT:    v_mul_f32_e64 v1, v1, |v2|
; GFX11-MAD-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-MAD-NEXT:    v_add_f32_e32 v1, 0x41200000, v1
; GFX11-MAD-NEXT:    global_store_b32 v0, v1, s[4:5]
; GFX11-MAD-NEXT:    s_nop 0
; GFX11-MAD-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-MAD-NEXT:    s_endpgm
;
; GFX940-FMA-LABEL: no_madak_src1_modifier_f32:
; GFX940-FMA:       ; %bb.0:
; GFX940-FMA-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX940-FMA-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX940-FMA-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX940-FMA-NEXT:    s_mov_b32 s0, 0x41200000
; GFX940-FMA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-FMA-NEXT:    global_load_dword v1, v0, s[6:7]
; GFX940-FMA-NEXT:    global_load_dword v2, v0, s[2:3]
; GFX940-FMA-NEXT:    s_waitcnt vmcnt(0)
; GFX940-FMA-NEXT:    v_fma_f32 v1, v1, |v2|, s0
; GFX940-FMA-NEXT:    global_store_dword v0, v1, s[4:5] sc0 sc1
; GFX940-FMA-NEXT:    s_endpgm
;
; GFX10-FMA-LABEL: no_madak_src1_modifier_f32:
; GFX10-FMA:       ; %bb.0:
; GFX10-FMA-NEXT:    s_clause 0x1
; GFX10-FMA-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX10-FMA-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX10-FMA-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-FMA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-FMA-NEXT:    s_clause 0x1
; GFX10-FMA-NEXT:    global_load_dword v1, v0, s[6:7]
; GFX10-FMA-NEXT:    global_load_dword v2, v0, s[2:3]
; GFX10-FMA-NEXT:    s_waitcnt vmcnt(0)
; GFX10-FMA-NEXT:    v_fma_f32 v1, v1, |v2|, 0x41200000
; GFX10-FMA-NEXT:    global_store_dword v0, v1, s[4:5]
; GFX10-FMA-NEXT:    s_endpgm
;
; GFX11-FMA-LABEL: no_madak_src1_modifier_f32:
; GFX11-FMA:       ; %bb.0:
; GFX11-FMA-NEXT:    s_clause 0x1
; GFX11-FMA-NEXT:    s_load_b128 s[4:7], s[0:1], 0x24
; GFX11-FMA-NEXT:    s_load_b64 s[0:1], s[0:1], 0x34
; GFX11-FMA-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-FMA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-FMA-NEXT:    s_clause 0x1
; GFX11-FMA-NEXT:    global_load_b32 v1, v0, s[6:7]
; GFX11-FMA-NEXT:    global_load_b32 v2, v0, s[0:1]
; GFX11-FMA-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FMA-NEXT:    v_fma_f32 v1, v1, |v2|, 0x41200000
; GFX11-FMA-NEXT:    global_store_b32 v0, v1, s[4:5]
; GFX11-FMA-NEXT:    s_nop 0
; GFX11-FMA-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-FMA-NEXT:    s_endpgm
  %tid = tail call i32 @llvm.amdgcn.workitem.id.x() nounwind readnone
  %in.a.gep = getelementptr float, ptr addrspace(1) %in.a, i32 %tid
  %in.b.gep = getelementptr float, ptr addrspace(1) %in.b, i32 %tid
  %out.gep = getelementptr float, ptr addrspace(1) %out, i32 %tid

  %a = load float, ptr addrspace(1) %in.a.gep, align 4
  %b = load float, ptr addrspace(1) %in.b.gep, align 4

  %b.fabs = call float @llvm.fabs.f32(float %b) nounwind readnone

  %mul = fmul float %a, %b.fabs
  %madak = fadd float %mul, 10.0
  store float %madak, ptr addrspace(1) %out.gep, align 4
  ret void
}

; SIFoldOperands should not fold the SGPR copy into the instruction before GFX10
; because the implicit immediate already uses the constant bus.
; On GFX10+ we can use two scalar operands.
define amdgpu_kernel void @madak_constant_bus_violation(i32 %arg1, [8 x i32], float %sgpr0, float %sgpr1) #0 {
; GFX6-LABEL: madak_constant_bus_violation:
; GFX6:       ; %bb.0: ; %bb
; GFX6-NEXT:    s_load_dword s2, s[0:1], 0x9
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_cmp_lg_u32 s2, 0
; GFX6-NEXT:    s_cbranch_scc1 .LBB9_2
; GFX6-NEXT:  ; %bb.1: ; %bb3
; GFX6-NEXT:    s_mov_b32 s3, 0xf000
; GFX6-NEXT:    s_mov_b32 s2, -1
; GFX6-NEXT:    v_mov_b32_e32 v0, 0
; GFX6-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:  .LBB9_2: ; %bb4
; GFX6-NEXT:    s_mov_b32 s3, 0xf000
; GFX6-NEXT:    s_mov_b32 s2, -1
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    buffer_load_dword v0, off, s[0:3], 0 glc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    s_load_dword s0, s[0:1], 0x12
; GFX6-NEXT:    v_mov_b32_e32 v1, 0x42280000
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mac_f32_e64 v1, s0, 0.5
; GFX6-NEXT:    v_mul_f32_e32 v0, v1, v0
; GFX6-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: madak_constant_bus_violation:
; GFX8:       ; %bb.0: ; %bb
; GFX8-NEXT:    s_load_dword s2, s[0:1], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_cmp_lg_u32 s2, 0
; GFX8-NEXT:    s_cbranch_scc1 .LBB9_2
; GFX8-NEXT:  ; %bb.1: ; %bb3
; GFX8-NEXT:    v_mov_b32_e32 v0, 0
; GFX8-NEXT:    flat_store_dword v[0:1], v0
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:  .LBB9_2: ; %bb4
; GFX8-NEXT:    flat_load_dword v0, v[0:1] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    s_load_dword s0, s[0:1], 0x48
; GFX8-NEXT:    v_mov_b32_e32 v1, 0x42280000
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mac_f32_e64 v1, s0, 0.5
; GFX8-NEXT:    v_mul_f32_e32 v0, v1, v0
; GFX8-NEXT:    flat_store_dword v[0:1], v0
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: madak_constant_bus_violation:
; GFX9:       ; %bb.0: ; %bb
; GFX9-NEXT:    s_load_dword s2, s[0:1], 0x24
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s2, 0
; GFX9-NEXT:    s_cbranch_scc1 .LBB9_2
; GFX9-NEXT:  ; %bb.1: ; %bb3
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    global_store_dword v[0:1], v0, off
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:  .LBB9_2: ; %bb4
; GFX9-NEXT:    global_load_dword v0, v[0:1], off glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_load_dword s0, s[0:1], 0x48
; GFX9-NEXT:    v_mov_b32_e32 v1, 0x42280000
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mac_f32_e64 v1, s0, 0.5
; GFX9-NEXT:    v_mul_f32_e32 v0, v1, v0
; GFX9-NEXT:    global_store_dword v[0:1], v0, off
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_endpgm
;
; GFX10-MAD-LABEL: madak_constant_bus_violation:
; GFX10-MAD:       ; %bb.0: ; %bb
; GFX10-MAD-NEXT:    s_load_dword s2, s[0:1], 0x24
; GFX10-MAD-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-MAD-NEXT:    s_cmp_lg_u32 s2, 0
; GFX10-MAD-NEXT:    s_cbranch_scc1 .LBB9_2
; GFX10-MAD-NEXT:  ; %bb.1: ; %bb3
; GFX10-MAD-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-MAD-NEXT:    global_store_dword v[0:1], v0, off
; GFX10-MAD-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-MAD-NEXT:  .LBB9_2: ; %bb4
; GFX10-MAD-NEXT:    global_load_dword v0, v[0:1], off glc dlc
; GFX10-MAD-NEXT:    s_waitcnt vmcnt(0)
; GFX10-MAD-NEXT:    s_load_dword s0, s[0:1], 0x48
; GFX10-MAD-NEXT:    v_mov_b32_e32 v1, 0.5
; GFX10-MAD-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-MAD-NEXT:    v_madak_f32 v1, s0, v1, 0x42280000
; GFX10-MAD-NEXT:    v_mul_f32_e32 v0, v1, v0
; GFX10-MAD-NEXT:    global_store_dword v[0:1], v0, off
; GFX10-MAD-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-MAD-NEXT:    s_endpgm
;
; GFX11-MAD-LABEL: madak_constant_bus_violation:
; GFX11-MAD:       ; %bb.0: ; %bb
; GFX11-MAD-NEXT:    s_load_b32 s2, s[0:1], 0x24
; GFX11-MAD-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-MAD-NEXT:    s_cmp_lg_u32 s2, 0
; GFX11-MAD-NEXT:    s_cbranch_scc1 .LBB9_2
; GFX11-MAD-NEXT:  ; %bb.1: ; %bb3
; GFX11-MAD-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-MAD-NEXT:    global_store_b32 v[0:1], v0, off dlc
; GFX11-MAD-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-MAD-NEXT:  .LBB9_2: ; %bb4
; GFX11-MAD-NEXT:    global_load_b32 v0, v[0:1], off glc dlc
; GFX11-MAD-NEXT:    s_waitcnt vmcnt(0)
; GFX11-MAD-NEXT:    s_load_b32 s0, s[0:1], 0x48
; GFX11-MAD-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-MAD-NEXT:    v_mul_f32_e64 v1, s0, 0.5
; GFX11-MAD-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-MAD-NEXT:    v_add_f32_e32 v1, 0x42280000, v1
; GFX11-MAD-NEXT:    v_mul_f32_e32 v0, v1, v0
; GFX11-MAD-NEXT:    global_store_b32 v[0:1], v0, off dlc
; GFX11-MAD-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-MAD-NEXT:    s_nop 0
; GFX11-MAD-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-MAD-NEXT:    s_endpgm
;
; GFX940-FMA-LABEL: madak_constant_bus_violation:
; GFX940-FMA:       ; %bb.0: ; %bb
; GFX940-FMA-NEXT:    s_load_dword s2, s[0:1], 0x24
; GFX940-FMA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-FMA-NEXT:    s_cmp_lg_u32 s2, 0
; GFX940-FMA-NEXT:    s_cbranch_scc1 .LBB9_2
; GFX940-FMA-NEXT:  ; %bb.1: ; %bb3
; GFX940-FMA-NEXT:    v_mov_b32_e32 v0, 0
; GFX940-FMA-NEXT:    global_store_dword v[0:1], v0, off sc0 sc1
; GFX940-FMA-NEXT:    s_waitcnt vmcnt(0)
; GFX940-FMA-NEXT:  .LBB9_2: ; %bb4
; GFX940-FMA-NEXT:    global_load_dword v0, v[0:1], off sc0 sc1
; GFX940-FMA-NEXT:    s_waitcnt vmcnt(0)
; GFX940-FMA-NEXT:    s_load_dword s0, s[0:1], 0x48
; GFX940-FMA-NEXT:    v_mov_b32_e32 v1, 0x42280000
; GFX940-FMA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-FMA-NEXT:    v_fmac_f32_e64 v1, s0, 0.5
; GFX940-FMA-NEXT:    v_mul_f32_e32 v0, v1, v0
; GFX940-FMA-NEXT:    global_store_dword v[0:1], v0, off sc0 sc1
; GFX940-FMA-NEXT:    s_waitcnt vmcnt(0)
; GFX940-FMA-NEXT:    s_endpgm
;
; GFX10-FMA-LABEL: madak_constant_bus_violation:
; GFX10-FMA:       ; %bb.0: ; %bb
; GFX10-FMA-NEXT:    s_load_dword s2, s[0:1], 0x24
; GFX10-FMA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-FMA-NEXT:    s_cmp_lg_u32 s2, 0
; GFX10-FMA-NEXT:    s_cbranch_scc1 .LBB9_2
; GFX10-FMA-NEXT:  ; %bb.1: ; %bb3
; GFX10-FMA-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-FMA-NEXT:    global_store_dword v[0:1], v0, off
; GFX10-FMA-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-FMA-NEXT:  .LBB9_2: ; %bb4
; GFX10-FMA-NEXT:    global_load_dword v0, v[0:1], off glc dlc
; GFX10-FMA-NEXT:    s_waitcnt vmcnt(0)
; GFX10-FMA-NEXT:    s_load_dword s0, s[0:1], 0x48
; GFX10-FMA-NEXT:    v_mov_b32_e32 v1, 0.5
; GFX10-FMA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-FMA-NEXT:    v_fmaak_f32 v1, s0, v1, 0x42280000
; GFX10-FMA-NEXT:    v_mul_f32_e32 v0, v1, v0
; GFX10-FMA-NEXT:    global_store_dword v[0:1], v0, off
; GFX10-FMA-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-FMA-NEXT:    s_endpgm
;
; GFX11-FMA-LABEL: madak_constant_bus_violation:
; GFX11-FMA:       ; %bb.0: ; %bb
; GFX11-FMA-NEXT:    s_load_b32 s2, s[0:1], 0x24
; GFX11-FMA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-FMA-NEXT:    s_cmp_lg_u32 s2, 0
; GFX11-FMA-NEXT:    s_cbranch_scc1 .LBB9_2
; GFX11-FMA-NEXT:  ; %bb.1: ; %bb3
; GFX11-FMA-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-FMA-NEXT:    global_store_b32 v[0:1], v0, off dlc
; GFX11-FMA-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-FMA-NEXT:  .LBB9_2: ; %bb4
; GFX11-FMA-NEXT:    global_load_b32 v0, v[0:1], off glc dlc
; GFX11-FMA-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FMA-NEXT:    s_load_b32 s0, s[0:1], 0x48
; GFX11-FMA-NEXT:    v_mov_b32_e32 v1, 0.5
; GFX11-FMA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-FMA-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FMA-NEXT:    v_fmaak_f32 v1, s0, v1, 0x42280000
; GFX11-FMA-NEXT:    v_mul_f32_e32 v0, v1, v0
; GFX11-FMA-NEXT:    global_store_b32 v[0:1], v0, off dlc
; GFX11-FMA-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-FMA-NEXT:    s_nop 0
; GFX11-FMA-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-FMA-NEXT:    s_endpgm
bb:
  %tmp = icmp eq i32 %arg1, 0
  br i1 %tmp, label %bb3, label %bb4

bb3:
  store volatile float 0.0, ptr addrspace(1) undef
  br label %bb4

bb4:
  %vgpr = load volatile float, ptr addrspace(1) undef
  %tmp0 = fmul float %sgpr0, 0.5
  %tmp1 = fadd float %tmp0, 42.0
  %tmp2 = fmul float %tmp1, %vgpr
  store volatile float %tmp2, ptr addrspace(1) undef, align 4
  ret void
}

attributes #0 = { nounwind "denormal-fp-math-f32"="preserve-sign,preserve-sign" }
