; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=amdgcn -mcpu=gfx1010 -mattr=-wavefrontsize32,+wavefrontsize64 -verify-machineinstrs < %s | FileCheck -check-prefix=GFX10 %s

; The test was originally written to spill an SGPR to scratch without having spare SGPRs
; available to save exec. This scenario won't be true anymore as we reseve SGPR(s)
; upfront for saving exec.

define amdgpu_kernel void @test() #1 {
; GFX10-LABEL: test:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX10-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX10-NEXT:    s_mov_b32 s10, -1
; GFX10-NEXT:    s_mov_b32 s11, 0x31e16000
; GFX10-NEXT:    s_add_u32 s8, s8, s1
; GFX10-NEXT:    s_addc_u32 s9, s9, 0
; GFX10-NEXT:    ;;#ASMSTART
; GFX10-NEXT:    ; def s[0:7]
; GFX10-NEXT:    ;;#ASMEND
; GFX10-NEXT:    ;;#ASMSTART
; GFX10-NEXT:    ; def s[8:12]
; GFX10-NEXT:    ;;#ASMEND
; GFX10-NEXT:    ;;#ASMSTART
; GFX10-NEXT:    ;;#ASMEND
; GFX10-NEXT:    ;;#ASMSTART
; GFX10-NEXT:    ; use s[0:7]
; GFX10-NEXT:    ;;#ASMEND
; GFX10-NEXT:    ;;#ASMSTART
; GFX10-NEXT:    ; use s[8:12]
; GFX10-NEXT:    ;;#ASMEND
; GFX10-NEXT:    s_endpgm
  %wide.sgpr0 = call <8 x i32> asm sideeffect "; def $0", "={s[0:7]}" () #0
  %wide.sgpr2 = call <5 x i32> asm sideeffect "; def $0", "={s[8:12]}" () #0
  call void asm sideeffect "", "~{v[0:7]}" () #0
  call void asm sideeffect "; use $0", "s"(<8 x i32> %wide.sgpr0) #0
  call void asm sideeffect "; use $0", "s"(<5 x i32> %wide.sgpr2) #0
  ret void
}

attributes #0 = { nounwind }
attributes #1 = { nounwind "amdgpu-num-sgpr"="16" "amdgpu-num-vgpr"="8" }
