; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs < %s | FileCheck %s

target datalayout = "E-m:a-i64:64-n32:64-S128-v256:256:256-v512:512:512"
target triple = "powerpc64-ibm-aix7.2.0.0"

%struct.USST = type { i16, i16 }
%struct.SST = type { i16, i16 }
%struct.CST = type { i8, i8 }
%struct.SCST = type { i8, i8 }
%struct.ST = type { i32, i32 }
%struct.UST = type { i32, i32 }
%struct.LST = type { i64, i64 }
%struct.ULST = type { i64, i64 }

; Function Attrs: nounwind
define zeroext i32 @ustc1(ptr noundef byval(%struct.USST) align 8 %s) {
; CHECK-LABEL: ustc1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mr 4, 3
; CHECK-NEXT:    rldicl 3, 3, 8, 56
; CHECK-NEXT:    std 4, 48(1)
; CHECK-NEXT:    blr
entry:
  %0 = load i16, ptr %s, align 8
  %conv = zext i16 %0 to i32
  %shr = ashr i32 %conv, 8
  ret i32 %shr
}

; Function Attrs: nounwind
define zeroext i32 @ustc2(ptr noundef byval(%struct.USST) align 8 %s) {
; CHECK-LABEL: ustc2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mr 4, 3
; CHECK-NEXT:    rldicl 3, 3, 16, 48
; CHECK-NEXT:    std 4, 48(1)
; CHECK-NEXT:    blr
entry:
  %0 = load i16, ptr %s, align 8
  %conv = zext i16 %0 to i32
  ret i32 %conv
}

; Function Attrs: nounwind
define signext i32 @stc1(ptr noundef byval(%struct.SST) align 8 %s) {
; CHECK-LABEL: stc1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mr 4, 3
; CHECK-NEXT:    rldicl 3, 3, 16, 48
; CHECK-NEXT:    std 4, 48(1)
; CHECK-NEXT:    extsh 3, 3
; CHECK-NEXT:    srawi 3, 3, 8
; CHECK-NEXT:    blr
entry:
  %0 = load i16, ptr %s, align 8
  %conv = sext i16 %0 to i32
  %shr = ashr i32 %conv, 8
  ret i32 %shr
}

; Function Attrs: nounwind
define signext i32 @stc2(ptr noundef byval(%struct.SST) align 8 %s) {
; CHECK-LABEL: stc2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mr 4, 3
; CHECK-NEXT:    sradi 3, 3, 48
; CHECK-NEXT:    std 4, 48(1)
; CHECK-NEXT:    blr
entry:
  %0 = load i16, ptr %s, align 8
  %conv = sext i16 %0 to i32
  ret i32 %conv
}

; Function Attrs: nounwind
define signext i32 @ctc(ptr noundef byval(%struct.CST) align 8 %s) {
; CHECK-LABEL: ctc:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mr 4, 3
; CHECK-NEXT:    rldicl 3, 3, 8, 56
; CHECK-NEXT:    std 4, 48(1)
; CHECK-NEXT:    blr
entry:
  %0 = load i8, ptr %s, align 8
  %conv = zext i8 %0 to i32
  ret i32 %conv
}

; Function Attrs: nounwind
define signext i32 @sctc(ptr noundef byval(%struct.SCST) align 8 %s) {
; CHECK-LABEL: sctc:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mr 4, 3
; CHECK-NEXT:    sradi 3, 3, 56
; CHECK-NEXT:    std 4, 48(1)
; CHECK-NEXT:    blr
entry:
  %0 = load i8, ptr %s, align 8
  %conv = sext i8 %0 to i32
  ret i32 %conv
}

; Function Attrs: nounwind
define signext i32 @tc44(ptr noundef byval(%struct.ST) align 8 %s) {
; CHECK-LABEL: tc44:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mr 4, 3
; CHECK-NEXT:    sradi 3, 3, 32
; CHECK-NEXT:    std 4, 48(1)
; CHECK-NEXT:    blr
entry:
  %0 = load i32, ptr %s, align 8
  ret i32 %0
}

; Function Attrs: nounwind
define signext i32 @tc41(ptr noundef byval(%struct.ST) align 8 %s) {
; CHECK-LABEL: tc41:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mr 4, 3
; CHECK-NEXT:    sradi 3, 3, 56
; CHECK-NEXT:    std 4, 48(1)
; CHECK-NEXT:    blr
entry:
  %0 = load i32, ptr %s, align 8
  %shr = ashr i32 %0, 24
  ret i32 %shr
}

; Function Attrs: nounwind
define signext i32 @tc42(ptr noundef byval(%struct.ST) align 8 %s) {
; CHECK-LABEL: tc42:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mr 4, 3
; CHECK-NEXT:    sradi 3, 3, 48
; CHECK-NEXT:    std 4, 48(1)
; CHECK-NEXT:    blr
entry:
  %0 = load i32, ptr %s, align 8
  %shr = ashr i32 %0, 16
  ret i32 %shr
}

; Function Attrs: nounwind
define signext i32 @tc43(ptr noundef byval(%struct.ST) align 8 %s) {
; CHECK-LABEL: tc43:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mr 4, 3
; CHECK-NEXT:    sradi 3, 3, 40
; CHECK-NEXT:    std 4, 48(1)
; CHECK-NEXT:    blr
entry:
  %0 = load i32, ptr %s, align 8
  %shr = ashr i32 %0, 8
  ret i32 %shr
}

; Function Attrs: nounwind
define zeroext i32 @utc44(ptr noundef byval(%struct.UST) align 8 %s) #0 {
; CHECK-LABEL: utc44:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mr 4, 3
; CHECK-NEXT:    rldicl 3, 3, 32, 32
; CHECK-NEXT:    std 4, 48(1)
; CHECK-NEXT:    blr
entry:
  %0 = load i32, ptr %s, align 8
  ret i32 %0
}

; Function Attrs: nounwind
define zeroext i32 @utc41(ptr noundef byval(%struct.UST) align 8 %s) {
; CHECK-LABEL: utc41:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mr 4, 3
; CHECK-NEXT:    rldicl 3, 3, 8, 56
; CHECK-NEXT:    std 4, 48(1)
; CHECK-NEXT:    blr
entry:
  %0 = load i32, ptr %s, align 8
  %shr = lshr i32 %0, 24
  ret i32 %shr
}

; Function Attrs: nounwind
define zeroext i32 @utc42(ptr noundef byval(%struct.UST) align 8 %s) {
; CHECK-LABEL: utc42:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mr 4, 3
; CHECK-NEXT:    rldicl 3, 3, 16, 48
; CHECK-NEXT:    std 4, 48(1)
; CHECK-NEXT:    blr
entry:
  %0 = load i32, ptr %s, align 8
  %shr = lshr i32 %0, 16
  ret i32 %shr
}

; Function Attrs: nounwind
define zeroext i32 @utc43(ptr noundef byval(%struct.UST) align 8 %s) {
; CHECK-LABEL: utc43:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mr 4, 3
; CHECK-NEXT:    rldicl 3, 3, 24, 40
; CHECK-NEXT:    std 4, 48(1)
; CHECK-NEXT:    blr
entry:
  %0 = load i32, ptr %s, align 8
  %shr = lshr i32 %0, 8
  ret i32 %shr
}

; Function Attrs: nounwind
define i64 @ltc88(ptr noundef byval(%struct.LST) align 8 %s) {
; CHECK-LABEL: ltc88:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mr 5, 3
; CHECK-NEXT:    sradi 3, 3, 8
; CHECK-NEXT:    std 5, 48(1)
; CHECK-NEXT:    std 4, 56(1)
; CHECK-NEXT:    blr
entry:
  %0 = load i64, ptr %s, align 8
  %shr = ashr i64 %0, 8
  ret i64 %shr
}

; Function Attrs: nounwind
define i64 @ltc86(ptr noundef byval(%struct.LST) align 8 %s) {
; CHECK-LABEL: ltc86:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mr 5, 3
; CHECK-NEXT:    sradi 3, 3, 16
; CHECK-NEXT:    std 5, 48(1)
; CHECK-NEXT:    std 4, 56(1)
; CHECK-NEXT:    blr
entry:
  %0 = load i64, ptr %s, align 8
  %shr = ashr i64 %0, 16
  ret i64 %shr
}

; Function Attrs: nounwind
define i64 @ltc85(ptr noundef byval(%struct.LST) align 8 %s) {
; CHECK-LABEL: ltc85:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mr 5, 3
; CHECK-NEXT:    sradi 3, 3, 24
; CHECK-NEXT:    std 5, 48(1)
; CHECK-NEXT:    std 4, 56(1)
; CHECK-NEXT:    blr
entry:
  %0 = load i64, ptr %s, align 8
  %shr = ashr i64 %0, 24
  ret i64 %shr
}

; Function Attrs: nounwind
define i64 @ltc84(ptr noundef byval(%struct.LST) align 8 %s) {
; CHECK-LABEL: ltc84:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mr 5, 3
; CHECK-NEXT:    sradi 3, 3, 32
; CHECK-NEXT:    std 5, 48(1)
; CHECK-NEXT:    std 4, 56(1)
; CHECK-NEXT:    blr
entry:
  %0 = load i64, ptr %s, align 8
  %shr = ashr i64 %0, 32
  ret i64 %shr
}

; Function Attrs: nounwind
define i64 @ltc83(ptr noundef byval(%struct.LST) align 8 %s) {
; CHECK-LABEL: ltc83:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mr 5, 3
; CHECK-NEXT:    sradi 3, 3, 40
; CHECK-NEXT:    std 5, 48(1)
; CHECK-NEXT:    std 4, 56(1)
; CHECK-NEXT:    blr
entry:
  %0 = load i64, ptr %s, align 8
  %shr = ashr i64 %0, 40
  ret i64 %shr
}

; Function Attrs: nounwind
define i64 @ltc82(ptr noundef byval(%struct.LST) align 8 %s) {
; CHECK-LABEL: ltc82:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mr 5, 3
; CHECK-NEXT:    sradi 3, 3, 48
; CHECK-NEXT:    std 5, 48(1)
; CHECK-NEXT:    std 4, 56(1)
; CHECK-NEXT:    blr
entry:
  %0 = load i64, ptr %s, align 8
  %shr = ashr i64 %0, 48
  ret i64 %shr
}

; Function Attrs: nounwind
define i64 @ltc81(ptr noundef byval(%struct.LST) align 8 %s) {
; CHECK-LABEL: ltc81:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mr 5, 3
; CHECK-NEXT:    sradi 3, 3, 56
; CHECK-NEXT:    std 5, 48(1)
; CHECK-NEXT:    std 4, 56(1)
; CHECK-NEXT:    blr
entry:
  %0 = load i64, ptr %s, align 8
  %shr = ashr i64 %0, 56
  ret i64 %shr
}

; Function Attrs: nounwind
define i64 @ultc88(ptr noundef byval(%struct.ULST) align 8 %s) {
; CHECK-LABEL: ultc88:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    std 3, 48(1)
; CHECK-NEXT:    std 4, 56(1)
; CHECK-NEXT:    blr
entry:
  %0 = load i64, ptr %s, align 8
  ret i64 %0
}

; Function Attrs: nounwind
define i64 @ultc87(ptr noundef byval(%struct.ULST) align 8 %s) {
; CHECK-LABEL: ultc87:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mr 5, 3
; CHECK-NEXT:    rldicl 3, 3, 56, 8
; CHECK-NEXT:    std 5, 48(1)
; CHECK-NEXT:    std 4, 56(1)
; CHECK-NEXT:    blr
entry:
  %0 = load i64, ptr %s, align 8
  %shr = lshr i64 %0, 8
  ret i64 %shr
}

; Function Attrs: nounwind
define i64 @ultc86(ptr noundef byval(%struct.ULST) align 8 %s) {
; CHECK-LABEL: ultc86:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mr 5, 3
; CHECK-NEXT:    rldicl 3, 3, 48, 16
; CHECK-NEXT:    std 5, 48(1)
; CHECK-NEXT:    std 4, 56(1)
; CHECK-NEXT:    blr
entry:
  %0 = load i64, ptr %s, align 8
  %shr = lshr i64 %0, 16
  ret i64 %shr
}

; Function Attrs: nounwind
define i64 @ultc85(ptr noundef byval(%struct.ULST) align 8 %s) {
; CHECK-LABEL: ultc85:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mr 5, 3
; CHECK-NEXT:    rldicl 3, 3, 40, 24
; CHECK-NEXT:    std 5, 48(1)
; CHECK-NEXT:    std 4, 56(1)
; CHECK-NEXT:    blr
entry:
  %0 = load i64, ptr %s, align 8
  %shr = lshr i64 %0, 24
  ret i64 %shr
}

; Function Attrs: nounwind
define i64 @ultc84(ptr noundef byval(%struct.ULST) align 8 %s) {
; CHECK-LABEL: ultc84:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mr 5, 3
; CHECK-NEXT:    rldicl 3, 3, 32, 32
; CHECK-NEXT:    std 5, 48(1)
; CHECK-NEXT:    std 4, 56(1)
; CHECK-NEXT:    blr
entry:
  %0 = load i64, ptr %s, align 8
  %shr = lshr i64 %0, 32
  ret i64 %shr
}

; Function Attrs: nounwind
define i64 @ultc83(ptr noundef byval(%struct.ULST) align 8 %s) {
; CHECK-LABEL: ultc83:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mr 5, 3
; CHECK-NEXT:    rldicl 3, 3, 24, 40
; CHECK-NEXT:    std 5, 48(1)
; CHECK-NEXT:    std 4, 56(1)
; CHECK-NEXT:    blr
entry:
  %0 = load i64, ptr %s, align 8
  %shr = lshr i64 %0, 40
  ret i64 %shr
}

; Function Attrs: nounwind
define i64 @ultc82(ptr noundef byval(%struct.ULST) align 8 %s) {
; CHECK-LABEL: ultc82:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mr 5, 3
; CHECK-NEXT:    rldicl 3, 3, 16, 48
; CHECK-NEXT:    std 5, 48(1)
; CHECK-NEXT:    std 4, 56(1)
; CHECK-NEXT:    blr
entry:
  %0 = load i64, ptr %s, align 8
  %shr = lshr i64 %0, 48
  ret i64 %shr
}

; Function Attrs: nounwind
define i64 @ultc81(ptr noundef byval(%struct.ULST) align 8 %s) {
; CHECK-LABEL: ultc81:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mr 5, 3
; CHECK-NEXT:    rldicl 3, 3, 8, 56
; CHECK-NEXT:    std 5, 48(1)
; CHECK-NEXT:    std 4, 56(1)
; CHECK-NEXT:    blr
entry:
  %0 = load i64, ptr %s, align 8
  %shr = lshr i64 %0, 56
  ret i64 %shr
}
