; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 3
; RUN: llc -mtriple=riscv32 -mattr=+v -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,CHECK-RV32
; RUN: llc -mtriple=riscv64 -mattr=+v -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,CHECK-RV64
; RUN: llc -mtriple=riscv32 -mattr=+v,+zvkb -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK-ZVKB,CHECK-ZVKB32
; RUN: llc -mtriple=riscv64 -mattr=+v,+zvkb -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK-ZVKB,CHECK-ZVKB64

define <vscale x 1 x i8> @vandn_vv_nxv1i8(<vscale x 1 x i8> %x, <vscale x 1 x i8> %y) {
; CHECK-LABEL: vandn_vv_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf8, ta, ma
; CHECK-NEXT:    vnot.v v8, v8
; CHECK-NEXT:    vand.vv v8, v8, v9
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_nxv1i8:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a0, zero, e8, mf8, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v9, v8
; CHECK-ZVKB-NEXT:    ret
  %head = insertelement <vscale x 1 x i8> poison, i8 -1, i32 0
  %splat = shufflevector <vscale x 1 x i8> %head, <vscale x 1 x i8> poison, <vscale x 1 x i32> zeroinitializer
  %a = xor <vscale x 1 x i8> %x, %splat
  %b = and <vscale x 1 x i8> %a, %y
  ret <vscale x 1 x i8> %b
}

define <vscale x 1 x i8> @vandn_vv_swapped_nxv1i8(<vscale x 1 x i8> %x, <vscale x 1 x i8> %y) {
; CHECK-LABEL: vandn_vv_swapped_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf8, ta, ma
; CHECK-NEXT:    vnot.v v8, v8
; CHECK-NEXT:    vand.vv v8, v9, v8
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_swapped_nxv1i8:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a0, zero, e8, mf8, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v9, v8
; CHECK-ZVKB-NEXT:    ret
  %head = insertelement <vscale x 1 x i8> poison, i8 -1, i32 0
  %splat = shufflevector <vscale x 1 x i8> %head, <vscale x 1 x i8> poison, <vscale x 1 x i32> zeroinitializer
  %a = xor <vscale x 1 x i8> %x, %splat
  %b = and <vscale x 1 x i8> %y, %a
  ret <vscale x 1 x i8> %b
}

define <vscale x 1 x i8> @vandn_vx_nxv1i8(i8 %x, <vscale x 1 x i8> %y) {
; CHECK-LABEL: vandn_vx_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    not a0, a0
; CHECK-NEXT:    vsetvli a1, zero, e8, mf8, ta, ma
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vx_nxv1i8:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a1, zero, e8, mf8, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vx v8, v8, a0
; CHECK-ZVKB-NEXT:    ret
  %a = xor i8 %x, -1
  %head = insertelement <vscale x 1 x i8> poison, i8 %a, i32 0
  %splat = shufflevector <vscale x 1 x i8> %head, <vscale x 1 x i8> poison, <vscale x 1 x i32> zeroinitializer
  %b = and <vscale x 1 x i8> %splat, %y
  ret <vscale x 1 x i8> %b
}

define <vscale x 1 x i8> @vandn_vx_swapped_nxv1i8(i8 %x, <vscale x 1 x i8> %y) {
; CHECK-LABEL: vandn_vx_swapped_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    not a0, a0
; CHECK-NEXT:    vsetvli a1, zero, e8, mf8, ta, ma
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vx_swapped_nxv1i8:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a1, zero, e8, mf8, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vx v8, v8, a0
; CHECK-ZVKB-NEXT:    ret
  %a = xor i8 %x, -1
  %head = insertelement <vscale x 1 x i8> poison, i8 %a, i32 0
  %splat = shufflevector <vscale x 1 x i8> %head, <vscale x 1 x i8> poison, <vscale x 1 x i32> zeroinitializer
  %b = and <vscale x 1 x i8> %splat, %y
  ret <vscale x 1 x i8> %b
}

define <vscale x 2 x i8> @vandn_vv_nxv2i8(<vscale x 2 x i8> %x, <vscale x 2 x i8> %y) {
; CHECK-LABEL: vandn_vv_nxv2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf4, ta, ma
; CHECK-NEXT:    vnot.v v8, v8
; CHECK-NEXT:    vand.vv v8, v8, v9
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_nxv2i8:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a0, zero, e8, mf4, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v9, v8
; CHECK-ZVKB-NEXT:    ret
  %head = insertelement <vscale x 2 x i8> poison, i8 -1, i32 0
  %splat = shufflevector <vscale x 2 x i8> %head, <vscale x 2 x i8> poison, <vscale x 2 x i32> zeroinitializer
  %a = xor <vscale x 2 x i8> %x, %splat
  %b = and <vscale x 2 x i8> %a, %y
  ret <vscale x 2 x i8> %b
}

define <vscale x 2 x i8> @vandn_vv_swapped_nxv2i8(<vscale x 2 x i8> %x, <vscale x 2 x i8> %y) {
; CHECK-LABEL: vandn_vv_swapped_nxv2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf4, ta, ma
; CHECK-NEXT:    vnot.v v8, v8
; CHECK-NEXT:    vand.vv v8, v9, v8
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_swapped_nxv2i8:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a0, zero, e8, mf4, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v9, v8
; CHECK-ZVKB-NEXT:    ret
  %head = insertelement <vscale x 2 x i8> poison, i8 -1, i32 0
  %splat = shufflevector <vscale x 2 x i8> %head, <vscale x 2 x i8> poison, <vscale x 2 x i32> zeroinitializer
  %a = xor <vscale x 2 x i8> %x, %splat
  %b = and <vscale x 2 x i8> %y, %a
  ret <vscale x 2 x i8> %b
}

define <vscale x 2 x i8> @vandn_vx_nxv2i8(i8 %x, <vscale x 2 x i8> %y) {
; CHECK-LABEL: vandn_vx_nxv2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    not a0, a0
; CHECK-NEXT:    vsetvli a1, zero, e8, mf4, ta, ma
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vx_nxv2i8:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a1, zero, e8, mf4, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vx v8, v8, a0
; CHECK-ZVKB-NEXT:    ret
  %a = xor i8 %x, -1
  %head = insertelement <vscale x 2 x i8> poison, i8 %a, i32 0
  %splat = shufflevector <vscale x 2 x i8> %head, <vscale x 2 x i8> poison, <vscale x 2 x i32> zeroinitializer
  %b = and <vscale x 2 x i8> %splat, %y
  ret <vscale x 2 x i8> %b
}

define <vscale x 2 x i8> @vandn_vx_swapped_nxv2i8(i8 %x, <vscale x 2 x i8> %y) {
; CHECK-LABEL: vandn_vx_swapped_nxv2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    not a0, a0
; CHECK-NEXT:    vsetvli a1, zero, e8, mf4, ta, ma
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vx_swapped_nxv2i8:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a1, zero, e8, mf4, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vx v8, v8, a0
; CHECK-ZVKB-NEXT:    ret
  %a = xor i8 %x, -1
  %head = insertelement <vscale x 2 x i8> poison, i8 %a, i32 0
  %splat = shufflevector <vscale x 2 x i8> %head, <vscale x 2 x i8> poison, <vscale x 2 x i32> zeroinitializer
  %b = and <vscale x 2 x i8> %splat, %y
  ret <vscale x 2 x i8> %b
}

define <vscale x 4 x i8> @vandn_vv_nxv4i8(<vscale x 4 x i8> %x, <vscale x 4 x i8> %y) {
; CHECK-LABEL: vandn_vv_nxv4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf2, ta, ma
; CHECK-NEXT:    vnot.v v8, v8
; CHECK-NEXT:    vand.vv v8, v8, v9
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_nxv4i8:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a0, zero, e8, mf2, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v9, v8
; CHECK-ZVKB-NEXT:    ret
  %head = insertelement <vscale x 4 x i8> poison, i8 -1, i32 0
  %splat = shufflevector <vscale x 4 x i8> %head, <vscale x 4 x i8> poison, <vscale x 4 x i32> zeroinitializer
  %a = xor <vscale x 4 x i8> %x, %splat
  %b = and <vscale x 4 x i8> %a, %y
  ret <vscale x 4 x i8> %b
}

define <vscale x 4 x i8> @vandn_vv_swapped_nxv4i8(<vscale x 4 x i8> %x, <vscale x 4 x i8> %y) {
; CHECK-LABEL: vandn_vv_swapped_nxv4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf2, ta, ma
; CHECK-NEXT:    vnot.v v8, v8
; CHECK-NEXT:    vand.vv v8, v9, v8
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_swapped_nxv4i8:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a0, zero, e8, mf2, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v9, v8
; CHECK-ZVKB-NEXT:    ret
  %head = insertelement <vscale x 4 x i8> poison, i8 -1, i32 0
  %splat = shufflevector <vscale x 4 x i8> %head, <vscale x 4 x i8> poison, <vscale x 4 x i32> zeroinitializer
  %a = xor <vscale x 4 x i8> %x, %splat
  %b = and <vscale x 4 x i8> %y, %a
  ret <vscale x 4 x i8> %b
}

define <vscale x 4 x i8> @vandn_vx_nxv4i8(i8 %x, <vscale x 4 x i8> %y) {
; CHECK-LABEL: vandn_vx_nxv4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    not a0, a0
; CHECK-NEXT:    vsetvli a1, zero, e8, mf2, ta, ma
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vx_nxv4i8:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a1, zero, e8, mf2, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vx v8, v8, a0
; CHECK-ZVKB-NEXT:    ret
  %a = xor i8 %x, -1
  %head = insertelement <vscale x 4 x i8> poison, i8 %a, i32 0
  %splat = shufflevector <vscale x 4 x i8> %head, <vscale x 4 x i8> poison, <vscale x 4 x i32> zeroinitializer
  %b = and <vscale x 4 x i8> %splat, %y
  ret <vscale x 4 x i8> %b
}

define <vscale x 4 x i8> @vandn_vx_swapped_nxv4i8(i8 %x, <vscale x 4 x i8> %y) {
; CHECK-LABEL: vandn_vx_swapped_nxv4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    not a0, a0
; CHECK-NEXT:    vsetvli a1, zero, e8, mf2, ta, ma
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vx_swapped_nxv4i8:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a1, zero, e8, mf2, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vx v8, v8, a0
; CHECK-ZVKB-NEXT:    ret
  %a = xor i8 %x, -1
  %head = insertelement <vscale x 4 x i8> poison, i8 %a, i32 0
  %splat = shufflevector <vscale x 4 x i8> %head, <vscale x 4 x i8> poison, <vscale x 4 x i32> zeroinitializer
  %b = and <vscale x 4 x i8> %splat, %y
  ret <vscale x 4 x i8> %b
}

define <vscale x 8 x i8> @vandn_vv_nxv8i8(<vscale x 8 x i8> %x, <vscale x 8 x i8> %y) {
; CHECK-LABEL: vandn_vv_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NEXT:    vnot.v v8, v8
; CHECK-NEXT:    vand.vv v8, v8, v9
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_nxv8i8:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v9, v8
; CHECK-ZVKB-NEXT:    ret
  %head = insertelement <vscale x 8 x i8> poison, i8 -1, i32 0
  %splat = shufflevector <vscale x 8 x i8> %head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %a = xor <vscale x 8 x i8> %x, %splat
  %b = and <vscale x 8 x i8> %a, %y
  ret <vscale x 8 x i8> %b
}

define <vscale x 8 x i8> @vandn_vv_swapped_nxv8i8(<vscale x 8 x i8> %x, <vscale x 8 x i8> %y) {
; CHECK-LABEL: vandn_vv_swapped_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NEXT:    vnot.v v8, v8
; CHECK-NEXT:    vand.vv v8, v9, v8
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_swapped_nxv8i8:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v9, v8
; CHECK-ZVKB-NEXT:    ret
  %head = insertelement <vscale x 8 x i8> poison, i8 -1, i32 0
  %splat = shufflevector <vscale x 8 x i8> %head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %a = xor <vscale x 8 x i8> %x, %splat
  %b = and <vscale x 8 x i8> %y, %a
  ret <vscale x 8 x i8> %b
}

define <vscale x 8 x i8> @vandn_vx_nxv8i8(i8 %x, <vscale x 8 x i8> %y) {
; CHECK-LABEL: vandn_vx_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    not a0, a0
; CHECK-NEXT:    vsetvli a1, zero, e8, m1, ta, ma
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vx_nxv8i8:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a1, zero, e8, m1, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vx v8, v8, a0
; CHECK-ZVKB-NEXT:    ret
  %a = xor i8 %x, -1
  %head = insertelement <vscale x 8 x i8> poison, i8 %a, i32 0
  %splat = shufflevector <vscale x 8 x i8> %head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %b = and <vscale x 8 x i8> %splat, %y
  ret <vscale x 8 x i8> %b
}

define <vscale x 8 x i8> @vandn_vx_swapped_nxv8i8(i8 %x, <vscale x 8 x i8> %y) {
; CHECK-LABEL: vandn_vx_swapped_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    not a0, a0
; CHECK-NEXT:    vsetvli a1, zero, e8, m1, ta, ma
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vx_swapped_nxv8i8:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a1, zero, e8, m1, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vx v8, v8, a0
; CHECK-ZVKB-NEXT:    ret
  %a = xor i8 %x, -1
  %head = insertelement <vscale x 8 x i8> poison, i8 %a, i32 0
  %splat = shufflevector <vscale x 8 x i8> %head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %b = and <vscale x 8 x i8> %splat, %y
  ret <vscale x 8 x i8> %b
}

define <vscale x 16 x i8> @vandn_vv_nxv16i8(<vscale x 16 x i8> %x, <vscale x 16 x i8> %y) {
; CHECK-LABEL: vandn_vv_nxv16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m2, ta, ma
; CHECK-NEXT:    vnot.v v8, v8
; CHECK-NEXT:    vand.vv v8, v8, v10
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_nxv16i8:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a0, zero, e8, m2, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v10, v8
; CHECK-ZVKB-NEXT:    ret
  %head = insertelement <vscale x 16 x i8> poison, i8 -1, i32 0
  %splat = shufflevector <vscale x 16 x i8> %head, <vscale x 16 x i8> poison, <vscale x 16 x i32> zeroinitializer
  %a = xor <vscale x 16 x i8> %x, %splat
  %b = and <vscale x 16 x i8> %a, %y
  ret <vscale x 16 x i8> %b
}

define <vscale x 16 x i8> @vandn_vv_swapped_nxv16i8(<vscale x 16 x i8> %x, <vscale x 16 x i8> %y) {
; CHECK-LABEL: vandn_vv_swapped_nxv16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m2, ta, ma
; CHECK-NEXT:    vnot.v v8, v8
; CHECK-NEXT:    vand.vv v8, v10, v8
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_swapped_nxv16i8:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a0, zero, e8, m2, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v10, v8
; CHECK-ZVKB-NEXT:    ret
  %head = insertelement <vscale x 16 x i8> poison, i8 -1, i32 0
  %splat = shufflevector <vscale x 16 x i8> %head, <vscale x 16 x i8> poison, <vscale x 16 x i32> zeroinitializer
  %a = xor <vscale x 16 x i8> %x, %splat
  %b = and <vscale x 16 x i8> %y, %a
  ret <vscale x 16 x i8> %b
}

define <vscale x 16 x i8> @vandn_vx_nxv16i8(i8 %x, <vscale x 16 x i8> %y) {
; CHECK-LABEL: vandn_vx_nxv16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    not a0, a0
; CHECK-NEXT:    vsetvli a1, zero, e8, m2, ta, ma
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vx_nxv16i8:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a1, zero, e8, m2, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vx v8, v8, a0
; CHECK-ZVKB-NEXT:    ret
  %a = xor i8 %x, -1
  %head = insertelement <vscale x 16 x i8> poison, i8 %a, i32 0
  %splat = shufflevector <vscale x 16 x i8> %head, <vscale x 16 x i8> poison, <vscale x 16 x i32> zeroinitializer
  %b = and <vscale x 16 x i8> %splat, %y
  ret <vscale x 16 x i8> %b
}

define <vscale x 16 x i8> @vandn_vx_swapped_nxv16i8(i8 %x, <vscale x 16 x i8> %y) {
; CHECK-LABEL: vandn_vx_swapped_nxv16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    not a0, a0
; CHECK-NEXT:    vsetvli a1, zero, e8, m2, ta, ma
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vx_swapped_nxv16i8:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a1, zero, e8, m2, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vx v8, v8, a0
; CHECK-ZVKB-NEXT:    ret
  %a = xor i8 %x, -1
  %head = insertelement <vscale x 16 x i8> poison, i8 %a, i32 0
  %splat = shufflevector <vscale x 16 x i8> %head, <vscale x 16 x i8> poison, <vscale x 16 x i32> zeroinitializer
  %b = and <vscale x 16 x i8> %splat, %y
  ret <vscale x 16 x i8> %b
}

define <vscale x 32 x i8> @vandn_vv_nxv32i8(<vscale x 32 x i8> %x, <vscale x 32 x i8> %y) {
; CHECK-LABEL: vandn_vv_nxv32i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m4, ta, ma
; CHECK-NEXT:    vnot.v v8, v8
; CHECK-NEXT:    vand.vv v8, v8, v12
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_nxv32i8:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a0, zero, e8, m4, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v12, v8
; CHECK-ZVKB-NEXT:    ret
  %head = insertelement <vscale x 32 x i8> poison, i8 -1, i32 0
  %splat = shufflevector <vscale x 32 x i8> %head, <vscale x 32 x i8> poison, <vscale x 32 x i32> zeroinitializer
  %a = xor <vscale x 32 x i8> %x, %splat
  %b = and <vscale x 32 x i8> %a, %y
  ret <vscale x 32 x i8> %b
}

define <vscale x 32 x i8> @vandn_vv_swapped_nxv32i8(<vscale x 32 x i8> %x, <vscale x 32 x i8> %y) {
; CHECK-LABEL: vandn_vv_swapped_nxv32i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m4, ta, ma
; CHECK-NEXT:    vnot.v v8, v8
; CHECK-NEXT:    vand.vv v8, v12, v8
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_swapped_nxv32i8:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a0, zero, e8, m4, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v12, v8
; CHECK-ZVKB-NEXT:    ret
  %head = insertelement <vscale x 32 x i8> poison, i8 -1, i32 0
  %splat = shufflevector <vscale x 32 x i8> %head, <vscale x 32 x i8> poison, <vscale x 32 x i32> zeroinitializer
  %a = xor <vscale x 32 x i8> %x, %splat
  %b = and <vscale x 32 x i8> %y, %a
  ret <vscale x 32 x i8> %b
}

define <vscale x 32 x i8> @vandn_vx_nxv32i8(i8 %x, <vscale x 32 x i8> %y) {
; CHECK-LABEL: vandn_vx_nxv32i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    not a0, a0
; CHECK-NEXT:    vsetvli a1, zero, e8, m4, ta, ma
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vx_nxv32i8:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a1, zero, e8, m4, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vx v8, v8, a0
; CHECK-ZVKB-NEXT:    ret
  %a = xor i8 %x, -1
  %head = insertelement <vscale x 32 x i8> poison, i8 %a, i32 0
  %splat = shufflevector <vscale x 32 x i8> %head, <vscale x 32 x i8> poison, <vscale x 32 x i32> zeroinitializer
  %b = and <vscale x 32 x i8> %splat, %y
  ret <vscale x 32 x i8> %b
}

define <vscale x 32 x i8> @vandn_vx_swapped_nxv32i8(i8 %x, <vscale x 32 x i8> %y) {
; CHECK-LABEL: vandn_vx_swapped_nxv32i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    not a0, a0
; CHECK-NEXT:    vsetvli a1, zero, e8, m4, ta, ma
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vx_swapped_nxv32i8:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a1, zero, e8, m4, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vx v8, v8, a0
; CHECK-ZVKB-NEXT:    ret
  %a = xor i8 %x, -1
  %head = insertelement <vscale x 32 x i8> poison, i8 %a, i32 0
  %splat = shufflevector <vscale x 32 x i8> %head, <vscale x 32 x i8> poison, <vscale x 32 x i32> zeroinitializer
  %b = and <vscale x 32 x i8> %splat, %y
  ret <vscale x 32 x i8> %b
}

define <vscale x 64 x i8> @vandn_vv_nxv64i8(<vscale x 64 x i8> %x, <vscale x 64 x i8> %y) {
; CHECK-LABEL: vandn_vv_nxv64i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m8, ta, ma
; CHECK-NEXT:    vnot.v v8, v8
; CHECK-NEXT:    vand.vv v8, v8, v16
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_nxv64i8:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a0, zero, e8, m8, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v16, v8
; CHECK-ZVKB-NEXT:    ret
  %head = insertelement <vscale x 64 x i8> poison, i8 -1, i32 0
  %splat = shufflevector <vscale x 64 x i8> %head, <vscale x 64 x i8> poison, <vscale x 64 x i32> zeroinitializer
  %a = xor <vscale x 64 x i8> %x, %splat
  %b = and <vscale x 64 x i8> %a, %y
  ret <vscale x 64 x i8> %b
}

define <vscale x 64 x i8> @vandn_vv_swapped_nxv64i8(<vscale x 64 x i8> %x, <vscale x 64 x i8> %y) {
; CHECK-LABEL: vandn_vv_swapped_nxv64i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m8, ta, ma
; CHECK-NEXT:    vnot.v v8, v8
; CHECK-NEXT:    vand.vv v8, v16, v8
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_swapped_nxv64i8:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a0, zero, e8, m8, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v16, v8
; CHECK-ZVKB-NEXT:    ret
  %head = insertelement <vscale x 64 x i8> poison, i8 -1, i32 0
  %splat = shufflevector <vscale x 64 x i8> %head, <vscale x 64 x i8> poison, <vscale x 64 x i32> zeroinitializer
  %a = xor <vscale x 64 x i8> %x, %splat
  %b = and <vscale x 64 x i8> %y, %a
  ret <vscale x 64 x i8> %b
}

define <vscale x 64 x i8> @vandn_vx_nxv64i8(i8 %x, <vscale x 64 x i8> %y) {
; CHECK-LABEL: vandn_vx_nxv64i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    not a0, a0
; CHECK-NEXT:    vsetvli a1, zero, e8, m8, ta, ma
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vx_nxv64i8:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a1, zero, e8, m8, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vx v8, v8, a0
; CHECK-ZVKB-NEXT:    ret
  %a = xor i8 %x, -1
  %head = insertelement <vscale x 64 x i8> poison, i8 %a, i32 0
  %splat = shufflevector <vscale x 64 x i8> %head, <vscale x 64 x i8> poison, <vscale x 64 x i32> zeroinitializer
  %b = and <vscale x 64 x i8> %splat, %y
  ret <vscale x 64 x i8> %b
}

define <vscale x 64 x i8> @vandn_vx_swapped_nxv64i8(i8 %x, <vscale x 64 x i8> %y) {
; CHECK-LABEL: vandn_vx_swapped_nxv64i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    not a0, a0
; CHECK-NEXT:    vsetvli a1, zero, e8, m8, ta, ma
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vx_swapped_nxv64i8:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a1, zero, e8, m8, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vx v8, v8, a0
; CHECK-ZVKB-NEXT:    ret
  %a = xor i8 %x, -1
  %head = insertelement <vscale x 64 x i8> poison, i8 %a, i32 0
  %splat = shufflevector <vscale x 64 x i8> %head, <vscale x 64 x i8> poison, <vscale x 64 x i32> zeroinitializer
  %b = and <vscale x 64 x i8> %splat, %y
  ret <vscale x 64 x i8> %b
}

define <vscale x 1 x i16> @vandn_vv_nxv1i16(<vscale x 1 x i16> %x, <vscale x 1 x i16> %y) {
; CHECK-LABEL: vandn_vv_nxv1i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vnot.v v8, v8
; CHECK-NEXT:    vand.vv v8, v8, v9
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_nxv1i16:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v9, v8
; CHECK-ZVKB-NEXT:    ret
  %head = insertelement <vscale x 1 x i16> poison, i16 -1, i32 0
  %splat = shufflevector <vscale x 1 x i16> %head, <vscale x 1 x i16> poison, <vscale x 1 x i32> zeroinitializer
  %a = xor <vscale x 1 x i16> %x, %splat
  %b = and <vscale x 1 x i16> %a, %y
  ret <vscale x 1 x i16> %b
}

define <vscale x 1 x i16> @vandn_vv_swapped_nxv1i16(<vscale x 1 x i16> %x, <vscale x 1 x i16> %y) {
; CHECK-LABEL: vandn_vv_swapped_nxv1i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vnot.v v8, v8
; CHECK-NEXT:    vand.vv v8, v9, v8
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_swapped_nxv1i16:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v9, v8
; CHECK-ZVKB-NEXT:    ret
  %head = insertelement <vscale x 1 x i16> poison, i16 -1, i32 0
  %splat = shufflevector <vscale x 1 x i16> %head, <vscale x 1 x i16> poison, <vscale x 1 x i32> zeroinitializer
  %a = xor <vscale x 1 x i16> %x, %splat
  %b = and <vscale x 1 x i16> %y, %a
  ret <vscale x 1 x i16> %b
}

define <vscale x 1 x i16> @vandn_vx_nxv1i16(i16 %x, <vscale x 1 x i16> %y) {
; CHECK-LABEL: vandn_vx_nxv1i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    not a0, a0
; CHECK-NEXT:    vsetvli a1, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vx_nxv1i16:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a1, zero, e16, mf4, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vx v8, v8, a0
; CHECK-ZVKB-NEXT:    ret
  %a = xor i16 %x, -1
  %head = insertelement <vscale x 1 x i16> poison, i16 %a, i32 0
  %splat = shufflevector <vscale x 1 x i16> %head, <vscale x 1 x i16> poison, <vscale x 1 x i32> zeroinitializer
  %b = and <vscale x 1 x i16> %splat, %y
  ret <vscale x 1 x i16> %b
}

define <vscale x 1 x i16> @vandn_vx_swapped_nxv1i16(i16 %x, <vscale x 1 x i16> %y) {
; CHECK-LABEL: vandn_vx_swapped_nxv1i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    not a0, a0
; CHECK-NEXT:    vsetvli a1, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vx_swapped_nxv1i16:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a1, zero, e16, mf4, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vx v8, v8, a0
; CHECK-ZVKB-NEXT:    ret
  %a = xor i16 %x, -1
  %head = insertelement <vscale x 1 x i16> poison, i16 %a, i32 0
  %splat = shufflevector <vscale x 1 x i16> %head, <vscale x 1 x i16> poison, <vscale x 1 x i32> zeroinitializer
  %b = and <vscale x 1 x i16> %splat, %y
  ret <vscale x 1 x i16> %b
}

define <vscale x 2 x i16> @vandn_vv_nxv2i16(<vscale x 2 x i16> %x, <vscale x 2 x i16> %y) {
; CHECK-LABEL: vandn_vv_nxv2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vnot.v v8, v8
; CHECK-NEXT:    vand.vv v8, v8, v9
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_nxv2i16:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v9, v8
; CHECK-ZVKB-NEXT:    ret
  %head = insertelement <vscale x 2 x i16> poison, i16 -1, i32 0
  %splat = shufflevector <vscale x 2 x i16> %head, <vscale x 2 x i16> poison, <vscale x 2 x i32> zeroinitializer
  %a = xor <vscale x 2 x i16> %x, %splat
  %b = and <vscale x 2 x i16> %a, %y
  ret <vscale x 2 x i16> %b
}

define <vscale x 2 x i16> @vandn_vv_swapped_nxv2i16(<vscale x 2 x i16> %x, <vscale x 2 x i16> %y) {
; CHECK-LABEL: vandn_vv_swapped_nxv2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vnot.v v8, v8
; CHECK-NEXT:    vand.vv v8, v9, v8
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_swapped_nxv2i16:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v9, v8
; CHECK-ZVKB-NEXT:    ret
  %head = insertelement <vscale x 2 x i16> poison, i16 -1, i32 0
  %splat = shufflevector <vscale x 2 x i16> %head, <vscale x 2 x i16> poison, <vscale x 2 x i32> zeroinitializer
  %a = xor <vscale x 2 x i16> %x, %splat
  %b = and <vscale x 2 x i16> %y, %a
  ret <vscale x 2 x i16> %b
}

define <vscale x 2 x i16> @vandn_vx_nxv2i16(i16 %x, <vscale x 2 x i16> %y) {
; CHECK-LABEL: vandn_vx_nxv2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    not a0, a0
; CHECK-NEXT:    vsetvli a1, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vx_nxv2i16:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a1, zero, e16, mf2, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vx v8, v8, a0
; CHECK-ZVKB-NEXT:    ret
  %a = xor i16 %x, -1
  %head = insertelement <vscale x 2 x i16> poison, i16 %a, i32 0
  %splat = shufflevector <vscale x 2 x i16> %head, <vscale x 2 x i16> poison, <vscale x 2 x i32> zeroinitializer
  %b = and <vscale x 2 x i16> %splat, %y
  ret <vscale x 2 x i16> %b
}

define <vscale x 2 x i16> @vandn_vx_swapped_nxv2i16(i16 %x, <vscale x 2 x i16> %y) {
; CHECK-LABEL: vandn_vx_swapped_nxv2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    not a0, a0
; CHECK-NEXT:    vsetvli a1, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vx_swapped_nxv2i16:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a1, zero, e16, mf2, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vx v8, v8, a0
; CHECK-ZVKB-NEXT:    ret
  %a = xor i16 %x, -1
  %head = insertelement <vscale x 2 x i16> poison, i16 %a, i32 0
  %splat = shufflevector <vscale x 2 x i16> %head, <vscale x 2 x i16> poison, <vscale x 2 x i32> zeroinitializer
  %b = and <vscale x 2 x i16> %splat, %y
  ret <vscale x 2 x i16> %b
}

define <vscale x 4 x i16> @vandn_vv_nxv4i16(<vscale x 4 x i16> %x, <vscale x 4 x i16> %y) {
; CHECK-LABEL: vandn_vv_nxv4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vnot.v v8, v8
; CHECK-NEXT:    vand.vv v8, v8, v9
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_nxv4i16:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v9, v8
; CHECK-ZVKB-NEXT:    ret
  %head = insertelement <vscale x 4 x i16> poison, i16 -1, i32 0
  %splat = shufflevector <vscale x 4 x i16> %head, <vscale x 4 x i16> poison, <vscale x 4 x i32> zeroinitializer
  %a = xor <vscale x 4 x i16> %x, %splat
  %b = and <vscale x 4 x i16> %a, %y
  ret <vscale x 4 x i16> %b
}

define <vscale x 4 x i16> @vandn_vv_swapped_nxv4i16(<vscale x 4 x i16> %x, <vscale x 4 x i16> %y) {
; CHECK-LABEL: vandn_vv_swapped_nxv4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vnot.v v8, v8
; CHECK-NEXT:    vand.vv v8, v9, v8
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_swapped_nxv4i16:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v9, v8
; CHECK-ZVKB-NEXT:    ret
  %head = insertelement <vscale x 4 x i16> poison, i16 -1, i32 0
  %splat = shufflevector <vscale x 4 x i16> %head, <vscale x 4 x i16> poison, <vscale x 4 x i32> zeroinitializer
  %a = xor <vscale x 4 x i16> %x, %splat
  %b = and <vscale x 4 x i16> %y, %a
  ret <vscale x 4 x i16> %b
}

define <vscale x 4 x i16> @vandn_vx_nxv4i16(i16 %x, <vscale x 4 x i16> %y) {
; CHECK-LABEL: vandn_vx_nxv4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    not a0, a0
; CHECK-NEXT:    vsetvli a1, zero, e16, m1, ta, ma
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vx_nxv4i16:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a1, zero, e16, m1, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vx v8, v8, a0
; CHECK-ZVKB-NEXT:    ret
  %a = xor i16 %x, -1
  %head = insertelement <vscale x 4 x i16> poison, i16 %a, i32 0
  %splat = shufflevector <vscale x 4 x i16> %head, <vscale x 4 x i16> poison, <vscale x 4 x i32> zeroinitializer
  %b = and <vscale x 4 x i16> %splat, %y
  ret <vscale x 4 x i16> %b
}

define <vscale x 4 x i16> @vandn_vx_swapped_nxv4i16(i16 %x, <vscale x 4 x i16> %y) {
; CHECK-LABEL: vandn_vx_swapped_nxv4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    not a0, a0
; CHECK-NEXT:    vsetvli a1, zero, e16, m1, ta, ma
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vx_swapped_nxv4i16:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a1, zero, e16, m1, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vx v8, v8, a0
; CHECK-ZVKB-NEXT:    ret
  %a = xor i16 %x, -1
  %head = insertelement <vscale x 4 x i16> poison, i16 %a, i32 0
  %splat = shufflevector <vscale x 4 x i16> %head, <vscale x 4 x i16> poison, <vscale x 4 x i32> zeroinitializer
  %b = and <vscale x 4 x i16> %splat, %y
  ret <vscale x 4 x i16> %b
}

define <vscale x 8 x i16> @vandn_vv_nxv8i16(<vscale x 8 x i16> %x, <vscale x 8 x i16> %y) {
; CHECK-LABEL: vandn_vv_nxv8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vnot.v v8, v8
; CHECK-NEXT:    vand.vv v8, v8, v10
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_nxv8i16:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v10, v8
; CHECK-ZVKB-NEXT:    ret
  %head = insertelement <vscale x 8 x i16> poison, i16 -1, i32 0
  %splat = shufflevector <vscale x 8 x i16> %head, <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
  %a = xor <vscale x 8 x i16> %x, %splat
  %b = and <vscale x 8 x i16> %a, %y
  ret <vscale x 8 x i16> %b
}

define <vscale x 8 x i16> @vandn_vv_swapped_nxv8i16(<vscale x 8 x i16> %x, <vscale x 8 x i16> %y) {
; CHECK-LABEL: vandn_vv_swapped_nxv8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vnot.v v8, v8
; CHECK-NEXT:    vand.vv v8, v10, v8
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_swapped_nxv8i16:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v10, v8
; CHECK-ZVKB-NEXT:    ret
  %head = insertelement <vscale x 8 x i16> poison, i16 -1, i32 0
  %splat = shufflevector <vscale x 8 x i16> %head, <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
  %a = xor <vscale x 8 x i16> %x, %splat
  %b = and <vscale x 8 x i16> %y, %a
  ret <vscale x 8 x i16> %b
}

define <vscale x 8 x i16> @vandn_vx_nxv8i16(i16 %x, <vscale x 8 x i16> %y) {
; CHECK-LABEL: vandn_vx_nxv8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    not a0, a0
; CHECK-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vx_nxv8i16:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vx v8, v8, a0
; CHECK-ZVKB-NEXT:    ret
  %a = xor i16 %x, -1
  %head = insertelement <vscale x 8 x i16> poison, i16 %a, i32 0
  %splat = shufflevector <vscale x 8 x i16> %head, <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
  %b = and <vscale x 8 x i16> %splat, %y
  ret <vscale x 8 x i16> %b
}

define <vscale x 8 x i16> @vandn_vx_swapped_nxv8i16(i16 %x, <vscale x 8 x i16> %y) {
; CHECK-LABEL: vandn_vx_swapped_nxv8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    not a0, a0
; CHECK-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vx_swapped_nxv8i16:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vx v8, v8, a0
; CHECK-ZVKB-NEXT:    ret
  %a = xor i16 %x, -1
  %head = insertelement <vscale x 8 x i16> poison, i16 %a, i32 0
  %splat = shufflevector <vscale x 8 x i16> %head, <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
  %b = and <vscale x 8 x i16> %splat, %y
  ret <vscale x 8 x i16> %b
}

define <vscale x 16 x i16> @vandn_vv_nxv16i16(<vscale x 16 x i16> %x, <vscale x 16 x i16> %y) {
; CHECK-LABEL: vandn_vv_nxv16i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vnot.v v8, v8
; CHECK-NEXT:    vand.vv v8, v8, v12
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_nxv16i16:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v12, v8
; CHECK-ZVKB-NEXT:    ret
  %head = insertelement <vscale x 16 x i16> poison, i16 -1, i32 0
  %splat = shufflevector <vscale x 16 x i16> %head, <vscale x 16 x i16> poison, <vscale x 16 x i32> zeroinitializer
  %a = xor <vscale x 16 x i16> %x, %splat
  %b = and <vscale x 16 x i16> %a, %y
  ret <vscale x 16 x i16> %b
}

define <vscale x 16 x i16> @vandn_vv_swapped_nxv16i16(<vscale x 16 x i16> %x, <vscale x 16 x i16> %y) {
; CHECK-LABEL: vandn_vv_swapped_nxv16i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vnot.v v8, v8
; CHECK-NEXT:    vand.vv v8, v12, v8
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_swapped_nxv16i16:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v12, v8
; CHECK-ZVKB-NEXT:    ret
  %head = insertelement <vscale x 16 x i16> poison, i16 -1, i32 0
  %splat = shufflevector <vscale x 16 x i16> %head, <vscale x 16 x i16> poison, <vscale x 16 x i32> zeroinitializer
  %a = xor <vscale x 16 x i16> %x, %splat
  %b = and <vscale x 16 x i16> %y, %a
  ret <vscale x 16 x i16> %b
}

define <vscale x 16 x i16> @vandn_vx_nxv16i16(i16 %x, <vscale x 16 x i16> %y) {
; CHECK-LABEL: vandn_vx_nxv16i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    not a0, a0
; CHECK-NEXT:    vsetvli a1, zero, e16, m4, ta, ma
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vx_nxv16i16:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a1, zero, e16, m4, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vx v8, v8, a0
; CHECK-ZVKB-NEXT:    ret
  %a = xor i16 %x, -1
  %head = insertelement <vscale x 16 x i16> poison, i16 %a, i32 0
  %splat = shufflevector <vscale x 16 x i16> %head, <vscale x 16 x i16> poison, <vscale x 16 x i32> zeroinitializer
  %b = and <vscale x 16 x i16> %splat, %y
  ret <vscale x 16 x i16> %b
}

define <vscale x 16 x i16> @vandn_vx_swapped_nxv16i16(i16 %x, <vscale x 16 x i16> %y) {
; CHECK-LABEL: vandn_vx_swapped_nxv16i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    not a0, a0
; CHECK-NEXT:    vsetvli a1, zero, e16, m4, ta, ma
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vx_swapped_nxv16i16:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a1, zero, e16, m4, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vx v8, v8, a0
; CHECK-ZVKB-NEXT:    ret
  %a = xor i16 %x, -1
  %head = insertelement <vscale x 16 x i16> poison, i16 %a, i32 0
  %splat = shufflevector <vscale x 16 x i16> %head, <vscale x 16 x i16> poison, <vscale x 16 x i32> zeroinitializer
  %b = and <vscale x 16 x i16> %splat, %y
  ret <vscale x 16 x i16> %b
}

define <vscale x 32 x i16> @vandn_vv_nxv32i16(<vscale x 32 x i16> %x, <vscale x 32 x i16> %y) {
; CHECK-LABEL: vandn_vv_nxv32i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m8, ta, ma
; CHECK-NEXT:    vnot.v v8, v8
; CHECK-NEXT:    vand.vv v8, v8, v16
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_nxv32i16:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a0, zero, e16, m8, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v16, v8
; CHECK-ZVKB-NEXT:    ret
  %head = insertelement <vscale x 32 x i16> poison, i16 -1, i32 0
  %splat = shufflevector <vscale x 32 x i16> %head, <vscale x 32 x i16> poison, <vscale x 32 x i32> zeroinitializer
  %a = xor <vscale x 32 x i16> %x, %splat
  %b = and <vscale x 32 x i16> %a, %y
  ret <vscale x 32 x i16> %b
}

define <vscale x 32 x i16> @vandn_vv_swapped_nxv32i16(<vscale x 32 x i16> %x, <vscale x 32 x i16> %y) {
; CHECK-LABEL: vandn_vv_swapped_nxv32i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m8, ta, ma
; CHECK-NEXT:    vnot.v v8, v8
; CHECK-NEXT:    vand.vv v8, v16, v8
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_swapped_nxv32i16:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a0, zero, e16, m8, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v16, v8
; CHECK-ZVKB-NEXT:    ret
  %head = insertelement <vscale x 32 x i16> poison, i16 -1, i32 0
  %splat = shufflevector <vscale x 32 x i16> %head, <vscale x 32 x i16> poison, <vscale x 32 x i32> zeroinitializer
  %a = xor <vscale x 32 x i16> %x, %splat
  %b = and <vscale x 32 x i16> %y, %a
  ret <vscale x 32 x i16> %b
}

define <vscale x 32 x i16> @vandn_vx_nxv32i16(i16 %x, <vscale x 32 x i16> %y) {
; CHECK-LABEL: vandn_vx_nxv32i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    not a0, a0
; CHECK-NEXT:    vsetvli a1, zero, e16, m8, ta, ma
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vx_nxv32i16:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a1, zero, e16, m8, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vx v8, v8, a0
; CHECK-ZVKB-NEXT:    ret
  %a = xor i16 %x, -1
  %head = insertelement <vscale x 32 x i16> poison, i16 %a, i32 0
  %splat = shufflevector <vscale x 32 x i16> %head, <vscale x 32 x i16> poison, <vscale x 32 x i32> zeroinitializer
  %b = and <vscale x 32 x i16> %splat, %y
  ret <vscale x 32 x i16> %b
}

define <vscale x 32 x i16> @vandn_vx_swapped_nxv32i16(i16 %x, <vscale x 32 x i16> %y) {
; CHECK-LABEL: vandn_vx_swapped_nxv32i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    not a0, a0
; CHECK-NEXT:    vsetvli a1, zero, e16, m8, ta, ma
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vx_swapped_nxv32i16:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a1, zero, e16, m8, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vx v8, v8, a0
; CHECK-ZVKB-NEXT:    ret
  %a = xor i16 %x, -1
  %head = insertelement <vscale x 32 x i16> poison, i16 %a, i32 0
  %splat = shufflevector <vscale x 32 x i16> %head, <vscale x 32 x i16> poison, <vscale x 32 x i32> zeroinitializer
  %b = and <vscale x 32 x i16> %splat, %y
  ret <vscale x 32 x i16> %b
}

define <vscale x 1 x i32> @vandn_vv_nxv1i32(<vscale x 1 x i32> %x, <vscale x 1 x i32> %y) {
; CHECK-LABEL: vandn_vv_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vnot.v v8, v8
; CHECK-NEXT:    vand.vv v8, v8, v9
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_nxv1i32:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v9, v8
; CHECK-ZVKB-NEXT:    ret
  %head = insertelement <vscale x 1 x i32> poison, i32 -1, i32 0
  %splat = shufflevector <vscale x 1 x i32> %head, <vscale x 1 x i32> poison, <vscale x 1 x i32> zeroinitializer
  %a = xor <vscale x 1 x i32> %x, %splat
  %b = and <vscale x 1 x i32> %a, %y
  ret <vscale x 1 x i32> %b
}

define <vscale x 1 x i32> @vandn_vv_swapped_nxv1i32(<vscale x 1 x i32> %x, <vscale x 1 x i32> %y) {
; CHECK-LABEL: vandn_vv_swapped_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vnot.v v8, v8
; CHECK-NEXT:    vand.vv v8, v9, v8
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_swapped_nxv1i32:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v9, v8
; CHECK-ZVKB-NEXT:    ret
  %head = insertelement <vscale x 1 x i32> poison, i32 -1, i32 0
  %splat = shufflevector <vscale x 1 x i32> %head, <vscale x 1 x i32> poison, <vscale x 1 x i32> zeroinitializer
  %a = xor <vscale x 1 x i32> %x, %splat
  %b = and <vscale x 1 x i32> %y, %a
  ret <vscale x 1 x i32> %b
}

define <vscale x 1 x i32> @vandn_vx_nxv1i32(i32 %x, <vscale x 1 x i32> %y) {
; CHECK-LABEL: vandn_vx_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    not a0, a0
; CHECK-NEXT:    vsetvli a1, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vx_nxv1i32:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a1, zero, e32, mf2, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vx v8, v8, a0
; CHECK-ZVKB-NEXT:    ret
  %a = xor i32 %x, -1
  %head = insertelement <vscale x 1 x i32> poison, i32 %a, i32 0
  %splat = shufflevector <vscale x 1 x i32> %head, <vscale x 1 x i32> poison, <vscale x 1 x i32> zeroinitializer
  %b = and <vscale x 1 x i32> %splat, %y
  ret <vscale x 1 x i32> %b
}

define <vscale x 1 x i32> @vandn_vx_swapped_nxv1i32(i32 %x, <vscale x 1 x i32> %y) {
; CHECK-LABEL: vandn_vx_swapped_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    not a0, a0
; CHECK-NEXT:    vsetvli a1, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vx_swapped_nxv1i32:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a1, zero, e32, mf2, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vx v8, v8, a0
; CHECK-ZVKB-NEXT:    ret
  %a = xor i32 %x, -1
  %head = insertelement <vscale x 1 x i32> poison, i32 %a, i32 0
  %splat = shufflevector <vscale x 1 x i32> %head, <vscale x 1 x i32> poison, <vscale x 1 x i32> zeroinitializer
  %b = and <vscale x 1 x i32> %splat, %y
  ret <vscale x 1 x i32> %b
}

define <vscale x 2 x i32> @vandn_vv_nxv2i32(<vscale x 2 x i32> %x, <vscale x 2 x i32> %y) {
; CHECK-LABEL: vandn_vv_nxv2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vnot.v v8, v8
; CHECK-NEXT:    vand.vv v8, v8, v9
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_nxv2i32:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v9, v8
; CHECK-ZVKB-NEXT:    ret
  %head = insertelement <vscale x 2 x i32> poison, i32 -1, i32 0
  %splat = shufflevector <vscale x 2 x i32> %head, <vscale x 2 x i32> poison, <vscale x 2 x i32> zeroinitializer
  %a = xor <vscale x 2 x i32> %x, %splat
  %b = and <vscale x 2 x i32> %a, %y
  ret <vscale x 2 x i32> %b
}

define <vscale x 2 x i32> @vandn_vv_swapped_nxv2i32(<vscale x 2 x i32> %x, <vscale x 2 x i32> %y) {
; CHECK-LABEL: vandn_vv_swapped_nxv2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vnot.v v8, v8
; CHECK-NEXT:    vand.vv v8, v9, v8
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_swapped_nxv2i32:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v9, v8
; CHECK-ZVKB-NEXT:    ret
  %head = insertelement <vscale x 2 x i32> poison, i32 -1, i32 0
  %splat = shufflevector <vscale x 2 x i32> %head, <vscale x 2 x i32> poison, <vscale x 2 x i32> zeroinitializer
  %a = xor <vscale x 2 x i32> %x, %splat
  %b = and <vscale x 2 x i32> %y, %a
  ret <vscale x 2 x i32> %b
}

define <vscale x 2 x i32> @vandn_vx_nxv2i32(i32 %x, <vscale x 2 x i32> %y) {
; CHECK-LABEL: vandn_vx_nxv2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    not a0, a0
; CHECK-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vx_nxv2i32:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vx v8, v8, a0
; CHECK-ZVKB-NEXT:    ret
  %a = xor i32 %x, -1
  %head = insertelement <vscale x 2 x i32> poison, i32 %a, i32 0
  %splat = shufflevector <vscale x 2 x i32> %head, <vscale x 2 x i32> poison, <vscale x 2 x i32> zeroinitializer
  %b = and <vscale x 2 x i32> %splat, %y
  ret <vscale x 2 x i32> %b
}

define <vscale x 2 x i32> @vandn_vx_swapped_nxv2i32(i32 %x, <vscale x 2 x i32> %y) {
; CHECK-LABEL: vandn_vx_swapped_nxv2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    not a0, a0
; CHECK-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vx_swapped_nxv2i32:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vx v8, v8, a0
; CHECK-ZVKB-NEXT:    ret
  %a = xor i32 %x, -1
  %head = insertelement <vscale x 2 x i32> poison, i32 %a, i32 0
  %splat = shufflevector <vscale x 2 x i32> %head, <vscale x 2 x i32> poison, <vscale x 2 x i32> zeroinitializer
  %b = and <vscale x 2 x i32> %splat, %y
  ret <vscale x 2 x i32> %b
}

define <vscale x 4 x i32> @vandn_vv_nxv4i32(<vscale x 4 x i32> %x, <vscale x 4 x i32> %y) {
; CHECK-LABEL: vandn_vv_nxv4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vnot.v v8, v8
; CHECK-NEXT:    vand.vv v8, v8, v10
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_nxv4i32:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v10, v8
; CHECK-ZVKB-NEXT:    ret
  %head = insertelement <vscale x 4 x i32> poison, i32 -1, i32 0
  %splat = shufflevector <vscale x 4 x i32> %head, <vscale x 4 x i32> poison, <vscale x 4 x i32> zeroinitializer
  %a = xor <vscale x 4 x i32> %x, %splat
  %b = and <vscale x 4 x i32> %a, %y
  ret <vscale x 4 x i32> %b
}

define <vscale x 4 x i32> @vandn_vv_swapped_nxv4i32(<vscale x 4 x i32> %x, <vscale x 4 x i32> %y) {
; CHECK-LABEL: vandn_vv_swapped_nxv4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vnot.v v8, v8
; CHECK-NEXT:    vand.vv v8, v10, v8
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_swapped_nxv4i32:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v10, v8
; CHECK-ZVKB-NEXT:    ret
  %head = insertelement <vscale x 4 x i32> poison, i32 -1, i32 0
  %splat = shufflevector <vscale x 4 x i32> %head, <vscale x 4 x i32> poison, <vscale x 4 x i32> zeroinitializer
  %a = xor <vscale x 4 x i32> %x, %splat
  %b = and <vscale x 4 x i32> %y, %a
  ret <vscale x 4 x i32> %b
}

define <vscale x 4 x i32> @vandn_vx_nxv4i32(i32 %x, <vscale x 4 x i32> %y) {
; CHECK-LABEL: vandn_vx_nxv4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    not a0, a0
; CHECK-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vx_nxv4i32:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vx v8, v8, a0
; CHECK-ZVKB-NEXT:    ret
  %a = xor i32 %x, -1
  %head = insertelement <vscale x 4 x i32> poison, i32 %a, i32 0
  %splat = shufflevector <vscale x 4 x i32> %head, <vscale x 4 x i32> poison, <vscale x 4 x i32> zeroinitializer
  %b = and <vscale x 4 x i32> %splat, %y
  ret <vscale x 4 x i32> %b
}

define <vscale x 4 x i32> @vandn_vx_swapped_nxv4i32(i32 %x, <vscale x 4 x i32> %y) {
; CHECK-LABEL: vandn_vx_swapped_nxv4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    not a0, a0
; CHECK-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vx_swapped_nxv4i32:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vx v8, v8, a0
; CHECK-ZVKB-NEXT:    ret
  %a = xor i32 %x, -1
  %head = insertelement <vscale x 4 x i32> poison, i32 %a, i32 0
  %splat = shufflevector <vscale x 4 x i32> %head, <vscale x 4 x i32> poison, <vscale x 4 x i32> zeroinitializer
  %b = and <vscale x 4 x i32> %splat, %y
  ret <vscale x 4 x i32> %b
}

define <vscale x 8 x i32> @vandn_vv_nxv8i32(<vscale x 8 x i32> %x, <vscale x 8 x i32> %y) {
; CHECK-LABEL: vandn_vv_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vnot.v v8, v8
; CHECK-NEXT:    vand.vv v8, v8, v12
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_nxv8i32:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v12, v8
; CHECK-ZVKB-NEXT:    ret
  %head = insertelement <vscale x 8 x i32> poison, i32 -1, i32 0
  %splat = shufflevector <vscale x 8 x i32> %head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %a = xor <vscale x 8 x i32> %x, %splat
  %b = and <vscale x 8 x i32> %a, %y
  ret <vscale x 8 x i32> %b
}

define <vscale x 8 x i32> @vandn_vv_swapped_nxv8i32(<vscale x 8 x i32> %x, <vscale x 8 x i32> %y) {
; CHECK-LABEL: vandn_vv_swapped_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vnot.v v8, v8
; CHECK-NEXT:    vand.vv v8, v12, v8
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_swapped_nxv8i32:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v12, v8
; CHECK-ZVKB-NEXT:    ret
  %head = insertelement <vscale x 8 x i32> poison, i32 -1, i32 0
  %splat = shufflevector <vscale x 8 x i32> %head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %a = xor <vscale x 8 x i32> %x, %splat
  %b = and <vscale x 8 x i32> %y, %a
  ret <vscale x 8 x i32> %b
}

define <vscale x 8 x i32> @vandn_vx_nxv8i32(i32 %x, <vscale x 8 x i32> %y) {
; CHECK-LABEL: vandn_vx_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    not a0, a0
; CHECK-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vx_nxv8i32:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vx v8, v8, a0
; CHECK-ZVKB-NEXT:    ret
  %a = xor i32 %x, -1
  %head = insertelement <vscale x 8 x i32> poison, i32 %a, i32 0
  %splat = shufflevector <vscale x 8 x i32> %head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %b = and <vscale x 8 x i32> %splat, %y
  ret <vscale x 8 x i32> %b
}

define <vscale x 8 x i32> @vandn_vx_swapped_nxv8i32(i32 %x, <vscale x 8 x i32> %y) {
; CHECK-LABEL: vandn_vx_swapped_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    not a0, a0
; CHECK-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vx_swapped_nxv8i32:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vx v8, v8, a0
; CHECK-ZVKB-NEXT:    ret
  %a = xor i32 %x, -1
  %head = insertelement <vscale x 8 x i32> poison, i32 %a, i32 0
  %splat = shufflevector <vscale x 8 x i32> %head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %b = and <vscale x 8 x i32> %splat, %y
  ret <vscale x 8 x i32> %b
}

define <vscale x 16 x i32> @vandn_vv_nxv16i32(<vscale x 16 x i32> %x, <vscale x 16 x i32> %y) {
; CHECK-LABEL: vandn_vv_nxv16i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-NEXT:    vnot.v v8, v8
; CHECK-NEXT:    vand.vv v8, v8, v16
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_nxv16i32:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v16, v8
; CHECK-ZVKB-NEXT:    ret
  %head = insertelement <vscale x 16 x i32> poison, i32 -1, i32 0
  %splat = shufflevector <vscale x 16 x i32> %head, <vscale x 16 x i32> poison, <vscale x 16 x i32> zeroinitializer
  %a = xor <vscale x 16 x i32> %x, %splat
  %b = and <vscale x 16 x i32> %a, %y
  ret <vscale x 16 x i32> %b
}

define <vscale x 16 x i32> @vandn_vv_swapped_nxv16i32(<vscale x 16 x i32> %x, <vscale x 16 x i32> %y) {
; CHECK-LABEL: vandn_vv_swapped_nxv16i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-NEXT:    vnot.v v8, v8
; CHECK-NEXT:    vand.vv v8, v16, v8
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_swapped_nxv16i32:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v16, v8
; CHECK-ZVKB-NEXT:    ret
  %head = insertelement <vscale x 16 x i32> poison, i32 -1, i32 0
  %splat = shufflevector <vscale x 16 x i32> %head, <vscale x 16 x i32> poison, <vscale x 16 x i32> zeroinitializer
  %a = xor <vscale x 16 x i32> %x, %splat
  %b = and <vscale x 16 x i32> %y, %a
  ret <vscale x 16 x i32> %b
}

define <vscale x 16 x i32> @vandn_vx_nxv16i32(i32 %x, <vscale x 16 x i32> %y) {
; CHECK-LABEL: vandn_vx_nxv16i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    not a0, a0
; CHECK-NEXT:    vsetvli a1, zero, e32, m8, ta, ma
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vx_nxv16i32:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a1, zero, e32, m8, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vx v8, v8, a0
; CHECK-ZVKB-NEXT:    ret
  %a = xor i32 %x, -1
  %head = insertelement <vscale x 16 x i32> poison, i32 %a, i32 0
  %splat = shufflevector <vscale x 16 x i32> %head, <vscale x 16 x i32> poison, <vscale x 16 x i32> zeroinitializer
  %b = and <vscale x 16 x i32> %splat, %y
  ret <vscale x 16 x i32> %b
}

define <vscale x 16 x i32> @vandn_vx_swapped_nxv16i32(i32 %x, <vscale x 16 x i32> %y) {
; CHECK-LABEL: vandn_vx_swapped_nxv16i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    not a0, a0
; CHECK-NEXT:    vsetvli a1, zero, e32, m8, ta, ma
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vx_swapped_nxv16i32:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a1, zero, e32, m8, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vx v8, v8, a0
; CHECK-ZVKB-NEXT:    ret
  %a = xor i32 %x, -1
  %head = insertelement <vscale x 16 x i32> poison, i32 %a, i32 0
  %splat = shufflevector <vscale x 16 x i32> %head, <vscale x 16 x i32> poison, <vscale x 16 x i32> zeroinitializer
  %b = and <vscale x 16 x i32> %splat, %y
  ret <vscale x 16 x i32> %b
}

define <vscale x 1 x i64> @vandn_vv_nxv1i64(<vscale x 1 x i64> %x, <vscale x 1 x i64> %y) {
; CHECK-LABEL: vandn_vv_nxv1i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-NEXT:    vnot.v v8, v8
; CHECK-NEXT:    vand.vv v8, v8, v9
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_nxv1i64:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v9, v8
; CHECK-ZVKB-NEXT:    ret
  %head = insertelement <vscale x 1 x i64> poison, i64 -1, i32 0
  %splat = shufflevector <vscale x 1 x i64> %head, <vscale x 1 x i64> poison, <vscale x 1 x i32> zeroinitializer
  %a = xor <vscale x 1 x i64> %x, %splat
  %b = and <vscale x 1 x i64> %a, %y
  ret <vscale x 1 x i64> %b
}

define <vscale x 1 x i64> @vandn_vv_swapped_nxv1i64(<vscale x 1 x i64> %x, <vscale x 1 x i64> %y) {
; CHECK-LABEL: vandn_vv_swapped_nxv1i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-NEXT:    vnot.v v8, v8
; CHECK-NEXT:    vand.vv v8, v9, v8
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_swapped_nxv1i64:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v9, v8
; CHECK-ZVKB-NEXT:    ret
  %head = insertelement <vscale x 1 x i64> poison, i64 -1, i32 0
  %splat = shufflevector <vscale x 1 x i64> %head, <vscale x 1 x i64> poison, <vscale x 1 x i32> zeroinitializer
  %a = xor <vscale x 1 x i64> %x, %splat
  %b = and <vscale x 1 x i64> %y, %a
  ret <vscale x 1 x i64> %b
}

define <vscale x 1 x i64> @vandn_vx_nxv1i64(i64 %x, <vscale x 1 x i64> %y) {
; CHECK-RV32-LABEL: vandn_vx_nxv1i64:
; CHECK-RV32:       # %bb.0:
; CHECK-RV32-NEXT:    addi sp, sp, -16
; CHECK-RV32-NEXT:    .cfi_def_cfa_offset 16
; CHECK-RV32-NEXT:    not a0, a0
; CHECK-RV32-NEXT:    not a1, a1
; CHECK-RV32-NEXT:    sw a1, 12(sp)
; CHECK-RV32-NEXT:    sw a0, 8(sp)
; CHECK-RV32-NEXT:    addi a0, sp, 8
; CHECK-RV32-NEXT:    vsetvli a1, zero, e64, m1, ta, ma
; CHECK-RV32-NEXT:    vlse64.v v9, (a0), zero
; CHECK-RV32-NEXT:    vand.vv v8, v9, v8
; CHECK-RV32-NEXT:    addi sp, sp, 16
; CHECK-RV32-NEXT:    ret
;
; CHECK-RV64-LABEL: vandn_vx_nxv1i64:
; CHECK-RV64:       # %bb.0:
; CHECK-RV64-NEXT:    not a0, a0
; CHECK-RV64-NEXT:    vsetvli a1, zero, e64, m1, ta, ma
; CHECK-RV64-NEXT:    vand.vx v8, v8, a0
; CHECK-RV64-NEXT:    ret
;
; CHECK-ZVKB32-LABEL: vandn_vx_nxv1i64:
; CHECK-ZVKB32:       # %bb.0:
; CHECK-ZVKB32-NEXT:    addi sp, sp, -16
; CHECK-ZVKB32-NEXT:    .cfi_def_cfa_offset 16
; CHECK-ZVKB32-NEXT:    not a0, a0
; CHECK-ZVKB32-NEXT:    not a1, a1
; CHECK-ZVKB32-NEXT:    sw a1, 12(sp)
; CHECK-ZVKB32-NEXT:    sw a0, 8(sp)
; CHECK-ZVKB32-NEXT:    addi a0, sp, 8
; CHECK-ZVKB32-NEXT:    vsetvli a1, zero, e64, m1, ta, ma
; CHECK-ZVKB32-NEXT:    vlse64.v v9, (a0), zero
; CHECK-ZVKB32-NEXT:    vand.vv v8, v9, v8
; CHECK-ZVKB32-NEXT:    addi sp, sp, 16
; CHECK-ZVKB32-NEXT:    ret
;
; CHECK-ZVKB64-LABEL: vandn_vx_nxv1i64:
; CHECK-ZVKB64:       # %bb.0:
; CHECK-ZVKB64-NEXT:    vsetvli a1, zero, e64, m1, ta, ma
; CHECK-ZVKB64-NEXT:    vandn.vx v8, v8, a0
; CHECK-ZVKB64-NEXT:    ret
  %a = xor i64 %x, -1
  %head = insertelement <vscale x 1 x i64> poison, i64 %a, i32 0
  %splat = shufflevector <vscale x 1 x i64> %head, <vscale x 1 x i64> poison, <vscale x 1 x i32> zeroinitializer
  %b = and <vscale x 1 x i64> %splat, %y
  ret <vscale x 1 x i64> %b
}

define <vscale x 1 x i64> @vandn_vx_swapped_nxv1i64(i64 %x, <vscale x 1 x i64> %y) {
; CHECK-RV32-LABEL: vandn_vx_swapped_nxv1i64:
; CHECK-RV32:       # %bb.0:
; CHECK-RV32-NEXT:    addi sp, sp, -16
; CHECK-RV32-NEXT:    .cfi_def_cfa_offset 16
; CHECK-RV32-NEXT:    not a0, a0
; CHECK-RV32-NEXT:    not a1, a1
; CHECK-RV32-NEXT:    sw a1, 12(sp)
; CHECK-RV32-NEXT:    sw a0, 8(sp)
; CHECK-RV32-NEXT:    addi a0, sp, 8
; CHECK-RV32-NEXT:    vsetvli a1, zero, e64, m1, ta, ma
; CHECK-RV32-NEXT:    vlse64.v v9, (a0), zero
; CHECK-RV32-NEXT:    vand.vv v8, v9, v8
; CHECK-RV32-NEXT:    addi sp, sp, 16
; CHECK-RV32-NEXT:    ret
;
; CHECK-RV64-LABEL: vandn_vx_swapped_nxv1i64:
; CHECK-RV64:       # %bb.0:
; CHECK-RV64-NEXT:    not a0, a0
; CHECK-RV64-NEXT:    vsetvli a1, zero, e64, m1, ta, ma
; CHECK-RV64-NEXT:    vand.vx v8, v8, a0
; CHECK-RV64-NEXT:    ret
;
; CHECK-ZVKB32-LABEL: vandn_vx_swapped_nxv1i64:
; CHECK-ZVKB32:       # %bb.0:
; CHECK-ZVKB32-NEXT:    addi sp, sp, -16
; CHECK-ZVKB32-NEXT:    .cfi_def_cfa_offset 16
; CHECK-ZVKB32-NEXT:    not a0, a0
; CHECK-ZVKB32-NEXT:    not a1, a1
; CHECK-ZVKB32-NEXT:    sw a1, 12(sp)
; CHECK-ZVKB32-NEXT:    sw a0, 8(sp)
; CHECK-ZVKB32-NEXT:    addi a0, sp, 8
; CHECK-ZVKB32-NEXT:    vsetvli a1, zero, e64, m1, ta, ma
; CHECK-ZVKB32-NEXT:    vlse64.v v9, (a0), zero
; CHECK-ZVKB32-NEXT:    vand.vv v8, v9, v8
; CHECK-ZVKB32-NEXT:    addi sp, sp, 16
; CHECK-ZVKB32-NEXT:    ret
;
; CHECK-ZVKB64-LABEL: vandn_vx_swapped_nxv1i64:
; CHECK-ZVKB64:       # %bb.0:
; CHECK-ZVKB64-NEXT:    vsetvli a1, zero, e64, m1, ta, ma
; CHECK-ZVKB64-NEXT:    vandn.vx v8, v8, a0
; CHECK-ZVKB64-NEXT:    ret
  %a = xor i64 %x, -1
  %head = insertelement <vscale x 1 x i64> poison, i64 %a, i32 0
  %splat = shufflevector <vscale x 1 x i64> %head, <vscale x 1 x i64> poison, <vscale x 1 x i32> zeroinitializer
  %b = and <vscale x 1 x i64> %splat, %y
  ret <vscale x 1 x i64> %b
}

define <vscale x 2 x i64> @vandn_vv_nxv2i64(<vscale x 2 x i64> %x, <vscale x 2 x i64> %y) {
; CHECK-LABEL: vandn_vv_nxv2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-NEXT:    vnot.v v8, v8
; CHECK-NEXT:    vand.vv v8, v8, v10
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_nxv2i64:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v10, v8
; CHECK-ZVKB-NEXT:    ret
  %head = insertelement <vscale x 2 x i64> poison, i64 -1, i32 0
  %splat = shufflevector <vscale x 2 x i64> %head, <vscale x 2 x i64> poison, <vscale x 2 x i32> zeroinitializer
  %a = xor <vscale x 2 x i64> %x, %splat
  %b = and <vscale x 2 x i64> %a, %y
  ret <vscale x 2 x i64> %b
}

define <vscale x 2 x i64> @vandn_vv_swapped_nxv2i64(<vscale x 2 x i64> %x, <vscale x 2 x i64> %y) {
; CHECK-LABEL: vandn_vv_swapped_nxv2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-NEXT:    vnot.v v8, v8
; CHECK-NEXT:    vand.vv v8, v10, v8
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_swapped_nxv2i64:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v10, v8
; CHECK-ZVKB-NEXT:    ret
  %head = insertelement <vscale x 2 x i64> poison, i64 -1, i32 0
  %splat = shufflevector <vscale x 2 x i64> %head, <vscale x 2 x i64> poison, <vscale x 2 x i32> zeroinitializer
  %a = xor <vscale x 2 x i64> %x, %splat
  %b = and <vscale x 2 x i64> %y, %a
  ret <vscale x 2 x i64> %b
}

define <vscale x 2 x i64> @vandn_vx_nxv2i64(i64 %x, <vscale x 2 x i64> %y) {
; CHECK-RV32-LABEL: vandn_vx_nxv2i64:
; CHECK-RV32:       # %bb.0:
; CHECK-RV32-NEXT:    addi sp, sp, -16
; CHECK-RV32-NEXT:    .cfi_def_cfa_offset 16
; CHECK-RV32-NEXT:    not a0, a0
; CHECK-RV32-NEXT:    not a1, a1
; CHECK-RV32-NEXT:    sw a1, 12(sp)
; CHECK-RV32-NEXT:    sw a0, 8(sp)
; CHECK-RV32-NEXT:    addi a0, sp, 8
; CHECK-RV32-NEXT:    vsetvli a1, zero, e64, m2, ta, ma
; CHECK-RV32-NEXT:    vlse64.v v10, (a0), zero
; CHECK-RV32-NEXT:    vand.vv v8, v10, v8
; CHECK-RV32-NEXT:    addi sp, sp, 16
; CHECK-RV32-NEXT:    ret
;
; CHECK-RV64-LABEL: vandn_vx_nxv2i64:
; CHECK-RV64:       # %bb.0:
; CHECK-RV64-NEXT:    not a0, a0
; CHECK-RV64-NEXT:    vsetvli a1, zero, e64, m2, ta, ma
; CHECK-RV64-NEXT:    vand.vx v8, v8, a0
; CHECK-RV64-NEXT:    ret
;
; CHECK-ZVKB32-LABEL: vandn_vx_nxv2i64:
; CHECK-ZVKB32:       # %bb.0:
; CHECK-ZVKB32-NEXT:    addi sp, sp, -16
; CHECK-ZVKB32-NEXT:    .cfi_def_cfa_offset 16
; CHECK-ZVKB32-NEXT:    not a0, a0
; CHECK-ZVKB32-NEXT:    not a1, a1
; CHECK-ZVKB32-NEXT:    sw a1, 12(sp)
; CHECK-ZVKB32-NEXT:    sw a0, 8(sp)
; CHECK-ZVKB32-NEXT:    addi a0, sp, 8
; CHECK-ZVKB32-NEXT:    vsetvli a1, zero, e64, m2, ta, ma
; CHECK-ZVKB32-NEXT:    vlse64.v v10, (a0), zero
; CHECK-ZVKB32-NEXT:    vand.vv v8, v10, v8
; CHECK-ZVKB32-NEXT:    addi sp, sp, 16
; CHECK-ZVKB32-NEXT:    ret
;
; CHECK-ZVKB64-LABEL: vandn_vx_nxv2i64:
; CHECK-ZVKB64:       # %bb.0:
; CHECK-ZVKB64-NEXT:    vsetvli a1, zero, e64, m2, ta, ma
; CHECK-ZVKB64-NEXT:    vandn.vx v8, v8, a0
; CHECK-ZVKB64-NEXT:    ret
  %a = xor i64 %x, -1
  %head = insertelement <vscale x 2 x i64> poison, i64 %a, i32 0
  %splat = shufflevector <vscale x 2 x i64> %head, <vscale x 2 x i64> poison, <vscale x 2 x i32> zeroinitializer
  %b = and <vscale x 2 x i64> %splat, %y
  ret <vscale x 2 x i64> %b
}

define <vscale x 2 x i64> @vandn_vx_swapped_nxv2i64(i64 %x, <vscale x 2 x i64> %y) {
; CHECK-RV32-LABEL: vandn_vx_swapped_nxv2i64:
; CHECK-RV32:       # %bb.0:
; CHECK-RV32-NEXT:    addi sp, sp, -16
; CHECK-RV32-NEXT:    .cfi_def_cfa_offset 16
; CHECK-RV32-NEXT:    not a0, a0
; CHECK-RV32-NEXT:    not a1, a1
; CHECK-RV32-NEXT:    sw a1, 12(sp)
; CHECK-RV32-NEXT:    sw a0, 8(sp)
; CHECK-RV32-NEXT:    addi a0, sp, 8
; CHECK-RV32-NEXT:    vsetvli a1, zero, e64, m2, ta, ma
; CHECK-RV32-NEXT:    vlse64.v v10, (a0), zero
; CHECK-RV32-NEXT:    vand.vv v8, v10, v8
; CHECK-RV32-NEXT:    addi sp, sp, 16
; CHECK-RV32-NEXT:    ret
;
; CHECK-RV64-LABEL: vandn_vx_swapped_nxv2i64:
; CHECK-RV64:       # %bb.0:
; CHECK-RV64-NEXT:    not a0, a0
; CHECK-RV64-NEXT:    vsetvli a1, zero, e64, m2, ta, ma
; CHECK-RV64-NEXT:    vand.vx v8, v8, a0
; CHECK-RV64-NEXT:    ret
;
; CHECK-ZVKB32-LABEL: vandn_vx_swapped_nxv2i64:
; CHECK-ZVKB32:       # %bb.0:
; CHECK-ZVKB32-NEXT:    addi sp, sp, -16
; CHECK-ZVKB32-NEXT:    .cfi_def_cfa_offset 16
; CHECK-ZVKB32-NEXT:    not a0, a0
; CHECK-ZVKB32-NEXT:    not a1, a1
; CHECK-ZVKB32-NEXT:    sw a1, 12(sp)
; CHECK-ZVKB32-NEXT:    sw a0, 8(sp)
; CHECK-ZVKB32-NEXT:    addi a0, sp, 8
; CHECK-ZVKB32-NEXT:    vsetvli a1, zero, e64, m2, ta, ma
; CHECK-ZVKB32-NEXT:    vlse64.v v10, (a0), zero
; CHECK-ZVKB32-NEXT:    vand.vv v8, v10, v8
; CHECK-ZVKB32-NEXT:    addi sp, sp, 16
; CHECK-ZVKB32-NEXT:    ret
;
; CHECK-ZVKB64-LABEL: vandn_vx_swapped_nxv2i64:
; CHECK-ZVKB64:       # %bb.0:
; CHECK-ZVKB64-NEXT:    vsetvli a1, zero, e64, m2, ta, ma
; CHECK-ZVKB64-NEXT:    vandn.vx v8, v8, a0
; CHECK-ZVKB64-NEXT:    ret
  %a = xor i64 %x, -1
  %head = insertelement <vscale x 2 x i64> poison, i64 %a, i32 0
  %splat = shufflevector <vscale x 2 x i64> %head, <vscale x 2 x i64> poison, <vscale x 2 x i32> zeroinitializer
  %b = and <vscale x 2 x i64> %splat, %y
  ret <vscale x 2 x i64> %b
}

define <vscale x 4 x i64> @vandn_vv_nxv4i64(<vscale x 4 x i64> %x, <vscale x 4 x i64> %y) {
; CHECK-LABEL: vandn_vv_nxv4i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; CHECK-NEXT:    vnot.v v8, v8
; CHECK-NEXT:    vand.vv v8, v8, v12
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_nxv4i64:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v12, v8
; CHECK-ZVKB-NEXT:    ret
  %head = insertelement <vscale x 4 x i64> poison, i64 -1, i32 0
  %splat = shufflevector <vscale x 4 x i64> %head, <vscale x 4 x i64> poison, <vscale x 4 x i32> zeroinitializer
  %a = xor <vscale x 4 x i64> %x, %splat
  %b = and <vscale x 4 x i64> %a, %y
  ret <vscale x 4 x i64> %b
}

define <vscale x 4 x i64> @vandn_vv_swapped_nxv4i64(<vscale x 4 x i64> %x, <vscale x 4 x i64> %y) {
; CHECK-LABEL: vandn_vv_swapped_nxv4i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; CHECK-NEXT:    vnot.v v8, v8
; CHECK-NEXT:    vand.vv v8, v12, v8
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_swapped_nxv4i64:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v12, v8
; CHECK-ZVKB-NEXT:    ret
  %head = insertelement <vscale x 4 x i64> poison, i64 -1, i32 0
  %splat = shufflevector <vscale x 4 x i64> %head, <vscale x 4 x i64> poison, <vscale x 4 x i32> zeroinitializer
  %a = xor <vscale x 4 x i64> %x, %splat
  %b = and <vscale x 4 x i64> %y, %a
  ret <vscale x 4 x i64> %b
}

define <vscale x 4 x i64> @vandn_vx_nxv4i64(i64 %x, <vscale x 4 x i64> %y) {
; CHECK-RV32-LABEL: vandn_vx_nxv4i64:
; CHECK-RV32:       # %bb.0:
; CHECK-RV32-NEXT:    addi sp, sp, -16
; CHECK-RV32-NEXT:    .cfi_def_cfa_offset 16
; CHECK-RV32-NEXT:    not a0, a0
; CHECK-RV32-NEXT:    not a1, a1
; CHECK-RV32-NEXT:    sw a1, 12(sp)
; CHECK-RV32-NEXT:    sw a0, 8(sp)
; CHECK-RV32-NEXT:    addi a0, sp, 8
; CHECK-RV32-NEXT:    vsetvli a1, zero, e64, m4, ta, ma
; CHECK-RV32-NEXT:    vlse64.v v12, (a0), zero
; CHECK-RV32-NEXT:    vand.vv v8, v12, v8
; CHECK-RV32-NEXT:    addi sp, sp, 16
; CHECK-RV32-NEXT:    ret
;
; CHECK-RV64-LABEL: vandn_vx_nxv4i64:
; CHECK-RV64:       # %bb.0:
; CHECK-RV64-NEXT:    not a0, a0
; CHECK-RV64-NEXT:    vsetvli a1, zero, e64, m4, ta, ma
; CHECK-RV64-NEXT:    vand.vx v8, v8, a0
; CHECK-RV64-NEXT:    ret
;
; CHECK-ZVKB32-LABEL: vandn_vx_nxv4i64:
; CHECK-ZVKB32:       # %bb.0:
; CHECK-ZVKB32-NEXT:    addi sp, sp, -16
; CHECK-ZVKB32-NEXT:    .cfi_def_cfa_offset 16
; CHECK-ZVKB32-NEXT:    not a0, a0
; CHECK-ZVKB32-NEXT:    not a1, a1
; CHECK-ZVKB32-NEXT:    sw a1, 12(sp)
; CHECK-ZVKB32-NEXT:    sw a0, 8(sp)
; CHECK-ZVKB32-NEXT:    addi a0, sp, 8
; CHECK-ZVKB32-NEXT:    vsetvli a1, zero, e64, m4, ta, ma
; CHECK-ZVKB32-NEXT:    vlse64.v v12, (a0), zero
; CHECK-ZVKB32-NEXT:    vand.vv v8, v12, v8
; CHECK-ZVKB32-NEXT:    addi sp, sp, 16
; CHECK-ZVKB32-NEXT:    ret
;
; CHECK-ZVKB64-LABEL: vandn_vx_nxv4i64:
; CHECK-ZVKB64:       # %bb.0:
; CHECK-ZVKB64-NEXT:    vsetvli a1, zero, e64, m4, ta, ma
; CHECK-ZVKB64-NEXT:    vandn.vx v8, v8, a0
; CHECK-ZVKB64-NEXT:    ret
  %a = xor i64 %x, -1
  %head = insertelement <vscale x 4 x i64> poison, i64 %a, i32 0
  %splat = shufflevector <vscale x 4 x i64> %head, <vscale x 4 x i64> poison, <vscale x 4 x i32> zeroinitializer
  %b = and <vscale x 4 x i64> %splat, %y
  ret <vscale x 4 x i64> %b
}

define <vscale x 4 x i64> @vandn_vx_swapped_nxv4i64(i64 %x, <vscale x 4 x i64> %y) {
; CHECK-RV32-LABEL: vandn_vx_swapped_nxv4i64:
; CHECK-RV32:       # %bb.0:
; CHECK-RV32-NEXT:    addi sp, sp, -16
; CHECK-RV32-NEXT:    .cfi_def_cfa_offset 16
; CHECK-RV32-NEXT:    not a0, a0
; CHECK-RV32-NEXT:    not a1, a1
; CHECK-RV32-NEXT:    sw a1, 12(sp)
; CHECK-RV32-NEXT:    sw a0, 8(sp)
; CHECK-RV32-NEXT:    addi a0, sp, 8
; CHECK-RV32-NEXT:    vsetvli a1, zero, e64, m4, ta, ma
; CHECK-RV32-NEXT:    vlse64.v v12, (a0), zero
; CHECK-RV32-NEXT:    vand.vv v8, v12, v8
; CHECK-RV32-NEXT:    addi sp, sp, 16
; CHECK-RV32-NEXT:    ret
;
; CHECK-RV64-LABEL: vandn_vx_swapped_nxv4i64:
; CHECK-RV64:       # %bb.0:
; CHECK-RV64-NEXT:    not a0, a0
; CHECK-RV64-NEXT:    vsetvli a1, zero, e64, m4, ta, ma
; CHECK-RV64-NEXT:    vand.vx v8, v8, a0
; CHECK-RV64-NEXT:    ret
;
; CHECK-ZVKB32-LABEL: vandn_vx_swapped_nxv4i64:
; CHECK-ZVKB32:       # %bb.0:
; CHECK-ZVKB32-NEXT:    addi sp, sp, -16
; CHECK-ZVKB32-NEXT:    .cfi_def_cfa_offset 16
; CHECK-ZVKB32-NEXT:    not a0, a0
; CHECK-ZVKB32-NEXT:    not a1, a1
; CHECK-ZVKB32-NEXT:    sw a1, 12(sp)
; CHECK-ZVKB32-NEXT:    sw a0, 8(sp)
; CHECK-ZVKB32-NEXT:    addi a0, sp, 8
; CHECK-ZVKB32-NEXT:    vsetvli a1, zero, e64, m4, ta, ma
; CHECK-ZVKB32-NEXT:    vlse64.v v12, (a0), zero
; CHECK-ZVKB32-NEXT:    vand.vv v8, v12, v8
; CHECK-ZVKB32-NEXT:    addi sp, sp, 16
; CHECK-ZVKB32-NEXT:    ret
;
; CHECK-ZVKB64-LABEL: vandn_vx_swapped_nxv4i64:
; CHECK-ZVKB64:       # %bb.0:
; CHECK-ZVKB64-NEXT:    vsetvli a1, zero, e64, m4, ta, ma
; CHECK-ZVKB64-NEXT:    vandn.vx v8, v8, a0
; CHECK-ZVKB64-NEXT:    ret
  %a = xor i64 %x, -1
  %head = insertelement <vscale x 4 x i64> poison, i64 %a, i32 0
  %splat = shufflevector <vscale x 4 x i64> %head, <vscale x 4 x i64> poison, <vscale x 4 x i32> zeroinitializer
  %b = and <vscale x 4 x i64> %splat, %y
  ret <vscale x 4 x i64> %b
}

define <vscale x 8 x i64> @vandn_vv_nxv8i64(<vscale x 8 x i64> %x, <vscale x 8 x i64> %y) {
; CHECK-LABEL: vandn_vv_nxv8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vnot.v v8, v8
; CHECK-NEXT:    vand.vv v8, v8, v16
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_nxv8i64:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v16, v8
; CHECK-ZVKB-NEXT:    ret
  %head = insertelement <vscale x 8 x i64> poison, i64 -1, i32 0
  %splat = shufflevector <vscale x 8 x i64> %head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %a = xor <vscale x 8 x i64> %x, %splat
  %b = and <vscale x 8 x i64> %a, %y
  ret <vscale x 8 x i64> %b
}

define <vscale x 8 x i64> @vandn_vv_swapped_nxv8i64(<vscale x 8 x i64> %x, <vscale x 8 x i64> %y) {
; CHECK-LABEL: vandn_vv_swapped_nxv8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vnot.v v8, v8
; CHECK-NEXT:    vand.vv v8, v16, v8
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_swapped_nxv8i64:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v16, v8
; CHECK-ZVKB-NEXT:    ret
  %head = insertelement <vscale x 8 x i64> poison, i64 -1, i32 0
  %splat = shufflevector <vscale x 8 x i64> %head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %a = xor <vscale x 8 x i64> %x, %splat
  %b = and <vscale x 8 x i64> %y, %a
  ret <vscale x 8 x i64> %b
}

define <vscale x 8 x i64> @vandn_vx_nxv8i64(i64 %x, <vscale x 8 x i64> %y) {
; CHECK-RV32-LABEL: vandn_vx_nxv8i64:
; CHECK-RV32:       # %bb.0:
; CHECK-RV32-NEXT:    addi sp, sp, -16
; CHECK-RV32-NEXT:    .cfi_def_cfa_offset 16
; CHECK-RV32-NEXT:    not a0, a0
; CHECK-RV32-NEXT:    not a1, a1
; CHECK-RV32-NEXT:    sw a1, 12(sp)
; CHECK-RV32-NEXT:    sw a0, 8(sp)
; CHECK-RV32-NEXT:    addi a0, sp, 8
; CHECK-RV32-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; CHECK-RV32-NEXT:    vlse64.v v16, (a0), zero
; CHECK-RV32-NEXT:    vand.vv v8, v16, v8
; CHECK-RV32-NEXT:    addi sp, sp, 16
; CHECK-RV32-NEXT:    ret
;
; CHECK-RV64-LABEL: vandn_vx_nxv8i64:
; CHECK-RV64:       # %bb.0:
; CHECK-RV64-NEXT:    not a0, a0
; CHECK-RV64-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; CHECK-RV64-NEXT:    vand.vx v8, v8, a0
; CHECK-RV64-NEXT:    ret
;
; CHECK-ZVKB32-LABEL: vandn_vx_nxv8i64:
; CHECK-ZVKB32:       # %bb.0:
; CHECK-ZVKB32-NEXT:    addi sp, sp, -16
; CHECK-ZVKB32-NEXT:    .cfi_def_cfa_offset 16
; CHECK-ZVKB32-NEXT:    not a0, a0
; CHECK-ZVKB32-NEXT:    not a1, a1
; CHECK-ZVKB32-NEXT:    sw a1, 12(sp)
; CHECK-ZVKB32-NEXT:    sw a0, 8(sp)
; CHECK-ZVKB32-NEXT:    addi a0, sp, 8
; CHECK-ZVKB32-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; CHECK-ZVKB32-NEXT:    vlse64.v v16, (a0), zero
; CHECK-ZVKB32-NEXT:    vand.vv v8, v16, v8
; CHECK-ZVKB32-NEXT:    addi sp, sp, 16
; CHECK-ZVKB32-NEXT:    ret
;
; CHECK-ZVKB64-LABEL: vandn_vx_nxv8i64:
; CHECK-ZVKB64:       # %bb.0:
; CHECK-ZVKB64-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; CHECK-ZVKB64-NEXT:    vandn.vx v8, v8, a0
; CHECK-ZVKB64-NEXT:    ret
  %a = xor i64 %x, -1
  %head = insertelement <vscale x 8 x i64> poison, i64 %a, i32 0
  %splat = shufflevector <vscale x 8 x i64> %head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %b = and <vscale x 8 x i64> %splat, %y
  ret <vscale x 8 x i64> %b
}

define <vscale x 8 x i64> @vandn_vx_swapped_nxv8i64(i64 %x, <vscale x 8 x i64> %y) {
; CHECK-RV32-LABEL: vandn_vx_swapped_nxv8i64:
; CHECK-RV32:       # %bb.0:
; CHECK-RV32-NEXT:    addi sp, sp, -16
; CHECK-RV32-NEXT:    .cfi_def_cfa_offset 16
; CHECK-RV32-NEXT:    not a0, a0
; CHECK-RV32-NEXT:    not a1, a1
; CHECK-RV32-NEXT:    sw a1, 12(sp)
; CHECK-RV32-NEXT:    sw a0, 8(sp)
; CHECK-RV32-NEXT:    addi a0, sp, 8
; CHECK-RV32-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; CHECK-RV32-NEXT:    vlse64.v v16, (a0), zero
; CHECK-RV32-NEXT:    vand.vv v8, v16, v8
; CHECK-RV32-NEXT:    addi sp, sp, 16
; CHECK-RV32-NEXT:    ret
;
; CHECK-RV64-LABEL: vandn_vx_swapped_nxv8i64:
; CHECK-RV64:       # %bb.0:
; CHECK-RV64-NEXT:    not a0, a0
; CHECK-RV64-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; CHECK-RV64-NEXT:    vand.vx v8, v8, a0
; CHECK-RV64-NEXT:    ret
;
; CHECK-ZVKB32-LABEL: vandn_vx_swapped_nxv8i64:
; CHECK-ZVKB32:       # %bb.0:
; CHECK-ZVKB32-NEXT:    addi sp, sp, -16
; CHECK-ZVKB32-NEXT:    .cfi_def_cfa_offset 16
; CHECK-ZVKB32-NEXT:    not a0, a0
; CHECK-ZVKB32-NEXT:    not a1, a1
; CHECK-ZVKB32-NEXT:    sw a1, 12(sp)
; CHECK-ZVKB32-NEXT:    sw a0, 8(sp)
; CHECK-ZVKB32-NEXT:    addi a0, sp, 8
; CHECK-ZVKB32-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; CHECK-ZVKB32-NEXT:    vlse64.v v16, (a0), zero
; CHECK-ZVKB32-NEXT:    vand.vv v8, v16, v8
; CHECK-ZVKB32-NEXT:    addi sp, sp, 16
; CHECK-ZVKB32-NEXT:    ret
;
; CHECK-ZVKB64-LABEL: vandn_vx_swapped_nxv8i64:
; CHECK-ZVKB64:       # %bb.0:
; CHECK-ZVKB64-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; CHECK-ZVKB64-NEXT:    vandn.vx v8, v8, a0
; CHECK-ZVKB64-NEXT:    ret
  %a = xor i64 %x, -1
  %head = insertelement <vscale x 8 x i64> poison, i64 %a, i32 0
  %splat = shufflevector <vscale x 8 x i64> %head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %b = and <vscale x 8 x i64> %splat, %y
  ret <vscale x 8 x i64> %b
}
