; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown | FileCheck %s --check-prefixes=CHECK,CHECK-NOBMI
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx2,+bmi2,+bmi | FileCheck %s --check-prefixes=CHECK,CHECK-BMI2,CHECK-AVX2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f,+avx512vl,+avx512vpopcntdq,+bmi2,+bmi | FileCheck %s --check-prefixes=CHECK,CHECK-BMI2,CHECK-AVX512

declare i32 @llvm.ctpop.i32(i32)
declare <4 x i64> @llvm.ctpop.v4i64(<4 x i64>)
define i1 @is_pow2_non_zero(i32 %xin) {
; CHECK-NOBMI-LABEL: is_pow2_non_zero:
; CHECK-NOBMI:       # %bb.0:
; CHECK-NOBMI-NEXT:    # kill: def $edi killed $edi def $rdi
; CHECK-NOBMI-NEXT:    orl $256, %edi # imm = 0x100
; CHECK-NOBMI-NEXT:    leal -1(%rdi), %eax
; CHECK-NOBMI-NEXT:    testl %eax, %edi
; CHECK-NOBMI-NEXT:    sete %al
; CHECK-NOBMI-NEXT:    retq
;
; CHECK-BMI2-LABEL: is_pow2_non_zero:
; CHECK-BMI2:       # %bb.0:
; CHECK-BMI2-NEXT:    orl $256, %edi # imm = 0x100
; CHECK-BMI2-NEXT:    blsrl %edi, %eax
; CHECK-BMI2-NEXT:    sete %al
; CHECK-BMI2-NEXT:    retq
  %x = or i32 %xin, 256
  %cnt = call i32 @llvm.ctpop.i32(i32 %x)
  %r = icmp eq i32 %cnt, 1
  ret i1 %r
}

define i1 @is_pow2_non_zero_x_maybe_z(i32 %x) {
; CHECK-LABEL: is_pow2_non_zero_x_maybe_z:
; CHECK:       # %bb.0:
; CHECK-NEXT:    # kill: def $edi killed $edi def $rdi
; CHECK-NEXT:    leal -1(%rdi), %eax
; CHECK-NEXT:    xorl %eax, %edi
; CHECK-NEXT:    cmpl %eax, %edi
; CHECK-NEXT:    seta %al
; CHECK-NEXT:    retq
  %cnt = call i32 @llvm.ctpop.i32(i32 %x)
  %r = icmp eq i32 %cnt, 1
  ret i1 %r
}

define i1 @neither_pow2_non_zero(i32 %xin) {
; CHECK-NOBMI-LABEL: neither_pow2_non_zero:
; CHECK-NOBMI:       # %bb.0:
; CHECK-NOBMI-NEXT:    # kill: def $edi killed $edi def $rdi
; CHECK-NOBMI-NEXT:    orl $256, %edi # imm = 0x100
; CHECK-NOBMI-NEXT:    leal -1(%rdi), %eax
; CHECK-NOBMI-NEXT:    testl %eax, %edi
; CHECK-NOBMI-NEXT:    setne %al
; CHECK-NOBMI-NEXT:    retq
;
; CHECK-BMI2-LABEL: neither_pow2_non_zero:
; CHECK-BMI2:       # %bb.0:
; CHECK-BMI2-NEXT:    orl $256, %edi # imm = 0x100
; CHECK-BMI2-NEXT:    blsrl %edi, %eax
; CHECK-BMI2-NEXT:    setne %al
; CHECK-BMI2-NEXT:    retq
  %x = or i32 %xin, 256
  %cnt = call i32 @llvm.ctpop.i32(i32 %x)
  %r = icmp ne i32 %cnt, 1
  ret i1 %r
}

define <4 x i1> @is_pow2_non_zero_4xv64(<4 x i64> %xin) {
; CHECK-NOBMI-LABEL: is_pow2_non_zero_4xv64:
; CHECK-NOBMI:       # %bb.0:
; CHECK-NOBMI-NEXT:    movdqa {{.*#+}} xmm2 = [256,256]
; CHECK-NOBMI-NEXT:    por %xmm2, %xmm0
; CHECK-NOBMI-NEXT:    por %xmm2, %xmm1
; CHECK-NOBMI-NEXT:    pcmpeqd %xmm2, %xmm2
; CHECK-NOBMI-NEXT:    movdqa %xmm1, %xmm3
; CHECK-NOBMI-NEXT:    paddq %xmm2, %xmm3
; CHECK-NOBMI-NEXT:    pand %xmm1, %xmm3
; CHECK-NOBMI-NEXT:    pxor %xmm1, %xmm1
; CHECK-NOBMI-NEXT:    pcmpeqd %xmm1, %xmm3
; CHECK-NOBMI-NEXT:    paddq %xmm0, %xmm2
; CHECK-NOBMI-NEXT:    pand %xmm2, %xmm0
; CHECK-NOBMI-NEXT:    pcmpeqd %xmm1, %xmm0
; CHECK-NOBMI-NEXT:    movdqa %xmm0, %xmm1
; CHECK-NOBMI-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,3],xmm3[1,3]
; CHECK-NOBMI-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,2],xmm3[0,2]
; CHECK-NOBMI-NEXT:    andps %xmm1, %xmm0
; CHECK-NOBMI-NEXT:    retq
;
; CHECK-AVX2-LABEL: is_pow2_non_zero_4xv64:
; CHECK-AVX2:       # %bb.0:
; CHECK-AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [256,256,256,256]
; CHECK-AVX2-NEXT:    vpor %ymm1, %ymm0, %ymm0
; CHECK-AVX2-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; CHECK-AVX2-NEXT:    vpaddq %ymm1, %ymm0, %ymm1
; CHECK-AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; CHECK-AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; CHECK-AVX2-NEXT:    vpcmpeqq %ymm1, %ymm0, %ymm0
; CHECK-AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; CHECK-AVX2-NEXT:    vpackssdw %xmm1, %xmm0, %xmm0
; CHECK-AVX2-NEXT:    vzeroupper
; CHECK-AVX2-NEXT:    retq
;
; CHECK-AVX512-LABEL: is_pow2_non_zero_4xv64:
; CHECK-AVX512:       # %bb.0:
; CHECK-AVX512-NEXT:    vporq {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %ymm0, %ymm0
; CHECK-AVX512-NEXT:    vpopcntq %ymm0, %ymm0
; CHECK-AVX512-NEXT:    vpcmpeqq {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %ymm0, %k1
; CHECK-AVX512-NEXT:    vpcmpeqd %xmm0, %xmm0, %xmm0
; CHECK-AVX512-NEXT:    vmovdqa32 %xmm0, %xmm0 {%k1} {z}
; CHECK-AVX512-NEXT:    vzeroupper
; CHECK-AVX512-NEXT:    retq
  %x = or <4 x i64> %xin, <i64 256, i64 256, i64 256, i64 256>
  %cnt = call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %x)
  %r = icmp eq <4 x i64> %cnt, <i64 1, i64 1, i64 1, i64 1>
  ret <4 x i1> %r
}

define <4 x i1> @neither_pow2_non_zero_4xv64(<4 x i64> %xin) {
; CHECK-NOBMI-LABEL: neither_pow2_non_zero_4xv64:
; CHECK-NOBMI:       # %bb.0:
; CHECK-NOBMI-NEXT:    movdqa {{.*#+}} xmm2 = [256,256]
; CHECK-NOBMI-NEXT:    por %xmm2, %xmm0
; CHECK-NOBMI-NEXT:    por %xmm2, %xmm1
; CHECK-NOBMI-NEXT:    pcmpeqd %xmm2, %xmm2
; CHECK-NOBMI-NEXT:    movdqa %xmm1, %xmm3
; CHECK-NOBMI-NEXT:    paddq %xmm2, %xmm3
; CHECK-NOBMI-NEXT:    pand %xmm1, %xmm3
; CHECK-NOBMI-NEXT:    pxor %xmm1, %xmm1
; CHECK-NOBMI-NEXT:    pcmpeqd %xmm1, %xmm3
; CHECK-NOBMI-NEXT:    movdqa %xmm0, %xmm4
; CHECK-NOBMI-NEXT:    paddq %xmm2, %xmm4
; CHECK-NOBMI-NEXT:    pand %xmm4, %xmm0
; CHECK-NOBMI-NEXT:    pcmpeqd %xmm1, %xmm0
; CHECK-NOBMI-NEXT:    movdqa %xmm0, %xmm1
; CHECK-NOBMI-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,3],xmm3[1,3]
; CHECK-NOBMI-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,2],xmm3[0,2]
; CHECK-NOBMI-NEXT:    andps %xmm1, %xmm0
; CHECK-NOBMI-NEXT:    xorps %xmm2, %xmm0
; CHECK-NOBMI-NEXT:    retq
;
; CHECK-AVX2-LABEL: neither_pow2_non_zero_4xv64:
; CHECK-AVX2:       # %bb.0:
; CHECK-AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [256,256,256,256]
; CHECK-AVX2-NEXT:    vpor %ymm1, %ymm0, %ymm0
; CHECK-AVX2-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; CHECK-AVX2-NEXT:    vpaddq %ymm1, %ymm0, %ymm2
; CHECK-AVX2-NEXT:    vpand %ymm2, %ymm0, %ymm0
; CHECK-AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; CHECK-AVX2-NEXT:    vpcmpeqq %ymm2, %ymm0, %ymm0
; CHECK-AVX2-NEXT:    vpxor %ymm1, %ymm0, %ymm0
; CHECK-AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; CHECK-AVX2-NEXT:    vpackssdw %xmm1, %xmm0, %xmm0
; CHECK-AVX2-NEXT:    vzeroupper
; CHECK-AVX2-NEXT:    retq
;
; CHECK-AVX512-LABEL: neither_pow2_non_zero_4xv64:
; CHECK-AVX512:       # %bb.0:
; CHECK-AVX512-NEXT:    vporq {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %ymm0, %ymm0
; CHECK-AVX512-NEXT:    vpopcntq %ymm0, %ymm0
; CHECK-AVX512-NEXT:    vpcmpneqq {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %ymm0, %k1
; CHECK-AVX512-NEXT:    vpcmpeqd %xmm0, %xmm0, %xmm0
; CHECK-AVX512-NEXT:    vmovdqa32 %xmm0, %xmm0 {%k1} {z}
; CHECK-AVX512-NEXT:    vzeroupper
; CHECK-AVX512-NEXT:    retq
  %x = or <4 x i64> %xin, <i64 256, i64 256, i64 256, i64 256>
  %cnt = call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %x)
  %r = icmp ne <4 x i64> %cnt, <i64 1, i64 1, i64 1, i64 1>
  ret <4 x i1> %r
}

define <4 x i1> @neither_pow2_non_zero_4xv64_x_maybe_z(<4 x i64> %x) {
; CHECK-NOBMI-LABEL: neither_pow2_non_zero_4xv64_x_maybe_z:
; CHECK-NOBMI:       # %bb.0:
; CHECK-NOBMI-NEXT:    pcmpeqd %xmm2, %xmm2
; CHECK-NOBMI-NEXT:    movdqa %xmm1, %xmm3
; CHECK-NOBMI-NEXT:    paddq %xmm2, %xmm3
; CHECK-NOBMI-NEXT:    movdqa {{.*#+}} xmm4 = [9223372039002259456,9223372039002259456]
; CHECK-NOBMI-NEXT:    pxor %xmm4, %xmm3
; CHECK-NOBMI-NEXT:    pxor %xmm3, %xmm1
; CHECK-NOBMI-NEXT:    movdqa %xmm1, %xmm5
; CHECK-NOBMI-NEXT:    pcmpgtd %xmm3, %xmm5
; CHECK-NOBMI-NEXT:    movdqa %xmm0, %xmm6
; CHECK-NOBMI-NEXT:    paddq %xmm2, %xmm6
; CHECK-NOBMI-NEXT:    pxor %xmm4, %xmm6
; CHECK-NOBMI-NEXT:    pxor %xmm6, %xmm0
; CHECK-NOBMI-NEXT:    movdqa %xmm0, %xmm4
; CHECK-NOBMI-NEXT:    pcmpgtd %xmm6, %xmm4
; CHECK-NOBMI-NEXT:    movdqa %xmm4, %xmm7
; CHECK-NOBMI-NEXT:    shufps {{.*#+}} xmm7 = xmm7[0,2],xmm5[0,2]
; CHECK-NOBMI-NEXT:    pcmpeqd %xmm3, %xmm1
; CHECK-NOBMI-NEXT:    pcmpeqd %xmm6, %xmm0
; CHECK-NOBMI-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,3],xmm1[1,3]
; CHECK-NOBMI-NEXT:    andps %xmm7, %xmm0
; CHECK-NOBMI-NEXT:    shufps {{.*#+}} xmm4 = xmm4[1,3],xmm5[1,3]
; CHECK-NOBMI-NEXT:    orps %xmm4, %xmm0
; CHECK-NOBMI-NEXT:    xorps %xmm2, %xmm0
; CHECK-NOBMI-NEXT:    retq
;
; CHECK-AVX2-LABEL: neither_pow2_non_zero_4xv64_x_maybe_z:
; CHECK-AVX2:       # %bb.0:
; CHECK-AVX2-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; CHECK-AVX2-NEXT:    vpaddq %ymm1, %ymm0, %ymm2
; CHECK-AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm3 = [9223372036854775808,9223372036854775808,9223372036854775808,9223372036854775808]
; CHECK-AVX2-NEXT:    vpxor %ymm3, %ymm2, %ymm2
; CHECK-AVX2-NEXT:    vpxor %ymm0, %ymm2, %ymm0
; CHECK-AVX2-NEXT:    vpcmpgtq %ymm2, %ymm0, %ymm0
; CHECK-AVX2-NEXT:    vpxor %ymm1, %ymm0, %ymm0
; CHECK-AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; CHECK-AVX2-NEXT:    vpackssdw %xmm1, %xmm0, %xmm0
; CHECK-AVX2-NEXT:    vzeroupper
; CHECK-AVX2-NEXT:    retq
;
; CHECK-AVX512-LABEL: neither_pow2_non_zero_4xv64_x_maybe_z:
; CHECK-AVX512:       # %bb.0:
; CHECK-AVX512-NEXT:    vpopcntq %ymm0, %ymm0
; CHECK-AVX512-NEXT:    vpcmpneqq {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %ymm0, %k1
; CHECK-AVX512-NEXT:    vpcmpeqd %xmm0, %xmm0, %xmm0
; CHECK-AVX512-NEXT:    vmovdqa32 %xmm0, %xmm0 {%k1} {z}
; CHECK-AVX512-NEXT:    vzeroupper
; CHECK-AVX512-NEXT:    retq
  %cnt = call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %x)
  %r = icmp ne <4 x i64> %cnt, <i64 1, i64 1, i64 1, i64 1>
  ret <4 x i1> %r
}
