; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc -mtriple=aarch64-none-linux-gnu -mcpu=neoverse-n1 -verify-machineinstrs < %s | FileCheck %s

; The tests check the following optimization of DAGCombiner for AArch64:
; CMP(A,C)||CMP(B,C) => CMP(MIN/MAX(A,B), C)
; CMP(A,C)&&CMP(B,C) => CMP(MIN/MAX(A,B), C)

define i1 @test1(float %arg1, float %arg2, float %arg3) #0 {
; CHECK-LABEL: test1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fminnm s0, s0, s1
; CHECK-NEXT:    fcmp s0, s2
; CHECK-NEXT:    cset w0, mi
; CHECK-NEXT:    ret
  %cmp1 = fcmp olt float %arg1, %arg3
  %cmp2 = fcmp olt float %arg2, %arg3
  %or1  = or i1 %cmp1, %cmp2
  ret i1 %or1
}

define i1 @test2(double %arg1, double %arg2, double %arg3) #0 {
; CHECK-LABEL: test2:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fmaxnm d0, d0, d1
; CHECK-NEXT:    fcmp d0, d2
; CHECK-NEXT:    cset w0, gt
; CHECK-NEXT:    ret
  %cmp1 = fcmp ogt double %arg1, %arg3
  %cmp2 = fcmp ogt double %arg2, %arg3
  %or1  = or i1 %cmp1, %cmp2
  ret i1 %or1
}

; It is illegal to apply the optimization in the following two test cases
; because FMINNUM_IEEE and FMAXNUM_IEEE are not supported.

define i1 @test3(float %arg1, float %arg2, float %arg3) {
; CHECK-LABEL: test3:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fmov s3, #1.00000000
; CHECK-NEXT:    fadd s0, s0, s3
; CHECK-NEXT:    fmov s3, #2.00000000
; CHECK-NEXT:    fadd s1, s1, s3
; CHECK-NEXT:    fcmp s1, s2
; CHECK-NEXT:    fccmp s0, s2, #0, lt
; CHECK-NEXT:    cset w0, lt
; CHECK-NEXT:    ret
  %add1 = fadd nnan float %arg1, 1.0
  %add2 = fadd nnan float %arg2, 2.0
  %cmp1 = fcmp nnan olt float %add1, %arg3
  %cmp2 = fcmp nnan olt float %add2, %arg3
  %or1  = and i1 %cmp1, %cmp2
  ret i1 %or1
}

define i1 @test4(float %arg1, float %arg2, float %arg3) {
; CHECK-LABEL: test4:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fmov s3, #1.00000000
; CHECK-NEXT:    fadd s0, s0, s3
; CHECK-NEXT:    fmov s3, #2.00000000
; CHECK-NEXT:    fadd s1, s1, s3
; CHECK-NEXT:    fcmp s1, s2
; CHECK-NEXT:    fccmp s0, s2, #4, gt
; CHECK-NEXT:    cset w0, gt
; CHECK-NEXT:    ret
  %add1 = fadd nnan float %arg1, 1.0
  %add2 = fadd nnan float %arg2, 2.0
  %cmp1 = fcmp nnan ogt float %add1, %arg3
  %cmp2 = fcmp nnan ogt float %add2, %arg3
  %or1  = and i1 %cmp1, %cmp2
  ret i1 %or1
}

