; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc -mtriple=amdgcn -mcpu=tahiti -verify-machineinstrs -enable-misched=false < %s | FileCheck -check-prefixes=SI %s
; RUN: llc -mtriple=amdgcn -mcpu=fiji -mattr=-flat-for-global -verify-machineinstrs -enable-misched=false < %s | FileCheck -check-prefixes=VI %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -global-isel=0 -mattr=+real-true16,-flat-for-global -verify-machineinstrs -enable-misched=false < %s | FileCheck -check-prefixes=GFX11-SDAG %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -global-isel=1 -mattr=+real-true16,-flat-for-global -verify-machineinstrs -enable-misched=false < %s | FileCheck -check-prefixes=GFX11-GISEL %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -global-isel=0 -mattr=-real-true16,-flat-for-global -verify-machineinstrs -enable-misched=false < %s | FileCheck -check-prefixes=GFX11-FAKE16-SDAG %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -global-isel=1 -mattr=-real-true16,-flat-for-global -verify-machineinstrs -enable-misched=false < %s | FileCheck -check-prefixes=GFX11-FAKE16-GISEL %s

define amdgpu_kernel void @fadd_f16(
; SI-LABEL: fadd_f16:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; SI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0xd
; SI-NEXT:    s_mov_b32 s11, 0xf000
; SI-NEXT:    s_mov_b32 s10, -1
; SI-NEXT:    s_mov_b32 s2, s10
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s8, s4
; SI-NEXT:    s_mov_b32 s9, s5
; SI-NEXT:    s_mov_b32 s4, s6
; SI-NEXT:    s_mov_b32 s5, s7
; SI-NEXT:    s_mov_b32 s6, s10
; SI-NEXT:    s_mov_b32 s7, s11
; SI-NEXT:    s_mov_b32 s3, s11
; SI-NEXT:    buffer_load_ushort v0, off, s[4:7], 0 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_load_ushort v1, off, s[0:3], 0 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:    v_add_f32_e32 v0, v0, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    buffer_store_short v0, off, s[8:11], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: fadd_f16:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; VI-NEXT:    s_mov_b32 s11, 0xf000
; VI-NEXT:    s_mov_b32 s10, -1
; VI-NEXT:    s_mov_b32 s2, s10
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s8, s4
; VI-NEXT:    s_mov_b32 s9, s5
; VI-NEXT:    s_mov_b32 s4, s6
; VI-NEXT:    s_mov_b32 s5, s7
; VI-NEXT:    s_mov_b32 s6, s10
; VI-NEXT:    s_mov_b32 s7, s11
; VI-NEXT:    s_mov_b32 s3, s11
; VI-NEXT:    buffer_load_ushort v0, off, s[4:7], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_load_ushort v1, off, s[0:3], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_add_f16_e32 v0, v0, v1
; VI-NEXT:    buffer_store_short v0, off, s[8:11], 0
; VI-NEXT:    s_endpgm
;
; GFX11-SDAG-LABEL: fadd_f16:
; GFX11-SDAG:       ; %bb.0: ; %entry
; GFX11-SDAG-NEXT:    s_clause 0x1
; GFX11-SDAG-NEXT:    s_load_b128 s[4:7], s[0:1], 0x24
; GFX11-SDAG-NEXT:    s_load_b64 s[0:1], s[0:1], 0x34
; GFX11-SDAG-NEXT:    s_mov_b32 s11, 0x31016000
; GFX11-SDAG-NEXT:    s_mov_b32 s10, -1
; GFX11-SDAG-NEXT:    s_mov_b32 s3, s11
; GFX11-SDAG-NEXT:    s_mov_b32 s2, s10
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    s_mov_b32 s8, s4
; GFX11-SDAG-NEXT:    s_mov_b32 s9, s5
; GFX11-SDAG-NEXT:    s_mov_b32 s4, s6
; GFX11-SDAG-NEXT:    s_mov_b32 s5, s7
; GFX11-SDAG-NEXT:    s_mov_b32 s6, s10
; GFX11-SDAG-NEXT:    s_mov_b32 s7, s11
; GFX11-SDAG-NEXT:    buffer_load_u16 v0, off, s[4:7], 0 glc dlc
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX11-SDAG-NEXT:    buffer_load_u16 v1, off, s[0:3], 0 glc dlc
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX11-SDAG-NEXT:    v_mov_b16_e32 v0.h, v1.l
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_add_f16_e32 v0.l, v0.l, v0.h
; GFX11-SDAG-NEXT:    buffer_store_b16 v0, off, s[8:11], 0
; GFX11-SDAG-NEXT:    s_nop 0
; GFX11-SDAG-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: fadd_f16:
; GFX11-GISEL:       ; %bb.0: ; %entry
; GFX11-GISEL-NEXT:    s_clause 0x1
; GFX11-GISEL-NEXT:    s_load_b128 s[4:7], s[0:1], 0x24
; GFX11-GISEL-NEXT:    s_load_b64 s[0:1], s[0:1], 0x34
; GFX11-GISEL-NEXT:    s_mov_b32 s10, -1
; GFX11-GISEL-NEXT:    s_mov_b32 s11, 0x31016000
; GFX11-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-GISEL-NEXT:    s_mov_b64 s[2:3], s[10:11]
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX11-GISEL-NEXT:    s_mov_b64 s[6:7], s[10:11]
; GFX11-GISEL-NEXT:    buffer_load_u16 v0, off, s[8:11], 0 glc dlc
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-GISEL-NEXT:    buffer_load_u16 v1, off, s[0:3], 0 glc dlc
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-GISEL-NEXT:    v_mov_b16_e32 v0.h, v1.l
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_add_f16_e32 v0.l, v0.l, v0.h
; GFX11-GISEL-NEXT:    buffer_store_b16 v0, off, s[4:7], 0
; GFX11-GISEL-NEXT:    s_nop 0
; GFX11-GISEL-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-GISEL-NEXT:    s_endpgm
;
; GFX11-FAKE16-SDAG-LABEL: fadd_f16:
; GFX11-FAKE16-SDAG:       ; %bb.0: ; %entry
; GFX11-FAKE16-SDAG-NEXT:    s_clause 0x1
; GFX11-FAKE16-SDAG-NEXT:    s_load_b128 s[4:7], s[0:1], 0x24
; GFX11-FAKE16-SDAG-NEXT:    s_load_b64 s[0:1], s[0:1], 0x34
; GFX11-FAKE16-SDAG-NEXT:    s_mov_b32 s11, 0x31016000
; GFX11-FAKE16-SDAG-NEXT:    s_mov_b32 s10, -1
; GFX11-FAKE16-SDAG-NEXT:    s_mov_b32 s3, s11
; GFX11-FAKE16-SDAG-NEXT:    s_mov_b32 s2, s10
; GFX11-FAKE16-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-FAKE16-SDAG-NEXT:    s_mov_b32 s8, s4
; GFX11-FAKE16-SDAG-NEXT:    s_mov_b32 s9, s5
; GFX11-FAKE16-SDAG-NEXT:    s_mov_b32 s4, s6
; GFX11-FAKE16-SDAG-NEXT:    s_mov_b32 s5, s7
; GFX11-FAKE16-SDAG-NEXT:    s_mov_b32 s6, s10
; GFX11-FAKE16-SDAG-NEXT:    s_mov_b32 s7, s11
; GFX11-FAKE16-SDAG-NEXT:    buffer_load_u16 v0, off, s[4:7], 0 glc dlc
; GFX11-FAKE16-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FAKE16-SDAG-NEXT:    buffer_load_u16 v1, off, s[0:3], 0 glc dlc
; GFX11-FAKE16-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FAKE16-SDAG-NEXT:    v_add_f16_e32 v0, v0, v1
; GFX11-FAKE16-SDAG-NEXT:    buffer_store_b16 v0, off, s[8:11], 0
; GFX11-FAKE16-SDAG-NEXT:    s_nop 0
; GFX11-FAKE16-SDAG-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-FAKE16-SDAG-NEXT:    s_endpgm
;
; GFX11-FAKE16-GISEL-LABEL: fadd_f16:
; GFX11-FAKE16-GISEL:       ; %bb.0: ; %entry
; GFX11-FAKE16-GISEL-NEXT:    s_clause 0x1
; GFX11-FAKE16-GISEL-NEXT:    s_load_b128 s[4:7], s[0:1], 0x24
; GFX11-FAKE16-GISEL-NEXT:    s_load_b64 s[0:1], s[0:1], 0x34
; GFX11-FAKE16-GISEL-NEXT:    s_mov_b32 s10, -1
; GFX11-FAKE16-GISEL-NEXT:    s_mov_b32 s11, 0x31016000
; GFX11-FAKE16-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-FAKE16-GISEL-NEXT:    s_mov_b64 s[2:3], s[10:11]
; GFX11-FAKE16-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-FAKE16-GISEL-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX11-FAKE16-GISEL-NEXT:    s_mov_b64 s[6:7], s[10:11]
; GFX11-FAKE16-GISEL-NEXT:    buffer_load_u16 v0, off, s[8:11], 0 glc dlc
; GFX11-FAKE16-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FAKE16-GISEL-NEXT:    buffer_load_u16 v1, off, s[0:3], 0 glc dlc
; GFX11-FAKE16-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FAKE16-GISEL-NEXT:    v_add_f16_e32 v0, v0, v1
; GFX11-FAKE16-GISEL-NEXT:    buffer_store_b16 v0, off, s[4:7], 0
; GFX11-FAKE16-GISEL-NEXT:    s_nop 0
; GFX11-FAKE16-GISEL-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-FAKE16-GISEL-NEXT:    s_endpgm
; GFX11-LABEL: fadd_f16:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b128 s[4:7], s[0:1], 0x24
; GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x34
; GFX11-NEXT:    s_mov_b32 s11, 0x31016000
; GFX11-NEXT:    s_mov_b32 s10, -1
; GFX11-NEXT:    s_mov_b32 s3, s11
; GFX11-NEXT:    s_mov_b32 s2, s10
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s8, s4
; GFX11-NEXT:    s_mov_b32 s9, s5
; GFX11-NEXT:    s_mov_b32 s4, s6
; GFX11-NEXT:    s_mov_b32 s5, s7
; GFX11-NEXT:    s_mov_b32 s6, s10
; GFX11-NEXT:    s_mov_b32 s7, s11
; GFX11-NEXT:    buffer_load_u16 v0, off, s[4:7], 0 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_load_u16 v1, off, s[0:3], 0 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_mov_b16_e32 v0.h, v1.l
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_add_f16_e32 v0.l, v0.l, v0.h
; GFX11-NEXT:    buffer_store_b16 v0, off, s[8:11], 0
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
    ptr addrspace(1) %r,
    ptr addrspace(1) %a,
    ptr addrspace(1) %b) {
entry:
  %a.val = load volatile half, ptr addrspace(1) %a
  %b.val = load volatile half, ptr addrspace(1) %b
  %r.val = fadd half %a.val, %b.val
  store half %r.val, ptr addrspace(1) %r
  ret void
}

define amdgpu_kernel void @fadd_f16_imm_a(
; SI-LABEL: fadd_f16_imm_a:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_mov_b32 s0, s2
; SI-NEXT:    s_mov_b32 s1, s3
; SI-NEXT:    s_mov_b32 s2, s6
; SI-NEXT:    s_mov_b32 s3, s7
; SI-NEXT:    buffer_load_ushort v0, off, s[0:3], 0
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    buffer_store_short v0, off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: fadd_f16_imm_a:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s4, s0
; VI-NEXT:    s_mov_b32 s5, s1
; VI-NEXT:    s_mov_b32 s0, s2
; VI-NEXT:    s_mov_b32 s1, s3
; VI-NEXT:    s_mov_b32 s2, s6
; VI-NEXT:    s_mov_b32 s3, s7
; VI-NEXT:    buffer_load_ushort v0, off, s[0:3], 0
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_add_f16_e32 v0, 1.0, v0
; VI-NEXT:    buffer_store_short v0, off, s[4:7], 0
; VI-NEXT:    s_endpgm
;
; GFX11-SDAG-LABEL: fadd_f16_imm_a:
; GFX11-SDAG:       ; %bb.0: ; %entry
; GFX11-SDAG-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-SDAG-NEXT:    s_mov_b32 s7, 0x31016000
; GFX11-SDAG-NEXT:    s_mov_b32 s6, -1
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    s_mov_b32 s4, s0
; GFX11-SDAG-NEXT:    s_mov_b32 s5, s1
; GFX11-SDAG-NEXT:    s_mov_b32 s0, s2
; GFX11-SDAG-NEXT:    s_mov_b32 s1, s3
; GFX11-SDAG-NEXT:    s_mov_b32 s2, s6
; GFX11-SDAG-NEXT:    s_mov_b32 s3, s7
; GFX11-SDAG-NEXT:    buffer_load_u16 v0, off, s[0:3], 0
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX11-SDAG-NEXT:    v_mov_b16_e32 v0.h, 0x3c00
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_add_f16_e32 v0.l, v0.l, v0.h
; GFX11-SDAG-NEXT:    buffer_store_b16 v0, off, s[4:7], 0
; GFX11-SDAG-NEXT:    s_nop 0
; GFX11-SDAG-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: fadd_f16_imm_a:
; GFX11-GISEL:       ; %bb.0: ; %entry
; GFX11-GISEL-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-GISEL-NEXT:    s_mov_b32 s6, -1
; GFX11-GISEL-NEXT:    s_mov_b32 s7, 0x31016000
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-GISEL-NEXT:    s_mov_b64 s[2:3], s[6:7]
; GFX11-GISEL-NEXT:    buffer_load_u16 v0, off, s[4:7], 0
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-GISEL-NEXT:    v_mov_b16_e32 v0.h, 0x3c00
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_add_f16_e32 v0.l, v0.l, v0.h
; GFX11-GISEL-NEXT:    buffer_store_b16 v0, off, s[0:3], 0
; GFX11-GISEL-NEXT:    s_nop 0
; GFX11-GISEL-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-GISEL-NEXT:    s_endpgm
;
; GFX11-FAKE16-SDAG-LABEL: fadd_f16_imm_a:
; GFX11-FAKE16-SDAG:       ; %bb.0: ; %entry
; GFX11-FAKE16-SDAG-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-FAKE16-SDAG-NEXT:    s_mov_b32 s7, 0x31016000
; GFX11-FAKE16-SDAG-NEXT:    s_mov_b32 s6, -1
; GFX11-FAKE16-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-FAKE16-SDAG-NEXT:    s_mov_b32 s4, s0
; GFX11-FAKE16-SDAG-NEXT:    s_mov_b32 s5, s1
; GFX11-FAKE16-SDAG-NEXT:    s_mov_b32 s0, s2
; GFX11-FAKE16-SDAG-NEXT:    s_mov_b32 s1, s3
; GFX11-FAKE16-SDAG-NEXT:    s_mov_b32 s2, s6
; GFX11-FAKE16-SDAG-NEXT:    s_mov_b32 s3, s7
; GFX11-FAKE16-SDAG-NEXT:    buffer_load_u16 v0, off, s[0:3], 0
; GFX11-FAKE16-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FAKE16-SDAG-NEXT:    v_add_f16_e32 v0, 1.0, v0
; GFX11-FAKE16-SDAG-NEXT:    buffer_store_b16 v0, off, s[4:7], 0
; GFX11-FAKE16-SDAG-NEXT:    s_nop 0
; GFX11-FAKE16-SDAG-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-FAKE16-SDAG-NEXT:    s_endpgm
;
; GFX11-FAKE16-GISEL-LABEL: fadd_f16_imm_a:
; GFX11-FAKE16-GISEL:       ; %bb.0: ; %entry
; GFX11-FAKE16-GISEL-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-FAKE16-GISEL-NEXT:    s_mov_b32 s6, -1
; GFX11-FAKE16-GISEL-NEXT:    s_mov_b32 s7, 0x31016000
; GFX11-FAKE16-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-FAKE16-GISEL-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-FAKE16-GISEL-NEXT:    s_mov_b64 s[2:3], s[6:7]
; GFX11-FAKE16-GISEL-NEXT:    buffer_load_u16 v0, off, s[4:7], 0
; GFX11-FAKE16-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FAKE16-GISEL-NEXT:    v_add_f16_e32 v0, 1.0, v0
; GFX11-FAKE16-GISEL-NEXT:    buffer_store_b16 v0, off, s[0:3], 0
; GFX11-FAKE16-GISEL-NEXT:    s_nop 0
; GFX11-FAKE16-GISEL-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-FAKE16-GISEL-NEXT:    s_endpgm
; GFX11-LABEL: fadd_f16_imm_a:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-NEXT:    s_mov_b32 s7, 0x31016000
; GFX11-NEXT:    s_mov_b32 s6, -1
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s4, s0
; GFX11-NEXT:    s_mov_b32 s5, s1
; GFX11-NEXT:    s_mov_b32 s0, s2
; GFX11-NEXT:    s_mov_b32 s1, s3
; GFX11-NEXT:    s_mov_b32 s2, s6
; GFX11-NEXT:    s_mov_b32 s3, s7
; GFX11-NEXT:    buffer_load_u16 v0, off, s[0:3], 0
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_mov_b16_e32 v0.h, 0x3c00
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_add_f16_e32 v0.l, v0.l, v0.h
; GFX11-NEXT:    buffer_store_b16 v0, off, s[4:7], 0
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
    ptr addrspace(1) %r,
    ptr addrspace(1) %b) {
entry:
  %b.val = load half, ptr addrspace(1) %b
  %r.val = fadd half 1.0, %b.val
  store half %r.val, ptr addrspace(1) %r
  ret void
}

define amdgpu_kernel void @fadd_f16_imm_b(
; SI-LABEL: fadd_f16_imm_b:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_mov_b32 s0, s2
; SI-NEXT:    s_mov_b32 s1, s3
; SI-NEXT:    s_mov_b32 s2, s6
; SI-NEXT:    s_mov_b32 s3, s7
; SI-NEXT:    buffer_load_ushort v0, off, s[0:3], 0
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_add_f32_e32 v0, 2.0, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    buffer_store_short v0, off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: fadd_f16_imm_b:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s4, s0
; VI-NEXT:    s_mov_b32 s5, s1
; VI-NEXT:    s_mov_b32 s0, s2
; VI-NEXT:    s_mov_b32 s1, s3
; VI-NEXT:    s_mov_b32 s2, s6
; VI-NEXT:    s_mov_b32 s3, s7
; VI-NEXT:    buffer_load_ushort v0, off, s[0:3], 0
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_add_f16_e32 v0, 2.0, v0
; VI-NEXT:    buffer_store_short v0, off, s[4:7], 0
; VI-NEXT:    s_endpgm
;
; GFX11-SDAG-LABEL: fadd_f16_imm_b:
; GFX11-SDAG:       ; %bb.0: ; %entry
; GFX11-SDAG-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-SDAG-NEXT:    s_mov_b32 s7, 0x31016000
; GFX11-SDAG-NEXT:    s_mov_b32 s6, -1
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    s_mov_b32 s4, s0
; GFX11-SDAG-NEXT:    s_mov_b32 s5, s1
; GFX11-SDAG-NEXT:    s_mov_b32 s0, s2
; GFX11-SDAG-NEXT:    s_mov_b32 s1, s3
; GFX11-SDAG-NEXT:    s_mov_b32 s2, s6
; GFX11-SDAG-NEXT:    s_mov_b32 s3, s7
; GFX11-SDAG-NEXT:    buffer_load_u16 v0, off, s[0:3], 0
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX11-SDAG-NEXT:    v_mov_b16_e32 v0.h, 0x4000
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_add_f16_e32 v0.l, v0.l, v0.h
; GFX11-SDAG-NEXT:    buffer_store_b16 v0, off, s[4:7], 0
; GFX11-SDAG-NEXT:    s_nop 0
; GFX11-SDAG-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: fadd_f16_imm_b:
; GFX11-GISEL:       ; %bb.0: ; %entry
; GFX11-GISEL-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-GISEL-NEXT:    s_mov_b32 s6, -1
; GFX11-GISEL-NEXT:    s_mov_b32 s7, 0x31016000
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-GISEL-NEXT:    s_mov_b64 s[2:3], s[6:7]
; GFX11-GISEL-NEXT:    buffer_load_u16 v0, off, s[4:7], 0
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-GISEL-NEXT:    v_mov_b16_e32 v0.h, 0x4000
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_add_f16_e32 v0.l, v0.l, v0.h
; GFX11-GISEL-NEXT:    buffer_store_b16 v0, off, s[0:3], 0
; GFX11-GISEL-NEXT:    s_nop 0
; GFX11-GISEL-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-GISEL-NEXT:    s_endpgm
;
; GFX11-FAKE16-SDAG-LABEL: fadd_f16_imm_b:
; GFX11-FAKE16-SDAG:       ; %bb.0: ; %entry
; GFX11-FAKE16-SDAG-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-FAKE16-SDAG-NEXT:    s_mov_b32 s7, 0x31016000
; GFX11-FAKE16-SDAG-NEXT:    s_mov_b32 s6, -1
; GFX11-FAKE16-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-FAKE16-SDAG-NEXT:    s_mov_b32 s4, s0
; GFX11-FAKE16-SDAG-NEXT:    s_mov_b32 s5, s1
; GFX11-FAKE16-SDAG-NEXT:    s_mov_b32 s0, s2
; GFX11-FAKE16-SDAG-NEXT:    s_mov_b32 s1, s3
; GFX11-FAKE16-SDAG-NEXT:    s_mov_b32 s2, s6
; GFX11-FAKE16-SDAG-NEXT:    s_mov_b32 s3, s7
; GFX11-FAKE16-SDAG-NEXT:    buffer_load_u16 v0, off, s[0:3], 0
; GFX11-FAKE16-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FAKE16-SDAG-NEXT:    v_add_f16_e32 v0, 2.0, v0
; GFX11-FAKE16-SDAG-NEXT:    buffer_store_b16 v0, off, s[4:7], 0
; GFX11-FAKE16-SDAG-NEXT:    s_nop 0
; GFX11-FAKE16-SDAG-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-FAKE16-SDAG-NEXT:    s_endpgm
;
; GFX11-FAKE16-GISEL-LABEL: fadd_f16_imm_b:
; GFX11-FAKE16-GISEL:       ; %bb.0: ; %entry
; GFX11-FAKE16-GISEL-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-FAKE16-GISEL-NEXT:    s_mov_b32 s6, -1
; GFX11-FAKE16-GISEL-NEXT:    s_mov_b32 s7, 0x31016000
; GFX11-FAKE16-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-FAKE16-GISEL-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-FAKE16-GISEL-NEXT:    s_mov_b64 s[2:3], s[6:7]
; GFX11-FAKE16-GISEL-NEXT:    buffer_load_u16 v0, off, s[4:7], 0
; GFX11-FAKE16-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FAKE16-GISEL-NEXT:    v_add_f16_e32 v0, 2.0, v0
; GFX11-FAKE16-GISEL-NEXT:    buffer_store_b16 v0, off, s[0:3], 0
; GFX11-FAKE16-GISEL-NEXT:    s_nop 0
; GFX11-FAKE16-GISEL-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-FAKE16-GISEL-NEXT:    s_endpgm
; GFX11-LABEL: fadd_f16_imm_b:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-NEXT:    s_mov_b32 s7, 0x31016000
; GFX11-NEXT:    s_mov_b32 s6, -1
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s4, s0
; GFX11-NEXT:    s_mov_b32 s5, s1
; GFX11-NEXT:    s_mov_b32 s0, s2
; GFX11-NEXT:    s_mov_b32 s1, s3
; GFX11-NEXT:    s_mov_b32 s2, s6
; GFX11-NEXT:    s_mov_b32 s3, s7
; GFX11-NEXT:    buffer_load_u16 v0, off, s[0:3], 0
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_mov_b16_e32 v0.h, 0x4000
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_add_f16_e32 v0.l, v0.l, v0.h
; GFX11-NEXT:    buffer_store_b16 v0, off, s[4:7], 0
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
    ptr addrspace(1) %r,
    ptr addrspace(1) %a) {
entry:
  %a.val = load half, ptr addrspace(1) %a
  %r.val = fadd half %a.val, 2.0
  store half %r.val, ptr addrspace(1) %r
  ret void
}

define amdgpu_kernel void @fadd_v2f16(
; SI-LABEL: fadd_v2f16:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; SI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0xd
; SI-NEXT:    s_mov_b32 s11, 0xf000
; SI-NEXT:    s_mov_b32 s14, 0
; SI-NEXT:    s_mov_b32 s15, s11
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b64 s[12:13], s[6:7]
; SI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-NEXT:    v_mov_b32_e32 v1, 0
; SI-NEXT:    s_mov_b64 s[2:3], s[14:15]
; SI-NEXT:    buffer_load_dword v2, v[0:1], s[12:15], 0 addr64
; SI-NEXT:    buffer_load_dword v0, v[0:1], s[0:3], 0 addr64
; SI-NEXT:    s_mov_b32 s10, -1
; SI-NEXT:    s_mov_b32 s8, s4
; SI-NEXT:    s_mov_b32 s9, s5
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v2
; SI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_add_f32_e32 v1, v3, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_add_f32_e32 v0, v2, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    buffer_store_dword v0, off, s[8:11], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: fadd_v2f16:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; VI-NEXT:    s_load_dwordx2 s[8:9], s[0:1], 0x34
; VI-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_add_u32_e32 v0, vcc, s6, v2
; VI-NEXT:    v_mov_b32_e32 v1, s7
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    v_add_u32_e32 v2, vcc, s8, v2
; VI-NEXT:    v_mov_b32_e32 v3, s9
; VI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; VI-NEXT:    flat_load_dword v0, v[0:1]
; VI-NEXT:    flat_load_dword v1, v[2:3]
; VI-NEXT:    s_mov_b32 s0, s4
; VI-NEXT:    s_mov_b32 s1, s5
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_add_f16_sdwa v2, v0, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; VI-NEXT:    v_add_f16_e32 v0, v0, v1
; VI-NEXT:    v_or_b32_e32 v0, v0, v2
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; GFX11-SDAG-LABEL: fadd_v2f16:
; GFX11-SDAG:       ; %bb.0: ; %entry
; GFX11-SDAG-NEXT:    s_clause 0x1
; GFX11-SDAG-NEXT:    s_load_b128 s[4:7], s[0:1], 0x24
; GFX11-SDAG-NEXT:    s_load_b64 s[8:9], s[0:1], 0x34
; GFX11-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-SDAG-NEXT:    s_mov_b32 s3, 0x31016000
; GFX11-SDAG-NEXT:    s_mov_b32 s2, -1
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    s_clause 0x1
; GFX11-SDAG-NEXT:    global_load_b32 v1, v0, s[6:7]
; GFX11-SDAG-NEXT:    global_load_b32 v0, v0, s[8:9]
; GFX11-SDAG-NEXT:    s_mov_b32 s0, s4
; GFX11-SDAG-NEXT:    s_mov_b32 s1, s5
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX11-SDAG-NEXT:    v_pk_add_f16 v0, v1, v0
; GFX11-SDAG-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX11-SDAG-NEXT:    s_nop 0
; GFX11-SDAG-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: fadd_v2f16:
; GFX11-GISEL:       ; %bb.0: ; %entry
; GFX11-GISEL-NEXT:    s_clause 0x1
; GFX11-GISEL-NEXT:    s_load_b128 s[4:7], s[0:1], 0x24
; GFX11-GISEL-NEXT:    s_load_b64 s[0:1], s[0:1], 0x34
; GFX11-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_clause 0x1
; GFX11-GISEL-NEXT:    global_load_b32 v1, v0, s[6:7]
; GFX11-GISEL-NEXT:    global_load_b32 v0, v0, s[0:1]
; GFX11-GISEL-NEXT:    s_mov_b32 s6, -1
; GFX11-GISEL-NEXT:    s_mov_b32 s7, 0x31016000
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-GISEL-NEXT:    v_pk_add_f16 v0, v1, v0
; GFX11-GISEL-NEXT:    buffer_store_b32 v0, off, s[4:7], 0
; GFX11-GISEL-NEXT:    s_nop 0
; GFX11-GISEL-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-GISEL-NEXT:    s_endpgm
;
; GFX11-FAKE16-SDAG-LABEL: fadd_v2f16:
; GFX11-FAKE16-SDAG:       ; %bb.0: ; %entry
; GFX11-FAKE16-SDAG-NEXT:    s_clause 0x1
; GFX11-FAKE16-SDAG-NEXT:    s_load_b128 s[4:7], s[0:1], 0x24
; GFX11-FAKE16-SDAG-NEXT:    s_load_b64 s[8:9], s[0:1], 0x34
; GFX11-FAKE16-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-FAKE16-SDAG-NEXT:    s_mov_b32 s3, 0x31016000
; GFX11-FAKE16-SDAG-NEXT:    s_mov_b32 s2, -1
; GFX11-FAKE16-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-FAKE16-SDAG-NEXT:    s_clause 0x1
; GFX11-FAKE16-SDAG-NEXT:    global_load_b32 v1, v0, s[6:7]
; GFX11-FAKE16-SDAG-NEXT:    global_load_b32 v0, v0, s[8:9]
; GFX11-FAKE16-SDAG-NEXT:    s_mov_b32 s0, s4
; GFX11-FAKE16-SDAG-NEXT:    s_mov_b32 s1, s5
; GFX11-FAKE16-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FAKE16-SDAG-NEXT:    v_pk_add_f16 v0, v1, v0
; GFX11-FAKE16-SDAG-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX11-FAKE16-SDAG-NEXT:    s_nop 0
; GFX11-FAKE16-SDAG-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-FAKE16-SDAG-NEXT:    s_endpgm
;
; GFX11-FAKE16-GISEL-LABEL: fadd_v2f16:
; GFX11-FAKE16-GISEL:       ; %bb.0: ; %entry
; GFX11-FAKE16-GISEL-NEXT:    s_clause 0x1
; GFX11-FAKE16-GISEL-NEXT:    s_load_b128 s[4:7], s[0:1], 0x24
; GFX11-FAKE16-GISEL-NEXT:    s_load_b64 s[0:1], s[0:1], 0x34
; GFX11-FAKE16-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-FAKE16-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-FAKE16-GISEL-NEXT:    s_clause 0x1
; GFX11-FAKE16-GISEL-NEXT:    global_load_b32 v1, v0, s[6:7]
; GFX11-FAKE16-GISEL-NEXT:    global_load_b32 v0, v0, s[0:1]
; GFX11-FAKE16-GISEL-NEXT:    s_mov_b32 s6, -1
; GFX11-FAKE16-GISEL-NEXT:    s_mov_b32 s7, 0x31016000
; GFX11-FAKE16-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FAKE16-GISEL-NEXT:    v_pk_add_f16 v0, v1, v0
; GFX11-FAKE16-GISEL-NEXT:    buffer_store_b32 v0, off, s[4:7], 0
; GFX11-FAKE16-GISEL-NEXT:    s_nop 0
; GFX11-FAKE16-GISEL-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-FAKE16-GISEL-NEXT:    s_endpgm
; GFX11-LABEL: fadd_v2f16:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b128 s[4:7], s[0:1], 0x24
; GFX11-NEXT:    s_load_b64 s[8:9], s[0:1], 0x34
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-NEXT:    s_mov_b32 s3, 0x31016000
; GFX11-NEXT:    s_mov_b32 s2, -1
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    global_load_b32 v1, v0, s[6:7]
; GFX11-NEXT:    global_load_b32 v0, v0, s[8:9]
; GFX11-NEXT:    s_mov_b32 s0, s4
; GFX11-NEXT:    s_mov_b32 s1, s5
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_pk_add_f16 v0, v1, v0
; GFX11-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
    ptr addrspace(1) %r,
    ptr addrspace(1) %a,
    ptr addrspace(1) %b) {
entry:
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %gep.a = getelementptr inbounds <2 x half>, ptr addrspace(1) %a, i32 %tid
  %gep.b = getelementptr inbounds <2 x half>, ptr addrspace(1) %b, i32 %tid
  %a.val = load <2 x half>, ptr addrspace(1) %gep.a
  %b.val = load <2 x half>, ptr addrspace(1) %gep.b
  %r.val = fadd <2 x half> %a.val, %b.val
  store <2 x half> %r.val, ptr addrspace(1) %r
  ret void
}

define amdgpu_kernel void @fadd_v2f16_imm_a(
; SI-LABEL: fadd_v2f16_imm_a:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s10, 0
; SI-NEXT:    s_mov_b32 s11, s7
; SI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b64 s[8:9], s[2:3]
; SI-NEXT:    v_mov_b32_e32 v1, 0
; SI-NEXT:    buffer_load_dword v0, v[0:1], s[8:11], 0 addr64
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_add_f32_e32 v0, 2.0, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: fadd_v2f16_imm_a:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; VI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v0
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dword v0, v[0:1]
; VI-NEXT:    v_mov_b32_e32 v1, 0x4000
; VI-NEXT:    s_mov_b32 s4, s0
; VI-NEXT:    s_mov_b32 s5, s1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_add_f16_sdwa v1, v0, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v0, 1.0, v0
; VI-NEXT:    v_or_b32_e32 v0, v0, v1
; VI-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; VI-NEXT:    s_endpgm
;
; GFX11-SDAG-LABEL: fadd_v2f16_imm_a:
; GFX11-SDAG:       ; %bb.0: ; %entry
; GFX11-SDAG-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-SDAG-NEXT:    s_mov_b32 s7, 0x31016000
; GFX11-SDAG-NEXT:    s_mov_b32 s6, -1
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    global_load_b32 v0, v0, s[2:3]
; GFX11-SDAG-NEXT:    s_mov_b32 s4, s0
; GFX11-SDAG-NEXT:    s_mov_b32 s5, s1
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX11-SDAG-NEXT:    v_pk_add_f16 v0, 0x40003c00, v0
; GFX11-SDAG-NEXT:    buffer_store_b32 v0, off, s[4:7], 0
; GFX11-SDAG-NEXT:    s_nop 0
; GFX11-SDAG-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: fadd_v2f16_imm_a:
; GFX11-GISEL:       ; %bb.0: ; %entry
; GFX11-GISEL-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    global_load_b32 v0, v0, s[2:3]
; GFX11-GISEL-NEXT:    s_mov_b32 s2, -1
; GFX11-GISEL-NEXT:    s_mov_b32 s3, 0x31016000
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-GISEL-NEXT:    v_pk_add_f16 v0, 0x40003c00, v0
; GFX11-GISEL-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX11-GISEL-NEXT:    s_nop 0
; GFX11-GISEL-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-GISEL-NEXT:    s_endpgm
;
; GFX11-FAKE16-SDAG-LABEL: fadd_v2f16_imm_a:
; GFX11-FAKE16-SDAG:       ; %bb.0: ; %entry
; GFX11-FAKE16-SDAG-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-FAKE16-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-FAKE16-SDAG-NEXT:    s_mov_b32 s7, 0x31016000
; GFX11-FAKE16-SDAG-NEXT:    s_mov_b32 s6, -1
; GFX11-FAKE16-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-FAKE16-SDAG-NEXT:    global_load_b32 v0, v0, s[2:3]
; GFX11-FAKE16-SDAG-NEXT:    s_mov_b32 s4, s0
; GFX11-FAKE16-SDAG-NEXT:    s_mov_b32 s5, s1
; GFX11-FAKE16-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FAKE16-SDAG-NEXT:    v_pk_add_f16 v0, 0x40003c00, v0
; GFX11-FAKE16-SDAG-NEXT:    buffer_store_b32 v0, off, s[4:7], 0
; GFX11-FAKE16-SDAG-NEXT:    s_nop 0
; GFX11-FAKE16-SDAG-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-FAKE16-SDAG-NEXT:    s_endpgm
;
; GFX11-FAKE16-GISEL-LABEL: fadd_v2f16_imm_a:
; GFX11-FAKE16-GISEL:       ; %bb.0: ; %entry
; GFX11-FAKE16-GISEL-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-FAKE16-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-FAKE16-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-FAKE16-GISEL-NEXT:    global_load_b32 v0, v0, s[2:3]
; GFX11-FAKE16-GISEL-NEXT:    s_mov_b32 s2, -1
; GFX11-FAKE16-GISEL-NEXT:    s_mov_b32 s3, 0x31016000
; GFX11-FAKE16-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FAKE16-GISEL-NEXT:    v_pk_add_f16 v0, 0x40003c00, v0
; GFX11-FAKE16-GISEL-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX11-FAKE16-GISEL-NEXT:    s_nop 0
; GFX11-FAKE16-GISEL-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-FAKE16-GISEL-NEXT:    s_endpgm
; GFX11-LABEL: fadd_v2f16_imm_a:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-NEXT:    s_mov_b32 s7, 0x31016000
; GFX11-NEXT:    s_mov_b32 s6, -1
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v0, v0, s[2:3]
; GFX11-NEXT:    s_mov_b32 s4, s0
; GFX11-NEXT:    s_mov_b32 s5, s1
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_pk_add_f16 v0, 0x40003c00, v0
; GFX11-NEXT:    buffer_store_b32 v0, off, s[4:7], 0
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
    ptr addrspace(1) %r,
    ptr addrspace(1) %b) {
entry:
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %gep.b = getelementptr inbounds <2 x half>, ptr addrspace(1) %b, i32 %tid
  %b.val = load <2 x half>, ptr addrspace(1) %gep.b
  %r.val = fadd <2 x half> <half 1.0, half 2.0>, %b.val
  store <2 x half> %r.val, ptr addrspace(1) %r
  ret void
}

define amdgpu_kernel void @fadd_v2f16_imm_b(
; SI-LABEL: fadd_v2f16_imm_b:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s10, 0
; SI-NEXT:    s_mov_b32 s11, s7
; SI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b64 s[8:9], s[2:3]
; SI-NEXT:    v_mov_b32_e32 v1, 0
; SI-NEXT:    buffer_load_dword v0, v[0:1], s[8:11], 0 addr64
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_add_f32_e32 v1, 2.0, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: fadd_v2f16_imm_b:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; VI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v0
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dword v0, v[0:1]
; VI-NEXT:    v_mov_b32_e32 v1, 0x3c00
; VI-NEXT:    s_mov_b32 s4, s0
; VI-NEXT:    s_mov_b32 s5, s1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_add_f16_sdwa v1, v0, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v0, 2.0, v0
; VI-NEXT:    v_or_b32_e32 v0, v0, v1
; VI-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; VI-NEXT:    s_endpgm
;
; GFX11-SDAG-LABEL: fadd_v2f16_imm_b:
; GFX11-SDAG:       ; %bb.0: ; %entry
; GFX11-SDAG-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-SDAG-NEXT:    s_mov_b32 s7, 0x31016000
; GFX11-SDAG-NEXT:    s_mov_b32 s6, -1
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    global_load_b32 v0, v0, s[2:3]
; GFX11-SDAG-NEXT:    s_mov_b32 s4, s0
; GFX11-SDAG-NEXT:    s_mov_b32 s5, s1
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX11-SDAG-NEXT:    v_pk_add_f16 v0, 0x3c004000, v0
; GFX11-SDAG-NEXT:    buffer_store_b32 v0, off, s[4:7], 0
; GFX11-SDAG-NEXT:    s_nop 0
; GFX11-SDAG-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: fadd_v2f16_imm_b:
; GFX11-GISEL:       ; %bb.0: ; %entry
; GFX11-GISEL-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    global_load_b32 v0, v0, s[2:3]
; GFX11-GISEL-NEXT:    s_mov_b32 s2, -1
; GFX11-GISEL-NEXT:    s_mov_b32 s3, 0x31016000
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-GISEL-NEXT:    v_pk_add_f16 v0, 0x3c004000, v0
; GFX11-GISEL-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX11-GISEL-NEXT:    s_nop 0
; GFX11-GISEL-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-GISEL-NEXT:    s_endpgm
;
; GFX11-FAKE16-SDAG-LABEL: fadd_v2f16_imm_b:
; GFX11-FAKE16-SDAG:       ; %bb.0: ; %entry
; GFX11-FAKE16-SDAG-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-FAKE16-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-FAKE16-SDAG-NEXT:    s_mov_b32 s7, 0x31016000
; GFX11-FAKE16-SDAG-NEXT:    s_mov_b32 s6, -1
; GFX11-FAKE16-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-FAKE16-SDAG-NEXT:    global_load_b32 v0, v0, s[2:3]
; GFX11-FAKE16-SDAG-NEXT:    s_mov_b32 s4, s0
; GFX11-FAKE16-SDAG-NEXT:    s_mov_b32 s5, s1
; GFX11-FAKE16-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FAKE16-SDAG-NEXT:    v_pk_add_f16 v0, 0x3c004000, v0
; GFX11-FAKE16-SDAG-NEXT:    buffer_store_b32 v0, off, s[4:7], 0
; GFX11-FAKE16-SDAG-NEXT:    s_nop 0
; GFX11-FAKE16-SDAG-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-FAKE16-SDAG-NEXT:    s_endpgm
;
; GFX11-FAKE16-GISEL-LABEL: fadd_v2f16_imm_b:
; GFX11-FAKE16-GISEL:       ; %bb.0: ; %entry
; GFX11-FAKE16-GISEL-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-FAKE16-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-FAKE16-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-FAKE16-GISEL-NEXT:    global_load_b32 v0, v0, s[2:3]
; GFX11-FAKE16-GISEL-NEXT:    s_mov_b32 s2, -1
; GFX11-FAKE16-GISEL-NEXT:    s_mov_b32 s3, 0x31016000
; GFX11-FAKE16-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FAKE16-GISEL-NEXT:    v_pk_add_f16 v0, 0x3c004000, v0
; GFX11-FAKE16-GISEL-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX11-FAKE16-GISEL-NEXT:    s_nop 0
; GFX11-FAKE16-GISEL-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-FAKE16-GISEL-NEXT:    s_endpgm
; GFX11-LABEL: fadd_v2f16_imm_b:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-NEXT:    s_mov_b32 s7, 0x31016000
; GFX11-NEXT:    s_mov_b32 s6, -1
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v0, v0, s[2:3]
; GFX11-NEXT:    s_mov_b32 s4, s0
; GFX11-NEXT:    s_mov_b32 s5, s1
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_pk_add_f16 v0, 0x3c004000, v0
; GFX11-NEXT:    buffer_store_b32 v0, off, s[4:7], 0
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
    ptr addrspace(1) %r,
    ptr addrspace(1) %a) {
entry:
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %gep.a = getelementptr inbounds <2 x half>, ptr addrspace(1) %a, i32 %tid
  %a.val = load <2 x half>, ptr addrspace(1) %gep.a
  %r.val = fadd <2 x half> %a.val, <half 2.0, half 1.0>
  store <2 x half> %r.val, ptr addrspace(1) %r
  ret void
}

declare i32 @llvm.amdgcn.workitem.id.x() #1

attributes #0 = { nounwind }
attributes #1 = { nounwind readnone }
