// RUN: llvm-mc -arch=amdgcn -show-encoding -mcpu=gfx1200 %s | FileCheck --check-prefix=GFX12 %s

s_movk_i32 s0, 0x1234
// GFX12: encoding: [0x34,0x12,0x00,0xb0]

s_movk_i32 s0, 0xc1d1
// GFX12: encoding: [0xd1,0xc1,0x00,0xb0]

s_movk_i32 s105, 0x1234
// GFX12: encoding: [0x34,0x12,0x69,0xb0]

s_movk_i32 exec_lo, 0x1234
// GFX12: encoding: [0x34,0x12,0x7e,0xb0]

s_movk_i32 exec_hi, 0x1234
// GFX12: encoding: [0x34,0x12,0x7f,0xb0]

s_movk_i32 vcc_lo, 0x1234
// GFX12: encoding: [0x34,0x12,0x6a,0xb0]

s_movk_i32 vcc_hi, 0x1234
// GFX12: encoding: [0x34,0x12,0x6b,0xb0]

s_movk_i32 m0, 0x1234
// GFX12: encoding: [0x34,0x12,0x7d,0xb0]

s_version 0x1234
// GFX12: encoding: [0x34,0x12,0x80,0xb0]

s_version 0xc1d1
// GFX12: encoding: [0xd1,0xc1,0x80,0xb0]

s_cmovk_i32 s0, 0x1234
// GFX12: encoding: [0x34,0x12,0x00,0xb1]

s_cmovk_i32 s0, 0xc1d1
// GFX12: encoding: [0xd1,0xc1,0x00,0xb1]

s_cmovk_i32 s105, 0x1234
// GFX12: encoding: [0x34,0x12,0x69,0xb1]

s_cmovk_i32 exec_lo, 0x1234
// GFX12: encoding: [0x34,0x12,0x7e,0xb1]

s_cmovk_i32 exec_hi, 0x1234
// GFX12: encoding: [0x34,0x12,0x7f,0xb1]

s_cmovk_i32 vcc_lo, 0x1234
// GFX12: encoding: [0x34,0x12,0x6a,0xb1]

s_cmovk_i32 vcc_hi, 0x1234
// GFX12: encoding: [0x34,0x12,0x6b,0xb1]

s_cmovk_i32 m0, 0x1234
// GFX12: encoding: [0x34,0x12,0x7d,0xb1]

s_addk_co_i32 s0, 0x1234
// GFX12: encoding: [0x34,0x12,0x80,0xb7]

s_addk_co_i32 s0, 0xc1d1
// GFX12: encoding: [0xd1,0xc1,0x80,0xb7]

s_addk_co_i32 s105, 0x1234
// GFX12: encoding: [0x34,0x12,0xe9,0xb7]

s_addk_co_i32 exec_lo, 0x1234
// GFX12: encoding: [0x34,0x12,0xfe,0xb7]

s_addk_co_i32 exec_hi, 0x1234
// GFX12: encoding: [0x34,0x12,0xff,0xb7]

s_addk_co_i32 vcc_lo, 0x1234
// GFX12: encoding: [0x34,0x12,0xea,0xb7]

s_addk_co_i32 vcc_hi, 0x1234
// GFX12: encoding: [0x34,0x12,0xeb,0xb7]

s_addk_co_i32 m0, 0x1234
// GFX12: encoding: [0x34,0x12,0xfd,0xb7]

s_mulk_i32 s0, 0x1234
// GFX12: encoding: [0x34,0x12,0x00,0xb8]

s_mulk_i32 s0, 0xc1d1
// GFX12: encoding: [0xd1,0xc1,0x00,0xb8]

s_mulk_i32 s105, 0x1234
// GFX12: encoding: [0x34,0x12,0x69,0xb8]

s_mulk_i32 exec_lo, 0x1234
// GFX12: encoding: [0x34,0x12,0x7e,0xb8]

s_mulk_i32 exec_hi, 0x1234
// GFX12: encoding: [0x34,0x12,0x7f,0xb8]

s_mulk_i32 vcc_lo, 0x1234
// GFX12: encoding: [0x34,0x12,0x6a,0xb8]

s_mulk_i32 vcc_hi, 0x1234
// GFX12: encoding: [0x34,0x12,0x6b,0xb8]

s_mulk_i32 m0, 0x1234
// GFX12: encoding: [0x34,0x12,0x7d,0xb8]

s_getreg_b32 s0, 0x1234
// GFX12: encoding: [0x34,0x12,0x80,0xb8]

s_getreg_b32 s0, 0xc1d1
// GFX12: encoding: [0xd1,0xc1,0x80,0xb8]

s_getreg_b32 s105, 0x1234
// GFX12: encoding: [0x34,0x12,0xe9,0xb8]

s_getreg_b32 exec_lo, 0x1234
// GFX12: encoding: [0x34,0x12,0xfe,0xb8]

s_getreg_b32 exec_hi, 0x1234
// GFX12: encoding: [0x34,0x12,0xff,0xb8]

s_getreg_b32 vcc_lo, 0x1234
// GFX12: encoding: [0x34,0x12,0xea,0xb8]

s_getreg_b32 vcc_hi, 0x1234
// GFX12: encoding: [0x34,0x12,0xeb,0xb8]

s_getreg_b32 m0, 0x1234
// GFX12: encoding: [0x34,0x12,0xfd,0xb8]

s_setreg_b32 0x1234, s0
// GFX12: encoding: [0x34,0x12,0x00,0xb9]

s_setreg_b32 0xc1d1, s0
// GFX12: encoding: [0xd1,0xc1,0x00,0xb9]

s_setreg_b32 0x1234, s105
// GFX12: encoding: [0x34,0x12,0x69,0xb9]

s_setreg_b32 0x1234, exec_lo
// GFX12: encoding: [0x34,0x12,0x7e,0xb9]

s_setreg_b32 0x1234, exec_hi
// GFX12: encoding: [0x34,0x12,0x7f,0xb9]

s_setreg_b32 0x1234, vcc_lo
// GFX12: encoding: [0x34,0x12,0x6a,0xb9]

s_setreg_b32 0x1234, vcc_hi
// GFX12: encoding: [0x34,0x12,0x6b,0xb9]

s_setreg_b32 0x1234, m0
// GFX12: encoding: [0x34,0x12,0x7d,0xb9]

s_setreg_imm32_b32 0x1234, 0x11213141
// GFX12: encoding: [0x34,0x12,0x80,0xb9,0x41,0x31,0x21,0x11]

s_setreg_imm32_b32 0xc1d1, 0x11213141
// GFX12: encoding: [0xd1,0xc1,0x80,0xb9,0x41,0x31,0x21,0x11]

s_setreg_imm32_b32 0x1234, 0xa1b1c1d1
// GFX12: encoding: [0x34,0x12,0x80,0xb9,0xd1,0xc1,0xb1,0xa1]

s_setreg_imm32_b32 0xc1d1, 0xa1b1c1d1
// GFX12: encoding: [0xd1,0xc1,0x80,0xb9,0xd1,0xc1,0xb1,0xa1]

s_call_b64 s[0:1], 0x1234
// GFX12: encoding: [0x34,0x12,0x00,0xba]

s_call_b64 s[104:105], 0x1234
// GFX12: encoding: [0x34,0x12,0x68,0xba]

s_call_b64 exec, 0x1234
// GFX12: encoding: [0x34,0x12,0x7e,0xba]

s_call_b64 vcc, 0x1234
// GFX12: encoding: [0x34,0x12,0x6a,0xba]

s_call_b64 null, 0x1234
// GFX12: encoding: [0x34,0x12,0x7c,0xba]

s_getreg_b32 s0, hwreg(HW_REG_MODE)
// GFX12: encoding: [0x01,0xf8,0x80,0xb8]

s_getreg_b32 s0, hwreg(HW_REG_STATUS)
// GFX12: encoding: [0x02,0xf8,0x80,0xb8]

s_getreg_b32 s0, hwreg(HW_REG_STATE_PRIV)
// GFX12: encoding: [0x04,0xf8,0x80,0xb8]

s_getreg_b32 s0, hwreg(HW_REG_GPR_ALLOC)
// GFX12: encoding: [0x05,0xf8,0x80,0xb8]

s_getreg_b32 s0, hwreg(HW_REG_LDS_ALLOC)
// GFX12: encoding: [0x06,0xf8,0x80,0xb8]

s_getreg_b32 s0, hwreg(HW_REG_IB_STS)
// GFX12: encoding: [0x07,0xf8,0x80,0xb8]

s_getreg_b32 s0, hwreg(HW_REG_PERF_SNAPSHOT_DATA)
// GFX12: encoding: [0x0a,0xf8,0x80,0xb8]

s_getreg_b32 s0, hwreg(HW_REG_PERF_SNAPSHOT_PC_LO)
// GFX12: encoding: [0x0b,0xf8,0x80,0xb8]

s_getreg_b32 s0, hwreg(HW_REG_PERF_SNAPSHOT_PC_HI)
// GFX12: encoding: [0x0c,0xf8,0x80,0xb8]

s_getreg_b32 s0, hwreg(HW_REG_PERF_SNAPSHOT_DATA1)
// GFX12: encoding: [0x0f,0xf8,0x80,0xb8]

s_getreg_b32 s0, hwreg(HW_REG_PERF_SNAPSHOT_DATA2)
// GFX12: encoding: [0x10,0xf8,0x80,0xb8]

s_getreg_b32 s0, hwreg(HW_REG_EXCP_FLAG_PRIV)
// GFX12: encoding: [0x11,0xf8,0x80,0xb8]

s_getreg_b32 s0, hwreg(HW_REG_EXCP_FLAG_USER)
// GFX12: encoding: [0x12,0xf8,0x80,0xb8]

s_getreg_b32 s0, hwreg(HW_REG_TRAP_CTRL)
// GFX12: encoding: [0x13,0xf8,0x80,0xb8]

s_getreg_b32 s0, hwreg(HW_REG_SCRATCH_BASE_LO)
// GFX12: encoding: [0x14,0xf8,0x80,0xb8]

s_getreg_b32 s0, hwreg(HW_REG_SCRATCH_BASE_HI)
// GFX12: encoding: [0x15,0xf8,0x80,0xb8]

s_getreg_b32 s0, hwreg(HW_REG_HW_ID1)
// GFX12: encoding: [0x17,0xf8,0x80,0xb8]

s_getreg_b32 s0, hwreg(HW_REG_HW_ID2)
// GFX12: encoding: [0x18,0xf8,0x80,0xb8]

s_getreg_b32 s0, hwreg(HW_REG_DVGPR_ALLOC_LO)
// GFX12: encoding: [0x1f,0xf8,0x80,0xb8]

s_getreg_b32 s0, hwreg(HW_REG_DVGPR_ALLOC_HI)
// GFX12: encoding: [0x20,0xf8,0x80,0xb8]

s_getreg_b32 s0, hwreg(HW_REG_SHADER_CYCLES_LO)
// GFX12: encoding: [0x1d,0xf8,0x80,0xb8]

s_getreg_b32 s0, hwreg(HW_REG_SHADER_CYCLES_HI)
// GFX12: encoding: [0x1e,0xf8,0x80,0xb8]
