; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --function-signature --check-attributes --check-globals
; RUN: opt -aa-pipeline=basic-aa -passes=attributor -attributor-manifest-internal  -attributor-annotate-decl-cs  -S < %s | FileCheck %s --check-prefixes=CHECK,TUNIT
; RUN: opt -aa-pipeline=basic-aa -passes=attributor-cgscc -attributor-manifest-internal  -attributor-annotate-decl-cs -S < %s | FileCheck %s --check-prefixes=CHECK,CGSCC


define internal void @dead() {
; CGSCC-LABEL: define {{[^@]+}}@dead() {
; CGSCC-NEXT:    [[TMP1:%.*]] = call i32 @test()
; CGSCC-NEXT:    ret void
;
  call i32 @test(ptr null, ptr null)
  ret void
}

define internal i32 @test(ptr %X, ptr %Y) {
; CGSCC: Function Attrs: mustprogress nofree norecurse nosync nounwind willreturn memory(none)
; CGSCC-LABEL: define {{[^@]+}}@test
; CGSCC-SAME: () #[[ATTR0:[0-9]+]] {
; CGSCC-NEXT:    br i1 true, label [[LIVE:%.*]], label [[DEAD:%.*]]
; CGSCC:       live:
; CGSCC-NEXT:    ret i32 undef
; CGSCC:       dead:
; CGSCC-NEXT:    unreachable
;
  br i1 true, label %live, label %dead
live:
  store i32 0, ptr %X
  ret i32 0
dead:
  call i32 @caller(ptr null)
  call void @dead()
  ret i32 1
}

define internal i32 @caller(ptr %B) {
; CGSCC: Function Attrs: mustprogress nofree norecurse nosync nounwind willreturn memory(none)
; CGSCC-LABEL: define {{[^@]+}}@caller
; CGSCC-SAME: () #[[ATTR0]] {
; CGSCC-NEXT:    [[A:%.*]] = alloca i32, align 4
; CGSCC-NEXT:    [[A2:%.*]] = alloca i8, i32 0, align 4
; CGSCC-NEXT:    [[A1:%.*]] = alloca i8, i32 0, align 4
; CGSCC-NEXT:    ret i32 0
;
  %A = alloca i32
  store i32 1, ptr %A
  %C = call i32 @test(ptr %A, ptr %B)
  ret i32 %C
}

define i32 @callercaller() {
; TUNIT: Function Attrs: mustprogress nofree norecurse nosync nounwind willreturn memory(none)
; TUNIT-LABEL: define {{[^@]+}}@callercaller
; TUNIT-SAME: () #[[ATTR0:[0-9]+]] {
; TUNIT-NEXT:    [[B:%.*]] = alloca i32, align 4
; TUNIT-NEXT:    ret i32 0
;
; CGSCC: Function Attrs: mustprogress nofree nosync nounwind willreturn memory(none)
; CGSCC-LABEL: define {{[^@]+}}@callercaller
; CGSCC-SAME: () #[[ATTR1:[0-9]+]] {
; CGSCC-NEXT:    [[B:%.*]] = alloca i32, align 4
; CGSCC-NEXT:    [[X:%.*]] = call noundef i32 @caller() #[[ATTR2:[0-9]+]]
; CGSCC-NEXT:    ret i32 [[X]]
;
  %B = alloca i32
  store i32 2, ptr %B
  %X = call i32 @caller(ptr %B)
  ret i32 %X
}

;.
; TUNIT: attributes #[[ATTR0]] = { mustprogress nofree norecurse nosync nounwind willreturn memory(none) }
;.
; CGSCC: attributes #[[ATTR0]] = { mustprogress nofree norecurse nosync nounwind willreturn memory(none) }
; CGSCC: attributes #[[ATTR1]] = { mustprogress nofree nosync nounwind willreturn memory(none) }
; CGSCC: attributes #[[ATTR2]] = { nofree nosync willreturn }
;.
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; CHECK: {{.*}}
