; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mattr=+sve -force-streaming-compatible-sve  < %s | FileCheck %s
; RUN: llc -mattr=+sme -force-streaming-compatible-sve  < %s | FileCheck %s

target triple = "aarch64-unknown-linux-gnu"

;
; ASHR
;

define <4 x i8> @ashr_v4i8(<4 x i8> %op1, <4 x i8> %op2) {
; CHECK-LABEL: ashr_v4i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    and z1.h, z1.h, #0xff
; CHECK-NEXT:    sxtb z0.h, p0/m, z0.h
; CHECK-NEXT:    asr z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = ashr <4 x i8> %op1, %op2
  ret <4 x i8> %res
}

define <8 x i8> @ashr_v8i8(<8 x i8> %op1, <8 x i8> %op2) {
; CHECK-LABEL: ashr_v8i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.b, vl8
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    asr z0.b, p0/m, z0.b, z1.b
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = ashr <8 x i8> %op1, %op2
  ret <8 x i8> %res
}

define <16 x i8> @ashr_v16i8(<16 x i8> %op1, <16 x i8> %op2) {
; CHECK-LABEL: ashr_v16i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.b, vl16
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    asr z0.b, p0/m, z0.b, z1.b
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %res = ashr <16 x i8> %op1, %op2
  ret <16 x i8> %res
}

define void @ashr_v32i8(ptr %a, ptr %b) {
; CHECK-LABEL: ashr_v32i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.b, vl16
; CHECK-NEXT:    ldp q0, q3, [x1]
; CHECK-NEXT:    ldp q1, q2, [x0]
; CHECK-NEXT:    asrr z0.b, p0/m, z0.b, z1.b
; CHECK-NEXT:    movprfx z1, z2
; CHECK-NEXT:    asr z1.b, p0/m, z1.b, z3.b
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
  %op1 = load <32 x i8>, ptr %a
  %op2 = load <32 x i8>, ptr %b
  %res = ashr <32 x i8> %op1, %op2
  store <32 x i8> %res, ptr %a
  ret void
}

define <2 x i16> @ashr_v2i16(<2 x i16> %op1, <2 x i16> %op2) {
; CHECK-LABEL: ashr_v2i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    and z1.s, z1.s, #0xffff
; CHECK-NEXT:    sxth z0.s, p0/m, z0.s
; CHECK-NEXT:    asr z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = ashr <2 x i16> %op1, %op2
  ret <2 x i16> %res
}

define <4 x i16> @ashr_v4i16(<4 x i16> %op1, <4 x i16> %op2) {
; CHECK-LABEL: ashr_v4i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    asr z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = ashr <4 x i16> %op1, %op2
  ret <4 x i16> %res
}

define <8 x i16> @ashr_v8i16(<8 x i16> %op1, <8 x i16> %op2) {
; CHECK-LABEL: ashr_v8i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    asr z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %res = ashr <8 x i16> %op1, %op2
  ret <8 x i16> %res
}

define void @ashr_v16i16(ptr %a, ptr %b) {
; CHECK-LABEL: ashr_v16i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    ldp q0, q3, [x1]
; CHECK-NEXT:    ldp q1, q2, [x0]
; CHECK-NEXT:    asrr z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    movprfx z1, z2
; CHECK-NEXT:    asr z1.h, p0/m, z1.h, z3.h
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
  %op1 = load <16 x i16>, ptr %a
  %op2 = load <16 x i16>, ptr %b
  %res = ashr <16 x i16> %op1, %op2
  store <16 x i16> %res, ptr %a
  ret void
}

define <2 x i32> @ashr_v2i32(<2 x i32> %op1, <2 x i32> %op2) {
; CHECK-LABEL: ashr_v2i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    asr z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = ashr <2 x i32> %op1, %op2
  ret <2 x i32> %res
}

define <4 x i32> @ashr_v4i32(<4 x i32> %op1, <4 x i32> %op2) {
; CHECK-LABEL: ashr_v4i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    asr z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %res = ashr <4 x i32> %op1, %op2
  ret <4 x i32> %res
}

define void @ashr_v8i32(ptr %a, ptr %b) {
; CHECK-LABEL: ashr_v8i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    ldp q0, q3, [x1]
; CHECK-NEXT:    ldp q1, q2, [x0]
; CHECK-NEXT:    asrr z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    movprfx z1, z2
; CHECK-NEXT:    asr z1.s, p0/m, z1.s, z3.s
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
  %op1 = load <8 x i32>, ptr %a
  %op2 = load <8 x i32>, ptr %b
  %res = ashr <8 x i32> %op1, %op2
  store <8 x i32> %res, ptr %a
  ret void
}

define <1 x i64> @ashr_v1i64(<1 x i64> %op1, <1 x i64> %op2) {
; CHECK-LABEL: ashr_v1i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl1
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    asr z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = ashr <1 x i64> %op1, %op2
  ret <1 x i64> %res
}

define <2 x i64> @ashr_v2i64(<2 x i64> %op1, <2 x i64> %op2) {
; CHECK-LABEL: ashr_v2i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    asr z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %res = ashr <2 x i64> %op1, %op2
  ret <2 x i64> %res
}

define void @ashr_v4i64(ptr %a, ptr %b) {
; CHECK-LABEL: ashr_v4i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    ldp q0, q3, [x1]
; CHECK-NEXT:    ldp q1, q2, [x0]
; CHECK-NEXT:    asrr z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    movprfx z1, z2
; CHECK-NEXT:    asr z1.d, p0/m, z1.d, z3.d
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
  %op1 = load <4 x i64>, ptr %a
  %op2 = load <4 x i64>, ptr %b
  %res = ashr <4 x i64> %op1, %op2
  store <4 x i64> %res, ptr %a
  ret void
}

;
; LSHR
;

define <4 x i8> @lshr_v4i8(<4 x i8> %op1, <4 x i8> %op2) {
; CHECK-LABEL: lshr_v4i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    and z1.h, z1.h, #0xff
; CHECK-NEXT:    and z0.h, z0.h, #0xff
; CHECK-NEXT:    lsr z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = lshr <4 x i8> %op1, %op2
  ret <4 x i8> %res
}

define <8 x i8> @lshr_v8i8(<8 x i8> %op1, <8 x i8> %op2) {
; CHECK-LABEL: lshr_v8i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.b, vl8
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    lsr z0.b, p0/m, z0.b, z1.b
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = lshr <8 x i8> %op1, %op2
  ret <8 x i8> %res
}

define <16 x i8> @lshr_v16i8(<16 x i8> %op1, <16 x i8> %op2) {
; CHECK-LABEL: lshr_v16i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.b, vl16
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    lsr z0.b, p0/m, z0.b, z1.b
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %res = lshr <16 x i8> %op1, %op2
  ret <16 x i8> %res
}

define void @lshr_v32i8(ptr %a, ptr %b) {
; CHECK-LABEL: lshr_v32i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.b, vl16
; CHECK-NEXT:    ldp q0, q3, [x1]
; CHECK-NEXT:    ldp q1, q2, [x0]
; CHECK-NEXT:    lsrr z0.b, p0/m, z0.b, z1.b
; CHECK-NEXT:    movprfx z1, z2
; CHECK-NEXT:    lsr z1.b, p0/m, z1.b, z3.b
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
  %op1 = load <32 x i8>, ptr %a
  %op2 = load <32 x i8>, ptr %b
  %res = lshr <32 x i8> %op1, %op2
  store <32 x i8> %res, ptr %a
  ret void
}

define <2 x i16> @lshr_v2i16(<2 x i16> %op1, <2 x i16> %op2) {
; CHECK-LABEL: lshr_v2i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    and z1.s, z1.s, #0xffff
; CHECK-NEXT:    and z0.s, z0.s, #0xffff
; CHECK-NEXT:    lsr z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = lshr <2 x i16> %op1, %op2
  ret <2 x i16> %res
}

define <4 x i16> @lshr_v4i16(<4 x i16> %op1, <4 x i16> %op2) {
; CHECK-LABEL: lshr_v4i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    lsr z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = lshr <4 x i16> %op1, %op2
  ret <4 x i16> %res
}

define <8 x i16> @lshr_v8i16(<8 x i16> %op1, <8 x i16> %op2) {
; CHECK-LABEL: lshr_v8i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    lsr z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %res = lshr <8 x i16> %op1, %op2
  ret <8 x i16> %res
}

define void @lshr_v16i16(ptr %a, ptr %b) {
; CHECK-LABEL: lshr_v16i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    ldp q0, q3, [x1]
; CHECK-NEXT:    ldp q1, q2, [x0]
; CHECK-NEXT:    lsrr z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    movprfx z1, z2
; CHECK-NEXT:    lsr z1.h, p0/m, z1.h, z3.h
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
  %op1 = load <16 x i16>, ptr %a
  %op2 = load <16 x i16>, ptr %b
  %res = lshr <16 x i16> %op1, %op2
  store <16 x i16> %res, ptr %a
  ret void
}

define <2 x i32> @lshr_v2i32(<2 x i32> %op1, <2 x i32> %op2) {
; CHECK-LABEL: lshr_v2i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    lsr z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = lshr <2 x i32> %op1, %op2
  ret <2 x i32> %res
}

define <4 x i32> @lshr_v4i32(<4 x i32> %op1, <4 x i32> %op2) {
; CHECK-LABEL: lshr_v4i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    lsr z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %res = lshr <4 x i32> %op1, %op2
  ret <4 x i32> %res
}

define void @lshr_v8i32(ptr %a, ptr %b) {
; CHECK-LABEL: lshr_v8i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    ldp q0, q3, [x1]
; CHECK-NEXT:    ldp q1, q2, [x0]
; CHECK-NEXT:    lsrr z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    movprfx z1, z2
; CHECK-NEXT:    lsr z1.s, p0/m, z1.s, z3.s
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
  %op1 = load <8 x i32>, ptr %a
  %op2 = load <8 x i32>, ptr %b
  %res = lshr <8 x i32> %op1, %op2
  store <8 x i32> %res, ptr %a
  ret void
}

define <1 x i64> @lshr_v1i64(<1 x i64> %op1, <1 x i64> %op2) {
; CHECK-LABEL: lshr_v1i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl1
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    lsr z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = lshr <1 x i64> %op1, %op2
  ret <1 x i64> %res
}

define <2 x i64> @lshr_v2i64(<2 x i64> %op1, <2 x i64> %op2) {
; CHECK-LABEL: lshr_v2i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    lsr z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %res = lshr <2 x i64> %op1, %op2
  ret <2 x i64> %res
}

define void @lshr_v4i64(ptr %a, ptr %b) {
; CHECK-LABEL: lshr_v4i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    ldp q0, q3, [x1]
; CHECK-NEXT:    ldp q1, q2, [x0]
; CHECK-NEXT:    lsrr z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    movprfx z1, z2
; CHECK-NEXT:    lsr z1.d, p0/m, z1.d, z3.d
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
  %op1 = load <4 x i64>, ptr %a
  %op2 = load <4 x i64>, ptr %b
  %res = lshr <4 x i64> %op1, %op2
  store <4 x i64> %res, ptr %a
  ret void
}

;
; SHL
;

define <2 x i8> @shl_v2i8(<2 x i8> %op1, <2 x i8> %op2) {
; CHECK-LABEL: shl_v2i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    and z1.s, z1.s, #0xff
; CHECK-NEXT:    lsl z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = shl <2 x i8> %op1, %op2
  ret <2 x i8> %res
}

define <4 x i8> @shl_v4i8(<4 x i8> %op1, <4 x i8> %op2) {
; CHECK-LABEL: shl_v4i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    and z1.h, z1.h, #0xff
; CHECK-NEXT:    lsl z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = shl <4 x i8> %op1, %op2
  ret <4 x i8> %res
}

define <8 x i8> @shl_v8i8(<8 x i8> %op1, <8 x i8> %op2) {
; CHECK-LABEL: shl_v8i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.b, vl8
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    lsl z0.b, p0/m, z0.b, z1.b
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = shl <8 x i8> %op1, %op2
  ret <8 x i8> %res
}

define <16 x i8> @shl_v16i8(<16 x i8> %op1, <16 x i8> %op2) {
; CHECK-LABEL: shl_v16i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.b, vl16
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    lsl z0.b, p0/m, z0.b, z1.b
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %res = shl <16 x i8> %op1, %op2
  ret <16 x i8> %res
}

define void @shl_v32i8(ptr %a, ptr %b) {
; CHECK-LABEL: shl_v32i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.b, vl16
; CHECK-NEXT:    ldp q0, q3, [x1]
; CHECK-NEXT:    ldp q1, q2, [x0]
; CHECK-NEXT:    lslr z0.b, p0/m, z0.b, z1.b
; CHECK-NEXT:    movprfx z1, z2
; CHECK-NEXT:    lsl z1.b, p0/m, z1.b, z3.b
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
  %op1 = load <32 x i8>, ptr %a
  %op2 = load <32 x i8>, ptr %b
  %res = shl <32 x i8> %op1, %op2
  store <32 x i8> %res, ptr %a
  ret void
}

define <4 x i16> @shl_v4i16(<4 x i16> %op1, <4 x i16> %op2) {
; CHECK-LABEL: shl_v4i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    lsl z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = shl <4 x i16> %op1, %op2
  ret <4 x i16> %res
}

define <8 x i16> @shl_v8i16(<8 x i16> %op1, <8 x i16> %op2) {
; CHECK-LABEL: shl_v8i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    lsl z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %res = shl <8 x i16> %op1, %op2
  ret <8 x i16> %res
}

define void @shl_v16i16(ptr %a, ptr %b) {
; CHECK-LABEL: shl_v16i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    ldp q0, q3, [x1]
; CHECK-NEXT:    ldp q1, q2, [x0]
; CHECK-NEXT:    lslr z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    movprfx z1, z2
; CHECK-NEXT:    lsl z1.h, p0/m, z1.h, z3.h
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
  %op1 = load <16 x i16>, ptr %a
  %op2 = load <16 x i16>, ptr %b
  %res = shl <16 x i16> %op1, %op2
  store <16 x i16> %res, ptr %a
  ret void
}

define <2 x i32> @shl_v2i32(<2 x i32> %op1, <2 x i32> %op2) {
; CHECK-LABEL: shl_v2i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    lsl z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = shl <2 x i32> %op1, %op2
  ret <2 x i32> %res
}

define <4 x i32> @shl_v4i32(<4 x i32> %op1, <4 x i32> %op2) {
; CHECK-LABEL: shl_v4i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    lsl z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %res = shl <4 x i32> %op1, %op2
  ret <4 x i32> %res
}

define void @shl_v8i32(ptr %a, ptr %b) {
; CHECK-LABEL: shl_v8i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    ldp q0, q3, [x1]
; CHECK-NEXT:    ldp q1, q2, [x0]
; CHECK-NEXT:    lslr z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    movprfx z1, z2
; CHECK-NEXT:    lsl z1.s, p0/m, z1.s, z3.s
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
  %op1 = load <8 x i32>, ptr %a
  %op2 = load <8 x i32>, ptr %b
  %res = shl <8 x i32> %op1, %op2
  store <8 x i32> %res, ptr %a
  ret void
}

define <1 x i64> @shl_v1i64(<1 x i64> %op1, <1 x i64> %op2) {
; CHECK-LABEL: shl_v1i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl1
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    lsl z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = shl <1 x i64> %op1, %op2
  ret <1 x i64> %res
}

define <2 x i64> @shl_v2i64(<2 x i64> %op1, <2 x i64> %op2) {
; CHECK-LABEL: shl_v2i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    lsl z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %res = shl <2 x i64> %op1, %op2
  ret <2 x i64> %res
}

define void @shl_v4i64(ptr %a, ptr %b) {
; CHECK-LABEL: shl_v4i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    ldp q0, q3, [x1]
; CHECK-NEXT:    ldp q1, q2, [x0]
; CHECK-NEXT:    lslr z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    movprfx z1, z2
; CHECK-NEXT:    lsl z1.d, p0/m, z1.d, z3.d
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
  %op1 = load <4 x i64>, ptr %a
  %op2 = load <4 x i64>, ptr %b
  %res = shl <4 x i64> %op1, %op2
  store <4 x i64> %res, ptr %a
  ret void
}
