; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc --mtriple=loongarch32 --verify-machineinstrs < %s \
; RUN:   | FileCheck %s --check-prefix=LA32
; RUN: llc --mtriple=loongarch64 --verify-machineinstrs < %s \
; RUN:   | FileCheck %s --check-prefix=LA64

declare i16 @llvm.bswap.i16(i16)
declare i32 @llvm.bswap.i32(i32)
declare i48 @llvm.bswap.i48(i48)
declare i64 @llvm.bswap.i64(i64)
declare i80 @llvm.bswap.i80(i80)
declare i128 @llvm.bswap.i128(i128)

define i16 @test_bswap_i16(i16 %a) nounwind {
; LA32-LABEL: test_bswap_i16:
; LA32:       # %bb.0:
; LA32-NEXT:    revb.2h $a0, $a0
; LA32-NEXT:    ret
;
; LA64-LABEL: test_bswap_i16:
; LA64:       # %bb.0:
; LA64-NEXT:    revb.2h $a0, $a0
; LA64-NEXT:    ret
  %tmp = call i16 @llvm.bswap.i16(i16 %a)
  ret i16 %tmp
}

define i32 @test_bswap_i32(i32 %a) nounwind {
; LA32-LABEL: test_bswap_i32:
; LA32:       # %bb.0:
; LA32-NEXT:    revb.2h $a0, $a0
; LA32-NEXT:    rotri.w $a0, $a0, 16
; LA32-NEXT:    ret
;
; LA64-LABEL: test_bswap_i32:
; LA64:       # %bb.0:
; LA64-NEXT:    revb.2w $a0, $a0
; LA64-NEXT:    ret
  %tmp = call i32 @llvm.bswap.i32(i32 %a)
  ret i32 %tmp
}

define i64 @test_bswap_i64(i64 %a) nounwind {
; LA32-LABEL: test_bswap_i64:
; LA32:       # %bb.0:
; LA32-NEXT:    revb.2h $a1, $a1
; LA32-NEXT:    rotri.w $a2, $a1, 16
; LA32-NEXT:    revb.2h $a0, $a0
; LA32-NEXT:    rotri.w $a1, $a0, 16
; LA32-NEXT:    move $a0, $a2
; LA32-NEXT:    ret
;
; LA64-LABEL: test_bswap_i64:
; LA64:       # %bb.0:
; LA64-NEXT:    revb.d $a0, $a0
; LA64-NEXT:    ret
  %tmp = call i64 @llvm.bswap.i64(i64 %a)
  ret i64 %tmp
}

;; Bswap on non-native integer widths.

define i48 @test_bswap_i48(i48 %a) nounwind {
; LA32-LABEL: test_bswap_i48:
; LA32:       # %bb.0:
; LA32-NEXT:    revb.2h $a0, $a0
; LA32-NEXT:    rotri.w $a2, $a0, 16
; LA32-NEXT:    revb.2h $a0, $a1
; LA32-NEXT:    rotri.w $a0, $a0, 16
; LA32-NEXT:    bytepick.w $a0, $a0, $a2, 2
; LA32-NEXT:    srli.w $a1, $a2, 16
; LA32-NEXT:    ret
;
; LA64-LABEL: test_bswap_i48:
; LA64:       # %bb.0:
; LA64-NEXT:    revb.d $a0, $a0
; LA64-NEXT:    srli.d $a0, $a0, 16
; LA64-NEXT:    ret
  %tmp = call i48 @llvm.bswap.i48(i48 %a)
  ret i48 %tmp
}

define i80 @test_bswap_i80(i80 %a) nounwind {
; LA32-LABEL: test_bswap_i80:
; LA32:       # %bb.0:
; LA32-NEXT:    ld.w $a2, $a1, 0
; LA32-NEXT:    revb.2h $a2, $a2
; LA32-NEXT:    rotri.w $a2, $a2, 16
; LA32-NEXT:    ld.w $a3, $a1, 4
; LA32-NEXT:    revb.2h $a3, $a3
; LA32-NEXT:    rotri.w $a3, $a3, 16
; LA32-NEXT:    bytepick.w $a4, $a3, $a2, 2
; LA32-NEXT:    st.w $a4, $a0, 4
; LA32-NEXT:    ld.w $a1, $a1, 8
; LA32-NEXT:    revb.2h $a1, $a1
; LA32-NEXT:    rotri.w $a1, $a1, 16
; LA32-NEXT:    bytepick.w $a1, $a1, $a3, 2
; LA32-NEXT:    st.w $a1, $a0, 0
; LA32-NEXT:    srli.w $a1, $a2, 16
; LA32-NEXT:    st.h $a1, $a0, 8
; LA32-NEXT:    ret
;
; LA64-LABEL: test_bswap_i80:
; LA64:       # %bb.0:
; LA64-NEXT:    revb.d $a2, $a0
; LA64-NEXT:    revb.d $a0, $a1
; LA64-NEXT:    bytepick.d $a0, $a0, $a2, 2
; LA64-NEXT:    srli.d $a1, $a2, 48
; LA64-NEXT:    ret
  %tmp = call i80 @llvm.bswap.i80(i80 %a)
  ret i80 %tmp
}

define i128 @test_bswap_i128(i128 %a) nounwind {
; LA32-LABEL: test_bswap_i128:
; LA32:       # %bb.0:
; LA32-NEXT:    ld.w $a2, $a1, 0
; LA32-NEXT:    revb.2h $a2, $a2
; LA32-NEXT:    rotri.w $a2, $a2, 16
; LA32-NEXT:    st.w $a2, $a0, 12
; LA32-NEXT:    ld.w $a2, $a1, 4
; LA32-NEXT:    revb.2h $a2, $a2
; LA32-NEXT:    rotri.w $a2, $a2, 16
; LA32-NEXT:    st.w $a2, $a0, 8
; LA32-NEXT:    ld.w $a2, $a1, 8
; LA32-NEXT:    revb.2h $a2, $a2
; LA32-NEXT:    rotri.w $a2, $a2, 16
; LA32-NEXT:    st.w $a2, $a0, 4
; LA32-NEXT:    ld.w $a1, $a1, 12
; LA32-NEXT:    revb.2h $a1, $a1
; LA32-NEXT:    rotri.w $a1, $a1, 16
; LA32-NEXT:    st.w $a1, $a0, 0
; LA32-NEXT:    ret
;
; LA64-LABEL: test_bswap_i128:
; LA64:       # %bb.0:
; LA64-NEXT:    revb.d $a2, $a1
; LA64-NEXT:    revb.d $a1, $a0
; LA64-NEXT:    move $a0, $a2
; LA64-NEXT:    ret
  %tmp = call i128 @llvm.bswap.i128(i128 %a)
  ret i128 %tmp
}
