// RUN: llvm-mc -triple=amdgcn -mcpu=gfx1100 -show-encoding %s | FileCheck --check-prefixes=GFX11 %s

//===----------------------------------------------------------------------===//
// ENC_SMEM.
//===----------------------------------------------------------------------===//

s_load_dword s5, s[2:3], s0
// GFX11: s_load_b32 s5, s[2:3], s0               ; encoding: [0x41,0x01,0x00,0xf4,0x00,0x00,0x00,0x00]

s_load_dword s101, s[2:3], s0
// GFX11: s_load_b32 s101, s[2:3], s0             ; encoding: [0x41,0x19,0x00,0xf4,0x00,0x00,0x00,0x00]

s_load_dword vcc_lo, s[2:3], s0
// GFX11: s_load_b32 vcc_lo, s[2:3], s0           ; encoding: [0x81,0x1a,0x00,0xf4,0x00,0x00,0x00,0x00]

s_load_dword vcc_hi, s[2:3], s0
// GFX11: s_load_b32 vcc_hi, s[2:3], s0           ; encoding: [0xc1,0x1a,0x00,0xf4,0x00,0x00,0x00,0x00]

s_load_dword s5, s[4:5], s0
// GFX11: s_load_b32 s5, s[4:5], s0               ; encoding: [0x42,0x01,0x00,0xf4,0x00,0x00,0x00,0x00]

s_load_dword s5, s[100:101], s0
// GFX11: s_load_b32 s5, s[100:101], s0           ; encoding: [0x72,0x01,0x00,0xf4,0x00,0x00,0x00,0x00]

s_load_dword s5, vcc, s0
// GFX11: s_load_b32 s5, vcc, s0                  ; encoding: [0x75,0x01,0x00,0xf4,0x00,0x00,0x00,0x00]

s_load_dword s5, s[2:3], s101
// GFX11: s_load_b32 s5, s[2:3], s101             ; encoding: [0x41,0x01,0x00,0xf4,0x00,0x00,0x00,0xca]

s_load_dword s5, s[2:3], vcc_lo
// GFX11: s_load_b32 s5, s[2:3], vcc_lo           ; encoding: [0x41,0x01,0x00,0xf4,0x00,0x00,0x00,0xd4]

s_load_dword s5, s[2:3], vcc_hi
// GFX11: s_load_b32 s5, s[2:3], vcc_hi           ; encoding: [0x41,0x01,0x00,0xf4,0x00,0x00,0x00,0xd6]

s_load_dword s5, s[2:3], m0
// GFX11: s_load_b32 s5, s[2:3], m0               ; encoding: [0x41,0x01,0x00,0xf4,0x00,0x00,0x00,0xfa]

s_load_dword s5, s[2:3], 0x0
// GFX11: s_load_b32 s5, s[2:3], 0x0              ; encoding: [0x41,0x01,0x00,0xf4,0x00,0x00,0x00,0xf8]

s_load_dword s5, s[2:3], s0 glc
// GFX11: s_load_b32 s5, s[2:3], s0 glc           ; encoding: [0x41,0x41,0x00,0xf4,0x00,0x00,0x00,0x00]

s_load_dword s5, s[2:3], s0 dlc
// GFX11: s_load_b32 s5, s[2:3], s0 dlc           ; encoding: [0x41,0x21,0x00,0xf4,0x00,0x00,0x00,0x00]

s_load_dword s5, s[2:3], s0 glc dlc
// GFX11: s_load_b32 s5, s[2:3], s0 glc dlc       ; encoding: [0x41,0x61,0x00,0xf4,0x00,0x00,0x00,0x00]

s_load_dword s5, s[2:3], 0x1234 glc dlc
// GFX11: s_load_b32 s5, s[2:3], 0x1234 glc dlc   ; encoding: [0x41,0x61,0x00,0xf4,0x34,0x12,0x00,0xf8]

s_load_dwordx2 s[10:11], s[2:3], s0
// GFX11: s_load_b64 s[10:11], s[2:3], s0         ; encoding: [0x81,0x02,0x04,0xf4,0x00,0x00,0x00,0x00]

s_load_dwordx2 s[12:13], s[2:3], s0
// GFX11: s_load_b64 s[12:13], s[2:3], s0         ; encoding: [0x01,0x03,0x04,0xf4,0x00,0x00,0x00,0x00]

s_load_dwordx2 s[100:101], s[2:3], s0
// GFX11: s_load_b64 s[100:101], s[2:3], s0       ; encoding: [0x01,0x19,0x04,0xf4,0x00,0x00,0x00,0x00]

s_load_dwordx2 vcc, s[2:3], s0
// GFX11: s_load_b64 vcc, s[2:3], s0              ; encoding: [0x81,0x1a,0x04,0xf4,0x00,0x00,0x00,0x00]

s_load_dwordx2 s[10:11], s[4:5], s0
// GFX11: s_load_b64 s[10:11], s[4:5], s0         ; encoding: [0x82,0x02,0x04,0xf4,0x00,0x00,0x00,0x00]

s_load_dwordx2 s[10:11], s[100:101], s0
// GFX11: s_load_b64 s[10:11], s[100:101], s0     ; encoding: [0xb2,0x02,0x04,0xf4,0x00,0x00,0x00,0x00]

s_load_dwordx2 s[10:11], vcc, s0
// GFX11: s_load_b64 s[10:11], vcc, s0            ; encoding: [0xb5,0x02,0x04,0xf4,0x00,0x00,0x00,0x00]

s_load_dwordx2 s[10:11], s[2:3], s101
// GFX11: s_load_b64 s[10:11], s[2:3], s101       ; encoding: [0x81,0x02,0x04,0xf4,0x00,0x00,0x00,0xca]

s_load_dwordx2 s[10:11], s[2:3], vcc_lo
// GFX11: s_load_b64 s[10:11], s[2:3], vcc_lo     ; encoding: [0x81,0x02,0x04,0xf4,0x00,0x00,0x00,0xd4]

s_load_dwordx2 s[10:11], s[2:3], vcc_hi
// GFX11: s_load_b64 s[10:11], s[2:3], vcc_hi     ; encoding: [0x81,0x02,0x04,0xf4,0x00,0x00,0x00,0xd6]

s_load_dwordx2 s[10:11], s[2:3], m0
// GFX11: s_load_b64 s[10:11], s[2:3], m0         ; encoding: [0x81,0x02,0x04,0xf4,0x00,0x00,0x00,0xfa]

s_load_dwordx2 s[10:11], s[2:3], 0x0
// GFX11: s_load_b64 s[10:11], s[2:3], 0x0        ; encoding: [0x81,0x02,0x04,0xf4,0x00,0x00,0x00,0xf8]

s_load_dwordx2 s[10:11], s[2:3], s0 glc
// GFX11: s_load_b64 s[10:11], s[2:3], s0 glc     ; encoding: [0x81,0x42,0x04,0xf4,0x00,0x00,0x00,0x00]

s_load_dwordx2 s[10:11], s[2:3], s0 dlc
// GFX11: s_load_b64 s[10:11], s[2:3], s0 dlc     ; encoding: [0x81,0x22,0x04,0xf4,0x00,0x00,0x00,0x00]

s_load_dwordx2 s[10:11], s[2:3], s0 glc dlc
// GFX11: s_load_b64 s[10:11], s[2:3], s0 glc dlc ; encoding: [0x81,0x62,0x04,0xf4,0x00,0x00,0x00,0x00]

s_load_dwordx2 s[10:11], s[2:3], 0x1234 glc dlc
// GFX11: s_load_b64 s[10:11], s[2:3], 0x1234 glc dlc ; encoding: [0x81,0x62,0x04,0xf4,0x34,0x12,0x00,0xf8]

s_load_dwordx4 s[20:23], s[2:3], s0
// GFX11: s_load_b128 s[20:23], s[2:3], s0        ; encoding: [0x01,0x05,0x08,0xf4,0x00,0x00,0x00,0x00]

s_load_dwordx4 s[24:27], s[2:3], s0
// GFX11: s_load_b128 s[24:27], s[2:3], s0        ; encoding: [0x01,0x06,0x08,0xf4,0x00,0x00,0x00,0x00]

s_load_dwordx4 s[96:99], s[2:3], s0
// GFX11: s_load_b128 s[96:99], s[2:3], s0        ; encoding: [0x01,0x18,0x08,0xf4,0x00,0x00,0x00,0x00]

s_load_dwordx4 s[20:23], s[4:5], s0
// GFX11: s_load_b128 s[20:23], s[4:5], s0        ; encoding: [0x02,0x05,0x08,0xf4,0x00,0x00,0x00,0x00]

s_load_dwordx4 s[20:23], s[100:101], s0
// GFX11: s_load_b128 s[20:23], s[100:101], s0    ; encoding: [0x32,0x05,0x08,0xf4,0x00,0x00,0x00,0x00]

s_load_dwordx4 s[20:23], vcc, s0
// GFX11: s_load_b128 s[20:23], vcc, s0           ; encoding: [0x35,0x05,0x08,0xf4,0x00,0x00,0x00,0x00]

s_load_dwordx4 s[20:23], s[2:3], s101
// GFX11: s_load_b128 s[20:23], s[2:3], s101      ; encoding: [0x01,0x05,0x08,0xf4,0x00,0x00,0x00,0xca]

s_load_dwordx4 s[20:23], s[2:3], vcc_lo
// GFX11: s_load_b128 s[20:23], s[2:3], vcc_lo    ; encoding: [0x01,0x05,0x08,0xf4,0x00,0x00,0x00,0xd4]

s_load_dwordx4 s[20:23], s[2:3], vcc_hi
// GFX11: s_load_b128 s[20:23], s[2:3], vcc_hi    ; encoding: [0x01,0x05,0x08,0xf4,0x00,0x00,0x00,0xd6]

s_load_dwordx4 s[20:23], s[2:3], m0
// GFX11: s_load_b128 s[20:23], s[2:3], m0        ; encoding: [0x01,0x05,0x08,0xf4,0x00,0x00,0x00,0xfa]

s_load_dwordx4 s[20:23], s[2:3], 0x0
// GFX11: s_load_b128 s[20:23], s[2:3], 0x0       ; encoding: [0x01,0x05,0x08,0xf4,0x00,0x00,0x00,0xf8]

s_load_dwordx4 s[20:23], s[2:3], s0 glc
// GFX11: s_load_b128 s[20:23], s[2:3], s0 glc    ; encoding: [0x01,0x45,0x08,0xf4,0x00,0x00,0x00,0x00]

s_load_dwordx4 s[20:23], s[2:3], s0 dlc
// GFX11: s_load_b128 s[20:23], s[2:3], s0 dlc    ; encoding: [0x01,0x25,0x08,0xf4,0x00,0x00,0x00,0x00]

s_load_dwordx4 s[20:23], s[2:3], s0 glc dlc
// GFX11: s_load_b128 s[20:23], s[2:3], s0 glc dlc ; encoding: [0x01,0x65,0x08,0xf4,0x00,0x00,0x00,0x00]

s_load_dwordx4 s[20:23], s[2:3], 0x1234 glc dlc
// GFX11: s_load_b128 s[20:23], s[2:3], 0x1234 glc dlc ; encoding: [0x01,0x65,0x08,0xf4,0x34,0x12,0x00,0xf8]

s_load_dwordx8 s[20:27], s[2:3], s0
// GFX11: s_load_b256 s[20:27], s[2:3], s0        ; encoding: [0x01,0x05,0x0c,0xf4,0x00,0x00,0x00,0x00]

s_load_dwordx8 s[24:31], s[2:3], s0
// GFX11: s_load_b256 s[24:31], s[2:3], s0        ; encoding: [0x01,0x06,0x0c,0xf4,0x00,0x00,0x00,0x00]

s_load_dwordx8 s[92:99], s[2:3], s0
// GFX11: s_load_b256 s[92:99], s[2:3], s0        ; encoding: [0x01,0x17,0x0c,0xf4,0x00,0x00,0x00,0x00]

s_load_dwordx8 s[20:27], s[4:5], s0
// GFX11: s_load_b256 s[20:27], s[4:5], s0        ; encoding: [0x02,0x05,0x0c,0xf4,0x00,0x00,0x00,0x00]

s_load_dwordx8 s[20:27], s[100:101], s0
// GFX11: s_load_b256 s[20:27], s[100:101], s0    ; encoding: [0x32,0x05,0x0c,0xf4,0x00,0x00,0x00,0x00]

s_load_dwordx8 s[20:27], vcc, s0
// GFX11: s_load_b256 s[20:27], vcc, s0           ; encoding: [0x35,0x05,0x0c,0xf4,0x00,0x00,0x00,0x00]

s_load_dwordx8 s[20:27], s[2:3], s101
// GFX11: s_load_b256 s[20:27], s[2:3], s101      ; encoding: [0x01,0x05,0x0c,0xf4,0x00,0x00,0x00,0xca]

s_load_dwordx8 s[20:27], s[2:3], vcc_lo
// GFX11: s_load_b256 s[20:27], s[2:3], vcc_lo    ; encoding: [0x01,0x05,0x0c,0xf4,0x00,0x00,0x00,0xd4]

s_load_dwordx8 s[20:27], s[2:3], vcc_hi
// GFX11: s_load_b256 s[20:27], s[2:3], vcc_hi    ; encoding: [0x01,0x05,0x0c,0xf4,0x00,0x00,0x00,0xd6]

s_load_dwordx8 s[20:27], s[2:3], m0
// GFX11: s_load_b256 s[20:27], s[2:3], m0        ; encoding: [0x01,0x05,0x0c,0xf4,0x00,0x00,0x00,0xfa]

s_load_dwordx8 s[20:27], s[2:3], 0x0
// GFX11: s_load_b256 s[20:27], s[2:3], 0x0       ; encoding: [0x01,0x05,0x0c,0xf4,0x00,0x00,0x00,0xf8]

s_load_dwordx8 s[20:27], s[2:3], s0 glc
// GFX11: s_load_b256 s[20:27], s[2:3], s0 glc    ; encoding: [0x01,0x45,0x0c,0xf4,0x00,0x00,0x00,0x00]

s_load_dwordx8 s[20:27], s[2:3], s0 dlc
// GFX11: s_load_b256 s[20:27], s[2:3], s0 dlc    ; encoding: [0x01,0x25,0x0c,0xf4,0x00,0x00,0x00,0x00]

s_load_dwordx8 s[20:27], s[2:3], s0 glc dlc
// GFX11: s_load_b256 s[20:27], s[2:3], s0 glc dlc ; encoding: [0x01,0x65,0x0c,0xf4,0x00,0x00,0x00,0x00]

s_load_dwordx8 s[20:27], s[2:3], 0x1234 glc dlc
// GFX11: s_load_b256 s[20:27], s[2:3], 0x1234 glc dlc ; encoding: [0x01,0x65,0x0c,0xf4,0x34,0x12,0x00,0xf8]

s_load_dwordx16 s[20:35], s[2:3], s0
// GFX11: s_load_b512 s[20:35], s[2:3], s0        ; encoding: [0x01,0x05,0x10,0xf4,0x00,0x00,0x00,0x00]

s_load_dwordx16 s[24:39], s[2:3], s0
// GFX11: s_load_b512 s[24:39], s[2:3], s0        ; encoding: [0x01,0x06,0x10,0xf4,0x00,0x00,0x00,0x00]

s_load_dwordx16 s[84:99], s[2:3], s0
// GFX11: s_load_b512 s[84:99], s[2:3], s0        ; encoding: [0x01,0x15,0x10,0xf4,0x00,0x00,0x00,0x00]

s_load_dwordx16 s[20:35], s[4:5], s0
// GFX11: s_load_b512 s[20:35], s[4:5], s0        ; encoding: [0x02,0x05,0x10,0xf4,0x00,0x00,0x00,0x00]

s_load_dwordx16 s[20:35], s[100:101], s0
// GFX11: s_load_b512 s[20:35], s[100:101], s0    ; encoding: [0x32,0x05,0x10,0xf4,0x00,0x00,0x00,0x00]

s_load_dwordx16 s[20:35], vcc, s0
// GFX11: s_load_b512 s[20:35], vcc, s0           ; encoding: [0x35,0x05,0x10,0xf4,0x00,0x00,0x00,0x00]

s_load_dwordx16 s[20:35], s[2:3], s101
// GFX11: s_load_b512 s[20:35], s[2:3], s101      ; encoding: [0x01,0x05,0x10,0xf4,0x00,0x00,0x00,0xca]

s_load_dwordx16 s[20:35], s[2:3], vcc_lo
// GFX11: s_load_b512 s[20:35], s[2:3], vcc_lo    ; encoding: [0x01,0x05,0x10,0xf4,0x00,0x00,0x00,0xd4]

s_load_dwordx16 s[20:35], s[2:3], vcc_hi
// GFX11: s_load_b512 s[20:35], s[2:3], vcc_hi    ; encoding: [0x01,0x05,0x10,0xf4,0x00,0x00,0x00,0xd6]

s_load_dwordx16 s[20:35], s[2:3], m0
// GFX11: s_load_b512 s[20:35], s[2:3], m0        ; encoding: [0x01,0x05,0x10,0xf4,0x00,0x00,0x00,0xfa]

s_load_dwordx16 s[20:35], s[2:3], 0x0
// GFX11: s_load_b512 s[20:35], s[2:3], 0x0       ; encoding: [0x01,0x05,0x10,0xf4,0x00,0x00,0x00,0xf8]

s_load_dwordx16 s[20:35], s[2:3], s0 glc
// GFX11: s_load_b512 s[20:35], s[2:3], s0 glc    ; encoding: [0x01,0x45,0x10,0xf4,0x00,0x00,0x00,0x00]

s_load_dwordx16 s[20:35], s[2:3], s0 dlc
// GFX11: s_load_b512 s[20:35], s[2:3], s0 dlc    ; encoding: [0x01,0x25,0x10,0xf4,0x00,0x00,0x00,0x00]

s_load_dwordx16 s[20:35], s[2:3], s0 glc dlc
// GFX11: s_load_b512 s[20:35], s[2:3], s0 glc dlc ; encoding: [0x01,0x65,0x10,0xf4,0x00,0x00,0x00,0x00]

s_load_dwordx16 s[20:35], s[2:3], 0x1234 glc dlc
// GFX11: s_load_b512 s[20:35], s[2:3], 0x1234 glc dlc ; encoding: [0x01,0x65,0x10,0xf4,0x34,0x12,0x00,0xf8]

s_buffer_load_dword s5, s[4:7], s0
// GFX11: s_buffer_load_b32 s5, s[4:7], s0        ; encoding: [0x42,0x01,0x20,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dword s101, s[4:7], s0
// GFX11: s_buffer_load_b32 s101, s[4:7], s0      ; encoding: [0x42,0x19,0x20,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dword vcc_lo, s[4:7], s0
// GFX11: s_buffer_load_b32 vcc_lo, s[4:7], s0    ; encoding: [0x82,0x1a,0x20,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dword vcc_hi, s[4:7], s0
// GFX11: s_buffer_load_b32 vcc_hi, s[4:7], s0    ; encoding: [0xc2,0x1a,0x20,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dword s5, s[8:11], s0
// GFX11: s_buffer_load_b32 s5, s[8:11], s0       ; encoding: [0x44,0x01,0x20,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dword s5, s[96:99], s0
// GFX11: s_buffer_load_b32 s5, s[96:99], s0      ; encoding: [0x70,0x01,0x20,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dword s5, s[4:7], s101
// GFX11: s_buffer_load_b32 s5, s[4:7], s101      ; encoding: [0x42,0x01,0x20,0xf4,0x00,0x00,0x00,0xca]

s_buffer_load_dword s5, s[4:7], vcc_lo
// GFX11: s_buffer_load_b32 s5, s[4:7], vcc_lo    ; encoding: [0x42,0x01,0x20,0xf4,0x00,0x00,0x00,0xd4]

s_buffer_load_dword s5, s[4:7], vcc_hi
// GFX11: s_buffer_load_b32 s5, s[4:7], vcc_hi    ; encoding: [0x42,0x01,0x20,0xf4,0x00,0x00,0x00,0xd6]

s_buffer_load_dword s5, s[4:7], m0
// GFX11: s_buffer_load_b32 s5, s[4:7], m0        ; encoding: [0x42,0x01,0x20,0xf4,0x00,0x00,0x00,0xfa]

s_buffer_load_dword s5, s[4:7], 0x0
// GFX11: s_buffer_load_b32 s5, s[4:7], 0x0       ; encoding: [0x42,0x01,0x20,0xf4,0x00,0x00,0x00,0xf8]

s_buffer_load_dword s5, s[4:7], s0 glc
// GFX11: s_buffer_load_b32 s5, s[4:7], s0 glc    ; encoding: [0x42,0x41,0x20,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dword s5, s[4:7], s0 dlc
// GFX11: s_buffer_load_b32 s5, s[4:7], s0 dlc    ; encoding: [0x42,0x21,0x20,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dword s5, s[4:7], s0 glc dlc
// GFX11: s_buffer_load_b32 s5, s[4:7], s0 glc dlc ; encoding: [0x42,0x61,0x20,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dword s5, s[4:7], 0x1234 glc dlc
// GFX11: s_buffer_load_b32 s5, s[4:7], 0x1234 glc dlc ; encoding: [0x42,0x61,0x20,0xf4,0x34,0x12,0x00,0xf8]

s_buffer_load_dwordx2 s[10:11], s[4:7], s0
// GFX11: s_buffer_load_b64 s[10:11], s[4:7], s0  ; encoding: [0x82,0x02,0x24,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx2 s[12:13], s[4:7], s0
// GFX11: s_buffer_load_b64 s[12:13], s[4:7], s0  ; encoding: [0x02,0x03,0x24,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx2 s[100:101], s[4:7], s0
// GFX11: s_buffer_load_b64 s[100:101], s[4:7], s0 ; encoding: [0x02,0x19,0x24,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx2 vcc, s[4:7], s0
// GFX11: s_buffer_load_b64 vcc, s[4:7], s0       ; encoding: [0x82,0x1a,0x24,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx2 s[10:11], s[8:11], s0
// GFX11: s_buffer_load_b64 s[10:11], s[8:11], s0 ; encoding: [0x84,0x02,0x24,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx2 s[10:11], s[96:99], s0
// GFX11: s_buffer_load_b64 s[10:11], s[96:99], s0 ; encoding: [0xb0,0x02,0x24,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx2 s[10:11], s[4:7], s101
// GFX11: s_buffer_load_b64 s[10:11], s[4:7], s101 ; encoding: [0x82,0x02,0x24,0xf4,0x00,0x00,0x00,0xca]

s_buffer_load_dwordx2 s[10:11], s[4:7], vcc_lo
// GFX11: s_buffer_load_b64 s[10:11], s[4:7], vcc_lo ; encoding: [0x82,0x02,0x24,0xf4,0x00,0x00,0x00,0xd4]

s_buffer_load_dwordx2 s[10:11], s[4:7], vcc_hi
// GFX11: s_buffer_load_b64 s[10:11], s[4:7], vcc_hi ; encoding: [0x82,0x02,0x24,0xf4,0x00,0x00,0x00,0xd6]

s_buffer_load_dwordx2 s[10:11], s[4:7], m0
// GFX11: s_buffer_load_b64 s[10:11], s[4:7], m0  ; encoding: [0x82,0x02,0x24,0xf4,0x00,0x00,0x00,0xfa]

s_buffer_load_dwordx2 s[10:11], s[4:7], 0x0
// GFX11: s_buffer_load_b64 s[10:11], s[4:7], 0x0 ; encoding: [0x82,0x02,0x24,0xf4,0x00,0x00,0x00,0xf8]

s_buffer_load_dwordx2 s[10:11], s[4:7], s0 glc
// GFX11: s_buffer_load_b64 s[10:11], s[4:7], s0 glc ; encoding: [0x82,0x42,0x24,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx2 s[10:11], s[4:7], s0 dlc
// GFX11: s_buffer_load_b64 s[10:11], s[4:7], s0 dlc ; encoding: [0x82,0x22,0x24,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx2 s[10:11], s[4:7], s0 glc dlc
// GFX11: s_buffer_load_b64 s[10:11], s[4:7], s0 glc dlc ; encoding: [0x82,0x62,0x24,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx2 s[10:11], s[4:7], 0x1234 glc dlc
// GFX11: s_buffer_load_b64 s[10:11], s[4:7], 0x1234 glc dlc ; encoding: [0x82,0x62,0x24,0xf4,0x34,0x12,0x00,0xf8]

s_buffer_load_dwordx4 s[20:23], s[4:7], s0
// GFX11: s_buffer_load_b128 s[20:23], s[4:7], s0 ; encoding: [0x02,0x05,0x28,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx4 s[24:27], s[4:7], s0
// GFX11: s_buffer_load_b128 s[24:27], s[4:7], s0 ; encoding: [0x02,0x06,0x28,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx4 s[96:99], s[4:7], s0
// GFX11: s_buffer_load_b128 s[96:99], s[4:7], s0 ; encoding: [0x02,0x18,0x28,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx4 s[20:23], s[8:11], s0
// GFX11: s_buffer_load_b128 s[20:23], s[8:11], s0 ; encoding: [0x04,0x05,0x28,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx4 s[20:23], s[96:99], s0
// GFX11: s_buffer_load_b128 s[20:23], s[96:99], s0 ; encoding: [0x30,0x05,0x28,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx4 s[20:23], s[4:7], s101
// GFX11: s_buffer_load_b128 s[20:23], s[4:7], s101 ; encoding: [0x02,0x05,0x28,0xf4,0x00,0x00,0x00,0xca]

s_buffer_load_dwordx4 s[20:23], s[4:7], vcc_lo
// GFX11: s_buffer_load_b128 s[20:23], s[4:7], vcc_lo ; encoding: [0x02,0x05,0x28,0xf4,0x00,0x00,0x00,0xd4]

s_buffer_load_dwordx4 s[20:23], s[4:7], vcc_hi
// GFX11: s_buffer_load_b128 s[20:23], s[4:7], vcc_hi ; encoding: [0x02,0x05,0x28,0xf4,0x00,0x00,0x00,0xd6]

s_buffer_load_dwordx4 s[20:23], s[4:7], m0
// GFX11: s_buffer_load_b128 s[20:23], s[4:7], m0 ; encoding: [0x02,0x05,0x28,0xf4,0x00,0x00,0x00,0xfa]

s_buffer_load_dwordx4 s[20:23], s[4:7], 0x0
// GFX11: s_buffer_load_b128 s[20:23], s[4:7], 0x0 ; encoding: [0x02,0x05,0x28,0xf4,0x00,0x00,0x00,0xf8]

s_buffer_load_dwordx4 s[20:23], s[4:7], s0 glc
// GFX11: s_buffer_load_b128 s[20:23], s[4:7], s0 glc ; encoding: [0x02,0x45,0x28,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx4 s[20:23], s[4:7], s0 dlc
// GFX11: s_buffer_load_b128 s[20:23], s[4:7], s0 dlc ; encoding: [0x02,0x25,0x28,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx4 s[20:23], s[4:7], s0 glc dlc
// GFX11: s_buffer_load_b128 s[20:23], s[4:7], s0 glc dlc ; encoding: [0x02,0x65,0x28,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx4 s[20:23], s[4:7], 0x1234 glc dlc
// GFX11: s_buffer_load_b128 s[20:23], s[4:7], 0x1234 glc dlc ; encoding: [0x02,0x65,0x28,0xf4,0x34,0x12,0x00,0xf8]

s_buffer_load_dwordx8 s[20:27], s[4:7], s0
// GFX11: s_buffer_load_b256 s[20:27], s[4:7], s0 ; encoding: [0x02,0x05,0x2c,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx8 s[24:31], s[4:7], s0
// GFX11: s_buffer_load_b256 s[24:31], s[4:7], s0 ; encoding: [0x02,0x06,0x2c,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx8 s[92:99], s[4:7], s0
// GFX11: s_buffer_load_b256 s[92:99], s[4:7], s0 ; encoding: [0x02,0x17,0x2c,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx8 s[20:27], s[8:11], s0
// GFX11: s_buffer_load_b256 s[20:27], s[8:11], s0 ; encoding: [0x04,0x05,0x2c,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx8 s[20:27], s[96:99], s0
// GFX11: s_buffer_load_b256 s[20:27], s[96:99], s0 ; encoding: [0x30,0x05,0x2c,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx8 s[20:27], s[4:7], s101
// GFX11: s_buffer_load_b256 s[20:27], s[4:7], s101 ; encoding: [0x02,0x05,0x2c,0xf4,0x00,0x00,0x00,0xca]

s_buffer_load_dwordx8 s[20:27], s[4:7], vcc_lo
// GFX11: s_buffer_load_b256 s[20:27], s[4:7], vcc_lo ; encoding: [0x02,0x05,0x2c,0xf4,0x00,0x00,0x00,0xd4]

s_buffer_load_dwordx8 s[20:27], s[4:7], vcc_hi
// GFX11: s_buffer_load_b256 s[20:27], s[4:7], vcc_hi ; encoding: [0x02,0x05,0x2c,0xf4,0x00,0x00,0x00,0xd6]

s_buffer_load_dwordx8 s[20:27], s[4:7], m0
// GFX11: s_buffer_load_b256 s[20:27], s[4:7], m0 ; encoding: [0x02,0x05,0x2c,0xf4,0x00,0x00,0x00,0xfa]

s_buffer_load_dwordx8 s[20:27], s[4:7], 0x0
// GFX11: s_buffer_load_b256 s[20:27], s[4:7], 0x0 ; encoding: [0x02,0x05,0x2c,0xf4,0x00,0x00,0x00,0xf8]

s_buffer_load_dwordx8 s[20:27], s[4:7], s0 glc
// GFX11: s_buffer_load_b256 s[20:27], s[4:7], s0 glc ; encoding: [0x02,0x45,0x2c,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx8 s[20:27], s[4:7], s0 dlc
// GFX11: s_buffer_load_b256 s[20:27], s[4:7], s0 dlc ; encoding: [0x02,0x25,0x2c,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx8 s[20:27], s[4:7], s0 glc dlc
// GFX11: s_buffer_load_b256 s[20:27], s[4:7], s0 glc dlc ; encoding: [0x02,0x65,0x2c,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx8 s[20:27], s[4:7], 0x1234 glc dlc
// GFX11: s_buffer_load_b256 s[20:27], s[4:7], 0x1234 glc dlc ; encoding: [0x02,0x65,0x2c,0xf4,0x34,0x12,0x00,0xf8]

s_buffer_load_dwordx16 s[20:35], s[4:7], s0
// GFX11: s_buffer_load_b512 s[20:35], s[4:7], s0 ; encoding: [0x02,0x05,0x30,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx16 s[24:39], s[4:7], s0
// GFX11: s_buffer_load_b512 s[24:39], s[4:7], s0 ; encoding: [0x02,0x06,0x30,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx16 s[84:99], s[4:7], s0
// GFX11: s_buffer_load_b512 s[84:99], s[4:7], s0 ; encoding: [0x02,0x15,0x30,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx16 s[20:35], s[8:11], s0
// GFX11: s_buffer_load_b512 s[20:35], s[8:11], s0 ; encoding: [0x04,0x05,0x30,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx16 s[20:35], s[96:99], s0
// GFX11: s_buffer_load_b512 s[20:35], s[96:99], s0 ; encoding: [0x30,0x05,0x30,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx16 s[20:35], s[4:7], s101
// GFX11: s_buffer_load_b512 s[20:35], s[4:7], s101 ; encoding: [0x02,0x05,0x30,0xf4,0x00,0x00,0x00,0xca]

s_buffer_load_dwordx16 s[20:35], s[4:7], vcc_lo
// GFX11: s_buffer_load_b512 s[20:35], s[4:7], vcc_lo ; encoding: [0x02,0x05,0x30,0xf4,0x00,0x00,0x00,0xd4]

s_buffer_load_dwordx16 s[20:35], s[4:7], vcc_hi
// GFX11: s_buffer_load_b512 s[20:35], s[4:7], vcc_hi ; encoding: [0x02,0x05,0x30,0xf4,0x00,0x00,0x00,0xd6]

s_buffer_load_dwordx16 s[20:35], s[4:7], m0
// GFX11: s_buffer_load_b512 s[20:35], s[4:7], m0 ; encoding: [0x02,0x05,0x30,0xf4,0x00,0x00,0x00,0xfa]

s_buffer_load_dwordx16 s[20:35], s[4:7], 0x0
// GFX11: s_buffer_load_b512 s[20:35], s[4:7], 0x0 ; encoding: [0x02,0x05,0x30,0xf4,0x00,0x00,0x00,0xf8]

s_buffer_load_dwordx16 s[20:35], s[4:7], s0 glc
// GFX11: s_buffer_load_b512 s[20:35], s[4:7], s0 glc ; encoding: [0x02,0x45,0x30,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx16 s[20:35], s[4:7], s0 dlc
// GFX11: s_buffer_load_b512 s[20:35], s[4:7], s0 dlc ; encoding: [0x02,0x25,0x30,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx16 s[20:35], s[4:7], s0 glc dlc
// GFX11: s_buffer_load_b512 s[20:35], s[4:7], s0 glc dlc ; encoding: [0x02,0x65,0x30,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx16 s[20:35], s[4:7], 0x1234 glc dlc
// GFX11: s_buffer_load_b512 s[20:35], s[4:7], 0x1234 glc dlc ; encoding: [0x02,0x65,0x30,0xf4,0x34,0x12,0x00,0xf8]
