; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=memcpyopt -S -verify-memoryssa | FileCheck %s
; These memmoves should get optimized to memcpys.

target datalayout = "e-p:64:64:64-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:64:64-f32:32:32-f64:64:64-v64:64:64-v128:128:128-a0:0:64-s0:64:64-f80:128:128"
target triple = "x86_64-apple-darwin9.0"

@C = external constant [0 x i8]

declare void @llvm.memmove.p0.p0.i64(ptr nocapture, ptr nocapture, i64, i1) nounwind

define ptr @test1(ptr nocapture %src) nounwind {
; CHECK-LABEL: @test1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[MALLOCCALL:%.*]] = tail call ptr @malloc(i32 trunc (i64 mul nuw (i64 ptrtoint (ptr getelementptr (i8, ptr null, i32 1) to i64), i64 13) to i32))
; CHECK-NEXT:    tail call void @llvm.memcpy.p0.p0.i64(ptr [[MALLOCCALL]], ptr [[SRC:%.*]], i64 13, i1 false)
; CHECK-NEXT:    ret ptr [[MALLOCCALL]]
;
entry:

  %malloccall = tail call ptr @malloc(i32 trunc (i64 mul nuw (i64 ptrtoint (ptr getelementptr (i8, ptr null, i32 1) to i64), i64 13) to i32))
  tail call void @llvm.memmove.p0.p0.i64(ptr %malloccall, ptr %src, i64 13, i1 false)
  ret ptr %malloccall
}
declare noalias ptr @malloc(i32)


define void @test2(ptr %P) nounwind {
; CHECK-LABEL: @test2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ADD_PTR:%.*]] = getelementptr i8, ptr [[P:%.*]], i64 16
; CHECK-NEXT:    tail call void @llvm.memcpy.p0.p0.i64(ptr [[P]], ptr [[ADD_PTR]], i64 16, i1 false)
; CHECK-NEXT:    ret void
;
entry:
  %add.ptr = getelementptr i8, ptr %P, i64 16
  tail call void @llvm.memmove.p0.p0.i64(ptr %P, ptr %add.ptr, i64 16, i1 false)
  ret void
}

; This cannot be optimize because the src/dst really do overlap.
define void @test3(ptr %P) nounwind {
; CHECK-LABEL: @test3(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ADD_PTR:%.*]] = getelementptr i8, ptr [[P:%.*]], i64 16
; CHECK-NEXT:    tail call void @llvm.memmove.p0.p0.i64(ptr [[P]], ptr [[ADD_PTR]], i64 17, i1 false)
; CHECK-NEXT:    ret void
;
entry:
  %add.ptr = getelementptr i8, ptr %P, i64 16
  tail call void @llvm.memmove.p0.p0.i64(ptr %P, ptr %add.ptr, i64 17, i1 false)
  ret void
}

define void @test4(ptr %P) nounwind {
; CHECK-LABEL: @test4(
; CHECK-NEXT:    tail call void @llvm.memcpy.p0.p0.i64(ptr [[P:%.*]], ptr @C, i64 17, i1 false)
; CHECK-NEXT:    ret void
;
  tail call void @llvm.memmove.p0.p0.i64(ptr %P, ptr @C, i64 17, i1 false)
  ret void
}
