; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s                                   -mtriple=x86_64-linux-gnu | FileCheck %s --check-prefixes=ALL,X64
; RUN: llc < %s -fast-isel -fast-isel-abort=1     -mtriple=x86_64-linux-gnu | FileCheck %s --check-prefixes=ALL,X64
; RUN: llc < %s -global-isel -global-isel-abort=1 -mtriple=x86_64-linux-gnu | FileCheck %s --check-prefixes=ALL,GISEL-X64
; RUN: llc < %s                                   -mtriple=i686-linux-gnu   | FileCheck %s --check-prefixes=ALL,X86
; RUN: llc < %s -fast-isel -fast-isel-abort=1     -mtriple=i686-linux-gnu   | FileCheck %s --check-prefixes=ALL,X86
; RUN: llc < %s -global-isel -global-isel-abort=1 -mtriple=i686-linux-gnu   | FileCheck %s --check-prefixes=ALL,GISEL-X86

declare void @llvm.trap()

define void @test_trap() {
; ALL-LABEL: test_trap:
; ALL:       # %bb.0:
; ALL-NEXT:    ud2
; ALL-NEXT:    ret{{[l|q]}}
  tail call void @llvm.trap()
  ret void
}

define void @test_debugtrap() {
; ALL-LABEL: test_debugtrap:
; ALL:       # %bb.0:
; ALL-NEXT:    int3
; ALL-NEXT:    ret{{[l|q]}}
  tail call void @llvm.debugtrap()
  ret void
}

define void @test_ubsantrap() {
; ALL-LABEL: test_ubsantrap:
; ALL:       # %bb.0:
; ALL-NEXT:    ud1l 12(%eax), %eax
; ALL-NEXT:    ret{{[l|q]}}
  call void @llvm.ubsantrap(i8 12)
  ret void
}

define void @test_ubsantrap_custom() nounwind {
; X64-LABEL: test_ubsantrap_custom:
; X64:       # %bb.0:
; X64-NEXT:    pushq %rax
; X64-NEXT:    movl $42, %edi
; X64-NEXT:    callq guide@PLT
; X64-NEXT:    popq %rax
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: test_ubsantrap_custom:
; GISEL-X64:       # %bb.0:
; GISEL-X64-NEXT:    pushq %rax
; GISEL-X64-NEXT:    movl $42, %edi
; GISEL-X64-NEXT:    callq guide
; GISEL-X64-NEXT:    popq %rax
; GISEL-X64-NEXT:    retq
;
; X86-LABEL: test_ubsantrap_custom:
; X86:       # %bb.0:
; X86-NEXT:    subl $12, %esp
; X86-NEXT:    movl $42, (%esp)
; X86-NEXT:    calll guide
; X86-NEXT:    addl $12, %esp
; X86-NEXT:    retl
;
; GISEL-X86-LABEL: test_ubsantrap_custom:
; GISEL-X86:       # %bb.0:
; GISEL-X86-NEXT:    subl $12, %esp
; GISEL-X86-NEXT:    movl $42, %eax
; GISEL-X86-NEXT:    movl %eax, (%esp)
; GISEL-X86-NEXT:    calll guide
; GISEL-X86-NEXT:    addl $12, %esp
; GISEL-X86-NEXT:    retl
  call void @llvm.ubsantrap(i8 42) "trap-func-name"="guide"
  ret void
}
