# RUN: llvm-mc -triple x86_64 -show-encoding -x86-asm-syntax=intel -output-asm-variant=1 %s | FileCheck %s

## Condition flags

# CHECK: ccmpo {dfv=} rbx, rax
# CHECK: encoding: [0x62,0xf4,0x84,0x00,0x39,0xc3]
         ccmpo {dfv=} rbx, rax
# CHECK: ccmpo {dfv=of} rbx, rax
# CHECK: encoding: [0x62,0xf4,0xc4,0x00,0x39,0xc3]
         ccmpo {dfv=of} rbx, rax
# CHECK: ccmpo {dfv=sf} rbx, rax
# CHECK: encoding: [0x62,0xf4,0xa4,0x00,0x39,0xc3]
         ccmpo {dfv=sf} rbx, rax
# CHECK: ccmpo {dfv=zf} rbx, rax
# CHECK: encoding: [0x62,0xf4,0x94,0x00,0x39,0xc3]
         ccmpo {dfv=zf} rbx, rax
# CHECK: ccmpo {dfv=cf} rbx, rax
# CHECK: encoding: [0x62,0xf4,0x8c,0x00,0x39,0xc3]
         ccmpo {dfv=cf} rbx, rax
# CHECK: ccmpo {dfv=of,sf} rbx, rax
# CHECK: encoding: [0x62,0xf4,0xe4,0x00,0x39,0xc3]
         ccmpo {dfv=of,sf} rbx, rax
# CHECK: ccmpo {dfv=of,sf} rbx, rax
# CHECK: encoding: [0x62,0xf4,0xe4,0x00,0x39,0xc3]
         ccmpo {dfv=sf,of} rbx, rax
# CHECK: ccmpo {dfv=of,sf,zf} rbx, rax
# CHECK: encoding: [0x62,0xf4,0xf4,0x00,0x39,0xc3]
         ccmpo {dfv=of,sf,zf} rbx, rax
# CHECK: ccmpo {dfv=of,sf,zf} rbx, rax
# CHECK: encoding: [0x62,0xf4,0xf4,0x00,0x39,0xc3]
         ccmpo {dfv=zf,of,sf} rbx, rax
# CHECK: ccmpo {dfv=of,sf,zf,cf} rbx, rax
# CHECK: encoding: [0x62,0xf4,0xfc,0x00,0x39,0xc3]
         ccmpo {dfv=of,sf,zf,cf} rbx, rax
# CHECK: ccmpo {dfv=of,sf,zf,cf} rbx, rax
# CHECK: encoding: [0x62,0xf4,0xfc,0x00,0x39,0xc3]
         ccmpo {dfv=cf,zf,sf,of} rbx, rax

## Condition code

# CHECK: ccmpb {dfv=of} byte ptr [r8 + 4*rax + 123], 123
# CHECK: encoding: [0x62,0xd4,0x44,0x02,0x80,0x7c,0x80,0x7b,0x7b]
         ccmpb {dfv=of} byte ptr [r8 + 4*rax + 123], 123
# CHECK: ccmpb {dfv=of} word ptr [r8 + 4*rax + 123], 123
# CHECK: encoding: [0x62,0xd4,0x45,0x02,0x83,0x7c,0x80,0x7b,0x7b]
         ccmpb {dfv=of} word ptr [r8 + 4*rax + 123], 123
# CHECK: ccmpb {dfv=of} word ptr [r8 + 4*rax + 123], 1234
# CHECK: encoding: [0x62,0xd4,0x45,0x02,0x81,0x7c,0x80,0x7b,0xd2,0x04]
         ccmpb {dfv=of} word ptr [r8 + 4*rax + 123], 1234
# CHECK: ccmpb {dfv=of} dword ptr [r8 + 4*rax + 123], 123
# CHECK: encoding: [0x62,0xd4,0x44,0x02,0x83,0x7c,0x80,0x7b,0x7b]
         ccmpb {dfv=of} dword ptr [r8 + 4*rax + 123], 123
# CHECK: ccmpb {dfv=of} dword ptr [r8 + 4*rax + 123], 123456
# CHECK: encoding: [0x62,0xd4,0x44,0x02,0x81,0x7c,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ccmpb {dfv=of} dword ptr [r8 + 4*rax + 123], 123456
# CHECK: ccmpb {dfv=of} qword ptr [r8 + 4*rax + 123], 123
# CHECK: encoding: [0x62,0xd4,0xc4,0x02,0x83,0x7c,0x80,0x7b,0x7b]
         ccmpb {dfv=of} qword ptr [r8 + 4*rax + 123], 123
# CHECK: ccmpb {dfv=of} qword ptr [r8 + 4*rax + 123], 123456
# CHECK: encoding: [0x62,0xd4,0xc4,0x02,0x81,0x7c,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ccmpb {dfv=of} qword ptr [r8 + 4*rax + 123], 123456
# CHECK: ccmpb {dfv=of} byte ptr [r8 + 4*rax + 123], bl
# CHECK: encoding: [0x62,0xd4,0x44,0x02,0x38,0x5c,0x80,0x7b]
         ccmpb {dfv=of} byte ptr [r8 + 4*rax + 123], bl
# CHECK: ccmpb {dfv=of} word ptr [r8 + 4*rax + 123], dx
# CHECK: encoding: [0x62,0xd4,0x45,0x02,0x39,0x54,0x80,0x7b]
         ccmpb {dfv=of} word ptr [r8 + 4*rax + 123], dx
# CHECK: ccmpb {dfv=of} dword ptr [r8 + 4*rax + 123], ecx
# CHECK: encoding: [0x62,0xd4,0x44,0x02,0x39,0x4c,0x80,0x7b]
         ccmpb {dfv=of} dword ptr [r8 + 4*rax + 123], ecx
# CHECK: ccmpb {dfv=of} qword ptr [r8 + 4*rax + 123], r9
# CHECK: encoding: [0x62,0x54,0xc4,0x02,0x39,0x4c,0x80,0x7b]
         ccmpb {dfv=of} qword ptr [r8 + 4*rax + 123], r9
# CHECK: ccmpb {dfv=of} bl, byte ptr [r8 + 4*rax + 123]
# CHECK: encoding: [0x62,0xd4,0x44,0x02,0x3a,0x5c,0x80,0x7b]
         ccmpb {dfv=of} bl, byte ptr [r8 + 4*rax + 123]
# CHECK: ccmpb {dfv=of} dx, word ptr [r8 + 4*rax + 123]
# CHECK: encoding: [0x62,0xd4,0x45,0x02,0x3b,0x54,0x80,0x7b]
         ccmpb {dfv=of} dx, word ptr [r8 + 4*rax + 123]
# CHECK: ccmpb {dfv=of} ecx, dword ptr [r8 + 4*rax + 123]
# CHECK: encoding: [0x62,0xd4,0x44,0x02,0x3b,0x4c,0x80,0x7b]
         ccmpb {dfv=of} ecx, dword ptr [r8 + 4*rax + 123]
# CHECK: ccmpb {dfv=of} r9, qword ptr [r8 + 4*rax + 123]
# CHECK: encoding: [0x62,0x54,0xc4,0x02,0x3b,0x4c,0x80,0x7b]
         ccmpb {dfv=of} r9, qword ptr [r8 + 4*rax + 123]
# CHECK: ccmpb {dfv=of} bl, 123
# CHECK: encoding: [0x62,0xf4,0x44,0x02,0x80,0xfb,0x7b]
         ccmpb {dfv=of} bl, 123
# CHECK: ccmpb {dfv=of} dx, 123
# CHECK: encoding: [0x62,0xf4,0x45,0x02,0x83,0xfa,0x7b]
         ccmpb {dfv=of} dx, 123
# CHECK: ccmpb {dfv=of} ecx, 123
# CHECK: encoding: [0x62,0xf4,0x44,0x02,0x83,0xf9,0x7b]
         ccmpb {dfv=of} ecx, 123
# CHECK: ccmpb {dfv=of} r9, 123
# CHECK: encoding: [0x62,0xd4,0xc4,0x02,0x83,0xf9,0x7b]
         ccmpb {dfv=of} r9, 123
# CHECK: ccmpb {dfv=of} dx, 1234
# CHECK: encoding: [0x62,0xf4,0x45,0x02,0x81,0xfa,0xd2,0x04]
         ccmpb {dfv=of} dx, 1234
# CHECK: ccmpb {dfv=of} ecx, 123456
# CHECK: encoding: [0x62,0xf4,0x44,0x02,0x81,0xf9,0x40,0xe2,0x01,0x00]
         ccmpb {dfv=of} ecx, 123456
# CHECK: ccmpb {dfv=of} r9, 123456
# CHECK: encoding: [0x62,0xd4,0xc4,0x02,0x81,0xf9,0x40,0xe2,0x01,0x00]
         ccmpb {dfv=of} r9, 123456
# CHECK: ccmpb {dfv=of} dl, bl
# CHECK: encoding: [0x62,0xf4,0x44,0x02,0x38,0xda]
         ccmpb {dfv=of} dl, bl
# CHECK: ccmpb {dfv=of} ax, dx
# CHECK: encoding: [0x62,0xf4,0x45,0x02,0x39,0xd0]
         ccmpb {dfv=of} ax, dx
# CHECK: ccmpb {dfv=of} edx, ecx
# CHECK: encoding: [0x62,0xf4,0x44,0x02,0x39,0xca]
         ccmpb {dfv=of} edx, ecx
# CHECK: ccmpb {dfv=of} r15, r9
# CHECK: encoding: [0x62,0x54,0xc4,0x02,0x39,0xcf]
         ccmpb {dfv=of} r15, r9
# CHECK: ccmpf {dfv=of} byte ptr [r8 + 4*rax + 123], 123
# CHECK: encoding: [0x62,0xd4,0x44,0x0b,0x80,0x7c,0x80,0x7b,0x7b]
         ccmpf {dfv=of} byte ptr [r8 + 4*rax + 123], 123
# CHECK: ccmpf {dfv=of} word ptr [r8 + 4*rax + 123], 123
# CHECK: encoding: [0x62,0xd4,0x45,0x0b,0x83,0x7c,0x80,0x7b,0x7b]
         ccmpf {dfv=of} word ptr [r8 + 4*rax + 123], 123
# CHECK: ccmpf {dfv=of} word ptr [r8 + 4*rax + 123], 1234
# CHECK: encoding: [0x62,0xd4,0x45,0x0b,0x81,0x7c,0x80,0x7b,0xd2,0x04]
         ccmpf {dfv=of} word ptr [r8 + 4*rax + 123], 1234
# CHECK: ccmpf {dfv=of} dword ptr [r8 + 4*rax + 123], 123
# CHECK: encoding: [0x62,0xd4,0x44,0x0b,0x83,0x7c,0x80,0x7b,0x7b]
         ccmpf {dfv=of} dword ptr [r8 + 4*rax + 123], 123
# CHECK: ccmpf {dfv=of} dword ptr [r8 + 4*rax + 123], 123456
# CHECK: encoding: [0x62,0xd4,0x44,0x0b,0x81,0x7c,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ccmpf {dfv=of} dword ptr [r8 + 4*rax + 123], 123456
# CHECK: ccmpf {dfv=of} qword ptr [r8 + 4*rax + 123], 123
# CHECK: encoding: [0x62,0xd4,0xc4,0x0b,0x83,0x7c,0x80,0x7b,0x7b]
         ccmpf {dfv=of} qword ptr [r8 + 4*rax + 123], 123
# CHECK: ccmpf {dfv=of} qword ptr [r8 + 4*rax + 123], 123456
# CHECK: encoding: [0x62,0xd4,0xc4,0x0b,0x81,0x7c,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ccmpf {dfv=of} qword ptr [r8 + 4*rax + 123], 123456
# CHECK: ccmpf {dfv=of} byte ptr [r8 + 4*rax + 123], bl
# CHECK: encoding: [0x62,0xd4,0x44,0x0b,0x38,0x5c,0x80,0x7b]
         ccmpf {dfv=of} byte ptr [r8 + 4*rax + 123], bl
# CHECK: ccmpf {dfv=of} word ptr [r8 + 4*rax + 123], dx
# CHECK: encoding: [0x62,0xd4,0x45,0x0b,0x39,0x54,0x80,0x7b]
         ccmpf {dfv=of} word ptr [r8 + 4*rax + 123], dx
# CHECK: ccmpf {dfv=of} dword ptr [r8 + 4*rax + 123], ecx
# CHECK: encoding: [0x62,0xd4,0x44,0x0b,0x39,0x4c,0x80,0x7b]
         ccmpf {dfv=of} dword ptr [r8 + 4*rax + 123], ecx
# CHECK: ccmpf {dfv=of} qword ptr [r8 + 4*rax + 123], r9
# CHECK: encoding: [0x62,0x54,0xc4,0x0b,0x39,0x4c,0x80,0x7b]
         ccmpf {dfv=of} qword ptr [r8 + 4*rax + 123], r9
# CHECK: ccmpf {dfv=of} bl, byte ptr [r8 + 4*rax + 123]
# CHECK: encoding: [0x62,0xd4,0x44,0x0b,0x3a,0x5c,0x80,0x7b]
         ccmpf {dfv=of} bl, byte ptr [r8 + 4*rax + 123]
# CHECK: ccmpf {dfv=of} dx, word ptr [r8 + 4*rax + 123]
# CHECK: encoding: [0x62,0xd4,0x45,0x0b,0x3b,0x54,0x80,0x7b]
         ccmpf {dfv=of} dx, word ptr [r8 + 4*rax + 123]
# CHECK: ccmpf {dfv=of} ecx, dword ptr [r8 + 4*rax + 123]
# CHECK: encoding: [0x62,0xd4,0x44,0x0b,0x3b,0x4c,0x80,0x7b]
         ccmpf {dfv=of} ecx, dword ptr [r8 + 4*rax + 123]
# CHECK: ccmpf {dfv=of} r9, qword ptr [r8 + 4*rax + 123]
# CHECK: encoding: [0x62,0x54,0xc4,0x0b,0x3b,0x4c,0x80,0x7b]
         ccmpf {dfv=of} r9, qword ptr [r8 + 4*rax + 123]
# CHECK: ccmpf {dfv=of} bl, 123
# CHECK: encoding: [0x62,0xf4,0x44,0x0b,0x80,0xfb,0x7b]
         ccmpf {dfv=of} bl, 123
# CHECK: ccmpf {dfv=of} dx, 123
# CHECK: encoding: [0x62,0xf4,0x45,0x0b,0x83,0xfa,0x7b]
         ccmpf {dfv=of} dx, 123
# CHECK: ccmpf {dfv=of} ecx, 123
# CHECK: encoding: [0x62,0xf4,0x44,0x0b,0x83,0xf9,0x7b]
         ccmpf {dfv=of} ecx, 123
# CHECK: ccmpf {dfv=of} r9, 123
# CHECK: encoding: [0x62,0xd4,0xc4,0x0b,0x83,0xf9,0x7b]
         ccmpf {dfv=of} r9, 123
# CHECK: ccmpf {dfv=of} dx, 1234
# CHECK: encoding: [0x62,0xf4,0x45,0x0b,0x81,0xfa,0xd2,0x04]
         ccmpf {dfv=of} dx, 1234
# CHECK: ccmpf {dfv=of} ecx, 123456
# CHECK: encoding: [0x62,0xf4,0x44,0x0b,0x81,0xf9,0x40,0xe2,0x01,0x00]
         ccmpf {dfv=of} ecx, 123456
# CHECK: ccmpf {dfv=of} r9, 123456
# CHECK: encoding: [0x62,0xd4,0xc4,0x0b,0x81,0xf9,0x40,0xe2,0x01,0x00]
         ccmpf {dfv=of} r9, 123456
# CHECK: ccmpf {dfv=of} dl, bl
# CHECK: encoding: [0x62,0xf4,0x44,0x0b,0x38,0xda]
         ccmpf {dfv=of} dl, bl
# CHECK: ccmpf {dfv=of} ax, dx
# CHECK: encoding: [0x62,0xf4,0x45,0x0b,0x39,0xd0]
         ccmpf {dfv=of} ax, dx
# CHECK: ccmpf {dfv=of} edx, ecx
# CHECK: encoding: [0x62,0xf4,0x44,0x0b,0x39,0xca]
         ccmpf {dfv=of} edx, ecx
# CHECK: ccmpf {dfv=of} r15, r9
# CHECK: encoding: [0x62,0x54,0xc4,0x0b,0x39,0xcf]
         ccmpf {dfv=of} r15, r9
# CHECK: ccmpl {dfv=of} byte ptr [r8 + 4*rax + 123], 123
# CHECK: encoding: [0x62,0xd4,0x44,0x0c,0x80,0x7c,0x80,0x7b,0x7b]
         ccmpl {dfv=of} byte ptr [r8 + 4*rax + 123], 123
# CHECK: ccmpl {dfv=of} word ptr [r8 + 4*rax + 123], 123
# CHECK: encoding: [0x62,0xd4,0x45,0x0c,0x83,0x7c,0x80,0x7b,0x7b]
         ccmpl {dfv=of} word ptr [r8 + 4*rax + 123], 123
# CHECK: ccmpl {dfv=of} word ptr [r8 + 4*rax + 123], 1234
# CHECK: encoding: [0x62,0xd4,0x45,0x0c,0x81,0x7c,0x80,0x7b,0xd2,0x04]
         ccmpl {dfv=of} word ptr [r8 + 4*rax + 123], 1234
# CHECK: ccmpl {dfv=of} dword ptr [r8 + 4*rax + 123], 123
# CHECK: encoding: [0x62,0xd4,0x44,0x0c,0x83,0x7c,0x80,0x7b,0x7b]
         ccmpl {dfv=of} dword ptr [r8 + 4*rax + 123], 123
# CHECK: ccmpl {dfv=of} dword ptr [r8 + 4*rax + 123], 123456
# CHECK: encoding: [0x62,0xd4,0x44,0x0c,0x81,0x7c,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ccmpl {dfv=of} dword ptr [r8 + 4*rax + 123], 123456
# CHECK: ccmpl {dfv=of} qword ptr [r8 + 4*rax + 123], 123
# CHECK: encoding: [0x62,0xd4,0xc4,0x0c,0x83,0x7c,0x80,0x7b,0x7b]
         ccmpl {dfv=of} qword ptr [r8 + 4*rax + 123], 123
# CHECK: ccmpl {dfv=of} qword ptr [r8 + 4*rax + 123], 123456
# CHECK: encoding: [0x62,0xd4,0xc4,0x0c,0x81,0x7c,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ccmpl {dfv=of} qword ptr [r8 + 4*rax + 123], 123456
# CHECK: ccmpl {dfv=of} byte ptr [r8 + 4*rax + 123], bl
# CHECK: encoding: [0x62,0xd4,0x44,0x0c,0x38,0x5c,0x80,0x7b]
         ccmpl {dfv=of} byte ptr [r8 + 4*rax + 123], bl
# CHECK: ccmpl {dfv=of} word ptr [r8 + 4*rax + 123], dx
# CHECK: encoding: [0x62,0xd4,0x45,0x0c,0x39,0x54,0x80,0x7b]
         ccmpl {dfv=of} word ptr [r8 + 4*rax + 123], dx
# CHECK: ccmpl {dfv=of} dword ptr [r8 + 4*rax + 123], ecx
# CHECK: encoding: [0x62,0xd4,0x44,0x0c,0x39,0x4c,0x80,0x7b]
         ccmpl {dfv=of} dword ptr [r8 + 4*rax + 123], ecx
# CHECK: ccmpl {dfv=of} qword ptr [r8 + 4*rax + 123], r9
# CHECK: encoding: [0x62,0x54,0xc4,0x0c,0x39,0x4c,0x80,0x7b]
         ccmpl {dfv=of} qword ptr [r8 + 4*rax + 123], r9
# CHECK: ccmpl {dfv=of} bl, byte ptr [r8 + 4*rax + 123]
# CHECK: encoding: [0x62,0xd4,0x44,0x0c,0x3a,0x5c,0x80,0x7b]
         ccmpl {dfv=of} bl, byte ptr [r8 + 4*rax + 123]
# CHECK: ccmpl {dfv=of} dx, word ptr [r8 + 4*rax + 123]
# CHECK: encoding: [0x62,0xd4,0x45,0x0c,0x3b,0x54,0x80,0x7b]
         ccmpl {dfv=of} dx, word ptr [r8 + 4*rax + 123]
# CHECK: ccmpl {dfv=of} ecx, dword ptr [r8 + 4*rax + 123]
# CHECK: encoding: [0x62,0xd4,0x44,0x0c,0x3b,0x4c,0x80,0x7b]
         ccmpl {dfv=of} ecx, dword ptr [r8 + 4*rax + 123]
# CHECK: ccmpl {dfv=of} r9, qword ptr [r8 + 4*rax + 123]
# CHECK: encoding: [0x62,0x54,0xc4,0x0c,0x3b,0x4c,0x80,0x7b]
         ccmpl {dfv=of} r9, qword ptr [r8 + 4*rax + 123]
# CHECK: ccmpl {dfv=of} bl, 123
# CHECK: encoding: [0x62,0xf4,0x44,0x0c,0x80,0xfb,0x7b]
         ccmpl {dfv=of} bl, 123
# CHECK: ccmpl {dfv=of} dx, 123
# CHECK: encoding: [0x62,0xf4,0x45,0x0c,0x83,0xfa,0x7b]
         ccmpl {dfv=of} dx, 123
# CHECK: ccmpl {dfv=of} ecx, 123
# CHECK: encoding: [0x62,0xf4,0x44,0x0c,0x83,0xf9,0x7b]
         ccmpl {dfv=of} ecx, 123
# CHECK: ccmpl {dfv=of} r9, 123
# CHECK: encoding: [0x62,0xd4,0xc4,0x0c,0x83,0xf9,0x7b]
         ccmpl {dfv=of} r9, 123
# CHECK: ccmpl {dfv=of} dx, 1234
# CHECK: encoding: [0x62,0xf4,0x45,0x0c,0x81,0xfa,0xd2,0x04]
         ccmpl {dfv=of} dx, 1234
# CHECK: ccmpl {dfv=of} ecx, 123456
# CHECK: encoding: [0x62,0xf4,0x44,0x0c,0x81,0xf9,0x40,0xe2,0x01,0x00]
         ccmpl {dfv=of} ecx, 123456
# CHECK: ccmpl {dfv=of} r9, 123456
# CHECK: encoding: [0x62,0xd4,0xc4,0x0c,0x81,0xf9,0x40,0xe2,0x01,0x00]
         ccmpl {dfv=of} r9, 123456
# CHECK: ccmpl {dfv=of} dl, bl
# CHECK: encoding: [0x62,0xf4,0x44,0x0c,0x38,0xda]
         ccmpl {dfv=of} dl, bl
# CHECK: ccmpl {dfv=of} ax, dx
# CHECK: encoding: [0x62,0xf4,0x45,0x0c,0x39,0xd0]
         ccmpl {dfv=of} ax, dx
# CHECK: ccmpl {dfv=of} edx, ecx
# CHECK: encoding: [0x62,0xf4,0x44,0x0c,0x39,0xca]
         ccmpl {dfv=of} edx, ecx
# CHECK: ccmpl {dfv=of} r15, r9
# CHECK: encoding: [0x62,0x54,0xc4,0x0c,0x39,0xcf]
         ccmpl {dfv=of} r15, r9
# CHECK: ccmple {dfv=of} byte ptr [r8 + 4*rax + 123], 123
# CHECK: encoding: [0x62,0xd4,0x44,0x0e,0x80,0x7c,0x80,0x7b,0x7b]
         ccmple {dfv=of} byte ptr [r8 + 4*rax + 123], 123
# CHECK: ccmple {dfv=of} word ptr [r8 + 4*rax + 123], 123
# CHECK: encoding: [0x62,0xd4,0x45,0x0e,0x83,0x7c,0x80,0x7b,0x7b]
         ccmple {dfv=of} word ptr [r8 + 4*rax + 123], 123
# CHECK: ccmple {dfv=of} word ptr [r8 + 4*rax + 123], 1234
# CHECK: encoding: [0x62,0xd4,0x45,0x0e,0x81,0x7c,0x80,0x7b,0xd2,0x04]
         ccmple {dfv=of} word ptr [r8 + 4*rax + 123], 1234
# CHECK: ccmple {dfv=of} dword ptr [r8 + 4*rax + 123], 123
# CHECK: encoding: [0x62,0xd4,0x44,0x0e,0x83,0x7c,0x80,0x7b,0x7b]
         ccmple {dfv=of} dword ptr [r8 + 4*rax + 123], 123
# CHECK: ccmple {dfv=of} dword ptr [r8 + 4*rax + 123], 123456
# CHECK: encoding: [0x62,0xd4,0x44,0x0e,0x81,0x7c,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ccmple {dfv=of} dword ptr [r8 + 4*rax + 123], 123456
# CHECK: ccmple {dfv=of} qword ptr [r8 + 4*rax + 123], 123
# CHECK: encoding: [0x62,0xd4,0xc4,0x0e,0x83,0x7c,0x80,0x7b,0x7b]
         ccmple {dfv=of} qword ptr [r8 + 4*rax + 123], 123
# CHECK: ccmple {dfv=of} qword ptr [r8 + 4*rax + 123], 123456
# CHECK: encoding: [0x62,0xd4,0xc4,0x0e,0x81,0x7c,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ccmple {dfv=of} qword ptr [r8 + 4*rax + 123], 123456
# CHECK: ccmple {dfv=of} byte ptr [r8 + 4*rax + 123], bl
# CHECK: encoding: [0x62,0xd4,0x44,0x0e,0x38,0x5c,0x80,0x7b]
         ccmple {dfv=of} byte ptr [r8 + 4*rax + 123], bl
# CHECK: ccmple {dfv=of} word ptr [r8 + 4*rax + 123], dx
# CHECK: encoding: [0x62,0xd4,0x45,0x0e,0x39,0x54,0x80,0x7b]
         ccmple {dfv=of} word ptr [r8 + 4*rax + 123], dx
# CHECK: ccmple {dfv=of} dword ptr [r8 + 4*rax + 123], ecx
# CHECK: encoding: [0x62,0xd4,0x44,0x0e,0x39,0x4c,0x80,0x7b]
         ccmple {dfv=of} dword ptr [r8 + 4*rax + 123], ecx
# CHECK: ccmple {dfv=of} qword ptr [r8 + 4*rax + 123], r9
# CHECK: encoding: [0x62,0x54,0xc4,0x0e,0x39,0x4c,0x80,0x7b]
         ccmple {dfv=of} qword ptr [r8 + 4*rax + 123], r9
# CHECK: ccmple {dfv=of} bl, byte ptr [r8 + 4*rax + 123]
# CHECK: encoding: [0x62,0xd4,0x44,0x0e,0x3a,0x5c,0x80,0x7b]
         ccmple {dfv=of} bl, byte ptr [r8 + 4*rax + 123]
# CHECK: ccmple {dfv=of} dx, word ptr [r8 + 4*rax + 123]
# CHECK: encoding: [0x62,0xd4,0x45,0x0e,0x3b,0x54,0x80,0x7b]
         ccmple {dfv=of} dx, word ptr [r8 + 4*rax + 123]
# CHECK: ccmple {dfv=of} ecx, dword ptr [r8 + 4*rax + 123]
# CHECK: encoding: [0x62,0xd4,0x44,0x0e,0x3b,0x4c,0x80,0x7b]
         ccmple {dfv=of} ecx, dword ptr [r8 + 4*rax + 123]
# CHECK: ccmple {dfv=of} r9, qword ptr [r8 + 4*rax + 123]
# CHECK: encoding: [0x62,0x54,0xc4,0x0e,0x3b,0x4c,0x80,0x7b]
         ccmple {dfv=of} r9, qword ptr [r8 + 4*rax + 123]
# CHECK: ccmple {dfv=of} bl, 123
# CHECK: encoding: [0x62,0xf4,0x44,0x0e,0x80,0xfb,0x7b]
         ccmple {dfv=of} bl, 123
# CHECK: ccmple {dfv=of} dx, 123
# CHECK: encoding: [0x62,0xf4,0x45,0x0e,0x83,0xfa,0x7b]
         ccmple {dfv=of} dx, 123
# CHECK: ccmple {dfv=of} ecx, 123
# CHECK: encoding: [0x62,0xf4,0x44,0x0e,0x83,0xf9,0x7b]
         ccmple {dfv=of} ecx, 123
# CHECK: ccmple {dfv=of} r9, 123
# CHECK: encoding: [0x62,0xd4,0xc4,0x0e,0x83,0xf9,0x7b]
         ccmple {dfv=of} r9, 123
# CHECK: ccmple {dfv=of} dx, 1234
# CHECK: encoding: [0x62,0xf4,0x45,0x0e,0x81,0xfa,0xd2,0x04]
         ccmple {dfv=of} dx, 1234
# CHECK: ccmple {dfv=of} ecx, 123456
# CHECK: encoding: [0x62,0xf4,0x44,0x0e,0x81,0xf9,0x40,0xe2,0x01,0x00]
         ccmple {dfv=of} ecx, 123456
# CHECK: ccmple {dfv=of} r9, 123456
# CHECK: encoding: [0x62,0xd4,0xc4,0x0e,0x81,0xf9,0x40,0xe2,0x01,0x00]
         ccmple {dfv=of} r9, 123456
# CHECK: ccmple {dfv=of} dl, bl
# CHECK: encoding: [0x62,0xf4,0x44,0x0e,0x38,0xda]
         ccmple {dfv=of} dl, bl
# CHECK: ccmple {dfv=of} ax, dx
# CHECK: encoding: [0x62,0xf4,0x45,0x0e,0x39,0xd0]
         ccmple {dfv=of} ax, dx
# CHECK: ccmple {dfv=of} edx, ecx
# CHECK: encoding: [0x62,0xf4,0x44,0x0e,0x39,0xca]
         ccmple {dfv=of} edx, ecx
# CHECK: ccmple {dfv=of} r15, r9
# CHECK: encoding: [0x62,0x54,0xc4,0x0e,0x39,0xcf]
         ccmple {dfv=of} r15, r9
# CHECK: ccmpae {dfv=of} byte ptr [r8 + 4*rax + 123], 123
# CHECK: encoding: [0x62,0xd4,0x44,0x03,0x80,0x7c,0x80,0x7b,0x7b]
         ccmpae {dfv=of} byte ptr [r8 + 4*rax + 123], 123
# CHECK: ccmpae {dfv=of} word ptr [r8 + 4*rax + 123], 123
# CHECK: encoding: [0x62,0xd4,0x45,0x03,0x83,0x7c,0x80,0x7b,0x7b]
         ccmpae {dfv=of} word ptr [r8 + 4*rax + 123], 123
# CHECK: ccmpae {dfv=of} word ptr [r8 + 4*rax + 123], 1234
# CHECK: encoding: [0x62,0xd4,0x45,0x03,0x81,0x7c,0x80,0x7b,0xd2,0x04]
         ccmpae {dfv=of} word ptr [r8 + 4*rax + 123], 1234
# CHECK: ccmpae {dfv=of} dword ptr [r8 + 4*rax + 123], 123
# CHECK: encoding: [0x62,0xd4,0x44,0x03,0x83,0x7c,0x80,0x7b,0x7b]
         ccmpae {dfv=of} dword ptr [r8 + 4*rax + 123], 123
# CHECK: ccmpae {dfv=of} dword ptr [r8 + 4*rax + 123], 123456
# CHECK: encoding: [0x62,0xd4,0x44,0x03,0x81,0x7c,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ccmpae {dfv=of} dword ptr [r8 + 4*rax + 123], 123456
# CHECK: ccmpae {dfv=of} qword ptr [r8 + 4*rax + 123], 123
# CHECK: encoding: [0x62,0xd4,0xc4,0x03,0x83,0x7c,0x80,0x7b,0x7b]
         ccmpae {dfv=of} qword ptr [r8 + 4*rax + 123], 123
# CHECK: ccmpae {dfv=of} qword ptr [r8 + 4*rax + 123], 123456
# CHECK: encoding: [0x62,0xd4,0xc4,0x03,0x81,0x7c,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ccmpae {dfv=of} qword ptr [r8 + 4*rax + 123], 123456
# CHECK: ccmpae {dfv=of} byte ptr [r8 + 4*rax + 123], bl
# CHECK: encoding: [0x62,0xd4,0x44,0x03,0x38,0x5c,0x80,0x7b]
         ccmpae {dfv=of} byte ptr [r8 + 4*rax + 123], bl
# CHECK: ccmpae {dfv=of} word ptr [r8 + 4*rax + 123], dx
# CHECK: encoding: [0x62,0xd4,0x45,0x03,0x39,0x54,0x80,0x7b]
         ccmpae {dfv=of} word ptr [r8 + 4*rax + 123], dx
# CHECK: ccmpae {dfv=of} dword ptr [r8 + 4*rax + 123], ecx
# CHECK: encoding: [0x62,0xd4,0x44,0x03,0x39,0x4c,0x80,0x7b]
         ccmpae {dfv=of} dword ptr [r8 + 4*rax + 123], ecx
# CHECK: ccmpae {dfv=of} qword ptr [r8 + 4*rax + 123], r9
# CHECK: encoding: [0x62,0x54,0xc4,0x03,0x39,0x4c,0x80,0x7b]
         ccmpae {dfv=of} qword ptr [r8 + 4*rax + 123], r9
# CHECK: ccmpae {dfv=of} bl, byte ptr [r8 + 4*rax + 123]
# CHECK: encoding: [0x62,0xd4,0x44,0x03,0x3a,0x5c,0x80,0x7b]
         ccmpae {dfv=of} bl, byte ptr [r8 + 4*rax + 123]
# CHECK: ccmpae {dfv=of} dx, word ptr [r8 + 4*rax + 123]
# CHECK: encoding: [0x62,0xd4,0x45,0x03,0x3b,0x54,0x80,0x7b]
         ccmpae {dfv=of} dx, word ptr [r8 + 4*rax + 123]
# CHECK: ccmpae {dfv=of} ecx, dword ptr [r8 + 4*rax + 123]
# CHECK: encoding: [0x62,0xd4,0x44,0x03,0x3b,0x4c,0x80,0x7b]
         ccmpae {dfv=of} ecx, dword ptr [r8 + 4*rax + 123]
# CHECK: ccmpae {dfv=of} r9, qword ptr [r8 + 4*rax + 123]
# CHECK: encoding: [0x62,0x54,0xc4,0x03,0x3b,0x4c,0x80,0x7b]
         ccmpae {dfv=of} r9, qword ptr [r8 + 4*rax + 123]
# CHECK: ccmpae {dfv=of} bl, 123
# CHECK: encoding: [0x62,0xf4,0x44,0x03,0x80,0xfb,0x7b]
         ccmpae {dfv=of} bl, 123
# CHECK: ccmpae {dfv=of} dx, 123
# CHECK: encoding: [0x62,0xf4,0x45,0x03,0x83,0xfa,0x7b]
         ccmpae {dfv=of} dx, 123
# CHECK: ccmpae {dfv=of} ecx, 123
# CHECK: encoding: [0x62,0xf4,0x44,0x03,0x83,0xf9,0x7b]
         ccmpae {dfv=of} ecx, 123
# CHECK: ccmpae {dfv=of} r9, 123
# CHECK: encoding: [0x62,0xd4,0xc4,0x03,0x83,0xf9,0x7b]
         ccmpae {dfv=of} r9, 123
# CHECK: ccmpae {dfv=of} dx, 1234
# CHECK: encoding: [0x62,0xf4,0x45,0x03,0x81,0xfa,0xd2,0x04]
         ccmpae {dfv=of} dx, 1234
# CHECK: ccmpae {dfv=of} ecx, 123456
# CHECK: encoding: [0x62,0xf4,0x44,0x03,0x81,0xf9,0x40,0xe2,0x01,0x00]
         ccmpae {dfv=of} ecx, 123456
# CHECK: ccmpae {dfv=of} r9, 123456
# CHECK: encoding: [0x62,0xd4,0xc4,0x03,0x81,0xf9,0x40,0xe2,0x01,0x00]
         ccmpae {dfv=of} r9, 123456
# CHECK: ccmpae {dfv=of} dl, bl
# CHECK: encoding: [0x62,0xf4,0x44,0x03,0x38,0xda]
         ccmpae {dfv=of} dl, bl
# CHECK: ccmpae {dfv=of} ax, dx
# CHECK: encoding: [0x62,0xf4,0x45,0x03,0x39,0xd0]
         ccmpae {dfv=of} ax, dx
# CHECK: ccmpae {dfv=of} edx, ecx
# CHECK: encoding: [0x62,0xf4,0x44,0x03,0x39,0xca]
         ccmpae {dfv=of} edx, ecx
# CHECK: ccmpae {dfv=of} r15, r9
# CHECK: encoding: [0x62,0x54,0xc4,0x03,0x39,0xcf]
         ccmpae {dfv=of} r15, r9
# CHECK: ccmpa {dfv=of} byte ptr [r8 + 4*rax + 123], 123
# CHECK: encoding: [0x62,0xd4,0x44,0x07,0x80,0x7c,0x80,0x7b,0x7b]
         ccmpa {dfv=of} byte ptr [r8 + 4*rax + 123], 123
# CHECK: ccmpa {dfv=of} word ptr [r8 + 4*rax + 123], 123
# CHECK: encoding: [0x62,0xd4,0x45,0x07,0x83,0x7c,0x80,0x7b,0x7b]
         ccmpa {dfv=of} word ptr [r8 + 4*rax + 123], 123
# CHECK: ccmpa {dfv=of} word ptr [r8 + 4*rax + 123], 1234
# CHECK: encoding: [0x62,0xd4,0x45,0x07,0x81,0x7c,0x80,0x7b,0xd2,0x04]
         ccmpa {dfv=of} word ptr [r8 + 4*rax + 123], 1234
# CHECK: ccmpa {dfv=of} dword ptr [r8 + 4*rax + 123], 123
# CHECK: encoding: [0x62,0xd4,0x44,0x07,0x83,0x7c,0x80,0x7b,0x7b]
         ccmpa {dfv=of} dword ptr [r8 + 4*rax + 123], 123
# CHECK: ccmpa {dfv=of} dword ptr [r8 + 4*rax + 123], 123456
# CHECK: encoding: [0x62,0xd4,0x44,0x07,0x81,0x7c,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ccmpa {dfv=of} dword ptr [r8 + 4*rax + 123], 123456
# CHECK: ccmpa {dfv=of} qword ptr [r8 + 4*rax + 123], 123
# CHECK: encoding: [0x62,0xd4,0xc4,0x07,0x83,0x7c,0x80,0x7b,0x7b]
         ccmpa {dfv=of} qword ptr [r8 + 4*rax + 123], 123
# CHECK: ccmpa {dfv=of} qword ptr [r8 + 4*rax + 123], 123456
# CHECK: encoding: [0x62,0xd4,0xc4,0x07,0x81,0x7c,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ccmpa {dfv=of} qword ptr [r8 + 4*rax + 123], 123456
# CHECK: ccmpa {dfv=of} byte ptr [r8 + 4*rax + 123], bl
# CHECK: encoding: [0x62,0xd4,0x44,0x07,0x38,0x5c,0x80,0x7b]
         ccmpa {dfv=of} byte ptr [r8 + 4*rax + 123], bl
# CHECK: ccmpa {dfv=of} word ptr [r8 + 4*rax + 123], dx
# CHECK: encoding: [0x62,0xd4,0x45,0x07,0x39,0x54,0x80,0x7b]
         ccmpa {dfv=of} word ptr [r8 + 4*rax + 123], dx
# CHECK: ccmpa {dfv=of} dword ptr [r8 + 4*rax + 123], ecx
# CHECK: encoding: [0x62,0xd4,0x44,0x07,0x39,0x4c,0x80,0x7b]
         ccmpa {dfv=of} dword ptr [r8 + 4*rax + 123], ecx
# CHECK: ccmpa {dfv=of} qword ptr [r8 + 4*rax + 123], r9
# CHECK: encoding: [0x62,0x54,0xc4,0x07,0x39,0x4c,0x80,0x7b]
         ccmpa {dfv=of} qword ptr [r8 + 4*rax + 123], r9
# CHECK: ccmpa {dfv=of} bl, byte ptr [r8 + 4*rax + 123]
# CHECK: encoding: [0x62,0xd4,0x44,0x07,0x3a,0x5c,0x80,0x7b]
         ccmpa {dfv=of} bl, byte ptr [r8 + 4*rax + 123]
# CHECK: ccmpa {dfv=of} dx, word ptr [r8 + 4*rax + 123]
# CHECK: encoding: [0x62,0xd4,0x45,0x07,0x3b,0x54,0x80,0x7b]
         ccmpa {dfv=of} dx, word ptr [r8 + 4*rax + 123]
# CHECK: ccmpa {dfv=of} ecx, dword ptr [r8 + 4*rax + 123]
# CHECK: encoding: [0x62,0xd4,0x44,0x07,0x3b,0x4c,0x80,0x7b]
         ccmpa {dfv=of} ecx, dword ptr [r8 + 4*rax + 123]
# CHECK: ccmpa {dfv=of} r9, qword ptr [r8 + 4*rax + 123]
# CHECK: encoding: [0x62,0x54,0xc4,0x07,0x3b,0x4c,0x80,0x7b]
         ccmpa {dfv=of} r9, qword ptr [r8 + 4*rax + 123]
# CHECK: ccmpa {dfv=of} bl, 123
# CHECK: encoding: [0x62,0xf4,0x44,0x07,0x80,0xfb,0x7b]
         ccmpa {dfv=of} bl, 123
# CHECK: ccmpa {dfv=of} dx, 123
# CHECK: encoding: [0x62,0xf4,0x45,0x07,0x83,0xfa,0x7b]
         ccmpa {dfv=of} dx, 123
# CHECK: ccmpa {dfv=of} ecx, 123
# CHECK: encoding: [0x62,0xf4,0x44,0x07,0x83,0xf9,0x7b]
         ccmpa {dfv=of} ecx, 123
# CHECK: ccmpa {dfv=of} r9, 123
# CHECK: encoding: [0x62,0xd4,0xc4,0x07,0x83,0xf9,0x7b]
         ccmpa {dfv=of} r9, 123
# CHECK: ccmpa {dfv=of} dx, 1234
# CHECK: encoding: [0x62,0xf4,0x45,0x07,0x81,0xfa,0xd2,0x04]
         ccmpa {dfv=of} dx, 1234
# CHECK: ccmpa {dfv=of} ecx, 123456
# CHECK: encoding: [0x62,0xf4,0x44,0x07,0x81,0xf9,0x40,0xe2,0x01,0x00]
         ccmpa {dfv=of} ecx, 123456
# CHECK: ccmpa {dfv=of} r9, 123456
# CHECK: encoding: [0x62,0xd4,0xc4,0x07,0x81,0xf9,0x40,0xe2,0x01,0x00]
         ccmpa {dfv=of} r9, 123456
# CHECK: ccmpa {dfv=of} dl, bl
# CHECK: encoding: [0x62,0xf4,0x44,0x07,0x38,0xda]
         ccmpa {dfv=of} dl, bl
# CHECK: ccmpa {dfv=of} ax, dx
# CHECK: encoding: [0x62,0xf4,0x45,0x07,0x39,0xd0]
         ccmpa {dfv=of} ax, dx
# CHECK: ccmpa {dfv=of} edx, ecx
# CHECK: encoding: [0x62,0xf4,0x44,0x07,0x39,0xca]
         ccmpa {dfv=of} edx, ecx
# CHECK: ccmpa {dfv=of} r15, r9
# CHECK: encoding: [0x62,0x54,0xc4,0x07,0x39,0xcf]
         ccmpa {dfv=of} r15, r9
# CHECK: ccmpge {dfv=of} byte ptr [r8 + 4*rax + 123], 123
# CHECK: encoding: [0x62,0xd4,0x44,0x0d,0x80,0x7c,0x80,0x7b,0x7b]
         ccmpge {dfv=of} byte ptr [r8 + 4*rax + 123], 123
# CHECK: ccmpge {dfv=of} word ptr [r8 + 4*rax + 123], 123
# CHECK: encoding: [0x62,0xd4,0x45,0x0d,0x83,0x7c,0x80,0x7b,0x7b]
         ccmpge {dfv=of} word ptr [r8 + 4*rax + 123], 123
# CHECK: ccmpge {dfv=of} word ptr [r8 + 4*rax + 123], 1234
# CHECK: encoding: [0x62,0xd4,0x45,0x0d,0x81,0x7c,0x80,0x7b,0xd2,0x04]
         ccmpge {dfv=of} word ptr [r8 + 4*rax + 123], 1234
# CHECK: ccmpge {dfv=of} dword ptr [r8 + 4*rax + 123], 123
# CHECK: encoding: [0x62,0xd4,0x44,0x0d,0x83,0x7c,0x80,0x7b,0x7b]
         ccmpge {dfv=of} dword ptr [r8 + 4*rax + 123], 123
# CHECK: ccmpge {dfv=of} dword ptr [r8 + 4*rax + 123], 123456
# CHECK: encoding: [0x62,0xd4,0x44,0x0d,0x81,0x7c,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ccmpge {dfv=of} dword ptr [r8 + 4*rax + 123], 123456
# CHECK: ccmpge {dfv=of} qword ptr [r8 + 4*rax + 123], 123
# CHECK: encoding: [0x62,0xd4,0xc4,0x0d,0x83,0x7c,0x80,0x7b,0x7b]
         ccmpge {dfv=of} qword ptr [r8 + 4*rax + 123], 123
# CHECK: ccmpge {dfv=of} qword ptr [r8 + 4*rax + 123], 123456
# CHECK: encoding: [0x62,0xd4,0xc4,0x0d,0x81,0x7c,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ccmpge {dfv=of} qword ptr [r8 + 4*rax + 123], 123456
# CHECK: ccmpge {dfv=of} byte ptr [r8 + 4*rax + 123], bl
# CHECK: encoding: [0x62,0xd4,0x44,0x0d,0x38,0x5c,0x80,0x7b]
         ccmpge {dfv=of} byte ptr [r8 + 4*rax + 123], bl
# CHECK: ccmpge {dfv=of} word ptr [r8 + 4*rax + 123], dx
# CHECK: encoding: [0x62,0xd4,0x45,0x0d,0x39,0x54,0x80,0x7b]
         ccmpge {dfv=of} word ptr [r8 + 4*rax + 123], dx
# CHECK: ccmpge {dfv=of} dword ptr [r8 + 4*rax + 123], ecx
# CHECK: encoding: [0x62,0xd4,0x44,0x0d,0x39,0x4c,0x80,0x7b]
         ccmpge {dfv=of} dword ptr [r8 + 4*rax + 123], ecx
# CHECK: ccmpge {dfv=of} qword ptr [r8 + 4*rax + 123], r9
# CHECK: encoding: [0x62,0x54,0xc4,0x0d,0x39,0x4c,0x80,0x7b]
         ccmpge {dfv=of} qword ptr [r8 + 4*rax + 123], r9
# CHECK: ccmpge {dfv=of} bl, byte ptr [r8 + 4*rax + 123]
# CHECK: encoding: [0x62,0xd4,0x44,0x0d,0x3a,0x5c,0x80,0x7b]
         ccmpge {dfv=of} bl, byte ptr [r8 + 4*rax + 123]
# CHECK: ccmpge {dfv=of} dx, word ptr [r8 + 4*rax + 123]
# CHECK: encoding: [0x62,0xd4,0x45,0x0d,0x3b,0x54,0x80,0x7b]
         ccmpge {dfv=of} dx, word ptr [r8 + 4*rax + 123]
# CHECK: ccmpge {dfv=of} ecx, dword ptr [r8 + 4*rax + 123]
# CHECK: encoding: [0x62,0xd4,0x44,0x0d,0x3b,0x4c,0x80,0x7b]
         ccmpge {dfv=of} ecx, dword ptr [r8 + 4*rax + 123]
# CHECK: ccmpge {dfv=of} r9, qword ptr [r8 + 4*rax + 123]
# CHECK: encoding: [0x62,0x54,0xc4,0x0d,0x3b,0x4c,0x80,0x7b]
         ccmpge {dfv=of} r9, qword ptr [r8 + 4*rax + 123]
# CHECK: ccmpge {dfv=of} bl, 123
# CHECK: encoding: [0x62,0xf4,0x44,0x0d,0x80,0xfb,0x7b]
         ccmpge {dfv=of} bl, 123
# CHECK: ccmpge {dfv=of} dx, 123
# CHECK: encoding: [0x62,0xf4,0x45,0x0d,0x83,0xfa,0x7b]
         ccmpge {dfv=of} dx, 123
# CHECK: ccmpge {dfv=of} ecx, 123
# CHECK: encoding: [0x62,0xf4,0x44,0x0d,0x83,0xf9,0x7b]
         ccmpge {dfv=of} ecx, 123
# CHECK: ccmpge {dfv=of} r9, 123
# CHECK: encoding: [0x62,0xd4,0xc4,0x0d,0x83,0xf9,0x7b]
         ccmpge {dfv=of} r9, 123
# CHECK: ccmpge {dfv=of} dx, 1234
# CHECK: encoding: [0x62,0xf4,0x45,0x0d,0x81,0xfa,0xd2,0x04]
         ccmpge {dfv=of} dx, 1234
# CHECK: ccmpge {dfv=of} ecx, 123456
# CHECK: encoding: [0x62,0xf4,0x44,0x0d,0x81,0xf9,0x40,0xe2,0x01,0x00]
         ccmpge {dfv=of} ecx, 123456
# CHECK: ccmpge {dfv=of} r9, 123456
# CHECK: encoding: [0x62,0xd4,0xc4,0x0d,0x81,0xf9,0x40,0xe2,0x01,0x00]
         ccmpge {dfv=of} r9, 123456
# CHECK: ccmpge {dfv=of} dl, bl
# CHECK: encoding: [0x62,0xf4,0x44,0x0d,0x38,0xda]
         ccmpge {dfv=of} dl, bl
# CHECK: ccmpge {dfv=of} ax, dx
# CHECK: encoding: [0x62,0xf4,0x45,0x0d,0x39,0xd0]
         ccmpge {dfv=of} ax, dx
# CHECK: ccmpge {dfv=of} edx, ecx
# CHECK: encoding: [0x62,0xf4,0x44,0x0d,0x39,0xca]
         ccmpge {dfv=of} edx, ecx
# CHECK: ccmpge {dfv=of} r15, r9
# CHECK: encoding: [0x62,0x54,0xc4,0x0d,0x39,0xcf]
         ccmpge {dfv=of} r15, r9
# CHECK: ccmpg {dfv=of} byte ptr [r8 + 4*rax + 123], 123
# CHECK: encoding: [0x62,0xd4,0x44,0x0f,0x80,0x7c,0x80,0x7b,0x7b]
         ccmpg {dfv=of} byte ptr [r8 + 4*rax + 123], 123
# CHECK: ccmpg {dfv=of} word ptr [r8 + 4*rax + 123], 123
# CHECK: encoding: [0x62,0xd4,0x45,0x0f,0x83,0x7c,0x80,0x7b,0x7b]
         ccmpg {dfv=of} word ptr [r8 + 4*rax + 123], 123
# CHECK: ccmpg {dfv=of} word ptr [r8 + 4*rax + 123], 1234
# CHECK: encoding: [0x62,0xd4,0x45,0x0f,0x81,0x7c,0x80,0x7b,0xd2,0x04]
         ccmpg {dfv=of} word ptr [r8 + 4*rax + 123], 1234
# CHECK: ccmpg {dfv=of} dword ptr [r8 + 4*rax + 123], 123
# CHECK: encoding: [0x62,0xd4,0x44,0x0f,0x83,0x7c,0x80,0x7b,0x7b]
         ccmpg {dfv=of} dword ptr [r8 + 4*rax + 123], 123
# CHECK: ccmpg {dfv=of} dword ptr [r8 + 4*rax + 123], 123456
# CHECK: encoding: [0x62,0xd4,0x44,0x0f,0x81,0x7c,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ccmpg {dfv=of} dword ptr [r8 + 4*rax + 123], 123456
# CHECK: ccmpg {dfv=of} qword ptr [r8 + 4*rax + 123], 123
# CHECK: encoding: [0x62,0xd4,0xc4,0x0f,0x83,0x7c,0x80,0x7b,0x7b]
         ccmpg {dfv=of} qword ptr [r8 + 4*rax + 123], 123
# CHECK: ccmpg {dfv=of} qword ptr [r8 + 4*rax + 123], 123456
# CHECK: encoding: [0x62,0xd4,0xc4,0x0f,0x81,0x7c,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ccmpg {dfv=of} qword ptr [r8 + 4*rax + 123], 123456
# CHECK: ccmpg {dfv=of} byte ptr [r8 + 4*rax + 123], bl
# CHECK: encoding: [0x62,0xd4,0x44,0x0f,0x38,0x5c,0x80,0x7b]
         ccmpg {dfv=of} byte ptr [r8 + 4*rax + 123], bl
# CHECK: ccmpg {dfv=of} word ptr [r8 + 4*rax + 123], dx
# CHECK: encoding: [0x62,0xd4,0x45,0x0f,0x39,0x54,0x80,0x7b]
         ccmpg {dfv=of} word ptr [r8 + 4*rax + 123], dx
# CHECK: ccmpg {dfv=of} dword ptr [r8 + 4*rax + 123], ecx
# CHECK: encoding: [0x62,0xd4,0x44,0x0f,0x39,0x4c,0x80,0x7b]
         ccmpg {dfv=of} dword ptr [r8 + 4*rax + 123], ecx
# CHECK: ccmpg {dfv=of} qword ptr [r8 + 4*rax + 123], r9
# CHECK: encoding: [0x62,0x54,0xc4,0x0f,0x39,0x4c,0x80,0x7b]
         ccmpg {dfv=of} qword ptr [r8 + 4*rax + 123], r9
# CHECK: ccmpg {dfv=of} bl, byte ptr [r8 + 4*rax + 123]
# CHECK: encoding: [0x62,0xd4,0x44,0x0f,0x3a,0x5c,0x80,0x7b]
         ccmpg {dfv=of} bl, byte ptr [r8 + 4*rax + 123]
# CHECK: ccmpg {dfv=of} dx, word ptr [r8 + 4*rax + 123]
# CHECK: encoding: [0x62,0xd4,0x45,0x0f,0x3b,0x54,0x80,0x7b]
         ccmpg {dfv=of} dx, word ptr [r8 + 4*rax + 123]
# CHECK: ccmpg {dfv=of} ecx, dword ptr [r8 + 4*rax + 123]
# CHECK: encoding: [0x62,0xd4,0x44,0x0f,0x3b,0x4c,0x80,0x7b]
         ccmpg {dfv=of} ecx, dword ptr [r8 + 4*rax + 123]
# CHECK: ccmpg {dfv=of} r9, qword ptr [r8 + 4*rax + 123]
# CHECK: encoding: [0x62,0x54,0xc4,0x0f,0x3b,0x4c,0x80,0x7b]
         ccmpg {dfv=of} r9, qword ptr [r8 + 4*rax + 123]
# CHECK: ccmpg {dfv=of} bl, 123
# CHECK: encoding: [0x62,0xf4,0x44,0x0f,0x80,0xfb,0x7b]
         ccmpg {dfv=of} bl, 123
# CHECK: ccmpg {dfv=of} dx, 123
# CHECK: encoding: [0x62,0xf4,0x45,0x0f,0x83,0xfa,0x7b]
         ccmpg {dfv=of} dx, 123
# CHECK: ccmpg {dfv=of} ecx, 123
# CHECK: encoding: [0x62,0xf4,0x44,0x0f,0x83,0xf9,0x7b]
         ccmpg {dfv=of} ecx, 123
# CHECK: ccmpg {dfv=of} r9, 123
# CHECK: encoding: [0x62,0xd4,0xc4,0x0f,0x83,0xf9,0x7b]
         ccmpg {dfv=of} r9, 123
# CHECK: ccmpg {dfv=of} dx, 1234
# CHECK: encoding: [0x62,0xf4,0x45,0x0f,0x81,0xfa,0xd2,0x04]
         ccmpg {dfv=of} dx, 1234
# CHECK: ccmpg {dfv=of} ecx, 123456
# CHECK: encoding: [0x62,0xf4,0x44,0x0f,0x81,0xf9,0x40,0xe2,0x01,0x00]
         ccmpg {dfv=of} ecx, 123456
# CHECK: ccmpg {dfv=of} r9, 123456
# CHECK: encoding: [0x62,0xd4,0xc4,0x0f,0x81,0xf9,0x40,0xe2,0x01,0x00]
         ccmpg {dfv=of} r9, 123456
# CHECK: ccmpg {dfv=of} dl, bl
# CHECK: encoding: [0x62,0xf4,0x44,0x0f,0x38,0xda]
         ccmpg {dfv=of} dl, bl
# CHECK: ccmpg {dfv=of} ax, dx
# CHECK: encoding: [0x62,0xf4,0x45,0x0f,0x39,0xd0]
         ccmpg {dfv=of} ax, dx
# CHECK: ccmpg {dfv=of} edx, ecx
# CHECK: encoding: [0x62,0xf4,0x44,0x0f,0x39,0xca]
         ccmpg {dfv=of} edx, ecx
# CHECK: ccmpg {dfv=of} r15, r9
# CHECK: encoding: [0x62,0x54,0xc4,0x0f,0x39,0xcf]
         ccmpg {dfv=of} r15, r9
# CHECK: ccmpno {dfv=of} byte ptr [r8 + 4*rax + 123], 123
# CHECK: encoding: [0x62,0xd4,0x44,0x01,0x80,0x7c,0x80,0x7b,0x7b]
         ccmpno {dfv=of} byte ptr [r8 + 4*rax + 123], 123
# CHECK: ccmpno {dfv=of} word ptr [r8 + 4*rax + 123], 123
# CHECK: encoding: [0x62,0xd4,0x45,0x01,0x83,0x7c,0x80,0x7b,0x7b]
         ccmpno {dfv=of} word ptr [r8 + 4*rax + 123], 123
# CHECK: ccmpno {dfv=of} word ptr [r8 + 4*rax + 123], 1234
# CHECK: encoding: [0x62,0xd4,0x45,0x01,0x81,0x7c,0x80,0x7b,0xd2,0x04]
         ccmpno {dfv=of} word ptr [r8 + 4*rax + 123], 1234
# CHECK: ccmpno {dfv=of} dword ptr [r8 + 4*rax + 123], 123
# CHECK: encoding: [0x62,0xd4,0x44,0x01,0x83,0x7c,0x80,0x7b,0x7b]
         ccmpno {dfv=of} dword ptr [r8 + 4*rax + 123], 123
# CHECK: ccmpno {dfv=of} dword ptr [r8 + 4*rax + 123], 123456
# CHECK: encoding: [0x62,0xd4,0x44,0x01,0x81,0x7c,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ccmpno {dfv=of} dword ptr [r8 + 4*rax + 123], 123456
# CHECK: ccmpno {dfv=of} qword ptr [r8 + 4*rax + 123], 123
# CHECK: encoding: [0x62,0xd4,0xc4,0x01,0x83,0x7c,0x80,0x7b,0x7b]
         ccmpno {dfv=of} qword ptr [r8 + 4*rax + 123], 123
# CHECK: ccmpno {dfv=of} qword ptr [r8 + 4*rax + 123], 123456
# CHECK: encoding: [0x62,0xd4,0xc4,0x01,0x81,0x7c,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ccmpno {dfv=of} qword ptr [r8 + 4*rax + 123], 123456
# CHECK: ccmpno {dfv=of} byte ptr [r8 + 4*rax + 123], bl
# CHECK: encoding: [0x62,0xd4,0x44,0x01,0x38,0x5c,0x80,0x7b]
         ccmpno {dfv=of} byte ptr [r8 + 4*rax + 123], bl
# CHECK: ccmpno {dfv=of} word ptr [r8 + 4*rax + 123], dx
# CHECK: encoding: [0x62,0xd4,0x45,0x01,0x39,0x54,0x80,0x7b]
         ccmpno {dfv=of} word ptr [r8 + 4*rax + 123], dx
# CHECK: ccmpno {dfv=of} dword ptr [r8 + 4*rax + 123], ecx
# CHECK: encoding: [0x62,0xd4,0x44,0x01,0x39,0x4c,0x80,0x7b]
         ccmpno {dfv=of} dword ptr [r8 + 4*rax + 123], ecx
# CHECK: ccmpno {dfv=of} qword ptr [r8 + 4*rax + 123], r9
# CHECK: encoding: [0x62,0x54,0xc4,0x01,0x39,0x4c,0x80,0x7b]
         ccmpno {dfv=of} qword ptr [r8 + 4*rax + 123], r9
# CHECK: ccmpno {dfv=of} bl, byte ptr [r8 + 4*rax + 123]
# CHECK: encoding: [0x62,0xd4,0x44,0x01,0x3a,0x5c,0x80,0x7b]
         ccmpno {dfv=of} bl, byte ptr [r8 + 4*rax + 123]
# CHECK: ccmpno {dfv=of} dx, word ptr [r8 + 4*rax + 123]
# CHECK: encoding: [0x62,0xd4,0x45,0x01,0x3b,0x54,0x80,0x7b]
         ccmpno {dfv=of} dx, word ptr [r8 + 4*rax + 123]
# CHECK: ccmpno {dfv=of} ecx, dword ptr [r8 + 4*rax + 123]
# CHECK: encoding: [0x62,0xd4,0x44,0x01,0x3b,0x4c,0x80,0x7b]
         ccmpno {dfv=of} ecx, dword ptr [r8 + 4*rax + 123]
# CHECK: ccmpno {dfv=of} r9, qword ptr [r8 + 4*rax + 123]
# CHECK: encoding: [0x62,0x54,0xc4,0x01,0x3b,0x4c,0x80,0x7b]
         ccmpno {dfv=of} r9, qword ptr [r8 + 4*rax + 123]
# CHECK: ccmpno {dfv=of} bl, 123
# CHECK: encoding: [0x62,0xf4,0x44,0x01,0x80,0xfb,0x7b]
         ccmpno {dfv=of} bl, 123
# CHECK: ccmpno {dfv=of} dx, 123
# CHECK: encoding: [0x62,0xf4,0x45,0x01,0x83,0xfa,0x7b]
         ccmpno {dfv=of} dx, 123
# CHECK: ccmpno {dfv=of} ecx, 123
# CHECK: encoding: [0x62,0xf4,0x44,0x01,0x83,0xf9,0x7b]
         ccmpno {dfv=of} ecx, 123
# CHECK: ccmpno {dfv=of} r9, 123
# CHECK: encoding: [0x62,0xd4,0xc4,0x01,0x83,0xf9,0x7b]
         ccmpno {dfv=of} r9, 123
# CHECK: ccmpno {dfv=of} dx, 1234
# CHECK: encoding: [0x62,0xf4,0x45,0x01,0x81,0xfa,0xd2,0x04]
         ccmpno {dfv=of} dx, 1234
# CHECK: ccmpno {dfv=of} ecx, 123456
# CHECK: encoding: [0x62,0xf4,0x44,0x01,0x81,0xf9,0x40,0xe2,0x01,0x00]
         ccmpno {dfv=of} ecx, 123456
# CHECK: ccmpno {dfv=of} r9, 123456
# CHECK: encoding: [0x62,0xd4,0xc4,0x01,0x81,0xf9,0x40,0xe2,0x01,0x00]
         ccmpno {dfv=of} r9, 123456
# CHECK: ccmpno {dfv=of} dl, bl
# CHECK: encoding: [0x62,0xf4,0x44,0x01,0x38,0xda]
         ccmpno {dfv=of} dl, bl
# CHECK: ccmpno {dfv=of} ax, dx
# CHECK: encoding: [0x62,0xf4,0x45,0x01,0x39,0xd0]
         ccmpno {dfv=of} ax, dx
# CHECK: ccmpno {dfv=of} edx, ecx
# CHECK: encoding: [0x62,0xf4,0x44,0x01,0x39,0xca]
         ccmpno {dfv=of} edx, ecx
# CHECK: ccmpno {dfv=of} r15, r9
# CHECK: encoding: [0x62,0x54,0xc4,0x01,0x39,0xcf]
         ccmpno {dfv=of} r15, r9
# CHECK: ccmpns {dfv=of} byte ptr [r8 + 4*rax + 123], 123
# CHECK: encoding: [0x62,0xd4,0x44,0x09,0x80,0x7c,0x80,0x7b,0x7b]
         ccmpns {dfv=of} byte ptr [r8 + 4*rax + 123], 123
# CHECK: ccmpns {dfv=of} word ptr [r8 + 4*rax + 123], 123
# CHECK: encoding: [0x62,0xd4,0x45,0x09,0x83,0x7c,0x80,0x7b,0x7b]
         ccmpns {dfv=of} word ptr [r8 + 4*rax + 123], 123
# CHECK: ccmpns {dfv=of} word ptr [r8 + 4*rax + 123], 1234
# CHECK: encoding: [0x62,0xd4,0x45,0x09,0x81,0x7c,0x80,0x7b,0xd2,0x04]
         ccmpns {dfv=of} word ptr [r8 + 4*rax + 123], 1234
# CHECK: ccmpns {dfv=of} dword ptr [r8 + 4*rax + 123], 123
# CHECK: encoding: [0x62,0xd4,0x44,0x09,0x83,0x7c,0x80,0x7b,0x7b]
         ccmpns {dfv=of} dword ptr [r8 + 4*rax + 123], 123
# CHECK: ccmpns {dfv=of} dword ptr [r8 + 4*rax + 123], 123456
# CHECK: encoding: [0x62,0xd4,0x44,0x09,0x81,0x7c,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ccmpns {dfv=of} dword ptr [r8 + 4*rax + 123], 123456
# CHECK: ccmpns {dfv=of} qword ptr [r8 + 4*rax + 123], 123
# CHECK: encoding: [0x62,0xd4,0xc4,0x09,0x83,0x7c,0x80,0x7b,0x7b]
         ccmpns {dfv=of} qword ptr [r8 + 4*rax + 123], 123
# CHECK: ccmpns {dfv=of} qword ptr [r8 + 4*rax + 123], 123456
# CHECK: encoding: [0x62,0xd4,0xc4,0x09,0x81,0x7c,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ccmpns {dfv=of} qword ptr [r8 + 4*rax + 123], 123456
# CHECK: ccmpns {dfv=of} byte ptr [r8 + 4*rax + 123], bl
# CHECK: encoding: [0x62,0xd4,0x44,0x09,0x38,0x5c,0x80,0x7b]
         ccmpns {dfv=of} byte ptr [r8 + 4*rax + 123], bl
# CHECK: ccmpns {dfv=of} word ptr [r8 + 4*rax + 123], dx
# CHECK: encoding: [0x62,0xd4,0x45,0x09,0x39,0x54,0x80,0x7b]
         ccmpns {dfv=of} word ptr [r8 + 4*rax + 123], dx
# CHECK: ccmpns {dfv=of} dword ptr [r8 + 4*rax + 123], ecx
# CHECK: encoding: [0x62,0xd4,0x44,0x09,0x39,0x4c,0x80,0x7b]
         ccmpns {dfv=of} dword ptr [r8 + 4*rax + 123], ecx
# CHECK: ccmpns {dfv=of} qword ptr [r8 + 4*rax + 123], r9
# CHECK: encoding: [0x62,0x54,0xc4,0x09,0x39,0x4c,0x80,0x7b]
         ccmpns {dfv=of} qword ptr [r8 + 4*rax + 123], r9
# CHECK: ccmpns {dfv=of} bl, byte ptr [r8 + 4*rax + 123]
# CHECK: encoding: [0x62,0xd4,0x44,0x09,0x3a,0x5c,0x80,0x7b]
         ccmpns {dfv=of} bl, byte ptr [r8 + 4*rax + 123]
# CHECK: ccmpns {dfv=of} dx, word ptr [r8 + 4*rax + 123]
# CHECK: encoding: [0x62,0xd4,0x45,0x09,0x3b,0x54,0x80,0x7b]
         ccmpns {dfv=of} dx, word ptr [r8 + 4*rax + 123]
# CHECK: ccmpns {dfv=of} ecx, dword ptr [r8 + 4*rax + 123]
# CHECK: encoding: [0x62,0xd4,0x44,0x09,0x3b,0x4c,0x80,0x7b]
         ccmpns {dfv=of} ecx, dword ptr [r8 + 4*rax + 123]
# CHECK: ccmpns {dfv=of} r9, qword ptr [r8 + 4*rax + 123]
# CHECK: encoding: [0x62,0x54,0xc4,0x09,0x3b,0x4c,0x80,0x7b]
         ccmpns {dfv=of} r9, qword ptr [r8 + 4*rax + 123]
# CHECK: ccmpns {dfv=of} bl, 123
# CHECK: encoding: [0x62,0xf4,0x44,0x09,0x80,0xfb,0x7b]
         ccmpns {dfv=of} bl, 123
# CHECK: ccmpns {dfv=of} dx, 123
# CHECK: encoding: [0x62,0xf4,0x45,0x09,0x83,0xfa,0x7b]
         ccmpns {dfv=of} dx, 123
# CHECK: ccmpns {dfv=of} ecx, 123
# CHECK: encoding: [0x62,0xf4,0x44,0x09,0x83,0xf9,0x7b]
         ccmpns {dfv=of} ecx, 123
# CHECK: ccmpns {dfv=of} r9, 123
# CHECK: encoding: [0x62,0xd4,0xc4,0x09,0x83,0xf9,0x7b]
         ccmpns {dfv=of} r9, 123
# CHECK: ccmpns {dfv=of} dx, 1234
# CHECK: encoding: [0x62,0xf4,0x45,0x09,0x81,0xfa,0xd2,0x04]
         ccmpns {dfv=of} dx, 1234
# CHECK: ccmpns {dfv=of} ecx, 123456
# CHECK: encoding: [0x62,0xf4,0x44,0x09,0x81,0xf9,0x40,0xe2,0x01,0x00]
         ccmpns {dfv=of} ecx, 123456
# CHECK: ccmpns {dfv=of} r9, 123456
# CHECK: encoding: [0x62,0xd4,0xc4,0x09,0x81,0xf9,0x40,0xe2,0x01,0x00]
         ccmpns {dfv=of} r9, 123456
# CHECK: ccmpns {dfv=of} dl, bl
# CHECK: encoding: [0x62,0xf4,0x44,0x09,0x38,0xda]
         ccmpns {dfv=of} dl, bl
# CHECK: ccmpns {dfv=of} ax, dx
# CHECK: encoding: [0x62,0xf4,0x45,0x09,0x39,0xd0]
         ccmpns {dfv=of} ax, dx
# CHECK: ccmpns {dfv=of} edx, ecx
# CHECK: encoding: [0x62,0xf4,0x44,0x09,0x39,0xca]
         ccmpns {dfv=of} edx, ecx
# CHECK: ccmpns {dfv=of} r15, r9
# CHECK: encoding: [0x62,0x54,0xc4,0x09,0x39,0xcf]
         ccmpns {dfv=of} r15, r9
# CHECK: ccmpne {dfv=of} byte ptr [r8 + 4*rax + 123], 123
# CHECK: encoding: [0x62,0xd4,0x44,0x05,0x80,0x7c,0x80,0x7b,0x7b]
         ccmpne {dfv=of} byte ptr [r8 + 4*rax + 123], 123
# CHECK: ccmpne {dfv=of} word ptr [r8 + 4*rax + 123], 123
# CHECK: encoding: [0x62,0xd4,0x45,0x05,0x83,0x7c,0x80,0x7b,0x7b]
         ccmpne {dfv=of} word ptr [r8 + 4*rax + 123], 123
# CHECK: ccmpne {dfv=of} word ptr [r8 + 4*rax + 123], 1234
# CHECK: encoding: [0x62,0xd4,0x45,0x05,0x81,0x7c,0x80,0x7b,0xd2,0x04]
         ccmpne {dfv=of} word ptr [r8 + 4*rax + 123], 1234
# CHECK: ccmpne {dfv=of} dword ptr [r8 + 4*rax + 123], 123
# CHECK: encoding: [0x62,0xd4,0x44,0x05,0x83,0x7c,0x80,0x7b,0x7b]
         ccmpne {dfv=of} dword ptr [r8 + 4*rax + 123], 123
# CHECK: ccmpne {dfv=of} dword ptr [r8 + 4*rax + 123], 123456
# CHECK: encoding: [0x62,0xd4,0x44,0x05,0x81,0x7c,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ccmpne {dfv=of} dword ptr [r8 + 4*rax + 123], 123456
# CHECK: ccmpne {dfv=of} qword ptr [r8 + 4*rax + 123], 123
# CHECK: encoding: [0x62,0xd4,0xc4,0x05,0x83,0x7c,0x80,0x7b,0x7b]
         ccmpne {dfv=of} qword ptr [r8 + 4*rax + 123], 123
# CHECK: ccmpne {dfv=of} qword ptr [r8 + 4*rax + 123], 123456
# CHECK: encoding: [0x62,0xd4,0xc4,0x05,0x81,0x7c,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ccmpne {dfv=of} qword ptr [r8 + 4*rax + 123], 123456
# CHECK: ccmpne {dfv=of} byte ptr [r8 + 4*rax + 123], bl
# CHECK: encoding: [0x62,0xd4,0x44,0x05,0x38,0x5c,0x80,0x7b]
         ccmpne {dfv=of} byte ptr [r8 + 4*rax + 123], bl
# CHECK: ccmpne {dfv=of} word ptr [r8 + 4*rax + 123], dx
# CHECK: encoding: [0x62,0xd4,0x45,0x05,0x39,0x54,0x80,0x7b]
         ccmpne {dfv=of} word ptr [r8 + 4*rax + 123], dx
# CHECK: ccmpne {dfv=of} dword ptr [r8 + 4*rax + 123], ecx
# CHECK: encoding: [0x62,0xd4,0x44,0x05,0x39,0x4c,0x80,0x7b]
         ccmpne {dfv=of} dword ptr [r8 + 4*rax + 123], ecx
# CHECK: ccmpne {dfv=of} qword ptr [r8 + 4*rax + 123], r9
# CHECK: encoding: [0x62,0x54,0xc4,0x05,0x39,0x4c,0x80,0x7b]
         ccmpne {dfv=of} qword ptr [r8 + 4*rax + 123], r9
# CHECK: ccmpne {dfv=of} bl, byte ptr [r8 + 4*rax + 123]
# CHECK: encoding: [0x62,0xd4,0x44,0x05,0x3a,0x5c,0x80,0x7b]
         ccmpne {dfv=of} bl, byte ptr [r8 + 4*rax + 123]
# CHECK: ccmpne {dfv=of} dx, word ptr [r8 + 4*rax + 123]
# CHECK: encoding: [0x62,0xd4,0x45,0x05,0x3b,0x54,0x80,0x7b]
         ccmpne {dfv=of} dx, word ptr [r8 + 4*rax + 123]
# CHECK: ccmpne {dfv=of} ecx, dword ptr [r8 + 4*rax + 123]
# CHECK: encoding: [0x62,0xd4,0x44,0x05,0x3b,0x4c,0x80,0x7b]
         ccmpne {dfv=of} ecx, dword ptr [r8 + 4*rax + 123]
# CHECK: ccmpne {dfv=of} r9, qword ptr [r8 + 4*rax + 123]
# CHECK: encoding: [0x62,0x54,0xc4,0x05,0x3b,0x4c,0x80,0x7b]
         ccmpne {dfv=of} r9, qword ptr [r8 + 4*rax + 123]
# CHECK: ccmpne {dfv=of} bl, 123
# CHECK: encoding: [0x62,0xf4,0x44,0x05,0x80,0xfb,0x7b]
         ccmpne {dfv=of} bl, 123
# CHECK: ccmpne {dfv=of} dx, 123
# CHECK: encoding: [0x62,0xf4,0x45,0x05,0x83,0xfa,0x7b]
         ccmpne {dfv=of} dx, 123
# CHECK: ccmpne {dfv=of} ecx, 123
# CHECK: encoding: [0x62,0xf4,0x44,0x05,0x83,0xf9,0x7b]
         ccmpne {dfv=of} ecx, 123
# CHECK: ccmpne {dfv=of} r9, 123
# CHECK: encoding: [0x62,0xd4,0xc4,0x05,0x83,0xf9,0x7b]
         ccmpne {dfv=of} r9, 123
# CHECK: ccmpne {dfv=of} dx, 1234
# CHECK: encoding: [0x62,0xf4,0x45,0x05,0x81,0xfa,0xd2,0x04]
         ccmpne {dfv=of} dx, 1234
# CHECK: ccmpne {dfv=of} ecx, 123456
# CHECK: encoding: [0x62,0xf4,0x44,0x05,0x81,0xf9,0x40,0xe2,0x01,0x00]
         ccmpne {dfv=of} ecx, 123456
# CHECK: ccmpne {dfv=of} r9, 123456
# CHECK: encoding: [0x62,0xd4,0xc4,0x05,0x81,0xf9,0x40,0xe2,0x01,0x00]
         ccmpne {dfv=of} r9, 123456
# CHECK: ccmpne {dfv=of} dl, bl
# CHECK: encoding: [0x62,0xf4,0x44,0x05,0x38,0xda]
         ccmpne {dfv=of} dl, bl
# CHECK: ccmpne {dfv=of} ax, dx
# CHECK: encoding: [0x62,0xf4,0x45,0x05,0x39,0xd0]
         ccmpne {dfv=of} ax, dx
# CHECK: ccmpne {dfv=of} edx, ecx
# CHECK: encoding: [0x62,0xf4,0x44,0x05,0x39,0xca]
         ccmpne {dfv=of} edx, ecx
# CHECK: ccmpne {dfv=of} r15, r9
# CHECK: encoding: [0x62,0x54,0xc4,0x05,0x39,0xcf]
         ccmpne {dfv=of} r15, r9
# CHECK: ccmpo {dfv=of} byte ptr [r8 + 4*rax + 123], 123
# CHECK: encoding: [0x62,0xd4,0x44,0x00,0x80,0x7c,0x80,0x7b,0x7b]
         ccmpo {dfv=of} byte ptr [r8 + 4*rax + 123], 123
# CHECK: ccmpo {dfv=of} word ptr [r8 + 4*rax + 123], 123
# CHECK: encoding: [0x62,0xd4,0x45,0x00,0x83,0x7c,0x80,0x7b,0x7b]
         ccmpo {dfv=of} word ptr [r8 + 4*rax + 123], 123
# CHECK: ccmpo {dfv=of} word ptr [r8 + 4*rax + 123], 1234
# CHECK: encoding: [0x62,0xd4,0x45,0x00,0x81,0x7c,0x80,0x7b,0xd2,0x04]
         ccmpo {dfv=of} word ptr [r8 + 4*rax + 123], 1234
# CHECK: ccmpo {dfv=of} dword ptr [r8 + 4*rax + 123], 123
# CHECK: encoding: [0x62,0xd4,0x44,0x00,0x83,0x7c,0x80,0x7b,0x7b]
         ccmpo {dfv=of} dword ptr [r8 + 4*rax + 123], 123
# CHECK: ccmpo {dfv=of} dword ptr [r8 + 4*rax + 123], 123456
# CHECK: encoding: [0x62,0xd4,0x44,0x00,0x81,0x7c,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ccmpo {dfv=of} dword ptr [r8 + 4*rax + 123], 123456
# CHECK: ccmpo {dfv=of} qword ptr [r8 + 4*rax + 123], 123
# CHECK: encoding: [0x62,0xd4,0xc4,0x00,0x83,0x7c,0x80,0x7b,0x7b]
         ccmpo {dfv=of} qword ptr [r8 + 4*rax + 123], 123
# CHECK: ccmpo {dfv=of} qword ptr [r8 + 4*rax + 123], 123456
# CHECK: encoding: [0x62,0xd4,0xc4,0x00,0x81,0x7c,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ccmpo {dfv=of} qword ptr [r8 + 4*rax + 123], 123456
# CHECK: ccmpo {dfv=of} byte ptr [r8 + 4*rax + 123], bl
# CHECK: encoding: [0x62,0xd4,0x44,0x00,0x38,0x5c,0x80,0x7b]
         ccmpo {dfv=of} byte ptr [r8 + 4*rax + 123], bl
# CHECK: ccmpo {dfv=of} word ptr [r8 + 4*rax + 123], dx
# CHECK: encoding: [0x62,0xd4,0x45,0x00,0x39,0x54,0x80,0x7b]
         ccmpo {dfv=of} word ptr [r8 + 4*rax + 123], dx
# CHECK: ccmpo {dfv=of} dword ptr [r8 + 4*rax + 123], ecx
# CHECK: encoding: [0x62,0xd4,0x44,0x00,0x39,0x4c,0x80,0x7b]
         ccmpo {dfv=of} dword ptr [r8 + 4*rax + 123], ecx
# CHECK: ccmpo {dfv=of} qword ptr [r8 + 4*rax + 123], r9
# CHECK: encoding: [0x62,0x54,0xc4,0x00,0x39,0x4c,0x80,0x7b]
         ccmpo {dfv=of} qword ptr [r8 + 4*rax + 123], r9
# CHECK: ccmpo {dfv=of} bl, byte ptr [r8 + 4*rax + 123]
# CHECK: encoding: [0x62,0xd4,0x44,0x00,0x3a,0x5c,0x80,0x7b]
         ccmpo {dfv=of} bl, byte ptr [r8 + 4*rax + 123]
# CHECK: ccmpo {dfv=of} dx, word ptr [r8 + 4*rax + 123]
# CHECK: encoding: [0x62,0xd4,0x45,0x00,0x3b,0x54,0x80,0x7b]
         ccmpo {dfv=of} dx, word ptr [r8 + 4*rax + 123]
# CHECK: ccmpo {dfv=of} ecx, dword ptr [r8 + 4*rax + 123]
# CHECK: encoding: [0x62,0xd4,0x44,0x00,0x3b,0x4c,0x80,0x7b]
         ccmpo {dfv=of} ecx, dword ptr [r8 + 4*rax + 123]
# CHECK: ccmpo {dfv=of} r9, qword ptr [r8 + 4*rax + 123]
# CHECK: encoding: [0x62,0x54,0xc4,0x00,0x3b,0x4c,0x80,0x7b]
         ccmpo {dfv=of} r9, qword ptr [r8 + 4*rax + 123]
# CHECK: ccmpo {dfv=of} bl, 123
# CHECK: encoding: [0x62,0xf4,0x44,0x00,0x80,0xfb,0x7b]
         ccmpo {dfv=of} bl, 123
# CHECK: ccmpo {dfv=of} dx, 123
# CHECK: encoding: [0x62,0xf4,0x45,0x00,0x83,0xfa,0x7b]
         ccmpo {dfv=of} dx, 123
# CHECK: ccmpo {dfv=of} ecx, 123
# CHECK: encoding: [0x62,0xf4,0x44,0x00,0x83,0xf9,0x7b]
         ccmpo {dfv=of} ecx, 123
# CHECK: ccmpo {dfv=of} r9, 123
# CHECK: encoding: [0x62,0xd4,0xc4,0x00,0x83,0xf9,0x7b]
         ccmpo {dfv=of} r9, 123
# CHECK: ccmpo {dfv=of} dx, 1234
# CHECK: encoding: [0x62,0xf4,0x45,0x00,0x81,0xfa,0xd2,0x04]
         ccmpo {dfv=of} dx, 1234
# CHECK: ccmpo {dfv=of} ecx, 123456
# CHECK: encoding: [0x62,0xf4,0x44,0x00,0x81,0xf9,0x40,0xe2,0x01,0x00]
         ccmpo {dfv=of} ecx, 123456
# CHECK: ccmpo {dfv=of} r9, 123456
# CHECK: encoding: [0x62,0xd4,0xc4,0x00,0x81,0xf9,0x40,0xe2,0x01,0x00]
         ccmpo {dfv=of} r9, 123456
# CHECK: ccmpo {dfv=of} dl, bl
# CHECK: encoding: [0x62,0xf4,0x44,0x00,0x38,0xda]
         ccmpo {dfv=of} dl, bl
# CHECK: ccmpo {dfv=of} ax, dx
# CHECK: encoding: [0x62,0xf4,0x45,0x00,0x39,0xd0]
         ccmpo {dfv=of} ax, dx
# CHECK: ccmpo {dfv=of} edx, ecx
# CHECK: encoding: [0x62,0xf4,0x44,0x00,0x39,0xca]
         ccmpo {dfv=of} edx, ecx
# CHECK: ccmpo {dfv=of} r15, r9
# CHECK: encoding: [0x62,0x54,0xc4,0x00,0x39,0xcf]
         ccmpo {dfv=of} r15, r9
# CHECK: ccmps {dfv=of} byte ptr [r8 + 4*rax + 123], 123
# CHECK: encoding: [0x62,0xd4,0x44,0x08,0x80,0x7c,0x80,0x7b,0x7b]
         ccmps {dfv=of} byte ptr [r8 + 4*rax + 123], 123
# CHECK: ccmps {dfv=of} word ptr [r8 + 4*rax + 123], 123
# CHECK: encoding: [0x62,0xd4,0x45,0x08,0x83,0x7c,0x80,0x7b,0x7b]
         ccmps {dfv=of} word ptr [r8 + 4*rax + 123], 123
# CHECK: ccmps {dfv=of} word ptr [r8 + 4*rax + 123], 1234
# CHECK: encoding: [0x62,0xd4,0x45,0x08,0x81,0x7c,0x80,0x7b,0xd2,0x04]
         ccmps {dfv=of} word ptr [r8 + 4*rax + 123], 1234
# CHECK: ccmps {dfv=of} dword ptr [r8 + 4*rax + 123], 123
# CHECK: encoding: [0x62,0xd4,0x44,0x08,0x83,0x7c,0x80,0x7b,0x7b]
         ccmps {dfv=of} dword ptr [r8 + 4*rax + 123], 123
# CHECK: ccmps {dfv=of} dword ptr [r8 + 4*rax + 123], 123456
# CHECK: encoding: [0x62,0xd4,0x44,0x08,0x81,0x7c,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ccmps {dfv=of} dword ptr [r8 + 4*rax + 123], 123456
# CHECK: ccmps {dfv=of} qword ptr [r8 + 4*rax + 123], 123
# CHECK: encoding: [0x62,0xd4,0xc4,0x08,0x83,0x7c,0x80,0x7b,0x7b]
         ccmps {dfv=of} qword ptr [r8 + 4*rax + 123], 123
# CHECK: ccmps {dfv=of} qword ptr [r8 + 4*rax + 123], 123456
# CHECK: encoding: [0x62,0xd4,0xc4,0x08,0x81,0x7c,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ccmps {dfv=of} qword ptr [r8 + 4*rax + 123], 123456
# CHECK: ccmps {dfv=of} byte ptr [r8 + 4*rax + 123], bl
# CHECK: encoding: [0x62,0xd4,0x44,0x08,0x38,0x5c,0x80,0x7b]
         ccmps {dfv=of} byte ptr [r8 + 4*rax + 123], bl
# CHECK: ccmps {dfv=of} word ptr [r8 + 4*rax + 123], dx
# CHECK: encoding: [0x62,0xd4,0x45,0x08,0x39,0x54,0x80,0x7b]
         ccmps {dfv=of} word ptr [r8 + 4*rax + 123], dx
# CHECK: ccmps {dfv=of} dword ptr [r8 + 4*rax + 123], ecx
# CHECK: encoding: [0x62,0xd4,0x44,0x08,0x39,0x4c,0x80,0x7b]
         ccmps {dfv=of} dword ptr [r8 + 4*rax + 123], ecx
# CHECK: ccmps {dfv=of} qword ptr [r8 + 4*rax + 123], r9
# CHECK: encoding: [0x62,0x54,0xc4,0x08,0x39,0x4c,0x80,0x7b]
         ccmps {dfv=of} qword ptr [r8 + 4*rax + 123], r9
# CHECK: ccmps {dfv=of} bl, byte ptr [r8 + 4*rax + 123]
# CHECK: encoding: [0x62,0xd4,0x44,0x08,0x3a,0x5c,0x80,0x7b]
         ccmps {dfv=of} bl, byte ptr [r8 + 4*rax + 123]
# CHECK: ccmps {dfv=of} dx, word ptr [r8 + 4*rax + 123]
# CHECK: encoding: [0x62,0xd4,0x45,0x08,0x3b,0x54,0x80,0x7b]
         ccmps {dfv=of} dx, word ptr [r8 + 4*rax + 123]
# CHECK: ccmps {dfv=of} ecx, dword ptr [r8 + 4*rax + 123]
# CHECK: encoding: [0x62,0xd4,0x44,0x08,0x3b,0x4c,0x80,0x7b]
         ccmps {dfv=of} ecx, dword ptr [r8 + 4*rax + 123]
# CHECK: ccmps {dfv=of} r9, qword ptr [r8 + 4*rax + 123]
# CHECK: encoding: [0x62,0x54,0xc4,0x08,0x3b,0x4c,0x80,0x7b]
         ccmps {dfv=of} r9, qword ptr [r8 + 4*rax + 123]
# CHECK: ccmps {dfv=of} bl, 123
# CHECK: encoding: [0x62,0xf4,0x44,0x08,0x80,0xfb,0x7b]
         ccmps {dfv=of} bl, 123
# CHECK: ccmps {dfv=of} dx, 123
# CHECK: encoding: [0x62,0xf4,0x45,0x08,0x83,0xfa,0x7b]
         ccmps {dfv=of} dx, 123
# CHECK: ccmps {dfv=of} ecx, 123
# CHECK: encoding: [0x62,0xf4,0x44,0x08,0x83,0xf9,0x7b]
         ccmps {dfv=of} ecx, 123
# CHECK: ccmps {dfv=of} r9, 123
# CHECK: encoding: [0x62,0xd4,0xc4,0x08,0x83,0xf9,0x7b]
         ccmps {dfv=of} r9, 123
# CHECK: ccmps {dfv=of} dx, 1234
# CHECK: encoding: [0x62,0xf4,0x45,0x08,0x81,0xfa,0xd2,0x04]
         ccmps {dfv=of} dx, 1234
# CHECK: ccmps {dfv=of} ecx, 123456
# CHECK: encoding: [0x62,0xf4,0x44,0x08,0x81,0xf9,0x40,0xe2,0x01,0x00]
         ccmps {dfv=of} ecx, 123456
# CHECK: ccmps {dfv=of} r9, 123456
# CHECK: encoding: [0x62,0xd4,0xc4,0x08,0x81,0xf9,0x40,0xe2,0x01,0x00]
         ccmps {dfv=of} r9, 123456
# CHECK: ccmps {dfv=of} dl, bl
# CHECK: encoding: [0x62,0xf4,0x44,0x08,0x38,0xda]
         ccmps {dfv=of} dl, bl
# CHECK: ccmps {dfv=of} ax, dx
# CHECK: encoding: [0x62,0xf4,0x45,0x08,0x39,0xd0]
         ccmps {dfv=of} ax, dx
# CHECK: ccmps {dfv=of} edx, ecx
# CHECK: encoding: [0x62,0xf4,0x44,0x08,0x39,0xca]
         ccmps {dfv=of} edx, ecx
# CHECK: ccmps {dfv=of} r15, r9
# CHECK: encoding: [0x62,0x54,0xc4,0x08,0x39,0xcf]
         ccmps {dfv=of} r15, r9
# CHECK: ccmpt {dfv=of} byte ptr [r8 + 4*rax + 123], 123
# CHECK: encoding: [0x62,0xd4,0x44,0x0a,0x80,0x7c,0x80,0x7b,0x7b]
         ccmpt {dfv=of} byte ptr [r8 + 4*rax + 123], 123
# CHECK: ccmpt {dfv=of} word ptr [r8 + 4*rax + 123], 123
# CHECK: encoding: [0x62,0xd4,0x45,0x0a,0x83,0x7c,0x80,0x7b,0x7b]
         ccmpt {dfv=of} word ptr [r8 + 4*rax + 123], 123
# CHECK: ccmpt {dfv=of} word ptr [r8 + 4*rax + 123], 1234
# CHECK: encoding: [0x62,0xd4,0x45,0x0a,0x81,0x7c,0x80,0x7b,0xd2,0x04]
         ccmpt {dfv=of} word ptr [r8 + 4*rax + 123], 1234
# CHECK: ccmpt {dfv=of} dword ptr [r8 + 4*rax + 123], 123
# CHECK: encoding: [0x62,0xd4,0x44,0x0a,0x83,0x7c,0x80,0x7b,0x7b]
         ccmpt {dfv=of} dword ptr [r8 + 4*rax + 123], 123
# CHECK: ccmpt {dfv=of} dword ptr [r8 + 4*rax + 123], 123456
# CHECK: encoding: [0x62,0xd4,0x44,0x0a,0x81,0x7c,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ccmpt {dfv=of} dword ptr [r8 + 4*rax + 123], 123456
# CHECK: ccmpt {dfv=of} qword ptr [r8 + 4*rax + 123], 123
# CHECK: encoding: [0x62,0xd4,0xc4,0x0a,0x83,0x7c,0x80,0x7b,0x7b]
         ccmpt {dfv=of} qword ptr [r8 + 4*rax + 123], 123
# CHECK: ccmpt {dfv=of} qword ptr [r8 + 4*rax + 123], 123456
# CHECK: encoding: [0x62,0xd4,0xc4,0x0a,0x81,0x7c,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ccmpt {dfv=of} qword ptr [r8 + 4*rax + 123], 123456
# CHECK: ccmpt {dfv=of} byte ptr [r8 + 4*rax + 123], bl
# CHECK: encoding: [0x62,0xd4,0x44,0x0a,0x38,0x5c,0x80,0x7b]
         ccmpt {dfv=of} byte ptr [r8 + 4*rax + 123], bl
# CHECK: ccmpt {dfv=of} word ptr [r8 + 4*rax + 123], dx
# CHECK: encoding: [0x62,0xd4,0x45,0x0a,0x39,0x54,0x80,0x7b]
         ccmpt {dfv=of} word ptr [r8 + 4*rax + 123], dx
# CHECK: ccmpt {dfv=of} dword ptr [r8 + 4*rax + 123], ecx
# CHECK: encoding: [0x62,0xd4,0x44,0x0a,0x39,0x4c,0x80,0x7b]
         ccmpt {dfv=of} dword ptr [r8 + 4*rax + 123], ecx
# CHECK: ccmpt {dfv=of} qword ptr [r8 + 4*rax + 123], r9
# CHECK: encoding: [0x62,0x54,0xc4,0x0a,0x39,0x4c,0x80,0x7b]
         ccmpt {dfv=of} qword ptr [r8 + 4*rax + 123], r9
# CHECK: ccmpt {dfv=of} bl, byte ptr [r8 + 4*rax + 123]
# CHECK: encoding: [0x62,0xd4,0x44,0x0a,0x3a,0x5c,0x80,0x7b]
         ccmpt {dfv=of} bl, byte ptr [r8 + 4*rax + 123]
# CHECK: ccmpt {dfv=of} dx, word ptr [r8 + 4*rax + 123]
# CHECK: encoding: [0x62,0xd4,0x45,0x0a,0x3b,0x54,0x80,0x7b]
         ccmpt {dfv=of} dx, word ptr [r8 + 4*rax + 123]
# CHECK: ccmpt {dfv=of} ecx, dword ptr [r8 + 4*rax + 123]
# CHECK: encoding: [0x62,0xd4,0x44,0x0a,0x3b,0x4c,0x80,0x7b]
         ccmpt {dfv=of} ecx, dword ptr [r8 + 4*rax + 123]
# CHECK: ccmpt {dfv=of} r9, qword ptr [r8 + 4*rax + 123]
# CHECK: encoding: [0x62,0x54,0xc4,0x0a,0x3b,0x4c,0x80,0x7b]
         ccmpt {dfv=of} r9, qword ptr [r8 + 4*rax + 123]
# CHECK: ccmpt {dfv=of} bl, 123
# CHECK: encoding: [0x62,0xf4,0x44,0x0a,0x80,0xfb,0x7b]
         ccmpt {dfv=of} bl, 123
# CHECK: ccmpt {dfv=of} dx, 123
# CHECK: encoding: [0x62,0xf4,0x45,0x0a,0x83,0xfa,0x7b]
         ccmpt {dfv=of} dx, 123
# CHECK: ccmpt {dfv=of} ecx, 123
# CHECK: encoding: [0x62,0xf4,0x44,0x0a,0x83,0xf9,0x7b]
         ccmpt {dfv=of} ecx, 123
# CHECK: ccmpt {dfv=of} r9, 123
# CHECK: encoding: [0x62,0xd4,0xc4,0x0a,0x83,0xf9,0x7b]
         ccmpt {dfv=of} r9, 123
# CHECK: ccmpt {dfv=of} dx, 1234
# CHECK: encoding: [0x62,0xf4,0x45,0x0a,0x81,0xfa,0xd2,0x04]
         ccmpt {dfv=of} dx, 1234
# CHECK: ccmpt {dfv=of} ecx, 123456
# CHECK: encoding: [0x62,0xf4,0x44,0x0a,0x81,0xf9,0x40,0xe2,0x01,0x00]
         ccmpt {dfv=of} ecx, 123456
# CHECK: ccmpt {dfv=of} r9, 123456
# CHECK: encoding: [0x62,0xd4,0xc4,0x0a,0x81,0xf9,0x40,0xe2,0x01,0x00]
         ccmpt {dfv=of} r9, 123456
# CHECK: ccmpt {dfv=of} dl, bl
# CHECK: encoding: [0x62,0xf4,0x44,0x0a,0x38,0xda]
         ccmpt {dfv=of} dl, bl
# CHECK: ccmpt {dfv=of} ax, dx
# CHECK: encoding: [0x62,0xf4,0x45,0x0a,0x39,0xd0]
         ccmpt {dfv=of} ax, dx
# CHECK: ccmpt {dfv=of} edx, ecx
# CHECK: encoding: [0x62,0xf4,0x44,0x0a,0x39,0xca]
         ccmpt {dfv=of} edx, ecx
# CHECK: ccmpt {dfv=of} r15, r9
# CHECK: encoding: [0x62,0x54,0xc4,0x0a,0x39,0xcf]
         ccmpt {dfv=of} r15, r9
# CHECK: ccmpe {dfv=of} byte ptr [r8 + 4*rax + 123], 123
# CHECK: encoding: [0x62,0xd4,0x44,0x04,0x80,0x7c,0x80,0x7b,0x7b]
         ccmpe {dfv=of} byte ptr [r8 + 4*rax + 123], 123
# CHECK: ccmpe {dfv=of} word ptr [r8 + 4*rax + 123], 123
# CHECK: encoding: [0x62,0xd4,0x45,0x04,0x83,0x7c,0x80,0x7b,0x7b]
         ccmpe {dfv=of} word ptr [r8 + 4*rax + 123], 123
# CHECK: ccmpe {dfv=of} word ptr [r8 + 4*rax + 123], 1234
# CHECK: encoding: [0x62,0xd4,0x45,0x04,0x81,0x7c,0x80,0x7b,0xd2,0x04]
         ccmpe {dfv=of} word ptr [r8 + 4*rax + 123], 1234
# CHECK: ccmpe {dfv=of} dword ptr [r8 + 4*rax + 123], 123
# CHECK: encoding: [0x62,0xd4,0x44,0x04,0x83,0x7c,0x80,0x7b,0x7b]
         ccmpe {dfv=of} dword ptr [r8 + 4*rax + 123], 123
# CHECK: ccmpe {dfv=of} dword ptr [r8 + 4*rax + 123], 123456
# CHECK: encoding: [0x62,0xd4,0x44,0x04,0x81,0x7c,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ccmpe {dfv=of} dword ptr [r8 + 4*rax + 123], 123456
# CHECK: ccmpe {dfv=of} qword ptr [r8 + 4*rax + 123], 123
# CHECK: encoding: [0x62,0xd4,0xc4,0x04,0x83,0x7c,0x80,0x7b,0x7b]
         ccmpe {dfv=of} qword ptr [r8 + 4*rax + 123], 123
# CHECK: ccmpe {dfv=of} qword ptr [r8 + 4*rax + 123], 123456
# CHECK: encoding: [0x62,0xd4,0xc4,0x04,0x81,0x7c,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ccmpe {dfv=of} qword ptr [r8 + 4*rax + 123], 123456
# CHECK: ccmpe {dfv=of} byte ptr [r8 + 4*rax + 123], bl
# CHECK: encoding: [0x62,0xd4,0x44,0x04,0x38,0x5c,0x80,0x7b]
         ccmpe {dfv=of} byte ptr [r8 + 4*rax + 123], bl
# CHECK: ccmpe {dfv=of} word ptr [r8 + 4*rax + 123], dx
# CHECK: encoding: [0x62,0xd4,0x45,0x04,0x39,0x54,0x80,0x7b]
         ccmpe {dfv=of} word ptr [r8 + 4*rax + 123], dx
# CHECK: ccmpe {dfv=of} dword ptr [r8 + 4*rax + 123], ecx
# CHECK: encoding: [0x62,0xd4,0x44,0x04,0x39,0x4c,0x80,0x7b]
         ccmpe {dfv=of} dword ptr [r8 + 4*rax + 123], ecx
# CHECK: ccmpe {dfv=of} qword ptr [r8 + 4*rax + 123], r9
# CHECK: encoding: [0x62,0x54,0xc4,0x04,0x39,0x4c,0x80,0x7b]
         ccmpe {dfv=of} qword ptr [r8 + 4*rax + 123], r9
# CHECK: ccmpe {dfv=of} bl, byte ptr [r8 + 4*rax + 123]
# CHECK: encoding: [0x62,0xd4,0x44,0x04,0x3a,0x5c,0x80,0x7b]
         ccmpe {dfv=of} bl, byte ptr [r8 + 4*rax + 123]
# CHECK: ccmpe {dfv=of} dx, word ptr [r8 + 4*rax + 123]
# CHECK: encoding: [0x62,0xd4,0x45,0x04,0x3b,0x54,0x80,0x7b]
         ccmpe {dfv=of} dx, word ptr [r8 + 4*rax + 123]
# CHECK: ccmpe {dfv=of} ecx, dword ptr [r8 + 4*rax + 123]
# CHECK: encoding: [0x62,0xd4,0x44,0x04,0x3b,0x4c,0x80,0x7b]
         ccmpe {dfv=of} ecx, dword ptr [r8 + 4*rax + 123]
# CHECK: ccmpe {dfv=of} r9, qword ptr [r8 + 4*rax + 123]
# CHECK: encoding: [0x62,0x54,0xc4,0x04,0x3b,0x4c,0x80,0x7b]
         ccmpe {dfv=of} r9, qword ptr [r8 + 4*rax + 123]
# CHECK: ccmpe {dfv=of} bl, 123
# CHECK: encoding: [0x62,0xf4,0x44,0x04,0x80,0xfb,0x7b]
         ccmpe {dfv=of} bl, 123
# CHECK: ccmpe {dfv=of} dx, 123
# CHECK: encoding: [0x62,0xf4,0x45,0x04,0x83,0xfa,0x7b]
         ccmpe {dfv=of} dx, 123
# CHECK: ccmpe {dfv=of} ecx, 123
# CHECK: encoding: [0x62,0xf4,0x44,0x04,0x83,0xf9,0x7b]
         ccmpe {dfv=of} ecx, 123
# CHECK: ccmpe {dfv=of} r9, 123
# CHECK: encoding: [0x62,0xd4,0xc4,0x04,0x83,0xf9,0x7b]
         ccmpe {dfv=of} r9, 123
# CHECK: ccmpe {dfv=of} dx, 1234
# CHECK: encoding: [0x62,0xf4,0x45,0x04,0x81,0xfa,0xd2,0x04]
         ccmpe {dfv=of} dx, 1234
# CHECK: ccmpe {dfv=of} ecx, 123456
# CHECK: encoding: [0x62,0xf4,0x44,0x04,0x81,0xf9,0x40,0xe2,0x01,0x00]
         ccmpe {dfv=of} ecx, 123456
# CHECK: ccmpe {dfv=of} r9, 123456
# CHECK: encoding: [0x62,0xd4,0xc4,0x04,0x81,0xf9,0x40,0xe2,0x01,0x00]
         ccmpe {dfv=of} r9, 123456
# CHECK: ccmpe {dfv=of} dl, bl
# CHECK: encoding: [0x62,0xf4,0x44,0x04,0x38,0xda]
         ccmpe {dfv=of} dl, bl
# CHECK: ccmpe {dfv=of} ax, dx
# CHECK: encoding: [0x62,0xf4,0x45,0x04,0x39,0xd0]
         ccmpe {dfv=of} ax, dx
# CHECK: ccmpe {dfv=of} edx, ecx
# CHECK: encoding: [0x62,0xf4,0x44,0x04,0x39,0xca]
         ccmpe {dfv=of} edx, ecx
# CHECK: ccmpe {dfv=of} r15, r9
# CHECK: encoding: [0x62,0x54,0xc4,0x04,0x39,0xcf]
         ccmpe {dfv=of} r15, r9

## Case sensitive

# CHECK: ccmpo {dfv=of,sf,zf,cf} rbx, rax
# CHECK: encoding: [0x62,0xf4,0xfc,0x00,0x39,0xc3]
         ccmpo {DFv=Cf,zF,SF,of} rbx, rax
