; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=+sse2   | FileCheck %s --check-prefixes=SSE,SSE2,X86-SSE,X86-SSE2
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=+sse4.2 | FileCheck %s --check-prefixes=SSE,SSE4,X86-SSE,X86-SSE4
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse2 | FileCheck %s --check-prefixes=SSE,SSE2,X64-SSE,X64-SSE2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse4.2,-slow-pmulld | FileCheck %s --check-prefixes=SSE,SSE4,X64-SSE,X64-SSE4,X64-SSE4-FAST
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse4.2,+slow-pmulld | FileCheck %s --check-prefixes=SSE,SSE4,X64-SSE,X64-SSE4,X64-SSE4-SLOW
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+xop  | FileCheck %s --check-prefixes=X64-AVX,X64-XOP
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx2 | FileCheck %s --check-prefixes=X64-AVX,X64-AVX2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512dq,+avx512vl | FileCheck %s --check-prefixes=X64-AVX,X64-AVX512DQ

;
; PowOf2 (uniform)
;

define <2 x i64> @mul_v2i64_8(<2 x i64> %a0) nounwind {
; SSE-LABEL: mul_v2i64_8:
; SSE:       # %bb.0:
; SSE-NEXT:    psllq $3, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; X64-AVX-LABEL: mul_v2i64_8:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vpsllq $3, %xmm0, %xmm0
; X64-AVX-NEXT:    retq
  %1 = mul <2 x i64> %a0, <i64 8, i64 8>
  ret <2 x i64> %1
}

define <4 x i32> @mul_v4i32_8(<4 x i32> %a0) nounwind {
; SSE-LABEL: mul_v4i32_8:
; SSE:       # %bb.0:
; SSE-NEXT:    pslld $3, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; X64-AVX-LABEL: mul_v4i32_8:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vpslld $3, %xmm0, %xmm0
; X64-AVX-NEXT:    retq
  %1 = mul <4 x i32> %a0, <i32 8, i32 8, i32 8, i32 8>
  ret <4 x i32> %1
}

define <8 x i16> @mul_v8i16_8(<8 x i16> %a0) nounwind {
; SSE-LABEL: mul_v8i16_8:
; SSE:       # %bb.0:
; SSE-NEXT:    psllw $3, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; X64-AVX-LABEL: mul_v8i16_8:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vpsllw $3, %xmm0, %xmm0
; X64-AVX-NEXT:    retq
  %1 = mul <8 x i16> %a0, <i16 8, i16 8, i16 8, i16 8, i16 8, i16 8, i16 8, i16 8>
  ret <8 x i16> %1
}

define <16 x i8> @mul_v16i8_32(<16 x i8> %a0) nounwind {
; X86-SSE-LABEL: mul_v16i8_32:
; X86-SSE:       # %bb.0:
; X86-SSE-NEXT:    psllw $5, %xmm0
; X86-SSE-NEXT:    pand {{\.?LCPI[0-9]+_[0-9]+}}, %xmm0
; X86-SSE-NEXT:    retl
;
; X64-SSE-LABEL: mul_v16i8_32:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    psllw $5, %xmm0
; X64-SSE-NEXT:    pand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; X64-SSE-NEXT:    retq
;
; X64-XOP-LABEL: mul_v16i8_32:
; X64-XOP:       # %bb.0:
; X64-XOP-NEXT:    vpshlb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; X64-XOP-NEXT:    retq
;
; X64-AVX2-LABEL: mul_v16i8_32:
; X64-AVX2:       # %bb.0:
; X64-AVX2-NEXT:    vpsllw $5, %xmm0, %xmm0
; X64-AVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; X64-AVX2-NEXT:    retq
;
; X64-AVX512DQ-LABEL: mul_v16i8_32:
; X64-AVX512DQ:       # %bb.0:
; X64-AVX512DQ-NEXT:    vpsllw $5, %xmm0, %xmm0
; X64-AVX512DQ-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %xmm0, %xmm0
; X64-AVX512DQ-NEXT:    retq
  %1 = mul <16 x i8> %a0, <i8 32, i8 32, i8 32, i8 32, i8 32, i8 32, i8 32, i8 32, i8 32, i8 32, i8 32, i8 32, i8 32, i8 32, i8 32, i8 32>
  ret <16 x i8> %1
}

;
; PowOf2 (non-uniform)
;

define <2 x i64> @mul_v2i64_32_8(<2 x i64> %a0) nounwind {
; SSE2-LABEL: mul_v2i64_32_8:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa %xmm0, %xmm1
; SSE2-NEXT:    psllq $5, %xmm1
; SSE2-NEXT:    psllq $3, %xmm0
; SSE2-NEXT:    movsd {{.*#+}} xmm0 = xmm1[0],xmm0[1]
; SSE2-NEXT:    ret{{[l|q]}}
;
; SSE4-LABEL: mul_v2i64_32_8:
; SSE4:       # %bb.0:
; SSE4-NEXT:    movdqa %xmm0, %xmm1
; SSE4-NEXT:    psllq $3, %xmm1
; SSE4-NEXT:    psllq $5, %xmm0
; SSE4-NEXT:    pblendw {{.*#+}} xmm0 = xmm0[0,1,2,3],xmm1[4,5,6,7]
; SSE4-NEXT:    ret{{[l|q]}}
;
; X64-XOP-LABEL: mul_v2i64_32_8:
; X64-XOP:       # %bb.0:
; X64-XOP-NEXT:    vpshlq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; X64-XOP-NEXT:    retq
;
; X64-AVX2-LABEL: mul_v2i64_32_8:
; X64-AVX2:       # %bb.0:
; X64-AVX2-NEXT:    vpsllvq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; X64-AVX2-NEXT:    retq
;
; X64-AVX512DQ-LABEL: mul_v2i64_32_8:
; X64-AVX512DQ:       # %bb.0:
; X64-AVX512DQ-NEXT:    vpsllvq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; X64-AVX512DQ-NEXT:    retq
  %1 = mul <2 x i64> %a0, <i64 32, i64 8>
  ret <2 x i64> %1
}

define <4 x i32> @mul_v4i32_1_2_4_8(<4 x i32> %a0) nounwind {
; X86-SSE2-LABEL: mul_v4i32_1_2_4_8:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[1,1,3,3]
; X86-SSE2-NEXT:    pmuludq {{\.?LCPI[0-9]+_[0-9]+}}, %xmm0
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; X86-SSE2-NEXT:    pmuludq {{\.?LCPI[0-9]+_[0-9]+}}, %xmm1
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; X86-SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; X86-SSE2-NEXT:    retl
;
; X86-SSE4-LABEL: mul_v4i32_1_2_4_8:
; X86-SSE4:       # %bb.0:
; X86-SSE4-NEXT:    pmulld {{\.?LCPI[0-9]+_[0-9]+}}, %xmm0
; X86-SSE4-NEXT:    retl
;
; X64-SSE2-LABEL: mul_v4i32_1_2_4_8:
; X64-SSE2:       # %bb.0:
; X64-SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[1,1,3,3]
; X64-SSE2-NEXT:    pmuludq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; X64-SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; X64-SSE2-NEXT:    pmuludq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1
; X64-SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; X64-SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; X64-SSE2-NEXT:    retq
;
; X64-SSE4-LABEL: mul_v4i32_1_2_4_8:
; X64-SSE4:       # %bb.0:
; X64-SSE4-NEXT:    pmulld {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; X64-SSE4-NEXT:    retq
;
; X64-XOP-LABEL: mul_v4i32_1_2_4_8:
; X64-XOP:       # %bb.0:
; X64-XOP-NEXT:    vpshld {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; X64-XOP-NEXT:    retq
;
; X64-AVX2-LABEL: mul_v4i32_1_2_4_8:
; X64-AVX2:       # %bb.0:
; X64-AVX2-NEXT:    vpsllvd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; X64-AVX2-NEXT:    retq
;
; X64-AVX512DQ-LABEL: mul_v4i32_1_2_4_8:
; X64-AVX512DQ:       # %bb.0:
; X64-AVX512DQ-NEXT:    vpsllvd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; X64-AVX512DQ-NEXT:    retq
  %1 = mul <4 x i32> %a0, <i32 1, i32 2, i32 4, i32 8>
  ret <4 x i32> %1
}

define <4 x i32> @mul_v4i32_1_2_4_8_optsize(<4 x i32> %a0) nounwind optsize {
; SSE2-LABEL: mul_v4i32_1_2_4_8_optsize:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa {{.*#+}} xmm1 = [1,2,4,8]
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[1,1,3,3]
; SSE2-NEXT:    pmuludq %xmm1, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE2-NEXT:    pmuludq %xmm2, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE2-NEXT:    ret{{[l|q]}}
;
; X86-SSE4-LABEL: mul_v4i32_1_2_4_8_optsize:
; X86-SSE4:       # %bb.0:
; X86-SSE4-NEXT:    pmulld {{\.?LCPI[0-9]+_[0-9]+}}, %xmm0
; X86-SSE4-NEXT:    retl
;
; X64-SSE4-LABEL: mul_v4i32_1_2_4_8_optsize:
; X64-SSE4:       # %bb.0:
; X64-SSE4-NEXT:    pmulld {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; X64-SSE4-NEXT:    retq
;
; X64-XOP-LABEL: mul_v4i32_1_2_4_8_optsize:
; X64-XOP:       # %bb.0:
; X64-XOP-NEXT:    vpshld {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; X64-XOP-NEXT:    retq
;
; X64-AVX2-LABEL: mul_v4i32_1_2_4_8_optsize:
; X64-AVX2:       # %bb.0:
; X64-AVX2-NEXT:    vpsllvd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; X64-AVX2-NEXT:    retq
;
; X64-AVX512DQ-LABEL: mul_v4i32_1_2_4_8_optsize:
; X64-AVX512DQ:       # %bb.0:
; X64-AVX512DQ-NEXT:    vpsllvd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; X64-AVX512DQ-NEXT:    retq
  %1 = mul <4 x i32> %a0, <i32 1, i32 2, i32 4, i32 8>
  ret <4 x i32> %1
}

define <8 x i16> @mul_v8i16_1_2_4_8_16_32_64_128(<8 x i16> %a0) nounwind {
; X86-SSE-LABEL: mul_v8i16_1_2_4_8_16_32_64_128:
; X86-SSE:       # %bb.0:
; X86-SSE-NEXT:    pmullw {{\.?LCPI[0-9]+_[0-9]+}}, %xmm0 # [1,2,4,8,16,32,64,128]
; X86-SSE-NEXT:    retl
;
; X64-SSE-LABEL: mul_v8i16_1_2_4_8_16_32_64_128:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    pmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0 # [1,2,4,8,16,32,64,128]
; X64-SSE-NEXT:    retq
;
; X64-XOP-LABEL: mul_v8i16_1_2_4_8_16_32_64_128:
; X64-XOP:       # %bb.0:
; X64-XOP-NEXT:    vpshlw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; X64-XOP-NEXT:    retq
;
; X64-AVX2-LABEL: mul_v8i16_1_2_4_8_16_32_64_128:
; X64-AVX2:       # %bb.0:
; X64-AVX2-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0 # [1,2,4,8,16,32,64,128]
; X64-AVX2-NEXT:    retq
;
; X64-AVX512DQ-LABEL: mul_v8i16_1_2_4_8_16_32_64_128:
; X64-AVX512DQ:       # %bb.0:
; X64-AVX512DQ-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0 # [1,2,4,8,16,32,64,128]
; X64-AVX512DQ-NEXT:    retq
  %1 = mul <8 x i16> %a0, <i16 1, i16 2, i16 4, i16 8, i16 16, i16 32, i16 64, i16 128>
  ret <8 x i16> %1
}

define <16 x i8> @mul_v16i8_1_2_4_8_1_2_4_8_1_2_4_8_1_2_4_8(<16 x i8> %a0) nounwind {
; SSE2-LABEL: mul_v16i8_1_2_4_8_1_2_4_8_1_2_4_8_1_2_4_8:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa %xmm0, %xmm1
; SSE2-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; SSE2-NEXT:    movdqa {{.*#+}} xmm2 = [1,2,4,8,1,2,4,8]
; SSE2-NEXT:    pmullw %xmm2, %xmm1
; SSE2-NEXT:    movdqa {{.*#+}} xmm3 = [255,255,255,255,255,255,255,255]
; SSE2-NEXT:    pand %xmm3, %xmm1
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE2-NEXT:    pmullw %xmm2, %xmm0
; SSE2-NEXT:    pand %xmm3, %xmm0
; SSE2-NEXT:    packuswb %xmm1, %xmm0
; SSE2-NEXT:    ret{{[l|q]}}
;
; X86-SSE4-LABEL: mul_v16i8_1_2_4_8_1_2_4_8_1_2_4_8_1_2_4_8:
; X86-SSE4:       # %bb.0:
; X86-SSE4-NEXT:    movdqa %xmm0, %xmm1
; X86-SSE4-NEXT:    pmaddubsw {{\.?LCPI[0-9]+_[0-9]+}}, %xmm1 # [0,2,0,8,0,2,0,8,0,2,0,8,0,2,0,8]
; X86-SSE4-NEXT:    psllw $8, %xmm1
; X86-SSE4-NEXT:    pmaddubsw {{\.?LCPI[0-9]+_[0-9]+}}, %xmm0 # [1,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0]
; X86-SSE4-NEXT:    pand {{\.?LCPI[0-9]+_[0-9]+}}, %xmm0
; X86-SSE4-NEXT:    por %xmm1, %xmm0
; X86-SSE4-NEXT:    retl
;
; X64-SSE4-LABEL: mul_v16i8_1_2_4_8_1_2_4_8_1_2_4_8_1_2_4_8:
; X64-SSE4:       # %bb.0:
; X64-SSE4-NEXT:    movdqa %xmm0, %xmm1
; X64-SSE4-NEXT:    pmaddubsw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1 # [0,2,0,8,0,2,0,8,0,2,0,8,0,2,0,8]
; X64-SSE4-NEXT:    psllw $8, %xmm1
; X64-SSE4-NEXT:    pmaddubsw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0 # [1,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0]
; X64-SSE4-NEXT:    pand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; X64-SSE4-NEXT:    por %xmm1, %xmm0
; X64-SSE4-NEXT:    retq
;
; X64-XOP-LABEL: mul_v16i8_1_2_4_8_1_2_4_8_1_2_4_8_1_2_4_8:
; X64-XOP:       # %bb.0:
; X64-XOP-NEXT:    vpshlb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; X64-XOP-NEXT:    retq
;
; X64-AVX2-LABEL: mul_v16i8_1_2_4_8_1_2_4_8_1_2_4_8_1_2_4_8:
; X64-AVX2:       # %bb.0:
; X64-AVX2-NEXT:    vpmovzxbw {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero,xmm0[8],zero,xmm0[9],zero,xmm0[10],zero,xmm0[11],zero,xmm0[12],zero,xmm0[13],zero,xmm0[14],zero,xmm0[15],zero
; X64-AVX2-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0 # [1,2,4,8,1,2,4,8,1,2,4,8,1,2,4,8]
; X64-AVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; X64-AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; X64-AVX2-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; X64-AVX2-NEXT:    vzeroupper
; X64-AVX2-NEXT:    retq
;
; X64-AVX512DQ-LABEL: mul_v16i8_1_2_4_8_1_2_4_8_1_2_4_8_1_2_4_8:
; X64-AVX512DQ:       # %bb.0:
; X64-AVX512DQ-NEXT:    vpmovzxbd {{.*#+}} zmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero,xmm0[4],zero,zero,zero,xmm0[5],zero,zero,zero,xmm0[6],zero,zero,zero,xmm0[7],zero,zero,zero,xmm0[8],zero,zero,zero,xmm0[9],zero,zero,zero,xmm0[10],zero,zero,zero,xmm0[11],zero,zero,zero,xmm0[12],zero,zero,zero,xmm0[13],zero,zero,zero,xmm0[14],zero,zero,zero,xmm0[15],zero,zero,zero
; X64-AVX512DQ-NEXT:    vpsllvd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm0, %zmm0
; X64-AVX512DQ-NEXT:    vpmovdb %zmm0, %xmm0
; X64-AVX512DQ-NEXT:    vzeroupper
; X64-AVX512DQ-NEXT:    retq
  %1 = mul <16 x i8> %a0, <i8 1, i8 2, i8 4, i8 8, i8 1, i8 2, i8 4, i8 8, i8 1, i8 2, i8 4, i8 8, i8 1, i8 2, i8 4, i8 8>
  ret <16 x i8> %1
}

;
; PowOf2 + 1 (uniform)
;

define <2 x i64> @mul_v2i64_17(<2 x i64> %a0) nounwind {
; SSE-LABEL: mul_v2i64_17:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa %xmm0, %xmm1
; SSE-NEXT:    psllq $4, %xmm1
; SSE-NEXT:    paddq %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; X64-AVX-LABEL: mul_v2i64_17:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vpsllq $4, %xmm0, %xmm1
; X64-AVX-NEXT:    vpaddq %xmm0, %xmm1, %xmm0
; X64-AVX-NEXT:    retq
  %1 = mul <2 x i64> %a0, <i64 17, i64 17>
  ret <2 x i64> %1
}

define <4 x i32> @mul_v4i32_17(<4 x i32> %a0) nounwind {
; SSE-LABEL: mul_v4i32_17:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa %xmm0, %xmm1
; SSE-NEXT:    pslld $4, %xmm1
; SSE-NEXT:    paddd %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; X64-XOP-LABEL: mul_v4i32_17:
; X64-XOP:       # %bb.0:
; X64-XOP-NEXT:    vpslld $4, %xmm0, %xmm1
; X64-XOP-NEXT:    vpaddd %xmm1, %xmm0, %xmm0
; X64-XOP-NEXT:    retq
;
; X64-AVX2-LABEL: mul_v4i32_17:
; X64-AVX2:       # %bb.0:
; X64-AVX2-NEXT:    vpbroadcastd {{.*#+}} xmm1 = [17,17,17,17]
; X64-AVX2-NEXT:    vpmulld %xmm1, %xmm0, %xmm0
; X64-AVX2-NEXT:    retq
;
; X64-AVX512DQ-LABEL: mul_v4i32_17:
; X64-AVX512DQ:       # %bb.0:
; X64-AVX512DQ-NEXT:    vpmulld {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %xmm0, %xmm0
; X64-AVX512DQ-NEXT:    retq
  %1 = mul <4 x i32> %a0, <i32 17, i32 17, i32 17, i32 17>
  ret <4 x i32> %1
}

define <8 x i16> @mul_v8i16_17(<8 x i16> %a0) nounwind {
; SSE-LABEL: mul_v8i16_17:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa %xmm0, %xmm1
; SSE-NEXT:    psllw $4, %xmm1
; SSE-NEXT:    paddw %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; X64-AVX-LABEL: mul_v8i16_17:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vpsllw $4, %xmm0, %xmm1
; X64-AVX-NEXT:    vpaddw %xmm1, %xmm0, %xmm0
; X64-AVX-NEXT:    retq
  %1 = mul <8 x i16> %a0, <i16 17, i16 17, i16 17, i16 17, i16 17, i16 17, i16 17, i16 17>
  ret <8 x i16> %1
}

define <16 x i8> @mul_v16i8_17(<16 x i8> %a0) nounwind {
; X86-SSE-LABEL: mul_v16i8_17:
; X86-SSE:       # %bb.0:
; X86-SSE-NEXT:    movdqa %xmm0, %xmm1
; X86-SSE-NEXT:    psllw $4, %xmm1
; X86-SSE-NEXT:    pand {{\.?LCPI[0-9]+_[0-9]+}}, %xmm1
; X86-SSE-NEXT:    paddb %xmm1, %xmm0
; X86-SSE-NEXT:    retl
;
; X64-SSE-LABEL: mul_v16i8_17:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    movdqa %xmm0, %xmm1
; X64-SSE-NEXT:    psllw $4, %xmm1
; X64-SSE-NEXT:    pand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1
; X64-SSE-NEXT:    paddb %xmm1, %xmm0
; X64-SSE-NEXT:    retq
;
; X64-XOP-LABEL: mul_v16i8_17:
; X64-XOP:       # %bb.0:
; X64-XOP-NEXT:    vpshlb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm1
; X64-XOP-NEXT:    vpaddb %xmm0, %xmm1, %xmm0
; X64-XOP-NEXT:    retq
;
; X64-AVX2-LABEL: mul_v16i8_17:
; X64-AVX2:       # %bb.0:
; X64-AVX2-NEXT:    vpsllw $4, %xmm0, %xmm1
; X64-AVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm1
; X64-AVX2-NEXT:    vpaddb %xmm0, %xmm1, %xmm0
; X64-AVX2-NEXT:    retq
;
; X64-AVX512DQ-LABEL: mul_v16i8_17:
; X64-AVX512DQ:       # %bb.0:
; X64-AVX512DQ-NEXT:    vpsllw $4, %xmm0, %xmm1
; X64-AVX512DQ-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %xmm1, %xmm1
; X64-AVX512DQ-NEXT:    vpaddb %xmm0, %xmm1, %xmm0
; X64-AVX512DQ-NEXT:    retq
  %1 = mul <16 x i8> %a0, <i8 17, i8 17, i8 17, i8 17, i8 17, i8 17, i8 17, i8 17, i8 17, i8 17, i8 17, i8 17, i8 17, i8 17, i8 17, i8 17>
  ret <16 x i8> %1
}

define <4 x i64> @mul_v4i64_17(<4 x i64> %a0) nounwind {
; SSE-LABEL: mul_v4i64_17:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa %xmm0, %xmm2
; SSE-NEXT:    psllq $4, %xmm2
; SSE-NEXT:    paddq %xmm2, %xmm0
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    psllq $4, %xmm2
; SSE-NEXT:    paddq %xmm2, %xmm1
; SSE-NEXT:    ret{{[l|q]}}
;
; X64-XOP-LABEL: mul_v4i64_17:
; X64-XOP:       # %bb.0:
; X64-XOP-NEXT:    vextractf128 $1, %ymm0, %xmm1
; X64-XOP-NEXT:    vpsllq $4, %xmm1, %xmm2
; X64-XOP-NEXT:    vpaddq %xmm1, %xmm2, %xmm1
; X64-XOP-NEXT:    vpsllq $4, %xmm0, %xmm2
; X64-XOP-NEXT:    vpaddq %xmm0, %xmm2, %xmm0
; X64-XOP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; X64-XOP-NEXT:    retq
;
; X64-AVX2-LABEL: mul_v4i64_17:
; X64-AVX2:       # %bb.0:
; X64-AVX2-NEXT:    vpsllq $4, %ymm0, %ymm1
; X64-AVX2-NEXT:    vpaddq %ymm0, %ymm1, %ymm0
; X64-AVX2-NEXT:    retq
;
; X64-AVX512DQ-LABEL: mul_v4i64_17:
; X64-AVX512DQ:       # %bb.0:
; X64-AVX512DQ-NEXT:    vpsllq $4, %ymm0, %ymm1
; X64-AVX512DQ-NEXT:    vpaddq %ymm0, %ymm1, %ymm0
; X64-AVX512DQ-NEXT:    retq
  %1 = mul <4 x i64> %a0, <i64 17, i64 17, i64 17, i64 17>
  ret <4 x i64> %1
}

define <8 x i32> @mul_v8i32_17(<8 x i32> %a0) nounwind {
; SSE-LABEL: mul_v8i32_17:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa %xmm0, %xmm2
; SSE-NEXT:    pslld $4, %xmm2
; SSE-NEXT:    paddd %xmm2, %xmm0
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    pslld $4, %xmm2
; SSE-NEXT:    paddd %xmm2, %xmm1
; SSE-NEXT:    ret{{[l|q]}}
;
; X64-XOP-LABEL: mul_v8i32_17:
; X64-XOP:       # %bb.0:
; X64-XOP-NEXT:    vextractf128 $1, %ymm0, %xmm1
; X64-XOP-NEXT:    vpslld $4, %xmm1, %xmm2
; X64-XOP-NEXT:    vpaddd %xmm1, %xmm2, %xmm1
; X64-XOP-NEXT:    vpslld $4, %xmm0, %xmm2
; X64-XOP-NEXT:    vpaddd %xmm0, %xmm2, %xmm0
; X64-XOP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; X64-XOP-NEXT:    retq
;
; X64-AVX2-LABEL: mul_v8i32_17:
; X64-AVX2:       # %bb.0:
; X64-AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [17,17,17,17,17,17,17,17]
; X64-AVX2-NEXT:    vpmulld %ymm1, %ymm0, %ymm0
; X64-AVX2-NEXT:    retq
;
; X64-AVX512DQ-LABEL: mul_v8i32_17:
; X64-AVX512DQ:       # %bb.0:
; X64-AVX512DQ-NEXT:    vpmulld {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %ymm0, %ymm0
; X64-AVX512DQ-NEXT:    retq
  %1 = mul <8 x i32> %a0, <i32 17, i32 17, i32 17, i32 17, i32 17, i32 17, i32 17, i32 17>
  ret <8 x i32> %1
}

define <16 x i16> @mul_v16i16_17(<16 x i16> %a0) nounwind {
; SSE-LABEL: mul_v16i16_17:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa %xmm0, %xmm2
; SSE-NEXT:    psllw $4, %xmm2
; SSE-NEXT:    paddw %xmm2, %xmm0
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    psllw $4, %xmm2
; SSE-NEXT:    paddw %xmm2, %xmm1
; SSE-NEXT:    ret{{[l|q]}}
;
; X64-XOP-LABEL: mul_v16i16_17:
; X64-XOP:       # %bb.0:
; X64-XOP-NEXT:    vextractf128 $1, %ymm0, %xmm1
; X64-XOP-NEXT:    vpsllw $4, %xmm1, %xmm2
; X64-XOP-NEXT:    vpaddw %xmm1, %xmm2, %xmm1
; X64-XOP-NEXT:    vpsllw $4, %xmm0, %xmm2
; X64-XOP-NEXT:    vpaddw %xmm0, %xmm2, %xmm0
; X64-XOP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; X64-XOP-NEXT:    retq
;
; X64-AVX2-LABEL: mul_v16i16_17:
; X64-AVX2:       # %bb.0:
; X64-AVX2-NEXT:    vpsllw $4, %ymm0, %ymm1
; X64-AVX2-NEXT:    vpaddw %ymm1, %ymm0, %ymm0
; X64-AVX2-NEXT:    retq
;
; X64-AVX512DQ-LABEL: mul_v16i16_17:
; X64-AVX512DQ:       # %bb.0:
; X64-AVX512DQ-NEXT:    vpsllw $4, %ymm0, %ymm1
; X64-AVX512DQ-NEXT:    vpaddw %ymm1, %ymm0, %ymm0
; X64-AVX512DQ-NEXT:    retq
  %1 = mul <16 x i16> %a0, <i16 17, i16 17, i16 17, i16 17, i16 17, i16 17, i16 17, i16 17, i16 17, i16 17, i16 17, i16 17, i16 17, i16 17, i16 17, i16 17>
  ret <16 x i16> %1
}

define <32 x i8> @mul_v32i8_17(<32 x i8> %a0) nounwind {
; SSE-LABEL: mul_v32i8_17:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa %xmm0, %xmm2
; SSE-NEXT:    psllw $4, %xmm2
; SSE-NEXT:    movdqa {{.*#+}} xmm3 = [240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240]
; SSE-NEXT:    pand %xmm3, %xmm2
; SSE-NEXT:    paddb %xmm2, %xmm0
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    psllw $4, %xmm2
; SSE-NEXT:    pand %xmm3, %xmm2
; SSE-NEXT:    paddb %xmm2, %xmm1
; SSE-NEXT:    ret{{[l|q]}}
;
; X64-XOP-LABEL: mul_v32i8_17:
; X64-XOP:       # %bb.0:
; X64-XOP-NEXT:    vextractf128 $1, %ymm0, %xmm1
; X64-XOP-NEXT:    vbroadcastss {{.*#+}} xmm2 = [4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4]
; X64-XOP-NEXT:    vpshlb %xmm2, %xmm1, %xmm3
; X64-XOP-NEXT:    vpaddb %xmm1, %xmm3, %xmm1
; X64-XOP-NEXT:    vpshlb %xmm2, %xmm0, %xmm2
; X64-XOP-NEXT:    vpaddb %xmm0, %xmm2, %xmm0
; X64-XOP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; X64-XOP-NEXT:    retq
;
; X64-AVX2-LABEL: mul_v32i8_17:
; X64-AVX2:       # %bb.0:
; X64-AVX2-NEXT:    vpsllw $4, %ymm0, %ymm1
; X64-AVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1
; X64-AVX2-NEXT:    vpaddb %ymm0, %ymm1, %ymm0
; X64-AVX2-NEXT:    retq
;
; X64-AVX512DQ-LABEL: mul_v32i8_17:
; X64-AVX512DQ:       # %bb.0:
; X64-AVX512DQ-NEXT:    vpsllw $4, %ymm0, %ymm1
; X64-AVX512DQ-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %ymm1, %ymm1
; X64-AVX512DQ-NEXT:    vpaddb %ymm0, %ymm1, %ymm0
; X64-AVX512DQ-NEXT:    retq
  %1 = mul <32 x i8> %a0, <i8 17, i8 17, i8 17, i8 17, i8 17, i8 17, i8 17, i8 17, i8 17, i8 17, i8 17, i8 17, i8 17, i8 17, i8 17, i8 17, i8 17, i8 17, i8 17, i8 17, i8 17, i8 17, i8 17, i8 17, i8 17, i8 17, i8 17, i8 17, i8 17, i8 17, i8 17, i8 17>
  ret <32 x i8> %1
}

;
; -(PowOf2 + 1) (uniform)
;

define <2 x i64> @mul_v2i64_neg1025(<2 x i64> %a0) nounwind {
; SSE-LABEL: mul_v2i64_neg1025:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa %xmm0, %xmm1
; SSE-NEXT:    psllq $10, %xmm1
; SSE-NEXT:    paddq %xmm0, %xmm1
; SSE-NEXT:    pxor %xmm0, %xmm0
; SSE-NEXT:    psubq %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; X64-AVX-LABEL: mul_v2i64_neg1025:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vpsllq $10, %xmm0, %xmm1
; X64-AVX-NEXT:    vpaddq %xmm0, %xmm1, %xmm0
; X64-AVX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; X64-AVX-NEXT:    vpsubq %xmm0, %xmm1, %xmm0
; X64-AVX-NEXT:    retq
  %1 = mul <2 x i64> %a0, <i64 -1025, i64 -1025>
  ret <2 x i64> %1
}

define <4 x i32> @mul_v4i32_neg33(<4 x i32> %a0) nounwind {
; SSE-LABEL: mul_v4i32_neg33:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa %xmm0, %xmm1
; SSE-NEXT:    pslld $5, %xmm1
; SSE-NEXT:    paddd %xmm0, %xmm1
; SSE-NEXT:    pxor %xmm0, %xmm0
; SSE-NEXT:    psubd %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; X64-XOP-LABEL: mul_v4i32_neg33:
; X64-XOP:       # %bb.0:
; X64-XOP-NEXT:    vpslld $5, %xmm0, %xmm1
; X64-XOP-NEXT:    vpaddd %xmm1, %xmm0, %xmm0
; X64-XOP-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; X64-XOP-NEXT:    vpsubd %xmm0, %xmm1, %xmm0
; X64-XOP-NEXT:    retq
;
; X64-AVX2-LABEL: mul_v4i32_neg33:
; X64-AVX2:       # %bb.0:
; X64-AVX2-NEXT:    vpbroadcastd {{.*#+}} xmm1 = [4294967263,4294967263,4294967263,4294967263]
; X64-AVX2-NEXT:    vpmulld %xmm1, %xmm0, %xmm0
; X64-AVX2-NEXT:    retq
;
; X64-AVX512DQ-LABEL: mul_v4i32_neg33:
; X64-AVX512DQ:       # %bb.0:
; X64-AVX512DQ-NEXT:    vpmulld {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %xmm0, %xmm0
; X64-AVX512DQ-NEXT:    retq
  %1 = mul <4 x i32> %a0, <i32 -33, i32 -33, i32 -33, i32 -33>
  ret <4 x i32> %1
}

define <8 x i16> @mul_v8i16_neg9(<8 x i16> %a0) nounwind {
; SSE-LABEL: mul_v8i16_neg9:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa %xmm0, %xmm1
; SSE-NEXT:    psllw $3, %xmm1
; SSE-NEXT:    paddw %xmm0, %xmm1
; SSE-NEXT:    pxor %xmm0, %xmm0
; SSE-NEXT:    psubw %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; X64-AVX-LABEL: mul_v8i16_neg9:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vpsllw $3, %xmm0, %xmm1
; X64-AVX-NEXT:    vpaddw %xmm1, %xmm0, %xmm0
; X64-AVX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; X64-AVX-NEXT:    vpsubw %xmm0, %xmm1, %xmm0
; X64-AVX-NEXT:    retq
  %1 = mul <8 x i16> %a0, <i16 -9, i16 -9, i16 -9, i16 -9, i16 -9, i16 -9, i16 -9, i16 -9>
  ret <8 x i16> %1
}

define <16 x i8> @mul_v16i8_neg5(<16 x i8> %a0) nounwind {
; X86-SSE-LABEL: mul_v16i8_neg5:
; X86-SSE:       # %bb.0:
; X86-SSE-NEXT:    movdqa %xmm0, %xmm1
; X86-SSE-NEXT:    psllw $2, %xmm1
; X86-SSE-NEXT:    pand {{\.?LCPI[0-9]+_[0-9]+}}, %xmm1
; X86-SSE-NEXT:    paddb %xmm0, %xmm1
; X86-SSE-NEXT:    pxor %xmm0, %xmm0
; X86-SSE-NEXT:    psubb %xmm1, %xmm0
; X86-SSE-NEXT:    retl
;
; X64-SSE-LABEL: mul_v16i8_neg5:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    movdqa %xmm0, %xmm1
; X64-SSE-NEXT:    psllw $2, %xmm1
; X64-SSE-NEXT:    pand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1
; X64-SSE-NEXT:    paddb %xmm0, %xmm1
; X64-SSE-NEXT:    pxor %xmm0, %xmm0
; X64-SSE-NEXT:    psubb %xmm1, %xmm0
; X64-SSE-NEXT:    retq
;
; X64-XOP-LABEL: mul_v16i8_neg5:
; X64-XOP:       # %bb.0:
; X64-XOP-NEXT:    vpshlb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm1
; X64-XOP-NEXT:    vpaddb %xmm0, %xmm1, %xmm0
; X64-XOP-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; X64-XOP-NEXT:    vpsubb %xmm0, %xmm1, %xmm0
; X64-XOP-NEXT:    retq
;
; X64-AVX2-LABEL: mul_v16i8_neg5:
; X64-AVX2:       # %bb.0:
; X64-AVX2-NEXT:    vpsllw $2, %xmm0, %xmm1
; X64-AVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm1
; X64-AVX2-NEXT:    vpaddb %xmm0, %xmm1, %xmm0
; X64-AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; X64-AVX2-NEXT:    vpsubb %xmm0, %xmm1, %xmm0
; X64-AVX2-NEXT:    retq
;
; X64-AVX512DQ-LABEL: mul_v16i8_neg5:
; X64-AVX512DQ:       # %bb.0:
; X64-AVX512DQ-NEXT:    vpsllw $2, %xmm0, %xmm1
; X64-AVX512DQ-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %xmm1, %xmm1
; X64-AVX512DQ-NEXT:    vpaddb %xmm0, %xmm1, %xmm0
; X64-AVX512DQ-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; X64-AVX512DQ-NEXT:    vpsubb %xmm0, %xmm1, %xmm0
; X64-AVX512DQ-NEXT:    retq
  %1 = mul <16 x i8> %a0, <i8 -5, i8 -5, i8 -5, i8 -5, i8 -5, i8 -5, i8 -5, i8 -5, i8 -5, i8 -5, i8 -5, i8 -5, i8 -5, i8 -5, i8 -5, i8 -5>
  ret <16 x i8> %1
}

define <4 x i64> @mul_v4i64_neg1025(<4 x i64> %a0) nounwind {
; SSE-LABEL: mul_v4i64_neg1025:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa %xmm0, %xmm3
; SSE-NEXT:    psllq $10, %xmm3
; SSE-NEXT:    paddq %xmm0, %xmm3
; SSE-NEXT:    pxor %xmm2, %xmm2
; SSE-NEXT:    pxor %xmm0, %xmm0
; SSE-NEXT:    psubq %xmm3, %xmm0
; SSE-NEXT:    movdqa %xmm1, %xmm3
; SSE-NEXT:    psllq $10, %xmm3
; SSE-NEXT:    paddq %xmm1, %xmm3
; SSE-NEXT:    psubq %xmm3, %xmm2
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    ret{{[l|q]}}
;
; X64-XOP-LABEL: mul_v4i64_neg1025:
; X64-XOP:       # %bb.0:
; X64-XOP-NEXT:    vextractf128 $1, %ymm0, %xmm1
; X64-XOP-NEXT:    vpsllq $10, %xmm1, %xmm2
; X64-XOP-NEXT:    vpaddq %xmm1, %xmm2, %xmm1
; X64-XOP-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; X64-XOP-NEXT:    vpsubq %xmm1, %xmm2, %xmm1
; X64-XOP-NEXT:    vpsllq $10, %xmm0, %xmm3
; X64-XOP-NEXT:    vpaddq %xmm0, %xmm3, %xmm0
; X64-XOP-NEXT:    vpsubq %xmm0, %xmm2, %xmm0
; X64-XOP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; X64-XOP-NEXT:    retq
;
; X64-AVX2-LABEL: mul_v4i64_neg1025:
; X64-AVX2:       # %bb.0:
; X64-AVX2-NEXT:    vpsllq $10, %ymm0, %ymm1
; X64-AVX2-NEXT:    vpaddq %ymm0, %ymm1, %ymm0
; X64-AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; X64-AVX2-NEXT:    vpsubq %ymm0, %ymm1, %ymm0
; X64-AVX2-NEXT:    retq
;
; X64-AVX512DQ-LABEL: mul_v4i64_neg1025:
; X64-AVX512DQ:       # %bb.0:
; X64-AVX512DQ-NEXT:    vpsllq $10, %ymm0, %ymm1
; X64-AVX512DQ-NEXT:    vpaddq %ymm0, %ymm1, %ymm0
; X64-AVX512DQ-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; X64-AVX512DQ-NEXT:    vpsubq %ymm0, %ymm1, %ymm0
; X64-AVX512DQ-NEXT:    retq
  %1 = mul <4 x i64> %a0, <i64 -1025, i64 -1025, i64 -1025, i64 -1025>
  ret <4 x i64> %1
}

define <8 x i32> @mul_v8i32_neg33(<8 x i32> %a0) nounwind {
; SSE-LABEL: mul_v8i32_neg33:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa %xmm0, %xmm3
; SSE-NEXT:    pslld $5, %xmm3
; SSE-NEXT:    paddd %xmm0, %xmm3
; SSE-NEXT:    pxor %xmm2, %xmm2
; SSE-NEXT:    pxor %xmm0, %xmm0
; SSE-NEXT:    psubd %xmm3, %xmm0
; SSE-NEXT:    movdqa %xmm1, %xmm3
; SSE-NEXT:    pslld $5, %xmm3
; SSE-NEXT:    paddd %xmm1, %xmm3
; SSE-NEXT:    psubd %xmm3, %xmm2
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    ret{{[l|q]}}
;
; X64-XOP-LABEL: mul_v8i32_neg33:
; X64-XOP:       # %bb.0:
; X64-XOP-NEXT:    vextractf128 $1, %ymm0, %xmm1
; X64-XOP-NEXT:    vpslld $5, %xmm1, %xmm2
; X64-XOP-NEXT:    vpaddd %xmm1, %xmm2, %xmm1
; X64-XOP-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; X64-XOP-NEXT:    vpsubd %xmm1, %xmm2, %xmm1
; X64-XOP-NEXT:    vpslld $5, %xmm0, %xmm3
; X64-XOP-NEXT:    vpaddd %xmm0, %xmm3, %xmm0
; X64-XOP-NEXT:    vpsubd %xmm0, %xmm2, %xmm0
; X64-XOP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; X64-XOP-NEXT:    retq
;
; X64-AVX2-LABEL: mul_v8i32_neg33:
; X64-AVX2:       # %bb.0:
; X64-AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [4294967263,4294967263,4294967263,4294967263,4294967263,4294967263,4294967263,4294967263]
; X64-AVX2-NEXT:    vpmulld %ymm1, %ymm0, %ymm0
; X64-AVX2-NEXT:    retq
;
; X64-AVX512DQ-LABEL: mul_v8i32_neg33:
; X64-AVX512DQ:       # %bb.0:
; X64-AVX512DQ-NEXT:    vpmulld {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %ymm0, %ymm0
; X64-AVX512DQ-NEXT:    retq
  %1 = mul <8 x i32> %a0, <i32 -33, i32 -33, i32 -33, i32 -33, i32 -33, i32 -33, i32 -33, i32 -33>
  ret <8 x i32> %1
}

define <16 x i16> @mul_v16i16_neg9(<16 x i16> %a0) nounwind {
; SSE-LABEL: mul_v16i16_neg9:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa %xmm0, %xmm3
; SSE-NEXT:    psllw $3, %xmm3
; SSE-NEXT:    paddw %xmm0, %xmm3
; SSE-NEXT:    pxor %xmm2, %xmm2
; SSE-NEXT:    pxor %xmm0, %xmm0
; SSE-NEXT:    psubw %xmm3, %xmm0
; SSE-NEXT:    movdqa %xmm1, %xmm3
; SSE-NEXT:    psllw $3, %xmm3
; SSE-NEXT:    paddw %xmm1, %xmm3
; SSE-NEXT:    psubw %xmm3, %xmm2
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    ret{{[l|q]}}
;
; X64-XOP-LABEL: mul_v16i16_neg9:
; X64-XOP:       # %bb.0:
; X64-XOP-NEXT:    vextractf128 $1, %ymm0, %xmm1
; X64-XOP-NEXT:    vpsllw $3, %xmm1, %xmm2
; X64-XOP-NEXT:    vpaddw %xmm1, %xmm2, %xmm1
; X64-XOP-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; X64-XOP-NEXT:    vpsubw %xmm1, %xmm2, %xmm1
; X64-XOP-NEXT:    vpsllw $3, %xmm0, %xmm3
; X64-XOP-NEXT:    vpaddw %xmm0, %xmm3, %xmm0
; X64-XOP-NEXT:    vpsubw %xmm0, %xmm2, %xmm0
; X64-XOP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; X64-XOP-NEXT:    retq
;
; X64-AVX2-LABEL: mul_v16i16_neg9:
; X64-AVX2:       # %bb.0:
; X64-AVX2-NEXT:    vpsllw $3, %ymm0, %ymm1
; X64-AVX2-NEXT:    vpaddw %ymm1, %ymm0, %ymm0
; X64-AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; X64-AVX2-NEXT:    vpsubw %ymm0, %ymm1, %ymm0
; X64-AVX2-NEXT:    retq
;
; X64-AVX512DQ-LABEL: mul_v16i16_neg9:
; X64-AVX512DQ:       # %bb.0:
; X64-AVX512DQ-NEXT:    vpsllw $3, %ymm0, %ymm1
; X64-AVX512DQ-NEXT:    vpaddw %ymm1, %ymm0, %ymm0
; X64-AVX512DQ-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; X64-AVX512DQ-NEXT:    vpsubw %ymm0, %ymm1, %ymm0
; X64-AVX512DQ-NEXT:    retq
  %1 = mul <16 x i16> %a0, <i16 -9, i16 -9, i16 -9, i16 -9, i16 -9, i16 -9, i16 -9, i16 -9, i16 -9, i16 -9, i16 -9, i16 -9, i16 -9, i16 -9, i16 -9, i16 -9>
  ret <16 x i16> %1
}

define <32 x i8> @mul_v32i8_neg5(<32 x i8> %a0) nounwind {
; SSE-LABEL: mul_v32i8_neg5:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa %xmm0, %xmm3
; SSE-NEXT:    psllw $2, %xmm3
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252]
; SSE-NEXT:    pand %xmm4, %xmm3
; SSE-NEXT:    paddb %xmm0, %xmm3
; SSE-NEXT:    pxor %xmm2, %xmm2
; SSE-NEXT:    pxor %xmm0, %xmm0
; SSE-NEXT:    psubb %xmm3, %xmm0
; SSE-NEXT:    movdqa %xmm1, %xmm3
; SSE-NEXT:    psllw $2, %xmm3
; SSE-NEXT:    pand %xmm4, %xmm3
; SSE-NEXT:    paddb %xmm1, %xmm3
; SSE-NEXT:    psubb %xmm3, %xmm2
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    ret{{[l|q]}}
;
; X64-XOP-LABEL: mul_v32i8_neg5:
; X64-XOP:       # %bb.0:
; X64-XOP-NEXT:    vextractf128 $1, %ymm0, %xmm1
; X64-XOP-NEXT:    vbroadcastss {{.*#+}} xmm2 = [2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2]
; X64-XOP-NEXT:    vpshlb %xmm2, %xmm1, %xmm3
; X64-XOP-NEXT:    vpaddb %xmm1, %xmm3, %xmm1
; X64-XOP-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; X64-XOP-NEXT:    vpsubb %xmm1, %xmm3, %xmm1
; X64-XOP-NEXT:    vpshlb %xmm2, %xmm0, %xmm2
; X64-XOP-NEXT:    vpaddb %xmm0, %xmm2, %xmm0
; X64-XOP-NEXT:    vpsubb %xmm0, %xmm3, %xmm0
; X64-XOP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; X64-XOP-NEXT:    retq
;
; X64-AVX2-LABEL: mul_v32i8_neg5:
; X64-AVX2:       # %bb.0:
; X64-AVX2-NEXT:    vpsllw $2, %ymm0, %ymm1
; X64-AVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1
; X64-AVX2-NEXT:    vpaddb %ymm0, %ymm1, %ymm0
; X64-AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; X64-AVX2-NEXT:    vpsubb %ymm0, %ymm1, %ymm0
; X64-AVX2-NEXT:    retq
;
; X64-AVX512DQ-LABEL: mul_v32i8_neg5:
; X64-AVX512DQ:       # %bb.0:
; X64-AVX512DQ-NEXT:    vpsllw $2, %ymm0, %ymm1
; X64-AVX512DQ-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %ymm1, %ymm1
; X64-AVX512DQ-NEXT:    vpaddb %ymm0, %ymm1, %ymm0
; X64-AVX512DQ-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; X64-AVX512DQ-NEXT:    vpsubb %ymm0, %ymm1, %ymm0
; X64-AVX512DQ-NEXT:    retq
  %1 = mul <32 x i8> %a0, <i8 -5, i8 -5, i8 -5, i8 -5, i8 -5, i8 -5, i8 -5, i8 -5, i8 -5, i8 -5, i8 -5, i8 -5, i8 -5, i8 -5, i8 -5, i8 -5, i8 -5, i8 -5, i8 -5, i8 -5, i8 -5, i8 -5, i8 -5, i8 -5, i8 -5, i8 -5, i8 -5, i8 -5, i8 -5, i8 -5, i8 -5, i8 -5>
  ret <32 x i8> %1
}

;
; PowOf2 + 1 (non-uniform)
;

define <2 x i64> @mul_v2i64_17_65(<2 x i64> %a0) nounwind {
; X86-SSE2-LABEL: mul_v2i64_17_65:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    movdqa {{.*#+}} xmm1 = [17,0,65,0]
; X86-SSE2-NEXT:    movdqa %xmm0, %xmm2
; X86-SSE2-NEXT:    pmuludq %xmm1, %xmm2
; X86-SSE2-NEXT:    psrlq $32, %xmm0
; X86-SSE2-NEXT:    pmuludq %xmm1, %xmm0
; X86-SSE2-NEXT:    psllq $32, %xmm0
; X86-SSE2-NEXT:    paddq %xmm2, %xmm0
; X86-SSE2-NEXT:    retl
;
; SSE4-LABEL: mul_v2i64_17_65:
; SSE4:       # %bb.0:
; SSE4-NEXT:    pmovsxbq {{.*#+}} xmm1 = [17,65]
; SSE4-NEXT:    movdqa %xmm0, %xmm2
; SSE4-NEXT:    pmuludq %xmm1, %xmm2
; SSE4-NEXT:    psrlq $32, %xmm0
; SSE4-NEXT:    pmuludq %xmm1, %xmm0
; SSE4-NEXT:    psllq $32, %xmm0
; SSE4-NEXT:    paddq %xmm2, %xmm0
; SSE4-NEXT:    ret{{[l|q]}}
;
; X64-SSE2-LABEL: mul_v2i64_17_65:
; X64-SSE2:       # %bb.0:
; X64-SSE2-NEXT:    movdqa {{.*#+}} xmm1 = [17,65]
; X64-SSE2-NEXT:    movdqa %xmm0, %xmm2
; X64-SSE2-NEXT:    pmuludq %xmm1, %xmm2
; X64-SSE2-NEXT:    psrlq $32, %xmm0
; X64-SSE2-NEXT:    pmuludq %xmm1, %xmm0
; X64-SSE2-NEXT:    psllq $32, %xmm0
; X64-SSE2-NEXT:    paddq %xmm2, %xmm0
; X64-SSE2-NEXT:    retq
;
; X64-XOP-LABEL: mul_v2i64_17_65:
; X64-XOP:       # %bb.0:
; X64-XOP-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [17,65]
; X64-XOP-NEXT:    vpmuludq %xmm1, %xmm0, %xmm2
; X64-XOP-NEXT:    vpsrlq $32, %xmm0, %xmm0
; X64-XOP-NEXT:    vpmuludq %xmm1, %xmm0, %xmm0
; X64-XOP-NEXT:    vpsllq $32, %xmm0, %xmm0
; X64-XOP-NEXT:    vpaddq %xmm0, %xmm2, %xmm0
; X64-XOP-NEXT:    retq
;
; X64-AVX2-LABEL: mul_v2i64_17_65:
; X64-AVX2:       # %bb.0:
; X64-AVX2-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [17,65]
; X64-AVX2-NEXT:    vpmuludq %xmm1, %xmm0, %xmm2
; X64-AVX2-NEXT:    vpsrlq $32, %xmm0, %xmm0
; X64-AVX2-NEXT:    vpmuludq %xmm1, %xmm0, %xmm0
; X64-AVX2-NEXT:    vpsllq $32, %xmm0, %xmm0
; X64-AVX2-NEXT:    vpaddq %xmm0, %xmm2, %xmm0
; X64-AVX2-NEXT:    retq
;
; X64-AVX512DQ-LABEL: mul_v2i64_17_65:
; X64-AVX512DQ:       # %bb.0:
; X64-AVX512DQ-NEXT:    vpmullq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; X64-AVX512DQ-NEXT:    retq
  %1 = mul <2 x i64> %a0, <i64 17, i64 65>
  ret <2 x i64> %1
}

define <4 x i32> @mul_v4i32_5_17_33_65(<4 x i32> %a0) nounwind {
; X86-SSE2-LABEL: mul_v4i32_5_17_33_65:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[1,1,3,3]
; X86-SSE2-NEXT:    pmuludq {{\.?LCPI[0-9]+_[0-9]+}}, %xmm0
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; X86-SSE2-NEXT:    pmuludq {{\.?LCPI[0-9]+_[0-9]+}}, %xmm1
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; X86-SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; X86-SSE2-NEXT:    retl
;
; X86-SSE4-LABEL: mul_v4i32_5_17_33_65:
; X86-SSE4:       # %bb.0:
; X86-SSE4-NEXT:    pmulld {{\.?LCPI[0-9]+_[0-9]+}}, %xmm0
; X86-SSE4-NEXT:    retl
;
; X64-SSE2-LABEL: mul_v4i32_5_17_33_65:
; X64-SSE2:       # %bb.0:
; X64-SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[1,1,3,3]
; X64-SSE2-NEXT:    pmuludq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; X64-SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; X64-SSE2-NEXT:    pmuludq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1
; X64-SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; X64-SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; X64-SSE2-NEXT:    retq
;
; X64-SSE4-LABEL: mul_v4i32_5_17_33_65:
; X64-SSE4:       # %bb.0:
; X64-SSE4-NEXT:    pmulld {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; X64-SSE4-NEXT:    retq
;
; X64-AVX-LABEL: mul_v4i32_5_17_33_65:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vpmulld {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; X64-AVX-NEXT:    retq
  %1 = mul <4 x i32> %a0, <i32 5, i32 17, i32 33, i32 65>
  ret <4 x i32> %1
}

define <8 x i16> @mul_v8i16_2_3_9_17_33_65_129_257(<8 x i16> %a0) nounwind {
; X86-SSE-LABEL: mul_v8i16_2_3_9_17_33_65_129_257:
; X86-SSE:       # %bb.0:
; X86-SSE-NEXT:    pmullw {{\.?LCPI[0-9]+_[0-9]+}}, %xmm0 # [2,3,9,17,33,65,129,257]
; X86-SSE-NEXT:    retl
;
; X64-SSE-LABEL: mul_v8i16_2_3_9_17_33_65_129_257:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    pmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0 # [2,3,9,17,33,65,129,257]
; X64-SSE-NEXT:    retq
;
; X64-AVX-LABEL: mul_v8i16_2_3_9_17_33_65_129_257:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0 # [2,3,9,17,33,65,129,257]
; X64-AVX-NEXT:    retq
  %1 = mul <8 x i16> %a0, <i16 2, i16 3, i16 9, i16 17, i16 33, i16 65, i16 129, i16 257>
  ret <8 x i16> %1
}

define <16 x i8> @mul_v16i8_2_3_9_17_33_65_129_2_3_9_17_33_65_129_2_3(<16 x i8> %a0) nounwind {
; X86-SSE2-LABEL: mul_v16i8_2_3_9_17_33_65_129_2_3_9_17_33_65_129_2_3:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    movdqa %xmm0, %xmm1
; X86-SSE2-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; X86-SSE2-NEXT:    pmullw {{\.?LCPI[0-9]+_[0-9]+}}, %xmm1 # [3,9,17,33,65,129,2,3]
; X86-SSE2-NEXT:    movdqa {{.*#+}} xmm2 = [255,255,255,255,255,255,255,255]
; X86-SSE2-NEXT:    pand %xmm2, %xmm1
; X86-SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; X86-SSE2-NEXT:    pmullw {{\.?LCPI[0-9]+_[0-9]+}}, %xmm0 # [2,3,9,17,33,65,129,2]
; X86-SSE2-NEXT:    pand %xmm2, %xmm0
; X86-SSE2-NEXT:    packuswb %xmm1, %xmm0
; X86-SSE2-NEXT:    retl
;
; X86-SSE4-LABEL: mul_v16i8_2_3_9_17_33_65_129_2_3_9_17_33_65_129_2_3:
; X86-SSE4:       # %bb.0:
; X86-SSE4-NEXT:    movdqa %xmm0, %xmm1
; X86-SSE4-NEXT:    pmaddubsw {{\.?LCPI[0-9]+_[0-9]+}}, %xmm1 # [0,3,0,17,0,65,0,2,0,9,0,33,0,129,0,3]
; X86-SSE4-NEXT:    psllw $8, %xmm1
; X86-SSE4-NEXT:    pmaddubsw {{\.?LCPI[0-9]+_[0-9]+}}, %xmm0 # [2,0,9,0,33,0,129,0,3,0,17,0,65,0,2,0]
; X86-SSE4-NEXT:    pand {{\.?LCPI[0-9]+_[0-9]+}}, %xmm0
; X86-SSE4-NEXT:    por %xmm1, %xmm0
; X86-SSE4-NEXT:    retl
;
; X64-SSE2-LABEL: mul_v16i8_2_3_9_17_33_65_129_2_3_9_17_33_65_129_2_3:
; X64-SSE2:       # %bb.0:
; X64-SSE2-NEXT:    movdqa %xmm0, %xmm1
; X64-SSE2-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; X64-SSE2-NEXT:    pmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1 # [3,9,17,33,65,129,2,3]
; X64-SSE2-NEXT:    movdqa {{.*#+}} xmm2 = [255,255,255,255,255,255,255,255]
; X64-SSE2-NEXT:    pand %xmm2, %xmm1
; X64-SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; X64-SSE2-NEXT:    pmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0 # [2,3,9,17,33,65,129,2]
; X64-SSE2-NEXT:    pand %xmm2, %xmm0
; X64-SSE2-NEXT:    packuswb %xmm1, %xmm0
; X64-SSE2-NEXT:    retq
;
; X64-SSE4-LABEL: mul_v16i8_2_3_9_17_33_65_129_2_3_9_17_33_65_129_2_3:
; X64-SSE4:       # %bb.0:
; X64-SSE4-NEXT:    movdqa %xmm0, %xmm1
; X64-SSE4-NEXT:    pmaddubsw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1 # [0,3,0,17,0,65,0,2,0,9,0,33,0,129,0,3]
; X64-SSE4-NEXT:    psllw $8, %xmm1
; X64-SSE4-NEXT:    pmaddubsw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0 # [2,0,9,0,33,0,129,0,3,0,17,0,65,0,2,0]
; X64-SSE4-NEXT:    pand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; X64-SSE4-NEXT:    por %xmm1, %xmm0
; X64-SSE4-NEXT:    retq
;
; X64-XOP-LABEL: mul_v16i8_2_3_9_17_33_65_129_2_3_9_17_33_65_129_2_3:
; X64-XOP:       # %bb.0:
; X64-XOP-NEXT:    vpmaddubsw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm1 # [0,3,0,17,0,65,0,2,0,9,0,33,0,129,0,3]
; X64-XOP-NEXT:    vpmaddubsw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0 # [2,0,9,0,33,0,129,0,3,0,17,0,65,0,2,0]
; X64-XOP-NEXT:    vpperm {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[2],xmm1[2],xmm0[4],xmm1[4],xmm0[6],xmm1[6],xmm0[8],xmm1[8],xmm0[10],xmm1[10],xmm0[12],xmm1[12],xmm0[14],xmm1[14]
; X64-XOP-NEXT:    retq
;
; X64-AVX2-LABEL: mul_v16i8_2_3_9_17_33_65_129_2_3_9_17_33_65_129_2_3:
; X64-AVX2:       # %bb.0:
; X64-AVX2-NEXT:    vpmovzxbw {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero,xmm0[8],zero,xmm0[9],zero,xmm0[10],zero,xmm0[11],zero,xmm0[12],zero,xmm0[13],zero,xmm0[14],zero,xmm0[15],zero
; X64-AVX2-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0 # [2,3,9,17,33,65,129,2,3,9,17,33,65,129,2,3]
; X64-AVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; X64-AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; X64-AVX2-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; X64-AVX2-NEXT:    vzeroupper
; X64-AVX2-NEXT:    retq
;
; X64-AVX512DQ-LABEL: mul_v16i8_2_3_9_17_33_65_129_2_3_9_17_33_65_129_2_3:
; X64-AVX512DQ:       # %bb.0:
; X64-AVX512DQ-NEXT:    vpmovzxbw {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero,xmm0[8],zero,xmm0[9],zero,xmm0[10],zero,xmm0[11],zero,xmm0[12],zero,xmm0[13],zero,xmm0[14],zero,xmm0[15],zero
; X64-AVX512DQ-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0 # [2,3,9,17,33,65,129,2,3,9,17,33,65,129,2,3]
; X64-AVX512DQ-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; X64-AVX512DQ-NEXT:    vpmovdb %zmm0, %xmm0
; X64-AVX512DQ-NEXT:    vzeroupper
; X64-AVX512DQ-NEXT:    retq
  %1 = mul <16 x i8> %a0, <i8 2, i8 3, i8 9, i8 17, i8 33, i8 65, i8 129, i8 2, i8 3, i8 9, i8 17, i8 33, i8 65, i8 129, i8 2, i8 3>
  ret <16 x i8> %1
}

;
; PowOf2 - 1 (uniform)
;

define <2 x i64> @mul_v2i64_7(<2 x i64> %a0) nounwind {
; SSE-LABEL: mul_v2i64_7:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa %xmm0, %xmm1
; SSE-NEXT:    psllq $3, %xmm1
; SSE-NEXT:    psubq %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; X64-AVX-LABEL: mul_v2i64_7:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vpsllq $3, %xmm0, %xmm1
; X64-AVX-NEXT:    vpsubq %xmm0, %xmm1, %xmm0
; X64-AVX-NEXT:    retq
  %1 = mul <2 x i64> %a0, <i64 7, i64 7>
  ret <2 x i64> %1
}

define <4 x i32> @mul_v4i32_7(<4 x i32> %a0) nounwind {
; SSE-LABEL: mul_v4i32_7:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa %xmm0, %xmm1
; SSE-NEXT:    pslld $3, %xmm1
; SSE-NEXT:    psubd %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; X64-XOP-LABEL: mul_v4i32_7:
; X64-XOP:       # %bb.0:
; X64-XOP-NEXT:    vpslld $3, %xmm0, %xmm1
; X64-XOP-NEXT:    vpsubd %xmm0, %xmm1, %xmm0
; X64-XOP-NEXT:    retq
;
; X64-AVX2-LABEL: mul_v4i32_7:
; X64-AVX2:       # %bb.0:
; X64-AVX2-NEXT:    vpbroadcastd {{.*#+}} xmm1 = [7,7,7,7]
; X64-AVX2-NEXT:    vpmulld %xmm1, %xmm0, %xmm0
; X64-AVX2-NEXT:    retq
;
; X64-AVX512DQ-LABEL: mul_v4i32_7:
; X64-AVX512DQ:       # %bb.0:
; X64-AVX512DQ-NEXT:    vpmulld {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %xmm0, %xmm0
; X64-AVX512DQ-NEXT:    retq
  %1 = mul <4 x i32> %a0, <i32 7, i32 7, i32 7, i32 7>
  ret <4 x i32> %1
}

define <8 x i16> @mul_v8i16_7(<8 x i16> %a0) nounwind {
; SSE-LABEL: mul_v8i16_7:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa %xmm0, %xmm1
; SSE-NEXT:    psllw $3, %xmm1
; SSE-NEXT:    psubw %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; X64-AVX-LABEL: mul_v8i16_7:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vpsllw $3, %xmm0, %xmm1
; X64-AVX-NEXT:    vpsubw %xmm0, %xmm1, %xmm0
; X64-AVX-NEXT:    retq
  %1 = mul <8 x i16> %a0, <i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7>
  ret <8 x i16> %1
}

define <16 x i8> @mul_v16i8_31(<16 x i8> %a0) nounwind {
; X86-SSE-LABEL: mul_v16i8_31:
; X86-SSE:       # %bb.0:
; X86-SSE-NEXT:    movdqa %xmm0, %xmm1
; X86-SSE-NEXT:    psllw $5, %xmm1
; X86-SSE-NEXT:    pand {{\.?LCPI[0-9]+_[0-9]+}}, %xmm1
; X86-SSE-NEXT:    psubb %xmm0, %xmm1
; X86-SSE-NEXT:    movdqa %xmm1, %xmm0
; X86-SSE-NEXT:    retl
;
; X64-SSE-LABEL: mul_v16i8_31:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    movdqa %xmm0, %xmm1
; X64-SSE-NEXT:    psllw $5, %xmm1
; X64-SSE-NEXT:    pand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1
; X64-SSE-NEXT:    psubb %xmm0, %xmm1
; X64-SSE-NEXT:    movdqa %xmm1, %xmm0
; X64-SSE-NEXT:    retq
;
; X64-XOP-LABEL: mul_v16i8_31:
; X64-XOP:       # %bb.0:
; X64-XOP-NEXT:    vpshlb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm1
; X64-XOP-NEXT:    vpsubb %xmm0, %xmm1, %xmm0
; X64-XOP-NEXT:    retq
;
; X64-AVX2-LABEL: mul_v16i8_31:
; X64-AVX2:       # %bb.0:
; X64-AVX2-NEXT:    vpsllw $5, %xmm0, %xmm1
; X64-AVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm1
; X64-AVX2-NEXT:    vpsubb %xmm0, %xmm1, %xmm0
; X64-AVX2-NEXT:    retq
;
; X64-AVX512DQ-LABEL: mul_v16i8_31:
; X64-AVX512DQ:       # %bb.0:
; X64-AVX512DQ-NEXT:    vpsllw $5, %xmm0, %xmm1
; X64-AVX512DQ-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %xmm1, %xmm1
; X64-AVX512DQ-NEXT:    vpsubb %xmm0, %xmm1, %xmm0
; X64-AVX512DQ-NEXT:    retq
  %1 = mul <16 x i8> %a0, <i8 31, i8 31, i8 31, i8 31, i8 31, i8 31, i8 31, i8 31, i8 31, i8 31, i8 31, i8 31, i8 31, i8 31, i8 31, i8 31>
  ret <16 x i8> %1
}

;
; -(PowOf2 - 1) (uniform)
;

define <2 x i64> @mul_v2i64_neg7(<2 x i64> %a0) nounwind {
; SSE-LABEL: mul_v2i64_neg7:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa %xmm0, %xmm1
; SSE-NEXT:    psllq $3, %xmm1
; SSE-NEXT:    psubq %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; X64-AVX-LABEL: mul_v2i64_neg7:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vpsllq $3, %xmm0, %xmm1
; X64-AVX-NEXT:    vpsubq %xmm1, %xmm0, %xmm0
; X64-AVX-NEXT:    retq
  %1 = mul <2 x i64> %a0, <i64 -7, i64 -7>
  ret <2 x i64> %1
}

define <4 x i32> @mul_v4i32_neg63(<4 x i32> %a0) nounwind {
; SSE-LABEL: mul_v4i32_neg63:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa %xmm0, %xmm1
; SSE-NEXT:    pslld $6, %xmm1
; SSE-NEXT:    psubd %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; X64-XOP-LABEL: mul_v4i32_neg63:
; X64-XOP:       # %bb.0:
; X64-XOP-NEXT:    vpslld $6, %xmm0, %xmm1
; X64-XOP-NEXT:    vpsubd %xmm1, %xmm0, %xmm0
; X64-XOP-NEXT:    retq
;
; X64-AVX2-LABEL: mul_v4i32_neg63:
; X64-AVX2:       # %bb.0:
; X64-AVX2-NEXT:    vpbroadcastd {{.*#+}} xmm1 = [4294967233,4294967233,4294967233,4294967233]
; X64-AVX2-NEXT:    vpmulld %xmm1, %xmm0, %xmm0
; X64-AVX2-NEXT:    retq
;
; X64-AVX512DQ-LABEL: mul_v4i32_neg63:
; X64-AVX512DQ:       # %bb.0:
; X64-AVX512DQ-NEXT:    vpmulld {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %xmm0, %xmm0
; X64-AVX512DQ-NEXT:    retq
  %1 = mul <4 x i32> %a0, <i32 -63, i32 -63, i32 -63, i32 -63>
  ret <4 x i32> %1
}

define <8 x i16> @mul_v8i16_neg31(<8 x i16> %a0) nounwind {
; SSE-LABEL: mul_v8i16_neg31:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa %xmm0, %xmm1
; SSE-NEXT:    psllw $5, %xmm1
; SSE-NEXT:    psubw %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; X64-AVX-LABEL: mul_v8i16_neg31:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vpsllw $5, %xmm0, %xmm1
; X64-AVX-NEXT:    vpsubw %xmm1, %xmm0, %xmm0
; X64-AVX-NEXT:    retq
  %1 = mul <8 x i16> %a0, <i16 -31, i16 -31, i16 -31, i16 -31, i16 -31, i16 -31, i16 -31, i16 -31>
  ret <8 x i16> %1
}

define <16 x i8> @mul_v16i8_neg15(<16 x i8> %a0) nounwind {
; X86-SSE-LABEL: mul_v16i8_neg15:
; X86-SSE:       # %bb.0:
; X86-SSE-NEXT:    movdqa %xmm0, %xmm1
; X86-SSE-NEXT:    psllw $4, %xmm1
; X86-SSE-NEXT:    pand {{\.?LCPI[0-9]+_[0-9]+}}, %xmm1
; X86-SSE-NEXT:    psubb %xmm1, %xmm0
; X86-SSE-NEXT:    retl
;
; X64-SSE-LABEL: mul_v16i8_neg15:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    movdqa %xmm0, %xmm1
; X64-SSE-NEXT:    psllw $4, %xmm1
; X64-SSE-NEXT:    pand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1
; X64-SSE-NEXT:    psubb %xmm1, %xmm0
; X64-SSE-NEXT:    retq
;
; X64-XOP-LABEL: mul_v16i8_neg15:
; X64-XOP:       # %bb.0:
; X64-XOP-NEXT:    vpshlb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm1
; X64-XOP-NEXT:    vpsubb %xmm1, %xmm0, %xmm0
; X64-XOP-NEXT:    retq
;
; X64-AVX2-LABEL: mul_v16i8_neg15:
; X64-AVX2:       # %bb.0:
; X64-AVX2-NEXT:    vpsllw $4, %xmm0, %xmm1
; X64-AVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm1
; X64-AVX2-NEXT:    vpsubb %xmm1, %xmm0, %xmm0
; X64-AVX2-NEXT:    retq
;
; X64-AVX512DQ-LABEL: mul_v16i8_neg15:
; X64-AVX512DQ:       # %bb.0:
; X64-AVX512DQ-NEXT:    vpsllw $4, %xmm0, %xmm1
; X64-AVX512DQ-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %xmm1, %xmm1
; X64-AVX512DQ-NEXT:    vpsubb %xmm1, %xmm0, %xmm0
; X64-AVX512DQ-NEXT:    retq
  %1 = mul <16 x i8> %a0, <i8 -15, i8 -15, i8 -15, i8 -15, i8 -15, i8 -15, i8 -15, i8 -15, i8 -15, i8 -15, i8 -15, i8 -15, i8 -15, i8 -15, i8 -15, i8 -15>
  ret <16 x i8> %1
}

;
; PowOf2 - 1 (non-uniform)
;

define <2 x i64> @mul_v2i64_15_63(<2 x i64> %a0) nounwind {
; X86-SSE2-LABEL: mul_v2i64_15_63:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    movdqa {{.*#+}} xmm1 = [15,0,63,0]
; X86-SSE2-NEXT:    movdqa %xmm0, %xmm2
; X86-SSE2-NEXT:    pmuludq %xmm1, %xmm2
; X86-SSE2-NEXT:    psrlq $32, %xmm0
; X86-SSE2-NEXT:    pmuludq %xmm1, %xmm0
; X86-SSE2-NEXT:    psllq $32, %xmm0
; X86-SSE2-NEXT:    paddq %xmm2, %xmm0
; X86-SSE2-NEXT:    retl
;
; SSE4-LABEL: mul_v2i64_15_63:
; SSE4:       # %bb.0:
; SSE4-NEXT:    pmovsxbq {{.*#+}} xmm1 = [15,63]
; SSE4-NEXT:    movdqa %xmm0, %xmm2
; SSE4-NEXT:    pmuludq %xmm1, %xmm2
; SSE4-NEXT:    psrlq $32, %xmm0
; SSE4-NEXT:    pmuludq %xmm1, %xmm0
; SSE4-NEXT:    psllq $32, %xmm0
; SSE4-NEXT:    paddq %xmm2, %xmm0
; SSE4-NEXT:    ret{{[l|q]}}
;
; X64-SSE2-LABEL: mul_v2i64_15_63:
; X64-SSE2:       # %bb.0:
; X64-SSE2-NEXT:    movdqa {{.*#+}} xmm1 = [15,63]
; X64-SSE2-NEXT:    movdqa %xmm0, %xmm2
; X64-SSE2-NEXT:    pmuludq %xmm1, %xmm2
; X64-SSE2-NEXT:    psrlq $32, %xmm0
; X64-SSE2-NEXT:    pmuludq %xmm1, %xmm0
; X64-SSE2-NEXT:    psllq $32, %xmm0
; X64-SSE2-NEXT:    paddq %xmm2, %xmm0
; X64-SSE2-NEXT:    retq
;
; X64-XOP-LABEL: mul_v2i64_15_63:
; X64-XOP:       # %bb.0:
; X64-XOP-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [15,63]
; X64-XOP-NEXT:    vpmuludq %xmm1, %xmm0, %xmm2
; X64-XOP-NEXT:    vpsrlq $32, %xmm0, %xmm0
; X64-XOP-NEXT:    vpmuludq %xmm1, %xmm0, %xmm0
; X64-XOP-NEXT:    vpsllq $32, %xmm0, %xmm0
; X64-XOP-NEXT:    vpaddq %xmm0, %xmm2, %xmm0
; X64-XOP-NEXT:    retq
;
; X64-AVX2-LABEL: mul_v2i64_15_63:
; X64-AVX2:       # %bb.0:
; X64-AVX2-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [15,63]
; X64-AVX2-NEXT:    vpmuludq %xmm1, %xmm0, %xmm2
; X64-AVX2-NEXT:    vpsrlq $32, %xmm0, %xmm0
; X64-AVX2-NEXT:    vpmuludq %xmm1, %xmm0, %xmm0
; X64-AVX2-NEXT:    vpsllq $32, %xmm0, %xmm0
; X64-AVX2-NEXT:    vpaddq %xmm0, %xmm2, %xmm0
; X64-AVX2-NEXT:    retq
;
; X64-AVX512DQ-LABEL: mul_v2i64_15_63:
; X64-AVX512DQ:       # %bb.0:
; X64-AVX512DQ-NEXT:    vpmullq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; X64-AVX512DQ-NEXT:    retq
  %1 = mul <2 x i64> %a0, <i64 15, i64 63>
  ret <2 x i64> %1
}

define <2 x i64> @mul_v2i64_neg_15_63(<2 x i64> %a0) nounwind {
; X86-SSE2-LABEL: mul_v2i64_neg_15_63:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    pcmpeqd %xmm1, %xmm1
; X86-SSE2-NEXT:    pmuludq %xmm0, %xmm1
; X86-SSE2-NEXT:    movdqa %xmm0, %xmm2
; X86-SSE2-NEXT:    psrlq $32, %xmm2
; X86-SSE2-NEXT:    movdqa {{.*#+}} xmm3 = [4294967281,4294967295,4294967233,4294967295]
; X86-SSE2-NEXT:    pmuludq %xmm3, %xmm2
; X86-SSE2-NEXT:    paddq %xmm1, %xmm2
; X86-SSE2-NEXT:    psllq $32, %xmm2
; X86-SSE2-NEXT:    pmuludq %xmm3, %xmm0
; X86-SSE2-NEXT:    paddq %xmm2, %xmm0
; X86-SSE2-NEXT:    retl
;
; X86-SSE4-LABEL: mul_v2i64_neg_15_63:
; X86-SSE4:       # %bb.0:
; X86-SSE4-NEXT:    pcmpeqd %xmm1, %xmm1
; X86-SSE4-NEXT:    pmuludq %xmm0, %xmm1
; X86-SSE4-NEXT:    movdqa %xmm0, %xmm2
; X86-SSE4-NEXT:    psrlq $32, %xmm2
; X86-SSE4-NEXT:    pmovsxbq {{.*#+}} xmm3 = [18446744073709551601,18446744073709551553]
; X86-SSE4-NEXT:    pmuludq %xmm3, %xmm2
; X86-SSE4-NEXT:    paddq %xmm1, %xmm2
; X86-SSE4-NEXT:    psllq $32, %xmm2
; X86-SSE4-NEXT:    pmuludq %xmm3, %xmm0
; X86-SSE4-NEXT:    paddq %xmm2, %xmm0
; X86-SSE4-NEXT:    retl
;
; X64-SSE2-LABEL: mul_v2i64_neg_15_63:
; X64-SSE2:       # %bb.0:
; X64-SSE2-NEXT:    movdqa {{.*#+}} xmm1 = [18446744073709551601,18446744073709551553]
; X64-SSE2-NEXT:    movdqa %xmm0, %xmm2
; X64-SSE2-NEXT:    pmuludq %xmm1, %xmm2
; X64-SSE2-NEXT:    movdqa %xmm0, %xmm3
; X64-SSE2-NEXT:    psrlq $32, %xmm3
; X64-SSE2-NEXT:    pmuludq %xmm1, %xmm3
; X64-SSE2-NEXT:    pmuludq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; X64-SSE2-NEXT:    paddq %xmm3, %xmm0
; X64-SSE2-NEXT:    psllq $32, %xmm0
; X64-SSE2-NEXT:    paddq %xmm2, %xmm0
; X64-SSE2-NEXT:    retq
;
; X64-SSE4-LABEL: mul_v2i64_neg_15_63:
; X64-SSE4:       # %bb.0:
; X64-SSE4-NEXT:    pmovsxbq {{.*#+}} xmm1 = [18446744073709551601,18446744073709551553]
; X64-SSE4-NEXT:    movdqa %xmm0, %xmm2
; X64-SSE4-NEXT:    pmuludq %xmm1, %xmm2
; X64-SSE4-NEXT:    movdqa %xmm0, %xmm3
; X64-SSE4-NEXT:    psrlq $32, %xmm3
; X64-SSE4-NEXT:    pmuludq %xmm1, %xmm3
; X64-SSE4-NEXT:    pmuludq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; X64-SSE4-NEXT:    paddq %xmm3, %xmm0
; X64-SSE4-NEXT:    psllq $32, %xmm0
; X64-SSE4-NEXT:    paddq %xmm2, %xmm0
; X64-SSE4-NEXT:    retq
;
; X64-XOP-LABEL: mul_v2i64_neg_15_63:
; X64-XOP:       # %bb.0:
; X64-XOP-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [18446744073709551601,18446744073709551553]
; X64-XOP-NEXT:    vpmuludq %xmm1, %xmm0, %xmm2
; X64-XOP-NEXT:    vpsrlq $32, %xmm0, %xmm3
; X64-XOP-NEXT:    vpmuludq %xmm1, %xmm3, %xmm1
; X64-XOP-NEXT:    vpmuludq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; X64-XOP-NEXT:    vpaddq %xmm1, %xmm0, %xmm0
; X64-XOP-NEXT:    vpsllq $32, %xmm0, %xmm0
; X64-XOP-NEXT:    vpaddq %xmm0, %xmm2, %xmm0
; X64-XOP-NEXT:    retq
;
; X64-AVX2-LABEL: mul_v2i64_neg_15_63:
; X64-AVX2:       # %bb.0:
; X64-AVX2-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [18446744073709551601,18446744073709551553]
; X64-AVX2-NEXT:    vpmuludq %xmm1, %xmm0, %xmm2
; X64-AVX2-NEXT:    vpsrlq $32, %xmm0, %xmm3
; X64-AVX2-NEXT:    vpmuludq %xmm1, %xmm3, %xmm1
; X64-AVX2-NEXT:    vpmuludq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; X64-AVX2-NEXT:    vpaddq %xmm1, %xmm0, %xmm0
; X64-AVX2-NEXT:    vpsllq $32, %xmm0, %xmm0
; X64-AVX2-NEXT:    vpaddq %xmm0, %xmm2, %xmm0
; X64-AVX2-NEXT:    retq
;
; X64-AVX512DQ-LABEL: mul_v2i64_neg_15_63:
; X64-AVX512DQ:       # %bb.0:
; X64-AVX512DQ-NEXT:    vpmullq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; X64-AVX512DQ-NEXT:    retq
  %1 = mul <2 x i64> %a0, <i64 -15, i64 -63>
  ret <2 x i64> %1
}

define <2 x i64> @mul_v2i64_neg_17_65(<2 x i64> %a0) nounwind {
; X86-SSE2-LABEL: mul_v2i64_neg_17_65:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    pcmpeqd %xmm1, %xmm1
; X86-SSE2-NEXT:    pmuludq %xmm0, %xmm1
; X86-SSE2-NEXT:    movdqa %xmm0, %xmm2
; X86-SSE2-NEXT:    psrlq $32, %xmm2
; X86-SSE2-NEXT:    movdqa {{.*#+}} xmm3 = [4294967279,4294967295,4294967231,4294967295]
; X86-SSE2-NEXT:    pmuludq %xmm3, %xmm2
; X86-SSE2-NEXT:    paddq %xmm1, %xmm2
; X86-SSE2-NEXT:    psllq $32, %xmm2
; X86-SSE2-NEXT:    pmuludq %xmm3, %xmm0
; X86-SSE2-NEXT:    paddq %xmm2, %xmm0
; X86-SSE2-NEXT:    retl
;
; X86-SSE4-LABEL: mul_v2i64_neg_17_65:
; X86-SSE4:       # %bb.0:
; X86-SSE4-NEXT:    pcmpeqd %xmm1, %xmm1
; X86-SSE4-NEXT:    pmuludq %xmm0, %xmm1
; X86-SSE4-NEXT:    movdqa %xmm0, %xmm2
; X86-SSE4-NEXT:    psrlq $32, %xmm2
; X86-SSE4-NEXT:    pmovsxbq {{.*#+}} xmm3 = [18446744073709551599,18446744073709551551]
; X86-SSE4-NEXT:    pmuludq %xmm3, %xmm2
; X86-SSE4-NEXT:    paddq %xmm1, %xmm2
; X86-SSE4-NEXT:    psllq $32, %xmm2
; X86-SSE4-NEXT:    pmuludq %xmm3, %xmm0
; X86-SSE4-NEXT:    paddq %xmm2, %xmm0
; X86-SSE4-NEXT:    retl
;
; X64-SSE2-LABEL: mul_v2i64_neg_17_65:
; X64-SSE2:       # %bb.0:
; X64-SSE2-NEXT:    movdqa {{.*#+}} xmm1 = [18446744073709551599,18446744073709551551]
; X64-SSE2-NEXT:    movdqa %xmm0, %xmm2
; X64-SSE2-NEXT:    pmuludq %xmm1, %xmm2
; X64-SSE2-NEXT:    movdqa %xmm0, %xmm3
; X64-SSE2-NEXT:    psrlq $32, %xmm3
; X64-SSE2-NEXT:    pmuludq %xmm1, %xmm3
; X64-SSE2-NEXT:    pmuludq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; X64-SSE2-NEXT:    paddq %xmm3, %xmm0
; X64-SSE2-NEXT:    psllq $32, %xmm0
; X64-SSE2-NEXT:    paddq %xmm2, %xmm0
; X64-SSE2-NEXT:    retq
;
; X64-SSE4-LABEL: mul_v2i64_neg_17_65:
; X64-SSE4:       # %bb.0:
; X64-SSE4-NEXT:    pmovsxbq {{.*#+}} xmm1 = [18446744073709551599,18446744073709551551]
; X64-SSE4-NEXT:    movdqa %xmm0, %xmm2
; X64-SSE4-NEXT:    pmuludq %xmm1, %xmm2
; X64-SSE4-NEXT:    movdqa %xmm0, %xmm3
; X64-SSE4-NEXT:    psrlq $32, %xmm3
; X64-SSE4-NEXT:    pmuludq %xmm1, %xmm3
; X64-SSE4-NEXT:    pmuludq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; X64-SSE4-NEXT:    paddq %xmm3, %xmm0
; X64-SSE4-NEXT:    psllq $32, %xmm0
; X64-SSE4-NEXT:    paddq %xmm2, %xmm0
; X64-SSE4-NEXT:    retq
;
; X64-XOP-LABEL: mul_v2i64_neg_17_65:
; X64-XOP:       # %bb.0:
; X64-XOP-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [18446744073709551599,18446744073709551551]
; X64-XOP-NEXT:    vpmuludq %xmm1, %xmm0, %xmm2
; X64-XOP-NEXT:    vpsrlq $32, %xmm0, %xmm3
; X64-XOP-NEXT:    vpmuludq %xmm1, %xmm3, %xmm1
; X64-XOP-NEXT:    vpmuludq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; X64-XOP-NEXT:    vpaddq %xmm1, %xmm0, %xmm0
; X64-XOP-NEXT:    vpsllq $32, %xmm0, %xmm0
; X64-XOP-NEXT:    vpaddq %xmm0, %xmm2, %xmm0
; X64-XOP-NEXT:    retq
;
; X64-AVX2-LABEL: mul_v2i64_neg_17_65:
; X64-AVX2:       # %bb.0:
; X64-AVX2-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [18446744073709551599,18446744073709551551]
; X64-AVX2-NEXT:    vpmuludq %xmm1, %xmm0, %xmm2
; X64-AVX2-NEXT:    vpsrlq $32, %xmm0, %xmm3
; X64-AVX2-NEXT:    vpmuludq %xmm1, %xmm3, %xmm1
; X64-AVX2-NEXT:    vpmuludq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; X64-AVX2-NEXT:    vpaddq %xmm1, %xmm0, %xmm0
; X64-AVX2-NEXT:    vpsllq $32, %xmm0, %xmm0
; X64-AVX2-NEXT:    vpaddq %xmm0, %xmm2, %xmm0
; X64-AVX2-NEXT:    retq
;
; X64-AVX512DQ-LABEL: mul_v2i64_neg_17_65:
; X64-AVX512DQ:       # %bb.0:
; X64-AVX512DQ-NEXT:    vpmullq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; X64-AVX512DQ-NEXT:    retq
  %1 = mul <2 x i64> %a0, <i64 -17, i64 -65>
  ret <2 x i64> %1
}

define <2 x i64> @mul_v2i64_0_1(<2 x i64> %a0) nounwind {
; X86-SSE2-LABEL: mul_v2i64_0_1:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    xorpd %xmm1, %xmm1
; X86-SSE2-NEXT:    movsd {{.*#+}} xmm0 = xmm1[0],xmm0[1]
; X86-SSE2-NEXT:    retl
;
; SSE4-LABEL: mul_v2i64_0_1:
; SSE4:       # %bb.0:
; SSE4-NEXT:    xorps %xmm1, %xmm1
; SSE4-NEXT:    blendps {{.*#+}} xmm0 = xmm1[0,1],xmm0[2,3]
; SSE4-NEXT:    ret{{[l|q]}}
;
; X64-SSE2-LABEL: mul_v2i64_0_1:
; X64-SSE2:       # %bb.0:
; X64-SSE2-NEXT:    xorps %xmm1, %xmm1
; X64-SSE2-NEXT:    unpckhpd {{.*#+}} xmm1 = xmm1[1],xmm0[1]
; X64-SSE2-NEXT:    movaps %xmm1, %xmm0
; X64-SSE2-NEXT:    retq
;
; X64-AVX-LABEL: mul_v2i64_0_1:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; X64-AVX-NEXT:    vblendps {{.*#+}} xmm0 = xmm1[0,1],xmm0[2,3]
; X64-AVX-NEXT:    retq
  %1 = mul <2 x i64> %a0, <i64 0, i64 1>
  ret <2 x i64> %1
}

define <2 x i64> @mul_v2i64_neg_0_1(<2 x i64> %a0) nounwind {
; X86-SSE2-LABEL: mul_v2i64_neg_0_1:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    movdqa {{.*#+}} xmm1 = [0,0,4294967295,4294967295]
; X86-SSE2-NEXT:    movdqa %xmm0, %xmm2
; X86-SSE2-NEXT:    pmuludq %xmm1, %xmm2
; X86-SSE2-NEXT:    movdqa %xmm0, %xmm3
; X86-SSE2-NEXT:    psrlq $32, %xmm3
; X86-SSE2-NEXT:    pmuludq %xmm1, %xmm3
; X86-SSE2-NEXT:    pmuludq {{\.?LCPI[0-9]+_[0-9]+}}, %xmm0
; X86-SSE2-NEXT:    paddq %xmm3, %xmm0
; X86-SSE2-NEXT:    psllq $32, %xmm0
; X86-SSE2-NEXT:    paddq %xmm2, %xmm0
; X86-SSE2-NEXT:    retl
;
; X86-SSE4-LABEL: mul_v2i64_neg_0_1:
; X86-SSE4:       # %bb.0:
; X86-SSE4-NEXT:    pmovsxbq {{.*#+}} xmm1 = [0,18446744073709551615]
; X86-SSE4-NEXT:    movdqa %xmm0, %xmm2
; X86-SSE4-NEXT:    pmuludq %xmm1, %xmm2
; X86-SSE4-NEXT:    movdqa %xmm0, %xmm3
; X86-SSE4-NEXT:    psrlq $32, %xmm3
; X86-SSE4-NEXT:    pmuludq %xmm1, %xmm3
; X86-SSE4-NEXT:    pmuludq {{\.?LCPI[0-9]+_[0-9]+}}, %xmm0
; X86-SSE4-NEXT:    paddq %xmm3, %xmm0
; X86-SSE4-NEXT:    psllq $32, %xmm0
; X86-SSE4-NEXT:    paddq %xmm2, %xmm0
; X86-SSE4-NEXT:    retl
;
; X64-SSE2-LABEL: mul_v2i64_neg_0_1:
; X64-SSE2:       # %bb.0:
; X64-SSE2-NEXT:    movdqa {{.*#+}} xmm1 = [0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255]
; X64-SSE2-NEXT:    movdqa %xmm0, %xmm2
; X64-SSE2-NEXT:    pmuludq %xmm1, %xmm2
; X64-SSE2-NEXT:    movdqa %xmm0, %xmm3
; X64-SSE2-NEXT:    psrlq $32, %xmm3
; X64-SSE2-NEXT:    pmuludq %xmm1, %xmm3
; X64-SSE2-NEXT:    pmuludq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; X64-SSE2-NEXT:    paddq %xmm3, %xmm0
; X64-SSE2-NEXT:    psllq $32, %xmm0
; X64-SSE2-NEXT:    paddq %xmm2, %xmm0
; X64-SSE2-NEXT:    retq
;
; X64-SSE4-LABEL: mul_v2i64_neg_0_1:
; X64-SSE4:       # %bb.0:
; X64-SSE4-NEXT:    pmovsxbq {{.*#+}} xmm1 = [0,18446744073709551615]
; X64-SSE4-NEXT:    movdqa %xmm0, %xmm2
; X64-SSE4-NEXT:    pmuludq %xmm1, %xmm2
; X64-SSE4-NEXT:    movdqa %xmm0, %xmm3
; X64-SSE4-NEXT:    psrlq $32, %xmm3
; X64-SSE4-NEXT:    pmuludq %xmm1, %xmm3
; X64-SSE4-NEXT:    pmuludq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; X64-SSE4-NEXT:    paddq %xmm3, %xmm0
; X64-SSE4-NEXT:    psllq $32, %xmm0
; X64-SSE4-NEXT:    paddq %xmm2, %xmm0
; X64-SSE4-NEXT:    retq
;
; X64-XOP-LABEL: mul_v2i64_neg_0_1:
; X64-XOP:       # %bb.0:
; X64-XOP-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [0,18446744073709551615]
; X64-XOP-NEXT:    vpmuludq %xmm1, %xmm0, %xmm2
; X64-XOP-NEXT:    vpsrlq $32, %xmm0, %xmm3
; X64-XOP-NEXT:    vpmuludq %xmm1, %xmm3, %xmm1
; X64-XOP-NEXT:    vpmuludq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; X64-XOP-NEXT:    vpaddq %xmm1, %xmm0, %xmm0
; X64-XOP-NEXT:    vpsllq $32, %xmm0, %xmm0
; X64-XOP-NEXT:    vpaddq %xmm0, %xmm2, %xmm0
; X64-XOP-NEXT:    retq
;
; X64-AVX2-LABEL: mul_v2i64_neg_0_1:
; X64-AVX2:       # %bb.0:
; X64-AVX2-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [0,18446744073709551615]
; X64-AVX2-NEXT:    vpmuludq %xmm1, %xmm0, %xmm2
; X64-AVX2-NEXT:    vpsrlq $32, %xmm0, %xmm3
; X64-AVX2-NEXT:    vpmuludq %xmm1, %xmm3, %xmm1
; X64-AVX2-NEXT:    vpmuludq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; X64-AVX2-NEXT:    vpaddq %xmm1, %xmm0, %xmm0
; X64-AVX2-NEXT:    vpsllq $32, %xmm0, %xmm0
; X64-AVX2-NEXT:    vpaddq %xmm0, %xmm2, %xmm0
; X64-AVX2-NEXT:    retq
;
; X64-AVX512DQ-LABEL: mul_v2i64_neg_0_1:
; X64-AVX512DQ:       # %bb.0:
; X64-AVX512DQ-NEXT:    vpmullq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; X64-AVX512DQ-NEXT:    retq
  %1 = mul <2 x i64> %a0, <i64 0, i64 -1>
  ret <2 x i64> %1
}

define <2 x i64> @mul_v2i64_15_neg_63(<2 x i64> %a0) nounwind {
; X86-SSE2-LABEL: mul_v2i64_15_neg_63:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    movdqa {{.*#+}} xmm1 = [15,0,4294967233,4294967295]
; X86-SSE2-NEXT:    movdqa %xmm0, %xmm2
; X86-SSE2-NEXT:    pmuludq %xmm1, %xmm2
; X86-SSE2-NEXT:    movdqa %xmm0, %xmm3
; X86-SSE2-NEXT:    psrlq $32, %xmm3
; X86-SSE2-NEXT:    pmuludq %xmm1, %xmm3
; X86-SSE2-NEXT:    pmuludq {{\.?LCPI[0-9]+_[0-9]+}}, %xmm0
; X86-SSE2-NEXT:    paddq %xmm3, %xmm0
; X86-SSE2-NEXT:    psllq $32, %xmm0
; X86-SSE2-NEXT:    paddq %xmm2, %xmm0
; X86-SSE2-NEXT:    retl
;
; X86-SSE4-LABEL: mul_v2i64_15_neg_63:
; X86-SSE4:       # %bb.0:
; X86-SSE4-NEXT:    pmovsxbq {{.*#+}} xmm1 = [15,18446744073709551553]
; X86-SSE4-NEXT:    movdqa %xmm0, %xmm2
; X86-SSE4-NEXT:    pmuludq %xmm1, %xmm2
; X86-SSE4-NEXT:    movdqa %xmm0, %xmm3
; X86-SSE4-NEXT:    psrlq $32, %xmm3
; X86-SSE4-NEXT:    pmuludq %xmm1, %xmm3
; X86-SSE4-NEXT:    pmuludq {{\.?LCPI[0-9]+_[0-9]+}}, %xmm0
; X86-SSE4-NEXT:    paddq %xmm3, %xmm0
; X86-SSE4-NEXT:    psllq $32, %xmm0
; X86-SSE4-NEXT:    paddq %xmm2, %xmm0
; X86-SSE4-NEXT:    retl
;
; X64-SSE2-LABEL: mul_v2i64_15_neg_63:
; X64-SSE2:       # %bb.0:
; X64-SSE2-NEXT:    movdqa {{.*#+}} xmm1 = [15,18446744073709551553]
; X64-SSE2-NEXT:    movdqa %xmm0, %xmm2
; X64-SSE2-NEXT:    pmuludq %xmm1, %xmm2
; X64-SSE2-NEXT:    movdqa %xmm0, %xmm3
; X64-SSE2-NEXT:    psrlq $32, %xmm3
; X64-SSE2-NEXT:    pmuludq %xmm1, %xmm3
; X64-SSE2-NEXT:    pmuludq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; X64-SSE2-NEXT:    paddq %xmm3, %xmm0
; X64-SSE2-NEXT:    psllq $32, %xmm0
; X64-SSE2-NEXT:    paddq %xmm2, %xmm0
; X64-SSE2-NEXT:    retq
;
; X64-SSE4-LABEL: mul_v2i64_15_neg_63:
; X64-SSE4:       # %bb.0:
; X64-SSE4-NEXT:    pmovsxbq {{.*#+}} xmm1 = [15,18446744073709551553]
; X64-SSE4-NEXT:    movdqa %xmm0, %xmm2
; X64-SSE4-NEXT:    pmuludq %xmm1, %xmm2
; X64-SSE4-NEXT:    movdqa %xmm0, %xmm3
; X64-SSE4-NEXT:    psrlq $32, %xmm3
; X64-SSE4-NEXT:    pmuludq %xmm1, %xmm3
; X64-SSE4-NEXT:    pmuludq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; X64-SSE4-NEXT:    paddq %xmm3, %xmm0
; X64-SSE4-NEXT:    psllq $32, %xmm0
; X64-SSE4-NEXT:    paddq %xmm2, %xmm0
; X64-SSE4-NEXT:    retq
;
; X64-XOP-LABEL: mul_v2i64_15_neg_63:
; X64-XOP:       # %bb.0:
; X64-XOP-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [15,18446744073709551553]
; X64-XOP-NEXT:    vpmuludq %xmm1, %xmm0, %xmm2
; X64-XOP-NEXT:    vpsrlq $32, %xmm0, %xmm3
; X64-XOP-NEXT:    vpmuludq %xmm1, %xmm3, %xmm1
; X64-XOP-NEXT:    vpmuludq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; X64-XOP-NEXT:    vpaddq %xmm1, %xmm0, %xmm0
; X64-XOP-NEXT:    vpsllq $32, %xmm0, %xmm0
; X64-XOP-NEXT:    vpaddq %xmm0, %xmm2, %xmm0
; X64-XOP-NEXT:    retq
;
; X64-AVX2-LABEL: mul_v2i64_15_neg_63:
; X64-AVX2:       # %bb.0:
; X64-AVX2-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [15,18446744073709551553]
; X64-AVX2-NEXT:    vpmuludq %xmm1, %xmm0, %xmm2
; X64-AVX2-NEXT:    vpsrlq $32, %xmm0, %xmm3
; X64-AVX2-NEXT:    vpmuludq %xmm1, %xmm3, %xmm1
; X64-AVX2-NEXT:    vpmuludq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; X64-AVX2-NEXT:    vpaddq %xmm1, %xmm0, %xmm0
; X64-AVX2-NEXT:    vpsllq $32, %xmm0, %xmm0
; X64-AVX2-NEXT:    vpaddq %xmm0, %xmm2, %xmm0
; X64-AVX2-NEXT:    retq
;
; X64-AVX512DQ-LABEL: mul_v2i64_15_neg_63:
; X64-AVX512DQ:       # %bb.0:
; X64-AVX512DQ-NEXT:    vpmullq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; X64-AVX512DQ-NEXT:    retq
  %1 = mul <2 x i64> %a0, <i64 15, i64 -63>
  ret <2 x i64> %1
}

define <4 x i32> @mul_v4i32_0_15_31_7(<4 x i32> %a0) nounwind {
; X86-SSE2-LABEL: mul_v4i32_0_15_31_7:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[1,1,3,3]
; X86-SSE2-NEXT:    pmuludq {{\.?LCPI[0-9]+_[0-9]+}}, %xmm0
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; X86-SSE2-NEXT:    pmuludq {{\.?LCPI[0-9]+_[0-9]+}}, %xmm1
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; X86-SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; X86-SSE2-NEXT:    retl
;
; X86-SSE4-LABEL: mul_v4i32_0_15_31_7:
; X86-SSE4:       # %bb.0:
; X86-SSE4-NEXT:    pmulld {{\.?LCPI[0-9]+_[0-9]+}}, %xmm0
; X86-SSE4-NEXT:    retl
;
; X64-SSE2-LABEL: mul_v4i32_0_15_31_7:
; X64-SSE2:       # %bb.0:
; X64-SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[1,1,3,3]
; X64-SSE2-NEXT:    pmuludq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; X64-SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; X64-SSE2-NEXT:    pmuludq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1
; X64-SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; X64-SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; X64-SSE2-NEXT:    retq
;
; X64-SSE4-LABEL: mul_v4i32_0_15_31_7:
; X64-SSE4:       # %bb.0:
; X64-SSE4-NEXT:    pmulld {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; X64-SSE4-NEXT:    retq
;
; X64-AVX-LABEL: mul_v4i32_0_15_31_7:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vpmulld {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; X64-AVX-NEXT:    retq
  %1 = mul <4 x i32> %a0, <i32 0, i32 15, i32 31, i32 7>
  ret <4 x i32> %1
}

define <8 x i16> @mul_v8i16_0_1_7_15_31_63_127_255(<8 x i16> %a0) nounwind {
; X86-SSE-LABEL: mul_v8i16_0_1_7_15_31_63_127_255:
; X86-SSE:       # %bb.0:
; X86-SSE-NEXT:    pmullw {{\.?LCPI[0-9]+_[0-9]+}}, %xmm0 # [0,1,7,15,31,63,127,255]
; X86-SSE-NEXT:    retl
;
; X64-SSE-LABEL: mul_v8i16_0_1_7_15_31_63_127_255:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    pmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0 # [0,1,7,15,31,63,127,255]
; X64-SSE-NEXT:    retq
;
; X64-AVX-LABEL: mul_v8i16_0_1_7_15_31_63_127_255:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0 # [0,1,7,15,31,63,127,255]
; X64-AVX-NEXT:    retq
  %1 = mul <8 x i16> %a0, <i16 0, i16 1, i16 7, i16 15, i16 31, i16 63, i16 127, i16 255>
  ret <8 x i16> %1
}

define <16 x i8> @mul_v16i8_0_1_3_7_15_31_63_127_0_1_3_7_15_31_63_127(<16 x i8> %a0) nounwind {
; SSE2-LABEL: mul_v16i8_0_1_3_7_15_31_63_127_0_1_3_7_15_31_63_127:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa %xmm0, %xmm1
; SSE2-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; SSE2-NEXT:    movdqa {{.*#+}} xmm2 = [0,1,3,7,15,31,63,127]
; SSE2-NEXT:    pmullw %xmm2, %xmm1
; SSE2-NEXT:    movdqa {{.*#+}} xmm3 = [255,255,255,255,255,255,255,255]
; SSE2-NEXT:    pand %xmm3, %xmm1
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE2-NEXT:    pmullw %xmm2, %xmm0
; SSE2-NEXT:    pand %xmm3, %xmm0
; SSE2-NEXT:    packuswb %xmm1, %xmm0
; SSE2-NEXT:    ret{{[l|q]}}
;
; X86-SSE4-LABEL: mul_v16i8_0_1_3_7_15_31_63_127_0_1_3_7_15_31_63_127:
; X86-SSE4:       # %bb.0:
; X86-SSE4-NEXT:    movdqa %xmm0, %xmm1
; X86-SSE4-NEXT:    pmaddubsw {{\.?LCPI[0-9]+_[0-9]+}}, %xmm1 # [0,1,0,7,0,31,0,127,0,1,0,7,0,31,0,127]
; X86-SSE4-NEXT:    psllw $8, %xmm1
; X86-SSE4-NEXT:    pmaddubsw {{\.?LCPI[0-9]+_[0-9]+}}, %xmm0 # [0,0,3,0,15,0,63,0,0,0,3,0,15,0,63,0]
; X86-SSE4-NEXT:    pand {{\.?LCPI[0-9]+_[0-9]+}}, %xmm0
; X86-SSE4-NEXT:    por %xmm1, %xmm0
; X86-SSE4-NEXT:    retl
;
; X64-SSE4-LABEL: mul_v16i8_0_1_3_7_15_31_63_127_0_1_3_7_15_31_63_127:
; X64-SSE4:       # %bb.0:
; X64-SSE4-NEXT:    movdqa %xmm0, %xmm1
; X64-SSE4-NEXT:    pmaddubsw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1 # [0,1,0,7,0,31,0,127,0,1,0,7,0,31,0,127]
; X64-SSE4-NEXT:    psllw $8, %xmm1
; X64-SSE4-NEXT:    pmaddubsw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0 # [0,0,3,0,15,0,63,0,0,0,3,0,15,0,63,0]
; X64-SSE4-NEXT:    pand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; X64-SSE4-NEXT:    por %xmm1, %xmm0
; X64-SSE4-NEXT:    retq
;
; X64-XOP-LABEL: mul_v16i8_0_1_3_7_15_31_63_127_0_1_3_7_15_31_63_127:
; X64-XOP:       # %bb.0:
; X64-XOP-NEXT:    vpmaddubsw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm1 # [0,1,0,7,0,31,0,127,0,1,0,7,0,31,0,127]
; X64-XOP-NEXT:    vpmaddubsw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0 # [0,0,3,0,15,0,63,0,0,0,3,0,15,0,63,0]
; X64-XOP-NEXT:    vpperm {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[2],xmm1[2],xmm0[4],xmm1[4],xmm0[6],xmm1[6],xmm0[8],xmm1[8],xmm0[10],xmm1[10],xmm0[12],xmm1[12],xmm0[14],xmm1[14]
; X64-XOP-NEXT:    retq
;
; X64-AVX2-LABEL: mul_v16i8_0_1_3_7_15_31_63_127_0_1_3_7_15_31_63_127:
; X64-AVX2:       # %bb.0:
; X64-AVX2-NEXT:    vpmovzxbw {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero,xmm0[8],zero,xmm0[9],zero,xmm0[10],zero,xmm0[11],zero,xmm0[12],zero,xmm0[13],zero,xmm0[14],zero,xmm0[15],zero
; X64-AVX2-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0 # [0,1,3,7,15,31,63,127,0,1,3,7,15,31,63,127]
; X64-AVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; X64-AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; X64-AVX2-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; X64-AVX2-NEXT:    vzeroupper
; X64-AVX2-NEXT:    retq
;
; X64-AVX512DQ-LABEL: mul_v16i8_0_1_3_7_15_31_63_127_0_1_3_7_15_31_63_127:
; X64-AVX512DQ:       # %bb.0:
; X64-AVX512DQ-NEXT:    vpmovzxbw {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero,xmm0[8],zero,xmm0[9],zero,xmm0[10],zero,xmm0[11],zero,xmm0[12],zero,xmm0[13],zero,xmm0[14],zero,xmm0[15],zero
; X64-AVX512DQ-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0 # [0,1,3,7,15,31,63,127,0,1,3,7,15,31,63,127]
; X64-AVX512DQ-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; X64-AVX512DQ-NEXT:    vpmovdb %zmm0, %xmm0
; X64-AVX512DQ-NEXT:    vzeroupper
; X64-AVX512DQ-NEXT:    retq
  %1 = mul <16 x i8> %a0, <i8 0, i8 1, i8 3, i8 7, i8 15, i8 31, i8 63, i8 127, i8 0, i8 1, i8 3, i8 7, i8 15, i8 31, i8 63, i8 127>
  ret <16 x i8> %1
}

define <2 x i64> @mul_v2i64_68_132(<2 x i64> %x) nounwind {
; X86-SSE2-LABEL: mul_v2i64_68_132:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    movdqa {{.*#+}} xmm1 = [68,0,132,0]
; X86-SSE2-NEXT:    movdqa %xmm0, %xmm2
; X86-SSE2-NEXT:    pmuludq %xmm1, %xmm2
; X86-SSE2-NEXT:    psrlq $32, %xmm0
; X86-SSE2-NEXT:    pmuludq %xmm1, %xmm0
; X86-SSE2-NEXT:    psllq $32, %xmm0
; X86-SSE2-NEXT:    paddq %xmm2, %xmm0
; X86-SSE2-NEXT:    retl
;
; SSE4-LABEL: mul_v2i64_68_132:
; SSE4:       # %bb.0:
; SSE4-NEXT:    pmovzxbq {{.*#+}} xmm1 = [68,132]
; SSE4-NEXT:    movdqa %xmm0, %xmm2
; SSE4-NEXT:    pmuludq %xmm1, %xmm2
; SSE4-NEXT:    psrlq $32, %xmm0
; SSE4-NEXT:    pmuludq %xmm1, %xmm0
; SSE4-NEXT:    psllq $32, %xmm0
; SSE4-NEXT:    paddq %xmm2, %xmm0
; SSE4-NEXT:    ret{{[l|q]}}
;
; X64-SSE2-LABEL: mul_v2i64_68_132:
; X64-SSE2:       # %bb.0:
; X64-SSE2-NEXT:    movdqa {{.*#+}} xmm1 = [68,132]
; X64-SSE2-NEXT:    movdqa %xmm0, %xmm2
; X64-SSE2-NEXT:    pmuludq %xmm1, %xmm2
; X64-SSE2-NEXT:    psrlq $32, %xmm0
; X64-SSE2-NEXT:    pmuludq %xmm1, %xmm0
; X64-SSE2-NEXT:    psllq $32, %xmm0
; X64-SSE2-NEXT:    paddq %xmm2, %xmm0
; X64-SSE2-NEXT:    retq
;
; X64-XOP-LABEL: mul_v2i64_68_132:
; X64-XOP:       # %bb.0:
; X64-XOP-NEXT:    vpmovzxbq {{.*#+}} xmm1 = [68,132]
; X64-XOP-NEXT:    vpmuludq %xmm1, %xmm0, %xmm2
; X64-XOP-NEXT:    vpsrlq $32, %xmm0, %xmm0
; X64-XOP-NEXT:    vpmuludq %xmm1, %xmm0, %xmm0
; X64-XOP-NEXT:    vpsllq $32, %xmm0, %xmm0
; X64-XOP-NEXT:    vpaddq %xmm0, %xmm2, %xmm0
; X64-XOP-NEXT:    retq
;
; X64-AVX2-LABEL: mul_v2i64_68_132:
; X64-AVX2:       # %bb.0:
; X64-AVX2-NEXT:    vpmovzxbq {{.*#+}} xmm1 = [68,132]
; X64-AVX2-NEXT:    vpmuludq %xmm1, %xmm0, %xmm2
; X64-AVX2-NEXT:    vpsrlq $32, %xmm0, %xmm0
; X64-AVX2-NEXT:    vpmuludq %xmm1, %xmm0, %xmm0
; X64-AVX2-NEXT:    vpsllq $32, %xmm0, %xmm0
; X64-AVX2-NEXT:    vpaddq %xmm0, %xmm2, %xmm0
; X64-AVX2-NEXT:    retq
;
; X64-AVX512DQ-LABEL: mul_v2i64_68_132:
; X64-AVX512DQ:       # %bb.0:
; X64-AVX512DQ-NEXT:    vpmullq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; X64-AVX512DQ-NEXT:    retq
  %mul = mul <2 x i64> %x, <i64 68, i64 132>
  ret <2 x i64> %mul
}

define <2 x i64> @mul_v2i64_60_120(<2 x i64> %x) nounwind {
; X86-SSE2-LABEL: mul_v2i64_60_120:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    movdqa {{.*#+}} xmm1 = [60,0,124,0]
; X86-SSE2-NEXT:    movdqa %xmm0, %xmm2
; X86-SSE2-NEXT:    pmuludq %xmm1, %xmm2
; X86-SSE2-NEXT:    psrlq $32, %xmm0
; X86-SSE2-NEXT:    pmuludq %xmm1, %xmm0
; X86-SSE2-NEXT:    psllq $32, %xmm0
; X86-SSE2-NEXT:    paddq %xmm2, %xmm0
; X86-SSE2-NEXT:    retl
;
; SSE4-LABEL: mul_v2i64_60_120:
; SSE4:       # %bb.0:
; SSE4-NEXT:    pmovsxbq {{.*#+}} xmm1 = [60,124]
; SSE4-NEXT:    movdqa %xmm0, %xmm2
; SSE4-NEXT:    pmuludq %xmm1, %xmm2
; SSE4-NEXT:    psrlq $32, %xmm0
; SSE4-NEXT:    pmuludq %xmm1, %xmm0
; SSE4-NEXT:    psllq $32, %xmm0
; SSE4-NEXT:    paddq %xmm2, %xmm0
; SSE4-NEXT:    ret{{[l|q]}}
;
; X64-SSE2-LABEL: mul_v2i64_60_120:
; X64-SSE2:       # %bb.0:
; X64-SSE2-NEXT:    movdqa {{.*#+}} xmm1 = [60,124]
; X64-SSE2-NEXT:    movdqa %xmm0, %xmm2
; X64-SSE2-NEXT:    pmuludq %xmm1, %xmm2
; X64-SSE2-NEXT:    psrlq $32, %xmm0
; X64-SSE2-NEXT:    pmuludq %xmm1, %xmm0
; X64-SSE2-NEXT:    psllq $32, %xmm0
; X64-SSE2-NEXT:    paddq %xmm2, %xmm0
; X64-SSE2-NEXT:    retq
;
; X64-XOP-LABEL: mul_v2i64_60_120:
; X64-XOP:       # %bb.0:
; X64-XOP-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [60,124]
; X64-XOP-NEXT:    vpmuludq %xmm1, %xmm0, %xmm2
; X64-XOP-NEXT:    vpsrlq $32, %xmm0, %xmm0
; X64-XOP-NEXT:    vpmuludq %xmm1, %xmm0, %xmm0
; X64-XOP-NEXT:    vpsllq $32, %xmm0, %xmm0
; X64-XOP-NEXT:    vpaddq %xmm0, %xmm2, %xmm0
; X64-XOP-NEXT:    retq
;
; X64-AVX2-LABEL: mul_v2i64_60_120:
; X64-AVX2:       # %bb.0:
; X64-AVX2-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [60,124]
; X64-AVX2-NEXT:    vpmuludq %xmm1, %xmm0, %xmm2
; X64-AVX2-NEXT:    vpsrlq $32, %xmm0, %xmm0
; X64-AVX2-NEXT:    vpmuludq %xmm1, %xmm0, %xmm0
; X64-AVX2-NEXT:    vpsllq $32, %xmm0, %xmm0
; X64-AVX2-NEXT:    vpaddq %xmm0, %xmm2, %xmm0
; X64-AVX2-NEXT:    retq
;
; X64-AVX512DQ-LABEL: mul_v2i64_60_120:
; X64-AVX512DQ:       # %bb.0:
; X64-AVX512DQ-NEXT:    vpmullq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; X64-AVX512DQ-NEXT:    retq
  %mul = mul <2 x i64> %x, <i64 60, i64 124>
  ret <2 x i64> %mul
}

; We unfortunately can't see the zext that lives in the other basic block so we
; don't know that we only need one pmuludq to compute the full 64 bits. This
; sort of issue is more likely to occur when there is a loop and one of the
; multiply inputs is loop invariant.
define <2 x i64> @mul_v2i64_zext_cross_bb(ptr %in, ptr %y) {
; X86-SSE2-LABEL: mul_v2i64_zext_cross_bb:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-SSE2-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; X86-SSE2-NEXT:    pxor %xmm1, %xmm1
; X86-SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; X86-SSE2-NEXT:    movq {{.*#+}} xmm1 = mem[0],zero
; X86-SSE2-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0,0,1,1]
; X86-SSE2-NEXT:    pmuludq %xmm1, %xmm0
; X86-SSE2-NEXT:    retl
;
; X86-SSE4-LABEL: mul_v2i64_zext_cross_bb:
; X86-SSE4:       # %bb.0:
; X86-SSE4-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE4-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-SSE4-NEXT:    pmovzxdq {{.*#+}} xmm0 = mem[0],zero,mem[1],zero
; X86-SSE4-NEXT:    pmovzxdq {{.*#+}} xmm1 = mem[0],zero,mem[1],zero
; X86-SSE4-NEXT:    pmuludq %xmm1, %xmm0
; X86-SSE4-NEXT:    retl
;
; X64-SSE2-LABEL: mul_v2i64_zext_cross_bb:
; X64-SSE2:       # %bb.0:
; X64-SSE2-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; X64-SSE2-NEXT:    pxor %xmm1, %xmm1
; X64-SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; X64-SSE2-NEXT:    movq {{.*#+}} xmm1 = mem[0],zero
; X64-SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,1,1,3]
; X64-SSE2-NEXT:    pmuludq %xmm1, %xmm0
; X64-SSE2-NEXT:    retq
;
; X64-SSE4-LABEL: mul_v2i64_zext_cross_bb:
; X64-SSE4:       # %bb.0:
; X64-SSE4-NEXT:    pmovzxdq {{.*#+}} xmm0 = mem[0],zero,mem[1],zero
; X64-SSE4-NEXT:    pmovzxdq {{.*#+}} xmm1 = mem[0],zero,mem[1],zero
; X64-SSE4-NEXT:    pmuludq %xmm1, %xmm0
; X64-SSE4-NEXT:    retq
;
; X64-AVX-LABEL: mul_v2i64_zext_cross_bb:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vpmovzxdq {{.*#+}} xmm0 = mem[0],zero,mem[1],zero
; X64-AVX-NEXT:    vpmovzxdq {{.*#+}} xmm1 = mem[0],zero,mem[1],zero
; X64-AVX-NEXT:    vpmuludq %xmm1, %xmm0, %xmm0
; X64-AVX-NEXT:    retq
  %a = load <2 x i32>, ptr %in
  %b = zext <2 x i32> %a to <2 x i64>
  br label %foo

foo:
  %c = load <2 x i32>, ptr %y
  %d = zext <2 x i32> %c to <2 x i64>
  %e = mul <2 x i64> %b, %d
  ret <2 x i64> %e
}

define <4 x i64> @mul_v4i64_zext_cross_bb(ptr %in, ptr %y) {
; X86-SSE2-LABEL: mul_v4i64_zext_cross_bb:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-SSE2-NEXT:    movdqa (%ecx), %xmm0
; X86-SSE2-NEXT:    pxor %xmm2, %xmm2
; X86-SSE2-NEXT:    movdqa %xmm0, %xmm1
; X86-SSE2-NEXT:    punpckhdq {{.*#+}} xmm1 = xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; X86-SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1]
; X86-SSE2-NEXT:    movdqa (%eax), %xmm2
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm2[2,1,3,3]
; X86-SSE2-NEXT:    pmuludq %xmm3, %xmm1
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,1,1,3]
; X86-SSE2-NEXT:    pmuludq %xmm2, %xmm0
; X86-SSE2-NEXT:    retl
;
; X86-SSE4-LABEL: mul_v4i64_zext_cross_bb:
; X86-SSE4:       # %bb.0:
; X86-SSE4-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE4-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-SSE4-NEXT:    pmovzxdq {{.*#+}} xmm1 = mem[0],zero,mem[1],zero
; X86-SSE4-NEXT:    pmovzxdq {{.*#+}} xmm0 = mem[0],zero,mem[1],zero
; X86-SSE4-NEXT:    pmovzxdq {{.*#+}} xmm2 = mem[0],zero,mem[1],zero
; X86-SSE4-NEXT:    pmuludq %xmm2, %xmm1
; X86-SSE4-NEXT:    pmovzxdq {{.*#+}} xmm2 = mem[0],zero,mem[1],zero
; X86-SSE4-NEXT:    pmuludq %xmm2, %xmm0
; X86-SSE4-NEXT:    retl
;
; X64-SSE2-LABEL: mul_v4i64_zext_cross_bb:
; X64-SSE2:       # %bb.0:
; X64-SSE2-NEXT:    movdqa (%rdi), %xmm0
; X64-SSE2-NEXT:    pxor %xmm2, %xmm2
; X64-SSE2-NEXT:    movdqa %xmm0, %xmm1
; X64-SSE2-NEXT:    punpckhdq {{.*#+}} xmm1 = xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; X64-SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1]
; X64-SSE2-NEXT:    movdqa (%rsi), %xmm2
; X64-SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm2[2,1,3,3]
; X64-SSE2-NEXT:    pmuludq %xmm3, %xmm1
; X64-SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,1,1,3]
; X64-SSE2-NEXT:    pmuludq %xmm2, %xmm0
; X64-SSE2-NEXT:    retq
;
; X64-SSE4-LABEL: mul_v4i64_zext_cross_bb:
; X64-SSE4:       # %bb.0:
; X64-SSE4-NEXT:    pmovzxdq {{.*#+}} xmm1 = mem[0],zero,mem[1],zero
; X64-SSE4-NEXT:    pmovzxdq {{.*#+}} xmm0 = mem[0],zero,mem[1],zero
; X64-SSE4-NEXT:    pmovzxdq {{.*#+}} xmm2 = mem[0],zero,mem[1],zero
; X64-SSE4-NEXT:    pmuludq %xmm2, %xmm1
; X64-SSE4-NEXT:    pmovzxdq {{.*#+}} xmm2 = mem[0],zero,mem[1],zero
; X64-SSE4-NEXT:    pmuludq %xmm2, %xmm0
; X64-SSE4-NEXT:    retq
;
; X64-XOP-LABEL: mul_v4i64_zext_cross_bb:
; X64-XOP:       # %bb.0:
; X64-XOP-NEXT:    vpmovzxdq {{.*#+}} xmm0 = mem[0],zero,mem[1],zero
; X64-XOP-NEXT:    vpmovzxdq {{.*#+}} xmm1 = mem[0],zero,mem[1],zero
; X64-XOP-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; X64-XOP-NEXT:    vpmovzxdq {{.*#+}} xmm1 = mem[0],zero,mem[1],zero
; X64-XOP-NEXT:    vpmovzxdq {{.*#+}} xmm2 = mem[0],zero,mem[1],zero
; X64-XOP-NEXT:    vextractf128 $1, %ymm0, %xmm3
; X64-XOP-NEXT:    vpmuludq %xmm2, %xmm3, %xmm2
; X64-XOP-NEXT:    vpmuludq %xmm1, %xmm0, %xmm0
; X64-XOP-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; X64-XOP-NEXT:    retq
;
; X64-AVX2-LABEL: mul_v4i64_zext_cross_bb:
; X64-AVX2:       # %bb.0:
; X64-AVX2-NEXT:    vpmovzxdq {{.*#+}} ymm0 = mem[0],zero,mem[1],zero,mem[2],zero,mem[3],zero
; X64-AVX2-NEXT:    vpmovzxdq {{.*#+}} ymm1 = mem[0],zero,mem[1],zero,mem[2],zero,mem[3],zero
; X64-AVX2-NEXT:    vpmuludq %ymm1, %ymm0, %ymm0
; X64-AVX2-NEXT:    retq
;
; X64-AVX512DQ-LABEL: mul_v4i64_zext_cross_bb:
; X64-AVX512DQ:       # %bb.0:
; X64-AVX512DQ-NEXT:    vpmovzxdq {{.*#+}} ymm0 = mem[0],zero,mem[1],zero,mem[2],zero,mem[3],zero
; X64-AVX512DQ-NEXT:    vpmovzxdq {{.*#+}} ymm1 = mem[0],zero,mem[1],zero,mem[2],zero,mem[3],zero
; X64-AVX512DQ-NEXT:    vpmuludq %ymm1, %ymm0, %ymm0
; X64-AVX512DQ-NEXT:    retq
  %a = load <4 x i32>, ptr %in
  %b = zext <4 x i32> %a to <4 x i64>
  br label %foo

foo:
  %c = load <4 x i32>, ptr %y
  %d = zext <4 x i32> %c to <4 x i64>
  %e = mul <4 x i64> %b, %d
  ret <4 x i64> %e
}
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; X64-SSE4-FAST: {{.*}}
; X64-SSE4-SLOW: {{.*}}
