; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=gfx1100 -verify-machineinstrs < %s | FileCheck --check-prefixes=GFX11,GFX11-SDAG %s
; RUN: llc -global-isel=1 -mtriple=amdgcn -mcpu=gfx1100 -verify-machineinstrs < %s | FileCheck --check-prefixes=GFX11,GFX11-GISEL %s

define amdgpu_kernel void @test_get_doorbell(ptr addrspace(1) %out) {
; GFX11-SDAG-LABEL: test_get_doorbell:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-SDAG-NEXT:    s_sendmsg_rtn_b32 s2, sendmsg(MSG_RTN_GET_DOORBELL)
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s2
; GFX11-SDAG-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-SDAG-NEXT:    s_nop 0
; GFX11-SDAG-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: test_get_doorbell:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-GISEL-NEXT:    s_sendmsg_rtn_b32 s2, sendmsg(MSG_RTN_GET_DOORBELL)
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mov_b32 v0, s2
; GFX11-GISEL-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11-GISEL-NEXT:    s_nop 0
; GFX11-GISEL-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-GISEL-NEXT:    s_endpgm
  %ret = call i32 @llvm.amdgcn.s.sendmsg.rtn.i32(i32 128)
  store i32 %ret, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @test_get_ddid(ptr addrspace(1) %out) {
; GFX11-SDAG-LABEL: test_get_ddid:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-SDAG-NEXT:    s_sendmsg_rtn_b32 s2, sendmsg(MSG_RTN_GET_DDID)
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s2
; GFX11-SDAG-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-SDAG-NEXT:    s_nop 0
; GFX11-SDAG-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: test_get_ddid:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-GISEL-NEXT:    s_sendmsg_rtn_b32 s2, sendmsg(MSG_RTN_GET_DDID)
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mov_b32 v0, s2
; GFX11-GISEL-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11-GISEL-NEXT:    s_nop 0
; GFX11-GISEL-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-GISEL-NEXT:    s_endpgm
  %ret = call i32 @llvm.amdgcn.s.sendmsg.rtn.i32(i32 129)
  store i32 %ret, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @test_get_tma(ptr addrspace(1) %out) {
; GFX11-LABEL: test_get_tma:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-NEXT:    s_sendmsg_rtn_b64 s[2:3], sendmsg(MSG_RTN_GET_TMA)
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v0, s2 :: v_dual_mov_b32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %ret = call i64 @llvm.amdgcn.s.sendmsg.rtn.i64(i32 130)
  store i64 %ret, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @test_get_realtime(ptr addrspace(1) %out) {
; GFX11-LABEL: test_get_realtime:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-NEXT:    s_sendmsg_rtn_b64 s[2:3], sendmsg(MSG_RTN_GET_REALTIME)
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v0, s2 :: v_dual_mov_b32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %ret = call i64 @llvm.amdgcn.s.sendmsg.rtn.i64(i32 131)
  store i64 %ret, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @test_savewave(ptr addrspace(1) %out) {
; GFX11-SDAG-LABEL: test_savewave:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-SDAG-NEXT:    s_sendmsg_rtn_b32 s2, sendmsg(MSG_RTN_SAVE_WAVE)
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s2
; GFX11-SDAG-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-SDAG-NEXT:    s_nop 0
; GFX11-SDAG-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: test_savewave:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-GISEL-NEXT:    s_sendmsg_rtn_b32 s2, sendmsg(MSG_RTN_SAVE_WAVE)
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mov_b32 v0, s2
; GFX11-GISEL-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11-GISEL-NEXT:    s_nop 0
; GFX11-GISEL-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-GISEL-NEXT:    s_endpgm
  %ret = call i32 @llvm.amdgcn.s.sendmsg.rtn.i32(i32 132)
  store i32 %ret, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @test_get_tba(ptr addrspace(1) %out) {
; GFX11-LABEL: test_get_tba:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-NEXT:    s_sendmsg_rtn_b64 s[2:3], sendmsg(MSG_RTN_GET_TBA)
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v0, s2 :: v_dual_mov_b32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %ret = call i64 @llvm.amdgcn.s.sendmsg.rtn.i64(i32 133)
  store i64 %ret, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @test_get_0_i32(ptr addrspace(1) %out) {
; GFX11-SDAG-LABEL: test_get_0_i32:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-SDAG-NEXT:    s_sendmsg_rtn_b32 s2, sendmsg(0, 0, 0)
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s2
; GFX11-SDAG-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-SDAG-NEXT:    s_nop 0
; GFX11-SDAG-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: test_get_0_i32:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-GISEL-NEXT:    s_sendmsg_rtn_b32 s2, sendmsg(0, 0, 0)
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mov_b32 v0, s2
; GFX11-GISEL-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11-GISEL-NEXT:    s_nop 0
; GFX11-GISEL-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-GISEL-NEXT:    s_endpgm
  %ret = call i32 @llvm.amdgcn.s.sendmsg.rtn.i32(i32 0)
  store i32 %ret, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @test_get_99999_i64(ptr addrspace(1) %out) {
; GFX11-LABEL: test_get_99999_i64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-NEXT:    s_sendmsg_rtn_b64 s[2:3], 99999
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v0, s2 :: v_dual_mov_b32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %ret = call i64 @llvm.amdgcn.s.sendmsg.rtn.i64(i32 99999)
  store i64 %ret, ptr addrspace(1) %out
  ret void
}

declare i32 @llvm.amdgcn.s.sendmsg.rtn.i32(i32)
declare i64 @llvm.amdgcn.s.sendmsg.rtn.i64(i32)
