/*
** ###################################################################
**     Processors:          RW610ETA2I
**                          RW610HNA2I
**                          RW610UKA2I
**                          RW612ETA2I
**                          RW612HNA2I
**                          RW612UKA2I
**
**     Version:             rev. 1.0, 2021-03-16
**     Build:               b240715
**
**     Abstract:
**         CMSIS Peripheral Access Layer for BLEAPU
**
**     Copyright 1997-2016 Freescale Semiconductor, Inc.
**     Copyright 2016-2024 NXP
**     SPDX-License-Identifier: BSD-3-Clause
**
**     http:                 www.nxp.com
**     mail:                 support@nxp.com
**
**     Revisions:
**     - rev. 1.0 (2021-03-16)
**         Initial version.
**
** ###################################################################
*/

/*!
 * @file BLEAPU.h
 * @version 1.0
 * @date 2021-03-16
 * @brief CMSIS Peripheral Access Layer for BLEAPU
 *
 * CMSIS Peripheral Access Layer for BLEAPU
 */

#if !defined(BLEAPU_H_)
#define BLEAPU_H_                                /**< Symbol preventing repeated inclusion */

#if (defined(CPU_RW610ETA2I) || defined(CPU_RW610HNA2I) || defined(CPU_RW610UKA2I))
#include "RW610_COMMON.h"
#elif (defined(CPU_RW612ETA2I) || defined(CPU_RW612HNA2I) || defined(CPU_RW612UKA2I))
#include "RW612_COMMON.h"
#else
  #error "No valid CPU defined!"
#endif

/* ----------------------------------------------------------------------------
   -- Device Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup Peripheral_access_layer Device Peripheral Access Layer
 * @{
 */


/*
** Start of section using anonymous unions
*/

#if defined(__ARMCC_VERSION)
  #if (__ARMCC_VERSION >= 6010050)
    #pragma clang diagnostic push
  #else
    #pragma push
    #pragma anon_unions
  #endif
#elif defined(__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined(__IAR_SYSTEMS_ICC__)
  #pragma language=extended
#else
  #error Not supported compiler type
#endif

/* ----------------------------------------------------------------------------
   -- BLEAPU Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup BLEAPU_Peripheral_Access_Layer BLEAPU Peripheral Access Layer
 * @{
 */

/** BLEAPU - Register Layout Typedef */
typedef struct {
       uint8_t RESERVED_0[8];
  __IO uint32_t SOCBTAPU_APU_BYPASS0;              /**< APU Bypass0, offset: 0x8 */
  __IO uint32_t SOCBTAPU_APU_PWR_CTRL_BYPASS0;     /**< APU power control Bypass Register 0, offset: 0xC */
       uint8_t RESERVED_1[12];
  __IO uint32_t SOCBTAPU_APU_BYPASS1;              /**< APU Bypass Register 1, offset: 0x1C */
  __IO uint32_t SOCBTAPU_APU_BYPASS2;              /**< APU Bypass Register 2, offset: 0x20 */
  __IO uint32_t SOCBTAPU_APU_BYPASS3;              /**< APU Bypass Register 3, offset: 0x24 */
  __IO uint32_t SOCBTAPU_APU_CTRL;                 /**< APU Control, offset: 0x28 */
  __I  uint32_t SOCBTAPU_APU_STATUS;               /**< APU Status Register, offset: 0x2C */
  __IO uint32_t SOCBTAPU_CPU1_LMU_STA_BYPASS0;     /**< LMU static bank control byapss0 Register, offset: 0x30 */
  __IO uint32_t SOCBTAPU_CPU1_LMU_STA_BYPASS1;     /**< LMU static bank control byapss1 Register, offset: 0x34 */
  __IO uint32_t SOCBTAPU_CPU1_LMU_STA_BYPASS2;     /**< LMU static bank byapss2 Register, offset: 0x38 */
  __IO uint32_t SOCBTAPU_LMU_DYN_BYPASS0;          /**< LMU dynamic bank control byapss0 Register, offset: 0x3C */
  __IO uint32_t SOCBTAPU_LMU_G2BIST_CTRL_BYPASS;   /**< LMU G2Bist control bypass Register, offset: 0x40 */
       uint8_t RESERVED_2[12];
  __IO uint32_t SOCBTAPU_CPU1_LMU_G2BIST_CTRL_BYPASS; /**< LMU G2Bist control bypass Register for CPU1, offset: 0x50 */
       uint8_t RESERVED_3[8];
  __IO uint32_t SOCBTAPU_APU_PWR_CTRL_BYPASS5;     /**< ", offset: 0x5C */
       uint8_t RESERVED_4[8];
  __IO uint32_t SOCBTAPU_SMU1_HYBRID_LMU_BYPASS0;  /**< LMU static bank control byapss0 Register for smu1 hybrid banks mem, offset: 0x68 */
  __IO uint32_t SOCBTAPU_SMU1_HYBRID_LMU_BYPASS1;  /**< LMU static bank control byapss1 Register for smu1 hybrid banks mem, offset: 0x6C */
  __IO uint32_t SOCBTAPU_SMU1_HYBRID_LMU_BYPASS2;  /**< LMU static bank control byapss2 Register for smu1 hybrid banks mem, offset: 0x70 */
       uint8_t RESERVED_5[8];
  __IO uint32_t SOCBTAPU_APU_ECO_CTRL;             /**< APU ECO Control, offset: 0x7C */
  __IO uint32_t SOCBTAPU_GPIO_WKUP_CTRL0;          /**< ", offset: 0x80 */
  __IO uint32_t SOCBTAPU_GPIO_WKUP_CTRL1;          /**< ", offset: 0x84 */
  __IO uint32_t SOCBTAPU_GPIO_WKUP_CTRL2;          /**< ", offset: 0x88 */
  __IO uint32_t SOCBTAPU_GPIO_WKUP_CTRL3;          /**< ", offset: 0x8C */
  __IO uint32_t SOCBTAPU_HOST_WKUP_MODE;           /**< ", offset: 0x90 */
  __IO uint32_t SOCBTAPU_T3_CLK_DIV_EN_BYPASS;     /**< ", offset: 0x94 */
  __IO uint32_t SOCBTAPU_LDO_LV_CTRL2;             /**< LV LDO Control 2, offset: 0x98 */
  __IO uint32_t SOCBTAPU_CAU_BYPASS;               /**< CAU Bypass, offset: 0x9C */
       uint8_t RESERVED_6[4];
  __IO uint32_t SOCBTAPU_MEM_PWDN2;                /**< Memory Powerdown Control, offset: 0xA4 */
       uint8_t RESERVED_7[8];
  __IO uint32_t SOCBTAPU_HOST_WKUP_SOURCE;         /**< Host Wakeup Source Control, offset: 0xB0 */
} BLEAPU_Type;

/* ----------------------------------------------------------------------------
   -- BLEAPU Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup BLEAPU_Register_Masks BLEAPU Register Masks
 * @{
 */

/*! @name SOCBTAPU_APU_BYPASS0 - APU Bypass0 */
/*! @{ */

#define BLEAPU_SOCBTAPU_APU_BYPASS0_C2P_XOSC_EN_BYPASS_EN_MASK (0x1U)
#define BLEAPU_SOCBTAPU_APU_BYPASS0_C2P_XOSC_EN_BYPASS_EN_SHIFT (0U)
/*! C2P_XOSC_EN_BYPASS_EN - C2p_Xosc_En_Bypass */
#define BLEAPU_SOCBTAPU_APU_BYPASS0_C2P_XOSC_EN_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS0_C2P_XOSC_EN_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS0_C2P_XOSC_EN_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_TCPU_PDB_BYPASS_EN_MASK (0x2U)
#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_TCPU_PDB_BYPASS_EN_SHIFT (1U)
/*! TBG_TCPU_PDB_BYPASS_EN - TCPU_Pdb_Bypass */
#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_TCPU_PDB_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_TCPU_PDB_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_TCPU_PDB_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_BBU1_CLK_EN_BYPASS_EN_MASK (0x4U)
#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_BBU1_CLK_EN_BYPASS_EN_SHIFT (2U)
/*! TBG_BBU1_CLK_EN_BYPASS_EN - TBG512_320_176_BBU1_Clk_En_Bypass */
#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_BBU1_CLK_EN_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_BBU1_CLK_EN_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_BBU1_CLK_EN_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_T2_PDB_BYPASS_EN_MASK (0x8U)
#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_T2_PDB_BYPASS_EN_SHIFT (3U)
/*! TBG_T2_PDB_BYPASS_EN - tbg t2_Pdb_Bypass */
#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_T2_PDB_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_T2_PDB_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_T2_PDB_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_MAC1_CLK_EN_BYPASS_EN_MASK (0x10U)
#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_MAC1_CLK_EN_BYPASS_EN_SHIFT (4U)
/*! TBG_MAC1_CLK_EN_BYPASS_EN - TBG512_320_176_MAC1_Clk_En_Bypass */
#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_MAC1_CLK_EN_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_MAC1_CLK_EN_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_MAC1_CLK_EN_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_SOC_CLK_EN_BYPASS_EN_MASK (0x20U)
#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_SOC_CLK_EN_BYPASS_EN_SHIFT (5U)
/*! TBG_SOC_CLK_EN_BYPASS_EN - TBG512_320_176_SoC_Clk_En_Bypass */
#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_SOC_CLK_EN_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_SOC_CLK_EN_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_SOC_CLK_EN_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_BBU2_CLK_EN_BYPASS_EN_MASK (0x40U)
#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_BBU2_CLK_EN_BYPASS_EN_SHIFT (6U)
/*! TBG_BBU2_CLK_EN_BYPASS_EN - TBG512_320_176_BBU2_Clk_En_Bypass */
#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_BBU2_CLK_EN_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_BBU2_CLK_EN_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_BBU2_CLK_EN_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_MAC2_CLK_EN_BYPASS_EN_MASK (0x80U)
#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_MAC2_CLK_EN_BYPASS_EN_SHIFT (7U)
/*! TBG_MAC2_CLK_EN_BYPASS_EN - TBG512_320_176_MAC2_Clk_En_Bypass */
#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_MAC2_CLK_EN_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_MAC2_CLK_EN_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_MAC2_CLK_EN_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS0_TX_PE_BYPASS_EN_MASK (0x400U)
#define BLEAPU_SOCBTAPU_APU_BYPASS0_TX_PE_BYPASS_EN_SHIFT (10U)
/*! TX_PE_BYPASS_EN - BBU_Rx_Pe_Bypass Enable */
#define BLEAPU_SOCBTAPU_APU_BYPASS0_TX_PE_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS0_TX_PE_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS0_TX_PE_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS0_RX_PE_BYPASS_EN_MASK (0x800U)
#define BLEAPU_SOCBTAPU_APU_BYPASS0_RX_PE_BYPASS_EN_SHIFT (11U)
/*! RX_PE_BYPASS_EN - BBU_Rx_Pe_Bypass Enable */
#define BLEAPU_SOCBTAPU_APU_BYPASS0_RX_PE_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS0_RX_PE_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS0_RX_PE_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS0_RFU_PE1_BYPASS_EN_MASK (0x1000U)
#define BLEAPU_SOCBTAPU_APU_BYPASS0_RFU_PE1_BYPASS_EN_SHIFT (12U)
/*! RFU_PE1_BYPASS_EN - RFU_PE1_Bypass Enable */
#define BLEAPU_SOCBTAPU_APU_BYPASS0_RFU_PE1_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS0_RFU_PE1_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS0_RFU_PE1_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS0_RFU_PE2_BYPASS_EN_MASK (0x2000U)
#define BLEAPU_SOCBTAPU_APU_BYPASS0_RFU_PE2_BYPASS_EN_SHIFT (13U)
/*! RFU_PE2_BYPASS_EN - RFU_PE2_Bypass Enable */
#define BLEAPU_SOCBTAPU_APU_BYPASS0_RFU_PE2_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS0_RFU_PE2_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS0_RFU_PE2_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS0_RFU_PA_PE_A_BYPASS_EN_MASK (0x4000U)
#define BLEAPU_SOCBTAPU_APU_BYPASS0_RFU_PA_PE_A_BYPASS_EN_SHIFT (14U)
/*! RFU_PA_PE_A_BYPASS_EN - RFU_PA_PE_A_Bypass Enable */
#define BLEAPU_SOCBTAPU_APU_BYPASS0_RFU_PA_PE_A_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS0_RFU_PA_PE_A_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS0_RFU_PA_PE_A_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS0_RFU_PA_PE_G_BYPASS_EN_MASK (0x8000U)
#define BLEAPU_SOCBTAPU_APU_BYPASS0_RFU_PA_PE_G_BYPASS_EN_SHIFT (15U)
/*! RFU_PA_PE_G_BYPASS_EN - RFU_PA_PE_G_Bypass Enable */
#define BLEAPU_SOCBTAPU_APU_BYPASS0_RFU_PA_PE_G_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS0_RFU_PA_PE_G_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS0_RFU_PA_PE_G_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS0_C2P_XOSC_EN_BYPASS_VAL_MASK (0x10000U)
#define BLEAPU_SOCBTAPU_APU_BYPASS0_C2P_XOSC_EN_BYPASS_VAL_SHIFT (16U)
/*! C2P_XOSC_EN_BYPASS_VAL - C2p_Xosc_En Bypass Value */
#define BLEAPU_SOCBTAPU_APU_BYPASS0_C2P_XOSC_EN_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS0_C2P_XOSC_EN_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS0_C2P_XOSC_EN_BYPASS_VAL_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_TCPU_PDB_BYPASS_VAL_MASK (0x20000U)
#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_TCPU_PDB_BYPASS_VAL_SHIFT (17U)
/*! TBG_TCPU_PDB_BYPASS_VAL - TCPU_Pdb Bypass Value */
#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_TCPU_PDB_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_TCPU_PDB_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_TCPU_PDB_BYPASS_VAL_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_BBU1_CLK_EN_BYPASS_VAL_MASK (0x40000U)
#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_BBU1_CLK_EN_BYPASS_VAL_SHIFT (18U)
/*! TBG_BBU1_CLK_EN_BYPASS_VAL - TBG512_320_176_BBU1_Clk_En Bypass Value */
#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_BBU1_CLK_EN_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_BBU1_CLK_EN_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_BBU1_CLK_EN_BYPASS_VAL_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_T2_PDB_BYPASS_VAL_MASK (0x80000U)
#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_T2_PDB_BYPASS_VAL_SHIFT (19U)
/*! TBG_T2_PDB_BYPASS_VAL - TBF176_Pdb Bypass Value */
#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_T2_PDB_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_T2_PDB_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_T2_PDB_BYPASS_VAL_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_MAC1_CLK_EN_BYPASS_VAL_MASK (0x100000U)
#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_MAC1_CLK_EN_BYPASS_VAL_SHIFT (20U)
/*! TBG_MAC1_CLK_EN_BYPASS_VAL - TBG512_320_176_MAC1_Clk_En Bypass Value */
#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_MAC1_CLK_EN_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_MAC1_CLK_EN_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_MAC1_CLK_EN_BYPASS_VAL_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_SOC_CLK_EN_BYPASS_VAL_MASK (0x200000U)
#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_SOC_CLK_EN_BYPASS_VAL_SHIFT (21U)
/*! TBG_SOC_CLK_EN_BYPASS_VAL - TBG512_320_176_SoC_Clk_En Bypass Value */
#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_SOC_CLK_EN_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_SOC_CLK_EN_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_SOC_CLK_EN_BYPASS_VAL_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_BBU2_CLK_EN_BYPASS_VAL_MASK (0x400000U)
#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_BBU2_CLK_EN_BYPASS_VAL_SHIFT (22U)
/*! TBG_BBU2_CLK_EN_BYPASS_VAL - TBG512_320_176_BBU2_Clk_En Bypass Value */
#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_BBU2_CLK_EN_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_BBU2_CLK_EN_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_BBU2_CLK_EN_BYPASS_VAL_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_MAC2_CLK_EN_BYPASS_VAL_MASK (0x800000U)
#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_MAC2_CLK_EN_BYPASS_VAL_SHIFT (23U)
/*! TBG_MAC2_CLK_EN_BYPASS_VAL - TBG512_320_176_MAC2_Clk_En Bypass Value */
#define BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_MAC2_CLK_EN_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_MAC2_CLK_EN_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS0_TBG_MAC2_CLK_EN_BYPASS_VAL_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS0_TX_PE_BYPASS_VAL_MASK (0x4000000U)
#define BLEAPU_SOCBTAPU_APU_BYPASS0_TX_PE_BYPASS_VAL_SHIFT (26U)
/*! TX_PE_BYPASS_VAL - Tx_Pe Bypass Value */
#define BLEAPU_SOCBTAPU_APU_BYPASS0_TX_PE_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS0_TX_PE_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS0_TX_PE_BYPASS_VAL_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS0_RX_PE_BYPASS_VAL_MASK (0x8000000U)
#define BLEAPU_SOCBTAPU_APU_BYPASS0_RX_PE_BYPASS_VAL_SHIFT (27U)
/*! RX_PE_BYPASS_VAL - Rx_Pe Bypass Value */
#define BLEAPU_SOCBTAPU_APU_BYPASS0_RX_PE_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS0_RX_PE_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS0_RX_PE_BYPASS_VAL_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS0_RFU_PE1_BYPASS_VAL_MASK (0x10000000U)
#define BLEAPU_SOCBTAPU_APU_BYPASS0_RFU_PE1_BYPASS_VAL_SHIFT (28U)
/*! RFU_PE1_BYPASS_VAL - RFU PE1 Bypass Value */
#define BLEAPU_SOCBTAPU_APU_BYPASS0_RFU_PE1_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS0_RFU_PE1_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS0_RFU_PE1_BYPASS_VAL_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS0_RFU_PE2_BYPASS_VAL_MASK (0x20000000U)
#define BLEAPU_SOCBTAPU_APU_BYPASS0_RFU_PE2_BYPASS_VAL_SHIFT (29U)
/*! RFU_PE2_BYPASS_VAL - RFU PE2 Bypass Value */
#define BLEAPU_SOCBTAPU_APU_BYPASS0_RFU_PE2_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS0_RFU_PE2_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS0_RFU_PE2_BYPASS_VAL_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS0_RFU_PA_PE_A_BYPASS_VAL_MASK (0x40000000U)
#define BLEAPU_SOCBTAPU_APU_BYPASS0_RFU_PA_PE_A_BYPASS_VAL_SHIFT (30U)
/*! RFU_PA_PE_A_BYPASS_VAL - RFU PA_PE_A Bypass Value */
#define BLEAPU_SOCBTAPU_APU_BYPASS0_RFU_PA_PE_A_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS0_RFU_PA_PE_A_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS0_RFU_PA_PE_A_BYPASS_VAL_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS0_RFU_PA_PE_G_BYPASS_VAL_MASK (0x80000000U)
#define BLEAPU_SOCBTAPU_APU_BYPASS0_RFU_PA_PE_G_BYPASS_VAL_SHIFT (31U)
/*! RFU_PA_PE_G_BYPASS_VAL - RFU PA_PE_G Bypass Value */
#define BLEAPU_SOCBTAPU_APU_BYPASS0_RFU_PA_PE_G_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS0_RFU_PA_PE_G_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS0_RFU_PA_PE_G_BYPASS_VAL_MASK)
/*! @} */

/*! @name SOCBTAPU_APU_PWR_CTRL_BYPASS0 - APU power control Bypass Register 0 */
/*! @{ */

#define BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_PSW_BYPASS_VAL_MASK (0x1U)
#define BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_PSW_BYPASS_VAL_SHIFT (0U)
/*! SOC_PSW_BYPASS_VAL - SoC Power Switch Control */
#define BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_PSW_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_PSW_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_PSW_BYPASS_VAL_MASK)

#define BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_PSW_BYPASS_EN_MASK (0x2U)
#define BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_PSW_BYPASS_EN_SHIFT (1U)
/*! SOC_PSW_BYPASS_EN - SoC Power Switch Control Enable */
#define BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_PSW_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_PSW_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_PSW_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_FWBAR_BYPASS_VAL_MASK (0x4U)
#define BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_FWBAR_BYPASS_VAL_SHIFT (2U)
/*! SOC_FWBAR_BYPASS_VAL - SoC Firewallbar Control */
#define BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_FWBAR_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_FWBAR_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_FWBAR_BYPASS_VAL_MASK)

#define BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_FWBAR_BYPASS_EN_MASK (0x8U)
#define BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_FWBAR_BYPASS_EN_SHIFT (3U)
/*! SOC_FWBAR_BYPASS_EN - SoC Firewallbar Control Enable */
#define BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_FWBAR_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_FWBAR_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_FWBAR_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_ISO_EN_BYPASS_VAL_MASK (0x10U)
#define BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_ISO_EN_BYPASS_VAL_SHIFT (4U)
/*! SOC_ISO_EN_BYPASS_VAL - SoC Isolation Cell Control */
#define BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_ISO_EN_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_ISO_EN_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_ISO_EN_BYPASS_VAL_MASK)

#define BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_ISO_EN_BYPASS_EN_MASK (0x20U)
#define BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_ISO_EN_BYPASS_EN_SHIFT (5U)
/*! SOC_ISO_EN_BYPASS_EN - SoC Isolation Cell Control Enable */
#define BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_ISO_EN_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_ISO_EN_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_ISO_EN_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_CLK_DIV_RSTB_BYPASS_VAL_MASK (0x40U)
#define BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_CLK_DIV_RSTB_BYPASS_VAL_SHIFT (6U)
/*! SOC_CLK_DIV_RSTB_BYPASS_VAL - Firmware Bypass Value for SoC Dlk_Div_Rstb (active low signal) */
#define BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_CLK_DIV_RSTB_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_CLK_DIV_RSTB_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_CLK_DIV_RSTB_BYPASS_VAL_MASK)

#define BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_CLK_DIV_RSTB_BYPASS_EN_MASK (0x80U)
#define BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_CLK_DIV_RSTB_BYPASS_EN_SHIFT (7U)
/*! SOC_CLK_DIV_RSTB_BYPASS_EN - Firmware Bypass SoC Clk_Div_Rstb from APU */
#define BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_CLK_DIV_RSTB_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_CLK_DIV_RSTB_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_CLK_DIV_RSTB_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_NON_UDR_RST_BYPASS_VAL_MASK (0x100U)
#define BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_NON_UDR_RST_BYPASS_VAL_SHIFT (8U)
/*! SOC_NON_UDR_RST_BYPASS_VAL - Firmware Bypass Value for SoC non udr rst (active low signal) */
#define BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_NON_UDR_RST_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_NON_UDR_RST_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_NON_UDR_RST_BYPASS_VAL_MASK)

#define BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_NON_UDR_RST_BYPASS_EN_MASK (0x200U)
#define BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_NON_UDR_RST_BYPASS_EN_SHIFT (9U)
/*! SOC_NON_UDR_RST_BYPASS_EN - Firmware Bypass SoC non udr rst from APU (used for brf sif only in KF2) */
#define BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_NON_UDR_RST_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_NON_UDR_RST_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS0_SOC_NON_UDR_RST_BYPASS_EN_MASK)
/*! @} */

/*! @name SOCBTAPU_APU_BYPASS1 - APU Bypass Register 1 */
/*! @{ */

#define BLEAPU_SOCBTAPU_APU_BYPASS1_SOC_CAU_XOSC_EN_BP_EN_MASK (0x40U)
#define BLEAPU_SOCBTAPU_APU_BYPASS1_SOC_CAU_XOSC_EN_BP_EN_SHIFT (6U)
/*! SOC_CAU_XOSC_EN_BP_EN - Firmware Bypass Xosc_En to CAU and other parts of the chip including pads */
#define BLEAPU_SOCBTAPU_APU_BYPASS1_SOC_CAU_XOSC_EN_BP_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS1_SOC_CAU_XOSC_EN_BP_EN_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS1_SOC_CAU_XOSC_EN_BP_EN_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS1_SOC_CAU_XOSC_EN_BP_VAL_MASK (0x80U)
#define BLEAPU_SOCBTAPU_APU_BYPASS1_SOC_CAU_XOSC_EN_BP_VAL_SHIFT (7U)
/*! SOC_CAU_XOSC_EN_BP_VAL - Firmware Bypass Xosc_En Value for SoC_CAU_Xosc_En_Bp_En */
#define BLEAPU_SOCBTAPU_APU_BYPASS1_SOC_CAU_XOSC_EN_BP_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS1_SOC_CAU_XOSC_EN_BP_VAL_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS1_SOC_CAU_XOSC_EN_BP_VAL_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS1_RXPE_DYN_BYPASS_MASK (0x100U)
#define BLEAPU_SOCBTAPU_APU_BYPASS1_RXPE_DYN_BYPASS_SHIFT (8U)
/*! RXPE_DYN_BYPASS - Rxpe_Dyn_Bypass */
#define BLEAPU_SOCBTAPU_APU_BYPASS1_RXPE_DYN_BYPASS(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS1_RXPE_DYN_BYPASS_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS1_RXPE_DYN_BYPASS_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS1_PE1_DYN_BYPASS_MASK (0x200U)
#define BLEAPU_SOCBTAPU_APU_BYPASS1_PE1_DYN_BYPASS_SHIFT (9U)
/*! PE1_DYN_BYPASS - PE1_Dyn_Bypass */
#define BLEAPU_SOCBTAPU_APU_BYPASS1_PE1_DYN_BYPASS(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS1_PE1_DYN_BYPASS_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS1_PE1_DYN_BYPASS_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS1_PLL_OVERRIDE_BYPASS_MASK (0x400U)
#define BLEAPU_SOCBTAPU_APU_BYPASS1_PLL_OVERRIDE_BYPASS_SHIFT (10U)
/*! PLL_OVERRIDE_BYPASS - PLL Override Bypass */
#define BLEAPU_SOCBTAPU_APU_BYPASS1_PLL_OVERRIDE_BYPASS(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS1_PLL_OVERRIDE_BYPASS_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS1_PLL_OVERRIDE_BYPASS_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS1_BCA_CLK_EN_BYPASS_EN_MASK (0x40000U)
#define BLEAPU_SOCBTAPU_APU_BYPASS1_BCA_CLK_EN_BYPASS_EN_SHIFT (18U)
/*! BCA_CLK_EN_BYPASS_EN - Firmware Bypass BCA_Clk_En */
#define BLEAPU_SOCBTAPU_APU_BYPASS1_BCA_CLK_EN_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS1_BCA_CLK_EN_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS1_BCA_CLK_EN_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS1_BCA_CLK_EN_BYPASS_VAL_MASK (0x80000U)
#define BLEAPU_SOCBTAPU_APU_BYPASS1_BCA_CLK_EN_BYPASS_VAL_SHIFT (19U)
/*! BCA_CLK_EN_BYPASS_VAL - Firmware Bypass Value for BCA_Clk_En (active high signal) */
#define BLEAPU_SOCBTAPU_APU_BYPASS1_BCA_CLK_EN_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS1_BCA_CLK_EN_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS1_BCA_CLK_EN_BYPASS_VAL_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS1_SLNA_CLK_EN_BYPASS_EN_MASK (0x4000000U)
#define BLEAPU_SOCBTAPU_APU_BYPASS1_SLNA_CLK_EN_BYPASS_EN_SHIFT (26U)
/*! SLNA_CLK_EN_BYPASS_EN - Firmware Bypass for SLNA_Clk_En */
#define BLEAPU_SOCBTAPU_APU_BYPASS1_SLNA_CLK_EN_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS1_SLNA_CLK_EN_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS1_SLNA_CLK_EN_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS1_SLNA_CLK_EN_BYPASS_VAL_MASK (0x8000000U)
#define BLEAPU_SOCBTAPU_APU_BYPASS1_SLNA_CLK_EN_BYPASS_VAL_SHIFT (27U)
/*! SLNA_CLK_EN_BYPASS_VAL - Firmware Bypass Value for SLNA_Clk_En (active high signal) */
#define BLEAPU_SOCBTAPU_APU_BYPASS1_SLNA_CLK_EN_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS1_SLNA_CLK_EN_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS1_SLNA_CLK_EN_BYPASS_VAL_MASK)
/*! @} */

/*! @name SOCBTAPU_APU_BYPASS2 - APU Bypass Register 2 */
/*! @{ */

#define BLEAPU_SOCBTAPU_APU_BYPASS2_TBG_T3_PDB_BYPASS_EN_MASK (0x100U)
#define BLEAPU_SOCBTAPU_APU_BYPASS2_TBG_T3_PDB_BYPASS_EN_SHIFT (8U)
/*! TBG_T3_PDB_BYPASS_EN - Firmware Bypass for T3_pdb pll */
#define BLEAPU_SOCBTAPU_APU_BYPASS2_TBG_T3_PDB_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS2_TBG_T3_PDB_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS2_TBG_T3_PDB_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS2_TBG_T3_PDB_BYPASS_VAL_MASK (0x200U)
#define BLEAPU_SOCBTAPU_APU_BYPASS2_TBG_T3_PDB_BYPASS_VAL_SHIFT (9U)
/*! TBG_T3_PDB_BYPASS_VAL - T3_Pdb Bypass Value */
#define BLEAPU_SOCBTAPU_APU_BYPASS2_TBG_T3_PDB_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS2_TBG_T3_PDB_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS2_TBG_T3_PDB_BYPASS_VAL_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS2_T3_PI1_PDB_BYPASS_EN_MASK (0x400U)
#define BLEAPU_SOCBTAPU_APU_BYPASS2_T3_PI1_PDB_BYPASS_EN_SHIFT (10U)
/*! T3_PI1_PDB_BYPASS_EN - Firmware Bypass for TBG256 aiu_pi1 */
#define BLEAPU_SOCBTAPU_APU_BYPASS2_T3_PI1_PDB_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS2_T3_PI1_PDB_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS2_T3_PI1_PDB_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS2_T3_PI1_PDB_BYPASS_VAL_MASK (0x800U)
#define BLEAPU_SOCBTAPU_APU_BYPASS2_T3_PI1_PDB_BYPASS_VAL_SHIFT (11U)
/*! T3_PI1_PDB_BYPASS_VAL - Firmware Bypass Value for TBG256 aiu pi1 */
#define BLEAPU_SOCBTAPU_APU_BYPASS2_T3_PI1_PDB_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS2_T3_PI1_PDB_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS2_T3_PI1_PDB_BYPASS_VAL_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS2_T3_PI2_PDB_BYPASS_EN_MASK (0x1000U)
#define BLEAPU_SOCBTAPU_APU_BYPASS2_T3_PI2_PDB_BYPASS_EN_SHIFT (12U)
/*! T3_PI2_PDB_BYPASS_EN - Firmware Bypass for TBG256 aiu_pi2 */
#define BLEAPU_SOCBTAPU_APU_BYPASS2_T3_PI2_PDB_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS2_T3_PI2_PDB_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS2_T3_PI2_PDB_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS2_T3_PI2_PDB_BYPASS_VAL_MASK (0x2000U)
#define BLEAPU_SOCBTAPU_APU_BYPASS2_T3_PI2_PDB_BYPASS_VAL_SHIFT (13U)
/*! T3_PI2_PDB_BYPASS_VAL - Firmware Bypass Value for TBG256 aiu_pi2 */
#define BLEAPU_SOCBTAPU_APU_BYPASS2_T3_PI2_PDB_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS2_T3_PI2_PDB_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS2_T3_PI2_PDB_BYPASS_VAL_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS2_TBG_T1_STABLE_BYPASS_EN_MASK (0x2000000U)
#define BLEAPU_SOCBTAPU_APU_BYPASS2_TBG_T1_STABLE_BYPASS_EN_SHIFT (25U)
/*! TBG_T1_STABLE_BYPASS_EN - Firmware Bypass enable for T1 pll_stable signal from APU */
#define BLEAPU_SOCBTAPU_APU_BYPASS2_TBG_T1_STABLE_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS2_TBG_T1_STABLE_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS2_TBG_T1_STABLE_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS2_TBG_T1_STABLE_BYPASS_VAL_MASK (0x4000000U)
#define BLEAPU_SOCBTAPU_APU_BYPASS2_TBG_T1_STABLE_BYPASS_VAL_SHIFT (26U)
/*! TBG_T1_STABLE_BYPASS_VAL - Firmware Bypass value for T1 pll_stable signal from APU */
#define BLEAPU_SOCBTAPU_APU_BYPASS2_TBG_T1_STABLE_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS2_TBG_T1_STABLE_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS2_TBG_T1_STABLE_BYPASS_VAL_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS2_PMIC_DVSC_CTRL_BYPASS_EN_MASK (0x8000000U)
#define BLEAPU_SOCBTAPU_APU_BYPASS2_PMIC_DVSC_CTRL_BYPASS_EN_SHIFT (27U)
/*! PMIC_DVSC_CTRL_BYPASS_EN - Firmware Bypass enable for pmic dvsc ctrl from APU */
#define BLEAPU_SOCBTAPU_APU_BYPASS2_PMIC_DVSC_CTRL_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS2_PMIC_DVSC_CTRL_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS2_PMIC_DVSC_CTRL_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS2_PMIC_DVSC_CTRL_BYPASS_VAL_MASK (0x30000000U)
#define BLEAPU_SOCBTAPU_APU_BYPASS2_PMIC_DVSC_CTRL_BYPASS_VAL_SHIFT (28U)
/*! PMIC_DVSC_CTRL_BYPASS_VAL - Firmware Bypass value for pmic dvsc ctrl from APU (default high power WLAN ode) */
#define BLEAPU_SOCBTAPU_APU_BYPASS2_PMIC_DVSC_CTRL_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS2_PMIC_DVSC_CTRL_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS2_PMIC_DVSC_CTRL_BYPASS_VAL_MASK)
/*! @} */

/*! @name SOCBTAPU_APU_BYPASS3 - APU Bypass Register 3 */
/*! @{ */

#define BLEAPU_SOCBTAPU_APU_BYPASS3_SYS_CLK_EN_BYPASS_EN_MASK (0x10U)
#define BLEAPU_SOCBTAPU_APU_BYPASS3_SYS_CLK_EN_BYPASS_EN_SHIFT (4U)
/*! SYS_CLK_EN_BYPASS_EN - Firmware Bypass for sys clock domain clock enable */
#define BLEAPU_SOCBTAPU_APU_BYPASS3_SYS_CLK_EN_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS3_SYS_CLK_EN_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS3_SYS_CLK_EN_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS3_SYS_CLK_EN_BYPASS_VAL_MASK (0x20U)
#define BLEAPU_SOCBTAPU_APU_BYPASS3_SYS_CLK_EN_BYPASS_VAL_SHIFT (5U)
/*! SYS_CLK_EN_BYPASS_VAL - Firmware Bypass Value for sys clock domain clock enable(active high signal) */
#define BLEAPU_SOCBTAPU_APU_BYPASS3_SYS_CLK_EN_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS3_SYS_CLK_EN_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS3_SYS_CLK_EN_BYPASS_VAL_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS3_SPSRAM_RST_BYPASS_EN_MASK (0x4000U)
#define BLEAPU_SOCBTAPU_APU_BYPASS3_SPSRAM_RST_BYPASS_EN_SHIFT (14U)
/*! SPSRAM_RST_BYPASS_EN - Firmware Bypass for Single power SRAM reset enable */
#define BLEAPU_SOCBTAPU_APU_BYPASS3_SPSRAM_RST_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS3_SPSRAM_RST_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS3_SPSRAM_RST_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS3_SPSRAM_RST_BYPASS_VAL_MASK (0x8000U)
#define BLEAPU_SOCBTAPU_APU_BYPASS3_SPSRAM_RST_BYPASS_VAL_SHIFT (15U)
/*! SPSRAM_RST_BYPASS_VAL - Firmware Bypass Value for single power sram reset(active low signal) */
#define BLEAPU_SOCBTAPU_APU_BYPASS3_SPSRAM_RST_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS3_SPSRAM_RST_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS3_SPSRAM_RST_BYPASS_VAL_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS3_SLNA_BBUD_BRF_BYPASS_EN_MASK (0x10000U)
#define BLEAPU_SOCBTAPU_APU_BYPASS3_SLNA_BBUD_BRF_BYPASS_EN_SHIFT (16U)
/*! SLNA_BBUD_BRF_BYPASS_EN - Firmware Bypass for apu mux control of SLNA gain from bbud/brf */
#define BLEAPU_SOCBTAPU_APU_BYPASS3_SLNA_BBUD_BRF_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS3_SLNA_BBUD_BRF_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS3_SLNA_BBUD_BRF_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_APU_BYPASS3_SLNA_BBUD_BRF_BYPASS_VAL_MASK (0x20000U)
#define BLEAPU_SOCBTAPU_APU_BYPASS3_SLNA_BBUD_BRF_BYPASS_VAL_SHIFT (17U)
/*! SLNA_BBUD_BRF_BYPASS_VAL - Firmware Bypass Value for apu mux control of SLNA gain from bbud/brf */
#define BLEAPU_SOCBTAPU_APU_BYPASS3_SLNA_BBUD_BRF_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_BYPASS3_SLNA_BBUD_BRF_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_APU_BYPASS3_SLNA_BBUD_BRF_BYPASS_VAL_MASK)
/*! @} */

/*! @name SOCBTAPU_APU_CTRL - APU Control */
/*! @{ */

#define BLEAPU_SOCBTAPU_APU_CTRL_APU_REFCLK_DIV_SEL_MASK (0xFU)
#define BLEAPU_SOCBTAPU_APU_CTRL_APU_REFCLK_DIV_SEL_SHIFT (0U)
/*! APU_REFCLK_DIV_SEL - APU Reference Clock Divider Select */
#define BLEAPU_SOCBTAPU_APU_CTRL_APU_REFCLK_DIV_SEL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_CTRL_APU_REFCLK_DIV_SEL_SHIFT)) & BLEAPU_SOCBTAPU_APU_CTRL_APU_REFCLK_DIV_SEL_MASK)

#define BLEAPU_SOCBTAPU_APU_CTRL_FORCE_BTU_WAKEUP_MASK (0x10U)
#define BLEAPU_SOCBTAPU_APU_CTRL_FORCE_BTU_WAKEUP_SHIFT (4U)
/*! FORCE_BTU_WAKEUP - Force BTU Wakeup */
#define BLEAPU_SOCBTAPU_APU_CTRL_FORCE_BTU_WAKEUP(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_CTRL_FORCE_BTU_WAKEUP_SHIFT)) & BLEAPU_SOCBTAPU_APU_CTRL_FORCE_BTU_WAKEUP_MASK)

#define BLEAPU_SOCBTAPU_APU_CTRL_ISU_WKUP_IN_USE_MASK (0x40U)
#define BLEAPU_SOCBTAPU_APU_CTRL_ISU_WKUP_IN_USE_SHIFT (6U)
/*! ISU_WKUP_IN_USE - APU Wakeup */
#define BLEAPU_SOCBTAPU_APU_CTRL_ISU_WKUP_IN_USE(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_CTRL_ISU_WKUP_IN_USE_SHIFT)) & BLEAPU_SOCBTAPU_APU_CTRL_ISU_WKUP_IN_USE_MASK)

#define BLEAPU_SOCBTAPU_APU_CTRL_APU_HOST_WKUP_MASK (0x80U)
#define BLEAPU_SOCBTAPU_APU_CTRL_APU_HOST_WKUP_SHIFT (7U)
/*! APU_HOST_WKUP - APU Wakeup triggered by CPU2 */
#define BLEAPU_SOCBTAPU_APU_CTRL_APU_HOST_WKUP(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_CTRL_APU_HOST_WKUP_SHIFT)) & BLEAPU_SOCBTAPU_APU_CTRL_APU_HOST_WKUP_MASK)

#define BLEAPU_SOCBTAPU_APU_CTRL_BRF_INT_WAKEUP_MASK (0x100U)
#define BLEAPU_SOCBTAPU_APU_CTRL_BRF_INT_WAKEUP_SHIFT (8U)
/*! BRF_INT_WAKEUP - APU Wakeup */
#define BLEAPU_SOCBTAPU_APU_CTRL_BRF_INT_WAKEUP(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_CTRL_BRF_INT_WAKEUP_SHIFT)) & BLEAPU_SOCBTAPU_APU_CTRL_BRF_INT_WAKEUP_MASK)

#define BLEAPU_SOCBTAPU_APU_CTRL_SOC_PA_PE_EN_MASK (0x200U)
#define BLEAPU_SOCBTAPU_APU_CTRL_SOC_PA_PE_EN_SHIFT (9U)
/*! SOC_PA_PE_EN - PA_PE control from SoC to RFU SoC_PA_PE Input */
#define BLEAPU_SOCBTAPU_APU_CTRL_SOC_PA_PE_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_CTRL_SOC_PA_PE_EN_SHIFT)) & BLEAPU_SOCBTAPU_APU_CTRL_SOC_PA_PE_EN_MASK)

#define BLEAPU_SOCBTAPU_APU_CTRL_SOC_PA_PE_A_EN_MASK (0x400U)
#define BLEAPU_SOCBTAPU_APU_CTRL_SOC_PA_PE_A_EN_SHIFT (10U)
/*! SOC_PA_PE_A_EN - PA_PE_A control from SoC to Pad */
#define BLEAPU_SOCBTAPU_APU_CTRL_SOC_PA_PE_A_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_CTRL_SOC_PA_PE_A_EN_SHIFT)) & BLEAPU_SOCBTAPU_APU_CTRL_SOC_PA_PE_A_EN_MASK)

#define BLEAPU_SOCBTAPU_APU_CTRL_SOC_PA_PE_G_EN_MASK (0x800U)
#define BLEAPU_SOCBTAPU_APU_CTRL_SOC_PA_PE_G_EN_SHIFT (11U)
/*! SOC_PA_PE_G_EN - PA_PE_G control from SoC to Pad */
#define BLEAPU_SOCBTAPU_APU_CTRL_SOC_PA_PE_G_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_CTRL_SOC_PA_PE_G_EN_SHIFT)) & BLEAPU_SOCBTAPU_APU_CTRL_SOC_PA_PE_G_EN_MASK)

#define BLEAPU_SOCBTAPU_APU_CTRL_RFU_2G_SRAM_PD_METHOD_SEL_MASK (0x1000U)
#define BLEAPU_SOCBTAPU_APU_CTRL_RFU_2G_SRAM_PD_METHOD_SEL_SHIFT (12U)
/*! RFU_2G_SRAM_PD_METHOD_SEL - Choose apu signal to use for SRAM PD of RFU 2G memories */
#define BLEAPU_SOCBTAPU_APU_CTRL_RFU_2G_SRAM_PD_METHOD_SEL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_CTRL_RFU_2G_SRAM_PD_METHOD_SEL_SHIFT)) & BLEAPU_SOCBTAPU_APU_CTRL_RFU_2G_SRAM_PD_METHOD_SEL_MASK)

#define BLEAPU_SOCBTAPU_APU_CTRL_BRF_SRAM_PD_METHOD_SEL_MASK (0x2000U)
#define BLEAPU_SOCBTAPU_APU_CTRL_BRF_SRAM_PD_METHOD_SEL_SHIFT (13U)
/*! BRF_SRAM_PD_METHOD_SEL - Choose apu signal to use for SRAM PD of BRF memories */
#define BLEAPU_SOCBTAPU_APU_CTRL_BRF_SRAM_PD_METHOD_SEL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_CTRL_BRF_SRAM_PD_METHOD_SEL_SHIFT)) & BLEAPU_SOCBTAPU_APU_CTRL_BRF_SRAM_PD_METHOD_SEL_MASK)

#define BLEAPU_SOCBTAPU_APU_CTRL_LMU_BYPASS_MASK (0x8000U)
#define BLEAPU_SOCBTAPU_APU_CTRL_LMU_BYPASS_SHIFT (15U)
/*! LMU_BYPASS - LMU global bypass bit */
#define BLEAPU_SOCBTAPU_APU_CTRL_LMU_BYPASS(x)   (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_CTRL_LMU_BYPASS_SHIFT)) & BLEAPU_SOCBTAPU_APU_CTRL_LMU_BYPASS_MASK)

#define BLEAPU_SOCBTAPU_APU_CTRL_SOC_PA_PE_EN_MAC2_MASK (0x10000U)
#define BLEAPU_SOCBTAPU_APU_CTRL_SOC_PA_PE_EN_MAC2_SHIFT (16U)
/*! SOC_PA_PE_EN_MAC2 - PA_PE control from MAC2 to RFU SoC_PA_PE Input */
#define BLEAPU_SOCBTAPU_APU_CTRL_SOC_PA_PE_EN_MAC2(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_CTRL_SOC_PA_PE_EN_MAC2_SHIFT)) & BLEAPU_SOCBTAPU_APU_CTRL_SOC_PA_PE_EN_MAC2_MASK)

#define BLEAPU_SOCBTAPU_APU_CTRL_RFU_5G_SRAM_PD_METHOD_SEL_MASK (0x20000U)
#define BLEAPU_SOCBTAPU_APU_CTRL_RFU_5G_SRAM_PD_METHOD_SEL_SHIFT (17U)
/*! RFU_5G_SRAM_PD_METHOD_SEL - Choose apu signal to use for SRAM PD of RFU 5G memories */
#define BLEAPU_SOCBTAPU_APU_CTRL_RFU_5G_SRAM_PD_METHOD_SEL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_CTRL_RFU_5G_SRAM_PD_METHOD_SEL_SHIFT)) & BLEAPU_SOCBTAPU_APU_CTRL_RFU_5G_SRAM_PD_METHOD_SEL_MASK)

#define BLEAPU_SOCBTAPU_APU_CTRL_APU_HOST_WKUP_CPU1_MASK (0x40000U)
#define BLEAPU_SOCBTAPU_APU_CTRL_APU_HOST_WKUP_CPU1_SHIFT (18U)
/*! APU_HOST_WKUP_CPU1 - APU Wakeup triggered by CPU1 */
#define BLEAPU_SOCBTAPU_APU_CTRL_APU_HOST_WKUP_CPU1(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_CTRL_APU_HOST_WKUP_CPU1_SHIFT)) & BLEAPU_SOCBTAPU_APU_CTRL_APU_HOST_WKUP_CPU1_MASK)

#define BLEAPU_SOCBTAPU_APU_CTRL_APU_HOST_WKUP_CPU3_MASK (0x80000U)
#define BLEAPU_SOCBTAPU_APU_CTRL_APU_HOST_WKUP_CPU3_SHIFT (19U)
/*! APU_HOST_WKUP_CPU3 - APU Wakeup triggered by CPU3 */
#define BLEAPU_SOCBTAPU_APU_CTRL_APU_HOST_WKUP_CPU3(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_CTRL_APU_HOST_WKUP_CPU3_SHIFT)) & BLEAPU_SOCBTAPU_APU_CTRL_APU_HOST_WKUP_CPU3_MASK)

#define BLEAPU_SOCBTAPU_APU_CTRL_FORCE_BTU2_WAKEUP_MASK (0x100000U)
#define BLEAPU_SOCBTAPU_APU_CTRL_FORCE_BTU2_WAKEUP_SHIFT (20U)
/*! FORCE_BTU2_WAKEUP - Force BTU2 Wakeup */
#define BLEAPU_SOCBTAPU_APU_CTRL_FORCE_BTU2_WAKEUP(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_CTRL_FORCE_BTU2_WAKEUP_SHIFT)) & BLEAPU_SOCBTAPU_APU_CTRL_FORCE_BTU2_WAKEUP_MASK)
/*! @} */

/*! @name SOCBTAPU_APU_STATUS - APU Status Register */
/*! @{ */

#define BLEAPU_SOCBTAPU_APU_STATUS_BRF_CLK_TBG_SEL_MASK (0x1U)
#define BLEAPU_SOCBTAPU_APU_STATUS_BRF_CLK_TBG_SEL_SHIFT (0U)
/*! BRF_CLK_TBG_SEL - Monitor BRF_Clk_TBG_Sel */
#define BLEAPU_SOCBTAPU_APU_STATUS_BRF_CLK_TBG_SEL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_STATUS_BRF_CLK_TBG_SEL_SHIFT)) & BLEAPU_SOCBTAPU_APU_STATUS_BRF_CLK_TBG_SEL_MASK)

#define BLEAPU_SOCBTAPU_APU_STATUS_BTU_CLK_TBG_SEL_MASK (0x2U)
#define BLEAPU_SOCBTAPU_APU_STATUS_BTU_CLK_TBG_SEL_SHIFT (1U)
/*! BTU_CLK_TBG_SEL - Monitor BTU_Clk_TBG_Sel */
#define BLEAPU_SOCBTAPU_APU_STATUS_BTU_CLK_TBG_SEL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_STATUS_BTU_CLK_TBG_SEL_SHIFT)) & BLEAPU_SOCBTAPU_APU_STATUS_BTU_CLK_TBG_SEL_MASK)

#define BLEAPU_SOCBTAPU_APU_STATUS_SOC_CLK_T3_REF_SEL_MASK (0x4U)
#define BLEAPU_SOCBTAPU_APU_STATUS_SOC_CLK_T3_REF_SEL_SHIFT (2U)
/*! SOC_CLK_T3_REF_SEL - Monitor SoC_Clk_T3_Ref_Sel */
#define BLEAPU_SOCBTAPU_APU_STATUS_SOC_CLK_T3_REF_SEL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_STATUS_SOC_CLK_T3_REF_SEL_SHIFT)) & BLEAPU_SOCBTAPU_APU_STATUS_SOC_CLK_T3_REF_SEL_MASK)

#define BLEAPU_SOCBTAPU_APU_STATUS_SOC_CLK_TBG_SEL_MASK (0x8U)
#define BLEAPU_SOCBTAPU_APU_STATUS_SOC_CLK_TBG_SEL_SHIFT (3U)
/*! SOC_CLK_TBG_SEL - Monitor SoC_Clk_TBG_Sel */
#define BLEAPU_SOCBTAPU_APU_STATUS_SOC_CLK_TBG_SEL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_STATUS_SOC_CLK_TBG_SEL_SHIFT)) & BLEAPU_SOCBTAPU_APU_STATUS_SOC_CLK_TBG_SEL_MASK)
/*! @} */

/*! @name SOCBTAPU_CPU1_LMU_STA_BYPASS0 - LMU static bank control byapss0 Register */
/*! @{ */

#define BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS0_LMU_STA_BANKS_ISO_EN_BP_EN_MASK (0xFFU)
#define BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS0_LMU_STA_BANKS_ISO_EN_BP_EN_SHIFT (0U)
/*! LMU_STA_BANKS_ISO_EN_BP_EN - Firmware Bypass enable for lmu static banks iso_en */
#define BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS0_LMU_STA_BANKS_ISO_EN_BP_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS0_LMU_STA_BANKS_ISO_EN_BP_EN_SHIFT)) & BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS0_LMU_STA_BANKS_ISO_EN_BP_EN_MASK)

#define BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS0_LMU_STA_BANKS_ISO_EN_BP_VAL_MASK (0xFF00U)
#define BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS0_LMU_STA_BANKS_ISO_EN_BP_VAL_SHIFT (8U)
/*! LMU_STA_BANKS_ISO_EN_BP_VAL - Firmware Bypass value for lmu static banks iso_en */
#define BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS0_LMU_STA_BANKS_ISO_EN_BP_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS0_LMU_STA_BANKS_ISO_EN_BP_VAL_SHIFT)) & BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS0_LMU_STA_BANKS_ISO_EN_BP_VAL_MASK)

#define BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS0_LMU_STA_BANKS_PSW_EN_BP_EN_MASK (0xFF0000U)
#define BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS0_LMU_STA_BANKS_PSW_EN_BP_EN_SHIFT (16U)
/*! LMU_STA_BANKS_PSW_EN_BP_EN - Firmware Bypass enable for lmu static banks psw_en */
#define BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS0_LMU_STA_BANKS_PSW_EN_BP_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS0_LMU_STA_BANKS_PSW_EN_BP_EN_SHIFT)) & BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS0_LMU_STA_BANKS_PSW_EN_BP_EN_MASK)

#define BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS0_LMU_STA_BANKS_PSW_EN_BP_VAL_MASK (0xFF000000U)
#define BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS0_LMU_STA_BANKS_PSW_EN_BP_VAL_SHIFT (24U)
/*! LMU_STA_BANKS_PSW_EN_BP_VAL - Firmware Bypass value for lmu static banks psw_en */
#define BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS0_LMU_STA_BANKS_PSW_EN_BP_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS0_LMU_STA_BANKS_PSW_EN_BP_VAL_SHIFT)) & BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS0_LMU_STA_BANKS_PSW_EN_BP_VAL_MASK)
/*! @} */

/*! @name SOCBTAPU_CPU1_LMU_STA_BYPASS1 - LMU static bank control byapss1 Register */
/*! @{ */

#define BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS1_LMU_STA_BANKS_SRAM_PD_BP_EN_MASK (0xFFU)
#define BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS1_LMU_STA_BANKS_SRAM_PD_BP_EN_SHIFT (0U)
/*! LMU_STA_BANKS_SRAM_PD_BP_EN - Firmware Bypass enable for lmu static banks sram_pd */
#define BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS1_LMU_STA_BANKS_SRAM_PD_BP_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS1_LMU_STA_BANKS_SRAM_PD_BP_EN_SHIFT)) & BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS1_LMU_STA_BANKS_SRAM_PD_BP_EN_MASK)

#define BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS1_LMU_STA_BANKS_SRAM_PD_BP_VAL_MASK (0xFF00U)
#define BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS1_LMU_STA_BANKS_SRAM_PD_BP_VAL_SHIFT (8U)
/*! LMU_STA_BANKS_SRAM_PD_BP_VAL - Firmware Bypass value for lmu static banks sram_pd */
#define BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS1_LMU_STA_BANKS_SRAM_PD_BP_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS1_LMU_STA_BANKS_SRAM_PD_BP_VAL_SHIFT)) & BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS1_LMU_STA_BANKS_SRAM_PD_BP_VAL_MASK)

#define BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS1_LMU_STA_BANKS_FNRST_BP_EN_MASK (0xFF0000U)
#define BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS1_LMU_STA_BANKS_FNRST_BP_EN_SHIFT (16U)
/*! LMU_STA_BANKS_FNRST_BP_EN - Firmware Bypass enable for lmu static banks fnrst */
#define BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS1_LMU_STA_BANKS_FNRST_BP_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS1_LMU_STA_BANKS_FNRST_BP_EN_SHIFT)) & BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS1_LMU_STA_BANKS_FNRST_BP_EN_MASK)

#define BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS1_LMU_STA_BANKS_FNRST_BP_VAL_MASK (0xFF000000U)
#define BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS1_LMU_STA_BANKS_FNRST_BP_VAL_SHIFT (24U)
/*! LMU_STA_BANKS_FNRST_BP_VAL - Firmware Bypass value for lmu static banks fnrst */
#define BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS1_LMU_STA_BANKS_FNRST_BP_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS1_LMU_STA_BANKS_FNRST_BP_VAL_SHIFT)) & BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS1_LMU_STA_BANKS_FNRST_BP_VAL_MASK)
/*! @} */

/*! @name SOCBTAPU_CPU1_LMU_STA_BYPASS2 - LMU static bank byapss2 Register */
/*! @{ */

#define BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS2_LMU_STA_BANKS_VDDMC_SW_PD_CTRL_BP_EN_MASK (0xFFU)
#define BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS2_LMU_STA_BANKS_VDDMC_SW_PD_CTRL_BP_EN_SHIFT (0U)
/*! LMU_STA_BANKS_VDDMC_SW_PD_CTRL_BP_EN - Firmware Bypass enable for lmu static banks vddmc_sw_pd_ctrl */
#define BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS2_LMU_STA_BANKS_VDDMC_SW_PD_CTRL_BP_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS2_LMU_STA_BANKS_VDDMC_SW_PD_CTRL_BP_EN_SHIFT)) & BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS2_LMU_STA_BANKS_VDDMC_SW_PD_CTRL_BP_EN_MASK)

#define BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS2_LMU_STA_BANKS_VDDMC_SW_PD_CTRL_BP_VAL_MASK (0xFF00U)
#define BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS2_LMU_STA_BANKS_VDDMC_SW_PD_CTRL_BP_VAL_SHIFT (8U)
/*! LMU_STA_BANKS_VDDMC_SW_PD_CTRL_BP_VAL - Firmware Bypass value for lmu static banks vddmc_sw_pd_ctrl */
#define BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS2_LMU_STA_BANKS_VDDMC_SW_PD_CTRL_BP_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS2_LMU_STA_BANKS_VDDMC_SW_PD_CTRL_BP_VAL_SHIFT)) & BLEAPU_SOCBTAPU_CPU1_LMU_STA_BYPASS2_LMU_STA_BANKS_VDDMC_SW_PD_CTRL_BP_VAL_MASK)
/*! @} */

/*! @name SOCBTAPU_LMU_DYN_BYPASS0 - LMU dynamic bank control byapss0 Register */
/*! @{ */

#define BLEAPU_SOCBTAPU_LMU_DYN_BYPASS0_LMU_DYN_BANKS_VDDMC_SW_PD_CTRL_BP_EN_MASK (0x7U)
#define BLEAPU_SOCBTAPU_LMU_DYN_BYPASS0_LMU_DYN_BANKS_VDDMC_SW_PD_CTRL_BP_EN_SHIFT (0U)
/*! LMU_DYN_BANKS_VDDMC_SW_PD_CTRL_BP_EN - Firmware Bypass enable for lmu dynamic banks vddmc_sw_pd_ctrl */
#define BLEAPU_SOCBTAPU_LMU_DYN_BYPASS0_LMU_DYN_BANKS_VDDMC_SW_PD_CTRL_BP_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_LMU_DYN_BYPASS0_LMU_DYN_BANKS_VDDMC_SW_PD_CTRL_BP_EN_SHIFT)) & BLEAPU_SOCBTAPU_LMU_DYN_BYPASS0_LMU_DYN_BANKS_VDDMC_SW_PD_CTRL_BP_EN_MASK)

#define BLEAPU_SOCBTAPU_LMU_DYN_BYPASS0_LMU_DYN_BANKS_VDDMC_SW_PD_CTRL_BP_VAL_MASK (0x700U)
#define BLEAPU_SOCBTAPU_LMU_DYN_BYPASS0_LMU_DYN_BANKS_VDDMC_SW_PD_CTRL_BP_VAL_SHIFT (8U)
/*! LMU_DYN_BANKS_VDDMC_SW_PD_CTRL_BP_VAL - Firmware Bypass value for lmu dynamic banks vddmc_sw_pd_ctrl */
#define BLEAPU_SOCBTAPU_LMU_DYN_BYPASS0_LMU_DYN_BANKS_VDDMC_SW_PD_CTRL_BP_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_LMU_DYN_BYPASS0_LMU_DYN_BANKS_VDDMC_SW_PD_CTRL_BP_VAL_SHIFT)) & BLEAPU_SOCBTAPU_LMU_DYN_BYPASS0_LMU_DYN_BANKS_VDDMC_SW_PD_CTRL_BP_VAL_MASK)

#define BLEAPU_SOCBTAPU_LMU_DYN_BYPASS0_LMU_DYN_BANKS_FNRST_BP_EN_MASK (0x70000U)
#define BLEAPU_SOCBTAPU_LMU_DYN_BYPASS0_LMU_DYN_BANKS_FNRST_BP_EN_SHIFT (16U)
/*! LMU_DYN_BANKS_FNRST_BP_EN - Firmware Bypass enable for lmu dynamic banks fnrst */
#define BLEAPU_SOCBTAPU_LMU_DYN_BYPASS0_LMU_DYN_BANKS_FNRST_BP_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_LMU_DYN_BYPASS0_LMU_DYN_BANKS_FNRST_BP_EN_SHIFT)) & BLEAPU_SOCBTAPU_LMU_DYN_BYPASS0_LMU_DYN_BANKS_FNRST_BP_EN_MASK)

#define BLEAPU_SOCBTAPU_LMU_DYN_BYPASS0_LMU_DYN_BANKS_FNRST_BP_VAL_MASK (0x7000000U)
#define BLEAPU_SOCBTAPU_LMU_DYN_BYPASS0_LMU_DYN_BANKS_FNRST_BP_VAL_SHIFT (24U)
/*! LMU_DYN_BANKS_FNRST_BP_VAL - Firmware Bypass value for lmu dynamic banks fnrst */
#define BLEAPU_SOCBTAPU_LMU_DYN_BYPASS0_LMU_DYN_BANKS_FNRST_BP_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_LMU_DYN_BYPASS0_LMU_DYN_BANKS_FNRST_BP_VAL_SHIFT)) & BLEAPU_SOCBTAPU_LMU_DYN_BYPASS0_LMU_DYN_BANKS_FNRST_BP_VAL_MASK)

#define BLEAPU_SOCBTAPU_LMU_DYN_BYPASS0_LMU_DYN_BANKS_SRAM_FNRST_USE_WLAN_FNRST_MASK (0x80000000U)
#define BLEAPU_SOCBTAPU_LMU_DYN_BYPASS0_LMU_DYN_BANKS_SRAM_FNRST_USE_WLAN_FNRST_SHIFT (31U)
/*! LMU_DYN_BANKS_SRAM_FNRST_USE_WLAN_FNRST - 1: By default WLAN_SRAM_FNRST is used for SMU off domain banks */
#define BLEAPU_SOCBTAPU_LMU_DYN_BYPASS0_LMU_DYN_BANKS_SRAM_FNRST_USE_WLAN_FNRST(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_LMU_DYN_BYPASS0_LMU_DYN_BANKS_SRAM_FNRST_USE_WLAN_FNRST_SHIFT)) & BLEAPU_SOCBTAPU_LMU_DYN_BYPASS0_LMU_DYN_BANKS_SRAM_FNRST_USE_WLAN_FNRST_MASK)
/*! @} */

/*! @name SOCBTAPU_LMU_G2BIST_CTRL_BYPASS - LMU G2Bist control bypass Register */
/*! @{ */

#define BLEAPU_SOCBTAPU_LMU_G2BIST_CTRL_BYPASS_LMU_G2BIST_MODE_BYPASS_EN_MASK (0x1U)
#define BLEAPU_SOCBTAPU_LMU_G2BIST_CTRL_BYPASS_LMU_G2BIST_MODE_BYPASS_EN_SHIFT (0U)
/*! LMU_G2BIST_MODE_BYPASS_EN - Firmware Bypass enable for lmu g2bist mode */
#define BLEAPU_SOCBTAPU_LMU_G2BIST_CTRL_BYPASS_LMU_G2BIST_MODE_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_LMU_G2BIST_CTRL_BYPASS_LMU_G2BIST_MODE_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_LMU_G2BIST_CTRL_BYPASS_LMU_G2BIST_MODE_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_LMU_G2BIST_CTRL_BYPASS_LMU_G2BIST_MODE_BYPASS_VAL_MASK (0x3EU)
#define BLEAPU_SOCBTAPU_LMU_G2BIST_CTRL_BYPASS_LMU_G2BIST_MODE_BYPASS_VAL_SHIFT (1U)
/*! LMU_G2BIST_MODE_BYPASS_VAL - Firmware Bypass value for lmu g2bist mode */
#define BLEAPU_SOCBTAPU_LMU_G2BIST_CTRL_BYPASS_LMU_G2BIST_MODE_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_LMU_G2BIST_CTRL_BYPASS_LMU_G2BIST_MODE_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_LMU_G2BIST_CTRL_BYPASS_LMU_G2BIST_MODE_BYPASS_VAL_MASK)

#define BLEAPU_SOCBTAPU_LMU_G2BIST_CTRL_BYPASS_LMU_G2BIST_START_BP_EN_MASK (0x1000000U)
#define BLEAPU_SOCBTAPU_LMU_G2BIST_CTRL_BYPASS_LMU_G2BIST_START_BP_EN_SHIFT (24U)
/*! LMU_G2BIST_START_BP_EN - Firmware Bypass enable for lmu g2bist start */
#define BLEAPU_SOCBTAPU_LMU_G2BIST_CTRL_BYPASS_LMU_G2BIST_START_BP_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_LMU_G2BIST_CTRL_BYPASS_LMU_G2BIST_START_BP_EN_SHIFT)) & BLEAPU_SOCBTAPU_LMU_G2BIST_CTRL_BYPASS_LMU_G2BIST_START_BP_EN_MASK)

#define BLEAPU_SOCBTAPU_LMU_G2BIST_CTRL_BYPASS_LMU_G2BIST_START_BP_VAL_MASK (0x2000000U)
#define BLEAPU_SOCBTAPU_LMU_G2BIST_CTRL_BYPASS_LMU_G2BIST_START_BP_VAL_SHIFT (25U)
/*! LMU_G2BIST_START_BP_VAL - Firmware Bypass value for lmu g2bist start */
#define BLEAPU_SOCBTAPU_LMU_G2BIST_CTRL_BYPASS_LMU_G2BIST_START_BP_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_LMU_G2BIST_CTRL_BYPASS_LMU_G2BIST_START_BP_VAL_SHIFT)) & BLEAPU_SOCBTAPU_LMU_G2BIST_CTRL_BYPASS_LMU_G2BIST_START_BP_VAL_MASK)

#define BLEAPU_SOCBTAPU_LMU_G2BIST_CTRL_BYPASS_LMU_G2BIST_CLK_EN_BP_EN_MASK (0x4000000U)
#define BLEAPU_SOCBTAPU_LMU_G2BIST_CTRL_BYPASS_LMU_G2BIST_CLK_EN_BP_EN_SHIFT (26U)
/*! LMU_G2BIST_CLK_EN_BP_EN - Firmware Bypass enable for lmu g2bist clock en */
#define BLEAPU_SOCBTAPU_LMU_G2BIST_CTRL_BYPASS_LMU_G2BIST_CLK_EN_BP_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_LMU_G2BIST_CTRL_BYPASS_LMU_G2BIST_CLK_EN_BP_EN_SHIFT)) & BLEAPU_SOCBTAPU_LMU_G2BIST_CTRL_BYPASS_LMU_G2BIST_CLK_EN_BP_EN_MASK)

#define BLEAPU_SOCBTAPU_LMU_G2BIST_CTRL_BYPASS_LMU_G2BIST_CLK_EN_BP_VAL_MASK (0x8000000U)
#define BLEAPU_SOCBTAPU_LMU_G2BIST_CTRL_BYPASS_LMU_G2BIST_CLK_EN_BP_VAL_SHIFT (27U)
/*! LMU_G2BIST_CLK_EN_BP_VAL - Firmware Bypass value for lmu g2bist clock en */
#define BLEAPU_SOCBTAPU_LMU_G2BIST_CTRL_BYPASS_LMU_G2BIST_CLK_EN_BP_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_LMU_G2BIST_CTRL_BYPASS_LMU_G2BIST_CLK_EN_BP_VAL_SHIFT)) & BLEAPU_SOCBTAPU_LMU_G2BIST_CTRL_BYPASS_LMU_G2BIST_CLK_EN_BP_VAL_MASK)

#define BLEAPU_SOCBTAPU_LMU_G2BIST_CTRL_BYPASS_G2BIST_STATUS_MASK (0xF0000000U)
#define BLEAPU_SOCBTAPU_LMU_G2BIST_CTRL_BYPASS_G2BIST_STATUS_SHIFT (28U)
/*! G2BIST_STATUS - g2bist status */
#define BLEAPU_SOCBTAPU_LMU_G2BIST_CTRL_BYPASS_G2BIST_STATUS(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_LMU_G2BIST_CTRL_BYPASS_G2BIST_STATUS_SHIFT)) & BLEAPU_SOCBTAPU_LMU_G2BIST_CTRL_BYPASS_G2BIST_STATUS_MASK)
/*! @} */

/*! @name SOCBTAPU_CPU1_LMU_G2BIST_CTRL_BYPASS - LMU G2Bist control bypass Register for CPU1 */
/*! @{ */

#define BLEAPU_SOCBTAPU_CPU1_LMU_G2BIST_CTRL_BYPASS_LMU_CPU1_STA_PWRDMN_RPR_REQ_BP_EN_MASK (0x1U)
#define BLEAPU_SOCBTAPU_CPU1_LMU_G2BIST_CTRL_BYPASS_LMU_CPU1_STA_PWRDMN_RPR_REQ_BP_EN_SHIFT (0U)
/*! LMU_CPU1_STA_PWRDMN_RPR_REQ_BP_EN - Firmware Bypass enable for CPU1 static banks lmu powerdomain repair request */
#define BLEAPU_SOCBTAPU_CPU1_LMU_G2BIST_CTRL_BYPASS_LMU_CPU1_STA_PWRDMN_RPR_REQ_BP_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_CPU1_LMU_G2BIST_CTRL_BYPASS_LMU_CPU1_STA_PWRDMN_RPR_REQ_BP_EN_SHIFT)) & BLEAPU_SOCBTAPU_CPU1_LMU_G2BIST_CTRL_BYPASS_LMU_CPU1_STA_PWRDMN_RPR_REQ_BP_EN_MASK)

#define BLEAPU_SOCBTAPU_CPU1_LMU_G2BIST_CTRL_BYPASS_LMU_CPU1_STA_PWRDMN_RPR_REQ_BP_VAL_MASK (0xFFF0U)
#define BLEAPU_SOCBTAPU_CPU1_LMU_G2BIST_CTRL_BYPASS_LMU_CPU1_STA_PWRDMN_RPR_REQ_BP_VAL_SHIFT (4U)
/*! LMU_CPU1_STA_PWRDMN_RPR_REQ_BP_VAL - Firmware Bypass value for CPU1 static banks lmu powerdomain repair request */
#define BLEAPU_SOCBTAPU_CPU1_LMU_G2BIST_CTRL_BYPASS_LMU_CPU1_STA_PWRDMN_RPR_REQ_BP_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_CPU1_LMU_G2BIST_CTRL_BYPASS_LMU_CPU1_STA_PWRDMN_RPR_REQ_BP_VAL_SHIFT)) & BLEAPU_SOCBTAPU_CPU1_LMU_G2BIST_CTRL_BYPASS_LMU_CPU1_STA_PWRDMN_RPR_REQ_BP_VAL_MASK)

#define BLEAPU_SOCBTAPU_CPU1_LMU_G2BIST_CTRL_BYPASS_LMU_SMU1_DYN_PWRDMN_RPR_REQ_BP_EN_MASK (0x100000U)
#define BLEAPU_SOCBTAPU_CPU1_LMU_G2BIST_CTRL_BYPASS_LMU_SMU1_DYN_PWRDMN_RPR_REQ_BP_EN_SHIFT (20U)
/*! LMU_SMU1_DYN_PWRDMN_RPR_REQ_BP_EN - Firmware Bypass enable for SMU1 dynamic banks lmu powerdomain repair request */
#define BLEAPU_SOCBTAPU_CPU1_LMU_G2BIST_CTRL_BYPASS_LMU_SMU1_DYN_PWRDMN_RPR_REQ_BP_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_CPU1_LMU_G2BIST_CTRL_BYPASS_LMU_SMU1_DYN_PWRDMN_RPR_REQ_BP_EN_SHIFT)) & BLEAPU_SOCBTAPU_CPU1_LMU_G2BIST_CTRL_BYPASS_LMU_SMU1_DYN_PWRDMN_RPR_REQ_BP_EN_MASK)

#define BLEAPU_SOCBTAPU_CPU1_LMU_G2BIST_CTRL_BYPASS_LMU_SMU1_DYN_PWRDMN_RPR_REQ_BP_VAL_MASK (0xF000000U)
#define BLEAPU_SOCBTAPU_CPU1_LMU_G2BIST_CTRL_BYPASS_LMU_SMU1_DYN_PWRDMN_RPR_REQ_BP_VAL_SHIFT (24U)
/*! LMU_SMU1_DYN_PWRDMN_RPR_REQ_BP_VAL - Firmware Bypass value for SMU1 dynamic banks lmu powerdomain repair request */
#define BLEAPU_SOCBTAPU_CPU1_LMU_G2BIST_CTRL_BYPASS_LMU_SMU1_DYN_PWRDMN_RPR_REQ_BP_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_CPU1_LMU_G2BIST_CTRL_BYPASS_LMU_SMU1_DYN_PWRDMN_RPR_REQ_BP_VAL_SHIFT)) & BLEAPU_SOCBTAPU_CPU1_LMU_G2BIST_CTRL_BYPASS_LMU_SMU1_DYN_PWRDMN_RPR_REQ_BP_VAL_MASK)
/*! @} */

/*! @name SOCBTAPU_APU_PWR_CTRL_BYPASS5 - " */
/*! @{ */

#define BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS5_CPU1_VINITHI_BYPASS_VAL_MASK (0x1000U)
#define BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS5_CPU1_VINITHI_BYPASS_VAL_SHIFT (12U)
/*! CPU1_VINITHI_BYPASS_VAL - Firmware Bypass Value for CPU1 Vinithi (default boot from ROM) */
#define BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS5_CPU1_VINITHI_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS5_CPU1_VINITHI_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS5_CPU1_VINITHI_BYPASS_VAL_MASK)

#define BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS5_CPU1_VINITHI_BYPASS_EN_MASK (0x2000U)
#define BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS5_CPU1_VINITHI_BYPASS_EN_SHIFT (13U)
/*! CPU1_VINITHI_BYPASS_EN - Firmware Bypass enable for CPU1 Vinithi */
#define BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS5_CPU1_VINITHI_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS5_CPU1_VINITHI_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_APU_PWR_CTRL_BYPASS5_CPU1_VINITHI_BYPASS_EN_MASK)
/*! @} */

/*! @name SOCBTAPU_SMU1_HYBRID_LMU_BYPASS0 - LMU static bank control byapss0 Register for smu1 hybrid banks mem */
/*! @{ */

#define BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS0_LMU_HYBRID_BANKS_ISO_EN_BP_EN_MASK (0xFFU)
#define BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS0_LMU_HYBRID_BANKS_ISO_EN_BP_EN_SHIFT (0U)
/*! LMU_HYBRID_BANKS_ISO_EN_BP_EN - Firmware Bypass enable for lmu static banks iso_en */
#define BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS0_LMU_HYBRID_BANKS_ISO_EN_BP_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS0_LMU_HYBRID_BANKS_ISO_EN_BP_EN_SHIFT)) & BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS0_LMU_HYBRID_BANKS_ISO_EN_BP_EN_MASK)

#define BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS0_LMU_HYBRID_BANKS_ISO_EN_BP_VAL_MASK (0xFF00U)
#define BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS0_LMU_HYBRID_BANKS_ISO_EN_BP_VAL_SHIFT (8U)
/*! LMU_HYBRID_BANKS_ISO_EN_BP_VAL - Firmware Bypass value for lmu static banks iso_en */
#define BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS0_LMU_HYBRID_BANKS_ISO_EN_BP_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS0_LMU_HYBRID_BANKS_ISO_EN_BP_VAL_SHIFT)) & BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS0_LMU_HYBRID_BANKS_ISO_EN_BP_VAL_MASK)

#define BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS0_LMU_HYBRID_BANKS_PSW_EN_BP_EN_MASK (0xFF0000U)
#define BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS0_LMU_HYBRID_BANKS_PSW_EN_BP_EN_SHIFT (16U)
/*! LMU_HYBRID_BANKS_PSW_EN_BP_EN - Firmware Bypass enable for lmu static banks psw_en */
#define BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS0_LMU_HYBRID_BANKS_PSW_EN_BP_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS0_LMU_HYBRID_BANKS_PSW_EN_BP_EN_SHIFT)) & BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS0_LMU_HYBRID_BANKS_PSW_EN_BP_EN_MASK)

#define BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS0_LMU_HYBRID_BANKS_PSW_EN_BP_VAL_MASK (0xFF000000U)
#define BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS0_LMU_HYBRID_BANKS_PSW_EN_BP_VAL_SHIFT (24U)
/*! LMU_HYBRID_BANKS_PSW_EN_BP_VAL - Firmware Bypass value for lmu static banks psw_en */
#define BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS0_LMU_HYBRID_BANKS_PSW_EN_BP_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS0_LMU_HYBRID_BANKS_PSW_EN_BP_VAL_SHIFT)) & BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS0_LMU_HYBRID_BANKS_PSW_EN_BP_VAL_MASK)
/*! @} */

/*! @name SOCBTAPU_SMU1_HYBRID_LMU_BYPASS1 - LMU static bank control byapss1 Register for smu1 hybrid banks mem */
/*! @{ */

#define BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS1_LMU_HYBRID_BANKS_SRAM_PD_BP_EN_MASK (0xFFU)
#define BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS1_LMU_HYBRID_BANKS_SRAM_PD_BP_EN_SHIFT (0U)
/*! LMU_HYBRID_BANKS_SRAM_PD_BP_EN - Firmware Bypass enable for lmu static banks sram_pd */
#define BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS1_LMU_HYBRID_BANKS_SRAM_PD_BP_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS1_LMU_HYBRID_BANKS_SRAM_PD_BP_EN_SHIFT)) & BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS1_LMU_HYBRID_BANKS_SRAM_PD_BP_EN_MASK)

#define BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS1_LMU_HYBRID_BANKS_SRAM_PD_BP_VAL_MASK (0xFF00U)
#define BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS1_LMU_HYBRID_BANKS_SRAM_PD_BP_VAL_SHIFT (8U)
/*! LMU_HYBRID_BANKS_SRAM_PD_BP_VAL - Firmware Bypass value for lmu static banks sram_pd */
#define BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS1_LMU_HYBRID_BANKS_SRAM_PD_BP_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS1_LMU_HYBRID_BANKS_SRAM_PD_BP_VAL_SHIFT)) & BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS1_LMU_HYBRID_BANKS_SRAM_PD_BP_VAL_MASK)

#define BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS1_LMU_HYBRID_BANKS_FNRST_BP_EN_MASK (0xFF0000U)
#define BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS1_LMU_HYBRID_BANKS_FNRST_BP_EN_SHIFT (16U)
/*! LMU_HYBRID_BANKS_FNRST_BP_EN - Firmware Bypass enable for lmu static banks fnrst */
#define BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS1_LMU_HYBRID_BANKS_FNRST_BP_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS1_LMU_HYBRID_BANKS_FNRST_BP_EN_SHIFT)) & BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS1_LMU_HYBRID_BANKS_FNRST_BP_EN_MASK)

#define BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS1_LMU_HYBRID_BANKS_FNRST_BP_VAL_MASK (0xFF000000U)
#define BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS1_LMU_HYBRID_BANKS_FNRST_BP_VAL_SHIFT (24U)
/*! LMU_HYBRID_BANKS_FNRST_BP_VAL - Firmware Bypass value for lmu static banks fnrst */
#define BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS1_LMU_HYBRID_BANKS_FNRST_BP_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS1_LMU_HYBRID_BANKS_FNRST_BP_VAL_SHIFT)) & BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS1_LMU_HYBRID_BANKS_FNRST_BP_VAL_MASK)
/*! @} */

/*! @name SOCBTAPU_SMU1_HYBRID_LMU_BYPASS2 - LMU static bank control byapss2 Register for smu1 hybrid banks mem */
/*! @{ */

#define BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS2_LMU_HYBRID_BANKS_VDDMC_SW_PD_CTRL_BP_EN_MASK (0xFFU)
#define BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS2_LMU_HYBRID_BANKS_VDDMC_SW_PD_CTRL_BP_EN_SHIFT (0U)
/*! LMU_HYBRID_BANKS_VDDMC_SW_PD_CTRL_BP_EN - Firmware Bypass enable for lmu static banks vddmc_sw_pd_ctrl */
#define BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS2_LMU_HYBRID_BANKS_VDDMC_SW_PD_CTRL_BP_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS2_LMU_HYBRID_BANKS_VDDMC_SW_PD_CTRL_BP_EN_SHIFT)) & BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS2_LMU_HYBRID_BANKS_VDDMC_SW_PD_CTRL_BP_EN_MASK)

#define BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS2_LMU_HYBRID_BANKS_VDDMC_SW_PD_CTRL_BP_VAL_MASK (0xFF00U)
#define BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS2_LMU_HYBRID_BANKS_VDDMC_SW_PD_CTRL_BP_VAL_SHIFT (8U)
/*! LMU_HYBRID_BANKS_VDDMC_SW_PD_CTRL_BP_VAL - Firmware Bypass value for lmu static banks vddmc_sw_pd_ctrl */
#define BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS2_LMU_HYBRID_BANKS_VDDMC_SW_PD_CTRL_BP_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS2_LMU_HYBRID_BANKS_VDDMC_SW_PD_CTRL_BP_VAL_SHIFT)) & BLEAPU_SOCBTAPU_SMU1_HYBRID_LMU_BYPASS2_LMU_HYBRID_BANKS_VDDMC_SW_PD_CTRL_BP_VAL_MASK)
/*! @} */

/*! @name SOCBTAPU_APU_ECO_CTRL - APU ECO Control */
/*! @{ */

#define BLEAPU_SOCBTAPU_APU_ECO_CTRL_ECO_BITS_MASK (0xFFFFFFFFU)
#define BLEAPU_SOCBTAPU_APU_ECO_CTRL_ECO_BITS_SHIFT (0U)
/*! ECO_BITS - Reserved for ECOs */
#define BLEAPU_SOCBTAPU_APU_ECO_CTRL_ECO_BITS(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_APU_ECO_CTRL_ECO_BITS_SHIFT)) & BLEAPU_SOCBTAPU_APU_ECO_CTRL_ECO_BITS_MASK)
/*! @} */

/*! @name SOCBTAPU_GPIO_WKUP_CTRL0 - " */
/*! @{ */

#define BLEAPU_SOCBTAPU_GPIO_WKUP_CTRL0_P2C_WKUP_SELECT_MASK (0xFFFFFFFFU)
#define BLEAPU_SOCBTAPU_GPIO_WKUP_CTRL0_P2C_WKUP_SELECT_SHIFT (0U)
/*! P2C_WKUP_SELECT - [07:00]: Mux 1 of 32 p2c_pad_wkup input pins to APU wakeup input [0] */
#define BLEAPU_SOCBTAPU_GPIO_WKUP_CTRL0_P2C_WKUP_SELECT(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_GPIO_WKUP_CTRL0_P2C_WKUP_SELECT_SHIFT)) & BLEAPU_SOCBTAPU_GPIO_WKUP_CTRL0_P2C_WKUP_SELECT_MASK)
/*! @} */

/*! @name SOCBTAPU_GPIO_WKUP_CTRL1 - " */
/*! @{ */

#define BLEAPU_SOCBTAPU_GPIO_WKUP_CTRL1_P2C_WKUP_SELECT_MASK (0xFFFFFFFFU)
#define BLEAPU_SOCBTAPU_GPIO_WKUP_CTRL1_P2C_WKUP_SELECT_SHIFT (0U)
/*! P2C_WKUP_SELECT - [07:00]: Mux 1 of 32 p2c_pad_wkup input pins to APU wakeup input [4] */
#define BLEAPU_SOCBTAPU_GPIO_WKUP_CTRL1_P2C_WKUP_SELECT(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_GPIO_WKUP_CTRL1_P2C_WKUP_SELECT_SHIFT)) & BLEAPU_SOCBTAPU_GPIO_WKUP_CTRL1_P2C_WKUP_SELECT_MASK)
/*! @} */

/*! @name SOCBTAPU_GPIO_WKUP_CTRL2 - " */
/*! @{ */

#define BLEAPU_SOCBTAPU_GPIO_WKUP_CTRL2_P2C_WKUP_SELECT_MASK (0xFFFFFFFFU)
#define BLEAPU_SOCBTAPU_GPIO_WKUP_CTRL2_P2C_WKUP_SELECT_SHIFT (0U)
/*! P2C_WKUP_SELECT - [07:00]: Mux 1 of 32 p2c_pad_wkup input pins to APU wakeup input [8] */
#define BLEAPU_SOCBTAPU_GPIO_WKUP_CTRL2_P2C_WKUP_SELECT(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_GPIO_WKUP_CTRL2_P2C_WKUP_SELECT_SHIFT)) & BLEAPU_SOCBTAPU_GPIO_WKUP_CTRL2_P2C_WKUP_SELECT_MASK)
/*! @} */

/*! @name SOCBTAPU_GPIO_WKUP_CTRL3 - " */
/*! @{ */

#define BLEAPU_SOCBTAPU_GPIO_WKUP_CTRL3_P2C_WKUP_SELECT_MASK (0xFFFFFFFFU)
#define BLEAPU_SOCBTAPU_GPIO_WKUP_CTRL3_P2C_WKUP_SELECT_SHIFT (0U)
/*! P2C_WKUP_SELECT - [07:00]: Mux 1 of 32 p2c_pad_wkup input pins to APU wakeup input [12] */
#define BLEAPU_SOCBTAPU_GPIO_WKUP_CTRL3_P2C_WKUP_SELECT(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_GPIO_WKUP_CTRL3_P2C_WKUP_SELECT_SHIFT)) & BLEAPU_SOCBTAPU_GPIO_WKUP_CTRL3_P2C_WKUP_SELECT_MASK)
/*! @} */

/*! @name SOCBTAPU_HOST_WKUP_MODE - " */
/*! @{ */

#define BLEAPU_SOCBTAPU_HOST_WKUP_MODE_GPIO_SEL_MASK (0xFFFFU)
#define BLEAPU_SOCBTAPU_HOST_WKUP_MODE_GPIO_SEL_SHIFT (0U)
/*! GPIO_SEL - GPIO select */
#define BLEAPU_SOCBTAPU_HOST_WKUP_MODE_GPIO_SEL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_HOST_WKUP_MODE_GPIO_SEL_SHIFT)) & BLEAPU_SOCBTAPU_HOST_WKUP_MODE_GPIO_SEL_MASK)
/*! @} */

/*! @name SOCBTAPU_T3_CLK_DIV_EN_BYPASS - " */
/*! @{ */

#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_256_CLK_DIV_EN_BYPASS_EN_MASK (0x1U)
#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_256_CLK_DIV_EN_BYPASS_EN_SHIFT (0U)
/*! T3_SOC_256_CLK_DIV_EN_BYPASS_EN - Enable/ disable value: */
#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_256_CLK_DIV_EN_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_256_CLK_DIV_EN_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_256_CLK_DIV_EN_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_256_CLK_DIV_EN_BYPASS_VAL_MASK (0x2U)
#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_256_CLK_DIV_EN_BYPASS_VAL_SHIFT (1U)
/*! T3_SOC_256_CLK_DIV_EN_BYPASS_VAL - bypass value */
#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_256_CLK_DIV_EN_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_256_CLK_DIV_EN_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_256_CLK_DIV_EN_BYPASS_VAL_MASK)

#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_320_CLK_DIV_EN_BYPASS_EN_MASK (0x4U)
#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_320_CLK_DIV_EN_BYPASS_EN_SHIFT (2U)
/*! T3_SOC_320_CLK_DIV_EN_BYPASS_EN - Enable/ disable value: */
#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_320_CLK_DIV_EN_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_320_CLK_DIV_EN_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_320_CLK_DIV_EN_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_320_CLK_DIV_EN_BYPASS_VAL_MASK (0x8U)
#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_320_CLK_DIV_EN_BYPASS_VAL_SHIFT (3U)
/*! T3_SOC_320_CLK_DIV_EN_BYPASS_VAL - bypass value */
#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_320_CLK_DIV_EN_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_320_CLK_DIV_EN_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_320_CLK_DIV_EN_BYPASS_VAL_MASK)

#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_365P7_CLK_DIV_EN_BYPASS_EN_MASK (0x10U)
#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_365P7_CLK_DIV_EN_BYPASS_EN_SHIFT (4U)
/*! T3_SOC_365P7_CLK_DIV_EN_BYPASS_EN - Enable/ disable value: */
#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_365P7_CLK_DIV_EN_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_365P7_CLK_DIV_EN_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_365P7_CLK_DIV_EN_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_365P7_CLK_DIV_EN_BYPASS_VAL_MASK (0x20U)
#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_365P7_CLK_DIV_EN_BYPASS_VAL_SHIFT (5U)
/*! T3_SOC_365P7_CLK_DIV_EN_BYPASS_VAL - bypass value */
#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_365P7_CLK_DIV_EN_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_365P7_CLK_DIV_EN_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_365P7_CLK_DIV_EN_BYPASS_VAL_MASK)

#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_426_CLK_DIV_EN_BYPASS_EN_MASK (0x40U)
#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_426_CLK_DIV_EN_BYPASS_EN_SHIFT (6U)
/*! T3_SOC_426_CLK_DIV_EN_BYPASS_EN - Enable/ disable value: */
#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_426_CLK_DIV_EN_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_426_CLK_DIV_EN_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_426_CLK_DIV_EN_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_426_CLK_DIV_EN_BYPASS_VAL_MASK (0x80U)
#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_426_CLK_DIV_EN_BYPASS_VAL_SHIFT (7U)
/*! T3_SOC_426_CLK_DIV_EN_BYPASS_VAL - bypass value */
#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_426_CLK_DIV_EN_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_426_CLK_DIV_EN_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_426_CLK_DIV_EN_BYPASS_VAL_MASK)

#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_512_CLK_DIV_EN_BYPASS_EN_MASK (0x100U)
#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_512_CLK_DIV_EN_BYPASS_EN_SHIFT (8U)
/*! T3_SOC_512_CLK_DIV_EN_BYPASS_EN - Enable/ disable value: */
#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_512_CLK_DIV_EN_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_512_CLK_DIV_EN_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_512_CLK_DIV_EN_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_512_CLK_DIV_EN_BYPASS_VAL_MASK (0x200U)
#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_512_CLK_DIV_EN_BYPASS_VAL_SHIFT (9U)
/*! T3_SOC_512_CLK_DIV_EN_BYPASS_VAL - bypass value */
#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_512_CLK_DIV_EN_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_512_CLK_DIV_EN_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_SOC_512_CLK_DIV_EN_BYPASS_VAL_MASK)

#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_213P3_CLK_DIV_EN_BYPASS_EN_MASK (0x400U)
#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_213P3_CLK_DIV_EN_BYPASS_EN_SHIFT (10U)
/*! T3_213P3_CLK_DIV_EN_BYPASS_EN - Enable/ disable value: */
#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_213P3_CLK_DIV_EN_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_213P3_CLK_DIV_EN_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_213P3_CLK_DIV_EN_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_213P3_CLK_DIV_EN_BYPASS_VAL_MASK (0x800U)
#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_213P3_CLK_DIV_EN_BYPASS_VAL_SHIFT (11U)
/*! T3_213P3_CLK_DIV_EN_BYPASS_VAL - bypass value */
#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_213P3_CLK_DIV_EN_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_213P3_CLK_DIV_EN_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_213P3_CLK_DIV_EN_BYPASS_VAL_MASK)

#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_MAC1_CLK_DIV_EN_BYPASS_EN_MASK (0x1000U)
#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_MAC1_CLK_DIV_EN_BYPASS_EN_SHIFT (12U)
/*! T3_MAC1_CLK_DIV_EN_BYPASS_EN - Enable/ disable value: */
#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_MAC1_CLK_DIV_EN_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_MAC1_CLK_DIV_EN_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_MAC1_CLK_DIV_EN_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_MAC1_CLK_DIV_EN_BYPASS_VAL_MASK (0x2000U)
#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_MAC1_CLK_DIV_EN_BYPASS_VAL_SHIFT (13U)
/*! T3_MAC1_CLK_DIV_EN_BYPASS_VAL - bypass value */
#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_MAC1_CLK_DIV_EN_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_MAC1_CLK_DIV_EN_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_MAC1_CLK_DIV_EN_BYPASS_VAL_MASK)

#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_MAC2_CLK_DIV_EN_BYPASS_EN_MASK (0x4000U)
#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_MAC2_CLK_DIV_EN_BYPASS_EN_SHIFT (14U)
/*! T3_MAC2_CLK_DIV_EN_BYPASS_EN - Enable/ disable value: */
#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_MAC2_CLK_DIV_EN_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_MAC2_CLK_DIV_EN_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_MAC2_CLK_DIV_EN_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_MAC2_CLK_DIV_EN_BYPASS_VAL_MASK (0x8000U)
#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_MAC2_CLK_DIV_EN_BYPASS_VAL_SHIFT (15U)
/*! T3_MAC2_CLK_DIV_EN_BYPASS_VAL - bypass value */
#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_MAC2_CLK_DIV_EN_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_MAC2_CLK_DIV_EN_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_MAC2_CLK_DIV_EN_BYPASS_VAL_MASK)

#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_BBUD_CLK_DIV_EN_BYPASS_EN_MASK (0x10000U)
#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_BBUD_CLK_DIV_EN_BYPASS_EN_SHIFT (16U)
/*! T3_BBUD_CLK_DIV_EN_BYPASS_EN - Enable/ disable value: */
#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_BBUD_CLK_DIV_EN_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_BBUD_CLK_DIV_EN_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_BBUD_CLK_DIV_EN_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_BBUD_CLK_DIV_EN_BYPASS_VAL_MASK (0x20000U)
#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_BBUD_CLK_DIV_EN_BYPASS_VAL_SHIFT (17U)
/*! T3_BBUD_CLK_DIV_EN_BYPASS_VAL - bypass value */
#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_BBUD_CLK_DIV_EN_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_BBUD_CLK_DIV_EN_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_T3_BBUD_CLK_DIV_EN_BYPASS_VAL_MASK)

#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_TCPU_CPU_CLK_DIV_EN_BYPASS_EN_MASK (0x40000U)
#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_TCPU_CPU_CLK_DIV_EN_BYPASS_EN_SHIFT (18U)
/*! TCPU_CPU_CLK_DIV_EN_BYPASS_EN - Enable/ disable value: */
#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_TCPU_CPU_CLK_DIV_EN_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_TCPU_CPU_CLK_DIV_EN_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_TCPU_CPU_CLK_DIV_EN_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_TCPU_CPU_CLK_DIV_EN_BYPASS_VAL_MASK (0x80000U)
#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_TCPU_CPU_CLK_DIV_EN_BYPASS_VAL_SHIFT (19U)
/*! TCPU_CPU_CLK_DIV_EN_BYPASS_VAL - bypass value for tcpu cpu_clk_en */
#define BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_TCPU_CPU_CLK_DIV_EN_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_TCPU_CPU_CLK_DIV_EN_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_T3_CLK_DIV_EN_BYPASS_TCPU_CPU_CLK_DIV_EN_BYPASS_VAL_MASK)
/*! @} */

/*! @name SOCBTAPU_LDO_LV_CTRL2 - LV LDO Control 2 */
/*! @{ */

#define BLEAPU_SOCBTAPU_LDO_LV_CTRL2_LDO_GLU_XOSC_VAL_MASK (0x10U)
#define BLEAPU_SOCBTAPU_LDO_LV_CTRL2_LDO_GLU_XOSC_VAL_SHIFT (4U)
/*! LDO_GLU_XOSC_VAL - XOSC_EN value for ldo control logic set by FW */
#define BLEAPU_SOCBTAPU_LDO_LV_CTRL2_LDO_GLU_XOSC_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_LDO_LV_CTRL2_LDO_GLU_XOSC_VAL_SHIFT)) & BLEAPU_SOCBTAPU_LDO_LV_CTRL2_LDO_GLU_XOSC_VAL_MASK)

#define BLEAPU_SOCBTAPU_LDO_LV_CTRL2_LDO_GLU_XOSC_BYPASS_EN_MASK (0x20U)
#define BLEAPU_SOCBTAPU_LDO_LV_CTRL2_LDO_GLU_XOSC_BYPASS_EN_SHIFT (5U)
/*! LDO_GLU_XOSC_BYPASS_EN - XOSC_EN control bypass for ldo control logic */
#define BLEAPU_SOCBTAPU_LDO_LV_CTRL2_LDO_GLU_XOSC_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_LDO_LV_CTRL2_LDO_GLU_XOSC_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_LDO_LV_CTRL2_LDO_GLU_XOSC_BYPASS_EN_MASK)
/*! @} */

/*! @name SOCBTAPU_CAU_BYPASS - CAU Bypass */
/*! @{ */

#define BLEAPU_SOCBTAPU_CAU_BYPASS_PHY_REF_CLK_BYPASS_VAL_MASK (0x1U)
#define BLEAPU_SOCBTAPU_CAU_BYPASS_PHY_REF_CLK_BYPASS_VAL_SHIFT (0U)
/*! PHY_REF_CLK_BYPASS_VAL - bypass value for phy ref clk enable */
#define BLEAPU_SOCBTAPU_CAU_BYPASS_PHY_REF_CLK_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_CAU_BYPASS_PHY_REF_CLK_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_CAU_BYPASS_PHY_REF_CLK_BYPASS_VAL_MASK)

#define BLEAPU_SOCBTAPU_CAU_BYPASS_PHY_REF_CLK_BYPASS_EN_MASK (0x2U)
#define BLEAPU_SOCBTAPU_CAU_BYPASS_PHY_REF_CLK_BYPASS_EN_SHIFT (1U)
/*! PHY_REF_CLK_BYPASS_EN - bypass enable for phy ref clk enable */
#define BLEAPU_SOCBTAPU_CAU_BYPASS_PHY_REF_CLK_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_CAU_BYPASS_PHY_REF_CLK_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_CAU_BYPASS_PHY_REF_CLK_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_CAU_BYPASS_BT_CLK_BYPASS_VAL_MASK (0x4U)
#define BLEAPU_SOCBTAPU_CAU_BYPASS_BT_CLK_BYPASS_VAL_SHIFT (2U)
/*! BT_CLK_BYPASS_VAL - bypass value for bt clk enable */
#define BLEAPU_SOCBTAPU_CAU_BYPASS_BT_CLK_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_CAU_BYPASS_BT_CLK_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_CAU_BYPASS_BT_CLK_BYPASS_VAL_MASK)

#define BLEAPU_SOCBTAPU_CAU_BYPASS_BT_CLK_BYPASS_EN_MASK (0x8U)
#define BLEAPU_SOCBTAPU_CAU_BYPASS_BT_CLK_BYPASS_EN_SHIFT (3U)
/*! BT_CLK_BYPASS_EN - bypass enable for bt clk enable */
#define BLEAPU_SOCBTAPU_CAU_BYPASS_BT_CLK_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_CAU_BYPASS_BT_CLK_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_CAU_BYPASS_BT_CLK_BYPASS_EN_MASK)

#define BLEAPU_SOCBTAPU_CAU_BYPASS_BRF_CLK_BYPASS_VAL_MASK (0x40U)
#define BLEAPU_SOCBTAPU_CAU_BYPASS_BRF_CLK_BYPASS_VAL_SHIFT (6U)
/*! BRF_CLK_BYPASS_VAL - bypass value for brf clk */
#define BLEAPU_SOCBTAPU_CAU_BYPASS_BRF_CLK_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_CAU_BYPASS_BRF_CLK_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_CAU_BYPASS_BRF_CLK_BYPASS_VAL_MASK)

#define BLEAPU_SOCBTAPU_CAU_BYPASS_BRF_CLK_BYPASS_EN_MASK (0x80U)
#define BLEAPU_SOCBTAPU_CAU_BYPASS_BRF_CLK_BYPASS_EN_SHIFT (7U)
/*! BRF_CLK_BYPASS_EN - bypass enable for brf clk */
#define BLEAPU_SOCBTAPU_CAU_BYPASS_BRF_CLK_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_CAU_BYPASS_BRF_CLK_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_CAU_BYPASS_BRF_CLK_BYPASS_EN_MASK)
/*! @} */

/*! @name SOCBTAPU_MEM_PWDN2 - Memory Powerdown Control */
/*! @{ */

#define BLEAPU_SOCBTAPU_MEM_PWDN2_OTP_BYPASS_VAL_MASK (0x2U)
#define BLEAPU_SOCBTAPU_MEM_PWDN2_OTP_BYPASS_VAL_SHIFT (1U)
/*! OTP_BYPASS_VAL - Firmware Bypass Value for OTP Power Down */
#define BLEAPU_SOCBTAPU_MEM_PWDN2_OTP_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_MEM_PWDN2_OTP_BYPASS_VAL_SHIFT)) & BLEAPU_SOCBTAPU_MEM_PWDN2_OTP_BYPASS_VAL_MASK)

#define BLEAPU_SOCBTAPU_MEM_PWDN2_OTP_BYPASS_EN_MASK (0x20000U)
#define BLEAPU_SOCBTAPU_MEM_PWDN2_OTP_BYPASS_EN_SHIFT (17U)
/*! OTP_BYPASS_EN - Firmware Bypass Enable for OTP Power Down */
#define BLEAPU_SOCBTAPU_MEM_PWDN2_OTP_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_MEM_PWDN2_OTP_BYPASS_EN_SHIFT)) & BLEAPU_SOCBTAPU_MEM_PWDN2_OTP_BYPASS_EN_MASK)
/*! @} */

/*! @name SOCBTAPU_HOST_WKUP_SOURCE - Host Wakeup Source Control */
/*! @{ */

#define BLEAPU_SOCBTAPU_HOST_WKUP_SOURCE_ENABLE_MASK (0xFFFFU)
#define BLEAPU_SOCBTAPU_HOST_WKUP_SOURCE_ENABLE_SHIFT (0U)
/*! ENABLE - Enable/ disable value: */
#define BLEAPU_SOCBTAPU_HOST_WKUP_SOURCE_ENABLE(x) (((uint32_t)(((uint32_t)(x)) << BLEAPU_SOCBTAPU_HOST_WKUP_SOURCE_ENABLE_SHIFT)) & BLEAPU_SOCBTAPU_HOST_WKUP_SOURCE_ENABLE_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group BLEAPU_Register_Masks */


/*!
 * @}
 */ /* end of group BLEAPU_Peripheral_Access_Layer */


/*
** End of section using anonymous unions
*/

#if defined(__ARMCC_VERSION)
  #if (__ARMCC_VERSION >= 6010050)
    #pragma clang diagnostic pop
  #else
    #pragma pop
  #endif
#elif defined(__GNUC__)
  /* leave anonymous unions enabled */
#elif defined(__IAR_SYSTEMS_ICC__)
  #pragma language=default
#else
  #error Not supported compiler type
#endif

/*!
 * @}
 */ /* end of group Peripheral_access_layer */


#endif  /* BLEAPU_H_ */

