; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 3
; RUN: llc -global-isel -mtriple=amdgcn-amd-amdpal -mcpu=gfx1010 -verify-machineinstrs < %s | FileCheck -check-prefix=GFX10 %s

define void @temporal_divergent_i1_phi(float %val, ptr %addr) {
; GFX10-LABEL: temporal_divergent_i1_phi:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_mov_b32 s5, 0
; GFX10-NEXT:    v_mov_b32_e32 v3, 1
; GFX10-NEXT:    v_mov_b32_e32 v4, s5
; GFX10-NEXT:    ; implicit-def: $sgpr6
; GFX10-NEXT:  .LBB0_1: ; %loop
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    v_cvt_f32_u32_e32 v5, v4
; GFX10-NEXT:    v_and_b32_e32 v6, 1, v3
; GFX10-NEXT:    v_xor_b32_e32 v3, 1, v3
; GFX10-NEXT:    v_add_nc_u32_e32 v4, 1, v4
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v5, v0
; GFX10-NEXT:    v_cmp_ne_u32_e64 s4, 0, v6
; GFX10-NEXT:    s_or_b32 s5, vcc_lo, s5
; GFX10-NEXT:    s_andn2_b32 s6, s6, exec_lo
; GFX10-NEXT:    s_and_b32 s4, exec_lo, s4
; GFX10-NEXT:    s_or_b32 s6, s6, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    s_cbranch_execnz .LBB0_1
; GFX10-NEXT:  ; %bb.2: ; %exit
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    v_cndmask_b32_e64 v0, 0, 1.0, s6
; GFX10-NEXT:    flat_store_dword v[1:2], v0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
entry:
  br label %loop

loop:
  %counter = phi i32 [ 0, %entry ], [ %counterPlus1, %loop ]
  %bool_counter = phi i1 [ true, %entry ], [ %neg_bool_counter, %loop ]
  %neg_bool_counter = xor i1 %bool_counter, true
  %fcounter = uitofp i32 %counter to float
  %cond = fcmp ogt float %fcounter, %val
  %counterPlus1 = add i32 %counter, 1
  br i1 %cond, label %exit, label %loop

exit:
  %select = select i1 %bool_counter, float 1.000000e+00, float 0.000000e+00
  store float %select, ptr %addr
  ret void
}

define void @temporal_divergent_i1_non_phi(float %val, ptr %addr) {
; GFX10-LABEL: temporal_divergent_i1_non_phi:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_mov_b32 s5, 0
; GFX10-NEXT:    v_mov_b32_e32 v3, 1
; GFX10-NEXT:    v_mov_b32_e32 v4, s5
; GFX10-NEXT:    ; implicit-def: $sgpr6
; GFX10-NEXT:  .LBB1_1: ; %loop
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    v_xor_b32_e32 v3, 1, v3
; GFX10-NEXT:    v_cvt_f32_u32_e32 v5, v4
; GFX10-NEXT:    v_add_nc_u32_e32 v4, 1, v4
; GFX10-NEXT:    v_and_b32_e32 v6, 1, v3
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v5, v0
; GFX10-NEXT:    v_cmp_ne_u32_e64 s4, 0, v6
; GFX10-NEXT:    s_or_b32 s5, vcc_lo, s5
; GFX10-NEXT:    s_andn2_b32 s6, s6, exec_lo
; GFX10-NEXT:    s_and_b32 s4, exec_lo, s4
; GFX10-NEXT:    s_or_b32 s6, s6, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    s_cbranch_execnz .LBB1_1
; GFX10-NEXT:  ; %bb.2: ; %exit
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    v_cndmask_b32_e64 v0, 0, 1.0, s6
; GFX10-NEXT:    flat_store_dword v[1:2], v0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
entry:
  br label %loop

loop:
  %counter = phi i32 [ 0, %entry ], [ %counterPlus1, %loop ]
  %bool_counter = phi i1 [ true, %entry ], [ %neg_bool_counter, %loop ]
  %neg_bool_counter = xor i1 %bool_counter, true
  %fcounter = uitofp i32 %counter to float
  %cond = fcmp ogt float %fcounter, %val
  %counterPlus1 = add i32 %counter, 1
  br i1 %cond, label %exit, label %loop

exit:
  %select = select i1 %neg_bool_counter, float 1.000000e+00, float 0.000000e+00
  store float %select, ptr %addr
  ret void
}

; This is temporal divergent uniform i1 structurize-cfg phi.
; Loop has uniform condition if with body with break at the end.
define amdgpu_cs void @loop_with_1break(ptr addrspace(1) %x, i32 %x.size, ptr addrspace(1) inreg %a, ptr addrspace(1) inreg %a.break) {
; GFX10-LABEL: loop_with_1break:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:    v_mov_b32_e32 v4, s1
; GFX10-NEXT:    v_mov_b32_e32 v3, s0
; GFX10-NEXT:    v_mov_b32_e32 v5, s4
; GFX10-NEXT:    ; implicit-def: $sgpr0
; GFX10-NEXT:    ; implicit-def: $sgpr1
; GFX10-NEXT:    s_branch .LBB2_3
; GFX10-NEXT:  .LBB2_1: ; %loop.body
; GFX10-NEXT:    ; in Loop: Header=BB2_3 Depth=1
; GFX10-NEXT:    v_add_co_u32 v6, vcc_lo, v0, v6
; GFX10-NEXT:    v_add_co_ci_u32_e32 v7, vcc_lo, v1, v7, vcc_lo
; GFX10-NEXT:    v_add_nc_u32_e32 v9, 1, v5
; GFX10-NEXT:    v_cmp_lt_u32_e32 vcc_lo, v5, v2
; GFX10-NEXT:    s_andn2_b32 s1, s1, exec_lo
; GFX10-NEXT:    global_load_dword v8, v[6:7], off
; GFX10-NEXT:    s_mov_b32 s5, 0
; GFX10-NEXT:    v_mov_b32_e32 v5, v9
; GFX10-NEXT:    s_and_b32 s6, exec_lo, vcc_lo
; GFX10-NEXT:    s_or_b32 s1, s1, s6
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_add_nc_u32_e32 v8, 1, v8
; GFX10-NEXT:    global_store_dword v[6:7], v8, off
; GFX10-NEXT:  .LBB2_2: ; %Flow
; GFX10-NEXT:    ; in Loop: Header=BB2_3 Depth=1
; GFX10-NEXT:    s_and_b32 s5, 1, s5
; GFX10-NEXT:    s_and_b32 s6, exec_lo, s1
; GFX10-NEXT:    v_cmp_ne_u32_e64 s5, 0, s5
; GFX10-NEXT:    s_or_b32 s4, s6, s4
; GFX10-NEXT:    s_andn2_b32 s0, s0, exec_lo
; GFX10-NEXT:    s_and_b32 s5, exec_lo, s5
; GFX10-NEXT:    s_or_b32 s0, s0, s5
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execz .LBB2_5
; GFX10-NEXT:  .LBB2_3: ; %A
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    v_ashrrev_i32_e32 v6, 31, v5
; GFX10-NEXT:    s_andn2_b32 s1, s1, exec_lo
; GFX10-NEXT:    s_and_b32 s5, exec_lo, -1
; GFX10-NEXT:    s_or_b32 s1, s1, s5
; GFX10-NEXT:    v_lshlrev_b64 v[6:7], 2, v[5:6]
; GFX10-NEXT:    v_add_co_u32 v8, vcc_lo, v3, v6
; GFX10-NEXT:    v_add_co_ci_u32_e32 v9, vcc_lo, v4, v7, vcc_lo
; GFX10-NEXT:    global_load_dword v8, v[8:9], off
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v8
; GFX10-NEXT:    s_cbranch_vccnz .LBB2_1
; GFX10-NEXT:  ; %bb.4: ; in Loop: Header=BB2_3 Depth=1
; GFX10-NEXT:    s_mov_b32 s5, 1
; GFX10-NEXT:    ; implicit-def: $vgpr5
; GFX10-NEXT:    s_branch .LBB2_2
; GFX10-NEXT:  .LBB2_5: ; %loop.exit.guard
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_and_saveexec_b32 s1, s0
; GFX10-NEXT:    s_xor_b32 s1, exec_lo, s1
; GFX10-NEXT:    s_cbranch_execz .LBB2_7
; GFX10-NEXT:  ; %bb.6: ; %break.body
; GFX10-NEXT:    v_mov_b32_e32 v0, 10
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    global_store_dword v1, v0, s[2:3]
; GFX10-NEXT:  .LBB2_7: ; %exit
; GFX10-NEXT:    s_endpgm
entry:
  br label %A

A:
  %counter = phi i32 [ %counter.plus.1, %loop.body ], [ 0, %entry ]
  %a.plus.counter = getelementptr inbounds i32, ptr addrspace(1) %a, i32 %counter
  %a.val = load i32, ptr addrspace(1) %a.plus.counter
  %a.cond = icmp eq i32 %a.val, 0
  br i1 %a.cond, label %break.body, label %loop.body

break.body:
  store i32 10, ptr addrspace(1) %a.break
  br label %exit

loop.body:
  %x.plus.counter = getelementptr inbounds i32, ptr addrspace(1) %x, i32 %counter
  %x.val = load i32, ptr addrspace(1) %x.plus.counter
  %x.val.plus.1 = add i32 %x.val, 1
  store i32 %x.val.plus.1, ptr addrspace(1) %x.plus.counter
  %counter.plus.1 = add i32 %counter, 1
  %x.cond = icmp ult i32 %counter, %x.size
  br i1 %x.cond, label %exit, label %A

exit:
  ret void
}

