; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=i686-unknown-linux-gnu -mattr=-sse -verify-machineinstrs < %s | FileCheck %s -check-prefix=X86-NOSSE
; RUN: llc -mtriple=i686-unknown-linux-gnu -mattr=+sse -verify-machineinstrs < %s | FileCheck %s -check-prefix=X86-SSE
; RUN: llc -mtriple=x86_64-unknown-linux-gnu -verify-machineinstrs < %s | FileCheck %s -check-prefix=X64

declare void @llvm.set.rounding(i32 %x)
declare i256 @llvm.get.fpenv.i256()
declare void @llvm.set.fpenv.i256(i256 %fpenv)
declare void @llvm.reset.fpenv()
declare i32 @llvm.get.fpmode.i32()
declare void @llvm.set.fpmode.i32(i32 %fpmode)
declare void @llvm.reset.fpmode()

define void @func_01() nounwind {
; X86-NOSSE-LABEL: func_01:
; X86-NOSSE:       # %bb.0:
; X86-NOSSE-NEXT:    pushl %eax
; X86-NOSSE-NEXT:    fnstcw (%esp)
; X86-NOSSE-NEXT:    orb $12, {{[0-9]+}}(%esp)
; X86-NOSSE-NEXT:    fldcw (%esp)
; X86-NOSSE-NEXT:    popl %eax
; X86-NOSSE-NEXT:    retl
;
; X86-SSE-LABEL: func_01:
; X86-SSE:       # %bb.0:
; X86-SSE-NEXT:    pushl %eax
; X86-SSE-NEXT:    fnstcw (%esp)
; X86-SSE-NEXT:    orb $12, {{[0-9]+}}(%esp)
; X86-SSE-NEXT:    fldcw (%esp)
; X86-SSE-NEXT:    stmxcsr (%esp)
; X86-SSE-NEXT:    orb $96, {{[0-9]+}}(%esp)
; X86-SSE-NEXT:    ldmxcsr (%esp)
; X86-SSE-NEXT:    popl %eax
; X86-SSE-NEXT:    retl
;
; X64-LABEL: func_01:
; X64:       # %bb.0:
; X64-NEXT:    fnstcw -{{[0-9]+}}(%rsp)
; X64-NEXT:    orb $12, -{{[0-9]+}}(%rsp)
; X64-NEXT:    fldcw -{{[0-9]+}}(%rsp)
; X64-NEXT:    stmxcsr -{{[0-9]+}}(%rsp)
; X64-NEXT:    orb $96, -{{[0-9]+}}(%rsp)
; X64-NEXT:    ldmxcsr -{{[0-9]+}}(%rsp)
; X64-NEXT:    retq
  call void @llvm.set.rounding(i32 0)  ; TowardZero (CW[11-10] = 11)
  ret void
}

define void @func_02() nounwind {
; X86-NOSSE-LABEL: func_02:
; X86-NOSSE:       # %bb.0:
; X86-NOSSE-NEXT:    pushl %eax
; X86-NOSSE-NEXT:    fnstcw (%esp)
; X86-NOSSE-NEXT:    andb $-13, {{[0-9]+}}(%esp)
; X86-NOSSE-NEXT:    fldcw (%esp)
; X86-NOSSE-NEXT:    popl %eax
; X86-NOSSE-NEXT:    retl
;
; X86-SSE-LABEL: func_02:
; X86-SSE:       # %bb.0:
; X86-SSE-NEXT:    pushl %eax
; X86-SSE-NEXT:    fnstcw (%esp)
; X86-SSE-NEXT:    andb $-13, {{[0-9]+}}(%esp)
; X86-SSE-NEXT:    fldcw (%esp)
; X86-SSE-NEXT:    stmxcsr (%esp)
; X86-SSE-NEXT:    andb $-97, {{[0-9]+}}(%esp)
; X86-SSE-NEXT:    ldmxcsr (%esp)
; X86-SSE-NEXT:    popl %eax
; X86-SSE-NEXT:    retl
;
; X64-LABEL: func_02:
; X64:       # %bb.0:
; X64-NEXT:    fnstcw -{{[0-9]+}}(%rsp)
; X64-NEXT:    andb $-13, -{{[0-9]+}}(%rsp)
; X64-NEXT:    fldcw -{{[0-9]+}}(%rsp)
; X64-NEXT:    stmxcsr -{{[0-9]+}}(%rsp)
; X64-NEXT:    andb $-97, -{{[0-9]+}}(%rsp)
; X64-NEXT:    ldmxcsr -{{[0-9]+}}(%rsp)
; X64-NEXT:    retq
  call void @llvm.set.rounding(i32 1)  ; ToNearestTiesToEven (CW[11-10] = 00)
  ret void
}

define void @func_03() nounwind {
; X86-NOSSE-LABEL: func_03:
; X86-NOSSE:       # %bb.0:
; X86-NOSSE-NEXT:    pushl %eax
; X86-NOSSE-NEXT:    fnstcw (%esp)
; X86-NOSSE-NEXT:    movl $-3073, %eax # imm = 0xF3FF
; X86-NOSSE-NEXT:    andl (%esp), %eax
; X86-NOSSE-NEXT:    orl $2048, %eax # imm = 0x800
; X86-NOSSE-NEXT:    movw %ax, (%esp)
; X86-NOSSE-NEXT:    fldcw (%esp)
; X86-NOSSE-NEXT:    popl %eax
; X86-NOSSE-NEXT:    retl
;
; X86-SSE-LABEL: func_03:
; X86-SSE:       # %bb.0:
; X86-SSE-NEXT:    pushl %eax
; X86-SSE-NEXT:    fnstcw (%esp)
; X86-SSE-NEXT:    movl $-3073, %eax # imm = 0xF3FF
; X86-SSE-NEXT:    andl (%esp), %eax
; X86-SSE-NEXT:    orl $2048, %eax # imm = 0x800
; X86-SSE-NEXT:    movw %ax, (%esp)
; X86-SSE-NEXT:    fldcw (%esp)
; X86-SSE-NEXT:    stmxcsr (%esp)
; X86-SSE-NEXT:    movl $-24577, %eax # imm = 0x9FFF
; X86-SSE-NEXT:    andl (%esp), %eax
; X86-SSE-NEXT:    orl $16384, %eax # imm = 0x4000
; X86-SSE-NEXT:    movl %eax, (%esp)
; X86-SSE-NEXT:    ldmxcsr (%esp)
; X86-SSE-NEXT:    popl %eax
; X86-SSE-NEXT:    retl
;
; X64-LABEL: func_03:
; X64:       # %bb.0:
; X64-NEXT:    fnstcw -{{[0-9]+}}(%rsp)
; X64-NEXT:    movl $-3073, %eax # imm = 0xF3FF
; X64-NEXT:    andl -{{[0-9]+}}(%rsp), %eax
; X64-NEXT:    orl $2048, %eax # imm = 0x800
; X64-NEXT:    movw %ax, -{{[0-9]+}}(%rsp)
; X64-NEXT:    fldcw -{{[0-9]+}}(%rsp)
; X64-NEXT:    stmxcsr -{{[0-9]+}}(%rsp)
; X64-NEXT:    movl $-24577, %eax # imm = 0x9FFF
; X64-NEXT:    andl -{{[0-9]+}}(%rsp), %eax
; X64-NEXT:    orl $16384, %eax # imm = 0x4000
; X64-NEXT:    movl %eax, -{{[0-9]+}}(%rsp)
; X64-NEXT:    ldmxcsr -{{[0-9]+}}(%rsp)
; X64-NEXT:    retq
  call void @llvm.set.rounding(i32 2)  ; Upward (CW[11-10] = 10)
  ret void
}

define void @func_04() nounwind {
; X86-NOSSE-LABEL: func_04:
; X86-NOSSE:       # %bb.0:
; X86-NOSSE-NEXT:    pushl %eax
; X86-NOSSE-NEXT:    fnstcw (%esp)
; X86-NOSSE-NEXT:    movl $-3073, %eax # imm = 0xF3FF
; X86-NOSSE-NEXT:    andl (%esp), %eax
; X86-NOSSE-NEXT:    orl $1024, %eax # imm = 0x400
; X86-NOSSE-NEXT:    movw %ax, (%esp)
; X86-NOSSE-NEXT:    fldcw (%esp)
; X86-NOSSE-NEXT:    popl %eax
; X86-NOSSE-NEXT:    retl
;
; X86-SSE-LABEL: func_04:
; X86-SSE:       # %bb.0:
; X86-SSE-NEXT:    pushl %eax
; X86-SSE-NEXT:    fnstcw (%esp)
; X86-SSE-NEXT:    movl $-3073, %eax # imm = 0xF3FF
; X86-SSE-NEXT:    andl (%esp), %eax
; X86-SSE-NEXT:    orl $1024, %eax # imm = 0x400
; X86-SSE-NEXT:    movw %ax, (%esp)
; X86-SSE-NEXT:    fldcw (%esp)
; X86-SSE-NEXT:    stmxcsr (%esp)
; X86-SSE-NEXT:    movl $-24577, %eax # imm = 0x9FFF
; X86-SSE-NEXT:    andl (%esp), %eax
; X86-SSE-NEXT:    orl $8192, %eax # imm = 0x2000
; X86-SSE-NEXT:    movl %eax, (%esp)
; X86-SSE-NEXT:    ldmxcsr (%esp)
; X86-SSE-NEXT:    popl %eax
; X86-SSE-NEXT:    retl
;
; X64-LABEL: func_04:
; X64:       # %bb.0:
; X64-NEXT:    fnstcw -{{[0-9]+}}(%rsp)
; X64-NEXT:    movl $-3073, %eax # imm = 0xF3FF
; X64-NEXT:    andl -{{[0-9]+}}(%rsp), %eax
; X64-NEXT:    orl $1024, %eax # imm = 0x400
; X64-NEXT:    movw %ax, -{{[0-9]+}}(%rsp)
; X64-NEXT:    fldcw -{{[0-9]+}}(%rsp)
; X64-NEXT:    stmxcsr -{{[0-9]+}}(%rsp)
; X64-NEXT:    movl $-24577, %eax # imm = 0x9FFF
; X64-NEXT:    andl -{{[0-9]+}}(%rsp), %eax
; X64-NEXT:    orl $8192, %eax # imm = 0x2000
; X64-NEXT:    movl %eax, -{{[0-9]+}}(%rsp)
; X64-NEXT:    ldmxcsr -{{[0-9]+}}(%rsp)
; X64-NEXT:    retq
  call void @llvm.set.rounding(i32 3)  ; Downward (CW[11-10] = 01)
  ret void
}

define void @func_05(i32 %x) nounwind {
; X86-NOSSE-LABEL: func_05:
; X86-NOSSE:       # %bb.0:
; X86-NOSSE-NEXT:    pushl %eax
; X86-NOSSE-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NOSSE-NEXT:    leal 4(%eax,%eax), %ecx
; X86-NOSSE-NEXT:    movl $201, %eax
; X86-NOSSE-NEXT:    # kill: def $cl killed $cl killed $ecx
; X86-NOSSE-NEXT:    shll %cl, %eax
; X86-NOSSE-NEXT:    andl $3072, %eax # imm = 0xC00
; X86-NOSSE-NEXT:    fnstcw (%esp)
; X86-NOSSE-NEXT:    movl $-3073, %ecx # imm = 0xF3FF
; X86-NOSSE-NEXT:    andl (%esp), %ecx
; X86-NOSSE-NEXT:    orl %eax, %ecx
; X86-NOSSE-NEXT:    movw %cx, (%esp)
; X86-NOSSE-NEXT:    fldcw (%esp)
; X86-NOSSE-NEXT:    popl %eax
; X86-NOSSE-NEXT:    retl
;
; X86-SSE-LABEL: func_05:
; X86-SSE:       # %bb.0:
; X86-SSE-NEXT:    pushl %eax
; X86-SSE-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    leal 4(%eax,%eax), %ecx
; X86-SSE-NEXT:    movl $201, %eax
; X86-SSE-NEXT:    # kill: def $cl killed $cl killed $ecx
; X86-SSE-NEXT:    shll %cl, %eax
; X86-SSE-NEXT:    andl $3072, %eax # imm = 0xC00
; X86-SSE-NEXT:    fnstcw (%esp)
; X86-SSE-NEXT:    movl $-3073, %ecx # imm = 0xF3FF
; X86-SSE-NEXT:    andl (%esp), %ecx
; X86-SSE-NEXT:    orl %eax, %ecx
; X86-SSE-NEXT:    movw %cx, (%esp)
; X86-SSE-NEXT:    fldcw (%esp)
; X86-SSE-NEXT:    stmxcsr (%esp)
; X86-SSE-NEXT:    movl $-24577, %ecx # imm = 0x9FFF
; X86-SSE-NEXT:    andl (%esp), %ecx
; X86-SSE-NEXT:    leal (%ecx,%eax,8), %eax
; X86-SSE-NEXT:    movl %eax, (%esp)
; X86-SSE-NEXT:    ldmxcsr (%esp)
; X86-SSE-NEXT:    popl %eax
; X86-SSE-NEXT:    retl
;
; X64-LABEL: func_05:
; X64:       # %bb.0:
; X64-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-NEXT:    leal 4(%rdi,%rdi), %ecx
; X64-NEXT:    movl $201, %eax
; X64-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-NEXT:    shll %cl, %eax
; X64-NEXT:    andl $3072, %eax # imm = 0xC00
; X64-NEXT:    fnstcw -{{[0-9]+}}(%rsp)
; X64-NEXT:    movl $-3073, %ecx # imm = 0xF3FF
; X64-NEXT:    andl -{{[0-9]+}}(%rsp), %ecx
; X64-NEXT:    orl %eax, %ecx
; X64-NEXT:    movw %cx, -{{[0-9]+}}(%rsp)
; X64-NEXT:    fldcw -{{[0-9]+}}(%rsp)
; X64-NEXT:    stmxcsr -{{[0-9]+}}(%rsp)
; X64-NEXT:    movl $-24577, %ecx # imm = 0x9FFF
; X64-NEXT:    andl -{{[0-9]+}}(%rsp), %ecx
; X64-NEXT:    leal (%rcx,%rax,8), %eax
; X64-NEXT:    movl %eax, -{{[0-9]+}}(%rsp)
; X64-NEXT:    ldmxcsr -{{[0-9]+}}(%rsp)
; X64-NEXT:    retq
  call void @llvm.set.rounding(i32 %x)  ; Downward
  ret void
}

define void @get_fpenv_01(ptr %ptr) #0 {
; X86-NOSSE-LABEL: get_fpenv_01:
; X86-NOSSE:       # %bb.0: # %entry
; X86-NOSSE-NEXT:    subl $60, %esp
; X86-NOSSE-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NOSSE-NEXT:    movl %eax, (%esp)
; X86-NOSSE-NEXT:    calll fegetenv
; X86-NOSSE-NEXT:    addl $60, %esp
; X86-NOSSE-NEXT:    retl
;
; X86-SSE-LABEL: get_fpenv_01:
; X86-SSE:       # %bb.0: # %entry
; X86-SSE-NEXT:    subl $60, %esp
; X86-SSE-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movl %eax, (%esp)
; X86-SSE-NEXT:    calll fegetenv
; X86-SSE-NEXT:    addl $60, %esp
; X86-SSE-NEXT:    retl
;
; X64-LABEL: get_fpenv_01:
; X64:       # %bb.0: # %entry
; X64-NEXT:    subq $40, %rsp
; X64-NEXT:    callq fegetenv@PLT
; X64-NEXT:    addq $40, %rsp
; X64-NEXT:    retq
entry:
  %env = call i256 @llvm.get.fpenv.i256()
  store i256 %env, ptr %ptr
  ret void
}

define void @get_fpenv_01_native(ptr %ptr) nounwind {
; X86-NOSSE-LABEL: get_fpenv_01_native:
; X86-NOSSE:       # %bb.0: # %entry
; X86-NOSSE-NEXT:    subl $44, %esp
; X86-NOSSE-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NOSSE-NEXT:    fnstenv (%eax)
; X86-NOSSE-NEXT:    fldenv (%eax)
; X86-NOSSE-NEXT:    addl $44, %esp
; X86-NOSSE-NEXT:    retl
;
; X86-SSE-LABEL: get_fpenv_01_native:
; X86-SSE:       # %bb.0: # %entry
; X86-SSE-NEXT:    subl $44, %esp
; X86-SSE-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    fnstenv (%eax)
; X86-SSE-NEXT:    fldenv (%eax)
; X86-SSE-NEXT:    stmxcsr 28(%eax)
; X86-SSE-NEXT:    addl $44, %esp
; X86-SSE-NEXT:    retl
;
; X64-LABEL: get_fpenv_01_native:
; X64:       # %bb.0: # %entry
; X64-NEXT:    fnstenv (%rdi)
; X64-NEXT:    fldenv (%rdi)
; X64-NEXT:    stmxcsr 28(%rdi)
; X64-NEXT:    retq
entry:
  %env = call i256 @llvm.get.fpenv.i256()
  store i256 %env, ptr %ptr
  ret void
}

define void @set_fpenv_01(ptr %ptr) #0 {
; X86-NOSSE-LABEL: set_fpenv_01:
; X86-NOSSE:       # %bb.0: # %entry
; X86-NOSSE-NEXT:    subl $60, %esp
; X86-NOSSE-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NOSSE-NEXT:    movl %eax, (%esp)
; X86-NOSSE-NEXT:    calll fesetenv
; X86-NOSSE-NEXT:    addl $60, %esp
; X86-NOSSE-NEXT:    retl
;
; X86-SSE-LABEL: set_fpenv_01:
; X86-SSE:       # %bb.0: # %entry
; X86-SSE-NEXT:    subl $60, %esp
; X86-SSE-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movl %eax, (%esp)
; X86-SSE-NEXT:    calll fesetenv
; X86-SSE-NEXT:    addl $60, %esp
; X86-SSE-NEXT:    retl
;
; X64-LABEL: set_fpenv_01:
; X64:       # %bb.0: # %entry
; X64-NEXT:    subq $40, %rsp
; X64-NEXT:    callq fesetenv@PLT
; X64-NEXT:    addq $40, %rsp
; X64-NEXT:    retq
entry:
  %env = load i256, ptr %ptr
  call void @llvm.set.fpenv.i256(i256 %env)
  ret void
}

define void @set_fpenv_01_native(ptr %ptr) nounwind {
; X86-NOSSE-LABEL: set_fpenv_01_native:
; X86-NOSSE:       # %bb.0: # %entry
; X86-NOSSE-NEXT:    subl $44, %esp
; X86-NOSSE-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NOSSE-NEXT:    fldenv (%eax)
; X86-NOSSE-NEXT:    addl $44, %esp
; X86-NOSSE-NEXT:    retl
;
; X86-SSE-LABEL: set_fpenv_01_native:
; X86-SSE:       # %bb.0: # %entry
; X86-SSE-NEXT:    subl $44, %esp
; X86-SSE-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    fldenv (%eax)
; X86-SSE-NEXT:    ldmxcsr 28(%eax)
; X86-SSE-NEXT:    addl $44, %esp
; X86-SSE-NEXT:    retl
;
; X64-LABEL: set_fpenv_01_native:
; X64:       # %bb.0: # %entry
; X64-NEXT:    fldenv (%rdi)
; X64-NEXT:    ldmxcsr 28(%rdi)
; X64-NEXT:    retq
entry:
  %env = load i256, ptr %ptr
  call void @llvm.set.fpenv.i256(i256 %env)
  ret void
}

define void @reset_fpenv_01() #0 {
; X86-NOSSE-LABEL: reset_fpenv_01:
; X86-NOSSE:       # %bb.0: # %entry
; X86-NOSSE-NEXT:    subl $12, %esp
; X86-NOSSE-NEXT:    movl $-1, (%esp)
; X86-NOSSE-NEXT:    calll fesetenv
; X86-NOSSE-NEXT:    addl $12, %esp
; X86-NOSSE-NEXT:    retl
;
; X86-SSE-LABEL: reset_fpenv_01:
; X86-SSE:       # %bb.0: # %entry
; X86-SSE-NEXT:    subl $12, %esp
; X86-SSE-NEXT:    movl $-1, (%esp)
; X86-SSE-NEXT:    calll fesetenv
; X86-SSE-NEXT:    addl $12, %esp
; X86-SSE-NEXT:    retl
;
; X64-LABEL: reset_fpenv_01:
; X64:       # %bb.0: # %entry
; X64-NEXT:    pushq %rax
; X64-NEXT:    movq $-1, %rdi
; X64-NEXT:    callq fesetenv@PLT
; X64-NEXT:    popq %rax
; X64-NEXT:    retq
entry:
  call void @llvm.reset.fpenv()
  ret void
}

define void @reset_fpenv_01_native() nounwind {
; X86-NOSSE-LABEL: reset_fpenv_01_native:
; X86-NOSSE:       # %bb.0: # %entry
; X86-NOSSE-NEXT:    fldenv {{\.?LCPI[0-9]+_[0-9]+}}
; X86-NOSSE-NEXT:    retl
;
; X86-SSE-LABEL: reset_fpenv_01_native:
; X86-SSE:       # %bb.0: # %entry
; X86-SSE-NEXT:    fldenv {{\.?LCPI[0-9]+_[0-9]+}}
; X86-SSE-NEXT:    ldmxcsr {{\.?LCPI[0-9]+_[0-9]+}}+28
; X86-SSE-NEXT:    retl
;
; X64-LABEL: reset_fpenv_01_native:
; X64:       # %bb.0: # %entry
; X64-NEXT:    fldenv {{\.?LCPI[0-9]+_[0-9]+}}(%rip)
; X64-NEXT:    ldmxcsr {{\.?LCPI[0-9]+_[0-9]+}}+28(%rip)
; X64-NEXT:    retq
entry:
  call void @llvm.reset.fpenv()
  ret void
}

define i32 @func_get_fpmode() #0 {
; X86-NOSSE-LABEL: func_get_fpmode:
; X86-NOSSE:       # %bb.0: # %entry
; X86-NOSSE-NEXT:    subl $12, %esp
; X86-NOSSE-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NOSSE-NEXT:    movl %eax, (%esp)
; X86-NOSSE-NEXT:    calll fegetmode
; X86-NOSSE-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NOSSE-NEXT:    addl $12, %esp
; X86-NOSSE-NEXT:    retl
;
; X86-SSE-LABEL: func_get_fpmode:
; X86-SSE:       # %bb.0: # %entry
; X86-SSE-NEXT:    subl $12, %esp
; X86-SSE-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movl %eax, (%esp)
; X86-SSE-NEXT:    calll fegetmode
; X86-SSE-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    addl $12, %esp
; X86-SSE-NEXT:    retl
;
; X64-LABEL: func_get_fpmode:
; X64:       # %bb.0: # %entry
; X64-NEXT:    pushq %rax
; X64-NEXT:    leaq {{[0-9]+}}(%rsp), %rdi
; X64-NEXT:    callq fegetmode@PLT
; X64-NEXT:    movl {{[0-9]+}}(%rsp), %eax
; X64-NEXT:    popq %rcx
; X64-NEXT:    retq
entry:
  %fpmode = call i32 @llvm.get.fpmode.i32()
  ret i32 %fpmode
}

define void @func_set_fpmode(i32 %fpmode) #0 {
; X86-NOSSE-LABEL: func_set_fpmode:
; X86-NOSSE:       # %bb.0: # %entry
; X86-NOSSE-NEXT:    subl $12, %esp
; X86-NOSSE-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NOSSE-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NOSSE-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NOSSE-NEXT:    movl %eax, (%esp)
; X86-NOSSE-NEXT:    calll fesetmode
; X86-NOSSE-NEXT:    addl $12, %esp
; X86-NOSSE-NEXT:    retl
;
; X86-SSE-LABEL: func_set_fpmode:
; X86-SSE:       # %bb.0: # %entry
; X86-SSE-NEXT:    subl $12, %esp
; X86-SSE-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-SSE-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movl %eax, (%esp)
; X86-SSE-NEXT:    calll fesetmode
; X86-SSE-NEXT:    addl $12, %esp
; X86-SSE-NEXT:    retl
;
; X64-LABEL: func_set_fpmode:
; X64:       # %bb.0: # %entry
; X64-NEXT:    pushq %rax
; X64-NEXT:    movl %edi, {{[0-9]+}}(%rsp)
; X64-NEXT:    leaq {{[0-9]+}}(%rsp), %rdi
; X64-NEXT:    callq fesetmode@PLT
; X64-NEXT:    popq %rax
; X64-NEXT:    retq
entry:
  call void @llvm.set.fpmode.i32(i32 %fpmode)
  ret void
}


define void @func_reset() #0 {
; X86-NOSSE-LABEL: func_reset:
; X86-NOSSE:       # %bb.0: # %entry
; X86-NOSSE-NEXT:    subl $12, %esp
; X86-NOSSE-NEXT:    movl $-1, (%esp)
; X86-NOSSE-NEXT:    calll fesetmode
; X86-NOSSE-NEXT:    addl $12, %esp
; X86-NOSSE-NEXT:    retl
;
; X86-SSE-LABEL: func_reset:
; X86-SSE:       # %bb.0: # %entry
; X86-SSE-NEXT:    subl $12, %esp
; X86-SSE-NEXT:    movl $-1, (%esp)
; X86-SSE-NEXT:    calll fesetmode
; X86-SSE-NEXT:    addl $12, %esp
; X86-SSE-NEXT:    retl
;
; X64-LABEL: func_reset:
; X64:       # %bb.0: # %entry
; X64-NEXT:    pushq %rax
; X64-NEXT:    movq $-1, %rdi
; X64-NEXT:    callq fesetmode@PLT
; X64-NEXT:    popq %rax
; X64-NEXT:    retq
entry:
  call void @llvm.reset.fpmode()
  ret void
}

attributes #0 = { nounwind "use-soft-float"="true" }
