; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 3
; RUN: llc --mtriple=loongarch32 --mattr=+f --verify-machineinstrs < %s | FileCheck %s
; RUN: llc --mtriple=loongarch64 --mattr=+f --verify-machineinstrs < %s | FileCheck %s

define i1 @isnan_f(float %x) {
; CHECK-LABEL: isnan_f:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fclass.s $fa0, $fa0
; CHECK-NEXT:    movfr2gr.s $a0, $fa0
; CHECK-NEXT:    andi $a0, $a0, 3
; CHECK-NEXT:    sltu $a0, $zero, $a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 3)  ; "nan"
  ret i1 %0
}

define i1 @isnot_nan_f(float %x) {
; CHECK-LABEL: isnot_nan_f:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fclass.s $fa0, $fa0
; CHECK-NEXT:    movfr2gr.s $a0, $fa0
; CHECK-NEXT:    andi $a0, $a0, 1020
; CHECK-NEXT:    sltu $a0, $zero, $a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 1020)  ; 0x3fc = "zero|subnormal|normal|inf"
  ret i1 %0
}

define i1 @issignaling_f(float %x) {
; CHECK-LABEL: issignaling_f:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fclass.s $fa0, $fa0
; CHECK-NEXT:    movfr2gr.s $a0, $fa0
; CHECK-NEXT:    andi $a0, $a0, 1
; CHECK-NEXT:    sltu $a0, $zero, $a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 1)  ; "snan"
  ret i1 %0
}

define i1 @not_issignaling_f(float %x) {
; CHECK-LABEL: not_issignaling_f:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fclass.s $fa0, $fa0
; CHECK-NEXT:    movfr2gr.s $a0, $fa0
; CHECK-NEXT:    andi $a0, $a0, 1022
; CHECK-NEXT:    sltu $a0, $zero, $a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 1022)  ; ~"snan"
  ret i1 %0
}

define i1 @isquiet_f(float %x) {
; CHECK-LABEL: isquiet_f:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fclass.s $fa0, $fa0
; CHECK-NEXT:    movfr2gr.s $a0, $fa0
; CHECK-NEXT:    andi $a0, $a0, 2
; CHECK-NEXT:    sltu $a0, $zero, $a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 2)  ; "qnan"
  ret i1 %0
}

define i1 @not_isquiet_f(float %x) {
; CHECK-LABEL: not_isquiet_f:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fclass.s $fa0, $fa0
; CHECK-NEXT:    movfr2gr.s $a0, $fa0
; CHECK-NEXT:    andi $a0, $a0, 1021
; CHECK-NEXT:    sltu $a0, $zero, $a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 1021)  ; ~"qnan"
  ret i1 %0
}

define i1 @isinf_f(float %x) {
; CHECK-LABEL: isinf_f:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fclass.s $fa0, $fa0
; CHECK-NEXT:    movfr2gr.s $a0, $fa0
; CHECK-NEXT:    andi $a0, $a0, 68
; CHECK-NEXT:    sltu $a0, $zero, $a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 516)  ; 0x204 = "inf"
  ret i1 %0
}

define i1 @not_isinf_f(float %x) {
; CHECK-LABEL: not_isinf_f:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fclass.s $fa0, $fa0
; CHECK-NEXT:    movfr2gr.s $a0, $fa0
; CHECK-NEXT:    andi $a0, $a0, 955
; CHECK-NEXT:    sltu $a0, $zero, $a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 507)  ; ~0x204 = "~inf"
  ret i1 %0
}

define i1 @is_plus_inf_f(float %x) {
; CHECK-LABEL: is_plus_inf_f:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fclass.s $fa0, $fa0
; CHECK-NEXT:    movfr2gr.s $a0, $fa0
; CHECK-NEXT:    andi $a0, $a0, 64
; CHECK-NEXT:    sltu $a0, $zero, $a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 512)  ; 0x200 = "+inf"
  ret i1 %0
}

define i1 @is_minus_inf_f(float %x) {
; CHECK-LABEL: is_minus_inf_f:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fclass.s $fa0, $fa0
; CHECK-NEXT:    movfr2gr.s $a0, $fa0
; CHECK-NEXT:    andi $a0, $a0, 4
; CHECK-NEXT:    sltu $a0, $zero, $a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 4)  ; "-inf"
  ret i1 %0
}

define i1 @not_is_minus_inf_f(float %x) {
; CHECK-LABEL: not_is_minus_inf_f:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fclass.s $fa0, $fa0
; CHECK-NEXT:    movfr2gr.s $a0, $fa0
; CHECK-NEXT:    andi $a0, $a0, 1019
; CHECK-NEXT:    sltu $a0, $zero, $a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 1019)  ; ~"-inf"
  ret i1 %0
}

define i1 @isfinite_f(float %x) {
; CHECK-LABEL: isfinite_f:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fclass.s $fa0, $fa0
; CHECK-NEXT:    movfr2gr.s $a0, $fa0
; CHECK-NEXT:    andi $a0, $a0, 952
; CHECK-NEXT:    sltu $a0, $zero, $a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 504)  ; 0x1f8 = "finite"
  ret i1 %0
}

define i1 @not_isfinite_f(float %x) {
; CHECK-LABEL: not_isfinite_f:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fclass.s $fa0, $fa0
; CHECK-NEXT:    movfr2gr.s $a0, $fa0
; CHECK-NEXT:    andi $a0, $a0, 71
; CHECK-NEXT:    sltu $a0, $zero, $a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 519)  ; ~0x1f8 = "~finite"
  ret i1 %0
}

define i1 @is_plus_finite_f(float %x) {
; CHECK-LABEL: is_plus_finite_f:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fclass.s $fa0, $fa0
; CHECK-NEXT:    movfr2gr.s $a0, $fa0
; CHECK-NEXT:    andi $a0, $a0, 896
; CHECK-NEXT:    sltu $a0, $zero, $a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 448)  ; 0x1c0 = "+finite"
  ret i1 %0
}

define i1 @not_is_plus_finite_f(float %x) {
; CHECK-LABEL: not_is_plus_finite_f:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fclass.s $fa0, $fa0
; CHECK-NEXT:    movfr2gr.s $a0, $fa0
; CHECK-NEXT:    andi $a0, $a0, 127
; CHECK-NEXT:    sltu $a0, $zero, $a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 575)  ; ~0x1c0 = ~"+finite"
  ret i1 %0
}

define i1 @is_minus_finite_f(float %x) {
; CHECK-LABEL: is_minus_finite_f:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fclass.s $fa0, $fa0
; CHECK-NEXT:    movfr2gr.s $a0, $fa0
; CHECK-NEXT:    andi $a0, $a0, 56
; CHECK-NEXT:    sltu $a0, $zero, $a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 56)  ; 0x38 = "-finite"
  ret i1 %0
}

define i1 @not_is_minus_finite_f(float %x) {
; CHECK-LABEL: not_is_minus_finite_f:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fclass.s $fa0, $fa0
; CHECK-NEXT:    movfr2gr.s $a0, $fa0
; CHECK-NEXT:    andi $a0, $a0, 967
; CHECK-NEXT:    sltu $a0, $zero, $a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 967)  ; ~0x38 = ~"-finite"
  ret i1 %0
}

define i1 @isnormal_f(float %x) {
; CHECK-LABEL: isnormal_f:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fclass.s $fa0, $fa0
; CHECK-NEXT:    movfr2gr.s $a0, $fa0
; CHECK-NEXT:    andi $a0, $a0, 136
; CHECK-NEXT:    sltu $a0, $zero, $a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 264)  ; 0x108 = "normal"
  ret i1 %0
}

define i1 @not_isnormal_f(float %x) {
; CHECK-LABEL: not_isnormal_f:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fclass.s $fa0, $fa0
; CHECK-NEXT:    movfr2gr.s $a0, $fa0
; CHECK-NEXT:    andi $a0, $a0, 887
; CHECK-NEXT:    sltu $a0, $zero, $a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 759)  ; ~0x108 = "~normal"
  ret i1 %0
}

define i1 @is_plus_normal_f(float %x) {
; CHECK-LABEL: is_plus_normal_f:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fclass.s $fa0, $fa0
; CHECK-NEXT:    movfr2gr.s $a0, $fa0
; CHECK-NEXT:    andi $a0, $a0, 128
; CHECK-NEXT:    sltu $a0, $zero, $a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 256)  ; 0x100 = "+normal"
  ret i1 %0
}

define i1 @issubnormal_f(float %x) {
; CHECK-LABEL: issubnormal_f:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fclass.s $fa0, $fa0
; CHECK-NEXT:    movfr2gr.s $a0, $fa0
; CHECK-NEXT:    andi $a0, $a0, 272
; CHECK-NEXT:    sltu $a0, $zero, $a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 144)  ; 0x90 = "subnormal"
  ret i1 %0
}

define i1 @not_issubnormal_f(float %x) {
; CHECK-LABEL: not_issubnormal_f:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fclass.s $fa0, $fa0
; CHECK-NEXT:    movfr2gr.s $a0, $fa0
; CHECK-NEXT:    andi $a0, $a0, 751
; CHECK-NEXT:    sltu $a0, $zero, $a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 879)  ; ~0x90 = "~subnormal"
  ret i1 %0
}

define i1 @is_plus_subnormal_f(float %x) {
; CHECK-LABEL: is_plus_subnormal_f:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fclass.s $fa0, $fa0
; CHECK-NEXT:    movfr2gr.s $a0, $fa0
; CHECK-NEXT:    andi $a0, $a0, 256
; CHECK-NEXT:    sltu $a0, $zero, $a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 128)  ; 0x80 = "+subnormal"
  ret i1 %0
}

define i1 @not_is_plus_subnormal_f(float %x) {
; CHECK-LABEL: not_is_plus_subnormal_f:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fclass.s $fa0, $fa0
; CHECK-NEXT:    movfr2gr.s $a0, $fa0
; CHECK-NEXT:    andi $a0, $a0, 767
; CHECK-NEXT:    sltu $a0, $zero, $a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 895)  ; ~0x80 = ~"+subnormal"
  ret i1 %0
}

define i1 @is_minus_subnormal_f(float %x) {
; CHECK-LABEL: is_minus_subnormal_f:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fclass.s $fa0, $fa0
; CHECK-NEXT:    movfr2gr.s $a0, $fa0
; CHECK-NEXT:    andi $a0, $a0, 16
; CHECK-NEXT:    sltu $a0, $zero, $a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 16)  ; 0x10 = "-subnormal"
  ret i1 %0
}

define i1 @not_is_minus_subnormal_f(float %x) {
; CHECK-LABEL: not_is_minus_subnormal_f:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fclass.s $fa0, $fa0
; CHECK-NEXT:    movfr2gr.s $a0, $fa0
; CHECK-NEXT:    andi $a0, $a0, 1007
; CHECK-NEXT:    sltu $a0, $zero, $a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 1007)  ; ~0x10 = ~"-subnormal"
  ret i1 %0
}

define i1 @iszero_f(float %x) {
; CHECK-LABEL: iszero_f:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fclass.s $fa0, $fa0
; CHECK-NEXT:    movfr2gr.s $a0, $fa0
; CHECK-NEXT:    andi $a0, $a0, 544
; CHECK-NEXT:    sltu $a0, $zero, $a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 96)  ; 0x60 = "zero"
  ret i1 %0
}

define i1 @not_iszero_f(float %x) {
; CHECK-LABEL: not_iszero_f:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fclass.s $fa0, $fa0
; CHECK-NEXT:    movfr2gr.s $a0, $fa0
; CHECK-NEXT:    andi $a0, $a0, 479
; CHECK-NEXT:    sltu $a0, $zero, $a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 927)  ; ~0x60 = "~zero"
  ret i1 %0
}

define i1 @issubnormal_or_zero_f(float %x) {
; CHECK-LABEL: issubnormal_or_zero_f:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fclass.s $fa0, $fa0
; CHECK-NEXT:    movfr2gr.s $a0, $fa0
; CHECK-NEXT:    andi $a0, $a0, 816
; CHECK-NEXT:    sltu $a0, $zero, $a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 240)  ; 0xf0 = "subnormal|zero"
  ret i1 %0
}

define i1 @not_issubnormal_or_zero_f(float %x) {
; CHECK-LABEL: not_issubnormal_or_zero_f:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fclass.s $fa0, $fa0
; CHECK-NEXT:    movfr2gr.s $a0, $fa0
; CHECK-NEXT:    andi $a0, $a0, 207
; CHECK-NEXT:    sltu $a0, $zero, $a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 783)  ; ~0xf0 = "~(subnormal|zero)"
  ret i1 %0
}

define i1 @is_plus_zero_f(float %x) {
; CHECK-LABEL: is_plus_zero_f:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fclass.s $fa0, $fa0
; CHECK-NEXT:    movfr2gr.s $a0, $fa0
; CHECK-NEXT:    andi $a0, $a0, 512
; CHECK-NEXT:    sltu $a0, $zero, $a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 64)  ; 0x40 = "+zero"
  ret i1 %0
}

define i1 @not_is_plus_zero_f(float %x) {
; CHECK-LABEL: not_is_plus_zero_f:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fclass.s $fa0, $fa0
; CHECK-NEXT:    movfr2gr.s $a0, $fa0
; CHECK-NEXT:    andi $a0, $a0, 511
; CHECK-NEXT:    sltu $a0, $zero, $a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 959)  ; ~0x40 = ~"+zero"
  ret i1 %0
}

define i1 @is_minus_zero_f(float %x) {
; CHECK-LABEL: is_minus_zero_f:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fclass.s $fa0, $fa0
; CHECK-NEXT:    movfr2gr.s $a0, $fa0
; CHECK-NEXT:    andi $a0, $a0, 32
; CHECK-NEXT:    sltu $a0, $zero, $a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 32)  ; 0x20 = "-zero"
  ret i1 %0
}

define i1 @not_is_minus_zero_f(float %x) {
; CHECK-LABEL: not_is_minus_zero_f:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fclass.s $fa0, $fa0
; CHECK-NEXT:    movfr2gr.s $a0, $fa0
; CHECK-NEXT:    andi $a0, $a0, 991
; CHECK-NEXT:    sltu $a0, $zero, $a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 991)  ; ~0x20 = ~"-zero"
  ret i1 %0
}

define i1 @isnone_f(float %x) {
; CHECK-LABEL: isnone_f:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fclass.s $fa0, $fa0
; CHECK-NEXT:    movfr2gr.s $a0, $fa0
; CHECK-NEXT:    andi $a0, $a0, 0
; CHECK-NEXT:    sltu $a0, $zero, $a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 0)
  ret i1 %0
}

define i1 @isany_f(float %x) {
; CHECK-LABEL: isany_f:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fclass.s $fa0, $fa0
; CHECK-NEXT:    movfr2gr.s $a0, $fa0
; CHECK-NEXT:    andi $a0, $a0, 1023
; CHECK-NEXT:    sltu $a0, $zero, $a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 1023)
  ret i1 %0
}

define i1 @iszero_or_nan_f(float %x) {
; CHECK-LABEL: iszero_or_nan_f:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fclass.s $fa0, $fa0
; CHECK-NEXT:    movfr2gr.s $a0, $fa0
; CHECK-NEXT:    andi $a0, $a0, 547
; CHECK-NEXT:    sltu $a0, $zero, $a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 99)  ; 0x60|0x3 = "zero|nan"
  ret i1 %0
}

define i1 @not_iszero_or_nan_f(float %x) {
; CHECK-LABEL: not_iszero_or_nan_f:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fclass.s $fa0, $fa0
; CHECK-NEXT:    movfr2gr.s $a0, $fa0
; CHECK-NEXT:    andi $a0, $a0, 476
; CHECK-NEXT:    sltu $a0, $zero, $a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 924)  ; ~0x60 = "~(zero|nan)"
  ret i1 %0
}

define i1 @iszero_or_qnan_f(float %x) {
; CHECK-LABEL: iszero_or_qnan_f:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fclass.s $fa0, $fa0
; CHECK-NEXT:    movfr2gr.s $a0, $fa0
; CHECK-NEXT:    andi $a0, $a0, 546
; CHECK-NEXT:    sltu $a0, $zero, $a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 98)  ; 0x60|0x2 = "zero|qnan"
  ret i1 %0
}

define i1 @iszero_or_snan_f(float %x) {
; CHECK-LABEL: iszero_or_snan_f:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fclass.s $fa0, $fa0
; CHECK-NEXT:    movfr2gr.s $a0, $fa0
; CHECK-NEXT:    andi $a0, $a0, 545
; CHECK-NEXT:    sltu $a0, $zero, $a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 97)  ; 0x60|0x1 = "zero|snan"
  ret i1 %0
}

define i1 @not_iszero_or_qnan_f(float %x) {
; CHECK-LABEL: not_iszero_or_qnan_f:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fclass.s $fa0, $fa0
; CHECK-NEXT:    movfr2gr.s $a0, $fa0
; CHECK-NEXT:    andi $a0, $a0, 477
; CHECK-NEXT:    sltu $a0, $zero, $a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 925)  ; ~(0x60|0x2) = "~(zero|qnan)"
  ret i1 %0
}

define i1 @not_iszero_or_snan_f(float %x) {
; CHECK-LABEL: not_iszero_or_snan_f:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fclass.s $fa0, $fa0
; CHECK-NEXT:    movfr2gr.s $a0, $fa0
; CHECK-NEXT:    andi $a0, $a0, 478
; CHECK-NEXT:    sltu $a0, $zero, $a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 926)  ; ~(0x60|0x1) = "~(zero|snan)"
  ret i1 %0
}

define i1 @isinf_or_nan_f(float %x) {
; CHECK-LABEL: isinf_or_nan_f:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fclass.s $fa0, $fa0
; CHECK-NEXT:    movfr2gr.s $a0, $fa0
; CHECK-NEXT:    andi $a0, $a0, 71
; CHECK-NEXT:    sltu $a0, $zero, $a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 519)  ; 0x204|0x3 = "inf|nan"
  ret i1 %0
}

define i1 @not_isinf_or_nan_f(float %x) {
; CHECK-LABEL: not_isinf_or_nan_f:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fclass.s $fa0, $fa0
; CHECK-NEXT:    movfr2gr.s $a0, $fa0
; CHECK-NEXT:    andi $a0, $a0, 952
; CHECK-NEXT:    sltu $a0, $zero, $a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 504)  ; ~(0x204|0x3) = "~(inf|nan)"
  ret i1 %0
}

define i1 @isfinite_or_nan_f(float %x) {
; CHECK-LABEL: isfinite_or_nan_f:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fclass.s $fa0, $fa0
; CHECK-NEXT:    movfr2gr.s $a0, $fa0
; CHECK-NEXT:    andi $a0, $a0, 955
; CHECK-NEXT:    sltu $a0, $zero, $a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 507)  ; 0x1f8|0x3 = "finite|nan"
  ret i1 %0
}

define i1 @not_isfinite_or_nan_f(float %x) {
; CHECK-LABEL: not_isfinite_or_nan_f:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fclass.s $fa0, $fa0
; CHECK-NEXT:    movfr2gr.s $a0, $fa0
; CHECK-NEXT:    andi $a0, $a0, 68
; CHECK-NEXT:    sltu $a0, $zero, $a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 516)  ; ~(0x1f8|0x3) = "~(finite|nan)"
  ret i1 %0
}

define i1 @is_plus_inf_or_nan_f(float %x) {
; CHECK-LABEL: is_plus_inf_or_nan_f:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fclass.s $fa0, $fa0
; CHECK-NEXT:    movfr2gr.s $a0, $fa0
; CHECK-NEXT:    andi $a0, $a0, 67
; CHECK-NEXT:    sltu $a0, $zero, $a0
; CHECK-NEXT:    ret
  %class = tail call i1 @llvm.is.fpclass.f32(float %x, i32 515)  ; 0x200|0x3 = "+inf|nan"
  ret i1 %class
}

define i1 @is_minus_inf_or_nan_f(float %x) {
; CHECK-LABEL: is_minus_inf_or_nan_f:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fclass.s $fa0, $fa0
; CHECK-NEXT:    movfr2gr.s $a0, $fa0
; CHECK-NEXT:    andi $a0, $a0, 7
; CHECK-NEXT:    sltu $a0, $zero, $a0
; CHECK-NEXT:    ret
  %class = tail call i1 @llvm.is.fpclass.f32(float %x, i32 7)  ; "-inf|nan"
  ret i1 %class
}

define i1 @not_is_plus_inf_or_nan_f(float %x) {
; CHECK-LABEL: not_is_plus_inf_or_nan_f:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fclass.s $fa0, $fa0
; CHECK-NEXT:    movfr2gr.s $a0, $fa0
; CHECK-NEXT:    andi $a0, $a0, 956
; CHECK-NEXT:    sltu $a0, $zero, $a0
; CHECK-NEXT:    ret
  %class = tail call i1 @llvm.is.fpclass.f32(float %x, i32 508)  ; ~(0x200|0x3) = "~(+inf|nan)"
  ret i1 %class
}

define i1 @not_is_minus_inf_or_nan_f(float %x) {
; CHECK-LABEL: not_is_minus_inf_or_nan_f:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fclass.s $fa0, $fa0
; CHECK-NEXT:    movfr2gr.s $a0, $fa0
; CHECK-NEXT:    andi $a0, $a0, 1016
; CHECK-NEXT:    sltu $a0, $zero, $a0
; CHECK-NEXT:    ret
  %class = tail call i1 @llvm.is.fpclass.f32(float %x, i32 1016)  ; "~(-inf|nan)"
  ret i1 %class
}

define i1 @is_plus_inf_or_snan_f(float %x) {
; CHECK-LABEL: is_plus_inf_or_snan_f:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fclass.s $fa0, $fa0
; CHECK-NEXT:    movfr2gr.s $a0, $fa0
; CHECK-NEXT:    andi $a0, $a0, 65
; CHECK-NEXT:    sltu $a0, $zero, $a0
; CHECK-NEXT:    ret
  %class = tail call i1 @llvm.is.fpclass.f32(float %x, i32 513)  ; 0x200|0x1 = "+inf|snan"
  ret i1 %class
}

define i1 @is_plus_inf_or_qnan_f(float %x) {
; CHECK-LABEL: is_plus_inf_or_qnan_f:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fclass.s $fa0, $fa0
; CHECK-NEXT:    movfr2gr.s $a0, $fa0
; CHECK-NEXT:    andi $a0, $a0, 66
; CHECK-NEXT:    sltu $a0, $zero, $a0
; CHECK-NEXT:    ret
  %class = tail call i1 @llvm.is.fpclass.f32(float %x, i32 514)  ; 0x200|0x1 = "+inf|qnan"
  ret i1 %class
}

define i1 @not_is_plus_inf_or_snan_f(float %x) {
; CHECK-LABEL: not_is_plus_inf_or_snan_f:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fclass.s $fa0, $fa0
; CHECK-NEXT:    movfr2gr.s $a0, $fa0
; CHECK-NEXT:    andi $a0, $a0, 958
; CHECK-NEXT:    sltu $a0, $zero, $a0
; CHECK-NEXT:    ret
  %class = tail call i1 @llvm.is.fpclass.f32(float %x, i32 510) ; ~(+inf|snan)
  ret i1 %class
}

define i1 @not_is_plus_inf_or_qnan_f(float %x) {
; CHECK-LABEL: not_is_plus_inf_or_qnan_f:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fclass.s $fa0, $fa0
; CHECK-NEXT:    movfr2gr.s $a0, $fa0
; CHECK-NEXT:    andi $a0, $a0, 957
; CHECK-NEXT:    sltu $a0, $zero, $a0
; CHECK-NEXT:    ret
  %class = tail call i1 @llvm.is.fpclass.f32(float %x, i32 509) ; ~(+inf|qnan)
  ret i1 %class
}

define i1 @is_minus_inf_or_snan_f(float %x) {
; CHECK-LABEL: is_minus_inf_or_snan_f:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fclass.s $fa0, $fa0
; CHECK-NEXT:    movfr2gr.s $a0, $fa0
; CHECK-NEXT:    andi $a0, $a0, 5
; CHECK-NEXT:    sltu $a0, $zero, $a0
; CHECK-NEXT:    ret
  %class = tail call i1 @llvm.is.fpclass.f32(float %x, i32 5)  ; "-inf|snan"
  ret i1 %class
}

define i1 @is_minus_inf_or_qnan_f(float %x) {
; CHECK-LABEL: is_minus_inf_or_qnan_f:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fclass.s $fa0, $fa0
; CHECK-NEXT:    movfr2gr.s $a0, $fa0
; CHECK-NEXT:    andi $a0, $a0, 6
; CHECK-NEXT:    sltu $a0, $zero, $a0
; CHECK-NEXT:    ret
  %class = tail call i1 @llvm.is.fpclass.f32(float %x, i32 6)  ; "-inf|qnan"
  ret i1 %class
}

define i1 @not_is_minus_inf_or_snan_f(float %x) {
; CHECK-LABEL: not_is_minus_inf_or_snan_f:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fclass.s $fa0, $fa0
; CHECK-NEXT:    movfr2gr.s $a0, $fa0
; CHECK-NEXT:    andi $a0, $a0, 1018
; CHECK-NEXT:    sltu $a0, $zero, $a0
; CHECK-NEXT:    ret
  %class = tail call i1 @llvm.is.fpclass.f32(float %x, i32 1018)  ; "~(-inf|snan)"
  ret i1 %class
}

define i1 @not_is_minus_inf_or_qnan_f(float %x) {
; CHECK-LABEL: not_is_minus_inf_or_qnan_f:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fclass.s $fa0, $fa0
; CHECK-NEXT:    movfr2gr.s $a0, $fa0
; CHECK-NEXT:    andi $a0, $a0, 1017
; CHECK-NEXT:    sltu $a0, $zero, $a0
; CHECK-NEXT:    ret
  %class = tail call i1 @llvm.is.fpclass.f32(float %x, i32 1017)  ; "-inf|qnan"
  ret i1 %class
}

define i1 @issubnormal_or_nan_f(float %x) {
; CHECK-LABEL: issubnormal_or_nan_f:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fclass.s $fa0, $fa0
; CHECK-NEXT:    movfr2gr.s $a0, $fa0
; CHECK-NEXT:    andi $a0, $a0, 275
; CHECK-NEXT:    sltu $a0, $zero, $a0
; CHECK-NEXT:    ret
  %class = tail call i1 @llvm.is.fpclass.f32(float %x, i32 147)  ; 0x90|0x3 = "subnormal|nan"
  ret i1 %class
}

define i1 @issubnormal_or_zero_or_nan_f(float %x) {
; CHECK-LABEL: issubnormal_or_zero_or_nan_f:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fclass.s $fa0, $fa0
; CHECK-NEXT:    movfr2gr.s $a0, $fa0
; CHECK-NEXT:    andi $a0, $a0, 819
; CHECK-NEXT:    sltu $a0, $zero, $a0
; CHECK-NEXT:    ret
  %class = tail call i1 @llvm.is.fpclass.f32(float %x, i32 243)  ; 0xf0|0x3 = "subnormal|zero|nan"
  ret i1 %class
}

define i1 @issubnormal_or_zero_or_snan_f(float %x) {
; CHECK-LABEL: issubnormal_or_zero_or_snan_f:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fclass.s $fa0, $fa0
; CHECK-NEXT:    movfr2gr.s $a0, $fa0
; CHECK-NEXT:    andi $a0, $a0, 817
; CHECK-NEXT:    sltu $a0, $zero, $a0
; CHECK-NEXT:    ret
  %class = tail call i1 @llvm.is.fpclass.f32(float %x, i32 241)  ; 0x90|0x1 = "subnormal|snan"
  ret i1 %class
}

define i1 @issubnormal_or_zero_or_qnan_f(float %x) {
; CHECK-LABEL: issubnormal_or_zero_or_qnan_f:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fclass.s $fa0, $fa0
; CHECK-NEXT:    movfr2gr.s $a0, $fa0
; CHECK-NEXT:    andi $a0, $a0, 818
; CHECK-NEXT:    sltu $a0, $zero, $a0
; CHECK-NEXT:    ret
  %class = tail call i1 @llvm.is.fpclass.f32(float %x, i32 242)  ; 0x90|0x2 = "subnormal|qnan"
  ret i1 %class
}

define i1 @not_issubnormal_or_nan_f(float %x) {
; CHECK-LABEL: not_issubnormal_or_nan_f:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fclass.s $fa0, $fa0
; CHECK-NEXT:    movfr2gr.s $a0, $fa0
; CHECK-NEXT:    andi $a0, $a0, 748
; CHECK-NEXT:    sltu $a0, $zero, $a0
; CHECK-NEXT:    ret
  %class = tail call i1 @llvm.is.fpclass.f32(float %x, i32 876)  ; ~(0x90|0x3) = ~"subnormal|nan"
  ret i1 %class
}

define i1 @not_issubnormal_or_zero_or_nan_f(float %x) {
; CHECK-LABEL: not_issubnormal_or_zero_or_nan_f:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fclass.s $fa0, $fa0
; CHECK-NEXT:    movfr2gr.s $a0, $fa0
; CHECK-NEXT:    andi $a0, $a0, 204
; CHECK-NEXT:    sltu $a0, $zero, $a0
; CHECK-NEXT:    ret
  %class = tail call i1 @llvm.is.fpclass.f32(float %x, i32 780)  ; ~(0xf0|0x3) = ~"subnormal|zero|nan"
  ret i1 %class
}

define i1 @not_issubnormal_or_zero_or_snan_f(float %x) {
; CHECK-LABEL: not_issubnormal_or_zero_or_snan_f:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fclass.s $fa0, $fa0
; CHECK-NEXT:    movfr2gr.s $a0, $fa0
; CHECK-NEXT:    andi $a0, $a0, 206
; CHECK-NEXT:    sltu $a0, $zero, $a0
; CHECK-NEXT:    ret
  %class = tail call i1 @llvm.is.fpclass.f32(float %x, i32 782)  ; ~(0x90|0x1) = ~"subnormal|snan"
  ret i1 %class
}

define i1 @not_issubnormal_or_zero_or_qnan_f(float %x) {
; CHECK-LABEL: not_issubnormal_or_zero_or_qnan_f:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fclass.s $fa0, $fa0
; CHECK-NEXT:    movfr2gr.s $a0, $fa0
; CHECK-NEXT:    andi $a0, $a0, 205
; CHECK-NEXT:    sltu $a0, $zero, $a0
; CHECK-NEXT:    ret
  %class = tail call i1 @llvm.is.fpclass.f32(float %x, i32 781)  ; ~(0x90|0x2) = ~"subnormal|qnan"
  ret i1 %class
}

declare i1 @llvm.is.fpclass.f32(float, i32)
