LogicalView unit tests input files generation
=============================================

# Source file: test.cpp

```
using INTPTR = const int *;
int foo(INTPTR ParamPtr, unsigned ParamUnsigned, bool ParamBool) {
  if (ParamBool) {
    typedef int INTEGER;
    const INTEGER CONSTANT = 7;
    return CONSTANT;
  }
  return ParamUnsigned;
}
```

# Linux binary files:

## test-dwarf-clang.o

```clang -c -w -g -gdwarf-4 -O0 test.cpp -o test-dwarf-clang.o```

## test-dwarf-gcc.o

```g++ -c -w -g -O0 test.cpp -o test-dwarf-gcc.o```

# Windows binary files:

## test-codeview-clang.o

```clang++.exe --target=x86_64-windows -c -w -g -gcodeview test.cpp -o test-codeview-clang.o```

## test-codeview-msvc.o

```cl.exe /nologo /EHsc /Od /Z7 /Fotest-codeview-msvc.o /c test.cpp```

## test-codeview-pdb-msvc.o and test-codeview-pdb-msvc-.pdb

```cl.exe /nologo /EHsc /Od /Zi /Fotest-codeview-pdb-msvc.o /Fdtest-codeview-pdb-msvc-.pdb /c test.cpp```

## test-codeview-msvc.lib

This file is a static library embedding the **test-codeview-msvc.o** object file.
It is generated by the "lib.exe" tool shipped with MSVC compiler.

```lib.exe /OUT:test-codeview-msvc.lib test-codeview-msvc.o```
