; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-unknown | FileCheck %s --check-prefix=X86
; RUN: llc < %s -mtriple=x86_64-unknown | FileCheck %s --check-prefix=X64

define i32 @mask_add_sext_i32_i64(ptr %base, i32 %i) {
; X86-LABEL: mask_add_sext_i32_i64:
; X86:       # %bb.0:
; X86-NEXT:    movsbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl 12(%ecx,%eax,4), %eax
; X86-NEXT:    retl
;
; X64-LABEL: mask_add_sext_i32_i64:
; X64:       # %bb.0:
; X64-NEXT:    sarl $24, %esi
; X64-NEXT:    movslq %esi, %rax
; X64-NEXT:    movl 12(%rdi,%rax,4), %eax
; X64-NEXT:    retq
  %mask = ashr i32 %i, 24
  %offset = add i32 %mask, 3
  %sext = sext i32 %offset to i64
  %gep = getelementptr i32, ptr %base, i64 %sext
  %ret = load i32, ptr %gep
  ret i32 %ret
}

define i32 @mask_add_zext_i32_i64(ptr %base, i32 %i) {
; X86-LABEL: mask_add_zext_i32_i64:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    andl $15, %ecx
; X86-NEXT:    movl 12(%eax,%ecx,4), %eax
; X86-NEXT:    retl
;
; X64-LABEL: mask_add_zext_i32_i64:
; X64:       # %bb.0:
; X64-NEXT:    # kill: def $esi killed $esi def $rsi
; X64-NEXT:    andl $15, %esi
; X64-NEXT:    movl 12(%rdi,%rsi,4), %eax
; X64-NEXT:    retq
  %mask = and i32 %i, 15
  %offset = add i32 %mask, 3
  %zext = zext i32 %offset to i64
  %gep = getelementptr i32, ptr %base, i64 %zext
  %ret = load i32, ptr %gep
  ret i32 %ret
}

define i32 @mask_offset_scale_zext_i32_i64(ptr %base, i32 %i) {
; X86-LABEL: mask_offset_scale_zext_i32_i64:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    shll $11, %ecx
; X86-NEXT:    movl 48(%eax,%ecx), %eax
; X86-NEXT:    retl
;
; X64-LABEL: mask_offset_scale_zext_i32_i64:
; X64:       # %bb.0:
; X64-NEXT:    # kill: def $esi killed $esi def $rsi
; X64-NEXT:    andl $65280, %esi # imm = 0xFF00
; X64-NEXT:    movl 48(%rdi,%rsi,8), %eax
; X64-NEXT:    retq
  %mask = and i32 %i, 65280
  %offset = or i32 %mask, 6
  %scale = shl i32 %offset, 1
  %idxprom = zext i32 %scale to i64
  %arrayidx = getelementptr inbounds i32, ptr %base, i64 %idxprom
  %load = load i32, ptr %arrayidx, align 4
  ret i32 %load
}

; PR97533 - multiple uses of shl node (add + gep) in the same dependency chain.
define i64 @add_shl_zext(ptr %ptr, i8 %arg) nounwind {
; X86-LABEL: add_shl_zext:
; X86:       # %bb.0:
; X86-NEXT:    pushl %esi
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl 4(%esi,%ecx,4), %edx
; X86-NEXT:    leal (,%ecx,8), %eax
; X86-NEXT:    addl (%esi,%ecx,4), %eax
; X86-NEXT:    adcl $0, %edx
; X86-NEXT:    popl %esi
; X86-NEXT:    retl
;
; X64-LABEL: add_shl_zext:
; X64:       # %bb.0:
; X64-NEXT:    movzbl %sil, %eax
; X64-NEXT:    shll $3, %eax
; X64-NEXT:    addq (%rdi,%rax), %rax
; X64-NEXT:    retq
  %idx = zext i8 %arg to i64
  %gep = getelementptr ptr, ptr %ptr, i64 %idx
  %val = load i64, ptr %gep, align 8
  %shl = shl i64 %idx, 3
  %sum = add i64 %val, %shl
  ret i64 %sum
}
