; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=instcombine -S < %s | FileCheck %s

target datalayout = "p:64:64:64-i64:32:32"


define ptr @test1(ptr %x) {
; CHECK-LABEL: @test1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[B:%.*]] = load i64, ptr [[X:%.*]], align 4
; CHECK-NEXT:    [[C:%.*]] = inttoptr i64 [[B]] to ptr
; CHECK-NEXT:    ret ptr [[C]]
;
entry:
  %b = load i64, ptr %x
  %c = inttoptr i64 %b to ptr

  ret ptr %c
}

define ptr @test2(ptr %x) {
; CHECK-LABEL: @test2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[B:%.*]] = load i32, ptr [[X:%.*]], align 4
; CHECK-NEXT:    [[TMP0:%.*]] = zext i32 [[B]] to i64
; CHECK-NEXT:    [[C:%.*]] = inttoptr i64 [[TMP0]] to ptr
; CHECK-NEXT:    ret ptr [[C]]
;
entry:
  %b = load i32, ptr %x
  %c = inttoptr i32 %b to ptr

  ret ptr %c
}

define ptr @test3(ptr %x) {
; CHECK-LABEL: @test3(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[B:%.*]] = load i32, ptr [[X:%.*]], align 4
; CHECK-NEXT:    [[TMP0:%.*]] = zext i32 [[B]] to i64
; CHECK-NEXT:    [[C:%.*]] = inttoptr i64 [[TMP0]] to ptr
; CHECK-NEXT:    ret ptr [[C]]
;
entry:
  %b = load i32, ptr %x
  %c = inttoptr i32 %b to ptr

  ret ptr %c
}

define i64 @test4(ptr %x) {
; CHECK-LABEL: @test4(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[B:%.*]] = load ptr, ptr [[X:%.*]], align 8
; CHECK-NEXT:    [[C:%.*]] = ptrtoint ptr [[B]] to i64
; CHECK-NEXT:    ret i64 [[C]]
;
entry:
  %b = load ptr, ptr %x
  %c = ptrtoint ptr %b to i64

  ret i64 %c
}

define i32 @test5(ptr %x) {
; CHECK-LABEL: @test5(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[B:%.*]] = load ptr, ptr [[X:%.*]], align 8
; CHECK-NEXT:    [[TMP0:%.*]] = ptrtoint ptr [[B]] to i64
; CHECK-NEXT:    [[C:%.*]] = trunc i64 [[TMP0]] to i32
; CHECK-NEXT:    ret i32 [[C]]
;
entry:
  %b = load ptr, ptr %x
  %c = ptrtoint ptr %b to i32

  ret i32 %c
}

define i64 @test6(ptr %x) {
; CHECK-LABEL: @test6(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[B:%.*]] = load ptr, ptr [[X:%.*]], align 8
; CHECK-NEXT:    [[C:%.*]] = ptrtoint ptr [[B]] to i64
; CHECK-NEXT:    ret i64 [[C]]
;
entry:
  %b = load ptr, ptr %x
  %c = ptrtoint ptr %b to i64

  ret i64 %c
}

