# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=x86_64-unknown-unknown -mcpu=alderlake -instruction-tables < %s | FileCheck %s

cmpxchg8b  (%rax)
cmpxchg16b (%rax)
lock cmpxchg8b  (%rax)
lock cmpxchg16b (%rax)

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  16     25    3.50    *      *            cmpxchg8b	(%rax)
# CHECK-NEXT:  22     32    4.00    *      *            cmpxchg16b	(%rax)
# CHECK-NEXT:  16     25    3.50    *      *            lock		cmpxchg8b	(%rax)
# CHECK-NEXT:  22     32    4.00    *      *            lock		cmpxchg16b	(%rax)

# CHECK:      Resources:
# CHECK-NEXT: [0]   - ADLPPort00
# CHECK-NEXT: [1]   - ADLPPort01
# CHECK-NEXT: [2]   - ADLPPort02
# CHECK-NEXT: [3]   - ADLPPort03
# CHECK-NEXT: [4]   - ADLPPort04
# CHECK-NEXT: [5]   - ADLPPort05
# CHECK-NEXT: [6]   - ADLPPort06
# CHECK-NEXT: [7]   - ADLPPort07
# CHECK-NEXT: [8]   - ADLPPort08
# CHECK-NEXT: [9]   - ADLPPort09
# CHECK-NEXT: [10]  - ADLPPort10
# CHECK-NEXT: [11]  - ADLPPort11
# CHECK-NEXT: [12]  - ADLPPortInvalid

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12]
# CHECK-NEXT: 21.40  10.40  1.33   1.33   2.00   10.40  17.40  2.00   2.00   2.00   1.33   4.40    -

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12]   Instructions:
# CHECK-NEXT: 4.30   2.80   0.33   0.33   0.50   0.80   4.30   0.50   0.50   0.50   0.33   0.80    -     cmpxchg8b	(%rax)
# CHECK-NEXT: 6.40   2.40   0.33   0.33   0.50   4.40   4.40   0.50   0.50   0.50   0.33   1.40    -     cmpxchg16b	(%rax)
# CHECK-NEXT: 4.30   2.80   0.33   0.33   0.50   0.80   4.30   0.50   0.50   0.50   0.33   0.80    -     lock		cmpxchg8b	(%rax)
# CHECK-NEXT: 6.40   2.40   0.33   0.33   0.50   4.40   4.40   0.50   0.50   0.50   0.33   1.40    -     lock		cmpxchg16b	(%rax)
