; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512fp16,+avx512vl | FileCheck %s --check-prefixes=CHECK

define <8 x half> @extract_v16f16_v8f16_0(<16 x half> %x) {
; CHECK-LABEL: extract_v16f16_v8f16_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
  %a = shufflevector <16 x half> %x, <16 x half> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  ret <8 x half> %a
}

define <8 x half> @extract_v16f16_v8f16_1(<16 x half> %x) {
; CHECK-LABEL: extract_v16f16_v8f16_1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vextractf128 $1, %ymm0, %xmm0
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
  %a = shufflevector <16 x half> %x, <16 x half> undef, <8 x i32> <i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  ret <8 x half> %a
}

define <8 x half> @extract_v32f16_v8f16_0(<32 x half> %x) {
; CHECK-LABEL: extract_v32f16_v8f16_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
  %a = shufflevector <32 x half> %x, <32 x half> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  ret <8 x half> %a
}

define <8 x half> @extract_v32f16_v8f16_1(<32 x half> %x) {
; CHECK-LABEL: extract_v32f16_v8f16_1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vextractf128 $1, %ymm0, %xmm0
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
  %a = shufflevector <32 x half> %x, <32 x half> undef, <8 x i32> <i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  ret <8 x half> %a
}

define <8 x half> @extract_v32f16_v8f16_2(<32 x half> %x) {
; CHECK-LABEL: extract_v32f16_v8f16_2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vextractf32x4 $2, %zmm0, %xmm0
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
  %a = shufflevector <32 x half> %x, <32 x half> undef, <8 x i32> <i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23>
  ret <8 x half> %a
}

define <8 x half> @extract_v32f16_v8f16_3(<32 x half> %x) {
; CHECK-LABEL: extract_v32f16_v8f16_3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vextractf32x4 $3, %zmm0, %xmm0
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
  %a = shufflevector <32 x half> %x, <32 x half> undef, <8 x i32> <i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  ret <8 x half> %a
}

define <16 x half> @extract_v32f16_v81616_0(<32 x half> %x) {
; CHECK-LABEL: extract_v32f16_v81616_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; CHECK-NEXT:    retq
  %a = shufflevector <32 x half> %x, <32 x half> undef, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  ret <16 x half> %a
}

define <16 x half> @extract_v32f16_v81616_1(<32 x half> %x) {
; CHECK-LABEL: extract_v32f16_v81616_1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vextractf64x4 $1, %zmm0, %ymm0
; CHECK-NEXT:    retq
  %a = shufflevector <32 x half> %x, <32 x half> undef, <16 x i32> <i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  ret <16 x half> %a
}

define <16 x half> @concat_v8f16(<8 x half> %x, <8 x half> %y) {
; CHECK-LABEL: concat_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; CHECK-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; CHECK-NEXT:    retq
  %a = shufflevector <8 x half> %x, <8 x half> %y, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  ret <16 x half> %a
}

define <32 x half> @concat_v16f16(<16 x half> %x, <16 x half> %y) {
; CHECK-LABEL: concat_v16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; CHECK-NEXT:    vinsertf64x4 $1, %ymm1, %zmm0, %zmm0
; CHECK-NEXT:    retq
  %a = shufflevector <16 x half> %x, <16 x half> %y, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  ret <32 x half> %a
}

define <16 x half> @concat_zero_v8f16(<8 x half> %x, <8 x half> %y) {
; CHECK-LABEL: concat_zero_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmovaps %xmm0, %xmm0
; CHECK-NEXT:    retq
  %a = shufflevector <8 x half> %x, <8 x half> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  ret <16 x half> %a
}

define <32 x half> @concat_zero_v16f16(<16 x half> %x, <16 x half> %y) {
; CHECK-LABEL: concat_zero_v16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmovaps %ymm0, %ymm0
; CHECK-NEXT:    retq
  %a = shufflevector <16 x half> %x, <16 x half> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  ret <32 x half> %a
}

define <32 x half> @insert_v8f16_v32f16_0(<32 x half> %x, <8 x half> %y) {
; CHECK-LABEL: insert_v8f16_v32f16_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vinsertf32x4 $0, %xmm1, %zmm0, %zmm0
; CHECK-NEXT:    retq
  %a = shufflevector <8 x half> %y, <8 x half> undef, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %b = shufflevector <32 x half> %x, <32 x half> %a, <32 x i32> <i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  ret <32 x half> %b
}

define <32 x half> @insert_v8f16_v32f16_1(<32 x half> %x, <8 x half> %y) {
; CHECK-LABEL: insert_v8f16_v32f16_1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vinsertf32x4 $1, %xmm1, %zmm0, %zmm0
; CHECK-NEXT:    retq
  %a = shufflevector <8 x half> %y, <8 x half> undef, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %b = shufflevector <32 x half> %x, <32 x half> %a, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  ret <32 x half> %b
}

define <32 x half> @insert_v8f16_v32f16_2(<32 x half> %x, <8 x half> %y) {
; CHECK-LABEL: insert_v8f16_v32f16_2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vinsertf32x4 $2, %xmm1, %zmm0, %zmm0
; CHECK-NEXT:    retq
  %a = shufflevector <8 x half> %y, <8 x half> undef, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %b = shufflevector <32 x half> %x, <32 x half> %a, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  ret <32 x half> %b
}

define <32 x half> @insert_v8f16_v32f16_3(<32 x half> %x, <8 x half> %y) {
; CHECK-LABEL: insert_v8f16_v32f16_3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vinsertf32x4 $3, %xmm1, %zmm0, %zmm0
; CHECK-NEXT:    retq
  %a = shufflevector <8 x half> %y, <8 x half> undef, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %b = shufflevector <32 x half> %x, <32 x half> %a, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39>
  ret <32 x half> %b
}
