; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc < %s -mtriple=amdgcn -mcpu=verde -verify-machineinstrs | FileCheck -check-prefixes=GFX68,VERDE %s
; RUN: llc < %s -mtriple=amdgcn -mcpu=tonga -verify-machineinstrs | FileCheck -check-prefixes=GFX68,GFX8 %s
; RUN: llc < %s -mtriple=amdgcn -mcpu=gfx1100 -verify-machineinstrs | FileCheck -check-prefixes=GFX11 %s

define amdgpu_ps void @buffer_store(<4 x i32> inreg, <4 x float>, <4 x float>, <4 x float>) {
; GFX68-LABEL: buffer_store:
; GFX68:       ; %bb.0: ; %main_body
; GFX68-NEXT:    v_mov_b32_e32 v12, 0
; GFX68-NEXT:    buffer_store_dwordx4 v[0:3], v12, s[0:3], 0 idxen
; GFX68-NEXT:    buffer_store_dwordx4 v[4:7], v12, s[0:3], 0 idxen glc
; GFX68-NEXT:    buffer_store_dwordx4 v[8:11], v12, s[0:3], 0 idxen slc
; GFX68-NEXT:    s_endpgm
;
; GFX11-LABEL: buffer_store:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    v_mov_b32_e32 v12, 0
; GFX11-NEXT:    s_clause 0x2
; GFX11-NEXT:    buffer_store_b128 v[0:3], v12, s[0:3], 0 idxen
; GFX11-NEXT:    buffer_store_b128 v[4:7], v12, s[0:3], 0 idxen glc
; GFX11-NEXT:    buffer_store_b128 v[8:11], v12, s[0:3], 0 idxen slc
; GFX11-NEXT:    s_endpgm
main_body:
  call void @llvm.amdgcn.struct.buffer.store.v4f32(<4 x float> %1, <4 x i32> %0, i32 0, i32 0, i32 0, i32 0)
  call void @llvm.amdgcn.struct.buffer.store.v4f32(<4 x float> %2, <4 x i32> %0, i32 0, i32 0, i32 0, i32 1)
  call void @llvm.amdgcn.struct.buffer.store.v4f32(<4 x float> %3, <4 x i32> %0, i32 0, i32 0, i32 0, i32 2)
  ret void
}

define amdgpu_ps void @buffer_store_immoffs(<4 x i32> inreg, <4 x float>) {
; GFX68-LABEL: buffer_store_immoffs:
; GFX68:       ; %bb.0: ; %main_body
; GFX68-NEXT:    v_mov_b32_e32 v4, 0
; GFX68-NEXT:    buffer_store_dwordx4 v[0:3], v4, s[0:3], 0 idxen offset:42
; GFX68-NEXT:    s_endpgm
;
; GFX11-LABEL: buffer_store_immoffs:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    v_mov_b32_e32 v4, 0
; GFX11-NEXT:    buffer_store_b128 v[0:3], v4, s[0:3], 0 idxen offset:42
; GFX11-NEXT:    s_endpgm
main_body:
  call void @llvm.amdgcn.struct.buffer.store.v4f32(<4 x float> %1, <4 x i32> %0, i32 0, i32 42, i32 0, i32 0)
  ret void
}

define amdgpu_ps void @buffer_store_idx(<4 x i32> inreg, <4 x float>, i32) {
; GFX68-LABEL: buffer_store_idx:
; GFX68:       ; %bb.0: ; %main_body
; GFX68-NEXT:    buffer_store_dwordx4 v[0:3], v4, s[0:3], 0 idxen
; GFX68-NEXT:    s_endpgm
;
; GFX11-LABEL: buffer_store_idx:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    buffer_store_b128 v[0:3], v4, s[0:3], 0 idxen
; GFX11-NEXT:    s_endpgm
main_body:
  call void @llvm.amdgcn.struct.buffer.store.v4f32(<4 x float> %1, <4 x i32> %0, i32 %2, i32 0, i32 0, i32 0)
  ret void
}

define amdgpu_ps void @buffer_store_ofs(<4 x i32> inreg, <4 x float>, i32) {
; GFX68-LABEL: buffer_store_ofs:
; GFX68:       ; %bb.0: ; %main_body
; GFX68-NEXT:    s_mov_b32 s4, 0
; GFX68-NEXT:    v_mov_b32_e32 v5, v4
; GFX68-NEXT:    v_mov_b32_e32 v4, s4
; GFX68-NEXT:    buffer_store_dwordx4 v[0:3], v[4:5], s[0:3], 0 idxen offen
; GFX68-NEXT:    s_endpgm
;
; GFX11-LABEL: buffer_store_ofs:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    s_mov_b32 s4, 0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v5, v4 :: v_dual_mov_b32 v4, s4
; GFX11-NEXT:    buffer_store_b128 v[0:3], v[4:5], s[0:3], 0 idxen offen
; GFX11-NEXT:    s_endpgm
main_body:
  call void @llvm.amdgcn.struct.buffer.store.v4f32(<4 x float> %1, <4 x i32> %0, i32 0, i32 %2, i32 0, i32 0)
  ret void
}

define amdgpu_ps void @buffer_store_both(<4 x i32> inreg, <4 x float>, i32, i32) {
; GFX68-LABEL: buffer_store_both:
; GFX68:       ; %bb.0: ; %main_body
; GFX68-NEXT:    buffer_store_dwordx4 v[0:3], v[4:5], s[0:3], 0 idxen offen
; GFX68-NEXT:    s_endpgm
;
; GFX11-LABEL: buffer_store_both:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    buffer_store_b128 v[0:3], v[4:5], s[0:3], 0 idxen offen
; GFX11-NEXT:    s_endpgm
main_body:
  call void @llvm.amdgcn.struct.buffer.store.v4f32(<4 x float> %1, <4 x i32> %0, i32 %2, i32 %3, i32 0, i32 0)
  ret void
}

define amdgpu_ps void @buffer_store_both_reversed(<4 x i32> inreg, <4 x float>, i32, i32) {
; GFX68-LABEL: buffer_store_both_reversed:
; GFX68:       ; %bb.0: ; %main_body
; GFX68-NEXT:    v_mov_b32_e32 v6, v4
; GFX68-NEXT:    buffer_store_dwordx4 v[0:3], v[5:6], s[0:3], 0 idxen offen
; GFX68-NEXT:    s_endpgm
;
; GFX11-LABEL: buffer_store_both_reversed:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    v_mov_b32_e32 v6, v4
; GFX11-NEXT:    buffer_store_b128 v[0:3], v[5:6], s[0:3], 0 idxen offen
; GFX11-NEXT:    s_endpgm
main_body:
  call void @llvm.amdgcn.struct.buffer.store.v4f32(<4 x float> %1, <4 x i32> %0, i32 %3, i32 %2, i32 0, i32 0)
  ret void
}

; Ideally, the register allocator would avoid the wait here
define amdgpu_ps void @buffer_store_wait(<4 x i32> inreg, <4 x float>, i32, i32, i32) {
; VERDE-LABEL: buffer_store_wait:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    buffer_store_dwordx4 v[0:3], v4, s[0:3], 0 idxen
; VERDE-NEXT:    s_waitcnt expcnt(0)
; VERDE-NEXT:    buffer_load_dwordx4 v[0:3], v5, s[0:3], 0 idxen
; VERDE-NEXT:    s_waitcnt vmcnt(0)
; VERDE-NEXT:    buffer_store_dwordx4 v[0:3], v6, s[0:3], 0 idxen
; VERDE-NEXT:    s_endpgm
;
; GFX8-LABEL: buffer_store_wait:
; GFX8:       ; %bb.0: ; %main_body
; GFX8-NEXT:    buffer_store_dwordx4 v[0:3], v4, s[0:3], 0 idxen
; GFX8-NEXT:    buffer_load_dwordx4 v[0:3], v5, s[0:3], 0 idxen
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_store_dwordx4 v[0:3], v6, s[0:3], 0 idxen
; GFX8-NEXT:    s_endpgm
;
; GFX11-LABEL: buffer_store_wait:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    buffer_store_b128 v[0:3], v4, s[0:3], 0 idxen
; GFX11-NEXT:    buffer_load_b128 v[0:3], v5, s[0:3], 0 idxen
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_store_b128 v[0:3], v6, s[0:3], 0 idxen
; GFX11-NEXT:    s_endpgm
main_body:
  call void @llvm.amdgcn.struct.buffer.store.v4f32(<4 x float> %1, <4 x i32> %0, i32 %2, i32 0, i32 0, i32 0)
  %data = call <4 x float> @llvm.amdgcn.struct.buffer.load.v4f32(<4 x i32> %0, i32 %3, i32 0, i32 0, i32 0)
  call void @llvm.amdgcn.struct.buffer.store.v4f32(<4 x float> %data, <4 x i32> %0, i32 %4, i32 0, i32 0, i32 0)
  ret void
}

define amdgpu_ps void @buffer_store_x1(<4 x i32> inreg %rsrc, float %data, i32 %index) {
; GFX68-LABEL: buffer_store_x1:
; GFX68:       ; %bb.0: ; %main_body
; GFX68-NEXT:    buffer_store_dword v0, v1, s[0:3], 0 idxen
; GFX68-NEXT:    s_endpgm
;
; GFX11-LABEL: buffer_store_x1:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    buffer_store_b32 v0, v1, s[0:3], 0 idxen
; GFX11-NEXT:    s_endpgm
main_body:
  call void @llvm.amdgcn.struct.buffer.store.f32(float %data, <4 x i32> %rsrc, i32 %index, i32 0, i32 0, i32 0)
  ret void
}

define amdgpu_ps void @buffer_store_x2(<4 x i32> inreg %rsrc, <2 x float> %data, i32 %index) #0 {
; GFX68-LABEL: buffer_store_x2:
; GFX68:       ; %bb.0: ; %main_body
; GFX68-NEXT:    buffer_store_dwordx2 v[0:1], v2, s[0:3], 0 idxen
; GFX68-NEXT:    s_endpgm
;
; GFX11-LABEL: buffer_store_x2:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    buffer_store_b64 v[0:1], v2, s[0:3], 0 idxen
; GFX11-NEXT:    s_endpgm
main_body:
  call void @llvm.amdgcn.struct.buffer.store.v2f32(<2 x float> %data, <4 x i32> %rsrc, i32 %index, i32 0, i32 0, i32 0)
  ret void
}

define amdgpu_ps void @buffer_store_int(<4 x i32> inreg, <4 x i32>, <2 x i32>, i32) {
; GFX68-LABEL: buffer_store_int:
; GFX68:       ; %bb.0: ; %main_body
; GFX68-NEXT:    v_mov_b32_e32 v7, 0
; GFX68-NEXT:    buffer_store_dwordx4 v[0:3], v7, s[0:3], 0 idxen
; GFX68-NEXT:    buffer_store_dwordx2 v[4:5], v7, s[0:3], 0 idxen glc
; GFX68-NEXT:    buffer_store_dword v6, v7, s[0:3], 0 idxen slc
; GFX68-NEXT:    s_endpgm
;
; GFX11-LABEL: buffer_store_int:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    v_mov_b32_e32 v7, 0
; GFX11-NEXT:    s_clause 0x2
; GFX11-NEXT:    buffer_store_b128 v[0:3], v7, s[0:3], 0 idxen
; GFX11-NEXT:    buffer_store_b64 v[4:5], v7, s[0:3], 0 idxen glc
; GFX11-NEXT:    buffer_store_b32 v6, v7, s[0:3], 0 idxen slc
; GFX11-NEXT:    s_endpgm
main_body:
  call void @llvm.amdgcn.struct.buffer.store.v4i32(<4 x i32> %1, <4 x i32> %0, i32 0, i32 0, i32 0, i32 0)
  call void @llvm.amdgcn.struct.buffer.store.v2i32(<2 x i32> %2, <4 x i32> %0, i32 0, i32 0, i32 0, i32 1)
  call void @llvm.amdgcn.struct.buffer.store.i32(i32 %3, <4 x i32> %0, i32 0, i32 0, i32 0, i32 2)
  ret void
}

define amdgpu_ps void @struct_buffer_store_byte(<4 x i32> inreg %rsrc, float %v1, i32 %index) {
; GFX68-LABEL: struct_buffer_store_byte:
; GFX68:       ; %bb.0: ; %main_body
; GFX68-NEXT:    v_cvt_u32_f32_e32 v0, v0
; GFX68-NEXT:    buffer_store_byte v0, v1, s[0:3], 0 idxen
; GFX68-NEXT:    s_endpgm
;
; GFX11-LABEL: struct_buffer_store_byte:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    v_cvt_u32_f32_e32 v0, v0
; GFX11-NEXT:    buffer_store_b8 v0, v1, s[0:3], 0 idxen
; GFX11-NEXT:    s_endpgm
main_body:
  %v2 = fptoui float %v1 to i32
  %v3 = trunc i32 %v2 to i8
  call void @llvm.amdgcn.struct.buffer.store.i8(i8 %v3, <4 x i32> %rsrc, i32 %index, i32 0, i32 0, i32 0)
  ret void
}

define amdgpu_ps void @struct_buffer_store_f16(<4 x i32> inreg %rsrc, float %v1, i32 %index) {
; GFX68-LABEL: struct_buffer_store_f16:
; GFX68:       ; %bb.0:
; GFX68-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX68-NEXT:    buffer_store_short v0, v1, s[0:3], 0 idxen
; GFX68-NEXT:    s_endpgm
;
; GFX11-LABEL: struct_buffer_store_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX11-NEXT:    buffer_store_b16 v0, v1, s[0:3], 0 idxen
; GFX11-NEXT:    s_endpgm
  %v2 = fptrunc float %v1 to half
  call void @llvm.amdgcn.struct.buffer.store.f16(half %v2, <4 x i32> %rsrc, i32 %index, i32 0, i32 0, i32 0)
  ret void
}

define amdgpu_ps void @struct_buffer_store_v2f16(<4 x i32> inreg %rsrc, <2 x half> %v1, i32 %index) {
; VERDE-LABEL: struct_buffer_store_v2f16:
; VERDE:       ; %bb.0:
; VERDE-NEXT:    v_cvt_f16_f32_e32 v1, v1
; VERDE-NEXT:    v_cvt_f16_f32_e32 v0, v0
; VERDE-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; VERDE-NEXT:    v_or_b32_e32 v0, v0, v1
; VERDE-NEXT:    buffer_store_dword v0, v2, s[0:3], 0 idxen
; VERDE-NEXT:    s_endpgm
;
; GFX8-LABEL: struct_buffer_store_v2f16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    buffer_store_dword v0, v1, s[0:3], 0 idxen
; GFX8-NEXT:    s_endpgm
;
; GFX11-LABEL: struct_buffer_store_v2f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    buffer_store_b32 v0, v1, s[0:3], 0 idxen
; GFX11-NEXT:    s_endpgm
  call void @llvm.amdgcn.struct.buffer.store.v2f16(<2 x half> %v1, <4 x i32> %rsrc, i32 %index, i32 0, i32 0, i32 0)
  ret void
}

define amdgpu_ps void @struct_buffer_store_v4f16(<4 x i32> inreg %rsrc, <4 x half> %v1, i32 %index) {
; VERDE-LABEL: struct_buffer_store_v4f16:
; VERDE:       ; %bb.0:
; VERDE-NEXT:    v_cvt_f16_f32_e32 v3, v3
; VERDE-NEXT:    v_cvt_f16_f32_e32 v2, v2
; VERDE-NEXT:    v_cvt_f16_f32_e32 v5, v1
; VERDE-NEXT:    v_cvt_f16_f32_e32 v0, v0
; VERDE-NEXT:    v_lshlrev_b32_e32 v1, 16, v3
; VERDE-NEXT:    v_or_b32_e32 v1, v2, v1
; VERDE-NEXT:    v_lshlrev_b32_e32 v2, 16, v5
; VERDE-NEXT:    v_or_b32_e32 v0, v0, v2
; VERDE-NEXT:    buffer_store_dwordx2 v[0:1], v4, s[0:3], 0 idxen
; VERDE-NEXT:    s_endpgm
;
; GFX8-LABEL: struct_buffer_store_v4f16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    buffer_store_dwordx2 v[0:1], v2, s[0:3], 0 idxen
; GFX8-NEXT:    s_endpgm
;
; GFX11-LABEL: struct_buffer_store_v4f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    buffer_store_b64 v[0:1], v2, s[0:3], 0 idxen
; GFX11-NEXT:    s_endpgm
  call void @llvm.amdgcn.struct.buffer.store.v4f16(<4 x half> %v1, <4 x i32> %rsrc, i32 %index, i32 0, i32 0, i32 0)
  ret void
}

define amdgpu_ps void @struct_buffer_store_i16(<4 x i32> inreg %rsrc, float %v1, i32 %index) {
; GFX68-LABEL: struct_buffer_store_i16:
; GFX68:       ; %bb.0: ; %main_body
; GFX68-NEXT:    v_cvt_u32_f32_e32 v0, v0
; GFX68-NEXT:    buffer_store_short v0, v1, s[0:3], 0 idxen
; GFX68-NEXT:    s_endpgm
;
; GFX11-LABEL: struct_buffer_store_i16:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    v_cvt_u32_f32_e32 v0, v0
; GFX11-NEXT:    buffer_store_b16 v0, v1, s[0:3], 0 idxen
; GFX11-NEXT:    s_endpgm
main_body:
  %v2 = fptoui float %v1 to i32
  %v3 = trunc i32 %v2 to i16
  call void @llvm.amdgcn.struct.buffer.store.i16(i16 %v3, <4 x i32> %rsrc, i32 %index, i32 0, i32 0, i32 0)
  ret void
}

define amdgpu_ps void @struct_buffer_store_vif16(<4 x i32> inreg %rsrc, <2 x i16> %v1, i32 %index) {
; VERDE-LABEL: struct_buffer_store_vif16:
; VERDE:       ; %bb.0:
; VERDE-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; VERDE-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; VERDE-NEXT:    v_or_b32_e32 v0, v0, v1
; VERDE-NEXT:    buffer_store_dword v0, v2, s[0:3], 0 idxen
; VERDE-NEXT:    s_endpgm
;
; GFX8-LABEL: struct_buffer_store_vif16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    buffer_store_dword v0, v1, s[0:3], 0 idxen
; GFX8-NEXT:    s_endpgm
;
; GFX11-LABEL: struct_buffer_store_vif16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    buffer_store_b32 v0, v1, s[0:3], 0 idxen
; GFX11-NEXT:    s_endpgm
  call void @llvm.amdgcn.struct.buffer.store.v2i16(<2 x i16> %v1, <4 x i32> %rsrc, i32 %index, i32 0, i32 0, i32 0)
  ret void
}

define amdgpu_ps void @struct_buffer_store_v4i16(<4 x i32> inreg %rsrc, <4 x i16> %v1, i32 %index) {
; VERDE-LABEL: struct_buffer_store_v4i16:
; VERDE:       ; %bb.0:
; VERDE-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; VERDE-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; VERDE-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; VERDE-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; VERDE-NEXT:    v_or_b32_e32 v2, v2, v3
; VERDE-NEXT:    v_or_b32_e32 v1, v0, v1
; VERDE-NEXT:    buffer_store_dwordx2 v[1:2], v4, s[0:3], 0 idxen
; VERDE-NEXT:    s_endpgm
;
; GFX8-LABEL: struct_buffer_store_v4i16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    buffer_store_dwordx2 v[0:1], v2, s[0:3], 0 idxen
; GFX8-NEXT:    s_endpgm
;
; GFX11-LABEL: struct_buffer_store_v4i16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    buffer_store_b64 v[0:1], v2, s[0:3], 0 idxen
; GFX11-NEXT:    s_endpgm
  call void @llvm.amdgcn.struct.buffer.store.v4i16(<4 x i16> %v1, <4 x i32> %rsrc, i32 %index, i32 0, i32 0, i32 0)
  ret void
}

declare void @llvm.amdgcn.struct.buffer.store.f32(float, <4 x i32>, i32, i32, i32, i32) #0
declare void @llvm.amdgcn.struct.buffer.store.v2f32(<2 x float>, <4 x i32>, i32, i32, i32, i32) #0
declare void @llvm.amdgcn.struct.buffer.store.v4f32(<4 x float>, <4 x i32>, i32, i32, i32, i32) #0
declare void @llvm.amdgcn.struct.buffer.store.i32(i32, <4 x i32>, i32, i32, i32, i32) #0
declare void @llvm.amdgcn.struct.buffer.store.v2i32(<2 x i32>, <4 x i32>, i32, i32, i32, i32) #0
declare void @llvm.amdgcn.struct.buffer.store.v4i32(<4 x i32>, <4 x i32>, i32, i32, i32, i32) #0
declare <4 x float> @llvm.amdgcn.struct.buffer.load.v4f32(<4 x i32>, i32, i32, i32, i32) #1
declare void @llvm.amdgcn.struct.buffer.store.i8(i8, <4 x i32>, i32, i32, i32, i32) #0
declare void @llvm.amdgcn.struct.buffer.store.i16(i16, <4 x i32>, i32, i32, i32, i32) #0
declare void @llvm.amdgcn.struct.buffer.store.v2i16(<2 x i16>, <4 x i32>, i32, i32, i32, i32) #0
declare void @llvm.amdgcn.struct.buffer.store.v4i16(<4 x i16>, <4 x i32>, i32, i32, i32, i32) #0
declare void @llvm.amdgcn.struct.buffer.store.f16(half, <4 x i32>, i32, i32, i32, i32) #0
declare void @llvm.amdgcn.struct.buffer.store.v2f16(<2 x half>, <4 x i32>, i32, i32, i32, i32) #0
declare void @llvm.amdgcn.struct.buffer.store.v4f16(<4 x half>, <4 x i32>, i32, i32, i32, i32) #0

attributes #0 = { nounwind }
attributes #1 = { nounwind readonly }
