; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+m -verify-machineinstrs < %s | FileCheck --check-prefixes=CHECK,RV32IM %s
; RUN: llc -mtriple=riscv64 -mattr=+m -verify-machineinstrs < %s | FileCheck --check-prefixes=CHECK,RV64IM %s
; RUN: llc -mtriple=riscv64 -mattr=+m,+xventanacondops -verify-machineinstrs < %s | FileCheck --check-prefixes=CHECK,RV64IMXVTCONDOPS %s
; RUN: llc -mtriple=riscv32 -mattr=+m,+zicond -verify-machineinstrs < %s | FileCheck --check-prefixes=CHECK,CHECKZICOND,RV32IMZICOND %s
; RUN: llc -mtriple=riscv64 -mattr=+m,+zicond -verify-machineinstrs < %s | FileCheck --check-prefixes=CHECK,CHECKZICOND,RV64IMZICOND %s

define i16 @select_xor_1(i16 %A, i8 %cond) {
; RV32IM-LABEL: select_xor_1:
; RV32IM:       # %bb.0: # %entry
; RV32IM-NEXT:    slli a1, a1, 31
; RV32IM-NEXT:    srai a1, a1, 31
; RV32IM-NEXT:    andi a1, a1, 43
; RV32IM-NEXT:    xor a0, a0, a1
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_xor_1:
; RV64IM:       # %bb.0: # %entry
; RV64IM-NEXT:    slli a1, a1, 63
; RV64IM-NEXT:    srai a1, a1, 63
; RV64IM-NEXT:    andi a1, a1, 43
; RV64IM-NEXT:    xor a0, a0, a1
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_xor_1:
; RV64IMXVTCONDOPS:       # %bb.0: # %entry
; RV64IMXVTCONDOPS-NEXT:    andi a1, a1, 1
; RV64IMXVTCONDOPS-NEXT:    li a2, 43
; RV64IMXVTCONDOPS-NEXT:    vt.maskc a1, a2, a1
; RV64IMXVTCONDOPS-NEXT:    xor a0, a0, a1
; RV64IMXVTCONDOPS-NEXT:    ret
;
; CHECKZICOND-LABEL: select_xor_1:
; CHECKZICOND:       # %bb.0: # %entry
; CHECKZICOND-NEXT:    andi a1, a1, 1
; CHECKZICOND-NEXT:    li a2, 43
; CHECKZICOND-NEXT:    czero.eqz a1, a2, a1
; CHECKZICOND-NEXT:    xor a0, a0, a1
; CHECKZICOND-NEXT:    ret
entry:
 %and = and i8 %cond, 1
 %cmp10 = icmp eq i8 %and, 0
 %0 = xor i16 %A, 43
 %1 = select i1 %cmp10, i16 %A, i16 %0
 ret i16 %1
}

; Equivalent to above, but with icmp ne (and %cond, 1), 1 instead of
; icmp eq (and %cond, 1), 0
define i16 @select_xor_1b(i16 %A, i8 %cond) {
; RV32IM-LABEL: select_xor_1b:
; RV32IM:       # %bb.0: # %entry
; RV32IM-NEXT:    slli a1, a1, 31
; RV32IM-NEXT:    srai a1, a1, 31
; RV32IM-NEXT:    andi a1, a1, 43
; RV32IM-NEXT:    xor a0, a0, a1
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_xor_1b:
; RV64IM:       # %bb.0: # %entry
; RV64IM-NEXT:    slli a1, a1, 63
; RV64IM-NEXT:    srai a1, a1, 63
; RV64IM-NEXT:    andi a1, a1, 43
; RV64IM-NEXT:    xor a0, a0, a1
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_xor_1b:
; RV64IMXVTCONDOPS:       # %bb.0: # %entry
; RV64IMXVTCONDOPS-NEXT:    andi a1, a1, 1
; RV64IMXVTCONDOPS-NEXT:    li a2, 43
; RV64IMXVTCONDOPS-NEXT:    vt.maskc a1, a2, a1
; RV64IMXVTCONDOPS-NEXT:    xor a0, a0, a1
; RV64IMXVTCONDOPS-NEXT:    ret
;
; CHECKZICOND-LABEL: select_xor_1b:
; CHECKZICOND:       # %bb.0: # %entry
; CHECKZICOND-NEXT:    andi a1, a1, 1
; CHECKZICOND-NEXT:    li a2, 43
; CHECKZICOND-NEXT:    czero.eqz a1, a2, a1
; CHECKZICOND-NEXT:    xor a0, a0, a1
; CHECKZICOND-NEXT:    ret
entry:
 %and = and i8 %cond, 1
 %cmp10 = icmp ne i8 %and, 1
 %0 = xor i16 %A, 43
 %1 = select i1 %cmp10, i16 %A, i16 %0
 ret i16 %1
}

define i32 @select_xor_2(i32 %A, i32 %B, i8 %cond) {
; RV32IM-LABEL: select_xor_2:
; RV32IM:       # %bb.0: # %entry
; RV32IM-NEXT:    slli a2, a2, 31
; RV32IM-NEXT:    srai a2, a2, 31
; RV32IM-NEXT:    and a1, a2, a1
; RV32IM-NEXT:    xor a0, a0, a1
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_xor_2:
; RV64IM:       # %bb.0: # %entry
; RV64IM-NEXT:    slli a2, a2, 63
; RV64IM-NEXT:    srai a2, a2, 63
; RV64IM-NEXT:    and a1, a2, a1
; RV64IM-NEXT:    xor a0, a0, a1
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_xor_2:
; RV64IMXVTCONDOPS:       # %bb.0: # %entry
; RV64IMXVTCONDOPS-NEXT:    andi a2, a2, 1
; RV64IMXVTCONDOPS-NEXT:    vt.maskc a1, a1, a2
; RV64IMXVTCONDOPS-NEXT:    xor a0, a0, a1
; RV64IMXVTCONDOPS-NEXT:    ret
;
; CHECKZICOND-LABEL: select_xor_2:
; CHECKZICOND:       # %bb.0: # %entry
; CHECKZICOND-NEXT:    andi a2, a2, 1
; CHECKZICOND-NEXT:    czero.eqz a1, a1, a2
; CHECKZICOND-NEXT:    xor a0, a0, a1
; CHECKZICOND-NEXT:    ret
entry:
 %and = and i8 %cond, 1
 %cmp10 = icmp eq i8 %and, 0
 %0 = xor i32 %B, %A
 %1 = select i1 %cmp10, i32 %A, i32 %0
 ret i32 %1
}

; Equivalent to above, but with icmp ne (and %cond, 1), 1 instead of
; icmp eq (and %cond, 1), 0
define i32 @select_xor_2b(i32 %A, i32 %B, i8 %cond) {
; RV32IM-LABEL: select_xor_2b:
; RV32IM:       # %bb.0: # %entry
; RV32IM-NEXT:    slli a2, a2, 31
; RV32IM-NEXT:    srai a2, a2, 31
; RV32IM-NEXT:    and a1, a2, a1
; RV32IM-NEXT:    xor a0, a0, a1
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_xor_2b:
; RV64IM:       # %bb.0: # %entry
; RV64IM-NEXT:    slli a2, a2, 63
; RV64IM-NEXT:    srai a2, a2, 63
; RV64IM-NEXT:    and a1, a2, a1
; RV64IM-NEXT:    xor a0, a0, a1
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_xor_2b:
; RV64IMXVTCONDOPS:       # %bb.0: # %entry
; RV64IMXVTCONDOPS-NEXT:    andi a2, a2, 1
; RV64IMXVTCONDOPS-NEXT:    vt.maskc a1, a1, a2
; RV64IMXVTCONDOPS-NEXT:    xor a0, a0, a1
; RV64IMXVTCONDOPS-NEXT:    ret
;
; CHECKZICOND-LABEL: select_xor_2b:
; CHECKZICOND:       # %bb.0: # %entry
; CHECKZICOND-NEXT:    andi a2, a2, 1
; CHECKZICOND-NEXT:    czero.eqz a1, a1, a2
; CHECKZICOND-NEXT:    xor a0, a0, a1
; CHECKZICOND-NEXT:    ret
entry:
 %and = and i8 %cond, 1
 %cmp10 = icmp ne i8 %and, 1
 %0 = xor i32 %B, %A
 %1 = select i1 %cmp10, i32 %A, i32 %0
 ret i32 %1
}

define i16 @select_xor_3(i16 %A, i8 %cond) {
; RV32IM-LABEL: select_xor_3:
; RV32IM:       # %bb.0: # %entry
; RV32IM-NEXT:    andi a1, a1, 1
; RV32IM-NEXT:    addi a1, a1, -1
; RV32IM-NEXT:    andi a1, a1, 43
; RV32IM-NEXT:    xor a0, a0, a1
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_xor_3:
; RV64IM:       # %bb.0: # %entry
; RV64IM-NEXT:    andi a1, a1, 1
; RV64IM-NEXT:    addi a1, a1, -1
; RV64IM-NEXT:    andi a1, a1, 43
; RV64IM-NEXT:    xor a0, a0, a1
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_xor_3:
; RV64IMXVTCONDOPS:       # %bb.0: # %entry
; RV64IMXVTCONDOPS-NEXT:    andi a1, a1, 1
; RV64IMXVTCONDOPS-NEXT:    li a2, 43
; RV64IMXVTCONDOPS-NEXT:    vt.maskcn a1, a2, a1
; RV64IMXVTCONDOPS-NEXT:    xor a0, a0, a1
; RV64IMXVTCONDOPS-NEXT:    ret
;
; CHECKZICOND-LABEL: select_xor_3:
; CHECKZICOND:       # %bb.0: # %entry
; CHECKZICOND-NEXT:    andi a1, a1, 1
; CHECKZICOND-NEXT:    li a2, 43
; CHECKZICOND-NEXT:    czero.nez a1, a2, a1
; CHECKZICOND-NEXT:    xor a0, a0, a1
; CHECKZICOND-NEXT:    ret
entry:
 %and = and i8 %cond, 1
 %cmp10 = icmp eq i8 %and, 0
 %0 = xor i16 %A, 43
 %1 = select i1 %cmp10, i16 %0, i16 %A
 ret i16 %1
}

; Equivalent to above, but with icmp ne (and %cond, 1), 1 instead of
; icmp eq (and %cond, 1), 0
define i16 @select_xor_3b(i16 %A, i8 %cond) {
; RV32IM-LABEL: select_xor_3b:
; RV32IM:       # %bb.0: # %entry
; RV32IM-NEXT:    andi a1, a1, 1
; RV32IM-NEXT:    addi a1, a1, -1
; RV32IM-NEXT:    andi a1, a1, 43
; RV32IM-NEXT:    xor a0, a0, a1
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_xor_3b:
; RV64IM:       # %bb.0: # %entry
; RV64IM-NEXT:    andi a1, a1, 1
; RV64IM-NEXT:    addi a1, a1, -1
; RV64IM-NEXT:    andi a1, a1, 43
; RV64IM-NEXT:    xor a0, a0, a1
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_xor_3b:
; RV64IMXVTCONDOPS:       # %bb.0: # %entry
; RV64IMXVTCONDOPS-NEXT:    andi a1, a1, 1
; RV64IMXVTCONDOPS-NEXT:    li a2, 43
; RV64IMXVTCONDOPS-NEXT:    vt.maskcn a1, a2, a1
; RV64IMXVTCONDOPS-NEXT:    xor a0, a0, a1
; RV64IMXVTCONDOPS-NEXT:    ret
;
; CHECKZICOND-LABEL: select_xor_3b:
; CHECKZICOND:       # %bb.0: # %entry
; CHECKZICOND-NEXT:    andi a1, a1, 1
; CHECKZICOND-NEXT:    li a2, 43
; CHECKZICOND-NEXT:    czero.nez a1, a2, a1
; CHECKZICOND-NEXT:    xor a0, a0, a1
; CHECKZICOND-NEXT:    ret
entry:
 %and = and i8 %cond, 1
 %cmp10 = icmp ne i8 %and, 1
 %0 = xor i16 %A, 43
 %1 = select i1 %cmp10, i16 %0, i16 %A
 ret i16 %1
}

define i32 @select_xor_4(i32 %A, i32 %B, i8 %cond) {
; RV32IM-LABEL: select_xor_4:
; RV32IM:       # %bb.0: # %entry
; RV32IM-NEXT:    andi a2, a2, 1
; RV32IM-NEXT:    addi a2, a2, -1
; RV32IM-NEXT:    and a1, a2, a1
; RV32IM-NEXT:    xor a0, a0, a1
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_xor_4:
; RV64IM:       # %bb.0: # %entry
; RV64IM-NEXT:    andi a2, a2, 1
; RV64IM-NEXT:    addi a2, a2, -1
; RV64IM-NEXT:    and a1, a2, a1
; RV64IM-NEXT:    xor a0, a0, a1
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_xor_4:
; RV64IMXVTCONDOPS:       # %bb.0: # %entry
; RV64IMXVTCONDOPS-NEXT:    andi a2, a2, 1
; RV64IMXVTCONDOPS-NEXT:    vt.maskcn a1, a1, a2
; RV64IMXVTCONDOPS-NEXT:    xor a0, a0, a1
; RV64IMXVTCONDOPS-NEXT:    ret
;
; CHECKZICOND-LABEL: select_xor_4:
; CHECKZICOND:       # %bb.0: # %entry
; CHECKZICOND-NEXT:    andi a2, a2, 1
; CHECKZICOND-NEXT:    czero.nez a1, a1, a2
; CHECKZICOND-NEXT:    xor a0, a0, a1
; CHECKZICOND-NEXT:    ret
entry:
 %and = and i8 %cond, 1
 %cmp10 = icmp eq i8 %and, 0
 %0 = xor i32 %B, %A
 %1 = select i1 %cmp10, i32 %0, i32 %A
 ret i32 %1
}

; Equivalent to above, but with icmp ne (and %cond, 1), 1 instead of
; icmp eq (and %cond, 1), 0
define i32 @select_xor_4b(i32 %A, i32 %B, i8 %cond) {
; RV32IM-LABEL: select_xor_4b:
; RV32IM:       # %bb.0: # %entry
; RV32IM-NEXT:    andi a2, a2, 1
; RV32IM-NEXT:    addi a2, a2, -1
; RV32IM-NEXT:    and a1, a2, a1
; RV32IM-NEXT:    xor a0, a0, a1
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_xor_4b:
; RV64IM:       # %bb.0: # %entry
; RV64IM-NEXT:    andi a2, a2, 1
; RV64IM-NEXT:    addi a2, a2, -1
; RV64IM-NEXT:    and a1, a2, a1
; RV64IM-NEXT:    xor a0, a0, a1
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_xor_4b:
; RV64IMXVTCONDOPS:       # %bb.0: # %entry
; RV64IMXVTCONDOPS-NEXT:    andi a2, a2, 1
; RV64IMXVTCONDOPS-NEXT:    vt.maskcn a1, a1, a2
; RV64IMXVTCONDOPS-NEXT:    xor a0, a0, a1
; RV64IMXVTCONDOPS-NEXT:    ret
;
; CHECKZICOND-LABEL: select_xor_4b:
; CHECKZICOND:       # %bb.0: # %entry
; CHECKZICOND-NEXT:    andi a2, a2, 1
; CHECKZICOND-NEXT:    czero.nez a1, a1, a2
; CHECKZICOND-NEXT:    xor a0, a0, a1
; CHECKZICOND-NEXT:    ret
entry:
 %and = and i8 %cond, 1
 %cmp10 = icmp ne i8 %and, 1
 %0 = xor i32 %B, %A
 %1 = select i1 %cmp10, i32 %0, i32 %A
 ret i32 %1
}

define i32 @select_or(i32 %A, i32 %B, i8 %cond) {
; RV32IM-LABEL: select_or:
; RV32IM:       # %bb.0: # %entry
; RV32IM-NEXT:    slli a2, a2, 31
; RV32IM-NEXT:    srai a2, a2, 31
; RV32IM-NEXT:    and a1, a2, a1
; RV32IM-NEXT:    or a0, a0, a1
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_or:
; RV64IM:       # %bb.0: # %entry
; RV64IM-NEXT:    slli a2, a2, 63
; RV64IM-NEXT:    srai a2, a2, 63
; RV64IM-NEXT:    and a1, a2, a1
; RV64IM-NEXT:    or a0, a0, a1
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_or:
; RV64IMXVTCONDOPS:       # %bb.0: # %entry
; RV64IMXVTCONDOPS-NEXT:    andi a2, a2, 1
; RV64IMXVTCONDOPS-NEXT:    vt.maskc a1, a1, a2
; RV64IMXVTCONDOPS-NEXT:    or a0, a0, a1
; RV64IMXVTCONDOPS-NEXT:    ret
;
; CHECKZICOND-LABEL: select_or:
; CHECKZICOND:       # %bb.0: # %entry
; CHECKZICOND-NEXT:    andi a2, a2, 1
; CHECKZICOND-NEXT:    czero.eqz a1, a1, a2
; CHECKZICOND-NEXT:    or a0, a0, a1
; CHECKZICOND-NEXT:    ret
entry:
 %and = and i8 %cond, 1
 %cmp10 = icmp eq i8 %and, 0
 %0 = or i32 %B, %A
 %1 = select i1 %cmp10, i32 %A, i32 %0
 ret i32 %1
}

; Equivalent to above, but with icmp ne (and %cond, 1), 1 instead of
; icmp eq (and %cond, 1), 0
define i32 @select_or_b(i32 %A, i32 %B, i8 %cond) {
; RV32IM-LABEL: select_or_b:
; RV32IM:       # %bb.0: # %entry
; RV32IM-NEXT:    slli a2, a2, 31
; RV32IM-NEXT:    srai a2, a2, 31
; RV32IM-NEXT:    and a1, a2, a1
; RV32IM-NEXT:    or a0, a0, a1
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_or_b:
; RV64IM:       # %bb.0: # %entry
; RV64IM-NEXT:    slli a2, a2, 63
; RV64IM-NEXT:    srai a2, a2, 63
; RV64IM-NEXT:    and a1, a2, a1
; RV64IM-NEXT:    or a0, a0, a1
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_or_b:
; RV64IMXVTCONDOPS:       # %bb.0: # %entry
; RV64IMXVTCONDOPS-NEXT:    andi a2, a2, 1
; RV64IMXVTCONDOPS-NEXT:    vt.maskc a1, a1, a2
; RV64IMXVTCONDOPS-NEXT:    or a0, a0, a1
; RV64IMXVTCONDOPS-NEXT:    ret
;
; CHECKZICOND-LABEL: select_or_b:
; CHECKZICOND:       # %bb.0: # %entry
; CHECKZICOND-NEXT:    andi a2, a2, 1
; CHECKZICOND-NEXT:    czero.eqz a1, a1, a2
; CHECKZICOND-NEXT:    or a0, a0, a1
; CHECKZICOND-NEXT:    ret
entry:
 %and = and i8 %cond, 1
 %cmp10 = icmp ne i8 %and, 1
 %0 = or i32 %B, %A
 %1 = select i1 %cmp10, i32 %A, i32 %0
 ret i32 %1
}

define i32 @select_or_1(i32 %A, i32 %B, i32 %cond) {
; RV32IM-LABEL: select_or_1:
; RV32IM:       # %bb.0: # %entry
; RV32IM-NEXT:    slli a2, a2, 31
; RV32IM-NEXT:    srai a2, a2, 31
; RV32IM-NEXT:    and a1, a2, a1
; RV32IM-NEXT:    or a0, a0, a1
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_or_1:
; RV64IM:       # %bb.0: # %entry
; RV64IM-NEXT:    slli a2, a2, 63
; RV64IM-NEXT:    srai a2, a2, 63
; RV64IM-NEXT:    and a1, a2, a1
; RV64IM-NEXT:    or a0, a0, a1
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_or_1:
; RV64IMXVTCONDOPS:       # %bb.0: # %entry
; RV64IMXVTCONDOPS-NEXT:    andi a2, a2, 1
; RV64IMXVTCONDOPS-NEXT:    vt.maskc a1, a1, a2
; RV64IMXVTCONDOPS-NEXT:    or a0, a0, a1
; RV64IMXVTCONDOPS-NEXT:    ret
;
; CHECKZICOND-LABEL: select_or_1:
; CHECKZICOND:       # %bb.0: # %entry
; CHECKZICOND-NEXT:    andi a2, a2, 1
; CHECKZICOND-NEXT:    czero.eqz a1, a1, a2
; CHECKZICOND-NEXT:    or a0, a0, a1
; CHECKZICOND-NEXT:    ret
entry:
 %and = and i32 %cond, 1
 %cmp10 = icmp eq i32 %and, 0
 %0 = or i32 %B, %A
 %1 = select i1 %cmp10, i32 %A, i32 %0
 ret i32 %1
}

; Equivalent to above, but with icmp ne (and %cond, 1), 1 instead of
; icmp eq (and %cond, 1), 0
define i32 @select_or_1b(i32 %A, i32 %B, i32 %cond) {
; RV32IM-LABEL: select_or_1b:
; RV32IM:       # %bb.0: # %entry
; RV32IM-NEXT:    slli a2, a2, 31
; RV32IM-NEXT:    srai a2, a2, 31
; RV32IM-NEXT:    and a1, a2, a1
; RV32IM-NEXT:    or a0, a0, a1
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_or_1b:
; RV64IM:       # %bb.0: # %entry
; RV64IM-NEXT:    slli a2, a2, 63
; RV64IM-NEXT:    srai a2, a2, 63
; RV64IM-NEXT:    and a1, a2, a1
; RV64IM-NEXT:    or a0, a0, a1
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_or_1b:
; RV64IMXVTCONDOPS:       # %bb.0: # %entry
; RV64IMXVTCONDOPS-NEXT:    andi a2, a2, 1
; RV64IMXVTCONDOPS-NEXT:    vt.maskc a1, a1, a2
; RV64IMXVTCONDOPS-NEXT:    or a0, a0, a1
; RV64IMXVTCONDOPS-NEXT:    ret
;
; CHECKZICOND-LABEL: select_or_1b:
; CHECKZICOND:       # %bb.0: # %entry
; CHECKZICOND-NEXT:    andi a2, a2, 1
; CHECKZICOND-NEXT:    czero.eqz a1, a1, a2
; CHECKZICOND-NEXT:    or a0, a0, a1
; CHECKZICOND-NEXT:    ret
entry:
 %and = and i32 %cond, 1
 %cmp10 = icmp ne i32 %and, 1
 %0 = or i32 %B, %A
 %1 = select i1 %cmp10, i32 %A, i32 %0
 ret i32 %1
}

define i32 @select_or_2(i32 %A, i32 %B, i8 %cond) {
; RV32IM-LABEL: select_or_2:
; RV32IM:       # %bb.0: # %entry
; RV32IM-NEXT:    andi a2, a2, 1
; RV32IM-NEXT:    addi a2, a2, -1
; RV32IM-NEXT:    and a1, a2, a1
; RV32IM-NEXT:    or a0, a0, a1
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_or_2:
; RV64IM:       # %bb.0: # %entry
; RV64IM-NEXT:    andi a2, a2, 1
; RV64IM-NEXT:    addi a2, a2, -1
; RV64IM-NEXT:    and a1, a2, a1
; RV64IM-NEXT:    or a0, a0, a1
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_or_2:
; RV64IMXVTCONDOPS:       # %bb.0: # %entry
; RV64IMXVTCONDOPS-NEXT:    andi a2, a2, 1
; RV64IMXVTCONDOPS-NEXT:    vt.maskcn a1, a1, a2
; RV64IMXVTCONDOPS-NEXT:    or a0, a0, a1
; RV64IMXVTCONDOPS-NEXT:    ret
;
; CHECKZICOND-LABEL: select_or_2:
; CHECKZICOND:       # %bb.0: # %entry
; CHECKZICOND-NEXT:    andi a2, a2, 1
; CHECKZICOND-NEXT:    czero.nez a1, a1, a2
; CHECKZICOND-NEXT:    or a0, a0, a1
; CHECKZICOND-NEXT:    ret
entry:
 %and = and i8 %cond, 1
 %cmp10 = icmp eq i8 %and, 0
 %0 = or i32 %B, %A
 %1 = select i1 %cmp10, i32 %0, i32 %A
 ret i32 %1
}

; Equivalent to above, but with icmp ne (and %cond, 1), 1 instead of
; icmp eq (and %cond, 1), 0
define i32 @select_or_2b(i32 %A, i32 %B, i8 %cond) {
; RV32IM-LABEL: select_or_2b:
; RV32IM:       # %bb.0: # %entry
; RV32IM-NEXT:    andi a2, a2, 1
; RV32IM-NEXT:    addi a2, a2, -1
; RV32IM-NEXT:    and a1, a2, a1
; RV32IM-NEXT:    or a0, a0, a1
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_or_2b:
; RV64IM:       # %bb.0: # %entry
; RV64IM-NEXT:    andi a2, a2, 1
; RV64IM-NEXT:    addi a2, a2, -1
; RV64IM-NEXT:    and a1, a2, a1
; RV64IM-NEXT:    or a0, a0, a1
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_or_2b:
; RV64IMXVTCONDOPS:       # %bb.0: # %entry
; RV64IMXVTCONDOPS-NEXT:    andi a2, a2, 1
; RV64IMXVTCONDOPS-NEXT:    vt.maskcn a1, a1, a2
; RV64IMXVTCONDOPS-NEXT:    or a0, a0, a1
; RV64IMXVTCONDOPS-NEXT:    ret
;
; CHECKZICOND-LABEL: select_or_2b:
; CHECKZICOND:       # %bb.0: # %entry
; CHECKZICOND-NEXT:    andi a2, a2, 1
; CHECKZICOND-NEXT:    czero.nez a1, a1, a2
; CHECKZICOND-NEXT:    or a0, a0, a1
; CHECKZICOND-NEXT:    ret
entry:
 %and = and i8 %cond, 1
 %cmp10 = icmp ne i8 %and, 1
 %0 = or i32 %B, %A
 %1 = select i1 %cmp10, i32 %0, i32 %A
 ret i32 %1
}

define i32 @select_or_3(i32 %A, i32 %B, i32 %cond) {
; RV32IM-LABEL: select_or_3:
; RV32IM:       # %bb.0: # %entry
; RV32IM-NEXT:    andi a2, a2, 1
; RV32IM-NEXT:    addi a2, a2, -1
; RV32IM-NEXT:    and a1, a2, a1
; RV32IM-NEXT:    or a0, a0, a1
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_or_3:
; RV64IM:       # %bb.0: # %entry
; RV64IM-NEXT:    andi a2, a2, 1
; RV64IM-NEXT:    addi a2, a2, -1
; RV64IM-NEXT:    and a1, a2, a1
; RV64IM-NEXT:    or a0, a0, a1
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_or_3:
; RV64IMXVTCONDOPS:       # %bb.0: # %entry
; RV64IMXVTCONDOPS-NEXT:    andi a2, a2, 1
; RV64IMXVTCONDOPS-NEXT:    vt.maskcn a1, a1, a2
; RV64IMXVTCONDOPS-NEXT:    or a0, a0, a1
; RV64IMXVTCONDOPS-NEXT:    ret
;
; CHECKZICOND-LABEL: select_or_3:
; CHECKZICOND:       # %bb.0: # %entry
; CHECKZICOND-NEXT:    andi a2, a2, 1
; CHECKZICOND-NEXT:    czero.nez a1, a1, a2
; CHECKZICOND-NEXT:    or a0, a0, a1
; CHECKZICOND-NEXT:    ret
entry:
 %and = and i32 %cond, 1
 %cmp10 = icmp eq i32 %and, 0
 %0 = or i32 %B, %A
 %1 = select i1 %cmp10, i32 %0, i32 %A
 ret i32 %1
}

; Equivalent to above, but with icmp ne (and %cond, 1), 1 instead of
; icmp eq (and %cond, 1), 0
define i32 @select_or_3b(i32 %A, i32 %B, i32 %cond) {
; RV32IM-LABEL: select_or_3b:
; RV32IM:       # %bb.0: # %entry
; RV32IM-NEXT:    andi a2, a2, 1
; RV32IM-NEXT:    addi a2, a2, -1
; RV32IM-NEXT:    and a1, a2, a1
; RV32IM-NEXT:    or a0, a0, a1
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_or_3b:
; RV64IM:       # %bb.0: # %entry
; RV64IM-NEXT:    andi a2, a2, 1
; RV64IM-NEXT:    addi a2, a2, -1
; RV64IM-NEXT:    and a1, a2, a1
; RV64IM-NEXT:    or a0, a0, a1
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_or_3b:
; RV64IMXVTCONDOPS:       # %bb.0: # %entry
; RV64IMXVTCONDOPS-NEXT:    andi a2, a2, 1
; RV64IMXVTCONDOPS-NEXT:    vt.maskcn a1, a1, a2
; RV64IMXVTCONDOPS-NEXT:    or a0, a0, a1
; RV64IMXVTCONDOPS-NEXT:    ret
;
; CHECKZICOND-LABEL: select_or_3b:
; CHECKZICOND:       # %bb.0: # %entry
; CHECKZICOND-NEXT:    andi a2, a2, 1
; CHECKZICOND-NEXT:    czero.nez a1, a1, a2
; CHECKZICOND-NEXT:    or a0, a0, a1
; CHECKZICOND-NEXT:    ret
entry:
 %and = and i32 %cond, 1
 %cmp10 = icmp ne i32 %and, 1
 %0 = or i32 %B, %A
 %1 = select i1 %cmp10, i32 %0, i32 %A
 ret i32 %1
}

define i32 @select_add_1(i1 zeroext %cond, i32 %a, i32 %b) {
; RV32IM-LABEL: select_add_1:
; RV32IM:       # %bb.0: # %entry
; RV32IM-NEXT:    neg a0, a0
; RV32IM-NEXT:    and a0, a0, a1
; RV32IM-NEXT:    add a0, a2, a0
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_add_1:
; RV64IM:       # %bb.0: # %entry
; RV64IM-NEXT:    negw a0, a0
; RV64IM-NEXT:    and a0, a0, a1
; RV64IM-NEXT:    addw a0, a2, a0
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_add_1:
; RV64IMXVTCONDOPS:       # %bb.0: # %entry
; RV64IMXVTCONDOPS-NEXT:    vt.maskc a0, a1, a0
; RV64IMXVTCONDOPS-NEXT:    addw a0, a2, a0
; RV64IMXVTCONDOPS-NEXT:    ret
;
; RV32IMZICOND-LABEL: select_add_1:
; RV32IMZICOND:       # %bb.0: # %entry
; RV32IMZICOND-NEXT:    czero.eqz a0, a1, a0
; RV32IMZICOND-NEXT:    add a0, a2, a0
; RV32IMZICOND-NEXT:    ret
;
; RV64IMZICOND-LABEL: select_add_1:
; RV64IMZICOND:       # %bb.0: # %entry
; RV64IMZICOND-NEXT:    czero.eqz a0, a1, a0
; RV64IMZICOND-NEXT:    addw a0, a2, a0
; RV64IMZICOND-NEXT:    ret
entry:
  %c = add i32 %a, %b
  %res = select i1 %cond, i32 %c, i32 %b
  ret i32 %res
}

define i32 @select_add_2(i1 zeroext %cond, i32 %a, i32 %b) {
; RV32IM-LABEL: select_add_2:
; RV32IM:       # %bb.0: # %entry
; RV32IM-NEXT:    addi a0, a0, -1
; RV32IM-NEXT:    and a0, a0, a2
; RV32IM-NEXT:    add a0, a1, a0
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_add_2:
; RV64IM:       # %bb.0: # %entry
; RV64IM-NEXT:    addi a0, a0, -1
; RV64IM-NEXT:    and a0, a0, a2
; RV64IM-NEXT:    addw a0, a1, a0
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_add_2:
; RV64IMXVTCONDOPS:       # %bb.0: # %entry
; RV64IMXVTCONDOPS-NEXT:    vt.maskcn a0, a2, a0
; RV64IMXVTCONDOPS-NEXT:    addw a0, a1, a0
; RV64IMXVTCONDOPS-NEXT:    ret
;
; RV32IMZICOND-LABEL: select_add_2:
; RV32IMZICOND:       # %bb.0: # %entry
; RV32IMZICOND-NEXT:    czero.nez a0, a2, a0
; RV32IMZICOND-NEXT:    add a0, a1, a0
; RV32IMZICOND-NEXT:    ret
;
; RV64IMZICOND-LABEL: select_add_2:
; RV64IMZICOND:       # %bb.0: # %entry
; RV64IMZICOND-NEXT:    czero.nez a0, a2, a0
; RV64IMZICOND-NEXT:    addw a0, a1, a0
; RV64IMZICOND-NEXT:    ret
entry:
  %c = add i32 %a, %b
  %res = select i1 %cond, i32 %a, i32 %c
  ret i32 %res
}

define i32 @select_add_3(i1 zeroext %cond, i32 %a) {
; RV32IM-LABEL: select_add_3:
; RV32IM:       # %bb.0: # %entry
; RV32IM-NEXT:    addi a0, a0, -1
; RV32IM-NEXT:    andi a0, a0, 42
; RV32IM-NEXT:    add a0, a1, a0
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_add_3:
; RV64IM:       # %bb.0: # %entry
; RV64IM-NEXT:    addi a0, a0, -1
; RV64IM-NEXT:    andi a0, a0, 42
; RV64IM-NEXT:    addw a0, a1, a0
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_add_3:
; RV64IMXVTCONDOPS:       # %bb.0: # %entry
; RV64IMXVTCONDOPS-NEXT:    li a2, 42
; RV64IMXVTCONDOPS-NEXT:    vt.maskcn a0, a2, a0
; RV64IMXVTCONDOPS-NEXT:    addw a0, a1, a0
; RV64IMXVTCONDOPS-NEXT:    ret
;
; RV32IMZICOND-LABEL: select_add_3:
; RV32IMZICOND:       # %bb.0: # %entry
; RV32IMZICOND-NEXT:    li a2, 42
; RV32IMZICOND-NEXT:    czero.nez a0, a2, a0
; RV32IMZICOND-NEXT:    add a0, a1, a0
; RV32IMZICOND-NEXT:    ret
;
; RV64IMZICOND-LABEL: select_add_3:
; RV64IMZICOND:       # %bb.0: # %entry
; RV64IMZICOND-NEXT:    li a2, 42
; RV64IMZICOND-NEXT:    czero.nez a0, a2, a0
; RV64IMZICOND-NEXT:    addw a0, a1, a0
; RV64IMZICOND-NEXT:    ret
entry:
  %c = add i32 %a, 42
  %res = select i1 %cond, i32 %a, i32 %c
  ret i32 %res
}

define i32 @select_sub_1(i1 zeroext %cond, i32 %a, i32 %b) {
; RV32IM-LABEL: select_sub_1:
; RV32IM:       # %bb.0: # %entry
; RV32IM-NEXT:    beqz a0, .LBB19_2
; RV32IM-NEXT:  # %bb.1:
; RV32IM-NEXT:    sub a2, a1, a2
; RV32IM-NEXT:  .LBB19_2: # %entry
; RV32IM-NEXT:    mv a0, a2
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_sub_1:
; RV64IM:       # %bb.0: # %entry
; RV64IM-NEXT:    beqz a0, .LBB19_2
; RV64IM-NEXT:  # %bb.1:
; RV64IM-NEXT:    subw a2, a1, a2
; RV64IM-NEXT:  .LBB19_2: # %entry
; RV64IM-NEXT:    mv a0, a2
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_sub_1:
; RV64IMXVTCONDOPS:       # %bb.0: # %entry
; RV64IMXVTCONDOPS-NEXT:    subw a1, a1, a2
; RV64IMXVTCONDOPS-NEXT:    vt.maskcn a2, a2, a0
; RV64IMXVTCONDOPS-NEXT:    vt.maskc a0, a1, a0
; RV64IMXVTCONDOPS-NEXT:    or a0, a0, a2
; RV64IMXVTCONDOPS-NEXT:    ret
;
; RV32IMZICOND-LABEL: select_sub_1:
; RV32IMZICOND:       # %bb.0: # %entry
; RV32IMZICOND-NEXT:    sub a1, a1, a2
; RV32IMZICOND-NEXT:    czero.nez a2, a2, a0
; RV32IMZICOND-NEXT:    czero.eqz a0, a1, a0
; RV32IMZICOND-NEXT:    or a0, a0, a2
; RV32IMZICOND-NEXT:    ret
;
; RV64IMZICOND-LABEL: select_sub_1:
; RV64IMZICOND:       # %bb.0: # %entry
; RV64IMZICOND-NEXT:    subw a1, a1, a2
; RV64IMZICOND-NEXT:    czero.nez a2, a2, a0
; RV64IMZICOND-NEXT:    czero.eqz a0, a1, a0
; RV64IMZICOND-NEXT:    or a0, a0, a2
; RV64IMZICOND-NEXT:    ret
entry:
  %c = sub i32 %a, %b
  %res = select i1 %cond, i32 %c, i32 %b
  ret i32 %res
}

define i32 @select_sub_2(i1 zeroext %cond, i32 %a, i32 %b) {
; RV32IM-LABEL: select_sub_2:
; RV32IM:       # %bb.0: # %entry
; RV32IM-NEXT:    addi a0, a0, -1
; RV32IM-NEXT:    and a0, a0, a2
; RV32IM-NEXT:    sub a0, a1, a0
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_sub_2:
; RV64IM:       # %bb.0: # %entry
; RV64IM-NEXT:    addi a0, a0, -1
; RV64IM-NEXT:    and a0, a0, a2
; RV64IM-NEXT:    subw a0, a1, a0
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_sub_2:
; RV64IMXVTCONDOPS:       # %bb.0: # %entry
; RV64IMXVTCONDOPS-NEXT:    vt.maskcn a0, a2, a0
; RV64IMXVTCONDOPS-NEXT:    subw a0, a1, a0
; RV64IMXVTCONDOPS-NEXT:    ret
;
; RV32IMZICOND-LABEL: select_sub_2:
; RV32IMZICOND:       # %bb.0: # %entry
; RV32IMZICOND-NEXT:    czero.nez a0, a2, a0
; RV32IMZICOND-NEXT:    sub a0, a1, a0
; RV32IMZICOND-NEXT:    ret
;
; RV64IMZICOND-LABEL: select_sub_2:
; RV64IMZICOND:       # %bb.0: # %entry
; RV64IMZICOND-NEXT:    czero.nez a0, a2, a0
; RV64IMZICOND-NEXT:    subw a0, a1, a0
; RV64IMZICOND-NEXT:    ret
entry:
  %c = sub i32 %a, %b
  %res = select i1 %cond, i32 %a, i32 %c
  ret i32 %res
}

define i32 @select_sub_3(i1 zeroext %cond, i32 %a) {
; RV32IM-LABEL: select_sub_3:
; RV32IM:       # %bb.0: # %entry
; RV32IM-NEXT:    addi a0, a0, -1
; RV32IM-NEXT:    andi a0, a0, 42
; RV32IM-NEXT:    sub a0, a1, a0
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_sub_3:
; RV64IM:       # %bb.0: # %entry
; RV64IM-NEXT:    addi a0, a0, -1
; RV64IM-NEXT:    andi a0, a0, 42
; RV64IM-NEXT:    subw a0, a1, a0
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_sub_3:
; RV64IMXVTCONDOPS:       # %bb.0: # %entry
; RV64IMXVTCONDOPS-NEXT:    li a2, 42
; RV64IMXVTCONDOPS-NEXT:    vt.maskcn a0, a2, a0
; RV64IMXVTCONDOPS-NEXT:    subw a0, a1, a0
; RV64IMXVTCONDOPS-NEXT:    ret
;
; RV32IMZICOND-LABEL: select_sub_3:
; RV32IMZICOND:       # %bb.0: # %entry
; RV32IMZICOND-NEXT:    li a2, 42
; RV32IMZICOND-NEXT:    czero.nez a0, a2, a0
; RV32IMZICOND-NEXT:    sub a0, a1, a0
; RV32IMZICOND-NEXT:    ret
;
; RV64IMZICOND-LABEL: select_sub_3:
; RV64IMZICOND:       # %bb.0: # %entry
; RV64IMZICOND-NEXT:    li a2, 42
; RV64IMZICOND-NEXT:    czero.nez a0, a2, a0
; RV64IMZICOND-NEXT:    subw a0, a1, a0
; RV64IMZICOND-NEXT:    ret
entry:
  %c = sub i32 %a, 42
  %res = select i1 %cond, i32 %a, i32 %c
  ret i32 %res
}

define i32 @select_and_1(i1 zeroext %cond, i32 %a, i32 %b) {
; RV32IM-LABEL: select_and_1:
; RV32IM:       # %bb.0: # %entry
; RV32IM-NEXT:    beqz a0, .LBB22_2
; RV32IM-NEXT:  # %bb.1:
; RV32IM-NEXT:    and a2, a1, a2
; RV32IM-NEXT:  .LBB22_2: # %entry
; RV32IM-NEXT:    mv a0, a2
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_and_1:
; RV64IM:       # %bb.0: # %entry
; RV64IM-NEXT:    beqz a0, .LBB22_2
; RV64IM-NEXT:  # %bb.1:
; RV64IM-NEXT:    and a2, a1, a2
; RV64IM-NEXT:  .LBB22_2: # %entry
; RV64IM-NEXT:    mv a0, a2
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_and_1:
; RV64IMXVTCONDOPS:       # %bb.0: # %entry
; RV64IMXVTCONDOPS-NEXT:    and a1, a1, a2
; RV64IMXVTCONDOPS-NEXT:    vt.maskcn a0, a2, a0
; RV64IMXVTCONDOPS-NEXT:    or a0, a1, a0
; RV64IMXVTCONDOPS-NEXT:    ret
;
; CHECKZICOND-LABEL: select_and_1:
; CHECKZICOND:       # %bb.0: # %entry
; CHECKZICOND-NEXT:    and a1, a1, a2
; CHECKZICOND-NEXT:    czero.nez a0, a2, a0
; CHECKZICOND-NEXT:    or a0, a1, a0
; CHECKZICOND-NEXT:    ret
entry:
  %c = and i32 %a, %b
  %res = select i1 %cond, i32 %c, i32 %b
  ret i32 %res
}

define i32 @select_and_2(i1 zeroext %cond, i32 %a, i32 %b) {
; RV32IM-LABEL: select_and_2:
; RV32IM:       # %bb.0: # %entry
; RV32IM-NEXT:    bnez a0, .LBB23_2
; RV32IM-NEXT:  # %bb.1: # %entry
; RV32IM-NEXT:    and a1, a1, a2
; RV32IM-NEXT:  .LBB23_2: # %entry
; RV32IM-NEXT:    mv a0, a1
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_and_2:
; RV64IM:       # %bb.0: # %entry
; RV64IM-NEXT:    bnez a0, .LBB23_2
; RV64IM-NEXT:  # %bb.1: # %entry
; RV64IM-NEXT:    and a1, a1, a2
; RV64IM-NEXT:  .LBB23_2: # %entry
; RV64IM-NEXT:    mv a0, a1
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_and_2:
; RV64IMXVTCONDOPS:       # %bb.0: # %entry
; RV64IMXVTCONDOPS-NEXT:    and a2, a1, a2
; RV64IMXVTCONDOPS-NEXT:    vt.maskc a0, a1, a0
; RV64IMXVTCONDOPS-NEXT:    or a0, a2, a0
; RV64IMXVTCONDOPS-NEXT:    ret
;
; CHECKZICOND-LABEL: select_and_2:
; CHECKZICOND:       # %bb.0: # %entry
; CHECKZICOND-NEXT:    and a2, a1, a2
; CHECKZICOND-NEXT:    czero.eqz a0, a1, a0
; CHECKZICOND-NEXT:    or a0, a2, a0
; CHECKZICOND-NEXT:    ret
entry:
  %c = and i32 %a, %b
  %res = select i1 %cond, i32 %a, i32 %c
  ret i32 %res
}

define i32 @select_and_3(i1 zeroext %cond, i32 %a) {
; RV32IM-LABEL: select_and_3:
; RV32IM:       # %bb.0: # %entry
; RV32IM-NEXT:    bnez a0, .LBB24_2
; RV32IM-NEXT:  # %bb.1: # %entry
; RV32IM-NEXT:    andi a1, a1, 42
; RV32IM-NEXT:  .LBB24_2: # %entry
; RV32IM-NEXT:    mv a0, a1
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_and_3:
; RV64IM:       # %bb.0: # %entry
; RV64IM-NEXT:    bnez a0, .LBB24_2
; RV64IM-NEXT:  # %bb.1: # %entry
; RV64IM-NEXT:    andi a1, a1, 42
; RV64IM-NEXT:  .LBB24_2: # %entry
; RV64IM-NEXT:    mv a0, a1
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_and_3:
; RV64IMXVTCONDOPS:       # %bb.0: # %entry
; RV64IMXVTCONDOPS-NEXT:    andi a2, a1, 42
; RV64IMXVTCONDOPS-NEXT:    vt.maskc a0, a1, a0
; RV64IMXVTCONDOPS-NEXT:    or a0, a2, a0
; RV64IMXVTCONDOPS-NEXT:    ret
;
; CHECKZICOND-LABEL: select_and_3:
; CHECKZICOND:       # %bb.0: # %entry
; CHECKZICOND-NEXT:    andi a2, a1, 42
; CHECKZICOND-NEXT:    czero.eqz a0, a1, a0
; CHECKZICOND-NEXT:    or a0, a2, a0
; CHECKZICOND-NEXT:    ret
entry:
  %c = and i32 %a, 42
  %res = select i1 %cond, i32 %a, i32 %c
  ret i32 %res
}

define i32 @select_udiv_1(i1 zeroext %cond, i32 %a, i32 %b) {
; RV32IM-LABEL: select_udiv_1:
; RV32IM:       # %bb.0: # %entry
; RV32IM-NEXT:    beqz a0, .LBB25_2
; RV32IM-NEXT:  # %bb.1:
; RV32IM-NEXT:    divu a2, a1, a2
; RV32IM-NEXT:  .LBB25_2: # %entry
; RV32IM-NEXT:    mv a0, a2
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_udiv_1:
; RV64IM:       # %bb.0: # %entry
; RV64IM-NEXT:    beqz a0, .LBB25_2
; RV64IM-NEXT:  # %bb.1:
; RV64IM-NEXT:    divuw a2, a1, a2
; RV64IM-NEXT:  .LBB25_2: # %entry
; RV64IM-NEXT:    mv a0, a2
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_udiv_1:
; RV64IMXVTCONDOPS:       # %bb.0: # %entry
; RV64IMXVTCONDOPS-NEXT:    divuw a1, a1, a2
; RV64IMXVTCONDOPS-NEXT:    vt.maskcn a2, a2, a0
; RV64IMXVTCONDOPS-NEXT:    vt.maskc a0, a1, a0
; RV64IMXVTCONDOPS-NEXT:    or a0, a0, a2
; RV64IMXVTCONDOPS-NEXT:    ret
;
; RV32IMZICOND-LABEL: select_udiv_1:
; RV32IMZICOND:       # %bb.0: # %entry
; RV32IMZICOND-NEXT:    divu a1, a1, a2
; RV32IMZICOND-NEXT:    czero.nez a2, a2, a0
; RV32IMZICOND-NEXT:    czero.eqz a0, a1, a0
; RV32IMZICOND-NEXT:    or a0, a0, a2
; RV32IMZICOND-NEXT:    ret
;
; RV64IMZICOND-LABEL: select_udiv_1:
; RV64IMZICOND:       # %bb.0: # %entry
; RV64IMZICOND-NEXT:    divuw a1, a1, a2
; RV64IMZICOND-NEXT:    czero.nez a2, a2, a0
; RV64IMZICOND-NEXT:    czero.eqz a0, a1, a0
; RV64IMZICOND-NEXT:    or a0, a0, a2
; RV64IMZICOND-NEXT:    ret
entry:
  %c = udiv i32 %a, %b
  %res = select i1 %cond, i32 %c, i32 %b
  ret i32 %res
}

define i32 @select_udiv_2(i1 zeroext %cond, i32 %a, i32 %b) {
; RV32IM-LABEL: select_udiv_2:
; RV32IM:       # %bb.0: # %entry
; RV32IM-NEXT:    bnez a0, .LBB26_2
; RV32IM-NEXT:  # %bb.1: # %entry
; RV32IM-NEXT:    divu a1, a1, a2
; RV32IM-NEXT:  .LBB26_2: # %entry
; RV32IM-NEXT:    mv a0, a1
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_udiv_2:
; RV64IM:       # %bb.0: # %entry
; RV64IM-NEXT:    bnez a0, .LBB26_2
; RV64IM-NEXT:  # %bb.1: # %entry
; RV64IM-NEXT:    divuw a1, a1, a2
; RV64IM-NEXT:  .LBB26_2: # %entry
; RV64IM-NEXT:    mv a0, a1
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_udiv_2:
; RV64IMXVTCONDOPS:       # %bb.0: # %entry
; RV64IMXVTCONDOPS-NEXT:    divuw a2, a1, a2
; RV64IMXVTCONDOPS-NEXT:    vt.maskc a1, a1, a0
; RV64IMXVTCONDOPS-NEXT:    vt.maskcn a0, a2, a0
; RV64IMXVTCONDOPS-NEXT:    or a0, a1, a0
; RV64IMXVTCONDOPS-NEXT:    ret
;
; RV32IMZICOND-LABEL: select_udiv_2:
; RV32IMZICOND:       # %bb.0: # %entry
; RV32IMZICOND-NEXT:    divu a2, a1, a2
; RV32IMZICOND-NEXT:    czero.eqz a1, a1, a0
; RV32IMZICOND-NEXT:    czero.nez a0, a2, a0
; RV32IMZICOND-NEXT:    or a0, a1, a0
; RV32IMZICOND-NEXT:    ret
;
; RV64IMZICOND-LABEL: select_udiv_2:
; RV64IMZICOND:       # %bb.0: # %entry
; RV64IMZICOND-NEXT:    divuw a2, a1, a2
; RV64IMZICOND-NEXT:    czero.eqz a1, a1, a0
; RV64IMZICOND-NEXT:    czero.nez a0, a2, a0
; RV64IMZICOND-NEXT:    or a0, a1, a0
; RV64IMZICOND-NEXT:    ret
entry:
  %c = udiv i32 %a, %b
  %res = select i1 %cond, i32 %a, i32 %c
  ret i32 %res
}

define i32 @select_udiv_3(i1 zeroext %cond, i32 %a) {
; RV32IM-LABEL: select_udiv_3:
; RV32IM:       # %bb.0: # %entry
; RV32IM-NEXT:    bnez a0, .LBB27_2
; RV32IM-NEXT:  # %bb.1: # %entry
; RV32IM-NEXT:    srli a1, a1, 1
; RV32IM-NEXT:    lui a0, 199729
; RV32IM-NEXT:    addi a0, a0, -975
; RV32IM-NEXT:    mulhu a1, a1, a0
; RV32IM-NEXT:    srli a1, a1, 2
; RV32IM-NEXT:  .LBB27_2: # %entry
; RV32IM-NEXT:    mv a0, a1
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_udiv_3:
; RV64IM:       # %bb.0: # %entry
; RV64IM-NEXT:    bnez a0, .LBB27_2
; RV64IM-NEXT:  # %bb.1: # %entry
; RV64IM-NEXT:    srliw a0, a1, 1
; RV64IM-NEXT:    lui a1, 199729
; RV64IM-NEXT:    addiw a1, a1, -975
; RV64IM-NEXT:    mul a1, a0, a1
; RV64IM-NEXT:    srli a1, a1, 34
; RV64IM-NEXT:  .LBB27_2: # %entry
; RV64IM-NEXT:    mv a0, a1
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_udiv_3:
; RV64IMXVTCONDOPS:       # %bb.0: # %entry
; RV64IMXVTCONDOPS-NEXT:    srliw a2, a1, 1
; RV64IMXVTCONDOPS-NEXT:    lui a3, 199729
; RV64IMXVTCONDOPS-NEXT:    addiw a3, a3, -975
; RV64IMXVTCONDOPS-NEXT:    mul a2, a2, a3
; RV64IMXVTCONDOPS-NEXT:    srli a2, a2, 34
; RV64IMXVTCONDOPS-NEXT:    vt.maskc a1, a1, a0
; RV64IMXVTCONDOPS-NEXT:    vt.maskcn a0, a2, a0
; RV64IMXVTCONDOPS-NEXT:    or a0, a1, a0
; RV64IMXVTCONDOPS-NEXT:    ret
;
; RV32IMZICOND-LABEL: select_udiv_3:
; RV32IMZICOND:       # %bb.0: # %entry
; RV32IMZICOND-NEXT:    srli a2, a1, 1
; RV32IMZICOND-NEXT:    lui a3, 199729
; RV32IMZICOND-NEXT:    addi a3, a3, -975
; RV32IMZICOND-NEXT:    mulhu a2, a2, a3
; RV32IMZICOND-NEXT:    srli a2, a2, 2
; RV32IMZICOND-NEXT:    czero.eqz a1, a1, a0
; RV32IMZICOND-NEXT:    czero.nez a0, a2, a0
; RV32IMZICOND-NEXT:    or a0, a1, a0
; RV32IMZICOND-NEXT:    ret
;
; RV64IMZICOND-LABEL: select_udiv_3:
; RV64IMZICOND:       # %bb.0: # %entry
; RV64IMZICOND-NEXT:    srliw a2, a1, 1
; RV64IMZICOND-NEXT:    lui a3, 199729
; RV64IMZICOND-NEXT:    addiw a3, a3, -975
; RV64IMZICOND-NEXT:    mul a2, a2, a3
; RV64IMZICOND-NEXT:    srli a2, a2, 34
; RV64IMZICOND-NEXT:    czero.eqz a1, a1, a0
; RV64IMZICOND-NEXT:    czero.nez a0, a2, a0
; RV64IMZICOND-NEXT:    or a0, a1, a0
; RV64IMZICOND-NEXT:    ret
entry:
  %c = udiv i32 %a, 42
  %res = select i1 %cond, i32 %a, i32 %c
  ret i32 %res
}

define i32 @select_shl_1(i1 zeroext %cond, i32 %a, i32 %b) {
; RV32IM-LABEL: select_shl_1:
; RV32IM:       # %bb.0: # %entry
; RV32IM-NEXT:    beqz a0, .LBB28_2
; RV32IM-NEXT:  # %bb.1:
; RV32IM-NEXT:    sll a2, a1, a2
; RV32IM-NEXT:  .LBB28_2: # %entry
; RV32IM-NEXT:    mv a0, a2
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_shl_1:
; RV64IM:       # %bb.0: # %entry
; RV64IM-NEXT:    beqz a0, .LBB28_2
; RV64IM-NEXT:  # %bb.1:
; RV64IM-NEXT:    sllw a2, a1, a2
; RV64IM-NEXT:  .LBB28_2: # %entry
; RV64IM-NEXT:    mv a0, a2
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_shl_1:
; RV64IMXVTCONDOPS:       # %bb.0: # %entry
; RV64IMXVTCONDOPS-NEXT:    sllw a1, a1, a2
; RV64IMXVTCONDOPS-NEXT:    vt.maskcn a2, a2, a0
; RV64IMXVTCONDOPS-NEXT:    vt.maskc a0, a1, a0
; RV64IMXVTCONDOPS-NEXT:    or a0, a0, a2
; RV64IMXVTCONDOPS-NEXT:    ret
;
; RV32IMZICOND-LABEL: select_shl_1:
; RV32IMZICOND:       # %bb.0: # %entry
; RV32IMZICOND-NEXT:    sll a1, a1, a2
; RV32IMZICOND-NEXT:    czero.nez a2, a2, a0
; RV32IMZICOND-NEXT:    czero.eqz a0, a1, a0
; RV32IMZICOND-NEXT:    or a0, a0, a2
; RV32IMZICOND-NEXT:    ret
;
; RV64IMZICOND-LABEL: select_shl_1:
; RV64IMZICOND:       # %bb.0: # %entry
; RV64IMZICOND-NEXT:    sllw a1, a1, a2
; RV64IMZICOND-NEXT:    czero.nez a2, a2, a0
; RV64IMZICOND-NEXT:    czero.eqz a0, a1, a0
; RV64IMZICOND-NEXT:    or a0, a0, a2
; RV64IMZICOND-NEXT:    ret
entry:
  %c = shl i32 %a, %b
  %res = select i1 %cond, i32 %c, i32 %b
  ret i32 %res
}

define i32 @select_shl_2(i1 zeroext %cond, i32 %a, i32 %b) {
; RV32IM-LABEL: select_shl_2:
; RV32IM:       # %bb.0: # %entry
; RV32IM-NEXT:    addi a0, a0, -1
; RV32IM-NEXT:    and a0, a0, a2
; RV32IM-NEXT:    sll a0, a1, a0
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_shl_2:
; RV64IM:       # %bb.0: # %entry
; RV64IM-NEXT:    addi a0, a0, -1
; RV64IM-NEXT:    and a0, a0, a2
; RV64IM-NEXT:    sllw a0, a1, a0
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_shl_2:
; RV64IMXVTCONDOPS:       # %bb.0: # %entry
; RV64IMXVTCONDOPS-NEXT:    vt.maskcn a0, a2, a0
; RV64IMXVTCONDOPS-NEXT:    sllw a0, a1, a0
; RV64IMXVTCONDOPS-NEXT:    ret
;
; RV32IMZICOND-LABEL: select_shl_2:
; RV32IMZICOND:       # %bb.0: # %entry
; RV32IMZICOND-NEXT:    czero.nez a0, a2, a0
; RV32IMZICOND-NEXT:    sll a0, a1, a0
; RV32IMZICOND-NEXT:    ret
;
; RV64IMZICOND-LABEL: select_shl_2:
; RV64IMZICOND:       # %bb.0: # %entry
; RV64IMZICOND-NEXT:    czero.nez a0, a2, a0
; RV64IMZICOND-NEXT:    sllw a0, a1, a0
; RV64IMZICOND-NEXT:    ret
entry:
  %c = shl i32 %a, %b
  %res = select i1 %cond, i32 %a, i32 %c
  ret i32 %res
}

define i32 @select_shl_3(i1 zeroext %cond, i32 %a) {
; CHECK-LABEL: select_shl_3:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mv a0, a1
; CHECK-NEXT:    ret
entry:
  %c = shl i32 %a, 42
  %res = select i1 %cond, i32 %a, i32 %c
  ret i32 %res
}

define i32 @select_ashr_1(i1 zeroext %cond, i32 %a, i32 %b) {
; RV32IM-LABEL: select_ashr_1:
; RV32IM:       # %bb.0: # %entry
; RV32IM-NEXT:    beqz a0, .LBB31_2
; RV32IM-NEXT:  # %bb.1:
; RV32IM-NEXT:    sra a2, a1, a2
; RV32IM-NEXT:  .LBB31_2: # %entry
; RV32IM-NEXT:    mv a0, a2
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_ashr_1:
; RV64IM:       # %bb.0: # %entry
; RV64IM-NEXT:    beqz a0, .LBB31_2
; RV64IM-NEXT:  # %bb.1:
; RV64IM-NEXT:    sraw a2, a1, a2
; RV64IM-NEXT:  .LBB31_2: # %entry
; RV64IM-NEXT:    mv a0, a2
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_ashr_1:
; RV64IMXVTCONDOPS:       # %bb.0: # %entry
; RV64IMXVTCONDOPS-NEXT:    sraw a1, a1, a2
; RV64IMXVTCONDOPS-NEXT:    vt.maskcn a2, a2, a0
; RV64IMXVTCONDOPS-NEXT:    vt.maskc a0, a1, a0
; RV64IMXVTCONDOPS-NEXT:    or a0, a0, a2
; RV64IMXVTCONDOPS-NEXT:    ret
;
; RV32IMZICOND-LABEL: select_ashr_1:
; RV32IMZICOND:       # %bb.0: # %entry
; RV32IMZICOND-NEXT:    sra a1, a1, a2
; RV32IMZICOND-NEXT:    czero.nez a2, a2, a0
; RV32IMZICOND-NEXT:    czero.eqz a0, a1, a0
; RV32IMZICOND-NEXT:    or a0, a0, a2
; RV32IMZICOND-NEXT:    ret
;
; RV64IMZICOND-LABEL: select_ashr_1:
; RV64IMZICOND:       # %bb.0: # %entry
; RV64IMZICOND-NEXT:    sraw a1, a1, a2
; RV64IMZICOND-NEXT:    czero.nez a2, a2, a0
; RV64IMZICOND-NEXT:    czero.eqz a0, a1, a0
; RV64IMZICOND-NEXT:    or a0, a0, a2
; RV64IMZICOND-NEXT:    ret
entry:
  %c = ashr i32 %a, %b
  %res = select i1 %cond, i32 %c, i32 %b
  ret i32 %res
}

define i32 @select_ashr_2(i1 zeroext %cond, i32 %a, i32 %b) {
; RV32IM-LABEL: select_ashr_2:
; RV32IM:       # %bb.0: # %entry
; RV32IM-NEXT:    addi a0, a0, -1
; RV32IM-NEXT:    and a0, a0, a2
; RV32IM-NEXT:    sra a0, a1, a0
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_ashr_2:
; RV64IM:       # %bb.0: # %entry
; RV64IM-NEXT:    addi a0, a0, -1
; RV64IM-NEXT:    and a0, a0, a2
; RV64IM-NEXT:    sraw a0, a1, a0
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_ashr_2:
; RV64IMXVTCONDOPS:       # %bb.0: # %entry
; RV64IMXVTCONDOPS-NEXT:    vt.maskcn a0, a2, a0
; RV64IMXVTCONDOPS-NEXT:    sraw a0, a1, a0
; RV64IMXVTCONDOPS-NEXT:    ret
;
; RV32IMZICOND-LABEL: select_ashr_2:
; RV32IMZICOND:       # %bb.0: # %entry
; RV32IMZICOND-NEXT:    czero.nez a0, a2, a0
; RV32IMZICOND-NEXT:    sra a0, a1, a0
; RV32IMZICOND-NEXT:    ret
;
; RV64IMZICOND-LABEL: select_ashr_2:
; RV64IMZICOND:       # %bb.0: # %entry
; RV64IMZICOND-NEXT:    czero.nez a0, a2, a0
; RV64IMZICOND-NEXT:    sraw a0, a1, a0
; RV64IMZICOND-NEXT:    ret
entry:
  %c = ashr i32 %a, %b
  %res = select i1 %cond, i32 %a, i32 %c
  ret i32 %res
}

define i32 @select_ashr_3(i1 zeroext %cond, i32 %a) {
; CHECK-LABEL: select_ashr_3:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mv a0, a1
; CHECK-NEXT:    ret
entry:
  %c = ashr i32 %a, 42
  %res = select i1 %cond, i32 %a, i32 %c
  ret i32 %res
}

define i32 @select_lshr_1(i1 zeroext %cond, i32 %a, i32 %b) {
; RV32IM-LABEL: select_lshr_1:
; RV32IM:       # %bb.0: # %entry
; RV32IM-NEXT:    beqz a0, .LBB34_2
; RV32IM-NEXT:  # %bb.1:
; RV32IM-NEXT:    srl a2, a1, a2
; RV32IM-NEXT:  .LBB34_2: # %entry
; RV32IM-NEXT:    mv a0, a2
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_lshr_1:
; RV64IM:       # %bb.0: # %entry
; RV64IM-NEXT:    beqz a0, .LBB34_2
; RV64IM-NEXT:  # %bb.1:
; RV64IM-NEXT:    srlw a2, a1, a2
; RV64IM-NEXT:  .LBB34_2: # %entry
; RV64IM-NEXT:    mv a0, a2
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_lshr_1:
; RV64IMXVTCONDOPS:       # %bb.0: # %entry
; RV64IMXVTCONDOPS-NEXT:    srlw a1, a1, a2
; RV64IMXVTCONDOPS-NEXT:    vt.maskcn a2, a2, a0
; RV64IMXVTCONDOPS-NEXT:    vt.maskc a0, a1, a0
; RV64IMXVTCONDOPS-NEXT:    or a0, a0, a2
; RV64IMXVTCONDOPS-NEXT:    ret
;
; RV32IMZICOND-LABEL: select_lshr_1:
; RV32IMZICOND:       # %bb.0: # %entry
; RV32IMZICOND-NEXT:    srl a1, a1, a2
; RV32IMZICOND-NEXT:    czero.nez a2, a2, a0
; RV32IMZICOND-NEXT:    czero.eqz a0, a1, a0
; RV32IMZICOND-NEXT:    or a0, a0, a2
; RV32IMZICOND-NEXT:    ret
;
; RV64IMZICOND-LABEL: select_lshr_1:
; RV64IMZICOND:       # %bb.0: # %entry
; RV64IMZICOND-NEXT:    srlw a1, a1, a2
; RV64IMZICOND-NEXT:    czero.nez a2, a2, a0
; RV64IMZICOND-NEXT:    czero.eqz a0, a1, a0
; RV64IMZICOND-NEXT:    or a0, a0, a2
; RV64IMZICOND-NEXT:    ret
entry:
  %c = lshr i32 %a, %b
  %res = select i1 %cond, i32 %c, i32 %b
  ret i32 %res
}

define i32 @select_lshr_2(i1 zeroext %cond, i32 %a, i32 %b) {
; RV32IM-LABEL: select_lshr_2:
; RV32IM:       # %bb.0: # %entry
; RV32IM-NEXT:    addi a0, a0, -1
; RV32IM-NEXT:    and a0, a0, a2
; RV32IM-NEXT:    srl a0, a1, a0
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_lshr_2:
; RV64IM:       # %bb.0: # %entry
; RV64IM-NEXT:    addi a0, a0, -1
; RV64IM-NEXT:    and a0, a0, a2
; RV64IM-NEXT:    srlw a0, a1, a0
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_lshr_2:
; RV64IMXVTCONDOPS:       # %bb.0: # %entry
; RV64IMXVTCONDOPS-NEXT:    vt.maskcn a0, a2, a0
; RV64IMXVTCONDOPS-NEXT:    srlw a0, a1, a0
; RV64IMXVTCONDOPS-NEXT:    ret
;
; RV32IMZICOND-LABEL: select_lshr_2:
; RV32IMZICOND:       # %bb.0: # %entry
; RV32IMZICOND-NEXT:    czero.nez a0, a2, a0
; RV32IMZICOND-NEXT:    srl a0, a1, a0
; RV32IMZICOND-NEXT:    ret
;
; RV64IMZICOND-LABEL: select_lshr_2:
; RV64IMZICOND:       # %bb.0: # %entry
; RV64IMZICOND-NEXT:    czero.nez a0, a2, a0
; RV64IMZICOND-NEXT:    srlw a0, a1, a0
; RV64IMZICOND-NEXT:    ret
entry:
  %c = lshr i32 %a, %b
  %res = select i1 %cond, i32 %a, i32 %c
  ret i32 %res
}

define i32 @select_lshr_3(i1 zeroext %cond, i32 %a) {
; CHECK-LABEL: select_lshr_3:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mv a0, a1
; CHECK-NEXT:    ret
entry:
  %c = lshr i32 %a, 42
  %res = select i1 %cond, i32 %a, i32 %c
  ret i32 %res
}

define i32 @select_cst_not1(i32 signext %a, i32 signext %b) {
; CHECK-LABEL: select_cst_not1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    slt a0, a0, a1
; CHECK-NEXT:    neg a0, a0
; CHECK-NEXT:    xori a0, a0, -6
; CHECK-NEXT:    ret
  %cond = icmp slt i32 %a, %b
  %ret = select i1 %cond, i32 5, i32 -6
  ret i32 %ret
}

define i32 @select_cst_not2(i32 signext %a) {
; CHECK-LABEL: select_cst_not2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    srai a0, a0, 31
; CHECK-NEXT:    xori a0, a0, -6
; CHECK-NEXT:    ret
  %cond = icmp slt i32 %a, 0
  %ret = select i1 %cond, i32 5, i32 -6
  ret i32 %ret
}

define i32 @select_cst_not3(i32 signext %a) {
; CHECK-LABEL: select_cst_not3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    srai a0, a0, 31
; CHECK-NEXT:    xori a0, a0, 5
; CHECK-NEXT:    ret
  %cond = icmp sgt i32 %a, -1
  %ret = select i1 %cond, i32 5, i32 -6
  ret i32 %ret
}

define i32 @select_cst_not4(i32 signext %a, i32 signext %b) {
; RV32IM-LABEL: select_cst_not4:
; RV32IM:       # %bb.0:
; RV32IM-NEXT:    slt a0, a0, a1
; RV32IM-NEXT:    lui a1, 524288
; RV32IM-NEXT:    addi a1, a1, -1
; RV32IM-NEXT:    add a0, a0, a1
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_cst_not4:
; RV64IM:       # %bb.0:
; RV64IM-NEXT:    slt a0, a0, a1
; RV64IM-NEXT:    lui a1, 524288
; RV64IM-NEXT:    neg a0, a0
; RV64IM-NEXT:    addiw a1, a1, -1
; RV64IM-NEXT:    xor a0, a0, a1
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_cst_not4:
; RV64IMXVTCONDOPS:       # %bb.0:
; RV64IMXVTCONDOPS-NEXT:    slt a0, a0, a1
; RV64IMXVTCONDOPS-NEXT:    lui a1, 524288
; RV64IMXVTCONDOPS-NEXT:    neg a0, a0
; RV64IMXVTCONDOPS-NEXT:    addiw a1, a1, -1
; RV64IMXVTCONDOPS-NEXT:    xor a0, a0, a1
; RV64IMXVTCONDOPS-NEXT:    ret
;
; RV32IMZICOND-LABEL: select_cst_not4:
; RV32IMZICOND:       # %bb.0:
; RV32IMZICOND-NEXT:    slt a0, a0, a1
; RV32IMZICOND-NEXT:    lui a1, 524288
; RV32IMZICOND-NEXT:    addi a1, a1, -1
; RV32IMZICOND-NEXT:    add a0, a0, a1
; RV32IMZICOND-NEXT:    ret
;
; RV64IMZICOND-LABEL: select_cst_not4:
; RV64IMZICOND:       # %bb.0:
; RV64IMZICOND-NEXT:    slt a0, a0, a1
; RV64IMZICOND-NEXT:    lui a1, 524288
; RV64IMZICOND-NEXT:    neg a0, a0
; RV64IMZICOND-NEXT:    addiw a1, a1, -1
; RV64IMZICOND-NEXT:    xor a0, a0, a1
; RV64IMZICOND-NEXT:    ret
  %cond = icmp slt i32 %a, %b
  %ret = select i1 %cond, i32 -2147483648, i32 2147483647
  ret i32 %ret
}

define i32 @select_cst_not5(i32 signext %a, i32 signext %b) {
; RV32IM-LABEL: select_cst_not5:
; RV32IM:       # %bb.0:
; RV32IM-NEXT:    slt a0, a0, a1
; RV32IM-NEXT:    lui a1, 16
; RV32IM-NEXT:    neg a0, a0
; RV32IM-NEXT:    addi a1, a1, -5
; RV32IM-NEXT:    xor a0, a0, a1
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_cst_not5:
; RV64IM:       # %bb.0:
; RV64IM-NEXT:    slt a0, a0, a1
; RV64IM-NEXT:    lui a1, 16
; RV64IM-NEXT:    neg a0, a0
; RV64IM-NEXT:    addiw a1, a1, -5
; RV64IM-NEXT:    xor a0, a0, a1
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_cst_not5:
; RV64IMXVTCONDOPS:       # %bb.0:
; RV64IMXVTCONDOPS-NEXT:    slt a0, a0, a1
; RV64IMXVTCONDOPS-NEXT:    lui a1, 16
; RV64IMXVTCONDOPS-NEXT:    neg a0, a0
; RV64IMXVTCONDOPS-NEXT:    addiw a1, a1, -5
; RV64IMXVTCONDOPS-NEXT:    xor a0, a0, a1
; RV64IMXVTCONDOPS-NEXT:    ret
;
; RV32IMZICOND-LABEL: select_cst_not5:
; RV32IMZICOND:       # %bb.0:
; RV32IMZICOND-NEXT:    slt a0, a0, a1
; RV32IMZICOND-NEXT:    lui a1, 16
; RV32IMZICOND-NEXT:    neg a0, a0
; RV32IMZICOND-NEXT:    addi a1, a1, -5
; RV32IMZICOND-NEXT:    xor a0, a0, a1
; RV32IMZICOND-NEXT:    ret
;
; RV64IMZICOND-LABEL: select_cst_not5:
; RV64IMZICOND:       # %bb.0:
; RV64IMZICOND-NEXT:    slt a0, a0, a1
; RV64IMZICOND-NEXT:    lui a1, 16
; RV64IMZICOND-NEXT:    neg a0, a0
; RV64IMZICOND-NEXT:    addiw a1, a1, -5
; RV64IMZICOND-NEXT:    xor a0, a0, a1
; RV64IMZICOND-NEXT:    ret
  %cond = icmp slt i32 %a, %b
  %ret = select i1 %cond, i32 -65532, i32 65531
  ret i32 %ret
}

define i32 @select_cst_unknown(i32 signext %a, i32 signext %b) {
; RV32IM-LABEL: select_cst_unknown:
; RV32IM:       # %bb.0:
; RV32IM-NEXT:    blt a0, a1, .LBB42_2
; RV32IM-NEXT:  # %bb.1:
; RV32IM-NEXT:    li a0, -7
; RV32IM-NEXT:    ret
; RV32IM-NEXT:  .LBB42_2:
; RV32IM-NEXT:    li a0, 5
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_cst_unknown:
; RV64IM:       # %bb.0:
; RV64IM-NEXT:    blt a0, a1, .LBB42_2
; RV64IM-NEXT:  # %bb.1:
; RV64IM-NEXT:    li a0, -7
; RV64IM-NEXT:    ret
; RV64IM-NEXT:  .LBB42_2:
; RV64IM-NEXT:    li a0, 5
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_cst_unknown:
; RV64IMXVTCONDOPS:       # %bb.0:
; RV64IMXVTCONDOPS-NEXT:    slt a0, a0, a1
; RV64IMXVTCONDOPS-NEXT:    li a1, -12
; RV64IMXVTCONDOPS-NEXT:    vt.maskcn a0, a1, a0
; RV64IMXVTCONDOPS-NEXT:    addi a0, a0, 5
; RV64IMXVTCONDOPS-NEXT:    ret
;
; CHECKZICOND-LABEL: select_cst_unknown:
; CHECKZICOND:       # %bb.0:
; CHECKZICOND-NEXT:    slt a0, a0, a1
; CHECKZICOND-NEXT:    li a1, -12
; CHECKZICOND-NEXT:    czero.nez a0, a1, a0
; CHECKZICOND-NEXT:    addi a0, a0, 5
; CHECKZICOND-NEXT:    ret
  %cond = icmp slt i32 %a, %b
  %ret = select i1 %cond, i32 5, i32 -7
  ret i32 %ret
}

define i32 @select_cst1(i1 zeroext %cond) {
; RV32IM-LABEL: select_cst1:
; RV32IM:       # %bb.0:
; RV32IM-NEXT:    bnez a0, .LBB43_2
; RV32IM-NEXT:  # %bb.1:
; RV32IM-NEXT:    li a0, 20
; RV32IM-NEXT:    ret
; RV32IM-NEXT:  .LBB43_2:
; RV32IM-NEXT:    li a0, 10
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_cst1:
; RV64IM:       # %bb.0:
; RV64IM-NEXT:    bnez a0, .LBB43_2
; RV64IM-NEXT:  # %bb.1:
; RV64IM-NEXT:    li a0, 20
; RV64IM-NEXT:    ret
; RV64IM-NEXT:  .LBB43_2:
; RV64IM-NEXT:    li a0, 10
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_cst1:
; RV64IMXVTCONDOPS:       # %bb.0:
; RV64IMXVTCONDOPS-NEXT:    li a1, 10
; RV64IMXVTCONDOPS-NEXT:    vt.maskcn a0, a1, a0
; RV64IMXVTCONDOPS-NEXT:    addi a0, a0, 10
; RV64IMXVTCONDOPS-NEXT:    ret
;
; CHECKZICOND-LABEL: select_cst1:
; CHECKZICOND:       # %bb.0:
; CHECKZICOND-NEXT:    li a1, 10
; CHECKZICOND-NEXT:    czero.nez a0, a1, a0
; CHECKZICOND-NEXT:    addi a0, a0, 10
; CHECKZICOND-NEXT:    ret
  %ret = select i1 %cond, i32 10, i32 20
  ret i32 %ret
}

define i32 @select_cst2(i1 zeroext %cond) {
; RV32IM-LABEL: select_cst2:
; RV32IM:       # %bb.0:
; RV32IM-NEXT:    bnez a0, .LBB44_2
; RV32IM-NEXT:  # %bb.1:
; RV32IM-NEXT:    lui a0, 5
; RV32IM-NEXT:    addi a0, a0, -480
; RV32IM-NEXT:    ret
; RV32IM-NEXT:  .LBB44_2:
; RV32IM-NEXT:    li a0, 10
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_cst2:
; RV64IM:       # %bb.0:
; RV64IM-NEXT:    bnez a0, .LBB44_2
; RV64IM-NEXT:  # %bb.1:
; RV64IM-NEXT:    lui a0, 5
; RV64IM-NEXT:    addiw a0, a0, -480
; RV64IM-NEXT:    ret
; RV64IM-NEXT:  .LBB44_2:
; RV64IM-NEXT:    li a0, 10
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_cst2:
; RV64IMXVTCONDOPS:       # %bb.0:
; RV64IMXVTCONDOPS-NEXT:    lui a1, 5
; RV64IMXVTCONDOPS-NEXT:    addiw a1, a1, -490
; RV64IMXVTCONDOPS-NEXT:    vt.maskcn a0, a1, a0
; RV64IMXVTCONDOPS-NEXT:    addi a0, a0, 10
; RV64IMXVTCONDOPS-NEXT:    ret
;
; RV32IMZICOND-LABEL: select_cst2:
; RV32IMZICOND:       # %bb.0:
; RV32IMZICOND-NEXT:    lui a1, 5
; RV32IMZICOND-NEXT:    addi a1, a1, -490
; RV32IMZICOND-NEXT:    czero.nez a0, a1, a0
; RV32IMZICOND-NEXT:    addi a0, a0, 10
; RV32IMZICOND-NEXT:    ret
;
; RV64IMZICOND-LABEL: select_cst2:
; RV64IMZICOND:       # %bb.0:
; RV64IMZICOND-NEXT:    lui a1, 5
; RV64IMZICOND-NEXT:    addiw a1, a1, -490
; RV64IMZICOND-NEXT:    czero.nez a0, a1, a0
; RV64IMZICOND-NEXT:    addi a0, a0, 10
; RV64IMZICOND-NEXT:    ret
  %ret = select i1 %cond, i32 10, i32 20000
  ret i32 %ret
}

define i32 @select_cst3(i1 zeroext %cond) {
; RV32IM-LABEL: select_cst3:
; RV32IM:       # %bb.0:
; RV32IM-NEXT:    bnez a0, .LBB45_2
; RV32IM-NEXT:  # %bb.1:
; RV32IM-NEXT:    lui a0, 5
; RV32IM-NEXT:    addi a0, a0, -480
; RV32IM-NEXT:    ret
; RV32IM-NEXT:  .LBB45_2:
; RV32IM-NEXT:    lui a0, 7
; RV32IM-NEXT:    addi a0, a0, 1328
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_cst3:
; RV64IM:       # %bb.0:
; RV64IM-NEXT:    bnez a0, .LBB45_2
; RV64IM-NEXT:  # %bb.1:
; RV64IM-NEXT:    lui a0, 5
; RV64IM-NEXT:    addiw a0, a0, -480
; RV64IM-NEXT:    ret
; RV64IM-NEXT:  .LBB45_2:
; RV64IM-NEXT:    lui a0, 7
; RV64IM-NEXT:    addiw a0, a0, 1328
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_cst3:
; RV64IMXVTCONDOPS:       # %bb.0:
; RV64IMXVTCONDOPS-NEXT:    lui a1, 1048574
; RV64IMXVTCONDOPS-NEXT:    addiw a1, a1, -1808
; RV64IMXVTCONDOPS-NEXT:    vt.maskcn a0, a1, a0
; RV64IMXVTCONDOPS-NEXT:    lui a1, 7
; RV64IMXVTCONDOPS-NEXT:    addiw a1, a1, 1328
; RV64IMXVTCONDOPS-NEXT:    add a0, a0, a1
; RV64IMXVTCONDOPS-NEXT:    ret
;
; RV32IMZICOND-LABEL: select_cst3:
; RV32IMZICOND:       # %bb.0:
; RV32IMZICOND-NEXT:    lui a1, 1048574
; RV32IMZICOND-NEXT:    addi a1, a1, -1808
; RV32IMZICOND-NEXT:    czero.nez a0, a1, a0
; RV32IMZICOND-NEXT:    lui a1, 7
; RV32IMZICOND-NEXT:    addi a1, a1, 1328
; RV32IMZICOND-NEXT:    add a0, a0, a1
; RV32IMZICOND-NEXT:    ret
;
; RV64IMZICOND-LABEL: select_cst3:
; RV64IMZICOND:       # %bb.0:
; RV64IMZICOND-NEXT:    lui a1, 1048574
; RV64IMZICOND-NEXT:    addiw a1, a1, -1808
; RV64IMZICOND-NEXT:    czero.nez a0, a1, a0
; RV64IMZICOND-NEXT:    lui a1, 7
; RV64IMZICOND-NEXT:    addiw a1, a1, 1328
; RV64IMZICOND-NEXT:    add a0, a0, a1
; RV64IMZICOND-NEXT:    ret
  %ret = select i1 %cond, i32 30000, i32 20000
  ret i32 %ret
}

define i32 @select_cst4(i1 zeroext %cond) {
; CHECK-LABEL: select_cst4:
; CHECK:       # %bb.0:
; CHECK-NEXT:    neg a0, a0
; CHECK-NEXT:    xori a0, a0, 2047
; CHECK-NEXT:    ret
  %ret = select i1 %cond, i32 -2048, i32 2047
  ret i32 %ret
}

define i32 @select_cst5(i1 zeroext %cond) {
; RV32IM-LABEL: select_cst5:
; RV32IM:       # %bb.0:
; RV32IM-NEXT:    bnez a0, .LBB47_2
; RV32IM-NEXT:  # %bb.1:
; RV32IM-NEXT:    lui a0, 1
; RV32IM-NEXT:    addi a0, a0, -2047
; RV32IM-NEXT:    ret
; RV32IM-NEXT:  .LBB47_2:
; RV32IM-NEXT:    li a0, 2047
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_cst5:
; RV64IM:       # %bb.0:
; RV64IM-NEXT:    bnez a0, .LBB47_2
; RV64IM-NEXT:  # %bb.1:
; RV64IM-NEXT:    lui a0, 1
; RV64IM-NEXT:    addiw a0, a0, -2047
; RV64IM-NEXT:    ret
; RV64IM-NEXT:  .LBB47_2:
; RV64IM-NEXT:    li a0, 2047
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_cst5:
; RV64IMXVTCONDOPS:       # %bb.0:
; RV64IMXVTCONDOPS-NEXT:    li a1, 2
; RV64IMXVTCONDOPS-NEXT:    vt.maskcn a0, a1, a0
; RV64IMXVTCONDOPS-NEXT:    addi a0, a0, 2047
; RV64IMXVTCONDOPS-NEXT:    ret
;
; CHECKZICOND-LABEL: select_cst5:
; CHECKZICOND:       # %bb.0:
; CHECKZICOND-NEXT:    li a1, 2
; CHECKZICOND-NEXT:    czero.nez a0, a1, a0
; CHECKZICOND-NEXT:    addi a0, a0, 2047
; CHECKZICOND-NEXT:    ret
  %ret = select i1 %cond, i32 2047, i32 2049
  ret i32 %ret
}

define i32 @select_cst5_invert(i1 zeroext %cond) {
; RV32IM-LABEL: select_cst5_invert:
; RV32IM:       # %bb.0:
; RV32IM-NEXT:    bnez a0, .LBB48_2
; RV32IM-NEXT:  # %bb.1:
; RV32IM-NEXT:    li a0, 2047
; RV32IM-NEXT:    ret
; RV32IM-NEXT:  .LBB48_2:
; RV32IM-NEXT:    lui a0, 1
; RV32IM-NEXT:    addi a0, a0, -2047
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_cst5_invert:
; RV64IM:       # %bb.0:
; RV64IM-NEXT:    bnez a0, .LBB48_2
; RV64IM-NEXT:  # %bb.1:
; RV64IM-NEXT:    li a0, 2047
; RV64IM-NEXT:    ret
; RV64IM-NEXT:  .LBB48_2:
; RV64IM-NEXT:    lui a0, 1
; RV64IM-NEXT:    addiw a0, a0, -2047
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_cst5_invert:
; RV64IMXVTCONDOPS:       # %bb.0:
; RV64IMXVTCONDOPS-NEXT:    li a1, 2
; RV64IMXVTCONDOPS-NEXT:    vt.maskc a0, a1, a0
; RV64IMXVTCONDOPS-NEXT:    addi a0, a0, 2047
; RV64IMXVTCONDOPS-NEXT:    ret
;
; CHECKZICOND-LABEL: select_cst5_invert:
; CHECKZICOND:       # %bb.0:
; CHECKZICOND-NEXT:    li a1, 2
; CHECKZICOND-NEXT:    czero.eqz a0, a1, a0
; CHECKZICOND-NEXT:    addi a0, a0, 2047
; CHECKZICOND-NEXT:    ret
  %ret = select i1 %cond, i32 2049, i32 2047
  ret i32 %ret
}

define i32 @select_cst_diff2(i1 zeroext %cond) {
; RV32IM-LABEL: select_cst_diff2:
; RV32IM:       # %bb.0:
; RV32IM-NEXT:    bnez a0, .LBB49_2
; RV32IM-NEXT:  # %bb.1:
; RV32IM-NEXT:    li a0, 122
; RV32IM-NEXT:    ret
; RV32IM-NEXT:  .LBB49_2:
; RV32IM-NEXT:    li a0, 120
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_cst_diff2:
; RV64IM:       # %bb.0:
; RV64IM-NEXT:    bnez a0, .LBB49_2
; RV64IM-NEXT:  # %bb.1:
; RV64IM-NEXT:    li a0, 122
; RV64IM-NEXT:    ret
; RV64IM-NEXT:  .LBB49_2:
; RV64IM-NEXT:    li a0, 120
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_cst_diff2:
; RV64IMXVTCONDOPS:       # %bb.0:
; RV64IMXVTCONDOPS-NEXT:    li a1, 2
; RV64IMXVTCONDOPS-NEXT:    vt.maskcn a0, a1, a0
; RV64IMXVTCONDOPS-NEXT:    addi a0, a0, 120
; RV64IMXVTCONDOPS-NEXT:    ret
;
; CHECKZICOND-LABEL: select_cst_diff2:
; CHECKZICOND:       # %bb.0:
; CHECKZICOND-NEXT:    li a1, 2
; CHECKZICOND-NEXT:    czero.nez a0, a1, a0
; CHECKZICOND-NEXT:    addi a0, a0, 120
; CHECKZICOND-NEXT:    ret
  %ret = select i1 %cond, i32 120, i32 122
  ret i32 %ret
}

define i32 @select_cst_diff2_invert(i1 zeroext %cond) {
; RV32IM-LABEL: select_cst_diff2_invert:
; RV32IM:       # %bb.0:
; RV32IM-NEXT:    bnez a0, .LBB50_2
; RV32IM-NEXT:  # %bb.1:
; RV32IM-NEXT:    li a0, 120
; RV32IM-NEXT:    ret
; RV32IM-NEXT:  .LBB50_2:
; RV32IM-NEXT:    li a0, 122
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_cst_diff2_invert:
; RV64IM:       # %bb.0:
; RV64IM-NEXT:    bnez a0, .LBB50_2
; RV64IM-NEXT:  # %bb.1:
; RV64IM-NEXT:    li a0, 120
; RV64IM-NEXT:    ret
; RV64IM-NEXT:  .LBB50_2:
; RV64IM-NEXT:    li a0, 122
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_cst_diff2_invert:
; RV64IMXVTCONDOPS:       # %bb.0:
; RV64IMXVTCONDOPS-NEXT:    li a1, -2
; RV64IMXVTCONDOPS-NEXT:    vt.maskcn a0, a1, a0
; RV64IMXVTCONDOPS-NEXT:    addi a0, a0, 122
; RV64IMXVTCONDOPS-NEXT:    ret
;
; CHECKZICOND-LABEL: select_cst_diff2_invert:
; CHECKZICOND:       # %bb.0:
; CHECKZICOND-NEXT:    li a1, -2
; CHECKZICOND-NEXT:    czero.nez a0, a1, a0
; CHECKZICOND-NEXT:    addi a0, a0, 122
; CHECKZICOND-NEXT:    ret
  %ret = select i1 %cond, i32 122, i32 120
  ret i32 %ret
}

define i32 @select_cst_diff4(i1 zeroext %cond) {
; RV32IM-LABEL: select_cst_diff4:
; RV32IM:       # %bb.0:
; RV32IM-NEXT:    bnez a0, .LBB51_2
; RV32IM-NEXT:  # %bb.1:
; RV32IM-NEXT:    li a0, 6
; RV32IM-NEXT:    ret
; RV32IM-NEXT:  .LBB51_2:
; RV32IM-NEXT:    li a0, 10
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_cst_diff4:
; RV64IM:       # %bb.0:
; RV64IM-NEXT:    bnez a0, .LBB51_2
; RV64IM-NEXT:  # %bb.1:
; RV64IM-NEXT:    li a0, 6
; RV64IM-NEXT:    ret
; RV64IM-NEXT:  .LBB51_2:
; RV64IM-NEXT:    li a0, 10
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_cst_diff4:
; RV64IMXVTCONDOPS:       # %bb.0:
; RV64IMXVTCONDOPS-NEXT:    li a1, -4
; RV64IMXVTCONDOPS-NEXT:    vt.maskcn a0, a1, a0
; RV64IMXVTCONDOPS-NEXT:    addi a0, a0, 10
; RV64IMXVTCONDOPS-NEXT:    ret
;
; CHECKZICOND-LABEL: select_cst_diff4:
; CHECKZICOND:       # %bb.0:
; CHECKZICOND-NEXT:    li a1, -4
; CHECKZICOND-NEXT:    czero.nez a0, a1, a0
; CHECKZICOND-NEXT:    addi a0, a0, 10
; CHECKZICOND-NEXT:    ret
  %ret = select i1 %cond, i32 10, i32 6
  ret i32 %ret
}

define i32 @select_cst_diff4_invert(i1 zeroext %cond) {
; RV32IM-LABEL: select_cst_diff4_invert:
; RV32IM:       # %bb.0:
; RV32IM-NEXT:    bnez a0, .LBB52_2
; RV32IM-NEXT:  # %bb.1:
; RV32IM-NEXT:    li a0, 10
; RV32IM-NEXT:    ret
; RV32IM-NEXT:  .LBB52_2:
; RV32IM-NEXT:    li a0, 6
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_cst_diff4_invert:
; RV64IM:       # %bb.0:
; RV64IM-NEXT:    bnez a0, .LBB52_2
; RV64IM-NEXT:  # %bb.1:
; RV64IM-NEXT:    li a0, 10
; RV64IM-NEXT:    ret
; RV64IM-NEXT:  .LBB52_2:
; RV64IM-NEXT:    li a0, 6
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_cst_diff4_invert:
; RV64IMXVTCONDOPS:       # %bb.0:
; RV64IMXVTCONDOPS-NEXT:    li a1, 4
; RV64IMXVTCONDOPS-NEXT:    vt.maskcn a0, a1, a0
; RV64IMXVTCONDOPS-NEXT:    addi a0, a0, 6
; RV64IMXVTCONDOPS-NEXT:    ret
;
; CHECKZICOND-LABEL: select_cst_diff4_invert:
; CHECKZICOND:       # %bb.0:
; CHECKZICOND-NEXT:    li a1, 4
; CHECKZICOND-NEXT:    czero.nez a0, a1, a0
; CHECKZICOND-NEXT:    addi a0, a0, 6
; CHECKZICOND-NEXT:    ret
  %ret = select i1 %cond, i32 6, i32 10
  ret i32 %ret
}

define i32 @select_cst_diff8(i1 zeroext %cond) {
; RV32IM-LABEL: select_cst_diff8:
; RV32IM:       # %bb.0:
; RV32IM-NEXT:    bnez a0, .LBB53_2
; RV32IM-NEXT:  # %bb.1:
; RV32IM-NEXT:    li a0, 6
; RV32IM-NEXT:    ret
; RV32IM-NEXT:  .LBB53_2:
; RV32IM-NEXT:    li a0, 14
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_cst_diff8:
; RV64IM:       # %bb.0:
; RV64IM-NEXT:    bnez a0, .LBB53_2
; RV64IM-NEXT:  # %bb.1:
; RV64IM-NEXT:    li a0, 6
; RV64IM-NEXT:    ret
; RV64IM-NEXT:  .LBB53_2:
; RV64IM-NEXT:    li a0, 14
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_cst_diff8:
; RV64IMXVTCONDOPS:       # %bb.0:
; RV64IMXVTCONDOPS-NEXT:    li a1, -8
; RV64IMXVTCONDOPS-NEXT:    vt.maskcn a0, a1, a0
; RV64IMXVTCONDOPS-NEXT:    addi a0, a0, 14
; RV64IMXVTCONDOPS-NEXT:    ret
;
; CHECKZICOND-LABEL: select_cst_diff8:
; CHECKZICOND:       # %bb.0:
; CHECKZICOND-NEXT:    li a1, -8
; CHECKZICOND-NEXT:    czero.nez a0, a1, a0
; CHECKZICOND-NEXT:    addi a0, a0, 14
; CHECKZICOND-NEXT:    ret
  %ret = select i1 %cond, i32 14, i32 6
  ret i32 %ret
}

define i32 @select_cst_diff8_invert(i1 zeroext %cond) {
; RV32IM-LABEL: select_cst_diff8_invert:
; RV32IM:       # %bb.0:
; RV32IM-NEXT:    bnez a0, .LBB54_2
; RV32IM-NEXT:  # %bb.1:
; RV32IM-NEXT:    li a0, 14
; RV32IM-NEXT:    ret
; RV32IM-NEXT:  .LBB54_2:
; RV32IM-NEXT:    li a0, 6
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_cst_diff8_invert:
; RV64IM:       # %bb.0:
; RV64IM-NEXT:    bnez a0, .LBB54_2
; RV64IM-NEXT:  # %bb.1:
; RV64IM-NEXT:    li a0, 14
; RV64IM-NEXT:    ret
; RV64IM-NEXT:  .LBB54_2:
; RV64IM-NEXT:    li a0, 6
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_cst_diff8_invert:
; RV64IMXVTCONDOPS:       # %bb.0:
; RV64IMXVTCONDOPS-NEXT:    li a1, 8
; RV64IMXVTCONDOPS-NEXT:    vt.maskcn a0, a1, a0
; RV64IMXVTCONDOPS-NEXT:    addi a0, a0, 6
; RV64IMXVTCONDOPS-NEXT:    ret
;
; CHECKZICOND-LABEL: select_cst_diff8_invert:
; CHECKZICOND:       # %bb.0:
; CHECKZICOND-NEXT:    li a1, 8
; CHECKZICOND-NEXT:    czero.nez a0, a1, a0
; CHECKZICOND-NEXT:    addi a0, a0, 6
; CHECKZICOND-NEXT:    ret
  %ret = select i1 %cond, i32 6, i32 14
  ret i32 %ret
}


define i32 @select_cst_diff1024(i1 zeroext %cond) {
; RV32IM-LABEL: select_cst_diff1024:
; RV32IM:       # %bb.0:
; RV32IM-NEXT:    bnez a0, .LBB55_2
; RV32IM-NEXT:  # %bb.1:
; RV32IM-NEXT:    li a0, 6
; RV32IM-NEXT:    ret
; RV32IM-NEXT:  .LBB55_2:
; RV32IM-NEXT:    li a0, 1030
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_cst_diff1024:
; RV64IM:       # %bb.0:
; RV64IM-NEXT:    bnez a0, .LBB55_2
; RV64IM-NEXT:  # %bb.1:
; RV64IM-NEXT:    li a0, 6
; RV64IM-NEXT:    ret
; RV64IM-NEXT:  .LBB55_2:
; RV64IM-NEXT:    li a0, 1030
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_cst_diff1024:
; RV64IMXVTCONDOPS:       # %bb.0:
; RV64IMXVTCONDOPS-NEXT:    li a1, -1024
; RV64IMXVTCONDOPS-NEXT:    vt.maskcn a0, a1, a0
; RV64IMXVTCONDOPS-NEXT:    addi a0, a0, 1030
; RV64IMXVTCONDOPS-NEXT:    ret
;
; CHECKZICOND-LABEL: select_cst_diff1024:
; CHECKZICOND:       # %bb.0:
; CHECKZICOND-NEXT:    li a1, -1024
; CHECKZICOND-NEXT:    czero.nez a0, a1, a0
; CHECKZICOND-NEXT:    addi a0, a0, 1030
; CHECKZICOND-NEXT:    ret
  %ret = select i1 %cond, i32 1030, i32 6
  ret i32 %ret
}

define i32 @select_cst_diff1024_invert(i1 zeroext %cond) {
; RV32IM-LABEL: select_cst_diff1024_invert:
; RV32IM:       # %bb.0:
; RV32IM-NEXT:    bnez a0, .LBB56_2
; RV32IM-NEXT:  # %bb.1:
; RV32IM-NEXT:    li a0, 1030
; RV32IM-NEXT:    ret
; RV32IM-NEXT:  .LBB56_2:
; RV32IM-NEXT:    li a0, 6
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_cst_diff1024_invert:
; RV64IM:       # %bb.0:
; RV64IM-NEXT:    bnez a0, .LBB56_2
; RV64IM-NEXT:  # %bb.1:
; RV64IM-NEXT:    li a0, 1030
; RV64IM-NEXT:    ret
; RV64IM-NEXT:  .LBB56_2:
; RV64IM-NEXT:    li a0, 6
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_cst_diff1024_invert:
; RV64IMXVTCONDOPS:       # %bb.0:
; RV64IMXVTCONDOPS-NEXT:    li a1, 1024
; RV64IMXVTCONDOPS-NEXT:    vt.maskcn a0, a1, a0
; RV64IMXVTCONDOPS-NEXT:    addi a0, a0, 6
; RV64IMXVTCONDOPS-NEXT:    ret
;
; CHECKZICOND-LABEL: select_cst_diff1024_invert:
; CHECKZICOND:       # %bb.0:
; CHECKZICOND-NEXT:    li a1, 1024
; CHECKZICOND-NEXT:    czero.nez a0, a1, a0
; CHECKZICOND-NEXT:    addi a0, a0, 6
; CHECKZICOND-NEXT:    ret
  %ret = select i1 %cond, i32 6, i32 1030
  ret i32 %ret
}


@select_redundant_czero_eqz_data = global i32 0, align 4

define void @select_redundant_czero_eqz1(ptr %0, ptr %1) {
; RV32IM-LABEL: select_redundant_czero_eqz1:
; RV32IM:       # %bb.0: # %entry
; RV32IM-NEXT:    bnez a0, .LBB57_2
; RV32IM-NEXT:  # %bb.1:
; RV32IM-NEXT:    lui a0, %hi(select_redundant_czero_eqz_data)
; RV32IM-NEXT:    addi a0, a0, %lo(select_redundant_czero_eqz_data)
; RV32IM-NEXT:  .LBB57_2: # %entry
; RV32IM-NEXT:    sw a0, 0(a1)
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_redundant_czero_eqz1:
; RV64IM:       # %bb.0: # %entry
; RV64IM-NEXT:    bnez a0, .LBB57_2
; RV64IM-NEXT:  # %bb.1:
; RV64IM-NEXT:    lui a0, %hi(select_redundant_czero_eqz_data)
; RV64IM-NEXT:    addi a0, a0, %lo(select_redundant_czero_eqz_data)
; RV64IM-NEXT:  .LBB57_2: # %entry
; RV64IM-NEXT:    sd a0, 0(a1)
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_redundant_czero_eqz1:
; RV64IMXVTCONDOPS:       # %bb.0: # %entry
; RV64IMXVTCONDOPS-NEXT:    lui a2, %hi(select_redundant_czero_eqz_data)
; RV64IMXVTCONDOPS-NEXT:    addi a2, a2, %lo(select_redundant_czero_eqz_data)
; RV64IMXVTCONDOPS-NEXT:    vt.maskcn a2, a2, a0
; RV64IMXVTCONDOPS-NEXT:    or a0, a2, a0
; RV64IMXVTCONDOPS-NEXT:    sd a0, 0(a1)
; RV64IMXVTCONDOPS-NEXT:    ret
;
; RV32IMZICOND-LABEL: select_redundant_czero_eqz1:
; RV32IMZICOND:       # %bb.0: # %entry
; RV32IMZICOND-NEXT:    lui a2, %hi(select_redundant_czero_eqz_data)
; RV32IMZICOND-NEXT:    addi a2, a2, %lo(select_redundant_czero_eqz_data)
; RV32IMZICOND-NEXT:    czero.nez a2, a2, a0
; RV32IMZICOND-NEXT:    or a0, a2, a0
; RV32IMZICOND-NEXT:    sw a0, 0(a1)
; RV32IMZICOND-NEXT:    ret
;
; RV64IMZICOND-LABEL: select_redundant_czero_eqz1:
; RV64IMZICOND:       # %bb.0: # %entry
; RV64IMZICOND-NEXT:    lui a2, %hi(select_redundant_czero_eqz_data)
; RV64IMZICOND-NEXT:    addi a2, a2, %lo(select_redundant_czero_eqz_data)
; RV64IMZICOND-NEXT:    czero.nez a2, a2, a0
; RV64IMZICOND-NEXT:    or a0, a2, a0
; RV64IMZICOND-NEXT:    sd a0, 0(a1)
; RV64IMZICOND-NEXT:    ret
entry:
  %3 = icmp eq ptr %0, null
  %4 = select i1 %3, ptr @select_redundant_czero_eqz_data, ptr %0
  store ptr %4, ptr %1, align 8
  ret void
}

define void @select_redundant_czero_eqz2(ptr %0, ptr %1) {
; RV32IM-LABEL: select_redundant_czero_eqz2:
; RV32IM:       # %bb.0: # %entry
; RV32IM-NEXT:    bnez a0, .LBB58_2
; RV32IM-NEXT:  # %bb.1: # %entry
; RV32IM-NEXT:    lui a0, %hi(select_redundant_czero_eqz_data)
; RV32IM-NEXT:    addi a0, a0, %lo(select_redundant_czero_eqz_data)
; RV32IM-NEXT:  .LBB58_2: # %entry
; RV32IM-NEXT:    sw a0, 0(a1)
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_redundant_czero_eqz2:
; RV64IM:       # %bb.0: # %entry
; RV64IM-NEXT:    bnez a0, .LBB58_2
; RV64IM-NEXT:  # %bb.1: # %entry
; RV64IM-NEXT:    lui a0, %hi(select_redundant_czero_eqz_data)
; RV64IM-NEXT:    addi a0, a0, %lo(select_redundant_czero_eqz_data)
; RV64IM-NEXT:  .LBB58_2: # %entry
; RV64IM-NEXT:    sd a0, 0(a1)
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_redundant_czero_eqz2:
; RV64IMXVTCONDOPS:       # %bb.0: # %entry
; RV64IMXVTCONDOPS-NEXT:    lui a2, %hi(select_redundant_czero_eqz_data)
; RV64IMXVTCONDOPS-NEXT:    addi a2, a2, %lo(select_redundant_czero_eqz_data)
; RV64IMXVTCONDOPS-NEXT:    vt.maskcn a2, a2, a0
; RV64IMXVTCONDOPS-NEXT:    or a0, a0, a2
; RV64IMXVTCONDOPS-NEXT:    sd a0, 0(a1)
; RV64IMXVTCONDOPS-NEXT:    ret
;
; RV32IMZICOND-LABEL: select_redundant_czero_eqz2:
; RV32IMZICOND:       # %bb.0: # %entry
; RV32IMZICOND-NEXT:    lui a2, %hi(select_redundant_czero_eqz_data)
; RV32IMZICOND-NEXT:    addi a2, a2, %lo(select_redundant_czero_eqz_data)
; RV32IMZICOND-NEXT:    czero.nez a2, a2, a0
; RV32IMZICOND-NEXT:    or a0, a0, a2
; RV32IMZICOND-NEXT:    sw a0, 0(a1)
; RV32IMZICOND-NEXT:    ret
;
; RV64IMZICOND-LABEL: select_redundant_czero_eqz2:
; RV64IMZICOND:       # %bb.0: # %entry
; RV64IMZICOND-NEXT:    lui a2, %hi(select_redundant_czero_eqz_data)
; RV64IMZICOND-NEXT:    addi a2, a2, %lo(select_redundant_czero_eqz_data)
; RV64IMZICOND-NEXT:    czero.nez a2, a2, a0
; RV64IMZICOND-NEXT:    or a0, a0, a2
; RV64IMZICOND-NEXT:    sd a0, 0(a1)
; RV64IMZICOND-NEXT:    ret
entry:
  %3 = icmp ne ptr %0, null
  %4 = select i1 %3, ptr %0, ptr @select_redundant_czero_eqz_data
  store ptr %4, ptr %1, align 8
  ret void
}
