# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=x86_64-unknown-unknown -mcpu=znver3 -timeline -timeline-max-iterations=2 -register-file-stats -iterations=10000 < %s | FileCheck %s

# LLVM-MCA-BEGIN
xorps %xmm1, %xmm1
xorps %xmm0, %xmm1
# LLVM-MCA-END

# LLVM-MCA-BEGIN
xorpd %xmm1, %xmm1
xorpd %xmm0, %xmm1
# LLVM-MCA-END

# LLVM-MCA-BEGIN
andnps %xmm1, %xmm1
andnps %xmm0, %xmm1
# LLVM-MCA-END

# LLVM-MCA-BEGIN
andnpd %xmm1, %xmm1
andnpd %xmm0, %xmm1
# LLVM-MCA-END

# LLVM-MCA-BEGIN
pxor %xmm1, %xmm1
pxor %xmm0, %xmm1
# LLVM-MCA-END

# LLVM-MCA-BEGIN
pandn %xmm1, %xmm1
pandn %xmm0, %xmm1
# LLVM-MCA-END

# LLVM-MCA-BEGIN
psubb %xmm1, %xmm1
psubb %xmm0, %xmm1
# LLVM-MCA-END

# LLVM-MCA-BEGIN
psubw %xmm1, %xmm1
psubw %xmm0, %xmm1
# LLVM-MCA-END

# LLVM-MCA-BEGIN
psubd %xmm1, %xmm1
psubd %xmm0, %xmm1
# LLVM-MCA-END

# LLVM-MCA-BEGIN
psubq %xmm1, %xmm1
psubq %xmm0, %xmm1
# LLVM-MCA-END

# LLVM-MCA-BEGIN
psubsb %xmm1, %xmm1
pxor %xmm0, %xmm1
# LLVM-MCA-END

# LLVM-MCA-BEGIN
psubsw %xmm1, %xmm1
pxor %xmm0, %xmm1
# LLVM-MCA-END

# LLVM-MCA-BEGIN
psubusb %xmm1, %xmm1
pxor %xmm0, %xmm1
# LLVM-MCA-END

# LLVM-MCA-BEGIN
psubusw %xmm1, %xmm1
pxor %xmm0, %xmm1
# LLVM-MCA-END

# LLVM-MCA-BEGIN
pcmpgtb %xmm0, %xmm0
paddb %xmm0, %xmm0
# LLVM-MCA-END

# LLVM-MCA-BEGIN
pcmpgtw %xmm0, %xmm0
paddw %xmm0, %xmm0
# LLVM-MCA-END

# LLVM-MCA-BEGIN
pcmpgtd %xmm0, %xmm0
paddd %xmm0, %xmm0
# LLVM-MCA-END

# LLVM-MCA-BEGIN
pcmpgtq %xmm0, %xmm0
paddq %xmm0, %xmm0
# LLVM-MCA-END

# CHECK:      [0] Code Region

# CHECK:      Iterations:        10000
# CHECK-NEXT: Instructions:      20000
# CHECK-NEXT: Total Cycles:      5004
# CHECK-NEXT: Total uOps:        20000

# CHECK:      Dispatch Width:    6
# CHECK-NEXT: uOps Per Cycle:    4.00
# CHECK-NEXT: IPC:               4.00
# CHECK-NEXT: Block RThroughput: 0.5

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      1     0.25                        xorps	%xmm1, %xmm1
# CHECK-NEXT:  1      1     0.25                        xorps	%xmm0, %xmm1

# CHECK:      Register File statistics:
# CHECK-NEXT: Total number of mappings created:    10000
# CHECK-NEXT: Max number of mappings used:         37

# CHECK:      *  Register File #1 -- Zn3FpPRF:
# CHECK-NEXT:    Number of physical registers:     160
# CHECK-NEXT:    Total number of mappings created: 10000
# CHECK-NEXT:    Max number of mappings used:      37

# CHECK:      *  Register File #2 -- Zn3IntegerPRF:
# CHECK-NEXT:    Number of physical registers:     192
# CHECK-NEXT:    Total number of mappings created: 0
# CHECK-NEXT:    Max number of mappings used:      0

# CHECK:      Resources:
# CHECK-NEXT: [0]   - Zn3AGU0
# CHECK-NEXT: [1]   - Zn3AGU1
# CHECK-NEXT: [2]   - Zn3AGU2
# CHECK-NEXT: [3]   - Zn3ALU0
# CHECK-NEXT: [4]   - Zn3ALU1
# CHECK-NEXT: [5]   - Zn3ALU2
# CHECK-NEXT: [6]   - Zn3ALU3
# CHECK-NEXT: [7]   - Zn3BRU1
# CHECK-NEXT: [8]   - Zn3FP0
# CHECK-NEXT: [9]   - Zn3FP1
# CHECK-NEXT: [10]  - Zn3FP2
# CHECK-NEXT: [11]  - Zn3FP3
# CHECK-NEXT: [12.0] - Zn3FP45
# CHECK-NEXT: [12.1] - Zn3FP45
# CHECK-NEXT: [13]  - Zn3FPSt
# CHECK-NEXT: [14.0] - Zn3LSU
# CHECK-NEXT: [14.1] - Zn3LSU
# CHECK-NEXT: [14.2] - Zn3LSU
# CHECK-NEXT: [15.0] - Zn3Load
# CHECK-NEXT: [15.1] - Zn3Load
# CHECK-NEXT: [15.2] - Zn3Load
# CHECK-NEXT: [16.0] - Zn3Store
# CHECK-NEXT: [16.1] - Zn3Store

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12.0] [12.1] [13]   [14.0] [14.1] [14.2] [15.0] [15.1] [15.2] [16.0] [16.1]
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12.0] [12.1] [13]   [14.0] [14.1] [14.2] [15.0] [15.1] [15.2] [16.0] [16.1] Instructions:
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     0.50   0.25   0.25    -      -      -      -      -      -      -      -      -      -      -     xorps	%xmm1, %xmm1
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50    -     0.25   0.25    -      -      -      -      -      -      -      -      -      -      -     xorps	%xmm0, %xmm1

# CHECK:      Timeline view:
# CHECK-NEXT: Index     01234

# CHECK:      [0,0]     DeER.   xorps	%xmm1, %xmm1
# CHECK-NEXT: [0,1]     D=eER   xorps	%xmm0, %xmm1
# CHECK-NEXT: [1,0]     DeE-R   xorps	%xmm1, %xmm1
# CHECK-NEXT: [1,1]     D=eER   xorps	%xmm0, %xmm1

# CHECK:      Average Wait times (based on the timeline view):
# CHECK-NEXT: [0]: Executions
# CHECK-NEXT: [1]: Average time spent waiting in a scheduler's queue
# CHECK-NEXT: [2]: Average time spent waiting in a scheduler's queue while ready
# CHECK-NEXT: [3]: Average time elapsed from WB until retire stage

# CHECK:            [0]    [1]    [2]    [3]
# CHECK-NEXT: 0.     2     1.0    1.0    0.5       xorps	%xmm1, %xmm1
# CHECK-NEXT: 1.     2     2.0    0.0    0.0       xorps	%xmm0, %xmm1
# CHECK-NEXT:        2     1.5    0.5    0.3       <total>

# CHECK:      [1] Code Region

# CHECK:      Iterations:        10000
# CHECK-NEXT: Instructions:      20000
# CHECK-NEXT: Total Cycles:      5004
# CHECK-NEXT: Total uOps:        20000

# CHECK:      Dispatch Width:    6
# CHECK-NEXT: uOps Per Cycle:    4.00
# CHECK-NEXT: IPC:               4.00
# CHECK-NEXT: Block RThroughput: 0.5

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      1     0.25                        xorpd	%xmm1, %xmm1
# CHECK-NEXT:  1      1     0.25                        xorpd	%xmm0, %xmm1

# CHECK:      Register File statistics:
# CHECK-NEXT: Total number of mappings created:    10000
# CHECK-NEXT: Max number of mappings used:         37

# CHECK:      *  Register File #1 -- Zn3FpPRF:
# CHECK-NEXT:    Number of physical registers:     160
# CHECK-NEXT:    Total number of mappings created: 10000
# CHECK-NEXT:    Max number of mappings used:      37

# CHECK:      *  Register File #2 -- Zn3IntegerPRF:
# CHECK-NEXT:    Number of physical registers:     192
# CHECK-NEXT:    Total number of mappings created: 0
# CHECK-NEXT:    Max number of mappings used:      0

# CHECK:      Resources:
# CHECK-NEXT: [0]   - Zn3AGU0
# CHECK-NEXT: [1]   - Zn3AGU1
# CHECK-NEXT: [2]   - Zn3AGU2
# CHECK-NEXT: [3]   - Zn3ALU0
# CHECK-NEXT: [4]   - Zn3ALU1
# CHECK-NEXT: [5]   - Zn3ALU2
# CHECK-NEXT: [6]   - Zn3ALU3
# CHECK-NEXT: [7]   - Zn3BRU1
# CHECK-NEXT: [8]   - Zn3FP0
# CHECK-NEXT: [9]   - Zn3FP1
# CHECK-NEXT: [10]  - Zn3FP2
# CHECK-NEXT: [11]  - Zn3FP3
# CHECK-NEXT: [12.0] - Zn3FP45
# CHECK-NEXT: [12.1] - Zn3FP45
# CHECK-NEXT: [13]  - Zn3FPSt
# CHECK-NEXT: [14.0] - Zn3LSU
# CHECK-NEXT: [14.1] - Zn3LSU
# CHECK-NEXT: [14.2] - Zn3LSU
# CHECK-NEXT: [15.0] - Zn3Load
# CHECK-NEXT: [15.1] - Zn3Load
# CHECK-NEXT: [15.2] - Zn3Load
# CHECK-NEXT: [16.0] - Zn3Store
# CHECK-NEXT: [16.1] - Zn3Store

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12.0] [12.1] [13]   [14.0] [14.1] [14.2] [15.0] [15.1] [15.2] [16.0] [16.1]
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12.0] [12.1] [13]   [14.0] [14.1] [14.2] [15.0] [15.1] [15.2] [16.0] [16.1] Instructions:
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     0.50   0.25   0.25    -      -      -      -      -      -      -      -      -      -      -     xorpd	%xmm1, %xmm1
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50    -     0.25   0.25    -      -      -      -      -      -      -      -      -      -      -     xorpd	%xmm0, %xmm1

# CHECK:      Timeline view:
# CHECK-NEXT: Index     01234

# CHECK:      [0,0]     DeER.   xorpd	%xmm1, %xmm1
# CHECK-NEXT: [0,1]     D=eER   xorpd	%xmm0, %xmm1
# CHECK-NEXT: [1,0]     DeE-R   xorpd	%xmm1, %xmm1
# CHECK-NEXT: [1,1]     D=eER   xorpd	%xmm0, %xmm1

# CHECK:      Average Wait times (based on the timeline view):
# CHECK-NEXT: [0]: Executions
# CHECK-NEXT: [1]: Average time spent waiting in a scheduler's queue
# CHECK-NEXT: [2]: Average time spent waiting in a scheduler's queue while ready
# CHECK-NEXT: [3]: Average time elapsed from WB until retire stage

# CHECK:            [0]    [1]    [2]    [3]
# CHECK-NEXT: 0.     2     1.0    1.0    0.5       xorpd	%xmm1, %xmm1
# CHECK-NEXT: 1.     2     2.0    0.0    0.0       xorpd	%xmm0, %xmm1
# CHECK-NEXT:        2     1.5    0.5    0.3       <total>

# CHECK:      [2] Code Region

# CHECK:      Iterations:        10000
# CHECK-NEXT: Instructions:      20000
# CHECK-NEXT: Total Cycles:      5004
# CHECK-NEXT: Total uOps:        20000

# CHECK:      Dispatch Width:    6
# CHECK-NEXT: uOps Per Cycle:    4.00
# CHECK-NEXT: IPC:               4.00
# CHECK-NEXT: Block RThroughput: 0.5

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      1     0.25                        andnps	%xmm1, %xmm1
# CHECK-NEXT:  1      1     0.25                        andnps	%xmm0, %xmm1

# CHECK:      Register File statistics:
# CHECK-NEXT: Total number of mappings created:    10000
# CHECK-NEXT: Max number of mappings used:         37

# CHECK:      *  Register File #1 -- Zn3FpPRF:
# CHECK-NEXT:    Number of physical registers:     160
# CHECK-NEXT:    Total number of mappings created: 10000
# CHECK-NEXT:    Max number of mappings used:      37

# CHECK:      *  Register File #2 -- Zn3IntegerPRF:
# CHECK-NEXT:    Number of physical registers:     192
# CHECK-NEXT:    Total number of mappings created: 0
# CHECK-NEXT:    Max number of mappings used:      0

# CHECK:      Resources:
# CHECK-NEXT: [0]   - Zn3AGU0
# CHECK-NEXT: [1]   - Zn3AGU1
# CHECK-NEXT: [2]   - Zn3AGU2
# CHECK-NEXT: [3]   - Zn3ALU0
# CHECK-NEXT: [4]   - Zn3ALU1
# CHECK-NEXT: [5]   - Zn3ALU2
# CHECK-NEXT: [6]   - Zn3ALU3
# CHECK-NEXT: [7]   - Zn3BRU1
# CHECK-NEXT: [8]   - Zn3FP0
# CHECK-NEXT: [9]   - Zn3FP1
# CHECK-NEXT: [10]  - Zn3FP2
# CHECK-NEXT: [11]  - Zn3FP3
# CHECK-NEXT: [12.0] - Zn3FP45
# CHECK-NEXT: [12.1] - Zn3FP45
# CHECK-NEXT: [13]  - Zn3FPSt
# CHECK-NEXT: [14.0] - Zn3LSU
# CHECK-NEXT: [14.1] - Zn3LSU
# CHECK-NEXT: [14.2] - Zn3LSU
# CHECK-NEXT: [15.0] - Zn3Load
# CHECK-NEXT: [15.1] - Zn3Load
# CHECK-NEXT: [15.2] - Zn3Load
# CHECK-NEXT: [16.0] - Zn3Store
# CHECK-NEXT: [16.1] - Zn3Store

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12.0] [12.1] [13]   [14.0] [14.1] [14.2] [15.0] [15.1] [15.2] [16.0] [16.1]
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12.0] [12.1] [13]   [14.0] [14.1] [14.2] [15.0] [15.1] [15.2] [16.0] [16.1] Instructions:
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     0.50   0.25   0.25    -      -      -      -      -      -      -      -      -      -      -     andnps	%xmm1, %xmm1
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50    -     0.25   0.25    -      -      -      -      -      -      -      -      -      -      -     andnps	%xmm0, %xmm1

# CHECK:      Timeline view:
# CHECK-NEXT: Index     01234

# CHECK:      [0,0]     DeER.   andnps	%xmm1, %xmm1
# CHECK-NEXT: [0,1]     D=eER   andnps	%xmm0, %xmm1
# CHECK-NEXT: [1,0]     DeE-R   andnps	%xmm1, %xmm1
# CHECK-NEXT: [1,1]     D=eER   andnps	%xmm0, %xmm1

# CHECK:      Average Wait times (based on the timeline view):
# CHECK-NEXT: [0]: Executions
# CHECK-NEXT: [1]: Average time spent waiting in a scheduler's queue
# CHECK-NEXT: [2]: Average time spent waiting in a scheduler's queue while ready
# CHECK-NEXT: [3]: Average time elapsed from WB until retire stage

# CHECK:            [0]    [1]    [2]    [3]
# CHECK-NEXT: 0.     2     1.0    1.0    0.5       andnps	%xmm1, %xmm1
# CHECK-NEXT: 1.     2     2.0    0.0    0.0       andnps	%xmm0, %xmm1
# CHECK-NEXT:        2     1.5    0.5    0.3       <total>

# CHECK:      [3] Code Region

# CHECK:      Iterations:        10000
# CHECK-NEXT: Instructions:      20000
# CHECK-NEXT: Total Cycles:      5004
# CHECK-NEXT: Total uOps:        20000

# CHECK:      Dispatch Width:    6
# CHECK-NEXT: uOps Per Cycle:    4.00
# CHECK-NEXT: IPC:               4.00
# CHECK-NEXT: Block RThroughput: 0.5

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      1     0.25                        andnpd	%xmm1, %xmm1
# CHECK-NEXT:  1      1     0.25                        andnpd	%xmm0, %xmm1

# CHECK:      Register File statistics:
# CHECK-NEXT: Total number of mappings created:    10000
# CHECK-NEXT: Max number of mappings used:         37

# CHECK:      *  Register File #1 -- Zn3FpPRF:
# CHECK-NEXT:    Number of physical registers:     160
# CHECK-NEXT:    Total number of mappings created: 10000
# CHECK-NEXT:    Max number of mappings used:      37

# CHECK:      *  Register File #2 -- Zn3IntegerPRF:
# CHECK-NEXT:    Number of physical registers:     192
# CHECK-NEXT:    Total number of mappings created: 0
# CHECK-NEXT:    Max number of mappings used:      0

# CHECK:      Resources:
# CHECK-NEXT: [0]   - Zn3AGU0
# CHECK-NEXT: [1]   - Zn3AGU1
# CHECK-NEXT: [2]   - Zn3AGU2
# CHECK-NEXT: [3]   - Zn3ALU0
# CHECK-NEXT: [4]   - Zn3ALU1
# CHECK-NEXT: [5]   - Zn3ALU2
# CHECK-NEXT: [6]   - Zn3ALU3
# CHECK-NEXT: [7]   - Zn3BRU1
# CHECK-NEXT: [8]   - Zn3FP0
# CHECK-NEXT: [9]   - Zn3FP1
# CHECK-NEXT: [10]  - Zn3FP2
# CHECK-NEXT: [11]  - Zn3FP3
# CHECK-NEXT: [12.0] - Zn3FP45
# CHECK-NEXT: [12.1] - Zn3FP45
# CHECK-NEXT: [13]  - Zn3FPSt
# CHECK-NEXT: [14.0] - Zn3LSU
# CHECK-NEXT: [14.1] - Zn3LSU
# CHECK-NEXT: [14.2] - Zn3LSU
# CHECK-NEXT: [15.0] - Zn3Load
# CHECK-NEXT: [15.1] - Zn3Load
# CHECK-NEXT: [15.2] - Zn3Load
# CHECK-NEXT: [16.0] - Zn3Store
# CHECK-NEXT: [16.1] - Zn3Store

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12.0] [12.1] [13]   [14.0] [14.1] [14.2] [15.0] [15.1] [15.2] [16.0] [16.1]
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12.0] [12.1] [13]   [14.0] [14.1] [14.2] [15.0] [15.1] [15.2] [16.0] [16.1] Instructions:
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     0.50   0.25   0.25    -      -      -      -      -      -      -      -      -      -      -     andnpd	%xmm1, %xmm1
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50    -     0.25   0.25    -      -      -      -      -      -      -      -      -      -      -     andnpd	%xmm0, %xmm1

# CHECK:      Timeline view:
# CHECK-NEXT: Index     01234

# CHECK:      [0,0]     DeER.   andnpd	%xmm1, %xmm1
# CHECK-NEXT: [0,1]     D=eER   andnpd	%xmm0, %xmm1
# CHECK-NEXT: [1,0]     DeE-R   andnpd	%xmm1, %xmm1
# CHECK-NEXT: [1,1]     D=eER   andnpd	%xmm0, %xmm1

# CHECK:      Average Wait times (based on the timeline view):
# CHECK-NEXT: [0]: Executions
# CHECK-NEXT: [1]: Average time spent waiting in a scheduler's queue
# CHECK-NEXT: [2]: Average time spent waiting in a scheduler's queue while ready
# CHECK-NEXT: [3]: Average time elapsed from WB until retire stage

# CHECK:            [0]    [1]    [2]    [3]
# CHECK-NEXT: 0.     2     1.0    1.0    0.5       andnpd	%xmm1, %xmm1
# CHECK-NEXT: 1.     2     2.0    0.0    0.0       andnpd	%xmm0, %xmm1
# CHECK-NEXT:        2     1.5    0.5    0.3       <total>

# CHECK:      [4] Code Region

# CHECK:      Iterations:        10000
# CHECK-NEXT: Instructions:      20000
# CHECK-NEXT: Total Cycles:      5004
# CHECK-NEXT: Total uOps:        20000

# CHECK:      Dispatch Width:    6
# CHECK-NEXT: uOps Per Cycle:    4.00
# CHECK-NEXT: IPC:               4.00
# CHECK-NEXT: Block RThroughput: 0.5

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      1     0.25                        pxor	%xmm1, %xmm1
# CHECK-NEXT:  1      1     0.25                        pxor	%xmm0, %xmm1

# CHECK:      Register File statistics:
# CHECK-NEXT: Total number of mappings created:    10000
# CHECK-NEXT: Max number of mappings used:         37

# CHECK:      *  Register File #1 -- Zn3FpPRF:
# CHECK-NEXT:    Number of physical registers:     160
# CHECK-NEXT:    Total number of mappings created: 10000
# CHECK-NEXT:    Max number of mappings used:      37

# CHECK:      *  Register File #2 -- Zn3IntegerPRF:
# CHECK-NEXT:    Number of physical registers:     192
# CHECK-NEXT:    Total number of mappings created: 0
# CHECK-NEXT:    Max number of mappings used:      0

# CHECK:      Resources:
# CHECK-NEXT: [0]   - Zn3AGU0
# CHECK-NEXT: [1]   - Zn3AGU1
# CHECK-NEXT: [2]   - Zn3AGU2
# CHECK-NEXT: [3]   - Zn3ALU0
# CHECK-NEXT: [4]   - Zn3ALU1
# CHECK-NEXT: [5]   - Zn3ALU2
# CHECK-NEXT: [6]   - Zn3ALU3
# CHECK-NEXT: [7]   - Zn3BRU1
# CHECK-NEXT: [8]   - Zn3FP0
# CHECK-NEXT: [9]   - Zn3FP1
# CHECK-NEXT: [10]  - Zn3FP2
# CHECK-NEXT: [11]  - Zn3FP3
# CHECK-NEXT: [12.0] - Zn3FP45
# CHECK-NEXT: [12.1] - Zn3FP45
# CHECK-NEXT: [13]  - Zn3FPSt
# CHECK-NEXT: [14.0] - Zn3LSU
# CHECK-NEXT: [14.1] - Zn3LSU
# CHECK-NEXT: [14.2] - Zn3LSU
# CHECK-NEXT: [15.0] - Zn3Load
# CHECK-NEXT: [15.1] - Zn3Load
# CHECK-NEXT: [15.2] - Zn3Load
# CHECK-NEXT: [16.0] - Zn3Store
# CHECK-NEXT: [16.1] - Zn3Store

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12.0] [12.1] [13]   [14.0] [14.1] [14.2] [15.0] [15.1] [15.2] [16.0] [16.1]
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12.0] [12.1] [13]   [14.0] [14.1] [14.2] [15.0] [15.1] [15.2] [16.0] [16.1] Instructions:
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     0.50   0.25   0.25    -      -      -      -      -      -      -      -      -      -      -     pxor	%xmm1, %xmm1
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50    -     0.25   0.25    -      -      -      -      -      -      -      -      -      -      -     pxor	%xmm0, %xmm1

# CHECK:      Timeline view:
# CHECK-NEXT: Index     01234

# CHECK:      [0,0]     DeER.   pxor	%xmm1, %xmm1
# CHECK-NEXT: [0,1]     D=eER   pxor	%xmm0, %xmm1
# CHECK-NEXT: [1,0]     DeE-R   pxor	%xmm1, %xmm1
# CHECK-NEXT: [1,1]     D=eER   pxor	%xmm0, %xmm1

# CHECK:      Average Wait times (based on the timeline view):
# CHECK-NEXT: [0]: Executions
# CHECK-NEXT: [1]: Average time spent waiting in a scheduler's queue
# CHECK-NEXT: [2]: Average time spent waiting in a scheduler's queue while ready
# CHECK-NEXT: [3]: Average time elapsed from WB until retire stage

# CHECK:            [0]    [1]    [2]    [3]
# CHECK-NEXT: 0.     2     1.0    1.0    0.5       pxor	%xmm1, %xmm1
# CHECK-NEXT: 1.     2     2.0    0.0    0.0       pxor	%xmm0, %xmm1
# CHECK-NEXT:        2     1.5    0.5    0.3       <total>

# CHECK:      [5] Code Region

# CHECK:      Iterations:        10000
# CHECK-NEXT: Instructions:      20000
# CHECK-NEXT: Total Cycles:      5004
# CHECK-NEXT: Total uOps:        20000

# CHECK:      Dispatch Width:    6
# CHECK-NEXT: uOps Per Cycle:    4.00
# CHECK-NEXT: IPC:               4.00
# CHECK-NEXT: Block RThroughput: 0.5

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      1     0.25                        pandn	%xmm1, %xmm1
# CHECK-NEXT:  1      1     0.25                        pandn	%xmm0, %xmm1

# CHECK:      Register File statistics:
# CHECK-NEXT: Total number of mappings created:    10000
# CHECK-NEXT: Max number of mappings used:         37

# CHECK:      *  Register File #1 -- Zn3FpPRF:
# CHECK-NEXT:    Number of physical registers:     160
# CHECK-NEXT:    Total number of mappings created: 10000
# CHECK-NEXT:    Max number of mappings used:      37

# CHECK:      *  Register File #2 -- Zn3IntegerPRF:
# CHECK-NEXT:    Number of physical registers:     192
# CHECK-NEXT:    Total number of mappings created: 0
# CHECK-NEXT:    Max number of mappings used:      0

# CHECK:      Resources:
# CHECK-NEXT: [0]   - Zn3AGU0
# CHECK-NEXT: [1]   - Zn3AGU1
# CHECK-NEXT: [2]   - Zn3AGU2
# CHECK-NEXT: [3]   - Zn3ALU0
# CHECK-NEXT: [4]   - Zn3ALU1
# CHECK-NEXT: [5]   - Zn3ALU2
# CHECK-NEXT: [6]   - Zn3ALU3
# CHECK-NEXT: [7]   - Zn3BRU1
# CHECK-NEXT: [8]   - Zn3FP0
# CHECK-NEXT: [9]   - Zn3FP1
# CHECK-NEXT: [10]  - Zn3FP2
# CHECK-NEXT: [11]  - Zn3FP3
# CHECK-NEXT: [12.0] - Zn3FP45
# CHECK-NEXT: [12.1] - Zn3FP45
# CHECK-NEXT: [13]  - Zn3FPSt
# CHECK-NEXT: [14.0] - Zn3LSU
# CHECK-NEXT: [14.1] - Zn3LSU
# CHECK-NEXT: [14.2] - Zn3LSU
# CHECK-NEXT: [15.0] - Zn3Load
# CHECK-NEXT: [15.1] - Zn3Load
# CHECK-NEXT: [15.2] - Zn3Load
# CHECK-NEXT: [16.0] - Zn3Store
# CHECK-NEXT: [16.1] - Zn3Store

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12.0] [12.1] [13]   [14.0] [14.1] [14.2] [15.0] [15.1] [15.2] [16.0] [16.1]
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12.0] [12.1] [13]   [14.0] [14.1] [14.2] [15.0] [15.1] [15.2] [16.0] [16.1] Instructions:
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     0.50   0.25   0.25    -      -      -      -      -      -      -      -      -      -      -     pandn	%xmm1, %xmm1
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50    -     0.25   0.25    -      -      -      -      -      -      -      -      -      -      -     pandn	%xmm0, %xmm1

# CHECK:      Timeline view:
# CHECK-NEXT: Index     01234

# CHECK:      [0,0]     DeER.   pandn	%xmm1, %xmm1
# CHECK-NEXT: [0,1]     D=eER   pandn	%xmm0, %xmm1
# CHECK-NEXT: [1,0]     DeE-R   pandn	%xmm1, %xmm1
# CHECK-NEXT: [1,1]     D=eER   pandn	%xmm0, %xmm1

# CHECK:      Average Wait times (based on the timeline view):
# CHECK-NEXT: [0]: Executions
# CHECK-NEXT: [1]: Average time spent waiting in a scheduler's queue
# CHECK-NEXT: [2]: Average time spent waiting in a scheduler's queue while ready
# CHECK-NEXT: [3]: Average time elapsed from WB until retire stage

# CHECK:            [0]    [1]    [2]    [3]
# CHECK-NEXT: 0.     2     1.0    1.0    0.5       pandn	%xmm1, %xmm1
# CHECK-NEXT: 1.     2     2.0    0.0    0.0       pandn	%xmm0, %xmm1
# CHECK-NEXT:        2     1.5    0.5    0.3       <total>

# CHECK:      [6] Code Region

# CHECK:      Iterations:        10000
# CHECK-NEXT: Instructions:      20000
# CHECK-NEXT: Total Cycles:      5004
# CHECK-NEXT: Total uOps:        20000

# CHECK:      Dispatch Width:    6
# CHECK-NEXT: uOps Per Cycle:    4.00
# CHECK-NEXT: IPC:               4.00
# CHECK-NEXT: Block RThroughput: 0.5

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      1     0.25                        psubb	%xmm1, %xmm1
# CHECK-NEXT:  1      1     0.25                        psubb	%xmm0, %xmm1

# CHECK:      Register File statistics:
# CHECK-NEXT: Total number of mappings created:    10000
# CHECK-NEXT: Max number of mappings used:         37

# CHECK:      *  Register File #1 -- Zn3FpPRF:
# CHECK-NEXT:    Number of physical registers:     160
# CHECK-NEXT:    Total number of mappings created: 10000
# CHECK-NEXT:    Max number of mappings used:      37

# CHECK:      *  Register File #2 -- Zn3IntegerPRF:
# CHECK-NEXT:    Number of physical registers:     192
# CHECK-NEXT:    Total number of mappings created: 0
# CHECK-NEXT:    Max number of mappings used:      0

# CHECK:      Resources:
# CHECK-NEXT: [0]   - Zn3AGU0
# CHECK-NEXT: [1]   - Zn3AGU1
# CHECK-NEXT: [2]   - Zn3AGU2
# CHECK-NEXT: [3]   - Zn3ALU0
# CHECK-NEXT: [4]   - Zn3ALU1
# CHECK-NEXT: [5]   - Zn3ALU2
# CHECK-NEXT: [6]   - Zn3ALU3
# CHECK-NEXT: [7]   - Zn3BRU1
# CHECK-NEXT: [8]   - Zn3FP0
# CHECK-NEXT: [9]   - Zn3FP1
# CHECK-NEXT: [10]  - Zn3FP2
# CHECK-NEXT: [11]  - Zn3FP3
# CHECK-NEXT: [12.0] - Zn3FP45
# CHECK-NEXT: [12.1] - Zn3FP45
# CHECK-NEXT: [13]  - Zn3FPSt
# CHECK-NEXT: [14.0] - Zn3LSU
# CHECK-NEXT: [14.1] - Zn3LSU
# CHECK-NEXT: [14.2] - Zn3LSU
# CHECK-NEXT: [15.0] - Zn3Load
# CHECK-NEXT: [15.1] - Zn3Load
# CHECK-NEXT: [15.2] - Zn3Load
# CHECK-NEXT: [16.0] - Zn3Store
# CHECK-NEXT: [16.1] - Zn3Store

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12.0] [12.1] [13]   [14.0] [14.1] [14.2] [15.0] [15.1] [15.2] [16.0] [16.1]
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12.0] [12.1] [13]   [14.0] [14.1] [14.2] [15.0] [15.1] [15.2] [16.0] [16.1] Instructions:
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     0.50   0.25   0.25    -      -      -      -      -      -      -      -      -      -      -     psubb	%xmm1, %xmm1
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50    -     0.25   0.25    -      -      -      -      -      -      -      -      -      -      -     psubb	%xmm0, %xmm1

# CHECK:      Timeline view:
# CHECK-NEXT: Index     01234

# CHECK:      [0,0]     DeER.   psubb	%xmm1, %xmm1
# CHECK-NEXT: [0,1]     D=eER   psubb	%xmm0, %xmm1
# CHECK-NEXT: [1,0]     DeE-R   psubb	%xmm1, %xmm1
# CHECK-NEXT: [1,1]     D=eER   psubb	%xmm0, %xmm1

# CHECK:      Average Wait times (based on the timeline view):
# CHECK-NEXT: [0]: Executions
# CHECK-NEXT: [1]: Average time spent waiting in a scheduler's queue
# CHECK-NEXT: [2]: Average time spent waiting in a scheduler's queue while ready
# CHECK-NEXT: [3]: Average time elapsed from WB until retire stage

# CHECK:            [0]    [1]    [2]    [3]
# CHECK-NEXT: 0.     2     1.0    1.0    0.5       psubb	%xmm1, %xmm1
# CHECK-NEXT: 1.     2     2.0    0.0    0.0       psubb	%xmm0, %xmm1
# CHECK-NEXT:        2     1.5    0.5    0.3       <total>

# CHECK:      [7] Code Region

# CHECK:      Iterations:        10000
# CHECK-NEXT: Instructions:      20000
# CHECK-NEXT: Total Cycles:      5004
# CHECK-NEXT: Total uOps:        20000

# CHECK:      Dispatch Width:    6
# CHECK-NEXT: uOps Per Cycle:    4.00
# CHECK-NEXT: IPC:               4.00
# CHECK-NEXT: Block RThroughput: 0.5

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      1     0.25                        psubw	%xmm1, %xmm1
# CHECK-NEXT:  1      1     0.25                        psubw	%xmm0, %xmm1

# CHECK:      Register File statistics:
# CHECK-NEXT: Total number of mappings created:    10000
# CHECK-NEXT: Max number of mappings used:         37

# CHECK:      *  Register File #1 -- Zn3FpPRF:
# CHECK-NEXT:    Number of physical registers:     160
# CHECK-NEXT:    Total number of mappings created: 10000
# CHECK-NEXT:    Max number of mappings used:      37

# CHECK:      *  Register File #2 -- Zn3IntegerPRF:
# CHECK-NEXT:    Number of physical registers:     192
# CHECK-NEXT:    Total number of mappings created: 0
# CHECK-NEXT:    Max number of mappings used:      0

# CHECK:      Resources:
# CHECK-NEXT: [0]   - Zn3AGU0
# CHECK-NEXT: [1]   - Zn3AGU1
# CHECK-NEXT: [2]   - Zn3AGU2
# CHECK-NEXT: [3]   - Zn3ALU0
# CHECK-NEXT: [4]   - Zn3ALU1
# CHECK-NEXT: [5]   - Zn3ALU2
# CHECK-NEXT: [6]   - Zn3ALU3
# CHECK-NEXT: [7]   - Zn3BRU1
# CHECK-NEXT: [8]   - Zn3FP0
# CHECK-NEXT: [9]   - Zn3FP1
# CHECK-NEXT: [10]  - Zn3FP2
# CHECK-NEXT: [11]  - Zn3FP3
# CHECK-NEXT: [12.0] - Zn3FP45
# CHECK-NEXT: [12.1] - Zn3FP45
# CHECK-NEXT: [13]  - Zn3FPSt
# CHECK-NEXT: [14.0] - Zn3LSU
# CHECK-NEXT: [14.1] - Zn3LSU
# CHECK-NEXT: [14.2] - Zn3LSU
# CHECK-NEXT: [15.0] - Zn3Load
# CHECK-NEXT: [15.1] - Zn3Load
# CHECK-NEXT: [15.2] - Zn3Load
# CHECK-NEXT: [16.0] - Zn3Store
# CHECK-NEXT: [16.1] - Zn3Store

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12.0] [12.1] [13]   [14.0] [14.1] [14.2] [15.0] [15.1] [15.2] [16.0] [16.1]
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12.0] [12.1] [13]   [14.0] [14.1] [14.2] [15.0] [15.1] [15.2] [16.0] [16.1] Instructions:
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     0.50   0.25   0.25    -      -      -      -      -      -      -      -      -      -      -     psubw	%xmm1, %xmm1
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50    -     0.25   0.25    -      -      -      -      -      -      -      -      -      -      -     psubw	%xmm0, %xmm1

# CHECK:      Timeline view:
# CHECK-NEXT: Index     01234

# CHECK:      [0,0]     DeER.   psubw	%xmm1, %xmm1
# CHECK-NEXT: [0,1]     D=eER   psubw	%xmm0, %xmm1
# CHECK-NEXT: [1,0]     DeE-R   psubw	%xmm1, %xmm1
# CHECK-NEXT: [1,1]     D=eER   psubw	%xmm0, %xmm1

# CHECK:      Average Wait times (based on the timeline view):
# CHECK-NEXT: [0]: Executions
# CHECK-NEXT: [1]: Average time spent waiting in a scheduler's queue
# CHECK-NEXT: [2]: Average time spent waiting in a scheduler's queue while ready
# CHECK-NEXT: [3]: Average time elapsed from WB until retire stage

# CHECK:            [0]    [1]    [2]    [3]
# CHECK-NEXT: 0.     2     1.0    1.0    0.5       psubw	%xmm1, %xmm1
# CHECK-NEXT: 1.     2     2.0    0.0    0.0       psubw	%xmm0, %xmm1
# CHECK-NEXT:        2     1.5    0.5    0.3       <total>

# CHECK:      [8] Code Region

# CHECK:      Iterations:        10000
# CHECK-NEXT: Instructions:      20000
# CHECK-NEXT: Total Cycles:      5004
# CHECK-NEXT: Total uOps:        20000

# CHECK:      Dispatch Width:    6
# CHECK-NEXT: uOps Per Cycle:    4.00
# CHECK-NEXT: IPC:               4.00
# CHECK-NEXT: Block RThroughput: 0.5

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      1     0.25                        psubd	%xmm1, %xmm1
# CHECK-NEXT:  1      1     0.25                        psubd	%xmm0, %xmm1

# CHECK:      Register File statistics:
# CHECK-NEXT: Total number of mappings created:    10000
# CHECK-NEXT: Max number of mappings used:         37

# CHECK:      *  Register File #1 -- Zn3FpPRF:
# CHECK-NEXT:    Number of physical registers:     160
# CHECK-NEXT:    Total number of mappings created: 10000
# CHECK-NEXT:    Max number of mappings used:      37

# CHECK:      *  Register File #2 -- Zn3IntegerPRF:
# CHECK-NEXT:    Number of physical registers:     192
# CHECK-NEXT:    Total number of mappings created: 0
# CHECK-NEXT:    Max number of mappings used:      0

# CHECK:      Resources:
# CHECK-NEXT: [0]   - Zn3AGU0
# CHECK-NEXT: [1]   - Zn3AGU1
# CHECK-NEXT: [2]   - Zn3AGU2
# CHECK-NEXT: [3]   - Zn3ALU0
# CHECK-NEXT: [4]   - Zn3ALU1
# CHECK-NEXT: [5]   - Zn3ALU2
# CHECK-NEXT: [6]   - Zn3ALU3
# CHECK-NEXT: [7]   - Zn3BRU1
# CHECK-NEXT: [8]   - Zn3FP0
# CHECK-NEXT: [9]   - Zn3FP1
# CHECK-NEXT: [10]  - Zn3FP2
# CHECK-NEXT: [11]  - Zn3FP3
# CHECK-NEXT: [12.0] - Zn3FP45
# CHECK-NEXT: [12.1] - Zn3FP45
# CHECK-NEXT: [13]  - Zn3FPSt
# CHECK-NEXT: [14.0] - Zn3LSU
# CHECK-NEXT: [14.1] - Zn3LSU
# CHECK-NEXT: [14.2] - Zn3LSU
# CHECK-NEXT: [15.0] - Zn3Load
# CHECK-NEXT: [15.1] - Zn3Load
# CHECK-NEXT: [15.2] - Zn3Load
# CHECK-NEXT: [16.0] - Zn3Store
# CHECK-NEXT: [16.1] - Zn3Store

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12.0] [12.1] [13]   [14.0] [14.1] [14.2] [15.0] [15.1] [15.2] [16.0] [16.1]
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12.0] [12.1] [13]   [14.0] [14.1] [14.2] [15.0] [15.1] [15.2] [16.0] [16.1] Instructions:
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     0.50   0.25   0.25    -      -      -      -      -      -      -      -      -      -      -     psubd	%xmm1, %xmm1
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50    -     0.25   0.25    -      -      -      -      -      -      -      -      -      -      -     psubd	%xmm0, %xmm1

# CHECK:      Timeline view:
# CHECK-NEXT: Index     01234

# CHECK:      [0,0]     DeER.   psubd	%xmm1, %xmm1
# CHECK-NEXT: [0,1]     D=eER   psubd	%xmm0, %xmm1
# CHECK-NEXT: [1,0]     DeE-R   psubd	%xmm1, %xmm1
# CHECK-NEXT: [1,1]     D=eER   psubd	%xmm0, %xmm1

# CHECK:      Average Wait times (based on the timeline view):
# CHECK-NEXT: [0]: Executions
# CHECK-NEXT: [1]: Average time spent waiting in a scheduler's queue
# CHECK-NEXT: [2]: Average time spent waiting in a scheduler's queue while ready
# CHECK-NEXT: [3]: Average time elapsed from WB until retire stage

# CHECK:            [0]    [1]    [2]    [3]
# CHECK-NEXT: 0.     2     1.0    1.0    0.5       psubd	%xmm1, %xmm1
# CHECK-NEXT: 1.     2     2.0    0.0    0.0       psubd	%xmm0, %xmm1
# CHECK-NEXT:        2     1.5    0.5    0.3       <total>

# CHECK:      [9] Code Region

# CHECK:      Iterations:        10000
# CHECK-NEXT: Instructions:      20000
# CHECK-NEXT: Total Cycles:      5004
# CHECK-NEXT: Total uOps:        20000

# CHECK:      Dispatch Width:    6
# CHECK-NEXT: uOps Per Cycle:    4.00
# CHECK-NEXT: IPC:               4.00
# CHECK-NEXT: Block RThroughput: 0.5

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      1     0.25                        psubq	%xmm1, %xmm1
# CHECK-NEXT:  1      1     0.25                        psubq	%xmm0, %xmm1

# CHECK:      Register File statistics:
# CHECK-NEXT: Total number of mappings created:    10000
# CHECK-NEXT: Max number of mappings used:         37

# CHECK:      *  Register File #1 -- Zn3FpPRF:
# CHECK-NEXT:    Number of physical registers:     160
# CHECK-NEXT:    Total number of mappings created: 10000
# CHECK-NEXT:    Max number of mappings used:      37

# CHECK:      *  Register File #2 -- Zn3IntegerPRF:
# CHECK-NEXT:    Number of physical registers:     192
# CHECK-NEXT:    Total number of mappings created: 0
# CHECK-NEXT:    Max number of mappings used:      0

# CHECK:      Resources:
# CHECK-NEXT: [0]   - Zn3AGU0
# CHECK-NEXT: [1]   - Zn3AGU1
# CHECK-NEXT: [2]   - Zn3AGU2
# CHECK-NEXT: [3]   - Zn3ALU0
# CHECK-NEXT: [4]   - Zn3ALU1
# CHECK-NEXT: [5]   - Zn3ALU2
# CHECK-NEXT: [6]   - Zn3ALU3
# CHECK-NEXT: [7]   - Zn3BRU1
# CHECK-NEXT: [8]   - Zn3FP0
# CHECK-NEXT: [9]   - Zn3FP1
# CHECK-NEXT: [10]  - Zn3FP2
# CHECK-NEXT: [11]  - Zn3FP3
# CHECK-NEXT: [12.0] - Zn3FP45
# CHECK-NEXT: [12.1] - Zn3FP45
# CHECK-NEXT: [13]  - Zn3FPSt
# CHECK-NEXT: [14.0] - Zn3LSU
# CHECK-NEXT: [14.1] - Zn3LSU
# CHECK-NEXT: [14.2] - Zn3LSU
# CHECK-NEXT: [15.0] - Zn3Load
# CHECK-NEXT: [15.1] - Zn3Load
# CHECK-NEXT: [15.2] - Zn3Load
# CHECK-NEXT: [16.0] - Zn3Store
# CHECK-NEXT: [16.1] - Zn3Store

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12.0] [12.1] [13]   [14.0] [14.1] [14.2] [15.0] [15.1] [15.2] [16.0] [16.1]
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12.0] [12.1] [13]   [14.0] [14.1] [14.2] [15.0] [15.1] [15.2] [16.0] [16.1] Instructions:
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     0.50   0.25   0.25    -      -      -      -      -      -      -      -      -      -      -     psubq	%xmm1, %xmm1
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50    -     0.25   0.25    -      -      -      -      -      -      -      -      -      -      -     psubq	%xmm0, %xmm1

# CHECK:      Timeline view:
# CHECK-NEXT: Index     01234

# CHECK:      [0,0]     DeER.   psubq	%xmm1, %xmm1
# CHECK-NEXT: [0,1]     D=eER   psubq	%xmm0, %xmm1
# CHECK-NEXT: [1,0]     DeE-R   psubq	%xmm1, %xmm1
# CHECK-NEXT: [1,1]     D=eER   psubq	%xmm0, %xmm1

# CHECK:      Average Wait times (based on the timeline view):
# CHECK-NEXT: [0]: Executions
# CHECK-NEXT: [1]: Average time spent waiting in a scheduler's queue
# CHECK-NEXT: [2]: Average time spent waiting in a scheduler's queue while ready
# CHECK-NEXT: [3]: Average time elapsed from WB until retire stage

# CHECK:            [0]    [1]    [2]    [3]
# CHECK-NEXT: 0.     2     1.0    1.0    0.5       psubq	%xmm1, %xmm1
# CHECK-NEXT: 1.     2     2.0    0.0    0.0       psubq	%xmm0, %xmm1
# CHECK-NEXT:        2     1.5    0.5    0.3       <total>

# CHECK:      [10] Code Region

# CHECK:      Iterations:        10000
# CHECK-NEXT: Instructions:      20000
# CHECK-NEXT: Total Cycles:      5004
# CHECK-NEXT: Total uOps:        20000

# CHECK:      Dispatch Width:    6
# CHECK-NEXT: uOps Per Cycle:    4.00
# CHECK-NEXT: IPC:               4.00
# CHECK-NEXT: Block RThroughput: 0.5

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      1     0.50                        psubsb	%xmm1, %xmm1
# CHECK-NEXT:  1      1     0.25                        pxor	%xmm0, %xmm1

# CHECK:      Register File statistics:
# CHECK-NEXT: Total number of mappings created:    10000
# CHECK-NEXT: Max number of mappings used:         37

# CHECK:      *  Register File #1 -- Zn3FpPRF:
# CHECK-NEXT:    Number of physical registers:     160
# CHECK-NEXT:    Total number of mappings created: 10000
# CHECK-NEXT:    Max number of mappings used:      37

# CHECK:      *  Register File #2 -- Zn3IntegerPRF:
# CHECK-NEXT:    Number of physical registers:     192
# CHECK-NEXT:    Total number of mappings created: 0
# CHECK-NEXT:    Max number of mappings used:      0

# CHECK:      Resources:
# CHECK-NEXT: [0]   - Zn3AGU0
# CHECK-NEXT: [1]   - Zn3AGU1
# CHECK-NEXT: [2]   - Zn3AGU2
# CHECK-NEXT: [3]   - Zn3ALU0
# CHECK-NEXT: [4]   - Zn3ALU1
# CHECK-NEXT: [5]   - Zn3ALU2
# CHECK-NEXT: [6]   - Zn3ALU3
# CHECK-NEXT: [7]   - Zn3BRU1
# CHECK-NEXT: [8]   - Zn3FP0
# CHECK-NEXT: [9]   - Zn3FP1
# CHECK-NEXT: [10]  - Zn3FP2
# CHECK-NEXT: [11]  - Zn3FP3
# CHECK-NEXT: [12.0] - Zn3FP45
# CHECK-NEXT: [12.1] - Zn3FP45
# CHECK-NEXT: [13]  - Zn3FPSt
# CHECK-NEXT: [14.0] - Zn3LSU
# CHECK-NEXT: [14.1] - Zn3LSU
# CHECK-NEXT: [14.2] - Zn3LSU
# CHECK-NEXT: [15.0] - Zn3Load
# CHECK-NEXT: [15.1] - Zn3Load
# CHECK-NEXT: [15.2] - Zn3Load
# CHECK-NEXT: [16.0] - Zn3Store
# CHECK-NEXT: [16.1] - Zn3Store

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12.0] [12.1] [13]   [14.0] [14.1] [14.2] [15.0] [15.1] [15.2] [16.0] [16.1]
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12.0] [12.1] [13]   [14.0] [14.1] [14.2] [15.0] [15.1] [15.2] [16.0] [16.1] Instructions:
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50    -      -      -      -      -      -      -      -      -      -      -      -      -     psubsb	%xmm1, %xmm1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     pxor	%xmm0, %xmm1

# CHECK:      Timeline view:
# CHECK-NEXT: Index     01234

# CHECK:      [0,0]     DeER.   psubsb	%xmm1, %xmm1
# CHECK-NEXT: [0,1]     D=eER   pxor	%xmm0, %xmm1
# CHECK-NEXT: [1,0]     DeE-R   psubsb	%xmm1, %xmm1
# CHECK-NEXT: [1,1]     D=eER   pxor	%xmm0, %xmm1

# CHECK:      Average Wait times (based on the timeline view):
# CHECK-NEXT: [0]: Executions
# CHECK-NEXT: [1]: Average time spent waiting in a scheduler's queue
# CHECK-NEXT: [2]: Average time spent waiting in a scheduler's queue while ready
# CHECK-NEXT: [3]: Average time elapsed from WB until retire stage

# CHECK:            [0]    [1]    [2]    [3]
# CHECK-NEXT: 0.     2     1.0    1.0    0.5       psubsb	%xmm1, %xmm1
# CHECK-NEXT: 1.     2     2.0    0.0    0.0       pxor	%xmm0, %xmm1
# CHECK-NEXT:        2     1.5    0.5    0.3       <total>

# CHECK:      [11] Code Region

# CHECK:      Iterations:        10000
# CHECK-NEXT: Instructions:      20000
# CHECK-NEXT: Total Cycles:      5004
# CHECK-NEXT: Total uOps:        20000

# CHECK:      Dispatch Width:    6
# CHECK-NEXT: uOps Per Cycle:    4.00
# CHECK-NEXT: IPC:               4.00
# CHECK-NEXT: Block RThroughput: 0.5

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      1     0.50                        psubsw	%xmm1, %xmm1
# CHECK-NEXT:  1      1     0.25                        pxor	%xmm0, %xmm1

# CHECK:      Register File statistics:
# CHECK-NEXT: Total number of mappings created:    10000
# CHECK-NEXT: Max number of mappings used:         37

# CHECK:      *  Register File #1 -- Zn3FpPRF:
# CHECK-NEXT:    Number of physical registers:     160
# CHECK-NEXT:    Total number of mappings created: 10000
# CHECK-NEXT:    Max number of mappings used:      37

# CHECK:      *  Register File #2 -- Zn3IntegerPRF:
# CHECK-NEXT:    Number of physical registers:     192
# CHECK-NEXT:    Total number of mappings created: 0
# CHECK-NEXT:    Max number of mappings used:      0

# CHECK:      Resources:
# CHECK-NEXT: [0]   - Zn3AGU0
# CHECK-NEXT: [1]   - Zn3AGU1
# CHECK-NEXT: [2]   - Zn3AGU2
# CHECK-NEXT: [3]   - Zn3ALU0
# CHECK-NEXT: [4]   - Zn3ALU1
# CHECK-NEXT: [5]   - Zn3ALU2
# CHECK-NEXT: [6]   - Zn3ALU3
# CHECK-NEXT: [7]   - Zn3BRU1
# CHECK-NEXT: [8]   - Zn3FP0
# CHECK-NEXT: [9]   - Zn3FP1
# CHECK-NEXT: [10]  - Zn3FP2
# CHECK-NEXT: [11]  - Zn3FP3
# CHECK-NEXT: [12.0] - Zn3FP45
# CHECK-NEXT: [12.1] - Zn3FP45
# CHECK-NEXT: [13]  - Zn3FPSt
# CHECK-NEXT: [14.0] - Zn3LSU
# CHECK-NEXT: [14.1] - Zn3LSU
# CHECK-NEXT: [14.2] - Zn3LSU
# CHECK-NEXT: [15.0] - Zn3Load
# CHECK-NEXT: [15.1] - Zn3Load
# CHECK-NEXT: [15.2] - Zn3Load
# CHECK-NEXT: [16.0] - Zn3Store
# CHECK-NEXT: [16.1] - Zn3Store

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12.0] [12.1] [13]   [14.0] [14.1] [14.2] [15.0] [15.1] [15.2] [16.0] [16.1]
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12.0] [12.1] [13]   [14.0] [14.1] [14.2] [15.0] [15.1] [15.2] [16.0] [16.1] Instructions:
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50    -      -      -      -      -      -      -      -      -      -      -      -      -     psubsw	%xmm1, %xmm1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     pxor	%xmm0, %xmm1

# CHECK:      Timeline view:
# CHECK-NEXT: Index     01234

# CHECK:      [0,0]     DeER.   psubsw	%xmm1, %xmm1
# CHECK-NEXT: [0,1]     D=eER   pxor	%xmm0, %xmm1
# CHECK-NEXT: [1,0]     DeE-R   psubsw	%xmm1, %xmm1
# CHECK-NEXT: [1,1]     D=eER   pxor	%xmm0, %xmm1

# CHECK:      Average Wait times (based on the timeline view):
# CHECK-NEXT: [0]: Executions
# CHECK-NEXT: [1]: Average time spent waiting in a scheduler's queue
# CHECK-NEXT: [2]: Average time spent waiting in a scheduler's queue while ready
# CHECK-NEXT: [3]: Average time elapsed from WB until retire stage

# CHECK:            [0]    [1]    [2]    [3]
# CHECK-NEXT: 0.     2     1.0    1.0    0.5       psubsw	%xmm1, %xmm1
# CHECK-NEXT: 1.     2     2.0    0.0    0.0       pxor	%xmm0, %xmm1
# CHECK-NEXT:        2     1.5    0.5    0.3       <total>

# CHECK:      [12] Code Region

# CHECK:      Iterations:        10000
# CHECK-NEXT: Instructions:      20000
# CHECK-NEXT: Total Cycles:      5004
# CHECK-NEXT: Total uOps:        20000

# CHECK:      Dispatch Width:    6
# CHECK-NEXT: uOps Per Cycle:    4.00
# CHECK-NEXT: IPC:               4.00
# CHECK-NEXT: Block RThroughput: 0.5

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      1     0.50                        psubusb	%xmm1, %xmm1
# CHECK-NEXT:  1      1     0.25                        pxor	%xmm0, %xmm1

# CHECK:      Register File statistics:
# CHECK-NEXT: Total number of mappings created:    10000
# CHECK-NEXT: Max number of mappings used:         37

# CHECK:      *  Register File #1 -- Zn3FpPRF:
# CHECK-NEXT:    Number of physical registers:     160
# CHECK-NEXT:    Total number of mappings created: 10000
# CHECK-NEXT:    Max number of mappings used:      37

# CHECK:      *  Register File #2 -- Zn3IntegerPRF:
# CHECK-NEXT:    Number of physical registers:     192
# CHECK-NEXT:    Total number of mappings created: 0
# CHECK-NEXT:    Max number of mappings used:      0

# CHECK:      Resources:
# CHECK-NEXT: [0]   - Zn3AGU0
# CHECK-NEXT: [1]   - Zn3AGU1
# CHECK-NEXT: [2]   - Zn3AGU2
# CHECK-NEXT: [3]   - Zn3ALU0
# CHECK-NEXT: [4]   - Zn3ALU1
# CHECK-NEXT: [5]   - Zn3ALU2
# CHECK-NEXT: [6]   - Zn3ALU3
# CHECK-NEXT: [7]   - Zn3BRU1
# CHECK-NEXT: [8]   - Zn3FP0
# CHECK-NEXT: [9]   - Zn3FP1
# CHECK-NEXT: [10]  - Zn3FP2
# CHECK-NEXT: [11]  - Zn3FP3
# CHECK-NEXT: [12.0] - Zn3FP45
# CHECK-NEXT: [12.1] - Zn3FP45
# CHECK-NEXT: [13]  - Zn3FPSt
# CHECK-NEXT: [14.0] - Zn3LSU
# CHECK-NEXT: [14.1] - Zn3LSU
# CHECK-NEXT: [14.2] - Zn3LSU
# CHECK-NEXT: [15.0] - Zn3Load
# CHECK-NEXT: [15.1] - Zn3Load
# CHECK-NEXT: [15.2] - Zn3Load
# CHECK-NEXT: [16.0] - Zn3Store
# CHECK-NEXT: [16.1] - Zn3Store

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12.0] [12.1] [13]   [14.0] [14.1] [14.2] [15.0] [15.1] [15.2] [16.0] [16.1]
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12.0] [12.1] [13]   [14.0] [14.1] [14.2] [15.0] [15.1] [15.2] [16.0] [16.1] Instructions:
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50    -      -      -      -      -      -      -      -      -      -      -      -      -     psubusb	%xmm1, %xmm1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     pxor	%xmm0, %xmm1

# CHECK:      Timeline view:
# CHECK-NEXT: Index     01234

# CHECK:      [0,0]     DeER.   psubusb	%xmm1, %xmm1
# CHECK-NEXT: [0,1]     D=eER   pxor	%xmm0, %xmm1
# CHECK-NEXT: [1,0]     DeE-R   psubusb	%xmm1, %xmm1
# CHECK-NEXT: [1,1]     D=eER   pxor	%xmm0, %xmm1

# CHECK:      Average Wait times (based on the timeline view):
# CHECK-NEXT: [0]: Executions
# CHECK-NEXT: [1]: Average time spent waiting in a scheduler's queue
# CHECK-NEXT: [2]: Average time spent waiting in a scheduler's queue while ready
# CHECK-NEXT: [3]: Average time elapsed from WB until retire stage

# CHECK:            [0]    [1]    [2]    [3]
# CHECK-NEXT: 0.     2     1.0    1.0    0.5       psubusb	%xmm1, %xmm1
# CHECK-NEXT: 1.     2     2.0    0.0    0.0       pxor	%xmm0, %xmm1
# CHECK-NEXT:        2     1.5    0.5    0.3       <total>

# CHECK:      [13] Code Region

# CHECK:      Iterations:        10000
# CHECK-NEXT: Instructions:      20000
# CHECK-NEXT: Total Cycles:      5004
# CHECK-NEXT: Total uOps:        20000

# CHECK:      Dispatch Width:    6
# CHECK-NEXT: uOps Per Cycle:    4.00
# CHECK-NEXT: IPC:               4.00
# CHECK-NEXT: Block RThroughput: 0.5

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      1     0.50                        psubusw	%xmm1, %xmm1
# CHECK-NEXT:  1      1     0.25                        pxor	%xmm0, %xmm1

# CHECK:      Register File statistics:
# CHECK-NEXT: Total number of mappings created:    10000
# CHECK-NEXT: Max number of mappings used:         37

# CHECK:      *  Register File #1 -- Zn3FpPRF:
# CHECK-NEXT:    Number of physical registers:     160
# CHECK-NEXT:    Total number of mappings created: 10000
# CHECK-NEXT:    Max number of mappings used:      37

# CHECK:      *  Register File #2 -- Zn3IntegerPRF:
# CHECK-NEXT:    Number of physical registers:     192
# CHECK-NEXT:    Total number of mappings created: 0
# CHECK-NEXT:    Max number of mappings used:      0

# CHECK:      Resources:
# CHECK-NEXT: [0]   - Zn3AGU0
# CHECK-NEXT: [1]   - Zn3AGU1
# CHECK-NEXT: [2]   - Zn3AGU2
# CHECK-NEXT: [3]   - Zn3ALU0
# CHECK-NEXT: [4]   - Zn3ALU1
# CHECK-NEXT: [5]   - Zn3ALU2
# CHECK-NEXT: [6]   - Zn3ALU3
# CHECK-NEXT: [7]   - Zn3BRU1
# CHECK-NEXT: [8]   - Zn3FP0
# CHECK-NEXT: [9]   - Zn3FP1
# CHECK-NEXT: [10]  - Zn3FP2
# CHECK-NEXT: [11]  - Zn3FP3
# CHECK-NEXT: [12.0] - Zn3FP45
# CHECK-NEXT: [12.1] - Zn3FP45
# CHECK-NEXT: [13]  - Zn3FPSt
# CHECK-NEXT: [14.0] - Zn3LSU
# CHECK-NEXT: [14.1] - Zn3LSU
# CHECK-NEXT: [14.2] - Zn3LSU
# CHECK-NEXT: [15.0] - Zn3Load
# CHECK-NEXT: [15.1] - Zn3Load
# CHECK-NEXT: [15.2] - Zn3Load
# CHECK-NEXT: [16.0] - Zn3Store
# CHECK-NEXT: [16.1] - Zn3Store

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12.0] [12.1] [13]   [14.0] [14.1] [14.2] [15.0] [15.1] [15.2] [16.0] [16.1]
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12.0] [12.1] [13]   [14.0] [14.1] [14.2] [15.0] [15.1] [15.2] [16.0] [16.1] Instructions:
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50    -      -      -      -      -      -      -      -      -      -      -      -      -     psubusw	%xmm1, %xmm1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     pxor	%xmm0, %xmm1

# CHECK:      Timeline view:
# CHECK-NEXT: Index     01234

# CHECK:      [0,0]     DeER.   psubusw	%xmm1, %xmm1
# CHECK-NEXT: [0,1]     D=eER   pxor	%xmm0, %xmm1
# CHECK-NEXT: [1,0]     DeE-R   psubusw	%xmm1, %xmm1
# CHECK-NEXT: [1,1]     D=eER   pxor	%xmm0, %xmm1

# CHECK:      Average Wait times (based on the timeline view):
# CHECK-NEXT: [0]: Executions
# CHECK-NEXT: [1]: Average time spent waiting in a scheduler's queue
# CHECK-NEXT: [2]: Average time spent waiting in a scheduler's queue while ready
# CHECK-NEXT: [3]: Average time elapsed from WB until retire stage

# CHECK:            [0]    [1]    [2]    [3]
# CHECK-NEXT: 0.     2     1.0    1.0    0.5       psubusw	%xmm1, %xmm1
# CHECK-NEXT: 1.     2     2.0    0.0    0.0       pxor	%xmm0, %xmm1
# CHECK-NEXT:        2     1.5    0.5    0.3       <total>

# CHECK:      [14] Code Region

# CHECK:      Iterations:        10000
# CHECK-NEXT: Instructions:      20000
# CHECK-NEXT: Total Cycles:      5004
# CHECK-NEXT: Total uOps:        20000

# CHECK:      Dispatch Width:    6
# CHECK-NEXT: uOps Per Cycle:    4.00
# CHECK-NEXT: IPC:               4.00
# CHECK-NEXT: Block RThroughput: 0.5

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      1     0.25                        pcmpgtb	%xmm0, %xmm0
# CHECK-NEXT:  1      1     0.25                        paddb	%xmm0, %xmm0

# CHECK:      Register File statistics:
# CHECK-NEXT: Total number of mappings created:    10000
# CHECK-NEXT: Max number of mappings used:         37

# CHECK:      *  Register File #1 -- Zn3FpPRF:
# CHECK-NEXT:    Number of physical registers:     160
# CHECK-NEXT:    Total number of mappings created: 10000
# CHECK-NEXT:    Max number of mappings used:      37

# CHECK:      *  Register File #2 -- Zn3IntegerPRF:
# CHECK-NEXT:    Number of physical registers:     192
# CHECK-NEXT:    Total number of mappings created: 0
# CHECK-NEXT:    Max number of mappings used:      0

# CHECK:      Resources:
# CHECK-NEXT: [0]   - Zn3AGU0
# CHECK-NEXT: [1]   - Zn3AGU1
# CHECK-NEXT: [2]   - Zn3AGU2
# CHECK-NEXT: [3]   - Zn3ALU0
# CHECK-NEXT: [4]   - Zn3ALU1
# CHECK-NEXT: [5]   - Zn3ALU2
# CHECK-NEXT: [6]   - Zn3ALU3
# CHECK-NEXT: [7]   - Zn3BRU1
# CHECK-NEXT: [8]   - Zn3FP0
# CHECK-NEXT: [9]   - Zn3FP1
# CHECK-NEXT: [10]  - Zn3FP2
# CHECK-NEXT: [11]  - Zn3FP3
# CHECK-NEXT: [12.0] - Zn3FP45
# CHECK-NEXT: [12.1] - Zn3FP45
# CHECK-NEXT: [13]  - Zn3FPSt
# CHECK-NEXT: [14.0] - Zn3LSU
# CHECK-NEXT: [14.1] - Zn3LSU
# CHECK-NEXT: [14.2] - Zn3LSU
# CHECK-NEXT: [15.0] - Zn3Load
# CHECK-NEXT: [15.1] - Zn3Load
# CHECK-NEXT: [15.2] - Zn3Load
# CHECK-NEXT: [16.0] - Zn3Store
# CHECK-NEXT: [16.1] - Zn3Store

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12.0] [12.1] [13]   [14.0] [14.1] [14.2] [15.0] [15.1] [15.2] [16.0] [16.1]
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12.0] [12.1] [13]   [14.0] [14.1] [14.2] [15.0] [15.1] [15.2] [16.0] [16.1] Instructions:
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.25   0.25   0.50    -      -      -      -      -      -      -      -      -      -      -      -     pcmpgtb	%xmm0, %xmm0
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.25   0.25    -     0.50    -      -      -      -      -      -      -      -      -      -      -     paddb	%xmm0, %xmm0

# CHECK:      Timeline view:
# CHECK-NEXT: Index     01234

# CHECK:      [0,0]     DeER.   pcmpgtb	%xmm0, %xmm0
# CHECK-NEXT: [0,1]     D=eER   paddb	%xmm0, %xmm0
# CHECK-NEXT: [1,0]     DeE-R   pcmpgtb	%xmm0, %xmm0
# CHECK-NEXT: [1,1]     D=eER   paddb	%xmm0, %xmm0

# CHECK:      Average Wait times (based on the timeline view):
# CHECK-NEXT: [0]: Executions
# CHECK-NEXT: [1]: Average time spent waiting in a scheduler's queue
# CHECK-NEXT: [2]: Average time spent waiting in a scheduler's queue while ready
# CHECK-NEXT: [3]: Average time elapsed from WB until retire stage

# CHECK:            [0]    [1]    [2]    [3]
# CHECK-NEXT: 0.     2     1.0    1.0    0.5       pcmpgtb	%xmm0, %xmm0
# CHECK-NEXT: 1.     2     2.0    0.0    0.0       paddb	%xmm0, %xmm0
# CHECK-NEXT:        2     1.5    0.5    0.3       <total>

# CHECK:      [15] Code Region

# CHECK:      Iterations:        10000
# CHECK-NEXT: Instructions:      20000
# CHECK-NEXT: Total Cycles:      5004
# CHECK-NEXT: Total uOps:        20000

# CHECK:      Dispatch Width:    6
# CHECK-NEXT: uOps Per Cycle:    4.00
# CHECK-NEXT: IPC:               4.00
# CHECK-NEXT: Block RThroughput: 0.5

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      1     0.25                        pcmpgtw	%xmm0, %xmm0
# CHECK-NEXT:  1      1     0.25                        paddw	%xmm0, %xmm0

# CHECK:      Register File statistics:
# CHECK-NEXT: Total number of mappings created:    10000
# CHECK-NEXT: Max number of mappings used:         37

# CHECK:      *  Register File #1 -- Zn3FpPRF:
# CHECK-NEXT:    Number of physical registers:     160
# CHECK-NEXT:    Total number of mappings created: 10000
# CHECK-NEXT:    Max number of mappings used:      37

# CHECK:      *  Register File #2 -- Zn3IntegerPRF:
# CHECK-NEXT:    Number of physical registers:     192
# CHECK-NEXT:    Total number of mappings created: 0
# CHECK-NEXT:    Max number of mappings used:      0

# CHECK:      Resources:
# CHECK-NEXT: [0]   - Zn3AGU0
# CHECK-NEXT: [1]   - Zn3AGU1
# CHECK-NEXT: [2]   - Zn3AGU2
# CHECK-NEXT: [3]   - Zn3ALU0
# CHECK-NEXT: [4]   - Zn3ALU1
# CHECK-NEXT: [5]   - Zn3ALU2
# CHECK-NEXT: [6]   - Zn3ALU3
# CHECK-NEXT: [7]   - Zn3BRU1
# CHECK-NEXT: [8]   - Zn3FP0
# CHECK-NEXT: [9]   - Zn3FP1
# CHECK-NEXT: [10]  - Zn3FP2
# CHECK-NEXT: [11]  - Zn3FP3
# CHECK-NEXT: [12.0] - Zn3FP45
# CHECK-NEXT: [12.1] - Zn3FP45
# CHECK-NEXT: [13]  - Zn3FPSt
# CHECK-NEXT: [14.0] - Zn3LSU
# CHECK-NEXT: [14.1] - Zn3LSU
# CHECK-NEXT: [14.2] - Zn3LSU
# CHECK-NEXT: [15.0] - Zn3Load
# CHECK-NEXT: [15.1] - Zn3Load
# CHECK-NEXT: [15.2] - Zn3Load
# CHECK-NEXT: [16.0] - Zn3Store
# CHECK-NEXT: [16.1] - Zn3Store

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12.0] [12.1] [13]   [14.0] [14.1] [14.2] [15.0] [15.1] [15.2] [16.0] [16.1]
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12.0] [12.1] [13]   [14.0] [14.1] [14.2] [15.0] [15.1] [15.2] [16.0] [16.1] Instructions:
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.25   0.25   0.50    -      -      -      -      -      -      -      -      -      -      -      -     pcmpgtw	%xmm0, %xmm0
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.25   0.25    -     0.50    -      -      -      -      -      -      -      -      -      -      -     paddw	%xmm0, %xmm0

# CHECK:      Timeline view:
# CHECK-NEXT: Index     01234

# CHECK:      [0,0]     DeER.   pcmpgtw	%xmm0, %xmm0
# CHECK-NEXT: [0,1]     D=eER   paddw	%xmm0, %xmm0
# CHECK-NEXT: [1,0]     DeE-R   pcmpgtw	%xmm0, %xmm0
# CHECK-NEXT: [1,1]     D=eER   paddw	%xmm0, %xmm0

# CHECK:      Average Wait times (based on the timeline view):
# CHECK-NEXT: [0]: Executions
# CHECK-NEXT: [1]: Average time spent waiting in a scheduler's queue
# CHECK-NEXT: [2]: Average time spent waiting in a scheduler's queue while ready
# CHECK-NEXT: [3]: Average time elapsed from WB until retire stage

# CHECK:            [0]    [1]    [2]    [3]
# CHECK-NEXT: 0.     2     1.0    1.0    0.5       pcmpgtw	%xmm0, %xmm0
# CHECK-NEXT: 1.     2     2.0    0.0    0.0       paddw	%xmm0, %xmm0
# CHECK-NEXT:        2     1.5    0.5    0.3       <total>

# CHECK:      [16] Code Region

# CHECK:      Iterations:        10000
# CHECK-NEXT: Instructions:      20000
# CHECK-NEXT: Total Cycles:      5004
# CHECK-NEXT: Total uOps:        20000

# CHECK:      Dispatch Width:    6
# CHECK-NEXT: uOps Per Cycle:    4.00
# CHECK-NEXT: IPC:               4.00
# CHECK-NEXT: Block RThroughput: 0.5

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      1     0.25                        pcmpgtd	%xmm0, %xmm0
# CHECK-NEXT:  1      1     0.25                        paddd	%xmm0, %xmm0

# CHECK:      Register File statistics:
# CHECK-NEXT: Total number of mappings created:    10000
# CHECK-NEXT: Max number of mappings used:         37

# CHECK:      *  Register File #1 -- Zn3FpPRF:
# CHECK-NEXT:    Number of physical registers:     160
# CHECK-NEXT:    Total number of mappings created: 10000
# CHECK-NEXT:    Max number of mappings used:      37

# CHECK:      *  Register File #2 -- Zn3IntegerPRF:
# CHECK-NEXT:    Number of physical registers:     192
# CHECK-NEXT:    Total number of mappings created: 0
# CHECK-NEXT:    Max number of mappings used:      0

# CHECK:      Resources:
# CHECK-NEXT: [0]   - Zn3AGU0
# CHECK-NEXT: [1]   - Zn3AGU1
# CHECK-NEXT: [2]   - Zn3AGU2
# CHECK-NEXT: [3]   - Zn3ALU0
# CHECK-NEXT: [4]   - Zn3ALU1
# CHECK-NEXT: [5]   - Zn3ALU2
# CHECK-NEXT: [6]   - Zn3ALU3
# CHECK-NEXT: [7]   - Zn3BRU1
# CHECK-NEXT: [8]   - Zn3FP0
# CHECK-NEXT: [9]   - Zn3FP1
# CHECK-NEXT: [10]  - Zn3FP2
# CHECK-NEXT: [11]  - Zn3FP3
# CHECK-NEXT: [12.0] - Zn3FP45
# CHECK-NEXT: [12.1] - Zn3FP45
# CHECK-NEXT: [13]  - Zn3FPSt
# CHECK-NEXT: [14.0] - Zn3LSU
# CHECK-NEXT: [14.1] - Zn3LSU
# CHECK-NEXT: [14.2] - Zn3LSU
# CHECK-NEXT: [15.0] - Zn3Load
# CHECK-NEXT: [15.1] - Zn3Load
# CHECK-NEXT: [15.2] - Zn3Load
# CHECK-NEXT: [16.0] - Zn3Store
# CHECK-NEXT: [16.1] - Zn3Store

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12.0] [12.1] [13]   [14.0] [14.1] [14.2] [15.0] [15.1] [15.2] [16.0] [16.1]
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12.0] [12.1] [13]   [14.0] [14.1] [14.2] [15.0] [15.1] [15.2] [16.0] [16.1] Instructions:
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.25   0.25   0.50    -      -      -      -      -      -      -      -      -      -      -      -     pcmpgtd	%xmm0, %xmm0
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.25   0.25    -     0.50    -      -      -      -      -      -      -      -      -      -      -     paddd	%xmm0, %xmm0

# CHECK:      Timeline view:
# CHECK-NEXT: Index     01234

# CHECK:      [0,0]     DeER.   pcmpgtd	%xmm0, %xmm0
# CHECK-NEXT: [0,1]     D=eER   paddd	%xmm0, %xmm0
# CHECK-NEXT: [1,0]     DeE-R   pcmpgtd	%xmm0, %xmm0
# CHECK-NEXT: [1,1]     D=eER   paddd	%xmm0, %xmm0

# CHECK:      Average Wait times (based on the timeline view):
# CHECK-NEXT: [0]: Executions
# CHECK-NEXT: [1]: Average time spent waiting in a scheduler's queue
# CHECK-NEXT: [2]: Average time spent waiting in a scheduler's queue while ready
# CHECK-NEXT: [3]: Average time elapsed from WB until retire stage

# CHECK:            [0]    [1]    [2]    [3]
# CHECK-NEXT: 0.     2     1.0    1.0    0.5       pcmpgtd	%xmm0, %xmm0
# CHECK-NEXT: 1.     2     2.0    0.0    0.0       paddd	%xmm0, %xmm0
# CHECK-NEXT:        2     1.5    0.5    0.3       <total>

# CHECK:      [17] Code Region

# CHECK:      Iterations:        10000
# CHECK-NEXT: Instructions:      20000
# CHECK-NEXT: Total Cycles:      5004
# CHECK-NEXT: Total uOps:        20000

# CHECK:      Dispatch Width:    6
# CHECK-NEXT: uOps Per Cycle:    4.00
# CHECK-NEXT: IPC:               4.00
# CHECK-NEXT: Block RThroughput: 0.5

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      1     0.25                        pcmpgtq	%xmm0, %xmm0
# CHECK-NEXT:  1      1     0.25                        paddq	%xmm0, %xmm0

# CHECK:      Register File statistics:
# CHECK-NEXT: Total number of mappings created:    10000
# CHECK-NEXT: Max number of mappings used:         37

# CHECK:      *  Register File #1 -- Zn3FpPRF:
# CHECK-NEXT:    Number of physical registers:     160
# CHECK-NEXT:    Total number of mappings created: 10000
# CHECK-NEXT:    Max number of mappings used:      37

# CHECK:      *  Register File #2 -- Zn3IntegerPRF:
# CHECK-NEXT:    Number of physical registers:     192
# CHECK-NEXT:    Total number of mappings created: 0
# CHECK-NEXT:    Max number of mappings used:      0

# CHECK:      Resources:
# CHECK-NEXT: [0]   - Zn3AGU0
# CHECK-NEXT: [1]   - Zn3AGU1
# CHECK-NEXT: [2]   - Zn3AGU2
# CHECK-NEXT: [3]   - Zn3ALU0
# CHECK-NEXT: [4]   - Zn3ALU1
# CHECK-NEXT: [5]   - Zn3ALU2
# CHECK-NEXT: [6]   - Zn3ALU3
# CHECK-NEXT: [7]   - Zn3BRU1
# CHECK-NEXT: [8]   - Zn3FP0
# CHECK-NEXT: [9]   - Zn3FP1
# CHECK-NEXT: [10]  - Zn3FP2
# CHECK-NEXT: [11]  - Zn3FP3
# CHECK-NEXT: [12.0] - Zn3FP45
# CHECK-NEXT: [12.1] - Zn3FP45
# CHECK-NEXT: [13]  - Zn3FPSt
# CHECK-NEXT: [14.0] - Zn3LSU
# CHECK-NEXT: [14.1] - Zn3LSU
# CHECK-NEXT: [14.2] - Zn3LSU
# CHECK-NEXT: [15.0] - Zn3Load
# CHECK-NEXT: [15.1] - Zn3Load
# CHECK-NEXT: [15.2] - Zn3Load
# CHECK-NEXT: [16.0] - Zn3Store
# CHECK-NEXT: [16.1] - Zn3Store

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12.0] [12.1] [13]   [14.0] [14.1] [14.2] [15.0] [15.1] [15.2] [16.0] [16.1]
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12.0] [12.1] [13]   [14.0] [14.1] [14.2] [15.0] [15.1] [15.2] [16.0] [16.1] Instructions:
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.25   0.25   0.50    -      -      -      -      -      -      -      -      -      -      -      -     pcmpgtq	%xmm0, %xmm0
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.25   0.25    -     0.50    -      -      -      -      -      -      -      -      -      -      -     paddq	%xmm0, %xmm0

# CHECK:      Timeline view:
# CHECK-NEXT: Index     01234

# CHECK:      [0,0]     DeER.   pcmpgtq	%xmm0, %xmm0
# CHECK-NEXT: [0,1]     D=eER   paddq	%xmm0, %xmm0
# CHECK-NEXT: [1,0]     DeE-R   pcmpgtq	%xmm0, %xmm0
# CHECK-NEXT: [1,1]     D=eER   paddq	%xmm0, %xmm0

# CHECK:      Average Wait times (based on the timeline view):
# CHECK-NEXT: [0]: Executions
# CHECK-NEXT: [1]: Average time spent waiting in a scheduler's queue
# CHECK-NEXT: [2]: Average time spent waiting in a scheduler's queue while ready
# CHECK-NEXT: [3]: Average time elapsed from WB until retire stage

# CHECK:            [0]    [1]    [2]    [3]
# CHECK-NEXT: 0.     2     1.0    1.0    0.5       pcmpgtq	%xmm0, %xmm0
# CHECK-NEXT: 1.     2     2.0    0.0    0.0       paddq	%xmm0, %xmm0
# CHECK-NEXT:        2     1.5    0.5    0.3       <total>
