; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown | FileCheck %s

define void @tiny_memset_to_rep_stos(ptr %ptr) minsize nounwind {
; CHECK-LABEL: tiny_memset_to_rep_stos:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andq $0, (%rdi)
; CHECK-NEXT:    retq
entry:
  call void @llvm.memset.p0.i32(ptr align 4 %ptr, i8 0, i32 8, i1 false)
  ret void
}

define void @small_memset_to_rep_stos(ptr %ptr) minsize nounwind {
; CHECK-LABEL: small_memset_to_rep_stos:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    pushq $32
; CHECK-NEXT:    popq %rcx
; CHECK-NEXT:    xorl %eax, %eax
; CHECK-NEXT:    rep;stosl %eax, %es:(%rdi)
; CHECK-NEXT:    retq
entry:
  call void @llvm.memset.p0.i32(ptr align 4 %ptr, i8 0, i32 128, i1 false)
  ret void
}

define void @medium_memset_to_rep_stos(ptr %ptr) minsize nounwind {
; CHECK-LABEL: medium_memset_to_rep_stos:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl $128, %ecx
; CHECK-NEXT:    xorl %eax, %eax
; CHECK-NEXT:    rep;stosl %eax, %es:(%rdi)
; CHECK-NEXT:    retq
entry:
  call void @llvm.memset.p0.i32(ptr align 4 %ptr, i8 0, i32 512, i1 false)
  ret void
}

define void @large_memset_to_rep_stos(ptr %ptr) minsize nounwind {
; CHECK-LABEL: large_memset_to_rep_stos:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl $1024, %ecx # imm = 0x400
; CHECK-NEXT:    xorl %eax, %eax
; CHECK-NEXT:    rep;stosl %eax, %es:(%rdi)
; CHECK-NEXT:    retq
entry:
  call void @llvm.memset.p0.i32(ptr align 4 %ptr, i8 0, i32 4096, i1 false)
  ret void
}

define void @huge_memset_to_rep_stos(ptr %ptr) minsize nounwind {
; CHECK-LABEL: huge_memset_to_rep_stos:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl $2048, %ecx # imm = 0x800
; CHECK-NEXT:    xorl %eax, %eax
; CHECK-NEXT:    rep;stosl %eax, %es:(%rdi)
; CHECK-NEXT:    retq
entry:
  call void @llvm.memset.p0.i32(ptr align 4 %ptr, i8 0, i32 8192, i1 false)
  ret void
}

define void @odd_length_memset_to_rep_stos(ptr %ptr) minsize nounwind {
; CHECK-LABEL: odd_length_memset_to_rep_stos:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl $255, %ecx
; CHECK-NEXT:    xorl %eax, %eax
; CHECK-NEXT:    rep;stosb %al, %es:(%rdi)
; CHECK-NEXT:    retq
entry:
  call void @llvm.memset.p0.i32(ptr align 4 %ptr, i8 0, i32 255, i1 false)
  ret void
}

define void @align_1_memset_to_rep_stos(ptr %ptr) minsize nounwind {
; CHECK-LABEL: align_1_memset_to_rep_stos:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    pushq $64
; CHECK-NEXT:    popq %rcx
; CHECK-NEXT:    xorl %eax, %eax
; CHECK-NEXT:    rep;stosl %eax, %es:(%rdi)
; CHECK-NEXT:    retq
entry:
  call void @llvm.memset.p0.i32(ptr align 1 %ptr, i8 0, i32 256, i1 false)
  ret void
}

define void @align_2_memset_to_rep_stos(ptr %ptr) minsize nounwind {
; CHECK-LABEL: align_2_memset_to_rep_stos:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    pushq $64
; CHECK-NEXT:    popq %rcx
; CHECK-NEXT:    xorl %eax, %eax
; CHECK-NEXT:    rep;stosl %eax, %es:(%rdi)
; CHECK-NEXT:    retq
entry:
  call void @llvm.memset.p0.i32(ptr align 2 %ptr, i8 0, i32 256, i1 false)
  ret void
}

define void @align_4_memset_to_rep_stos(ptr %ptr) minsize nounwind {
; CHECK-LABEL: align_4_memset_to_rep_stos:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    pushq $64
; CHECK-NEXT:    popq %rcx
; CHECK-NEXT:    xorl %eax, %eax
; CHECK-NEXT:    rep;stosl %eax, %es:(%rdi)
; CHECK-NEXT:    retq
entry:
  call void @llvm.memset.p0.i32(ptr align 4 %ptr, i8 0, i32 256, i1 false)
  ret void
}

define void @align_8_memset_to_rep_stos(ptr %ptr) minsize nounwind {
; CHECK-LABEL: align_8_memset_to_rep_stos:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    pushq $64
; CHECK-NEXT:    popq %rcx
; CHECK-NEXT:    xorl %eax, %eax
; CHECK-NEXT:    rep;stosl %eax, %es:(%rdi)
; CHECK-NEXT:    retq
entry:
  call void @llvm.memset.p0.i32(ptr align 8 %ptr, i8 0, i32 256, i1 false)
  ret void
}

define void @small_memset_to_rep_stos_64(ptr %ptr) minsize nounwind {
; CHECK-LABEL: small_memset_to_rep_stos_64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    pushq $32
; CHECK-NEXT:    popq %rcx
; CHECK-NEXT:    xorl %eax, %eax
; CHECK-NEXT:    rep;stosl %eax, %es:(%rdi)
; CHECK-NEXT:    retq
entry:
  call void @llvm.memset.p0.i64(ptr align 8 %ptr, i8 0, i64 128, i1 false)
  ret void
}

declare void @llvm.memset.p0.i32(ptr nocapture writeonly, i8, i32, i1)
