; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S -mtriple=amdgcn-amd-amdhsa -passes=infer-address-spaces,instsimplify %s | FileCheck %s

define amdgpu_kernel void @is_local_true(ptr addrspace(3) %lptr) {
; CHECK-LABEL: @is_local_true(
; CHECK-NEXT:    store i32 1, ptr addrspace(1) undef
; CHECK-NEXT:    ret void
;
  %cast = addrspacecast ptr addrspace(3) %lptr to ptr
  %is.shared = call i1 @llvm.amdgcn.is.shared(ptr %cast)
  %ext = zext i1 %is.shared to i32
  store i32 %ext, ptr addrspace(1) undef
  ret void
}

define amdgpu_kernel void @is_local_false(ptr addrspace(1) %gptr) {
; CHECK-LABEL: @is_local_false(
; CHECK-NEXT:    store i32 0, ptr addrspace(1) undef
; CHECK-NEXT:    ret void
;
  %cast = addrspacecast ptr addrspace(1) %gptr to ptr
  %is.shared = call i1 @llvm.amdgcn.is.shared(ptr %cast)
  %ext = zext i1 %is.shared to i32
  store i32 %ext, ptr addrspace(1) undef
  ret void
}

define void @is_private_true(ptr addrspace(5) %lptr) {
; CHECK-LABEL: @is_private_true(
; CHECK-NEXT:    store i32 1, ptr addrspace(1) undef
; CHECK-NEXT:    ret void
;
  %cast = addrspacecast ptr addrspace(5) %lptr to ptr
  %is.private = call i1 @llvm.amdgcn.is.private(ptr %cast)
  %ext = zext i1 %is.private to i32
  store i32 %ext, ptr addrspace(1) undef
  ret void
}

define void @is_private_false(ptr addrspace(1) %gptr) {
; CHECK-LABEL: @is_private_false(
; CHECK-NEXT:    store i32 0, ptr addrspace(1) undef
; CHECK-NEXT:    ret void
;
  %cast = addrspacecast ptr addrspace(1) %gptr to ptr
  %is.private = call i1 @llvm.amdgcn.is.private(ptr %cast)
  %ext = zext i1 %is.private to i32
  store i32 %ext, ptr addrspace(1) undef
  ret void
}

declare i1 @llvm.amdgcn.is.shared(ptr nocapture) #0
declare i1 @llvm.amdgcn.is.private(ptr nocapture) #0

attributes #0 = { nounwind readnone speculatable }
