; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -o - %s -mtriple=aarch64 | FileCheck %s --check-prefix=CHECK-O2
; RUN: llc -o - %s -mtriple=aarch64 -O3 | FileCheck %s --check-prefix=CHECK-O3

%struct.S = type { i32, i16 }
define i32 @needless_promotion(ptr nocapture noundef readonly %S, i64 noundef %red_cost) {
; CHECK-O2-LABEL: needless_promotion:
; CHECK-O2:       // %bb.0: // %entry
; CHECK-O2-NEXT:    ldrsh w8, [x0, #4]
; CHECK-O2-NEXT:    tbnz w8, #31, .LBB0_3
; CHECK-O2-NEXT:  // %bb.1: // %lor.rhs
; CHECK-O2-NEXT:    cbz x1, .LBB0_5
; CHECK-O2-NEXT:  // %bb.2:
; CHECK-O2-NEXT:    mov w9, #2
; CHECK-O2-NEXT:    b .LBB0_4
; CHECK-O2-NEXT:  .LBB0_3:
; CHECK-O2-NEXT:    mov w9, #1
; CHECK-O2-NEXT:  .LBB0_4: // %lor.end.sink.split
; CHECK-O2-NEXT:    cmp w8, w9
; CHECK-O2-NEXT:    cset w0, eq
; CHECK-O2-NEXT:    ret
; CHECK-O2-NEXT:  .LBB0_5:
; CHECK-O2-NEXT:    mov w0, wzr
; CHECK-O2-NEXT:    ret
;
; CHECK-O3-LABEL: needless_promotion:
; CHECK-O3:       // %bb.0: // %entry
; CHECK-O3-NEXT:    ldrsh w8, [x0, #4]
; CHECK-O3-NEXT:    tbnz w8, #31, .LBB0_3
; CHECK-O3-NEXT:  // %bb.1: // %lor.rhs
; CHECK-O3-NEXT:    cbz x1, .LBB0_4
; CHECK-O3-NEXT:  // %bb.2:
; CHECK-O3-NEXT:    mov w9, #2
; CHECK-O3-NEXT:    cmp w8, w9
; CHECK-O3-NEXT:    cset w0, eq
; CHECK-O3-NEXT:    ret
; CHECK-O3-NEXT:  .LBB0_3:
; CHECK-O3-NEXT:    mov w9, #1
; CHECK-O3-NEXT:    cmp w8, w9
; CHECK-O3-NEXT:    cset w0, eq
; CHECK-O3-NEXT:    ret
; CHECK-O3-NEXT:  .LBB0_4:
; CHECK-O3-NEXT:    mov w0, wzr
; CHECK-O3-NEXT:    ret
entry:
  %ident = getelementptr inbounds %struct.S, ptr %S, i64 0, i32 1
  %0 = load i16, ptr %ident, align 8
  %cmp = icmp slt i16 %0, 0
  br i1 %cmp, label %lor.end.sink.split, label %lor.rhs

lor.rhs:                                          ; preds = %entry
  %cmp3.not = icmp eq i64 %red_cost, 0
  br i1 %cmp3.not, label %lor.end, label %lor.end.sink.split

lor.end.sink.split:                               ; preds = %lor.rhs, %entry
  %.sink12 = phi i16 [ 1, %entry ], [ 2, %lor.rhs ]
  %cmp1 = icmp eq i16 %0, %.sink12
  %phi.cast = zext i1 %cmp1 to i32
  br label %lor.end

lor.end:                                          ; preds = %lor.end.sink.split, %lor.rhs
  %.shrunk = phi i32 [ 0, %lor.rhs ], [ %phi.cast, %lor.end.sink.split ]
  ret i32 %.shrunk
}

define i8 @loopcmp(ptr nocapture noundef readonly %x, i8 noundef %y) {
; CHECK-O2-LABEL: loopcmp:
; CHECK-O2:       // %bb.0: // %entry
; CHECK-O2-NEXT:    and w9, w1, #0xff
; CHECK-O2-NEXT:  .LBB1_1: // %while.cond
; CHECK-O2-NEXT:    // =>This Inner Loop Header: Depth=1
; CHECK-O2-NEXT:    ldrb w8, [x0], #1
; CHECK-O2-NEXT:    cmp w8, w9
; CHECK-O2-NEXT:    b.lo .LBB1_1
; CHECK-O2-NEXT:  // %bb.2: // %while.end
; CHECK-O2-NEXT:    mov w0, w8
; CHECK-O2-NEXT:    ret
;
; CHECK-O3-LABEL: loopcmp:
; CHECK-O3:       // %bb.0: // %entry
; CHECK-O3-NEXT:    and w9, w1, #0xff
; CHECK-O3-NEXT:  .LBB1_1: // %while.cond
; CHECK-O3-NEXT:    // =>This Inner Loop Header: Depth=1
; CHECK-O3-NEXT:    ldrb w8, [x0], #1
; CHECK-O3-NEXT:    cmp w8, w9
; CHECK-O3-NEXT:    b.lo .LBB1_1
; CHECK-O3-NEXT:  // %bb.2: // %while.end
; CHECK-O3-NEXT:    mov w0, w8
; CHECK-O3-NEXT:    ret
entry:
  br label %while.cond

while.cond:                                       ; preds = %while.cond, %entry
  %a.0.in = phi ptr [ %x, %entry ], [ %x.addr.0, %while.cond ]
  %a.0 = load i8, ptr %a.0.in, align 1
  %cmp = icmp ult i8 %a.0, %y
  %x.addr.0 = getelementptr inbounds i8, ptr %a.0.in, i64 1
  br i1 %cmp, label %while.cond, label %while.end

while.end:                                        ; preds = %while.cond
  ret i8 %a.0
}

