; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 3
; RUN: opt -passes=mergefunc -S %s | FileCheck %s

; This test contains three identical functions, aside from the metadata
; they pass to a function call. This test verifies that the function merger
; pass is able to merge the two functions that are truly identical,
; but the third that passes different metadata is preserved

declare { ptr, i1 } @llvm.type.checked.load(ptr, i32, metadata)

define i1 @merge_candidate_a(ptr %ptr, i32 %offset) {
; CHECK-LABEL: define i1 @merge_candidate_a(
; CHECK-SAME: ptr [[PTR:%.*]], i32 [[OFFSET:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = call { ptr, i1 } @llvm.type.checked.load(ptr [[PTR]], i32 [[OFFSET]], metadata !"common_metadata")
; CHECK-NEXT:    [[TMP2:%.*]] = extractvalue { ptr, i1 } [[TMP1]], 1
; CHECK-NEXT:    ret i1 [[TMP2]]
;
  %1 = call { ptr, i1 } @llvm.type.checked.load(ptr %ptr, i32 %offset, metadata !"common_metadata")
  %2 = extractvalue { ptr, i1 } %1, 1
  ret i1 %2
}

define i1 @merge_candidate_c(ptr %ptr, i32 %offset) {
; CHECK-LABEL: define i1 @merge_candidate_c(
; CHECK-SAME: ptr [[PTR:%.*]], i32 [[OFFSET:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = call { ptr, i1 } @llvm.type.checked.load(ptr [[PTR]], i32 [[OFFSET]], metadata !"different_metadata")
; CHECK-NEXT:    [[TMP2:%.*]] = extractvalue { ptr, i1 } [[TMP1]], 1
; CHECK-NEXT:    ret i1 [[TMP2]]
;
  %1 = call { ptr, i1 } @llvm.type.checked.load(ptr %ptr, i32 %offset, metadata !"different_metadata")
  %2 = extractvalue { ptr, i1 } %1, 1
  ret i1 %2
}

define i1 @merge_candidate_b(ptr %ptr, i32 %offset) {
; CHECK-LABEL: define i1 @merge_candidate_b(
; CHECK-SAME: ptr [[TMP0:%.*]], i32 [[TMP1:%.*]]) {
; CHECK-NEXT:    [[TMP3:%.*]] = tail call i1 @merge_candidate_a(ptr [[TMP0]], i32 [[TMP1]])
; CHECK-NEXT:    ret i1 [[TMP3]]
;
  %1 = call { ptr, i1 } @llvm.type.checked.load(ptr %ptr, i32 %offset, metadata !"common_metadata")
  %2 = extractvalue { ptr, i1 } %1, 1
  ret i1 %2
}
