; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mattr=+sve -force-streaming-compatible  < %s | FileCheck %s
; RUN: llc -mattr=+sme -force-streaming  < %s | FileCheck %s
; RUN: llc -force-streaming-compatible < %s | FileCheck %s --check-prefix=NONEON-NOSVE

target triple = "aarch64-unknown-linux-gnu"

define <4 x i8> @select_v4i8(<4 x i8> %op1, <4 x i8> %op2, <4 x i1> %mask) {
; CHECK-LABEL: select_v4i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $z2
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    lsl z2.h, z2.h, #15
; CHECK-NEXT:    asr z2.h, z2.h, #15
; CHECK-NEXT:    and z2.h, z2.h, #0x1
; CHECK-NEXT:    cmpne p0.h, p0/z, z2.h, #0
; CHECK-NEXT:    sel z0.h, p0, z0.h, z1.h
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: select_v4i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #32
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    stp d1, d2, [sp, #8]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #22]
; NONEON-NOSVE-NEXT:    str d0, [sp]
; NONEON-NOSVE-NEXT:    ldrh w11, [sp, #20]
; NONEON-NOSVE-NEXT:    ldrh w12, [sp, #14]
; NONEON-NOSVE-NEXT:    ldrh w13, [sp, #6]
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #18]
; NONEON-NOSVE-NEXT:    sbfx w9, w9, #0, #1
; NONEON-NOSVE-NEXT:    sbfx w11, w11, #0, #1
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #16]
; NONEON-NOSVE-NEXT:    sbfx w10, w10, #0, #1
; NONEON-NOSVE-NEXT:    tst w9, #0xffff
; NONEON-NOSVE-NEXT:    sbfx w8, w8, #0, #1
; NONEON-NOSVE-NEXT:    csel w9, w13, w12, ne
; NONEON-NOSVE-NEXT:    ldrh w12, [sp, #4]
; NONEON-NOSVE-NEXT:    tst w11, #0xffff
; NONEON-NOSVE-NEXT:    strh w9, [sp, #30]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #12]
; NONEON-NOSVE-NEXT:    ldrh w11, [sp, #2]
; NONEON-NOSVE-NEXT:    csel w9, w12, w9, ne
; NONEON-NOSVE-NEXT:    tst w10, #0xffff
; NONEON-NOSVE-NEXT:    ldrh w10, [sp]
; NONEON-NOSVE-NEXT:    strh w9, [sp, #28]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #10]
; NONEON-NOSVE-NEXT:    csel w9, w11, w9, ne
; NONEON-NOSVE-NEXT:    tst w8, #0xffff
; NONEON-NOSVE-NEXT:    strh w9, [sp, #26]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #8]
; NONEON-NOSVE-NEXT:    csel w8, w10, w9, ne
; NONEON-NOSVE-NEXT:    strh w8, [sp, #24]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #24]
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %sel = select <4 x i1> %mask, <4 x i8> %op1, <4 x i8> %op2
  ret <4 x i8> %sel
}

define <8 x i8> @select_v8i8(<8 x i8> %op1, <8 x i8> %op2, <8 x i1> %mask) {
; CHECK-LABEL: select_v8i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $z2
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    lsl z2.b, z2.b, #7
; CHECK-NEXT:    asr z2.b, z2.b, #7
; CHECK-NEXT:    and z2.b, z2.b, #0x1
; CHECK-NEXT:    cmpne p0.b, p0/z, z2.b, #0
; CHECK-NEXT:    sel z0.b, p0, z0.b, z1.b
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: select_v8i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #32
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    stp d1, d2, [sp, #8]
; NONEON-NOSVE-NEXT:    ldrb w13, [sp, #23]
; NONEON-NOSVE-NEXT:    str d0, [sp]
; NONEON-NOSVE-NEXT:    ldrb w15, [sp, #22]
; NONEON-NOSVE-NEXT:    ldrb w16, [sp, #15]
; NONEON-NOSVE-NEXT:    ldrb w17, [sp, #7]
; NONEON-NOSVE-NEXT:    ldrb w14, [sp, #21]
; NONEON-NOSVE-NEXT:    sbfx w13, w13, #0, #1
; NONEON-NOSVE-NEXT:    sbfx w15, w15, #0, #1
; NONEON-NOSVE-NEXT:    ldrb w12, [sp, #20]
; NONEON-NOSVE-NEXT:    sbfx w14, w14, #0, #1
; NONEON-NOSVE-NEXT:    ldrb w11, [sp, #19]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #18]
; NONEON-NOSVE-NEXT:    tst w13, #0xff
; NONEON-NOSVE-NEXT:    sbfx w12, w12, #0, #1
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #17]
; NONEON-NOSVE-NEXT:    csel w13, w17, w16, ne
; NONEON-NOSVE-NEXT:    ldrb w16, [sp, #6]
; NONEON-NOSVE-NEXT:    tst w15, #0xff
; NONEON-NOSVE-NEXT:    strb w13, [sp, #31]
; NONEON-NOSVE-NEXT:    ldrb w13, [sp, #14]
; NONEON-NOSVE-NEXT:    ldrb w15, [sp, #5]
; NONEON-NOSVE-NEXT:    sbfx w11, w11, #0, #1
; NONEON-NOSVE-NEXT:    sbfx w10, w10, #0, #1
; NONEON-NOSVE-NEXT:    sbfx w9, w9, #0, #1
; NONEON-NOSVE-NEXT:    csel w13, w16, w13, ne
; NONEON-NOSVE-NEXT:    tst w14, #0xff
; NONEON-NOSVE-NEXT:    ldrb w14, [sp, #4]
; NONEON-NOSVE-NEXT:    strb w13, [sp, #30]
; NONEON-NOSVE-NEXT:    ldrb w13, [sp, #13]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #16]
; NONEON-NOSVE-NEXT:    csel w13, w15, w13, ne
; NONEON-NOSVE-NEXT:    tst w12, #0xff
; NONEON-NOSVE-NEXT:    sbfx w8, w8, #0, #1
; NONEON-NOSVE-NEXT:    strb w13, [sp, #29]
; NONEON-NOSVE-NEXT:    ldrb w13, [sp, #12]
; NONEON-NOSVE-NEXT:    csel w12, w14, w13, ne
; NONEON-NOSVE-NEXT:    ldrb w13, [sp, #3]
; NONEON-NOSVE-NEXT:    tst w11, #0xff
; NONEON-NOSVE-NEXT:    strb w12, [sp, #28]
; NONEON-NOSVE-NEXT:    ldrb w12, [sp, #11]
; NONEON-NOSVE-NEXT:    csel w11, w13, w12, ne
; NONEON-NOSVE-NEXT:    ldrb w12, [sp, #2]
; NONEON-NOSVE-NEXT:    tst w10, #0xff
; NONEON-NOSVE-NEXT:    strb w11, [sp, #27]
; NONEON-NOSVE-NEXT:    ldrb w11, [sp, #10]
; NONEON-NOSVE-NEXT:    csel w10, w12, w11, ne
; NONEON-NOSVE-NEXT:    ldrb w11, [sp, #1]
; NONEON-NOSVE-NEXT:    tst w9, #0xff
; NONEON-NOSVE-NEXT:    strb w10, [sp, #26]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #9]
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, ne
; NONEON-NOSVE-NEXT:    ldrb w10, [sp]
; NONEON-NOSVE-NEXT:    tst w8, #0xff
; NONEON-NOSVE-NEXT:    strb w9, [sp, #25]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #8]
; NONEON-NOSVE-NEXT:    csel w8, w10, w9, ne
; NONEON-NOSVE-NEXT:    strb w8, [sp, #24]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #24]
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %sel = select <8 x i1> %mask, <8 x i8> %op1, <8 x i8> %op2
  ret <8 x i8> %sel
}

define <16 x i8> @select_v16i8(<16 x i8> %op1, <16 x i8> %op2, <16 x i1> %mask) {
; CHECK-LABEL: select_v16i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q2 killed $q2 def $z2
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    lsl z2.b, z2.b, #7
; CHECK-NEXT:    asr z2.b, z2.b, #7
; CHECK-NEXT:    and z2.b, z2.b, #0x1
; CHECK-NEXT:    cmpne p0.b, p0/z, z2.b, #0
; CHECK-NEXT:    sel z0.b, p0, z0.b, z1.b
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: select_v16i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #64
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    stp q1, q2, [sp, #16]
; NONEON-NOSVE-NEXT:    ldrb w2, [sp, #47]
; NONEON-NOSVE-NEXT:    str q0, [sp]
; NONEON-NOSVE-NEXT:    ldrb w4, [sp, #46]
; NONEON-NOSVE-NEXT:    ldrb w5, [sp, #31]
; NONEON-NOSVE-NEXT:    ldrb w6, [sp, #15]
; NONEON-NOSVE-NEXT:    ldrb w3, [sp, #45]
; NONEON-NOSVE-NEXT:    sbfx w2, w2, #0, #1
; NONEON-NOSVE-NEXT:    sbfx w4, w4, #0, #1
; NONEON-NOSVE-NEXT:    ldrb w1, [sp, #44]
; NONEON-NOSVE-NEXT:    sbfx w3, w3, #0, #1
; NONEON-NOSVE-NEXT:    ldrb w0, [sp, #43]
; NONEON-NOSVE-NEXT:    ldrb w18, [sp, #42]
; NONEON-NOSVE-NEXT:    tst w2, #0xff
; NONEON-NOSVE-NEXT:    sbfx w1, w1, #0, #1
; NONEON-NOSVE-NEXT:    ldrb w17, [sp, #41]
; NONEON-NOSVE-NEXT:    csel w2, w6, w5, ne
; NONEON-NOSVE-NEXT:    ldrb w5, [sp, #14]
; NONEON-NOSVE-NEXT:    tst w4, #0xff
; NONEON-NOSVE-NEXT:    strb w2, [sp, #63]
; NONEON-NOSVE-NEXT:    ldrb w2, [sp, #30]
; NONEON-NOSVE-NEXT:    ldrb w4, [sp, #13]
; NONEON-NOSVE-NEXT:    sbfx w0, w0, #0, #1
; NONEON-NOSVE-NEXT:    sbfx w18, w18, #0, #1
; NONEON-NOSVE-NEXT:    sbfx w17, w17, #0, #1
; NONEON-NOSVE-NEXT:    csel w2, w5, w2, ne
; NONEON-NOSVE-NEXT:    tst w3, #0xff
; NONEON-NOSVE-NEXT:    ldrb w3, [sp, #12]
; NONEON-NOSVE-NEXT:    strb w2, [sp, #62]
; NONEON-NOSVE-NEXT:    ldrb w2, [sp, #29]
; NONEON-NOSVE-NEXT:    ldrb w16, [sp, #40]
; NONEON-NOSVE-NEXT:    ldrb w15, [sp, #39]
; NONEON-NOSVE-NEXT:    ldrb w14, [sp, #38]
; NONEON-NOSVE-NEXT:    ldrb w13, [sp, #37]
; NONEON-NOSVE-NEXT:    csel w2, w4, w2, ne
; NONEON-NOSVE-NEXT:    tst w1, #0xff
; NONEON-NOSVE-NEXT:    sbfx w16, w16, #0, #1
; NONEON-NOSVE-NEXT:    strb w2, [sp, #61]
; NONEON-NOSVE-NEXT:    ldrb w2, [sp, #28]
; NONEON-NOSVE-NEXT:    sbfx w15, w15, #0, #1
; NONEON-NOSVE-NEXT:    sbfx w14, w14, #0, #1
; NONEON-NOSVE-NEXT:    sbfx w13, w13, #0, #1
; NONEON-NOSVE-NEXT:    ldrb w12, [sp, #36]
; NONEON-NOSVE-NEXT:    csel w1, w3, w2, ne
; NONEON-NOSVE-NEXT:    ldrb w2, [sp, #11]
; NONEON-NOSVE-NEXT:    tst w0, #0xff
; NONEON-NOSVE-NEXT:    strb w1, [sp, #60]
; NONEON-NOSVE-NEXT:    ldrb w1, [sp, #27]
; NONEON-NOSVE-NEXT:    sbfx w12, w12, #0, #1
; NONEON-NOSVE-NEXT:    ldrb w11, [sp, #35]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #34]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #33]
; NONEON-NOSVE-NEXT:    csel w0, w2, w1, ne
; NONEON-NOSVE-NEXT:    ldrb w1, [sp, #10]
; NONEON-NOSVE-NEXT:    tst w18, #0xff
; NONEON-NOSVE-NEXT:    strb w0, [sp, #59]
; NONEON-NOSVE-NEXT:    ldrb w0, [sp, #26]
; NONEON-NOSVE-NEXT:    sbfx w11, w11, #0, #1
; NONEON-NOSVE-NEXT:    sbfx w10, w10, #0, #1
; NONEON-NOSVE-NEXT:    sbfx w9, w9, #0, #1
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #32]
; NONEON-NOSVE-NEXT:    csel w18, w1, w0, ne
; NONEON-NOSVE-NEXT:    ldrb w0, [sp, #9]
; NONEON-NOSVE-NEXT:    tst w17, #0xff
; NONEON-NOSVE-NEXT:    strb w18, [sp, #58]
; NONEON-NOSVE-NEXT:    ldrb w18, [sp, #25]
; NONEON-NOSVE-NEXT:    sbfx w8, w8, #0, #1
; NONEON-NOSVE-NEXT:    csel w17, w0, w18, ne
; NONEON-NOSVE-NEXT:    ldrb w18, [sp, #8]
; NONEON-NOSVE-NEXT:    tst w16, #0xff
; NONEON-NOSVE-NEXT:    strb w17, [sp, #57]
; NONEON-NOSVE-NEXT:    ldrb w17, [sp, #24]
; NONEON-NOSVE-NEXT:    csel w16, w18, w17, ne
; NONEON-NOSVE-NEXT:    ldrb w17, [sp, #7]
; NONEON-NOSVE-NEXT:    tst w15, #0xff
; NONEON-NOSVE-NEXT:    strb w16, [sp, #56]
; NONEON-NOSVE-NEXT:    ldrb w16, [sp, #23]
; NONEON-NOSVE-NEXT:    csel w15, w17, w16, ne
; NONEON-NOSVE-NEXT:    ldrb w16, [sp, #6]
; NONEON-NOSVE-NEXT:    tst w14, #0xff
; NONEON-NOSVE-NEXT:    strb w15, [sp, #55]
; NONEON-NOSVE-NEXT:    ldrb w15, [sp, #22]
; NONEON-NOSVE-NEXT:    csel w14, w16, w15, ne
; NONEON-NOSVE-NEXT:    ldrb w15, [sp, #5]
; NONEON-NOSVE-NEXT:    tst w13, #0xff
; NONEON-NOSVE-NEXT:    strb w14, [sp, #54]
; NONEON-NOSVE-NEXT:    ldrb w14, [sp, #21]
; NONEON-NOSVE-NEXT:    csel w13, w15, w14, ne
; NONEON-NOSVE-NEXT:    ldrb w14, [sp, #4]
; NONEON-NOSVE-NEXT:    tst w12, #0xff
; NONEON-NOSVE-NEXT:    strb w13, [sp, #53]
; NONEON-NOSVE-NEXT:    ldrb w13, [sp, #20]
; NONEON-NOSVE-NEXT:    csel w12, w14, w13, ne
; NONEON-NOSVE-NEXT:    ldrb w13, [sp, #3]
; NONEON-NOSVE-NEXT:    tst w11, #0xff
; NONEON-NOSVE-NEXT:    strb w12, [sp, #52]
; NONEON-NOSVE-NEXT:    ldrb w12, [sp, #19]
; NONEON-NOSVE-NEXT:    csel w11, w13, w12, ne
; NONEON-NOSVE-NEXT:    ldrb w12, [sp, #2]
; NONEON-NOSVE-NEXT:    tst w10, #0xff
; NONEON-NOSVE-NEXT:    strb w11, [sp, #51]
; NONEON-NOSVE-NEXT:    ldrb w11, [sp, #18]
; NONEON-NOSVE-NEXT:    csel w10, w12, w11, ne
; NONEON-NOSVE-NEXT:    ldrb w11, [sp, #1]
; NONEON-NOSVE-NEXT:    tst w9, #0xff
; NONEON-NOSVE-NEXT:    strb w10, [sp, #50]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #17]
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, ne
; NONEON-NOSVE-NEXT:    ldrb w10, [sp]
; NONEON-NOSVE-NEXT:    tst w8, #0xff
; NONEON-NOSVE-NEXT:    strb w9, [sp, #49]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #16]
; NONEON-NOSVE-NEXT:    csel w8, w10, w9, ne
; NONEON-NOSVE-NEXT:    strb w8, [sp, #48]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #48]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %sel = select <16 x i1> %mask, <16 x i8> %op1, <16 x i8> %op2
  ret <16 x i8> %sel
}

define void @select_v32i8(ptr %a, ptr %b) {
; CHECK-LABEL: select_v32i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q2, [x0]
; CHECK-NEXT:    ptrue p0.b, vl16
; CHECK-NEXT:    ldp q1, q3, [x1]
; CHECK-NEXT:    cmpeq p1.b, p0/z, z0.b, z1.b
; CHECK-NEXT:    cmpeq p0.b, p0/z, z2.b, z3.b
; CHECK-NEXT:    sel z0.b, p1, z0.b, z1.b
; CHECK-NEXT:    sel z1.b, p0, z2.b, z3.b
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: select_v32i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #208
; NONEON-NOSVE-NEXT:    stp x29, x30, [sp, #112] // 16-byte Folded Spill
; NONEON-NOSVE-NEXT:    stp x28, x27, [sp, #128] // 16-byte Folded Spill
; NONEON-NOSVE-NEXT:    stp x26, x25, [sp, #144] // 16-byte Folded Spill
; NONEON-NOSVE-NEXT:    stp x24, x23, [sp, #160] // 16-byte Folded Spill
; NONEON-NOSVE-NEXT:    stp x22, x21, [sp, #176] // 16-byte Folded Spill
; NONEON-NOSVE-NEXT:    stp x20, x19, [sp, #192] // 16-byte Folded Spill
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 208
; NONEON-NOSVE-NEXT:    .cfi_offset w19, -8
; NONEON-NOSVE-NEXT:    .cfi_offset w20, -16
; NONEON-NOSVE-NEXT:    .cfi_offset w21, -24
; NONEON-NOSVE-NEXT:    .cfi_offset w22, -32
; NONEON-NOSVE-NEXT:    .cfi_offset w23, -40
; NONEON-NOSVE-NEXT:    .cfi_offset w24, -48
; NONEON-NOSVE-NEXT:    .cfi_offset w25, -56
; NONEON-NOSVE-NEXT:    .cfi_offset w26, -64
; NONEON-NOSVE-NEXT:    .cfi_offset w27, -72
; NONEON-NOSVE-NEXT:    .cfi_offset w28, -80
; NONEON-NOSVE-NEXT:    .cfi_offset w30, -88
; NONEON-NOSVE-NEXT:    .cfi_offset w29, -96
; NONEON-NOSVE-NEXT:    ldp q0, q3, [x1]
; NONEON-NOSVE-NEXT:    ldp q1, q2, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #16]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #33]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #17]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #34]
; NONEON-NOSVE-NEXT:    ldrb w11, [sp, #18]
; NONEON-NOSVE-NEXT:    ldrb w12, [sp, #35]
; NONEON-NOSVE-NEXT:    ldrb w13, [sp, #19]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    ldrb w14, [sp, #36]
; NONEON-NOSVE-NEXT:    ldrb w16, [sp, #20]
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, eq
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    ldrb w18, [sp, #37]
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, eq
; NONEON-NOSVE-NEXT:    cmp w13, w12
; NONEON-NOSVE-NEXT:    ldrb w1, [sp, #21]
; NONEON-NOSVE-NEXT:    str w8, [sp, #12] // 4-byte Folded Spill
; NONEON-NOSVE-NEXT:    csel w8, w13, w12, eq
; NONEON-NOSVE-NEXT:    cmp w16, w14
; NONEON-NOSVE-NEXT:    ldrb w13, [sp, #38]
; NONEON-NOSVE-NEXT:    ldrb w2, [sp, #22]
; NONEON-NOSVE-NEXT:    stp w8, w9, [sp, #4] // 8-byte Folded Spill
; NONEON-NOSVE-NEXT:    csel w8, w16, w14, eq
; NONEON-NOSVE-NEXT:    cmp w1, w18
; NONEON-NOSVE-NEXT:    ldrb w14, [sp, #39]
; NONEON-NOSVE-NEXT:    ldrb w16, [sp, #23]
; NONEON-NOSVE-NEXT:    csel w12, w1, w18, eq
; NONEON-NOSVE-NEXT:    cmp w2, w13
; NONEON-NOSVE-NEXT:    ldrb w18, [sp, #40]
; NONEON-NOSVE-NEXT:    ldrb w1, [sp, #24]
; NONEON-NOSVE-NEXT:    csel w13, w2, w13, eq
; NONEON-NOSVE-NEXT:    cmp w16, w14
; NONEON-NOSVE-NEXT:    ldrb w2, [sp, #41]
; NONEON-NOSVE-NEXT:    ldrb w5, [sp, #25]
; NONEON-NOSVE-NEXT:    csel w14, w16, w14, eq
; NONEON-NOSVE-NEXT:    cmp w1, w18
; NONEON-NOSVE-NEXT:    ldrb w6, [sp, #26]
; NONEON-NOSVE-NEXT:    csel w16, w1, w18, eq
; NONEON-NOSVE-NEXT:    ldrb w1, [sp, #42]
; NONEON-NOSVE-NEXT:    cmp w5, w2
; NONEON-NOSVE-NEXT:    csel w18, w5, w2, eq
; NONEON-NOSVE-NEXT:    ldrb w2, [sp, #43]
; NONEON-NOSVE-NEXT:    ldrb w5, [sp, #27]
; NONEON-NOSVE-NEXT:    cmp w6, w1
; NONEON-NOSVE-NEXT:    ldrb w19, [sp, #28]
; NONEON-NOSVE-NEXT:    ldrb w29, [sp, #45]
; NONEON-NOSVE-NEXT:    csel w1, w6, w1, eq
; NONEON-NOSVE-NEXT:    ldrb w6, [sp, #44]
; NONEON-NOSVE-NEXT:    cmp w5, w2
; NONEON-NOSVE-NEXT:    ldrb w30, [sp, #29]
; NONEON-NOSVE-NEXT:    str w8, [sp] // 4-byte Folded Spill
; NONEON-NOSVE-NEXT:    csel w2, w5, w2, eq
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #46]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #30]
; NONEON-NOSVE-NEXT:    cmp w19, w6
; NONEON-NOSVE-NEXT:    stp q2, q3, [sp, #48]
; NONEON-NOSVE-NEXT:    ldrb w21, [sp, #47]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #31]
; NONEON-NOSVE-NEXT:    csel w5, w19, w6, eq
; NONEON-NOSVE-NEXT:    cmp w30, w29
; NONEON-NOSVE-NEXT:    ldrb w22, [sp, #64]
; NONEON-NOSVE-NEXT:    ldrb w11, [sp, #48]
; NONEON-NOSVE-NEXT:    csel w6, w30, w29, eq
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    ldrb w28, [sp, #65]
; NONEON-NOSVE-NEXT:    ldrb w29, [sp, #49]
; NONEON-NOSVE-NEXT:    csel w19, w8, w9, eq
; NONEON-NOSVE-NEXT:    cmp w10, w21
; NONEON-NOSVE-NEXT:    ldrb w27, [sp, #66]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #50]
; NONEON-NOSVE-NEXT:    csel w21, w10, w21, eq
; NONEON-NOSVE-NEXT:    cmp w11, w22
; NONEON-NOSVE-NEXT:    ldrb w26, [sp, #67]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #51]
; NONEON-NOSVE-NEXT:    csel w22, w11, w22, eq
; NONEON-NOSVE-NEXT:    cmp w29, w28
; NONEON-NOSVE-NEXT:    ldrb w25, [sp, #68]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #52]
; NONEON-NOSVE-NEXT:    csel w11, w29, w28, eq
; NONEON-NOSVE-NEXT:    cmp w8, w27
; NONEON-NOSVE-NEXT:    ldrb w24, [sp, #69]
; NONEON-NOSVE-NEXT:    ldrb w28, [sp, #53]
; NONEON-NOSVE-NEXT:    csel w8, w8, w27, eq
; NONEON-NOSVE-NEXT:    cmp w9, w26
; NONEON-NOSVE-NEXT:    ldrb w23, [sp, #70]
; NONEON-NOSVE-NEXT:    ldrb w27, [sp, #54]
; NONEON-NOSVE-NEXT:    csel w9, w9, w26, eq
; NONEON-NOSVE-NEXT:    cmp w10, w25
; NONEON-NOSVE-NEXT:    ldrb w20, [sp, #71]
; NONEON-NOSVE-NEXT:    ldrb w26, [sp, #55]
; NONEON-NOSVE-NEXT:    csel w10, w10, w25, eq
; NONEON-NOSVE-NEXT:    cmp w28, w24
; NONEON-NOSVE-NEXT:    ldrb w7, [sp, #72]
; NONEON-NOSVE-NEXT:    ldrb w25, [sp, #56]
; NONEON-NOSVE-NEXT:    csel w24, w28, w24, eq
; NONEON-NOSVE-NEXT:    cmp w27, w23
; NONEON-NOSVE-NEXT:    ldrb w4, [sp, #73]
; NONEON-NOSVE-NEXT:    ldrb w28, [sp, #57]
; NONEON-NOSVE-NEXT:    csel w23, w27, w23, eq
; NONEON-NOSVE-NEXT:    cmp w26, w20
; NONEON-NOSVE-NEXT:    ldrb w3, [sp, #74]
; NONEON-NOSVE-NEXT:    ldrb w27, [sp, #58]
; NONEON-NOSVE-NEXT:    csel w20, w26, w20, eq
; NONEON-NOSVE-NEXT:    cmp w25, w7
; NONEON-NOSVE-NEXT:    ldrb w17, [sp, #75]
; NONEON-NOSVE-NEXT:    ldrb w26, [sp, #59]
; NONEON-NOSVE-NEXT:    csel w7, w25, w7, eq
; NONEON-NOSVE-NEXT:    cmp w28, w4
; NONEON-NOSVE-NEXT:    ldrb w15, [sp, #76]
; NONEON-NOSVE-NEXT:    ldrb w25, [sp, #60]
; NONEON-NOSVE-NEXT:    csel w4, w28, w4, eq
; NONEON-NOSVE-NEXT:    cmp w27, w3
; NONEON-NOSVE-NEXT:    csel w3, w27, w3, eq
; NONEON-NOSVE-NEXT:    cmp w26, w17
; NONEON-NOSVE-NEXT:    ldrb w28, [sp, #77]
; NONEON-NOSVE-NEXT:    ldrb w27, [sp, #61]
; NONEON-NOSVE-NEXT:    csel w17, w26, w17, eq
; NONEON-NOSVE-NEXT:    cmp w25, w15
; NONEON-NOSVE-NEXT:    ldrb w26, [sp, #78]
; NONEON-NOSVE-NEXT:    csel w15, w25, w15, eq
; NONEON-NOSVE-NEXT:    ldrb w25, [sp, #62]
; NONEON-NOSVE-NEXT:    cmp w27, w28
; NONEON-NOSVE-NEXT:    ldrb w29, [sp, #79]
; NONEON-NOSVE-NEXT:    ldrb w30, [sp, #63]
; NONEON-NOSVE-NEXT:    strb w9, [sp, #99]
; NONEON-NOSVE-NEXT:    csel w27, w27, w28, eq
; NONEON-NOSVE-NEXT:    cmp w25, w26
; NONEON-NOSVE-NEXT:    strb w8, [sp, #98]
; NONEON-NOSVE-NEXT:    csel w25, w25, w26, eq
; NONEON-NOSVE-NEXT:    cmp w30, w29
; NONEON-NOSVE-NEXT:    ldp w9, w8, [sp] // 8-byte Folded Reload
; NONEON-NOSVE-NEXT:    csel w26, w30, w29, eq
; NONEON-NOSVE-NEXT:    ldrb w28, [sp, #32]
; NONEON-NOSVE-NEXT:    ldrb w29, [sp, #16]
; NONEON-NOSVE-NEXT:    strb w26, [sp, #111]
; NONEON-NOSVE-NEXT:    strb w9, [sp, #84]
; NONEON-NOSVE-NEXT:    cmp w29, w28
; NONEON-NOSVE-NEXT:    strb w8, [sp, #83]
; NONEON-NOSVE-NEXT:    ldp w9, w8, [sp, #8] // 8-byte Folded Reload
; NONEON-NOSVE-NEXT:    strb w25, [sp, #110]
; NONEON-NOSVE-NEXT:    ldp x26, x25, [sp, #144] // 16-byte Folded Reload
; NONEON-NOSVE-NEXT:    strb w27, [sp, #109]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #81]
; NONEON-NOSVE-NEXT:    csel w8, w29, w28, eq
; NONEON-NOSVE-NEXT:    strb w15, [sp, #108]
; NONEON-NOSVE-NEXT:    ldp x28, x27, [sp, #128] // 16-byte Folded Reload
; NONEON-NOSVE-NEXT:    strb w17, [sp, #107]
; NONEON-NOSVE-NEXT:    ldp x29, x30, [sp, #112] // 16-byte Folded Reload
; NONEON-NOSVE-NEXT:    strb w3, [sp, #106]
; NONEON-NOSVE-NEXT:    strb w4, [sp, #105]
; NONEON-NOSVE-NEXT:    strb w7, [sp, #104]
; NONEON-NOSVE-NEXT:    strb w20, [sp, #103]
; NONEON-NOSVE-NEXT:    strb w23, [sp, #102]
; NONEON-NOSVE-NEXT:    strb w24, [sp, #101]
; NONEON-NOSVE-NEXT:    ldp x24, x23, [sp, #160] // 16-byte Folded Reload
; NONEON-NOSVE-NEXT:    strb w10, [sp, #100]
; NONEON-NOSVE-NEXT:    strb w11, [sp, #97]
; NONEON-NOSVE-NEXT:    strb w22, [sp, #96]
; NONEON-NOSVE-NEXT:    strb w21, [sp, #95]
; NONEON-NOSVE-NEXT:    ldp x22, x21, [sp, #176] // 16-byte Folded Reload
; NONEON-NOSVE-NEXT:    strb w19, [sp, #94]
; NONEON-NOSVE-NEXT:    ldp x20, x19, [sp, #192] // 16-byte Folded Reload
; NONEON-NOSVE-NEXT:    strb w6, [sp, #93]
; NONEON-NOSVE-NEXT:    strb w5, [sp, #92]
; NONEON-NOSVE-NEXT:    strb w2, [sp, #91]
; NONEON-NOSVE-NEXT:    strb w1, [sp, #90]
; NONEON-NOSVE-NEXT:    strb w18, [sp, #89]
; NONEON-NOSVE-NEXT:    strb w16, [sp, #88]
; NONEON-NOSVE-NEXT:    strb w14, [sp, #87]
; NONEON-NOSVE-NEXT:    strb w13, [sp, #86]
; NONEON-NOSVE-NEXT:    strb w12, [sp, #85]
; NONEON-NOSVE-NEXT:    strb w9, [sp, #82]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #80]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #80]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #208
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <32 x i8>, ptr %a
  %op2 = load <32 x i8>, ptr %b
  %mask = icmp eq <32 x i8> %op1, %op2
  %sel = select <32 x i1> %mask, <32 x i8> %op1, <32 x i8> %op2
  store <32 x i8> %sel, ptr %a
  ret void
}

define <2 x i16> @select_v2i16(<2 x i16> %op1, <2 x i16> %op2, <2 x i1> %mask) {
; CHECK-LABEL: select_v2i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $z2
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    lsl z2.s, z2.s, #31
; CHECK-NEXT:    asr z2.s, z2.s, #31
; CHECK-NEXT:    and z2.s, z2.s, #0x1
; CHECK-NEXT:    cmpne p0.s, p0/z, z2.s, #0
; CHECK-NEXT:    sel z0.s, p0, z0.s, z1.s
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: select_v2i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #32
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    stp d1, d2, [sp, #8]
; NONEON-NOSVE-NEXT:    ldp w9, w8, [sp, #16]
; NONEON-NOSVE-NEXT:    str d0, [sp]
; NONEON-NOSVE-NEXT:    ldr w10, [sp, #12]
; NONEON-NOSVE-NEXT:    ldr w11, [sp, #4]
; NONEON-NOSVE-NEXT:    sbfx w8, w8, #0, #1
; NONEON-NOSVE-NEXT:    sbfx w9, w9, #0, #1
; NONEON-NOSVE-NEXT:    cmp w8, #0
; NONEON-NOSVE-NEXT:    csel w8, w11, w10, ne
; NONEON-NOSVE-NEXT:    ldr w10, [sp]
; NONEON-NOSVE-NEXT:    cmp w9, #0
; NONEON-NOSVE-NEXT:    str w8, [sp, #28]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #8]
; NONEON-NOSVE-NEXT:    csel w8, w10, w8, ne
; NONEON-NOSVE-NEXT:    str w8, [sp, #24]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #24]
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %sel = select <2 x i1> %mask, <2 x i16> %op1, <2 x i16> %op2
  ret <2 x i16> %sel
}

define <4 x i16> @select_v4i16(<4 x i16> %op1, <4 x i16> %op2, <4 x i1> %mask) {
; CHECK-LABEL: select_v4i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $z2
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    lsl z2.h, z2.h, #15
; CHECK-NEXT:    asr z2.h, z2.h, #15
; CHECK-NEXT:    and z2.h, z2.h, #0x1
; CHECK-NEXT:    cmpne p0.h, p0/z, z2.h, #0
; CHECK-NEXT:    sel z0.h, p0, z0.h, z1.h
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: select_v4i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #32
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    stp d1, d2, [sp, #8]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #22]
; NONEON-NOSVE-NEXT:    str d0, [sp]
; NONEON-NOSVE-NEXT:    ldrh w11, [sp, #20]
; NONEON-NOSVE-NEXT:    ldrh w12, [sp, #14]
; NONEON-NOSVE-NEXT:    ldrh w13, [sp, #6]
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #18]
; NONEON-NOSVE-NEXT:    sbfx w9, w9, #0, #1
; NONEON-NOSVE-NEXT:    sbfx w11, w11, #0, #1
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #16]
; NONEON-NOSVE-NEXT:    sbfx w10, w10, #0, #1
; NONEON-NOSVE-NEXT:    tst w9, #0xffff
; NONEON-NOSVE-NEXT:    sbfx w8, w8, #0, #1
; NONEON-NOSVE-NEXT:    csel w9, w13, w12, ne
; NONEON-NOSVE-NEXT:    ldrh w12, [sp, #4]
; NONEON-NOSVE-NEXT:    tst w11, #0xffff
; NONEON-NOSVE-NEXT:    strh w9, [sp, #30]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #12]
; NONEON-NOSVE-NEXT:    ldrh w11, [sp, #2]
; NONEON-NOSVE-NEXT:    csel w9, w12, w9, ne
; NONEON-NOSVE-NEXT:    tst w10, #0xffff
; NONEON-NOSVE-NEXT:    ldrh w10, [sp]
; NONEON-NOSVE-NEXT:    strh w9, [sp, #28]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #10]
; NONEON-NOSVE-NEXT:    csel w9, w11, w9, ne
; NONEON-NOSVE-NEXT:    tst w8, #0xffff
; NONEON-NOSVE-NEXT:    strh w9, [sp, #26]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #8]
; NONEON-NOSVE-NEXT:    csel w8, w10, w9, ne
; NONEON-NOSVE-NEXT:    strh w8, [sp, #24]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #24]
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %sel = select <4 x i1> %mask, <4 x i16> %op1, <4 x i16> %op2
  ret <4 x i16> %sel
}

define <8 x i16> @select_v8i16(<8 x i16> %op1, <8 x i16> %op2, <8 x i1> %mask) {
; CHECK-LABEL: select_v8i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $z2
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    uunpklo z2.h, z2.b
; CHECK-NEXT:    lsl z2.h, z2.h, #15
; CHECK-NEXT:    asr z2.h, z2.h, #15
; CHECK-NEXT:    and z2.h, z2.h, #0x1
; CHECK-NEXT:    cmpne p0.h, p0/z, z2.h, #0
; CHECK-NEXT:    sel z0.h, p0, z0.h, z1.h
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: select_v8i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #64
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    str d2, [sp, #40]
; NONEON-NOSVE-NEXT:    ldrb w13, [sp, #47]
; NONEON-NOSVE-NEXT:    stp q0, q1, [sp]
; NONEON-NOSVE-NEXT:    ldrb w15, [sp, #46]
; NONEON-NOSVE-NEXT:    ldrh w16, [sp, #30]
; NONEON-NOSVE-NEXT:    ldrh w17, [sp, #14]
; NONEON-NOSVE-NEXT:    ldrb w14, [sp, #45]
; NONEON-NOSVE-NEXT:    sbfx w13, w13, #0, #1
; NONEON-NOSVE-NEXT:    sbfx w15, w15, #0, #1
; NONEON-NOSVE-NEXT:    ldrb w12, [sp, #44]
; NONEON-NOSVE-NEXT:    sbfx w14, w14, #0, #1
; NONEON-NOSVE-NEXT:    ldrb w11, [sp, #43]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #42]
; NONEON-NOSVE-NEXT:    tst w13, #0xffff
; NONEON-NOSVE-NEXT:    sbfx w12, w12, #0, #1
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #41]
; NONEON-NOSVE-NEXT:    csel w13, w17, w16, ne
; NONEON-NOSVE-NEXT:    ldrh w16, [sp, #12]
; NONEON-NOSVE-NEXT:    tst w15, #0xffff
; NONEON-NOSVE-NEXT:    strh w13, [sp, #62]
; NONEON-NOSVE-NEXT:    ldrh w13, [sp, #28]
; NONEON-NOSVE-NEXT:    ldrh w15, [sp, #10]
; NONEON-NOSVE-NEXT:    sbfx w11, w11, #0, #1
; NONEON-NOSVE-NEXT:    sbfx w10, w10, #0, #1
; NONEON-NOSVE-NEXT:    sbfx w9, w9, #0, #1
; NONEON-NOSVE-NEXT:    csel w13, w16, w13, ne
; NONEON-NOSVE-NEXT:    tst w14, #0xffff
; NONEON-NOSVE-NEXT:    ldrh w14, [sp, #8]
; NONEON-NOSVE-NEXT:    strh w13, [sp, #60]
; NONEON-NOSVE-NEXT:    ldrh w13, [sp, #26]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #40]
; NONEON-NOSVE-NEXT:    csel w13, w15, w13, ne
; NONEON-NOSVE-NEXT:    tst w12, #0xffff
; NONEON-NOSVE-NEXT:    sbfx w8, w8, #0, #1
; NONEON-NOSVE-NEXT:    strh w13, [sp, #58]
; NONEON-NOSVE-NEXT:    ldrh w13, [sp, #24]
; NONEON-NOSVE-NEXT:    csel w12, w14, w13, ne
; NONEON-NOSVE-NEXT:    ldrh w13, [sp, #6]
; NONEON-NOSVE-NEXT:    tst w11, #0xffff
; NONEON-NOSVE-NEXT:    strh w12, [sp, #56]
; NONEON-NOSVE-NEXT:    ldrh w12, [sp, #22]
; NONEON-NOSVE-NEXT:    csel w11, w13, w12, ne
; NONEON-NOSVE-NEXT:    ldrh w12, [sp, #4]
; NONEON-NOSVE-NEXT:    tst w10, #0xffff
; NONEON-NOSVE-NEXT:    strh w11, [sp, #54]
; NONEON-NOSVE-NEXT:    ldrh w11, [sp, #20]
; NONEON-NOSVE-NEXT:    csel w10, w12, w11, ne
; NONEON-NOSVE-NEXT:    ldrh w11, [sp, #2]
; NONEON-NOSVE-NEXT:    tst w9, #0xffff
; NONEON-NOSVE-NEXT:    strh w10, [sp, #52]
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #18]
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, ne
; NONEON-NOSVE-NEXT:    ldrh w10, [sp]
; NONEON-NOSVE-NEXT:    tst w8, #0xffff
; NONEON-NOSVE-NEXT:    strh w9, [sp, #50]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #16]
; NONEON-NOSVE-NEXT:    csel w8, w10, w9, ne
; NONEON-NOSVE-NEXT:    strh w8, [sp, #48]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #48]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %sel = select <8 x i1> %mask, <8 x i16> %op1, <8 x i16> %op2
  ret <8 x i16> %sel
}

define void @select_v16i16(ptr %a, ptr %b) {
; CHECK-LABEL: select_v16i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q2, [x0]
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    ldp q1, q3, [x1]
; CHECK-NEXT:    cmpeq p1.h, p0/z, z0.h, z1.h
; CHECK-NEXT:    cmpeq p0.h, p0/z, z2.h, z3.h
; CHECK-NEXT:    sel z0.h, p1, z0.h, z1.h
; CHECK-NEXT:    sel z1.h, p0, z2.h, z3.h
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: select_v16i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #112
; NONEON-NOSVE-NEXT:    str x19, [sp, #96] // 8-byte Folded Spill
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 112
; NONEON-NOSVE-NEXT:    .cfi_offset w19, -16
; NONEON-NOSVE-NEXT:    ldp q0, q3, [x1]
; NONEON-NOSVE-NEXT:    ldp q1, q2, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #18]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #2]
; NONEON-NOSVE-NEXT:    ldrh w12, [sp, #20]
; NONEON-NOSVE-NEXT:    ldrh w13, [sp, #4]
; NONEON-NOSVE-NEXT:    ldrh w14, [sp, #22]
; NONEON-NOSVE-NEXT:    ldrh w15, [sp, #6]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    ldrh w16, [sp, #24]
; NONEON-NOSVE-NEXT:    ldrh w17, [sp, #8]
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, eq
; NONEON-NOSVE-NEXT:    cmp w13, w12
; NONEON-NOSVE-NEXT:    ldrh w1, [sp, #12]
; NONEON-NOSVE-NEXT:    csel w9, w13, w12, eq
; NONEON-NOSVE-NEXT:    cmp w15, w14
; NONEON-NOSVE-NEXT:    ldrh w12, [sp, #26]
; NONEON-NOSVE-NEXT:    ldrh w13, [sp, #10]
; NONEON-NOSVE-NEXT:    csel w14, w15, w14, eq
; NONEON-NOSVE-NEXT:    cmp w17, w16
; NONEON-NOSVE-NEXT:    csel w16, w17, w16, eq
; NONEON-NOSVE-NEXT:    ldrh w17, [sp, #28]
; NONEON-NOSVE-NEXT:    stp q2, q3, [sp, #32]
; NONEON-NOSVE-NEXT:    cmp w13, w12
; NONEON-NOSVE-NEXT:    ldrh w3, [sp, #30]
; NONEON-NOSVE-NEXT:    ldrh w4, [sp, #14]
; NONEON-NOSVE-NEXT:    csel w12, w13, w12, eq
; NONEON-NOSVE-NEXT:    cmp w1, w17
; NONEON-NOSVE-NEXT:    ldrh w5, [sp, #32]
; NONEON-NOSVE-NEXT:    csel w17, w1, w17, eq
; NONEON-NOSVE-NEXT:    ldrh w1, [sp, #48]
; NONEON-NOSVE-NEXT:    cmp w4, w3
; NONEON-NOSVE-NEXT:    ldrh w6, [sp, #50]
; NONEON-NOSVE-NEXT:    ldrh w7, [sp, #34]
; NONEON-NOSVE-NEXT:    ldrh w2, [sp, #52]
; NONEON-NOSVE-NEXT:    csel w3, w4, w3, eq
; NONEON-NOSVE-NEXT:    ldrh w4, [sp, #36]
; NONEON-NOSVE-NEXT:    cmp w5, w1
; NONEON-NOSVE-NEXT:    ldrh w13, [sp, #54]
; NONEON-NOSVE-NEXT:    ldrh w19, [sp, #38]
; NONEON-NOSVE-NEXT:    csel w1, w5, w1, eq
; NONEON-NOSVE-NEXT:    cmp w7, w6
; NONEON-NOSVE-NEXT:    ldrh w18, [sp, #56]
; NONEON-NOSVE-NEXT:    ldrh w5, [sp, #40]
; NONEON-NOSVE-NEXT:    csel w6, w7, w6, eq
; NONEON-NOSVE-NEXT:    cmp w4, w2
; NONEON-NOSVE-NEXT:    ldrh w15, [sp, #58]
; NONEON-NOSVE-NEXT:    ldrh w7, [sp, #42]
; NONEON-NOSVE-NEXT:    csel w2, w4, w2, eq
; NONEON-NOSVE-NEXT:    cmp w19, w13
; NONEON-NOSVE-NEXT:    ldrh w11, [sp, #60]
; NONEON-NOSVE-NEXT:    ldrh w4, [sp, #44]
; NONEON-NOSVE-NEXT:    csel w13, w19, w13, eq
; NONEON-NOSVE-NEXT:    cmp w5, w18
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #62]
; NONEON-NOSVE-NEXT:    ldrh w19, [sp, #46]
; NONEON-NOSVE-NEXT:    csel w18, w5, w18, eq
; NONEON-NOSVE-NEXT:    cmp w7, w15
; NONEON-NOSVE-NEXT:    ldrh w5, [sp]
; NONEON-NOSVE-NEXT:    csel w15, w7, w15, eq
; NONEON-NOSVE-NEXT:    cmp w4, w11
; NONEON-NOSVE-NEXT:    strh w8, [sp, #66]
; NONEON-NOSVE-NEXT:    csel w11, w4, w11, eq
; NONEON-NOSVE-NEXT:    ldrh w4, [sp, #16]
; NONEON-NOSVE-NEXT:    cmp w19, w10
; NONEON-NOSVE-NEXT:    csel w10, w19, w10, eq
; NONEON-NOSVE-NEXT:    strh w11, [sp, #92]
; NONEON-NOSVE-NEXT:    ldr x19, [sp, #96] // 8-byte Folded Reload
; NONEON-NOSVE-NEXT:    cmp w5, w4
; NONEON-NOSVE-NEXT:    strh w10, [sp, #94]
; NONEON-NOSVE-NEXT:    csel w8, w5, w4, eq
; NONEON-NOSVE-NEXT:    strh w15, [sp, #90]
; NONEON-NOSVE-NEXT:    strh w18, [sp, #88]
; NONEON-NOSVE-NEXT:    strh w13, [sp, #86]
; NONEON-NOSVE-NEXT:    strh w2, [sp, #84]
; NONEON-NOSVE-NEXT:    strh w6, [sp, #82]
; NONEON-NOSVE-NEXT:    strh w1, [sp, #80]
; NONEON-NOSVE-NEXT:    strh w3, [sp, #78]
; NONEON-NOSVE-NEXT:    strh w17, [sp, #76]
; NONEON-NOSVE-NEXT:    strh w12, [sp, #74]
; NONEON-NOSVE-NEXT:    strh w16, [sp, #72]
; NONEON-NOSVE-NEXT:    strh w14, [sp, #70]
; NONEON-NOSVE-NEXT:    strh w9, [sp, #68]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #64]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #64]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #112
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <16 x i16>, ptr %a
  %op2 = load <16 x i16>, ptr %b
  %mask = icmp eq <16 x i16> %op1, %op2
  %sel = select <16 x i1> %mask, <16 x i16> %op1, <16 x i16> %op2
  store <16 x i16> %sel, ptr %a
  ret void
}

define <2 x i32> @select_v2i32(<2 x i32> %op1, <2 x i32> %op2, <2 x i1> %mask) {
; CHECK-LABEL: select_v2i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $z2
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    lsl z2.s, z2.s, #31
; CHECK-NEXT:    asr z2.s, z2.s, #31
; CHECK-NEXT:    and z2.s, z2.s, #0x1
; CHECK-NEXT:    cmpne p0.s, p0/z, z2.s, #0
; CHECK-NEXT:    sel z0.s, p0, z0.s, z1.s
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: select_v2i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #32
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    stp d1, d2, [sp, #8]
; NONEON-NOSVE-NEXT:    ldp w9, w8, [sp, #16]
; NONEON-NOSVE-NEXT:    str d0, [sp]
; NONEON-NOSVE-NEXT:    ldr w10, [sp, #12]
; NONEON-NOSVE-NEXT:    ldr w11, [sp, #4]
; NONEON-NOSVE-NEXT:    sbfx w8, w8, #0, #1
; NONEON-NOSVE-NEXT:    sbfx w9, w9, #0, #1
; NONEON-NOSVE-NEXT:    cmp w8, #0
; NONEON-NOSVE-NEXT:    csel w8, w11, w10, ne
; NONEON-NOSVE-NEXT:    ldr w10, [sp]
; NONEON-NOSVE-NEXT:    cmp w9, #0
; NONEON-NOSVE-NEXT:    str w8, [sp, #28]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #8]
; NONEON-NOSVE-NEXT:    csel w8, w10, w8, ne
; NONEON-NOSVE-NEXT:    str w8, [sp, #24]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #24]
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %sel = select <2 x i1> %mask, <2 x i32> %op1, <2 x i32> %op2
  ret <2 x i32> %sel
}

define <4 x i32> @select_v4i32(<4 x i32> %op1, <4 x i32> %op2, <4 x i1> %mask) {
; CHECK-LABEL: select_v4i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $z2
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    uunpklo z2.s, z2.h
; CHECK-NEXT:    lsl z2.s, z2.s, #31
; CHECK-NEXT:    asr z2.s, z2.s, #31
; CHECK-NEXT:    and z2.s, z2.s, #0x1
; CHECK-NEXT:    cmpne p0.s, p0/z, z2.s, #0
; CHECK-NEXT:    sel z0.s, p0, z0.s, z1.s
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: select_v4i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #64
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    str d2, [sp, #40]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #46]
; NONEON-NOSVE-NEXT:    stp q0, q1, [sp]
; NONEON-NOSVE-NEXT:    ldrh w11, [sp, #44]
; NONEON-NOSVE-NEXT:    ldr w12, [sp, #28]
; NONEON-NOSVE-NEXT:    ldr w13, [sp, #12]
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #42]
; NONEON-NOSVE-NEXT:    sbfx w9, w9, #0, #1
; NONEON-NOSVE-NEXT:    sbfx w11, w11, #0, #1
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #40]
; NONEON-NOSVE-NEXT:    sbfx w10, w10, #0, #1
; NONEON-NOSVE-NEXT:    cmp w9, #0
; NONEON-NOSVE-NEXT:    sbfx w8, w8, #0, #1
; NONEON-NOSVE-NEXT:    csel w9, w13, w12, ne
; NONEON-NOSVE-NEXT:    ldr w12, [sp, #8]
; NONEON-NOSVE-NEXT:    cmp w11, #0
; NONEON-NOSVE-NEXT:    str w9, [sp, #60]
; NONEON-NOSVE-NEXT:    ldr w9, [sp, #24]
; NONEON-NOSVE-NEXT:    ldr w11, [sp, #4]
; NONEON-NOSVE-NEXT:    csel w9, w12, w9, ne
; NONEON-NOSVE-NEXT:    cmp w10, #0
; NONEON-NOSVE-NEXT:    ldr w10, [sp]
; NONEON-NOSVE-NEXT:    str w9, [sp, #56]
; NONEON-NOSVE-NEXT:    ldr w9, [sp, #20]
; NONEON-NOSVE-NEXT:    csel w9, w11, w9, ne
; NONEON-NOSVE-NEXT:    cmp w8, #0
; NONEON-NOSVE-NEXT:    str w9, [sp, #52]
; NONEON-NOSVE-NEXT:    ldr w9, [sp, #16]
; NONEON-NOSVE-NEXT:    csel w8, w10, w9, ne
; NONEON-NOSVE-NEXT:    str w8, [sp, #48]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #48]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %sel = select <4 x i1> %mask, <4 x i32> %op1, <4 x i32> %op2
  ret <4 x i32> %sel
}

define void @select_v8i32(ptr %a, ptr %b) {
; CHECK-LABEL: select_v8i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q2, [x0]
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    ldp q1, q3, [x1]
; CHECK-NEXT:    cmpeq p1.s, p0/z, z0.s, z1.s
; CHECK-NEXT:    cmpeq p0.s, p0/z, z2.s, z3.s
; CHECK-NEXT:    sel z0.s, p1, z0.s, z1.s
; CHECK-NEXT:    sel z1.s, p0, z2.s, z3.s
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: select_v8i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q0, q3, [x1]
; NONEON-NOSVE-NEXT:    ldp q1, q2, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-96]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 96
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #16]
; NONEON-NOSVE-NEXT:    ldp w10, w13, [sp, #4]
; NONEON-NOSVE-NEXT:    ldp w12, w11, [sp, #24]
; NONEON-NOSVE-NEXT:    stp q2, q3, [sp, #32]
; NONEON-NOSVE-NEXT:    ldr w14, [sp, #12]
; NONEON-NOSVE-NEXT:    cmp w10, w9
; NONEON-NOSVE-NEXT:    csel w9, w10, w9, eq
; NONEON-NOSVE-NEXT:    cmp w13, w12
; NONEON-NOSVE-NEXT:    ldp w15, w16, [sp, #48]
; NONEON-NOSVE-NEXT:    csel w12, w13, w12, eq
; NONEON-NOSVE-NEXT:    cmp w14, w11
; NONEON-NOSVE-NEXT:    ldp w10, w13, [sp, #32]
; NONEON-NOSVE-NEXT:    csel w11, w14, w11, eq
; NONEON-NOSVE-NEXT:    ldp w17, w14, [sp, #56]
; NONEON-NOSVE-NEXT:    ldp w18, w1, [sp, #40]
; NONEON-NOSVE-NEXT:    cmp w10, w15
; NONEON-NOSVE-NEXT:    stp w12, w11, [sp, #72]
; NONEON-NOSVE-NEXT:    csel w10, w10, w15, eq
; NONEON-NOSVE-NEXT:    cmp w13, w16
; NONEON-NOSVE-NEXT:    ldr w15, [sp]
; NONEON-NOSVE-NEXT:    csel w13, w13, w16, eq
; NONEON-NOSVE-NEXT:    cmp w18, w17
; NONEON-NOSVE-NEXT:    csel w16, w18, w17, eq
; NONEON-NOSVE-NEXT:    cmp w1, w14
; NONEON-NOSVE-NEXT:    stp w10, w13, [sp, #80]
; NONEON-NOSVE-NEXT:    csel w10, w1, w14, eq
; NONEON-NOSVE-NEXT:    cmp w15, w8
; NONEON-NOSVE-NEXT:    csel w8, w15, w8, eq
; NONEON-NOSVE-NEXT:    stp w16, w10, [sp, #88]
; NONEON-NOSVE-NEXT:    stp w8, w9, [sp, #64]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #64]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #96
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <8 x i32>, ptr %a
  %op2 = load <8 x i32>, ptr %b
  %mask = icmp eq <8 x i32> %op1, %op2
  %sel = select <8 x i1> %mask, <8 x i32> %op1, <8 x i32> %op2
  store <8 x i32> %sel, ptr %a
  ret void
}

define <1 x i64> @select_v1i64(<1 x i64> %op1, <1 x i64> %op2, <1 x i1> %mask) {
; CHECK-LABEL: select_v1i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $w0 killed $w0 def $x0
; CHECK-NEXT:    and x8, x0, #0x1
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    mov z2.d, x8
; CHECK-NEXT:    cmpne p0.d, p0/z, z2.d, #0
; CHECK-NEXT:    sel z0.d, p0, z0.d, z1.d
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: select_v1i64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #16
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    fmov x8, d1
; NONEON-NOSVE-NEXT:    fmov x9, d0
; NONEON-NOSVE-NEXT:    tst w0, #0x1
; NONEON-NOSVE-NEXT:    csel x8, x9, x8, ne
; NONEON-NOSVE-NEXT:    str x8, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #8]
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %sel = select <1 x i1> %mask, <1 x i64> %op1, <1 x i64> %op2
  ret <1 x i64> %sel
}

define <2 x i64> @select_v2i64(<2 x i64> %op1, <2 x i64> %op2, <2 x i1> %mask) {
; CHECK-LABEL: select_v2i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $z2
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    uunpklo z2.d, z2.s
; CHECK-NEXT:    lsl z2.d, z2.d, #63
; CHECK-NEXT:    asr z2.d, z2.d, #63
; CHECK-NEXT:    and z2.d, z2.d, #0x1
; CHECK-NEXT:    cmpne p0.d, p0/z, z2.d, #0
; CHECK-NEXT:    sel z0.d, p0, z0.d, z1.d
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: select_v2i64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #64
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    str d2, [sp, #40]
; NONEON-NOSVE-NEXT:    ldp w9, w8, [sp, #40]
; NONEON-NOSVE-NEXT:    stp q0, q1, [sp]
; NONEON-NOSVE-NEXT:    ldr x10, [sp, #24]
; NONEON-NOSVE-NEXT:    ldr x11, [sp, #8]
; NONEON-NOSVE-NEXT:    sbfx x8, x8, #0, #1
; NONEON-NOSVE-NEXT:    sbfx x9, x9, #0, #1
; NONEON-NOSVE-NEXT:    cmp x8, #0
; NONEON-NOSVE-NEXT:    csel x8, x11, x10, ne
; NONEON-NOSVE-NEXT:    ldr x10, [sp]
; NONEON-NOSVE-NEXT:    cmp x9, #0
; NONEON-NOSVE-NEXT:    str x8, [sp, #56]
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #16]
; NONEON-NOSVE-NEXT:    csel x8, x10, x8, ne
; NONEON-NOSVE-NEXT:    str x8, [sp, #48]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #48]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %sel = select <2 x i1> %mask, <2 x i64> %op1, <2 x i64> %op2
  ret <2 x i64> %sel
}

define void @select_v4i64(ptr %a, ptr %b) {
; CHECK-LABEL: select_v4i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q2, [x0]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    ldp q1, q3, [x1]
; CHECK-NEXT:    cmpeq p1.d, p0/z, z0.d, z1.d
; CHECK-NEXT:    cmpeq p0.d, p0/z, z2.d, z3.d
; CHECK-NEXT:    sel z0.d, p1, z0.d, z1.d
; CHECK-NEXT:    sel z1.d, p0, z2.d, z3.d
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: select_v4i64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q0, q3, [x1]
; NONEON-NOSVE-NEXT:    ldp q1, q2, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-96]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 96
; NONEON-NOSVE-NEXT:    stp q2, q3, [sp, #32]
; NONEON-NOSVE-NEXT:    ldr x9, [sp, #8]
; NONEON-NOSVE-NEXT:    ldp x8, x11, [sp, #24]
; NONEON-NOSVE-NEXT:    ldr x13, [sp, #40]
; NONEON-NOSVE-NEXT:    ldp x10, x12, [sp, #48]
; NONEON-NOSVE-NEXT:    cmp x9, x8
; NONEON-NOSVE-NEXT:    csel x8, x9, x8, eq
; NONEON-NOSVE-NEXT:    cmp x11, x10
; NONEON-NOSVE-NEXT:    csel x9, x11, x10, eq
; NONEON-NOSVE-NEXT:    ldr x10, [sp, #16]
; NONEON-NOSVE-NEXT:    ldr x11, [sp]
; NONEON-NOSVE-NEXT:    cmp x13, x12
; NONEON-NOSVE-NEXT:    csel x12, x13, x12, eq
; NONEON-NOSVE-NEXT:    cmp x11, x10
; NONEON-NOSVE-NEXT:    stp x9, x12, [sp, #80]
; NONEON-NOSVE-NEXT:    csel x9, x11, x10, eq
; NONEON-NOSVE-NEXT:    stp x9, x8, [sp, #64]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #64]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #96
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <4 x i64>, ptr %a
  %op2 = load <4 x i64>, ptr %b
  %mask = icmp eq <4 x i64> %op1, %op2
  %sel = select <4 x i1> %mask, <4 x i64> %op1, <4 x i64> %op2
  store <4 x i64> %sel, ptr %a
  ret void
}
