; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=aarch64 | FileCheck %s --check-prefixes=CHECK,CHECK-SD,CHECK-SD-CVT
; RUN: llc < %s -mtriple=aarch64 -mattr=+fullfp16 | FileCheck %s --check-prefixes=CHECK,CHECK-SD,CHECK-SD-FP16
; RUN: llc < %s -mtriple=aarch64 -global-isel | FileCheck %s --check-prefixes=CHECK,CHECK-GI,CHECK-GI-CVT
; RUN: llc < %s -mtriple=aarch64 -mattr=+fullfp16 -global-isel | FileCheck %s --check-prefixes=CHECK,CHECK-GI,CHECK-GI-FP16

;
; 32-bit float to signed integer
;

declare   i1 @llvm.fptosi.sat.i1.f32  (float)
declare   i8 @llvm.fptosi.sat.i8.f32  (float)
declare  i13 @llvm.fptosi.sat.i13.f32 (float)
declare  i16 @llvm.fptosi.sat.i16.f32 (float)
declare  i19 @llvm.fptosi.sat.i19.f32 (float)
declare  i32 @llvm.fptosi.sat.i32.f32 (float)
declare  i50 @llvm.fptosi.sat.i50.f32 (float)
declare  i64 @llvm.fptosi.sat.i64.f32 (float)
declare i100 @llvm.fptosi.sat.i100.f32(float)
declare i128 @llvm.fptosi.sat.i128.f32(float)

define i1 @test_signed_i1_f32(float %f) nounwind {
; CHECK-SD-LABEL: test_signed_i1_f32:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcvtzs w8, s0
; CHECK-SD-NEXT:    ands w8, w8, w8, asr #31
; CHECK-SD-NEXT:    csinv w8, w8, wzr, ge
; CHECK-SD-NEXT:    and w0, w8, #0x1
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_signed_i1_f32:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fcvtzs w8, s0
; CHECK-GI-NEXT:    cmp w8, #0
; CHECK-GI-NEXT:    csel w8, w8, wzr, lt
; CHECK-GI-NEXT:    cmp w8, #0
; CHECK-GI-NEXT:    csinv w8, w8, wzr, ge
; CHECK-GI-NEXT:    and w0, w8, #0x1
; CHECK-GI-NEXT:    ret
    %x = call i1 @llvm.fptosi.sat.i1.f32(float %f)
    ret i1 %x
}

define i8 @test_signed_i8_f32(float %f) nounwind {
; CHECK-LABEL: test_signed_i8_f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtzs w9, s0
; CHECK-NEXT:    mov w8, #127 // =0x7f
; CHECK-NEXT:    cmp w9, #127
; CHECK-NEXT:    csel w8, w9, w8, lt
; CHECK-NEXT:    mov w9, #-128 // =0xffffff80
; CHECK-NEXT:    cmn w8, #128
; CHECK-NEXT:    csel w0, w8, w9, gt
; CHECK-NEXT:    ret
    %x = call i8 @llvm.fptosi.sat.i8.f32(float %f)
    ret i8 %x
}

define i13 @test_signed_i13_f32(float %f) nounwind {
; CHECK-LABEL: test_signed_i13_f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtzs w9, s0
; CHECK-NEXT:    mov w8, #4095 // =0xfff
; CHECK-NEXT:    cmp w9, #4095
; CHECK-NEXT:    csel w8, w9, w8, lt
; CHECK-NEXT:    mov w9, #-4096 // =0xfffff000
; CHECK-NEXT:    cmn w8, #1, lsl #12 // =4096
; CHECK-NEXT:    csel w0, w8, w9, gt
; CHECK-NEXT:    ret
    %x = call i13 @llvm.fptosi.sat.i13.f32(float %f)
    ret i13 %x
}

define i16 @test_signed_i16_f32(float %f) nounwind {
; CHECK-LABEL: test_signed_i16_f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtzs w8, s0
; CHECK-NEXT:    mov w9, #32767 // =0x7fff
; CHECK-NEXT:    cmp w8, w9
; CHECK-NEXT:    csel w8, w8, w9, lt
; CHECK-NEXT:    mov w9, #-32768 // =0xffff8000
; CHECK-NEXT:    cmn w8, #8, lsl #12 // =32768
; CHECK-NEXT:    csel w0, w8, w9, gt
; CHECK-NEXT:    ret
    %x = call i16 @llvm.fptosi.sat.i16.f32(float %f)
    ret i16 %x
}

define i19 @test_signed_i19_f32(float %f) nounwind {
; CHECK-LABEL: test_signed_i19_f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtzs w8, s0
; CHECK-NEXT:    mov w9, #262143 // =0x3ffff
; CHECK-NEXT:    cmp w8, w9
; CHECK-NEXT:    csel w8, w8, w9, lt
; CHECK-NEXT:    mov w9, #-262144 // =0xfffc0000
; CHECK-NEXT:    cmn w8, #64, lsl #12 // =262144
; CHECK-NEXT:    csel w0, w8, w9, gt
; CHECK-NEXT:    ret
    %x = call i19 @llvm.fptosi.sat.i19.f32(float %f)
    ret i19 %x
}

define i32 @test_signed_i32_f32(float %f) nounwind {
; CHECK-LABEL: test_signed_i32_f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtzs w0, s0
; CHECK-NEXT:    ret
    %x = call i32 @llvm.fptosi.sat.i32.f32(float %f)
    ret i32 %x
}

define i50 @test_signed_i50_f32(float %f) nounwind {
; CHECK-SD-LABEL: test_signed_i50_f32:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcvtzs x8, s0
; CHECK-SD-NEXT:    mov x9, #562949953421311 // =0x1ffffffffffff
; CHECK-SD-NEXT:    cmp x8, x9
; CHECK-SD-NEXT:    csel x8, x8, x9, lt
; CHECK-SD-NEXT:    mov x9, #-562949953421312 // =0xfffe000000000000
; CHECK-SD-NEXT:    cmp x8, x9
; CHECK-SD-NEXT:    csel x0, x8, x9, gt
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_signed_i50_f32:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fcvtzs x8, s0
; CHECK-GI-NEXT:    mov x9, #562949953421311 // =0x1ffffffffffff
; CHECK-GI-NEXT:    mov x10, #-562949953421312 // =0xfffe000000000000
; CHECK-GI-NEXT:    cmp x8, x9
; CHECK-GI-NEXT:    csel x8, x8, x9, lt
; CHECK-GI-NEXT:    cmp x8, x10
; CHECK-GI-NEXT:    csel x0, x8, x10, gt
; CHECK-GI-NEXT:    ret
    %x = call i50 @llvm.fptosi.sat.i50.f32(float %f)
    ret i50 %x
}

define i64 @test_signed_i64_f32(float %f) nounwind {
; CHECK-LABEL: test_signed_i64_f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtzs x0, s0
; CHECK-NEXT:    ret
    %x = call i64 @llvm.fptosi.sat.i64.f32(float %f)
    ret i64 %x
}

define i100 @test_signed_i100_f32(float %f) nounwind {
; CHECK-SD-LABEL: test_signed_i100_f32:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    str d8, [sp, #-16]! // 8-byte Folded Spill
; CHECK-SD-NEXT:    str x30, [sp, #8] // 8-byte Folded Spill
; CHECK-SD-NEXT:    fmov s8, s0
; CHECK-SD-NEXT:    bl __fixsfti
; CHECK-SD-NEXT:    movi v0.2s, #241, lsl #24
; CHECK-SD-NEXT:    mov w8, #1895825407 // =0x70ffffff
; CHECK-SD-NEXT:    mov x10, #34359738367 // =0x7ffffffff
; CHECK-SD-NEXT:    ldr x30, [sp, #8] // 8-byte Folded Reload
; CHECK-SD-NEXT:    fcmp s8, s0
; CHECK-SD-NEXT:    fmov s0, w8
; CHECK-SD-NEXT:    mov x8, #-34359738368 // =0xfffffff800000000
; CHECK-SD-NEXT:    csel x9, xzr, x0, lt
; CHECK-SD-NEXT:    csel x8, x8, x1, lt
; CHECK-SD-NEXT:    fcmp s8, s0
; CHECK-SD-NEXT:    csel x8, x10, x8, gt
; CHECK-SD-NEXT:    csinv x9, x9, xzr, le
; CHECK-SD-NEXT:    fcmp s8, s8
; CHECK-SD-NEXT:    csel x0, xzr, x9, vs
; CHECK-SD-NEXT:    csel x1, xzr, x8, vs
; CHECK-SD-NEXT:    ldr d8, [sp], #16 // 8-byte Folded Reload
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_signed_i100_f32:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    str d8, [sp, #-16]! // 8-byte Folded Spill
; CHECK-GI-NEXT:    str x30, [sp, #8] // 8-byte Folded Spill
; CHECK-GI-NEXT:    fmov s8, s0
; CHECK-GI-NEXT:    bl __fixsfti
; CHECK-GI-NEXT:    movi v0.2s, #241, lsl #24
; CHECK-GI-NEXT:    mov w8, #1895825407 // =0x70ffffff
; CHECK-GI-NEXT:    mov x10, #34359738367 // =0x7ffffffff
; CHECK-GI-NEXT:    ldr x30, [sp, #8] // 8-byte Folded Reload
; CHECK-GI-NEXT:    fcmp s8, s0
; CHECK-GI-NEXT:    fmov s0, w8
; CHECK-GI-NEXT:    mov x8, #34359738368 // =0x800000000
; CHECK-GI-NEXT:    csel x9, xzr, x0, lt
; CHECK-GI-NEXT:    csel x8, x8, x1, lt
; CHECK-GI-NEXT:    fcmp s8, s0
; CHECK-GI-NEXT:    csinv x9, x9, xzr, le
; CHECK-GI-NEXT:    csel x8, x10, x8, gt
; CHECK-GI-NEXT:    fcmp s8, s8
; CHECK-GI-NEXT:    csel x0, xzr, x9, vs
; CHECK-GI-NEXT:    csel x1, xzr, x8, vs
; CHECK-GI-NEXT:    ldr d8, [sp], #16 // 8-byte Folded Reload
; CHECK-GI-NEXT:    ret
    %x = call i100 @llvm.fptosi.sat.i100.f32(float %f)
    ret i100 %x
}

define i128 @test_signed_i128_f32(float %f) nounwind {
; CHECK-SD-LABEL: test_signed_i128_f32:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    str d8, [sp, #-16]! // 8-byte Folded Spill
; CHECK-SD-NEXT:    str x30, [sp, #8] // 8-byte Folded Spill
; CHECK-SD-NEXT:    fmov s8, s0
; CHECK-SD-NEXT:    bl __fixsfti
; CHECK-SD-NEXT:    movi v0.2s, #255, lsl #24
; CHECK-SD-NEXT:    mov w8, #2130706431 // =0x7effffff
; CHECK-SD-NEXT:    mov x10, #9223372036854775807 // =0x7fffffffffffffff
; CHECK-SD-NEXT:    ldr x30, [sp, #8] // 8-byte Folded Reload
; CHECK-SD-NEXT:    fcmp s8, s0
; CHECK-SD-NEXT:    fmov s0, w8
; CHECK-SD-NEXT:    mov x8, #-9223372036854775808 // =0x8000000000000000
; CHECK-SD-NEXT:    csel x9, xzr, x0, lt
; CHECK-SD-NEXT:    csel x8, x8, x1, lt
; CHECK-SD-NEXT:    fcmp s8, s0
; CHECK-SD-NEXT:    csel x8, x10, x8, gt
; CHECK-SD-NEXT:    csinv x9, x9, xzr, le
; CHECK-SD-NEXT:    fcmp s8, s8
; CHECK-SD-NEXT:    csel x0, xzr, x9, vs
; CHECK-SD-NEXT:    csel x1, xzr, x8, vs
; CHECK-SD-NEXT:    ldr d8, [sp], #16 // 8-byte Folded Reload
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_signed_i128_f32:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    str d8, [sp, #-16]! // 8-byte Folded Spill
; CHECK-GI-NEXT:    str x30, [sp, #8] // 8-byte Folded Spill
; CHECK-GI-NEXT:    fmov s8, s0
; CHECK-GI-NEXT:    bl __fixsfti
; CHECK-GI-NEXT:    movi v0.2s, #255, lsl #24
; CHECK-GI-NEXT:    mov w8, #2130706431 // =0x7effffff
; CHECK-GI-NEXT:    mov x10, #9223372036854775807 // =0x7fffffffffffffff
; CHECK-GI-NEXT:    ldr x30, [sp, #8] // 8-byte Folded Reload
; CHECK-GI-NEXT:    fcmp s8, s0
; CHECK-GI-NEXT:    fmov s0, w8
; CHECK-GI-NEXT:    mov x8, #-9223372036854775808 // =0x8000000000000000
; CHECK-GI-NEXT:    csel x9, xzr, x0, lt
; CHECK-GI-NEXT:    csel x8, x8, x1, lt
; CHECK-GI-NEXT:    fcmp s8, s0
; CHECK-GI-NEXT:    csinv x9, x9, xzr, le
; CHECK-GI-NEXT:    csel x8, x10, x8, gt
; CHECK-GI-NEXT:    fcmp s8, s8
; CHECK-GI-NEXT:    csel x0, xzr, x9, vs
; CHECK-GI-NEXT:    csel x1, xzr, x8, vs
; CHECK-GI-NEXT:    ldr d8, [sp], #16 // 8-byte Folded Reload
; CHECK-GI-NEXT:    ret
    %x = call i128 @llvm.fptosi.sat.i128.f32(float %f)
    ret i128 %x
}

;
; 64-bit float to signed integer
;

declare   i1 @llvm.fptosi.sat.i1.f64  (double)
declare   i8 @llvm.fptosi.sat.i8.f64  (double)
declare  i13 @llvm.fptosi.sat.i13.f64 (double)
declare  i16 @llvm.fptosi.sat.i16.f64 (double)
declare  i19 @llvm.fptosi.sat.i19.f64 (double)
declare  i32 @llvm.fptosi.sat.i32.f64 (double)
declare  i50 @llvm.fptosi.sat.i50.f64 (double)
declare  i64 @llvm.fptosi.sat.i64.f64 (double)
declare i100 @llvm.fptosi.sat.i100.f64(double)
declare i128 @llvm.fptosi.sat.i128.f64(double)

define i1 @test_signed_i1_f64(double %f) nounwind {
; CHECK-SD-LABEL: test_signed_i1_f64:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcvtzs w8, d0
; CHECK-SD-NEXT:    ands w8, w8, w8, asr #31
; CHECK-SD-NEXT:    csinv w8, w8, wzr, ge
; CHECK-SD-NEXT:    and w0, w8, #0x1
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_signed_i1_f64:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fcvtzs w8, d0
; CHECK-GI-NEXT:    cmp w8, #0
; CHECK-GI-NEXT:    csel w8, w8, wzr, lt
; CHECK-GI-NEXT:    cmp w8, #0
; CHECK-GI-NEXT:    csinv w8, w8, wzr, ge
; CHECK-GI-NEXT:    and w0, w8, #0x1
; CHECK-GI-NEXT:    ret
    %x = call i1 @llvm.fptosi.sat.i1.f64(double %f)
    ret i1 %x
}

define i8 @test_signed_i8_f64(double %f) nounwind {
; CHECK-LABEL: test_signed_i8_f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtzs w9, d0
; CHECK-NEXT:    mov w8, #127 // =0x7f
; CHECK-NEXT:    cmp w9, #127
; CHECK-NEXT:    csel w8, w9, w8, lt
; CHECK-NEXT:    mov w9, #-128 // =0xffffff80
; CHECK-NEXT:    cmn w8, #128
; CHECK-NEXT:    csel w0, w8, w9, gt
; CHECK-NEXT:    ret
    %x = call i8 @llvm.fptosi.sat.i8.f64(double %f)
    ret i8 %x
}

define i13 @test_signed_i13_f64(double %f) nounwind {
; CHECK-LABEL: test_signed_i13_f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtzs w9, d0
; CHECK-NEXT:    mov w8, #4095 // =0xfff
; CHECK-NEXT:    cmp w9, #4095
; CHECK-NEXT:    csel w8, w9, w8, lt
; CHECK-NEXT:    mov w9, #-4096 // =0xfffff000
; CHECK-NEXT:    cmn w8, #1, lsl #12 // =4096
; CHECK-NEXT:    csel w0, w8, w9, gt
; CHECK-NEXT:    ret
    %x = call i13 @llvm.fptosi.sat.i13.f64(double %f)
    ret i13 %x
}

define i16 @test_signed_i16_f64(double %f) nounwind {
; CHECK-LABEL: test_signed_i16_f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtzs w8, d0
; CHECK-NEXT:    mov w9, #32767 // =0x7fff
; CHECK-NEXT:    cmp w8, w9
; CHECK-NEXT:    csel w8, w8, w9, lt
; CHECK-NEXT:    mov w9, #-32768 // =0xffff8000
; CHECK-NEXT:    cmn w8, #8, lsl #12 // =32768
; CHECK-NEXT:    csel w0, w8, w9, gt
; CHECK-NEXT:    ret
    %x = call i16 @llvm.fptosi.sat.i16.f64(double %f)
    ret i16 %x
}

define i19 @test_signed_i19_f64(double %f) nounwind {
; CHECK-LABEL: test_signed_i19_f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtzs w8, d0
; CHECK-NEXT:    mov w9, #262143 // =0x3ffff
; CHECK-NEXT:    cmp w8, w9
; CHECK-NEXT:    csel w8, w8, w9, lt
; CHECK-NEXT:    mov w9, #-262144 // =0xfffc0000
; CHECK-NEXT:    cmn w8, #64, lsl #12 // =262144
; CHECK-NEXT:    csel w0, w8, w9, gt
; CHECK-NEXT:    ret
    %x = call i19 @llvm.fptosi.sat.i19.f64(double %f)
    ret i19 %x
}

define i32 @test_signed_i32_f64(double %f) nounwind {
; CHECK-LABEL: test_signed_i32_f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtzs w0, d0
; CHECK-NEXT:    ret
    %x = call i32 @llvm.fptosi.sat.i32.f64(double %f)
    ret i32 %x
}

define i50 @test_signed_i50_f64(double %f) nounwind {
; CHECK-SD-LABEL: test_signed_i50_f64:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcvtzs x8, d0
; CHECK-SD-NEXT:    mov x9, #562949953421311 // =0x1ffffffffffff
; CHECK-SD-NEXT:    cmp x8, x9
; CHECK-SD-NEXT:    csel x8, x8, x9, lt
; CHECK-SD-NEXT:    mov x9, #-562949953421312 // =0xfffe000000000000
; CHECK-SD-NEXT:    cmp x8, x9
; CHECK-SD-NEXT:    csel x0, x8, x9, gt
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_signed_i50_f64:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fcvtzs x8, d0
; CHECK-GI-NEXT:    mov x9, #562949953421311 // =0x1ffffffffffff
; CHECK-GI-NEXT:    mov x10, #-562949953421312 // =0xfffe000000000000
; CHECK-GI-NEXT:    cmp x8, x9
; CHECK-GI-NEXT:    csel x8, x8, x9, lt
; CHECK-GI-NEXT:    cmp x8, x10
; CHECK-GI-NEXT:    csel x0, x8, x10, gt
; CHECK-GI-NEXT:    ret
    %x = call i50 @llvm.fptosi.sat.i50.f64(double %f)
    ret i50 %x
}

define i64 @test_signed_i64_f64(double %f) nounwind {
; CHECK-LABEL: test_signed_i64_f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtzs x0, d0
; CHECK-NEXT:    ret
    %x = call i64 @llvm.fptosi.sat.i64.f64(double %f)
    ret i64 %x
}

define i100 @test_signed_i100_f64(double %f) nounwind {
; CHECK-SD-LABEL: test_signed_i100_f64:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    str d8, [sp, #-16]! // 8-byte Folded Spill
; CHECK-SD-NEXT:    str x30, [sp, #8] // 8-byte Folded Spill
; CHECK-SD-NEXT:    fmov d8, d0
; CHECK-SD-NEXT:    bl __fixdfti
; CHECK-SD-NEXT:    mov x8, #-4170333254945079296 // =0xc620000000000000
; CHECK-SD-NEXT:    mov x10, #34359738367 // =0x7ffffffff
; CHECK-SD-NEXT:    ldr x30, [sp, #8] // 8-byte Folded Reload
; CHECK-SD-NEXT:    fmov d0, x8
; CHECK-SD-NEXT:    mov x8, #5053038781909696511 // =0x461fffffffffffff
; CHECK-SD-NEXT:    fcmp d8, d0
; CHECK-SD-NEXT:    fmov d0, x8
; CHECK-SD-NEXT:    mov x8, #-34359738368 // =0xfffffff800000000
; CHECK-SD-NEXT:    csel x9, xzr, x0, lt
; CHECK-SD-NEXT:    csel x8, x8, x1, lt
; CHECK-SD-NEXT:    fcmp d8, d0
; CHECK-SD-NEXT:    csel x8, x10, x8, gt
; CHECK-SD-NEXT:    csinv x9, x9, xzr, le
; CHECK-SD-NEXT:    fcmp d8, d8
; CHECK-SD-NEXT:    csel x0, xzr, x9, vs
; CHECK-SD-NEXT:    csel x1, xzr, x8, vs
; CHECK-SD-NEXT:    ldr d8, [sp], #16 // 8-byte Folded Reload
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_signed_i100_f64:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    str d8, [sp, #-16]! // 8-byte Folded Spill
; CHECK-GI-NEXT:    str x30, [sp, #8] // 8-byte Folded Spill
; CHECK-GI-NEXT:    fmov d8, d0
; CHECK-GI-NEXT:    bl __fixdfti
; CHECK-GI-NEXT:    mov x8, #-4170333254945079296 // =0xc620000000000000
; CHECK-GI-NEXT:    mov x10, #34359738367 // =0x7ffffffff
; CHECK-GI-NEXT:    ldr x30, [sp, #8] // 8-byte Folded Reload
; CHECK-GI-NEXT:    fmov d0, x8
; CHECK-GI-NEXT:    mov x8, #5053038781909696511 // =0x461fffffffffffff
; CHECK-GI-NEXT:    fcmp d8, d0
; CHECK-GI-NEXT:    fmov d0, x8
; CHECK-GI-NEXT:    mov x8, #34359738368 // =0x800000000
; CHECK-GI-NEXT:    csel x9, xzr, x0, lt
; CHECK-GI-NEXT:    csel x8, x8, x1, lt
; CHECK-GI-NEXT:    fcmp d8, d0
; CHECK-GI-NEXT:    csinv x9, x9, xzr, le
; CHECK-GI-NEXT:    csel x8, x10, x8, gt
; CHECK-GI-NEXT:    fcmp d8, d8
; CHECK-GI-NEXT:    csel x0, xzr, x9, vs
; CHECK-GI-NEXT:    csel x1, xzr, x8, vs
; CHECK-GI-NEXT:    ldr d8, [sp], #16 // 8-byte Folded Reload
; CHECK-GI-NEXT:    ret
    %x = call i100 @llvm.fptosi.sat.i100.f64(double %f)
    ret i100 %x
}

define i128 @test_signed_i128_f64(double %f) nounwind {
; CHECK-SD-LABEL: test_signed_i128_f64:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    str d8, [sp, #-16]! // 8-byte Folded Spill
; CHECK-SD-NEXT:    str x30, [sp, #8] // 8-byte Folded Spill
; CHECK-SD-NEXT:    fmov d8, d0
; CHECK-SD-NEXT:    bl __fixdfti
; CHECK-SD-NEXT:    mov x8, #-4044232465378705408 // =0xc7e0000000000000
; CHECK-SD-NEXT:    mov x10, #9223372036854775807 // =0x7fffffffffffffff
; CHECK-SD-NEXT:    ldr x30, [sp, #8] // 8-byte Folded Reload
; CHECK-SD-NEXT:    fmov d0, x8
; CHECK-SD-NEXT:    mov x8, #5179139571476070399 // =0x47dfffffffffffff
; CHECK-SD-NEXT:    fcmp d8, d0
; CHECK-SD-NEXT:    fmov d0, x8
; CHECK-SD-NEXT:    mov x8, #-9223372036854775808 // =0x8000000000000000
; CHECK-SD-NEXT:    csel x9, xzr, x0, lt
; CHECK-SD-NEXT:    csel x8, x8, x1, lt
; CHECK-SD-NEXT:    fcmp d8, d0
; CHECK-SD-NEXT:    csel x8, x10, x8, gt
; CHECK-SD-NEXT:    csinv x9, x9, xzr, le
; CHECK-SD-NEXT:    fcmp d8, d8
; CHECK-SD-NEXT:    csel x0, xzr, x9, vs
; CHECK-SD-NEXT:    csel x1, xzr, x8, vs
; CHECK-SD-NEXT:    ldr d8, [sp], #16 // 8-byte Folded Reload
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_signed_i128_f64:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    str d8, [sp, #-16]! // 8-byte Folded Spill
; CHECK-GI-NEXT:    str x30, [sp, #8] // 8-byte Folded Spill
; CHECK-GI-NEXT:    fmov d8, d0
; CHECK-GI-NEXT:    bl __fixdfti
; CHECK-GI-NEXT:    mov x8, #-4044232465378705408 // =0xc7e0000000000000
; CHECK-GI-NEXT:    mov x10, #9223372036854775807 // =0x7fffffffffffffff
; CHECK-GI-NEXT:    ldr x30, [sp, #8] // 8-byte Folded Reload
; CHECK-GI-NEXT:    fmov d0, x8
; CHECK-GI-NEXT:    mov x8, #5179139571476070399 // =0x47dfffffffffffff
; CHECK-GI-NEXT:    fcmp d8, d0
; CHECK-GI-NEXT:    fmov d0, x8
; CHECK-GI-NEXT:    mov x8, #-9223372036854775808 // =0x8000000000000000
; CHECK-GI-NEXT:    csel x9, xzr, x0, lt
; CHECK-GI-NEXT:    csel x8, x8, x1, lt
; CHECK-GI-NEXT:    fcmp d8, d0
; CHECK-GI-NEXT:    csinv x9, x9, xzr, le
; CHECK-GI-NEXT:    csel x8, x10, x8, gt
; CHECK-GI-NEXT:    fcmp d8, d8
; CHECK-GI-NEXT:    csel x0, xzr, x9, vs
; CHECK-GI-NEXT:    csel x1, xzr, x8, vs
; CHECK-GI-NEXT:    ldr d8, [sp], #16 // 8-byte Folded Reload
; CHECK-GI-NEXT:    ret
    %x = call i128 @llvm.fptosi.sat.i128.f64(double %f)
    ret i128 %x
}

;
; 16-bit float to signed integer
;

declare   i1 @llvm.fptosi.sat.i1.f16  (half)
declare   i8 @llvm.fptosi.sat.i8.f16  (half)
declare  i13 @llvm.fptosi.sat.i13.f16 (half)
declare  i16 @llvm.fptosi.sat.i16.f16 (half)
declare  i19 @llvm.fptosi.sat.i19.f16 (half)
declare  i32 @llvm.fptosi.sat.i32.f16 (half)
declare  i50 @llvm.fptosi.sat.i50.f16 (half)
declare  i64 @llvm.fptosi.sat.i64.f16 (half)
declare i100 @llvm.fptosi.sat.i100.f16(half)
declare i128 @llvm.fptosi.sat.i128.f16(half)

define i1 @test_signed_i1_f16(half %f) nounwind {
; CHECK-SD-CVT-LABEL: test_signed_i1_f16:
; CHECK-SD-CVT:       // %bb.0:
; CHECK-SD-CVT-NEXT:    fcvt s0, h0
; CHECK-SD-CVT-NEXT:    fcvtzs w8, s0
; CHECK-SD-CVT-NEXT:    ands w8, w8, w8, asr #31
; CHECK-SD-CVT-NEXT:    csinv w8, w8, wzr, ge
; CHECK-SD-CVT-NEXT:    and w0, w8, #0x1
; CHECK-SD-CVT-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: test_signed_i1_f16:
; CHECK-SD-FP16:       // %bb.0:
; CHECK-SD-FP16-NEXT:    fcvtzs w8, h0
; CHECK-SD-FP16-NEXT:    ands w8, w8, w8, asr #31
; CHECK-SD-FP16-NEXT:    csinv w8, w8, wzr, ge
; CHECK-SD-FP16-NEXT:    and w0, w8, #0x1
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-CVT-LABEL: test_signed_i1_f16:
; CHECK-GI-CVT:       // %bb.0:
; CHECK-GI-CVT-NEXT:    fcvt s0, h0
; CHECK-GI-CVT-NEXT:    fcvtzs w8, s0
; CHECK-GI-CVT-NEXT:    cmp w8, #0
; CHECK-GI-CVT-NEXT:    csel w8, w8, wzr, lt
; CHECK-GI-CVT-NEXT:    cmp w8, #0
; CHECK-GI-CVT-NEXT:    csinv w8, w8, wzr, ge
; CHECK-GI-CVT-NEXT:    and w0, w8, #0x1
; CHECK-GI-CVT-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: test_signed_i1_f16:
; CHECK-GI-FP16:       // %bb.0:
; CHECK-GI-FP16-NEXT:    fcvtzs w8, h0
; CHECK-GI-FP16-NEXT:    cmp w8, #0
; CHECK-GI-FP16-NEXT:    csel w8, w8, wzr, lt
; CHECK-GI-FP16-NEXT:    cmp w8, #0
; CHECK-GI-FP16-NEXT:    csinv w8, w8, wzr, ge
; CHECK-GI-FP16-NEXT:    and w0, w8, #0x1
; CHECK-GI-FP16-NEXT:    ret
    %x = call i1 @llvm.fptosi.sat.i1.f16(half %f)
    ret i1 %x
}

define i8 @test_signed_i8_f16(half %f) nounwind {
; CHECK-SD-CVT-LABEL: test_signed_i8_f16:
; CHECK-SD-CVT:       // %bb.0:
; CHECK-SD-CVT-NEXT:    fcvt s0, h0
; CHECK-SD-CVT-NEXT:    mov w8, #127 // =0x7f
; CHECK-SD-CVT-NEXT:    fcvtzs w9, s0
; CHECK-SD-CVT-NEXT:    cmp w9, #127
; CHECK-SD-CVT-NEXT:    csel w8, w9, w8, lt
; CHECK-SD-CVT-NEXT:    mov w9, #-128 // =0xffffff80
; CHECK-SD-CVT-NEXT:    cmn w8, #128
; CHECK-SD-CVT-NEXT:    csel w0, w8, w9, gt
; CHECK-SD-CVT-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: test_signed_i8_f16:
; CHECK-SD-FP16:       // %bb.0:
; CHECK-SD-FP16-NEXT:    fcvtzs w9, h0
; CHECK-SD-FP16-NEXT:    mov w8, #127 // =0x7f
; CHECK-SD-FP16-NEXT:    cmp w9, #127
; CHECK-SD-FP16-NEXT:    csel w8, w9, w8, lt
; CHECK-SD-FP16-NEXT:    mov w9, #-128 // =0xffffff80
; CHECK-SD-FP16-NEXT:    cmn w8, #128
; CHECK-SD-FP16-NEXT:    csel w0, w8, w9, gt
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-CVT-LABEL: test_signed_i8_f16:
; CHECK-GI-CVT:       // %bb.0:
; CHECK-GI-CVT-NEXT:    fcvt s0, h0
; CHECK-GI-CVT-NEXT:    mov w8, #127 // =0x7f
; CHECK-GI-CVT-NEXT:    fcvtzs w9, s0
; CHECK-GI-CVT-NEXT:    cmp w9, #127
; CHECK-GI-CVT-NEXT:    csel w8, w9, w8, lt
; CHECK-GI-CVT-NEXT:    mov w9, #-128 // =0xffffff80
; CHECK-GI-CVT-NEXT:    cmn w8, #128
; CHECK-GI-CVT-NEXT:    csel w0, w8, w9, gt
; CHECK-GI-CVT-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: test_signed_i8_f16:
; CHECK-GI-FP16:       // %bb.0:
; CHECK-GI-FP16-NEXT:    fcvtzs w9, h0
; CHECK-GI-FP16-NEXT:    mov w8, #127 // =0x7f
; CHECK-GI-FP16-NEXT:    cmp w9, #127
; CHECK-GI-FP16-NEXT:    csel w8, w9, w8, lt
; CHECK-GI-FP16-NEXT:    mov w9, #-128 // =0xffffff80
; CHECK-GI-FP16-NEXT:    cmn w8, #128
; CHECK-GI-FP16-NEXT:    csel w0, w8, w9, gt
; CHECK-GI-FP16-NEXT:    ret
    %x = call i8 @llvm.fptosi.sat.i8.f16(half %f)
    ret i8 %x
}

define i13 @test_signed_i13_f16(half %f) nounwind {
; CHECK-SD-CVT-LABEL: test_signed_i13_f16:
; CHECK-SD-CVT:       // %bb.0:
; CHECK-SD-CVT-NEXT:    fcvt s0, h0
; CHECK-SD-CVT-NEXT:    mov w8, #4095 // =0xfff
; CHECK-SD-CVT-NEXT:    fcvtzs w9, s0
; CHECK-SD-CVT-NEXT:    cmp w9, #4095
; CHECK-SD-CVT-NEXT:    csel w8, w9, w8, lt
; CHECK-SD-CVT-NEXT:    mov w9, #-4096 // =0xfffff000
; CHECK-SD-CVT-NEXT:    cmn w8, #1, lsl #12 // =4096
; CHECK-SD-CVT-NEXT:    csel w0, w8, w9, gt
; CHECK-SD-CVT-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: test_signed_i13_f16:
; CHECK-SD-FP16:       // %bb.0:
; CHECK-SD-FP16-NEXT:    fcvtzs w9, h0
; CHECK-SD-FP16-NEXT:    mov w8, #4095 // =0xfff
; CHECK-SD-FP16-NEXT:    cmp w9, #4095
; CHECK-SD-FP16-NEXT:    csel w8, w9, w8, lt
; CHECK-SD-FP16-NEXT:    mov w9, #-4096 // =0xfffff000
; CHECK-SD-FP16-NEXT:    cmn w8, #1, lsl #12 // =4096
; CHECK-SD-FP16-NEXT:    csel w0, w8, w9, gt
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-CVT-LABEL: test_signed_i13_f16:
; CHECK-GI-CVT:       // %bb.0:
; CHECK-GI-CVT-NEXT:    fcvt s0, h0
; CHECK-GI-CVT-NEXT:    mov w8, #4095 // =0xfff
; CHECK-GI-CVT-NEXT:    fcvtzs w9, s0
; CHECK-GI-CVT-NEXT:    cmp w9, #4095
; CHECK-GI-CVT-NEXT:    csel w8, w9, w8, lt
; CHECK-GI-CVT-NEXT:    mov w9, #-4096 // =0xfffff000
; CHECK-GI-CVT-NEXT:    cmn w8, #1, lsl #12 // =4096
; CHECK-GI-CVT-NEXT:    csel w0, w8, w9, gt
; CHECK-GI-CVT-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: test_signed_i13_f16:
; CHECK-GI-FP16:       // %bb.0:
; CHECK-GI-FP16-NEXT:    fcvtzs w9, h0
; CHECK-GI-FP16-NEXT:    mov w8, #4095 // =0xfff
; CHECK-GI-FP16-NEXT:    cmp w9, #4095
; CHECK-GI-FP16-NEXT:    csel w8, w9, w8, lt
; CHECK-GI-FP16-NEXT:    mov w9, #-4096 // =0xfffff000
; CHECK-GI-FP16-NEXT:    cmn w8, #1, lsl #12 // =4096
; CHECK-GI-FP16-NEXT:    csel w0, w8, w9, gt
; CHECK-GI-FP16-NEXT:    ret
    %x = call i13 @llvm.fptosi.sat.i13.f16(half %f)
    ret i13 %x
}

define i16 @test_signed_i16_f16(half %f) nounwind {
; CHECK-SD-CVT-LABEL: test_signed_i16_f16:
; CHECK-SD-CVT:       // %bb.0:
; CHECK-SD-CVT-NEXT:    fcvt s0, h0
; CHECK-SD-CVT-NEXT:    mov w9, #32767 // =0x7fff
; CHECK-SD-CVT-NEXT:    fcvtzs w8, s0
; CHECK-SD-CVT-NEXT:    cmp w8, w9
; CHECK-SD-CVT-NEXT:    csel w8, w8, w9, lt
; CHECK-SD-CVT-NEXT:    mov w9, #-32768 // =0xffff8000
; CHECK-SD-CVT-NEXT:    cmn w8, #8, lsl #12 // =32768
; CHECK-SD-CVT-NEXT:    csel w0, w8, w9, gt
; CHECK-SD-CVT-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: test_signed_i16_f16:
; CHECK-SD-FP16:       // %bb.0:
; CHECK-SD-FP16-NEXT:    fcvtzs w8, h0
; CHECK-SD-FP16-NEXT:    mov w9, #32767 // =0x7fff
; CHECK-SD-FP16-NEXT:    cmp w8, w9
; CHECK-SD-FP16-NEXT:    csel w8, w8, w9, lt
; CHECK-SD-FP16-NEXT:    mov w9, #-32768 // =0xffff8000
; CHECK-SD-FP16-NEXT:    cmn w8, #8, lsl #12 // =32768
; CHECK-SD-FP16-NEXT:    csel w0, w8, w9, gt
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-CVT-LABEL: test_signed_i16_f16:
; CHECK-GI-CVT:       // %bb.0:
; CHECK-GI-CVT-NEXT:    fcvt s0, h0
; CHECK-GI-CVT-NEXT:    mov w9, #32767 // =0x7fff
; CHECK-GI-CVT-NEXT:    fcvtzs w8, s0
; CHECK-GI-CVT-NEXT:    cmp w8, w9
; CHECK-GI-CVT-NEXT:    csel w8, w8, w9, lt
; CHECK-GI-CVT-NEXT:    mov w9, #-32768 // =0xffff8000
; CHECK-GI-CVT-NEXT:    cmn w8, #8, lsl #12 // =32768
; CHECK-GI-CVT-NEXT:    csel w0, w8, w9, gt
; CHECK-GI-CVT-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: test_signed_i16_f16:
; CHECK-GI-FP16:       // %bb.0:
; CHECK-GI-FP16-NEXT:    fcvtzs w8, h0
; CHECK-GI-FP16-NEXT:    mov w9, #32767 // =0x7fff
; CHECK-GI-FP16-NEXT:    cmp w8, w9
; CHECK-GI-FP16-NEXT:    csel w8, w8, w9, lt
; CHECK-GI-FP16-NEXT:    mov w9, #-32768 // =0xffff8000
; CHECK-GI-FP16-NEXT:    cmn w8, #8, lsl #12 // =32768
; CHECK-GI-FP16-NEXT:    csel w0, w8, w9, gt
; CHECK-GI-FP16-NEXT:    ret
    %x = call i16 @llvm.fptosi.sat.i16.f16(half %f)
    ret i16 %x
}

define i19 @test_signed_i19_f16(half %f) nounwind {
; CHECK-SD-CVT-LABEL: test_signed_i19_f16:
; CHECK-SD-CVT:       // %bb.0:
; CHECK-SD-CVT-NEXT:    fcvt s0, h0
; CHECK-SD-CVT-NEXT:    mov w9, #262143 // =0x3ffff
; CHECK-SD-CVT-NEXT:    fcvtzs w8, s0
; CHECK-SD-CVT-NEXT:    cmp w8, w9
; CHECK-SD-CVT-NEXT:    csel w8, w8, w9, lt
; CHECK-SD-CVT-NEXT:    mov w9, #-262144 // =0xfffc0000
; CHECK-SD-CVT-NEXT:    cmn w8, #64, lsl #12 // =262144
; CHECK-SD-CVT-NEXT:    csel w0, w8, w9, gt
; CHECK-SD-CVT-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: test_signed_i19_f16:
; CHECK-SD-FP16:       // %bb.0:
; CHECK-SD-FP16-NEXT:    fcvtzs w8, h0
; CHECK-SD-FP16-NEXT:    mov w9, #262143 // =0x3ffff
; CHECK-SD-FP16-NEXT:    cmp w8, w9
; CHECK-SD-FP16-NEXT:    csel w8, w8, w9, lt
; CHECK-SD-FP16-NEXT:    mov w9, #-262144 // =0xfffc0000
; CHECK-SD-FP16-NEXT:    cmn w8, #64, lsl #12 // =262144
; CHECK-SD-FP16-NEXT:    csel w0, w8, w9, gt
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-CVT-LABEL: test_signed_i19_f16:
; CHECK-GI-CVT:       // %bb.0:
; CHECK-GI-CVT-NEXT:    fcvt s0, h0
; CHECK-GI-CVT-NEXT:    mov w9, #262143 // =0x3ffff
; CHECK-GI-CVT-NEXT:    fcvtzs w8, s0
; CHECK-GI-CVT-NEXT:    cmp w8, w9
; CHECK-GI-CVT-NEXT:    csel w8, w8, w9, lt
; CHECK-GI-CVT-NEXT:    mov w9, #-262144 // =0xfffc0000
; CHECK-GI-CVT-NEXT:    cmn w8, #64, lsl #12 // =262144
; CHECK-GI-CVT-NEXT:    csel w0, w8, w9, gt
; CHECK-GI-CVT-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: test_signed_i19_f16:
; CHECK-GI-FP16:       // %bb.0:
; CHECK-GI-FP16-NEXT:    fcvtzs w8, h0
; CHECK-GI-FP16-NEXT:    mov w9, #262143 // =0x3ffff
; CHECK-GI-FP16-NEXT:    cmp w8, w9
; CHECK-GI-FP16-NEXT:    csel w8, w8, w9, lt
; CHECK-GI-FP16-NEXT:    mov w9, #-262144 // =0xfffc0000
; CHECK-GI-FP16-NEXT:    cmn w8, #64, lsl #12 // =262144
; CHECK-GI-FP16-NEXT:    csel w0, w8, w9, gt
; CHECK-GI-FP16-NEXT:    ret
    %x = call i19 @llvm.fptosi.sat.i19.f16(half %f)
    ret i19 %x
}

define i32 @test_signed_i32_f16(half %f) nounwind {
; CHECK-SD-CVT-LABEL: test_signed_i32_f16:
; CHECK-SD-CVT:       // %bb.0:
; CHECK-SD-CVT-NEXT:    fcvt s0, h0
; CHECK-SD-CVT-NEXT:    fcvtzs w0, s0
; CHECK-SD-CVT-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: test_signed_i32_f16:
; CHECK-SD-FP16:       // %bb.0:
; CHECK-SD-FP16-NEXT:    fcvtzs w0, h0
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-CVT-LABEL: test_signed_i32_f16:
; CHECK-GI-CVT:       // %bb.0:
; CHECK-GI-CVT-NEXT:    fcvt s0, h0
; CHECK-GI-CVT-NEXT:    fcvtzs w0, s0
; CHECK-GI-CVT-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: test_signed_i32_f16:
; CHECK-GI-FP16:       // %bb.0:
; CHECK-GI-FP16-NEXT:    fcvtzs w0, h0
; CHECK-GI-FP16-NEXT:    ret
    %x = call i32 @llvm.fptosi.sat.i32.f16(half %f)
    ret i32 %x
}

define i50 @test_signed_i50_f16(half %f) nounwind {
; CHECK-SD-CVT-LABEL: test_signed_i50_f16:
; CHECK-SD-CVT:       // %bb.0:
; CHECK-SD-CVT-NEXT:    fcvt s0, h0
; CHECK-SD-CVT-NEXT:    mov x9, #562949953421311 // =0x1ffffffffffff
; CHECK-SD-CVT-NEXT:    fcvtzs x8, s0
; CHECK-SD-CVT-NEXT:    cmp x8, x9
; CHECK-SD-CVT-NEXT:    csel x8, x8, x9, lt
; CHECK-SD-CVT-NEXT:    mov x9, #-562949953421312 // =0xfffe000000000000
; CHECK-SD-CVT-NEXT:    cmp x8, x9
; CHECK-SD-CVT-NEXT:    csel x0, x8, x9, gt
; CHECK-SD-CVT-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: test_signed_i50_f16:
; CHECK-SD-FP16:       // %bb.0:
; CHECK-SD-FP16-NEXT:    fcvtzs x8, h0
; CHECK-SD-FP16-NEXT:    mov x9, #562949953421311 // =0x1ffffffffffff
; CHECK-SD-FP16-NEXT:    cmp x8, x9
; CHECK-SD-FP16-NEXT:    csel x8, x8, x9, lt
; CHECK-SD-FP16-NEXT:    mov x9, #-562949953421312 // =0xfffe000000000000
; CHECK-SD-FP16-NEXT:    cmp x8, x9
; CHECK-SD-FP16-NEXT:    csel x0, x8, x9, gt
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-CVT-LABEL: test_signed_i50_f16:
; CHECK-GI-CVT:       // %bb.0:
; CHECK-GI-CVT-NEXT:    fcvt s0, h0
; CHECK-GI-CVT-NEXT:    mov x9, #562949953421311 // =0x1ffffffffffff
; CHECK-GI-CVT-NEXT:    mov x10, #-562949953421312 // =0xfffe000000000000
; CHECK-GI-CVT-NEXT:    fcvtzs x8, s0
; CHECK-GI-CVT-NEXT:    cmp x8, x9
; CHECK-GI-CVT-NEXT:    csel x8, x8, x9, lt
; CHECK-GI-CVT-NEXT:    cmp x8, x10
; CHECK-GI-CVT-NEXT:    csel x0, x8, x10, gt
; CHECK-GI-CVT-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: test_signed_i50_f16:
; CHECK-GI-FP16:       // %bb.0:
; CHECK-GI-FP16-NEXT:    fcvtzs x8, h0
; CHECK-GI-FP16-NEXT:    mov x9, #562949953421311 // =0x1ffffffffffff
; CHECK-GI-FP16-NEXT:    mov x10, #-562949953421312 // =0xfffe000000000000
; CHECK-GI-FP16-NEXT:    cmp x8, x9
; CHECK-GI-FP16-NEXT:    csel x8, x8, x9, lt
; CHECK-GI-FP16-NEXT:    cmp x8, x10
; CHECK-GI-FP16-NEXT:    csel x0, x8, x10, gt
; CHECK-GI-FP16-NEXT:    ret
    %x = call i50 @llvm.fptosi.sat.i50.f16(half %f)
    ret i50 %x
}

define i64 @test_signed_i64_f16(half %f) nounwind {
; CHECK-SD-CVT-LABEL: test_signed_i64_f16:
; CHECK-SD-CVT:       // %bb.0:
; CHECK-SD-CVT-NEXT:    fcvt s0, h0
; CHECK-SD-CVT-NEXT:    fcvtzs x0, s0
; CHECK-SD-CVT-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: test_signed_i64_f16:
; CHECK-SD-FP16:       // %bb.0:
; CHECK-SD-FP16-NEXT:    fcvtzs x0, h0
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-CVT-LABEL: test_signed_i64_f16:
; CHECK-GI-CVT:       // %bb.0:
; CHECK-GI-CVT-NEXT:    fcvt s0, h0
; CHECK-GI-CVT-NEXT:    fcvtzs x0, s0
; CHECK-GI-CVT-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: test_signed_i64_f16:
; CHECK-GI-FP16:       // %bb.0:
; CHECK-GI-FP16-NEXT:    fcvtzs x0, h0
; CHECK-GI-FP16-NEXT:    ret
    %x = call i64 @llvm.fptosi.sat.i64.f16(half %f)
    ret i64 %x
}

define i100 @test_signed_i100_f16(half %f) nounwind {
; CHECK-SD-LABEL: test_signed_i100_f16:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    str d8, [sp, #-16]! // 8-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s8, h0
; CHECK-SD-NEXT:    str x30, [sp, #8] // 8-byte Folded Spill
; CHECK-SD-NEXT:    fmov s0, s8
; CHECK-SD-NEXT:    bl __fixsfti
; CHECK-SD-NEXT:    movi v0.2s, #241, lsl #24
; CHECK-SD-NEXT:    mov w8, #1895825407 // =0x70ffffff
; CHECK-SD-NEXT:    mov x10, #34359738367 // =0x7ffffffff
; CHECK-SD-NEXT:    ldr x30, [sp, #8] // 8-byte Folded Reload
; CHECK-SD-NEXT:    fcmp s8, s0
; CHECK-SD-NEXT:    fmov s0, w8
; CHECK-SD-NEXT:    mov x8, #-34359738368 // =0xfffffff800000000
; CHECK-SD-NEXT:    csel x9, xzr, x0, lt
; CHECK-SD-NEXT:    csel x8, x8, x1, lt
; CHECK-SD-NEXT:    fcmp s8, s0
; CHECK-SD-NEXT:    csel x8, x10, x8, gt
; CHECK-SD-NEXT:    csinv x9, x9, xzr, le
; CHECK-SD-NEXT:    fcmp s8, s8
; CHECK-SD-NEXT:    csel x0, xzr, x9, vs
; CHECK-SD-NEXT:    csel x1, xzr, x8, vs
; CHECK-SD-NEXT:    ldr d8, [sp], #16 // 8-byte Folded Reload
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-CVT-LABEL: test_signed_i100_f16:
; CHECK-GI-CVT:       // %bb.0:
; CHECK-GI-CVT-NEXT:    fcvt s0, h0
; CHECK-GI-CVT-NEXT:    mov x1, xzr
; CHECK-GI-CVT-NEXT:    fcvtzs x0, s0
; CHECK-GI-CVT-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: test_signed_i100_f16:
; CHECK-GI-FP16:       // %bb.0:
; CHECK-GI-FP16-NEXT:    fcvtzs x0, h0
; CHECK-GI-FP16-NEXT:    mov x1, xzr
; CHECK-GI-FP16-NEXT:    ret
    %x = call i100 @llvm.fptosi.sat.i100.f16(half %f)
    ret i100 %x
}

define i128 @test_signed_i128_f16(half %f) nounwind {
; CHECK-SD-LABEL: test_signed_i128_f16:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    str d8, [sp, #-16]! // 8-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s8, h0
; CHECK-SD-NEXT:    str x30, [sp, #8] // 8-byte Folded Spill
; CHECK-SD-NEXT:    fmov s0, s8
; CHECK-SD-NEXT:    bl __fixsfti
; CHECK-SD-NEXT:    movi v0.2s, #255, lsl #24
; CHECK-SD-NEXT:    mov w8, #2130706431 // =0x7effffff
; CHECK-SD-NEXT:    mov x10, #9223372036854775807 // =0x7fffffffffffffff
; CHECK-SD-NEXT:    ldr x30, [sp, #8] // 8-byte Folded Reload
; CHECK-SD-NEXT:    fcmp s8, s0
; CHECK-SD-NEXT:    fmov s0, w8
; CHECK-SD-NEXT:    mov x8, #-9223372036854775808 // =0x8000000000000000
; CHECK-SD-NEXT:    csel x9, xzr, x0, lt
; CHECK-SD-NEXT:    csel x8, x8, x1, lt
; CHECK-SD-NEXT:    fcmp s8, s0
; CHECK-SD-NEXT:    csel x8, x10, x8, gt
; CHECK-SD-NEXT:    csinv x9, x9, xzr, le
; CHECK-SD-NEXT:    fcmp s8, s8
; CHECK-SD-NEXT:    csel x0, xzr, x9, vs
; CHECK-SD-NEXT:    csel x1, xzr, x8, vs
; CHECK-SD-NEXT:    ldr d8, [sp], #16 // 8-byte Folded Reload
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-CVT-LABEL: test_signed_i128_f16:
; CHECK-GI-CVT:       // %bb.0:
; CHECK-GI-CVT-NEXT:    fcvt s0, h0
; CHECK-GI-CVT-NEXT:    mov x1, xzr
; CHECK-GI-CVT-NEXT:    fcvtzs x0, s0
; CHECK-GI-CVT-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: test_signed_i128_f16:
; CHECK-GI-FP16:       // %bb.0:
; CHECK-GI-FP16-NEXT:    fcvtzs x0, h0
; CHECK-GI-FP16-NEXT:    mov x1, xzr
; CHECK-GI-FP16-NEXT:    ret
    %x = call i128 @llvm.fptosi.sat.i128.f16(half %f)
    ret i128 %x
}

define i32 @test_signed_f128_i32(fp128 %f) {
; CHECK-SD-LABEL: test_signed_f128_i32:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    sub sp, sp, #32
; CHECK-SD-NEXT:    stp x30, x19, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 32
; CHECK-SD-NEXT:    .cfi_offset w19, -8
; CHECK-SD-NEXT:    .cfi_offset w30, -16
; CHECK-SD-NEXT:    adrp x8, .LCPI30_0
; CHECK-SD-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q1, [x8, :lo12:.LCPI30_0]
; CHECK-SD-NEXT:    bl __getf2
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov w19, w0
; CHECK-SD-NEXT:    bl __fixtfsi
; CHECK-SD-NEXT:    cmp w19, #0
; CHECK-SD-NEXT:    mov w8, #-2147483648 // =0x80000000
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    csel w19, w8, w0, lt
; CHECK-SD-NEXT:    adrp x8, .LCPI30_1
; CHECK-SD-NEXT:    ldr q1, [x8, :lo12:.LCPI30_1]
; CHECK-SD-NEXT:    bl __gttf2
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov w8, #2147483647 // =0x7fffffff
; CHECK-SD-NEXT:    cmp w0, #0
; CHECK-SD-NEXT:    csel w19, w8, w19, gt
; CHECK-SD-NEXT:    mov v1.16b, v0.16b
; CHECK-SD-NEXT:    bl __unordtf2
; CHECK-SD-NEXT:    cmp w0, #0
; CHECK-SD-NEXT:    csel w0, wzr, w19, ne
; CHECK-SD-NEXT:    ldp x30, x19, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    add sp, sp, #32
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_signed_f128_i32:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    sub sp, sp, #48
; CHECK-GI-NEXT:    str x30, [sp, #16] // 8-byte Folded Spill
; CHECK-GI-NEXT:    stp x20, x19, [sp, #32] // 16-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 48
; CHECK-GI-NEXT:    .cfi_offset w19, -8
; CHECK-GI-NEXT:    .cfi_offset w20, -16
; CHECK-GI-NEXT:    .cfi_offset w30, -32
; CHECK-GI-NEXT:    adrp x8, .LCPI30_1
; CHECK-GI-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-GI-NEXT:    ldr q1, [x8, :lo12:.LCPI30_1]
; CHECK-GI-NEXT:    bl __gttf2
; CHECK-GI-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-GI-NEXT:    cmp w0, #0
; CHECK-GI-NEXT:    mov x9, #-4603241769126068224 // =0xc01e000000000000
; CHECK-GI-NEXT:    fmov x8, d0
; CHECK-GI-NEXT:    csel x19, x8, xzr, gt
; CHECK-GI-NEXT:    mov x8, v0.d[1]
; CHECK-GI-NEXT:    mov v0.d[0], x19
; CHECK-GI-NEXT:    csel x20, x8, x9, gt
; CHECK-GI-NEXT:    adrp x8, .LCPI30_0
; CHECK-GI-NEXT:    mov v0.d[1], x20
; CHECK-GI-NEXT:    ldr q1, [x8, :lo12:.LCPI30_0]
; CHECK-GI-NEXT:    bl __lttf2
; CHECK-GI-NEXT:    cmp w0, #0
; CHECK-GI-NEXT:    csel x8, x19, xzr, lt
; CHECK-GI-NEXT:    mov v0.d[0], x8
; CHECK-GI-NEXT:    mov x8, #281474976448512 // =0xfffffffc0000
; CHECK-GI-NEXT:    movk x8, #16413, lsl #48
; CHECK-GI-NEXT:    csel x8, x20, x8, lt
; CHECK-GI-NEXT:    mov v0.d[1], x8
; CHECK-GI-NEXT:    bl __fixtfsi
; CHECK-GI-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov w19, w0
; CHECK-GI-NEXT:    mov v1.16b, v0.16b
; CHECK-GI-NEXT:    bl __unordtf2
; CHECK-GI-NEXT:    cmp w0, #0
; CHECK-GI-NEXT:    ldr x30, [sp, #16] // 8-byte Folded Reload
; CHECK-GI-NEXT:    csel w0, wzr, w19, ne
; CHECK-GI-NEXT:    ldp x20, x19, [sp, #32] // 16-byte Folded Reload
; CHECK-GI-NEXT:    add sp, sp, #48
; CHECK-GI-NEXT:    ret
    %x = call i32 @llvm.fptosi.sat.i32.f128(fp128 %f)
    ret i32 %x
}
