; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mattr=+sve    < %s | FileCheck %s -check-prefixes=CHECK,SVE
; RUN: llc -mattr=+sve2p2 < %s | FileCheck %s -check-prefix CHECK-2p2
; RUN: llc -mattr=+sve,+sme2p2 < %s | FileCheck %s -check-prefix CHECK-2p2

; RUN: llc -mattr=+sme    -force-streaming < %s | FileCheck %s -check-prefixes=CHECK,STREAMING-SVE
; RUN: llc -mattr=+sme2p2 -force-streaming < %s | FileCheck %s -check-prefix CHECK-2p2
; RUN: llc -mattr=+sme,+sve2p2 -force-streaming < %s | FileCheck %s -check-prefix CHECK-2p2

target triple = "aarch64-linux"

define <vscale x 2 x double> @test_svabs_f64_x_1(<vscale x 2 x i1> %pg, <vscale x 2 x double> %x) {
; CHECK-LABEL: test_svabs_f64_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fabs z0.d, p0/m, z0.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svabs_f64_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    fabs z0.d, p0/z, z0.d
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.fabs.nxv2f64(<vscale x 2 x double> poison, <vscale x 2 x i1> %pg, <vscale x 2 x double> %x)
  ret <vscale x 2 x double> %0
}

define <vscale x 2 x double> @test_svabs_f64_x_2(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x double> %x) {
; CHECK-LABEL: test_svabs_f64_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    fabs z0.d, p0/m, z1.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svabs_f64_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    fabs z0.d, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.fabs.nxv2f64(<vscale x 2 x double> poison, <vscale x 2 x i1> %pg, <vscale x 2 x double> %x)
  ret <vscale x 2 x double> %0
}

define <vscale x 2 x double> @test_svabs_f64_z(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x double> %x) {
; SVE-LABEL: test_svabs_f64_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    fabs z0.d, p0/m, z1.d
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svabs_f64_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    fabs z0.d, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svabs_f64_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.d, #0 // =0x0
; STREAMING-SVE-NEXT:    fabs z0.d, p0/m, z1.d
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.fabs.nxv2f64(<vscale x 2 x double> zeroinitializer, <vscale x 2 x i1> %pg, <vscale x 2 x double> %x)
  ret <vscale x 2 x double> %0
}

define <vscale x 4 x float> @test_svabs_f32_x_1(<vscale x 4 x i1> %pg, <vscale x 4 x float> %x) {
; CHECK-LABEL: test_svabs_f32_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fabs z0.s, p0/m, z0.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svabs_f32_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    fabs z0.s, p0/z, z0.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.fabs.nxv4f32(<vscale x 4 x float> poison, <vscale x 4 x i1> %pg, <vscale x 4 x float> %x)
  ret <vscale x 4 x float> %0
}

define <vscale x 4 x float> @test_svabs_f32_x_2(<vscale x 4 x i1> %pg, double %z0, <vscale x 4 x float> %x) {
; CHECK-LABEL: test_svabs_f32_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    fabs z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svabs_f32_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    fabs z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.fabs.nxv4f32(<vscale x 4 x float> poison, <vscale x 4 x i1> %pg, <vscale x 4 x float> %x)
  ret <vscale x 4 x float> %0
}

define <vscale x 4 x float> @test_svabs_f32_z(<vscale x 4 x i1> %pg, double %z0, <vscale x 4 x float> %x) {
; SVE-LABEL: test_svabs_f32_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    fabs z0.s, p0/m, z1.s
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svabs_f32_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    fabs z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svabs_f32_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.s, #0 // =0x0
; STREAMING-SVE-NEXT:    fabs z0.s, p0/m, z1.s
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.fabs.nxv4f32(<vscale x 4 x float> zeroinitializer, <vscale x 4 x i1> %pg, <vscale x 4 x float> %x)
  ret <vscale x 4 x float> %0
}

define <vscale x 8 x half> @test_svabs_f16_x_1(<vscale x 8 x i1> %pg, <vscale x 8 x half> %x) {
; CHECK-LABEL: test_svabs_f16_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fabs z0.h, p0/m, z0.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svabs_f16_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    fabs z0.h, p0/z, z0.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.fabs.nxv8f16(<vscale x 8 x half> poison, <vscale x 8 x i1> %pg, <vscale x 8 x half> %x)
  ret <vscale x 8 x half> %0
}

define <vscale x 8 x half> @test_svabs_f16_x_2(<vscale x 8 x i1> %pg, double %z0, <vscale x 8 x half> %x) {
; CHECK-LABEL: test_svabs_f16_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    fabs z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svabs_f16_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    fabs z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.fabs.nxv8f16(<vscale x 8 x half> poison, <vscale x 8 x i1> %pg, <vscale x 8 x half> %x)
  ret <vscale x 8 x half> %0
}

define <vscale x 8 x half> @test_svabs_f16_z(<vscale x 8 x i1> %pg, double %z0, <vscale x 8 x half> %x) {
; SVE-LABEL: test_svabs_f16_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    fabs z0.h, p0/m, z1.h
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svabs_f16_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    fabs z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svabs_f16_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.h, #0 // =0x0
; STREAMING-SVE-NEXT:    fabs z0.h, p0/m, z1.h
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.fabs.nxv8f16(<vscale x 8 x half> zeroinitializer, <vscale x 8 x i1> %pg, <vscale x 8 x half> %x)
  ret <vscale x 8 x half> %0
}

define <vscale x 16 x i8> @test_svabs_s8_x_1(<vscale x 16 x i1> %pg, <vscale x 16 x i8> %x) {
; CHECK-LABEL: test_svabs_s8_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    abs z0.b, p0/m, z0.b
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svabs_s8_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    abs z0.b, p0/z, z0.b
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 16 x i8> @llvm.aarch64.sve.abs.nxv16i8(<vscale x 16 x i8> poison, <vscale x 16 x i1> %pg, <vscale x 16 x i8> %x)
  ret <vscale x 16 x i8> %0
}

define <vscale x 16 x i8> @test_svabs_s8_x_2(<vscale x 16 x i1> %pg, double %z0, <vscale x 16 x i8> %x) {
; CHECK-LABEL: test_svabs_s8_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    abs z0.b, p0/m, z1.b
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svabs_s8_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    abs z0.b, p0/z, z1.b
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 16 x i8> @llvm.aarch64.sve.abs.nxv16i8(<vscale x 16 x i8> poison, <vscale x 16 x i1> %pg, <vscale x 16 x i8> %x)
  ret <vscale x 16 x i8> %0
}

define <vscale x 16 x i8> @test_svabs_s8_z(<vscale x 16 x i1> %pg, double %z0, <vscale x 16 x i8> %x) {
; SVE-LABEL: test_svabs_s8_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    abs z0.b, p0/m, z1.b
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svabs_s8_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    abs z0.b, p0/z, z1.b
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svabs_s8_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.b, #0 // =0x0
; STREAMING-SVE-NEXT:    abs z0.b, p0/m, z1.b
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 16 x i8> @llvm.aarch64.sve.abs.nxv16i8(<vscale x 16 x i8> zeroinitializer, <vscale x 16 x i1> %pg, <vscale x 16 x i8> %x)
  ret <vscale x 16 x i8> %0
}

define <vscale x 8 x i16> @test_svabs_s16_x_1(<vscale x 8 x i1> %pg, <vscale x 8 x i16> %x) {
; CHECK-LABEL: test_svabs_s16_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    abs z0.h, p0/m, z0.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svabs_s16_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    abs z0.h, p0/z, z0.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i16> @llvm.aarch64.sve.abs.nxv8i16(<vscale x 8 x i16> poison, <vscale x 8 x i1> %pg, <vscale x 8 x i16> %x)
  ret <vscale x 8 x i16> %0
}

define <vscale x 8 x i16> @test_svabs_s16_x_2(<vscale x 8 x i1> %pg, double %z0, <vscale x 8 x i16> %x) {
; CHECK-LABEL: test_svabs_s16_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    abs z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svabs_s16_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    abs z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i16> @llvm.aarch64.sve.abs.nxv8i16(<vscale x 8 x i16> poison, <vscale x 8 x i1> %pg, <vscale x 8 x i16> %x)
  ret <vscale x 8 x i16> %0
}

define <vscale x 8 x i16> @test_svabs_s16_z(<vscale x 8 x i1> %pg, double %z0, <vscale x 8 x i16> %x) {
; SVE-LABEL: test_svabs_s16_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    abs z0.h, p0/m, z1.h
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svabs_s16_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    abs z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svabs_s16_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.h, #0 // =0x0
; STREAMING-SVE-NEXT:    abs z0.h, p0/m, z1.h
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i16> @llvm.aarch64.sve.abs.nxv8i16(<vscale x 8 x i16> zeroinitializer, <vscale x 8 x i1> %pg, <vscale x 8 x i16> %x)
  ret <vscale x 8 x i16> %0
}

define <vscale x 4 x i32> @test_svabs_s32_x_1(<vscale x 4 x i1> %pg, <vscale x 4 x i32> %x) {
; CHECK-LABEL: test_svabs_s32_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    abs z0.s, p0/m, z0.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svabs_s32_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    abs z0.s, p0/z, z0.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i32> @llvm.aarch64.sve.abs.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i1> %pg, <vscale x 4 x i32> %x)
  ret <vscale x 4 x i32> %0
}

define <vscale x 4 x i32> @test_svabs_s32_x_2(<vscale x 4 x i1> %pg, double %z0, <vscale x 4 x i32> %x) {
; CHECK-LABEL: test_svabs_s32_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    abs z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svabs_s32_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    abs z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i32> @llvm.aarch64.sve.abs.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i1> %pg, <vscale x 4 x i32> %x)
  ret <vscale x 4 x i32> %0
}

define <vscale x 4 x i32> @test_svabs_s32_z(<vscale x 4 x i1> %pg, double %z0, <vscale x 4 x i32> %x) {
; SVE-LABEL: test_svabs_s32_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    abs z0.s, p0/m, z1.s
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svabs_s32_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    abs z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svabs_s32_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.s, #0 // =0x0
; STREAMING-SVE-NEXT:    abs z0.s, p0/m, z1.s
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i32> @llvm.aarch64.sve.abs.nxv4i32(<vscale x 4 x i32> zeroinitializer, <vscale x 4 x i1> %pg, <vscale x 4 x i32> %x)
  ret <vscale x 4 x i32> %0
}

define <vscale x 2 x i64> @test_svabs_s64_x_1(<vscale x 2 x i1> %pg, <vscale x 2 x i64> %x) {
; CHECK-LABEL: test_svabs_s64_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    abs z0.d, p0/m, z0.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svabs_s64_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    abs z0.d, p0/z, z0.d
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x i64> @llvm.aarch64.sve.abs.nxv2i64(<vscale x 2 x i64> poison, <vscale x 2 x i1> %pg, <vscale x 2 x i64> %x)
  ret <vscale x 2 x i64> %0
}

define <vscale x 2 x i64> @test_svabs_s64_x_2(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x i64> %x) {
; CHECK-LABEL: test_svabs_s64_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    abs z0.d, p0/m, z1.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svabs_s64_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    abs z0.d, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x i64> @llvm.aarch64.sve.abs.nxv2i64(<vscale x 2 x i64> poison, <vscale x 2 x i1> %pg, <vscale x 2 x i64> %x)
  ret <vscale x 2 x i64> %0
}

define <vscale x 2 x i64> @test_svabs_s64_z(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x i64> %x) {
; SVE-LABEL: test_svabs_s64_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    abs z0.d, p0/m, z1.d
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svabs_s64_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    abs z0.d, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svabs_s64_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.d, #0 // =0x0
; STREAMING-SVE-NEXT:    abs z0.d, p0/m, z1.d
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x i64> @llvm.aarch64.sve.abs.nxv2i64(<vscale x 2 x i64> zeroinitializer, <vscale x 2 x i1> %pg, <vscale x 2 x i64> %x)
  ret <vscale x 2 x i64> %0
}

define <vscale x 2 x double> @test_svneg_f64_x_1(<vscale x 2 x i1> %pg, <vscale x 2 x double> %x) {
; CHECK-LABEL: test_svneg_f64_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fneg z0.d, p0/m, z0.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svneg_f64_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    fneg z0.d, p0/z, z0.d
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.fneg.nxv2f64(<vscale x 2 x double> poison, <vscale x 2 x i1> %pg, <vscale x 2 x double> %x)
  ret <vscale x 2 x double> %0
}

define <vscale x 2 x double> @test_svneg_f64_x_2(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x double> %x) {
; CHECK-LABEL: test_svneg_f64_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    fneg z0.d, p0/m, z1.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svneg_f64_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    fneg z0.d, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.fneg.nxv2f64(<vscale x 2 x double> poison, <vscale x 2 x i1> %pg, <vscale x 2 x double> %x)
  ret <vscale x 2 x double> %0
}

define <vscale x 2 x double> @test_svneg_f64_z(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x double> %x) {
; SVE-LABEL: test_svneg_f64_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    fneg z0.d, p0/m, z1.d
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svneg_f64_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    fneg z0.d, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svneg_f64_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.d, #0 // =0x0
; STREAMING-SVE-NEXT:    fneg z0.d, p0/m, z1.d
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.fneg.nxv2f64(<vscale x 2 x double> zeroinitializer, <vscale x 2 x i1> %pg, <vscale x 2 x double> %x)
  ret <vscale x 2 x double> %0
}

define <vscale x 4 x float> @test_svneg_f32_x_1(<vscale x 4 x i1> %pg, <vscale x 4 x float> %x) {
; CHECK-LABEL: test_svneg_f32_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fneg z0.s, p0/m, z0.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svneg_f32_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    fneg z0.s, p0/z, z0.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.fneg.nxv4f32(<vscale x 4 x float> poison, <vscale x 4 x i1> %pg, <vscale x 4 x float> %x)
  ret <vscale x 4 x float> %0
}

define <vscale x 4 x float> @test_svneg_f32_x_2(<vscale x 4 x i1> %pg, double %z0, <vscale x 4 x float> %x) {
; CHECK-LABEL: test_svneg_f32_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    fneg z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svneg_f32_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    fneg z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.fneg.nxv4f32(<vscale x 4 x float> poison, <vscale x 4 x i1> %pg, <vscale x 4 x float> %x)
  ret <vscale x 4 x float> %0
}

define <vscale x 4 x float> @test_svneg_f32_z(<vscale x 4 x i1> %pg, double %z0, <vscale x 4 x float> %x) {
; SVE-LABEL: test_svneg_f32_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    fneg z0.s, p0/m, z1.s
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svneg_f32_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    fneg z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svneg_f32_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.s, #0 // =0x0
; STREAMING-SVE-NEXT:    fneg z0.s, p0/m, z1.s
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.fneg.nxv4f32(<vscale x 4 x float> zeroinitializer, <vscale x 4 x i1> %pg, <vscale x 4 x float> %x)
  ret <vscale x 4 x float> %0
}

define <vscale x 8 x half> @test_svneg_f16_x_1(<vscale x 8 x i1> %pg, <vscale x 8 x half> %x) {
; CHECK-LABEL: test_svneg_f16_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fneg z0.h, p0/m, z0.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svneg_f16_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    fneg z0.h, p0/z, z0.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.fneg.nxv8f16(<vscale x 8 x half> poison, <vscale x 8 x i1> %pg, <vscale x 8 x half> %x)
  ret <vscale x 8 x half> %0
}

define <vscale x 8 x half> @test_svneg_f16_x_2(<vscale x 8 x i1> %pg, double %z0, <vscale x 8 x half> %x) {
; CHECK-LABEL: test_svneg_f16_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    fneg z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svneg_f16_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    fneg z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.fneg.nxv8f16(<vscale x 8 x half> poison, <vscale x 8 x i1> %pg, <vscale x 8 x half> %x)
  ret <vscale x 8 x half> %0
}

define <vscale x 8 x half> @test_svneg_f16_z(<vscale x 8 x i1> %pg, double %z0, <vscale x 8 x half> %x) {
; SVE-LABEL: test_svneg_f16_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    fneg z0.h, p0/m, z1.h
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svneg_f16_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    fneg z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svneg_f16_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.h, #0 // =0x0
; STREAMING-SVE-NEXT:    fneg z0.h, p0/m, z1.h
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.fneg.nxv8f16(<vscale x 8 x half> zeroinitializer, <vscale x 8 x i1> %pg, <vscale x 8 x half> %x)
  ret <vscale x 8 x half> %0
}

define <vscale x 16 x i8> @test_svneg_s8_x_1(<vscale x 16 x i1> %pg, <vscale x 16 x i8> %x) {
; CHECK-LABEL: test_svneg_s8_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    neg z0.b, p0/m, z0.b
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svneg_s8_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    neg z0.b, p0/z, z0.b
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 16 x i8> @llvm.aarch64.sve.neg.nxv16i8(<vscale x 16 x i8> poison, <vscale x 16 x i1> %pg, <vscale x 16 x i8> %x)
  ret <vscale x 16 x i8> %0
}

define <vscale x 16 x i8> @test_svneg_s8_x_2(<vscale x 16 x i1> %pg, double %z0, <vscale x 16 x i8> %x) {
; CHECK-LABEL: test_svneg_s8_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    neg z0.b, p0/m, z1.b
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svneg_s8_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    neg z0.b, p0/z, z1.b
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 16 x i8> @llvm.aarch64.sve.neg.nxv16i8(<vscale x 16 x i8> poison, <vscale x 16 x i1> %pg, <vscale x 16 x i8> %x)
  ret <vscale x 16 x i8> %0
}

define <vscale x 16 x i8> @test_svneg_s8_z(<vscale x 16 x i1> %pg, double %z0, <vscale x 16 x i8> %x) {
; SVE-LABEL: test_svneg_s8_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    neg z0.b, p0/m, z1.b
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svneg_s8_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    neg z0.b, p0/z, z1.b
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svneg_s8_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.b, #0 // =0x0
; STREAMING-SVE-NEXT:    neg z0.b, p0/m, z1.b
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 16 x i8> @llvm.aarch64.sve.neg.nxv16i8(<vscale x 16 x i8> zeroinitializer, <vscale x 16 x i1> %pg, <vscale x 16 x i8> %x)
  ret <vscale x 16 x i8> %0
}

define <vscale x 8 x i16> @test_svneg_s16_x_1(<vscale x 8 x i1> %pg, <vscale x 8 x i16> %x) {
; CHECK-LABEL: test_svneg_s16_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    neg z0.h, p0/m, z0.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svneg_s16_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    neg z0.h, p0/z, z0.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i16> @llvm.aarch64.sve.neg.nxv8i16(<vscale x 8 x i16> poison, <vscale x 8 x i1> %pg, <vscale x 8 x i16> %x)
  ret <vscale x 8 x i16> %0
}

define <vscale x 8 x i16> @test_svneg_s16_x_2(<vscale x 8 x i1> %pg, double %z0, <vscale x 8 x i16> %x) {
; CHECK-LABEL: test_svneg_s16_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    neg z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svneg_s16_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    neg z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i16> @llvm.aarch64.sve.neg.nxv8i16(<vscale x 8 x i16> poison, <vscale x 8 x i1> %pg, <vscale x 8 x i16> %x)
  ret <vscale x 8 x i16> %0
}

define <vscale x 8 x i16> @test_svneg_s16_z(<vscale x 8 x i1> %pg, double %z0, <vscale x 8 x i16> %x) {
; SVE-LABEL: test_svneg_s16_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    neg z0.h, p0/m, z1.h
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svneg_s16_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    neg z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svneg_s16_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.h, #0 // =0x0
; STREAMING-SVE-NEXT:    neg z0.h, p0/m, z1.h
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i16> @llvm.aarch64.sve.neg.nxv8i16(<vscale x 8 x i16> zeroinitializer, <vscale x 8 x i1> %pg, <vscale x 8 x i16> %x)
  ret <vscale x 8 x i16> %0
}

define <vscale x 4 x i32> @test_svneg_s32_x_1(<vscale x 4 x i1> %pg, <vscale x 4 x i32> %x) {
; CHECK-LABEL: test_svneg_s32_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    neg z0.s, p0/m, z0.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svneg_s32_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    neg z0.s, p0/z, z0.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i32> @llvm.aarch64.sve.neg.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i1> %pg, <vscale x 4 x i32> %x)
  ret <vscale x 4 x i32> %0
}

define <vscale x 4 x i32> @test_svneg_s32_x_2(<vscale x 4 x i1> %pg, double %z0, <vscale x 4 x i32> %x) {
; CHECK-LABEL: test_svneg_s32_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    neg z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svneg_s32_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    neg z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i32> @llvm.aarch64.sve.neg.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i1> %pg, <vscale x 4 x i32> %x)
  ret <vscale x 4 x i32> %0
}

define <vscale x 4 x i32> @test_svneg_s32_z(<vscale x 4 x i1> %pg, double %z0, <vscale x 4 x i32> %x) {
; SVE-LABEL: test_svneg_s32_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    neg z0.s, p0/m, z1.s
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svneg_s32_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    neg z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svneg_s32_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.s, #0 // =0x0
; STREAMING-SVE-NEXT:    neg z0.s, p0/m, z1.s
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i32> @llvm.aarch64.sve.neg.nxv4i32(<vscale x 4 x i32> zeroinitializer, <vscale x 4 x i1> %pg, <vscale x 4 x i32> %x)
  ret <vscale x 4 x i32> %0
}

define <vscale x 2 x i64> @test_svneg_s64_x_1(<vscale x 2 x i1> %pg, <vscale x 2 x i64> %x) {
; CHECK-LABEL: test_svneg_s64_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    neg z0.d, p0/m, z0.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svneg_s64_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    neg z0.d, p0/z, z0.d
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x i64> @llvm.aarch64.sve.neg.nxv2i64(<vscale x 2 x i64> poison, <vscale x 2 x i1> %pg, <vscale x 2 x i64> %x)
  ret <vscale x 2 x i64> %0
}

define <vscale x 2 x i64> @test_svneg_s64_x_2(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x i64> %x) {
; CHECK-LABEL: test_svneg_s64_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    neg z0.d, p0/m, z1.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svneg_s64_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    neg z0.d, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x i64> @llvm.aarch64.sve.neg.nxv2i64(<vscale x 2 x i64> poison, <vscale x 2 x i1> %pg, <vscale x 2 x i64> %x)
  ret <vscale x 2 x i64> %0
}

define <vscale x 2 x i64> @test_svneg_s64_z(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x i64> %x) {
; SVE-LABEL: test_svneg_s64_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    neg z0.d, p0/m, z1.d
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svneg_s64_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    neg z0.d, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svneg_s64_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.d, #0 // =0x0
; STREAMING-SVE-NEXT:    neg z0.d, p0/m, z1.d
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x i64> @llvm.aarch64.sve.neg.nxv2i64(<vscale x 2 x i64> zeroinitializer, <vscale x 2 x i1> %pg, <vscale x 2 x i64> %x)
  ret <vscale x 2 x i64> %0
}

define <vscale x 2 x double> @test_svfabs_f64_ptrue_u(double %z0, <vscale x 2 x double> %x) {
; CHECK-LABEL: test_svfabs_f64_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    fabs z0.d, p0/m, z1.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfabs_f64_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    fabs z0.d, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.fabs.nxv2f64(<vscale x 2 x double> poison, <vscale x 2 x i1> %pg, <vscale x 2 x double> %x)
  ret <vscale x 2 x double> %0
}

define <vscale x 2 x double> @test_svfabs_f64_ptrue(double %z0, <vscale x 2 x double> %x, <vscale x 2 x double> %y) {
; CHECK-LABEL: test_svfabs_f64_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    fabs z0.d, p0/m, z2.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfabs_f64_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    fabs z0.d, p0/z, z2.d
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv4i1(i32 31)
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.fabs.nxv2f64(<vscale x 2 x double> %x, <vscale x 2 x i1> %pg, <vscale x 2 x double> %y)
  ret <vscale x 2 x double> %0
}

define <vscale x 4 x float> @test_svfabs_f32_ptrue_u(double %z0, <vscale x 4 x float> %x) {
; CHECK-LABEL: test_svfabs_f32_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    fabs z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfabs_f32_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.s
; CHECK-2p2-NEXT:    fabs z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 4 x i1> @llvm.aarch64.sve.ptrue.nxv4i1(i32 31)
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.fabs.nxv4f32(<vscale x 4 x float> poison, <vscale x 4 x i1> %pg, <vscale x 4 x float> %x)
  ret <vscale x 4 x float> %0
}

define <vscale x 4 x float> @test_svfabs_f32_ptrue(double %z0, <vscale x 4 x float> %x, <vscale x 4 x float> %y) {
; CHECK-LABEL: test_svfabs_f32_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    fabs z0.s, p0/m, z2.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfabs_f32_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.s
; CHECK-2p2-NEXT:    fabs z0.s, p0/z, z2.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 4 x i1> @llvm.aarch64.sve.ptrue.nxv4i1(i32 31)
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.fabs.nxv4f32(<vscale x 4 x float> %x, <vscale x 4 x i1> %pg, <vscale x 4 x float> %y)
  ret <vscale x 4 x float> %0
}

define <vscale x 8 x half> @test_svfabs_f16_ptrue_u(double %z0, <vscale x 8 x half> %x) {
; CHECK-LABEL: test_svfabs_f16_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    fabs z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfabs_f16_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.h
; CHECK-2p2-NEXT:    fabs z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 8 x i1> @llvm.aarch64.sve.ptrue.nxv8i1(i32 31)
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.fabs.nxv8f16(<vscale x 8 x half> poison, <vscale x 8 x i1> %pg, <vscale x 8 x half> %x)
  ret <vscale x 8 x half> %0
}

define <vscale x 8 x half> @test_svfabs_f16_ptrue(double %z0, <vscale x 8 x half> %x, <vscale x 8 x half> %y) {
; CHECK-LABEL: test_svfabs_f16_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    fabs z0.h, p0/m, z2.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfabs_f16_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.h
; CHECK-2p2-NEXT:    fabs z0.h, p0/z, z2.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 8 x i1> @llvm.aarch64.sve.ptrue.nxv8i1(i32 31)
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.fabs.nxv8f16(<vscale x 8 x half> %x, <vscale x 8 x i1> %pg, <vscale x 8 x half> %y)
  ret <vscale x 8 x half> %0
}

define <vscale x 16 x i8> @test_svabs_s8_ptrue_u(double %z0, <vscale x 16 x i8> %x) {
; CHECK-LABEL: test_svabs_s8_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    abs z0.b, p0/m, z1.b
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svabs_s8_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.b
; CHECK-2p2-NEXT:    abs z0.b, p0/z, z1.b
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 16 x i1> @llvm.aarch64.sve.ptrue.nxv16i1(i32 31)
  %0 = tail call <vscale x 16 x i8> @llvm.aarch64.sve.abs.nxv16i8(<vscale x 16 x i8> poison, <vscale x 16 x i1> %pg, <vscale x 16 x i8> %x)
  ret <vscale x 16 x i8> %0
}

define <vscale x 16 x i8> @test_svabs_s8_ptrue(double %z0, <vscale x 16 x i8> %x, <vscale x 16 x i8> %y) {
; CHECK-LABEL: test_svabs_s8_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    abs z0.b, p0/m, z2.b
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svabs_s8_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.b
; CHECK-2p2-NEXT:    abs z0.b, p0/z, z2.b
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 16 x i1> @llvm.aarch64.sve.ptrue.nxv16i1(i32 31)
  %0 = tail call <vscale x 16 x i8> @llvm.aarch64.sve.abs.nxv16i8(<vscale x 16 x i8> %x, <vscale x 16 x i1> %pg, <vscale x 16 x i8> %y)
  ret <vscale x 16 x i8> %0
}

define <vscale x 8 x i16> @test_svabs_s16_ptrue_u(double %z0, <vscale x 8 x i16> %x) {
; CHECK-LABEL: test_svabs_s16_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    abs z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svabs_s16_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.h
; CHECK-2p2-NEXT:    abs z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 8 x i1> @llvm.aarch64.sve.ptrue.nx84i1(i32 31)
  %0 = tail call <vscale x 8 x i16> @llvm.aarch64.sve.abs.nxv8i16(<vscale x 8 x i16> poison, <vscale x 8 x i1> %pg, <vscale x 8 x i16> %x)
  ret <vscale x 8 x i16> %0
}

define <vscale x 8 x i16> @test_svabs_s16_ptrue(double %z0, <vscale x 8 x i16> %x, <vscale x 8 x i16> %y) {
; CHECK-LABEL: test_svabs_s16_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    abs z0.h, p0/m, z2.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svabs_s16_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.h
; CHECK-2p2-NEXT:    abs z0.h, p0/z, z2.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 8 x i1> @llvm.aarch64.sve.ptrue.nxv8i1(i32 31)
  %0 = tail call <vscale x 8 x i16> @llvm.aarch64.sve.abs.nxv8i16(<vscale x 8 x i16> %x, <vscale x 8 x i1> %pg, <vscale x 8 x i16> %y)
  ret <vscale x 8 x i16> %0
}

define <vscale x 4 x i32> @test_svabs_s32_ptrue_u(double %z0, <vscale x 4 x i32> %x) {
; CHECK-LABEL: test_svabs_s32_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    abs z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svabs_s32_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.s
; CHECK-2p2-NEXT:    abs z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 4 x i1> @llvm.aarch64.sve.ptrue.nxv4i1(i32 31)
  %0 = tail call <vscale x 4 x i32> @llvm.aarch64.sve.abs.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i1> %pg, <vscale x 4 x i32> %x)
  ret <vscale x 4 x i32> %0
}

define <vscale x 4 x i32> @test_svabs_s32_ptrue(double %z0, <vscale x 4 x i32> %x, <vscale x 4 x i32> %y) {
; CHECK-LABEL: test_svabs_s32_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    abs z0.s, p0/m, z2.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svabs_s32_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.s
; CHECK-2p2-NEXT:    abs z0.s, p0/z, z2.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 4 x i1> @llvm.aarch64.sve.ptrue.nxv4i1(i32 31)
  %0 = tail call <vscale x 4 x i32> @llvm.aarch64.sve.abs.nxv4i32(<vscale x 4 x i32> %x, <vscale x 4 x i1> %pg, <vscale x 4 x i32> %y)
  ret <vscale x 4 x i32> %0
}

define <vscale x 2 x i64> @test_svabs_s64_ptrue_u(double %z0, <vscale x 2 x i64> %x) {
; CHECK-LABEL: test_svabs_s64_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    abs z0.d, p0/m, z1.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svabs_s64_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    abs z0.d, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x i64> @llvm.aarch64.sve.abs.nxv2i64(<vscale x 2 x i64> poison, <vscale x 2 x i1> %pg, <vscale x 2 x i64> %x)
  ret <vscale x 2 x i64> %0
}

define <vscale x 2 x i64> @test_svabs_s64_ptrue(double %z0, <vscale x 2 x i64> %x, <vscale x 2 x i64> %y) {
; CHECK-LABEL: test_svabs_s64_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    abs z0.d, p0/m, z2.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svabs_s64_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    abs z0.d, p0/z, z2.d
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x i64> @llvm.aarch64.sve.abs.nxv2i64(<vscale x 2 x i64> %x, <vscale x 2 x i1> %pg, <vscale x 2 x i64> %y)
  ret <vscale x 2 x i64> %0
}

define <vscale x 2 x double> @test_svfneg_f64_ptrue_u(double %z0, <vscale x 2 x double> %x) {
; CHECK-LABEL: test_svfneg_f64_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    fneg z0.d, p0/m, z1.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfneg_f64_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    fneg z0.d, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.fneg.nxv2f64(<vscale x 2 x double> poison, <vscale x 2 x i1> %pg, <vscale x 2 x double> %x)
  ret <vscale x 2 x double> %0
}

define <vscale x 2 x double> @test_svfneg_f64_ptrue(double %z0, <vscale x 2 x double> %x, <vscale x 2 x double> %y) {
; CHECK-LABEL: test_svfneg_f64_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    fneg z0.d, p0/m, z2.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfneg_f64_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    fneg z0.d, p0/z, z2.d
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.fneg.nxv2f64(<vscale x 2 x double> %x, <vscale x 2 x i1> %pg, <vscale x 2 x double> %y)
  ret <vscale x 2 x double> %0
}

define <vscale x 4 x float> @test_svfneg_f32_ptrue_u(double %z0, <vscale x 4 x float> %x) {
; CHECK-LABEL: test_svfneg_f32_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    fneg z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfneg_f32_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.s
; CHECK-2p2-NEXT:    fneg z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 4 x i1> @llvm.aarch64.sve.ptrue.nxv4i1(i32 31)
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.fneg.nxv4f32(<vscale x 4 x float> poison, <vscale x 4 x i1> %pg, <vscale x 4 x float> %x)
  ret <vscale x 4 x float> %0
}

define <vscale x 4 x float> @test_svfneg_f32_ptrue(double %z0, <vscale x 4 x float> %x, <vscale x 4 x float> %y) {
; CHECK-LABEL: test_svfneg_f32_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    fneg z0.s, p0/m, z2.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfneg_f32_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.s
; CHECK-2p2-NEXT:    fneg z0.s, p0/z, z2.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 4 x i1> @llvm.aarch64.sve.ptrue.nxv4i1(i32 31)
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.fneg.nxv4f32(<vscale x 4 x float> %x, <vscale x 4 x i1> %pg, <vscale x 4 x float> %y)
  ret <vscale x 4 x float> %0
}

define <vscale x 8 x half> @test_svfneg_f16_ptrue_u(double %z0, <vscale x 8 x half> %x) {
; CHECK-LABEL: test_svfneg_f16_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    fneg z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfneg_f16_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.h
; CHECK-2p2-NEXT:    fneg z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 8 x i1> @llvm.aarch64.sve.ptrue.nxv8i1(i32 31)
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.fneg.nxv8f16(<vscale x 8 x half> poison, <vscale x 8 x i1> %pg, <vscale x 8 x half> %x)
  ret <vscale x 8 x half> %0
}

define <vscale x 8 x half> @test_svfneg_f16_ptrue(double %z0, <vscale x 8 x half> %x, <vscale x 8 x half> %y) {
; CHECK-LABEL: test_svfneg_f16_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    fneg z0.h, p0/m, z2.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfneg_f16_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.h
; CHECK-2p2-NEXT:    fneg z0.h, p0/z, z2.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 8 x i1> @llvm.aarch64.sve.ptrue.nxv8i1(i32 31)
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.fneg.nxv8f16(<vscale x 8 x half> %x, <vscale x 8 x i1> %pg, <vscale x 8 x half> %y)
  ret <vscale x 8 x half> %0
}

define <vscale x 16 x i8> @test_svneg_s8_ptrue_u(double %z0, <vscale x 16 x i8> %x) {
; CHECK-LABEL: test_svneg_s8_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    neg z0.b, p0/m, z1.b
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svneg_s8_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.b
; CHECK-2p2-NEXT:    neg z0.b, p0/z, z1.b
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 16 x i1> @llvm.aarch64.sve.ptrue.nxv16i1(i32 31)
  %0 = tail call <vscale x 16 x i8> @llvm.aarch64.sve.neg.nxv16i8(<vscale x 16 x i8> poison, <vscale x 16 x i1> %pg, <vscale x 16 x i8> %x)
  ret <vscale x 16 x i8> %0
}

define <vscale x 16 x i8> @test_svneg_s8_ptrue(double %z0, <vscale x 16 x i8> %x, <vscale x 16 x i8> %y) {
; CHECK-LABEL: test_svneg_s8_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    neg z0.b, p0/m, z2.b
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svneg_s8_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.b
; CHECK-2p2-NEXT:    neg z0.b, p0/z, z2.b
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 16 x i1> @llvm.aarch64.sve.ptrue.nxv16i1(i32 31)
  %0 = tail call <vscale x 16 x i8> @llvm.aarch64.sve.neg.nxv16i8(<vscale x 16 x i8> %x, <vscale x 16 x i1> %pg, <vscale x 16 x i8> %y)
  ret <vscale x 16 x i8> %0
}

define <vscale x 8 x i16> @test_svneg_s16_ptrue_u(double %z0, <vscale x 8 x i16> %x) {
; CHECK-LABEL: test_svneg_s16_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    neg z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svneg_s16_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.h
; CHECK-2p2-NEXT:    neg z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 8 x i1> @llvm.aarch64.sve.ptrue.nxv8i1(i32 31)
  %0 = tail call <vscale x 8 x i16> @llvm.aarch64.sve.neg.nxv8i16(<vscale x 8 x i16> poison, <vscale x 8 x i1> %pg, <vscale x 8 x i16> %x)
  ret <vscale x 8 x i16> %0
}

define <vscale x 8 x i16> @test_svneg_s16_ptrue(double %z0, <vscale x 8 x i16> %x, <vscale x 8 x i16> %y) {
; CHECK-LABEL: test_svneg_s16_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    neg z0.h, p0/m, z2.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svneg_s16_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.h
; CHECK-2p2-NEXT:    neg z0.h, p0/z, z2.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 8 x i1> @llvm.aarch64.sve.ptrue.nxv8i1(i32 31)
  %0 = tail call <vscale x 8 x i16> @llvm.aarch64.sve.neg.nxv8i16(<vscale x 8 x i16> %x, <vscale x 8 x i1> %pg, <vscale x 8 x i16> %y)
  ret <vscale x 8 x i16> %0
}

define <vscale x 4 x i32> @test_svneg_s32_ptrue_u(double %z0, <vscale x 4 x i32> %x) {
; CHECK-LABEL: test_svneg_s32_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    neg z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svneg_s32_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.s
; CHECK-2p2-NEXT:    neg z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 4 x i1> @llvm.aarch64.sve.ptrue.nxv4i1(i32 31)
  %0 = tail call <vscale x 4 x i32> @llvm.aarch64.sve.neg.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i1> %pg, <vscale x 4 x i32> %x)
  ret <vscale x 4 x i32> %0
}

define <vscale x 4 x i32> @test_svneg_s32_ptrue(double %z0, <vscale x 4 x i32> %x, <vscale x 4 x i32> %y) {
; CHECK-LABEL: test_svneg_s32_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    neg z0.s, p0/m, z2.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svneg_s32_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.s
; CHECK-2p2-NEXT:    neg z0.s, p0/z, z2.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 4 x i1> @llvm.aarch64.sve.ptrue.nxv4i1(i32 31)
  %0 = tail call <vscale x 4 x i32> @llvm.aarch64.sve.neg.nxv4i32(<vscale x 4 x i32> %x, <vscale x 4 x i1> %pg, <vscale x 4 x i32> %y)
  ret <vscale x 4 x i32> %0
}

define <vscale x 2 x i64> @test_svneg_s64_ptrue_u(double %z0, <vscale x 2 x i64> %x) {
; CHECK-LABEL: test_svneg_s64_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    neg z0.d, p0/m, z1.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svneg_s64_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    neg z0.d, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x i64> @llvm.aarch64.sve.neg.nxv2i64(<vscale x 2 x i64> poison, <vscale x 2 x i1> %pg, <vscale x 2 x i64> %x)
  ret <vscale x 2 x i64> %0
}

define <vscale x 2 x i64> @test_svneg_s64_ptrue(double %z0, <vscale x 2 x i64> %x, <vscale x 2 x i64> %y) {
; CHECK-LABEL: test_svneg_s64_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    neg z0.d, p0/m, z2.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svneg_s64_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    neg z0.d, p0/z, z2.d
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x i64> @llvm.aarch64.sve.neg.nxv2i64(<vscale x 2 x i64> %x, <vscale x 2 x i1> %pg, <vscale x 2 x i64> %y)
  ret <vscale x 2 x i64> %0
}
