; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686--| FileCheck %s --check-prefixes=X86
; RUN: llc < %s -mtriple=x86_64--| FileCheck %s --check-prefixes=X64

;
; PR6146
;

define i32 @cmp_xor_i32(i32 %a, i32 %b, i32 %c)
; X86-LABEL: cmp_xor_i32:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    xorl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    jne .LBB0_2
; X86-NEXT:  # %bb.1:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:  .LBB0_2:
; X86-NEXT:    retl
;
; X64-LABEL: cmp_xor_i32:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    xorl %esi, %eax
; X64-NEXT:    cmovel %edx, %eax
; X64-NEXT:    retq
{
  %xor = xor i32 %a, %b
  %cmp = icmp eq i32 %a, %b
  %sel = select i1 %cmp, i32 %c, i32 %xor
  ret i32 %sel
}

define i32 @cmp_xor_i32_commute(i32 %a, i32 %b, i32 %c)
; X86-LABEL: cmp_xor_i32_commute:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    xorl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    jne .LBB1_2
; X86-NEXT:  # %bb.1:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:  .LBB1_2:
; X86-NEXT:    retl
;
; X64-LABEL: cmp_xor_i32_commute:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    xorl %esi, %eax
; X64-NEXT:    cmovel %edx, %eax
; X64-NEXT:    retq
{
  %xor = xor i32 %b, %a
  %cmp = icmp eq i32 %a, %b
  %sel = select i1 %cmp, i32 %c, i32 %xor
  ret i32 %sel
}

