# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=riscv64 -mcpu=sifive-x390 -instruction-tables=full -iterations=1 < %s \
# RUN:   | FileCheck %s

div a0, a1, a2
fdiv.s f1, f2, f3

# CHECK:      Resources:
# CHECK-NEXT: [0]   - VLEN1024X300SiFive7FDiv:1
# CHECK-NEXT: [1]   - VLEN1024X300SiFive7IDiv:1
# CHECK-NEXT: [2]   - VLEN1024X300SiFive7PipeA:1
# CHECK-NEXT: [3]   - VLEN1024X300SiFive7PipeAB:2 VLEN1024X300SiFive7PipeA, VLEN1024X300SiFive7PipeB
# CHECK-NEXT: [4]   - VLEN1024X300SiFive7PipeB:1
# CHECK-NEXT: [5]   - VLEN1024X300SiFive7VA1:1
# CHECK-NEXT: [6]   - VLEN1024X300SiFive7VA1OrVA2:2 VLEN1024X300SiFive7VA1, VLEN1024X300SiFive7VA2
# CHECK-NEXT: [7]   - VLEN1024X300SiFive7VA2:1
# CHECK-NEXT: [8]   - VLEN1024X300SiFive7VCQ:1
# CHECK-NEXT: [9]   - VLEN1024X300SiFive7VL:1
# CHECK-NEXT: [10]  - VLEN1024X300SiFive7VS:1

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)
# CHECK-NEXT: [7]: Bypass Latency
# CHECK-NEXT: [8]: Resources (<Name> | <Name>[<ReleaseAtCycle>] | <Name>[<AcquireAtCycle>,<ReleaseAtCycle])
# CHECK-NEXT: [9]: LLVM Opcode Name

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]                                        [9]                        Instructions:
# CHECK-NEXT:  1      66    65.00                        66    VLEN1024X300SiFive7IDiv[65],VLEN1024X300SiFive7PipeAB,VLEN1024X300SiFive7PipeB DIV div	a0, a1, a2
# CHECK-NEXT:  1      27    26.00                        27    VLEN1024X300SiFive7FDiv[26],VLEN1024X300SiFive7PipeAB,VLEN1024X300SiFive7PipeB FDIV_S fdiv.s	ft1, ft2, ft3

# CHECK:      Resources:
# CHECK-NEXT: [0]   - VLEN1024X300SiFive7FDiv
# CHECK-NEXT: [1]   - VLEN1024X300SiFive7IDiv
# CHECK-NEXT: [2]   - VLEN1024X300SiFive7PipeA
# CHECK-NEXT: [3]   - VLEN1024X300SiFive7PipeB
# CHECK-NEXT: [4]   - VLEN1024X300SiFive7VA1
# CHECK-NEXT: [5]   - VLEN1024X300SiFive7VA2
# CHECK-NEXT: [6]   - VLEN1024X300SiFive7VCQ
# CHECK-NEXT: [7]   - VLEN1024X300SiFive7VL
# CHECK-NEXT: [8]   - VLEN1024X300SiFive7VS

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]
# CHECK-NEXT: 26.00  65.00   -     2.00    -      -      -      -      -

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    Instructions:
# CHECK-NEXT:  -     65.00   -     1.00    -      -      -      -      -     div	a0, a1, a2
# CHECK-NEXT: 26.00   -      -     1.00    -      -      -      -      -     fdiv.s	ft1, ft2, ft3
