; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=instsimplify < %s -S | FileCheck %s

define i1 @phi_ugt_non_zero(i8 %x) {
; CHECK-LABEL: @phi_ugt_non_zero(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp ugt i8 [[X:%.*]], 32
; CHECK-NEXT:    br i1 [[CMP]], label [[T:%.*]], label [[F:%.*]]
; CHECK:       T:
; CHECK-NEXT:    ret i1 false
; CHECK:       F:
; CHECK-NEXT:    br label [[T]]
;
entry:
  %cmp = icmp ugt i8 %x, 32
  br i1 %cmp, label %T, label %F
T:
  %v = phi i8 [ %x, %entry], [-1, %F]
  %r = icmp eq i8 %v, 0
  ret i1 %r
F:
  br label %T
}

define i1 @phi_uge_non_zero(i8 %x) {
; CHECK-LABEL: @phi_uge_non_zero(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp uge i8 [[X:%.*]], 32
; CHECK-NEXT:    br i1 [[CMP]], label [[T:%.*]], label [[F:%.*]]
; CHECK:       T:
; CHECK-NEXT:    ret i1 false
; CHECK:       F:
; CHECK-NEXT:    br label [[T]]
;
entry:
  %cmp = icmp uge i8 %x, 32
  br i1 %cmp, label %T, label %F
T:
  %v = phi i8 [ %x, %entry], [-1, %F]
  %r = icmp eq i8 %v, 0
  ret i1 %r
F:
  br label %T
}

define i1 @phi_ugt_non_zero_fail(i8 %x) {
; CHECK-LABEL: @phi_ugt_non_zero_fail(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp ugt i8 [[X:%.*]], 32
; CHECK-NEXT:    br i1 [[CMP]], label [[T:%.*]], label [[F:%.*]]
; CHECK:       T:
; CHECK-NEXT:    [[V:%.*]] = phi i8 [ [[X]], [[ENTRY:%.*]] ], [ 0, [[F]] ]
; CHECK-NEXT:    [[R:%.*]] = icmp eq i8 [[V]], 0
; CHECK-NEXT:    ret i1 [[R]]
; CHECK:       F:
; CHECK-NEXT:    br label [[T]]
;
entry:
  %cmp = icmp ugt i8 %x, 32
  br i1 %cmp, label %T, label %F
T:
  %v = phi i8 [ %x, %entry], [0, %F]
  %r = icmp eq i8 %v, 0
  ret i1 %r
F:
  br label %T
}

define i1 @phi_ult_non_zero(i8 %x) {
; CHECK-LABEL: @phi_ult_non_zero(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i8 [[X:%.*]], 123
; CHECK-NEXT:    br i1 [[CMP]], label [[T:%.*]], label [[F:%.*]]
; CHECK:       T:
; CHECK-NEXT:    br label [[F]]
; CHECK:       F:
; CHECK-NEXT:    ret i1 false
;
entry:
  %cmp = icmp ult i8 %x, 123
  br i1 %cmp, label %T, label %F
T:
  br label %F
F:
  %v = phi i8 [ %x, %entry], [-1, %T]
  %r = icmp eq i8 %v, 0
  ret i1 %r
}

define i1 @phi_ule_non_zero(i8 %x) {
; CHECK-LABEL: @phi_ule_non_zero(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp ule i8 [[X:%.*]], 123
; CHECK-NEXT:    br i1 [[CMP]], label [[T:%.*]], label [[F:%.*]]
; CHECK:       T:
; CHECK-NEXT:    br label [[F]]
; CHECK:       F:
; CHECK-NEXT:    ret i1 false
;
entry:
  %cmp = icmp ule i8 %x, 123
  br i1 %cmp, label %T, label %F
T:
  br label %F
F:
  %v = phi i8 [ %x, %entry], [-1, %T]
  %r = icmp eq i8 %v, 0
  ret i1 %r
}

define i1 @phi_ule_non_zero_fail_wrong_succ(i8 %x) {
; CHECK-LABEL: @phi_ule_non_zero_fail_wrong_succ(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp ule i8 [[X:%.*]], 123
; CHECK-NEXT:    br i1 [[CMP]], label [[T:%.*]], label [[F:%.*]]
; CHECK:       T:
; CHECK-NEXT:    [[V:%.*]] = phi i8 [ [[X]], [[ENTRY:%.*]] ], [ -1, [[F]] ]
; CHECK-NEXT:    [[R:%.*]] = icmp eq i8 [[V]], 0
; CHECK-NEXT:    ret i1 [[R]]
; CHECK:       F:
; CHECK-NEXT:    br label [[T]]
;
entry:
  %cmp = icmp ule i8 %x, 123
  br i1 %cmp, label %T, label %F
T:
  %v = phi i8 [ %x, %entry], [-1, %F]
  %r = icmp eq i8 %v, 0
  ret i1 %r
F:
  br label %T
}

define i1 @phi_ult_non_zero_fail(i8 %x) {
; CHECK-LABEL: @phi_ult_non_zero_fail(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i8 [[X:%.*]], 123
; CHECK-NEXT:    [[X2:%.*]] = add i8 [[X]], [[X]]
; CHECK-NEXT:    br i1 [[CMP]], label [[T:%.*]], label [[F:%.*]]
; CHECK:       T:
; CHECK-NEXT:    br label [[F]]
; CHECK:       F:
; CHECK-NEXT:    [[V:%.*]] = phi i8 [ [[X2]], [[ENTRY:%.*]] ], [ -1, [[T]] ]
; CHECK-NEXT:    [[R:%.*]] = icmp eq i8 [[V]], 0
; CHECK-NEXT:    ret i1 [[R]]
;
entry:
  %cmp = icmp ult i8 %x, 123
  %x2 = add i8 %x, %x
  br i1 %cmp, label %T, label %F
T:
  br label %F
F:
  %v = phi i8 [ %x2, %entry], [-1, %T]
  %r = icmp eq i8 %v, 0
  ret i1 %r
}

define i1 @phi_ne_non_zero(i8 %x) {
; CHECK-LABEL: @phi_ne_non_zero(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp ne i8 [[X:%.*]], 0
; CHECK-NEXT:    br i1 [[CMP]], label [[T:%.*]], label [[F:%.*]]
; CHECK:       T:
; CHECK-NEXT:    ret i1 false
; CHECK:       F:
; CHECK-NEXT:    br label [[T]]
;
entry:
  %cmp = icmp ne i8 %x, 0
  br i1 %cmp, label %T, label %F
T:
  %v = phi i8 [ %x, %entry], [-1, %F]
  %r = icmp eq i8 %v, 0
  ret i1 %r
F:
  br label %T
}

define i1 @phi_eq_non_zero(i8 %x) {
; CHECK-LABEL: @phi_eq_non_zero(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i8 [[X:%.*]], 44
; CHECK-NEXT:    br i1 [[CMP]], label [[T:%.*]], label [[F:%.*]]
; CHECK:       T:
; CHECK-NEXT:    ret i1 false
; CHECK:       F:
; CHECK-NEXT:    br label [[T]]
;
entry:
  %cmp = icmp eq i8 %x, 44
  br i1 %cmp, label %T, label %F
T:
  %v = phi i8 [ %x, %entry], [-1, %F]
  %r = icmp eq i8 %v, 0
  ret i1 %r
F:
  br label %T
}

define i1 @phi_eq_non_zero2(i8 %x) {
; CHECK-LABEL: @phi_eq_non_zero2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i8 [[X:%.*]], 0
; CHECK-NEXT:    br i1 [[CMP]], label [[T:%.*]], label [[F:%.*]]
; CHECK:       T:
; CHECK-NEXT:    br label [[F]]
; CHECK:       F:
; CHECK-NEXT:    ret i1 false
;
entry:
  %cmp = icmp eq i8 %x, 0
  br i1 %cmp, label %T, label %F
T:
  br label %F
F:
  %v = phi i8 [ %x, %entry], [-1, %T]
  %r = icmp eq i8 %v, 0
  ret i1 %r
}

define i1 @phi_sgt_non_zero(i8 %x) {
; CHECK-LABEL: @phi_sgt_non_zero(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp sgt i8 [[X:%.*]], 1
; CHECK-NEXT:    br i1 [[CMP]], label [[T:%.*]], label [[F:%.*]]
; CHECK:       T:
; CHECK-NEXT:    ret i1 false
; CHECK:       F:
; CHECK-NEXT:    br label [[T]]
;
entry:
  %cmp = icmp sgt i8 %x, 1
  br i1 %cmp, label %T, label %F
T:
  %v = phi i8 [ %x, %entry], [-1, %F]
  %r = icmp eq i8 %v, 0
  ret i1 %r
F:
  br label %T
}

define i1 @phi_sgt_non_zero_fail(i8 %x) {
; CHECK-LABEL: @phi_sgt_non_zero_fail(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp sgt i8 [[X:%.*]], -1
; CHECK-NEXT:    br i1 [[CMP]], label [[T:%.*]], label [[F:%.*]]
; CHECK:       T:
; CHECK-NEXT:    [[V:%.*]] = phi i8 [ [[X]], [[ENTRY:%.*]] ], [ -1, [[F]] ]
; CHECK-NEXT:    [[R:%.*]] = icmp eq i8 [[V]], 0
; CHECK-NEXT:    ret i1 [[R]]
; CHECK:       F:
; CHECK-NEXT:    br label [[T]]
;
entry:
  %cmp = icmp sgt i8 %x, -1
  br i1 %cmp, label %T, label %F
T:
  %v = phi i8 [ %x, %entry], [-1, %F]
  %r = icmp eq i8 %v, 0
  ret i1 %r
F:
  br label %T
}
